### THIS FILE IS AUTOGENERATED. DO NOT EDIT THIS FILE DIRECTLY ###
import minknow_api
from minknow_api.v2.protocols_pb2_grpc import *
import minknow_api.v2.protocols_pb2 as protocols_pb2
from minknow_api.v2.protocols_pb2 import *
from minknow_api._support import MessageWrapper, ArgumentError
import time
import logging
import sys

__all__ = [
    "ProtocolsService",
    "BeginProtocolsRequest",
    "BeginProtocolsResponse",
    "StartProtocolsRequest",
    "StartProtocolsResponse",
    "StopProtocolsRequest",
    "StopProtocolsResponse",
]

def run_with_retry(method, message, timeout, unwraps, full_name):
    retry_count = 20
    error = None
    for i in range(retry_count):
        try:
            result = MessageWrapper(method(message, timeout=timeout), unwraps=unwraps)
            return result
        except grpc.RpcError as e:
            # Retrying unidentified grpc errors to keep clients from crashing
            retryable_error = (e.code() == grpc.StatusCode.UNKNOWN and "Stream removed" in e.details() or \
                                (e.code() == grpc.StatusCode.INTERNAL and "RST_STREAM" in e.details()))
            if retryable_error:
                logging.info('Bypassed ({}: {}) error for grpc: {}. Attempt {}.'.format(e.code(), e.details(), full_name, i))
            else:
                raise
            error = e
        time.sleep(1)
    raise error


class ProtocolsService(object):
    def __init__(self, channel):
        self._stub = ProtocolsServiceStub(channel)
        self._pb = protocols_pb2
    def begin_protocols(self, _message=None, _timeout=None, **kwargs):
        """Run a protocol on the connected flow cell.

        The protocol must be described by a TOML file. The request identifies the
        protocol and supplies overrides to the default protocol-settings described
        in the TOML file, in addition it provides user-info for the experiment.

        This will return an error if one or more of the sub-requests' flow cell identification information is invalid.
        Otherwise, will return OK, even if any of the sub-requests fail.

        If a sub-request fails, this will be indicated by the individual response's 'status' field being set.

        

        Args:
            _message (minknow_api.v2.protocols_pb2.BeginProtocolsRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.
            requests (minknow_api.v2.protocols_pb2.BeginProtocolsRequest.IndividualRequest, optional): 

        Returns:
            minknow_api.v2.protocols_pb2.BeginProtocolsResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.begin_protocols,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.v2.protocol.ProtocolsService")

        unused_args = set(kwargs.keys())

        _message = minknow_api.protocol_pb2.BeginProtocolsRequest()

        if "requests" in kwargs:
            unused_args.remove("requests")
            _message.requests.extend(kwargs['requests'])

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to begin_protocols: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.begin_protocols,
                              _message, _timeout,
                              [],
                              "minknow_api.v2.protocol.ProtocolsService")
    def start_protocols(self, _message=None, _timeout=None, **kwargs):
        """Initiates a python instance that runs the script specified by the `path` argument.
        `list_protocols` will give back a list of protocol scripts that can be started by this call

        This will return an error if one or more of the sub-requests' flow cell identification information is invalid.
        Otherwise, will return OK, even if any of the sub-requests fail.

        If a sub-request fails, this will be indicated by the individual response's 'status' field being set.

        

        Args:
            _message (minknow_api.v2.protocols_pb2.StartProtocolsRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.
            requests (minknow_api.v2.protocols_pb2.StartProtocolsRequest.IndividualRequest, optional): 

        Returns:
            minknow_api.v2.protocols_pb2.StartProtocolsResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.start_protocols,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.v2.protocol.ProtocolsService")

        unused_args = set(kwargs.keys())

        _message = minknow_api.protocol_pb2.StartProtocolsRequest()

        if "requests" in kwargs:
            unused_args.remove("requests")
            _message.requests.extend(kwargs['requests'])

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to start_protocols: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.start_protocols,
                              _message, _timeout,
                              [],
                              "minknow_api.v2.protocol.ProtocolsService")
    def stop_protocols(self, _message=None, _timeout=None, **kwargs):
        """Stops the named protocols.

        This will return an error if one or more of the sub-requests' run IDs does not correspond to a currently running experiment.
        Otherwise, will return OK, even if any of the sub-requests fail.

        If a sub-request fails, this will be indicated by the individual response's 'status' field being set.

        

        Args:
            _message (minknow_api.v2.protocols_pb2.StopProtocolsRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.
            requests (minknow_api.protocol_pb2.StopProtocolRequest, optional): 

        Returns:
            minknow_api.v2.protocols_pb2.StopProtocolsResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.stop_protocols,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.v2.protocol.ProtocolsService")

        unused_args = set(kwargs.keys())

        _message = minknow_api.protocol_pb2.StopProtocolsRequest()

        if "requests" in kwargs:
            unused_args.remove("requests")
            _message.requests.extend(kwargs['requests'])

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to stop_protocols: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.stop_protocols,
                              _message, _timeout,
                              [],
                              "minknow_api.v2.protocol.ProtocolsService")
    def get_run_info(self, _message=None, _timeout=None, **kwargs):
        """Gets information about a protocol run.

        If no run ID is provided, information about the most recently started protocol run is
        provided.

        Since 6.5

        This RPC has no side effects. Calling it will have no effect on the state of the
        system. It is safe to call repeatedly, or to retry on failure, although there is no
        guarantee it will return the same information each time.

        Args:
            _message (minknow_api.protocol_pb2.GetRunInfoRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.
            run_id (str, optional): The protocol run to get information about.

        Returns:
            minknow_api.protocol_pb2.ProtocolRunInfo

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.get_run_info,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.v2.protocol.ProtocolsService")

        unused_args = set(kwargs.keys())

        _message = minknow_api.protocol_pb2.GetRunInfoRequest()

        if "run_id" in kwargs:
            unused_args.remove("run_id")
            _message.run_id = kwargs['run_id']

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to get_run_info: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.get_run_info,
                              _message, _timeout,
                              [],
                              "minknow_api.v2.protocol.ProtocolsService")
    def list_protocol_runs(self, _message=None, _timeout=None, **kwargs):
        """List previously started protocol run ids (including any current protocol), in order of starting.

        The returned object can be used to find protocol information with get_run_info.

        Since 6.5

        This RPC has no side effects. Calling it will have no effect on the state of the
        system. It is safe to call repeatedly, or to retry on failure, although there is no
        guarantee it will return the same information each time.

        Args:
            _message (minknow_api.protocol_pb2.ListProtocolRunsRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.
            filter_info (minknow_api.protocol_pb2.FilteringInfo, optional): 

        Returns:
            minknow_api.protocol_pb2.ListProtocolRunsResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.list_protocol_runs,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.v2.protocol.ProtocolsService")

        unused_args = set(kwargs.keys())

        _message = minknow_api.protocol_pb2.ListProtocolRunsRequest()

        if "filter_info" in kwargs:
            unused_args.remove("filter_info")
            _message.filter_info.CopyFrom(kwargs['filter_info'])

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to list_protocol_runs: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.list_protocol_runs,
                              _message, _timeout,
                              [],
                              "minknow_api.v2.protocol.ProtocolsService")
    def clear_protocols_history_data(self, _message=None, _timeout=None, **kwargs):
        """Sends out a 'clear history data' request to all flow cells.

        History data includes protocol protocol info, acquisition info and statistics.

        Also clears any persistence data that has been written to disk for those protocols which meet the criteria -- this
        data will not be available after a restart.

        Does NOT clear experiment results (fast5, fastq, sequencing_summary, etc)

        Since 6.5

        

        Args:
            _message (minknow_api.protocol_pb2.ClearProtocolHistoryDataRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.
            protocol_ids (str, optional): 

        Returns:
            minknow_api.protocol_pb2.ClearProtocolHistoryDataResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.clear_protocols_history_data,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.v2.protocol.ProtocolsService")

        unused_args = set(kwargs.keys())

        _message = minknow_api.protocol_pb2.ClearProtocolHistoryDataRequest()

        if "protocol_ids" in kwargs:
            unused_args.remove("protocol_ids")
            _message.protocol_ids.extend(kwargs['protocol_ids'])

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to clear_protocols_history_data: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.clear_protocols_history_data,
                              _message, _timeout,
                              [],
                              "minknow_api.v2.protocol.ProtocolsService")
    def generate_run_report(self, _message=None, _timeout=None, **kwargs):
        """Generate a run report and return the report data.

        If the protocol selected for report generation is already complete the report is a completed report, otherwise
        the report will be from the in progress protocol.

        Since 6.5

        

        Args:
            _message (minknow_api.protocol_pb2.GenerateRunReportRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.
                Note that this is the time until the call ends, not the time between returned
                messages.
            protocol_run_id (str, optional): The protocol_run_id to generate a report for.
            include_input_data (bool, optional): Optionally return the input data used to generate the report. This input data is
                represented as the data seen in report_data.proto

        Returns:
            iter of minknow_api.protocol_pb2.GenerateRunReportResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.generate_run_report,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.v2.protocol.ProtocolsService")

        unused_args = set(kwargs.keys())

        _message = minknow_api.protocol_pb2.GenerateRunReportRequest()

        if "protocol_run_id" in kwargs:
            unused_args.remove("protocol_run_id")
            _message.protocol_run_id = kwargs['protocol_run_id']

        if "include_input_data" in kwargs:
            unused_args.remove("include_input_data")
            _message.include_input_data = kwargs['include_input_data']

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to generate_run_report: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.generate_run_report,
                              _message, _timeout,
                              [],
                              "minknow_api.v2.protocol.ProtocolsService")
    def get_acquisition_info(self, _message=None, _timeout=None, **kwargs):
        """Gets information about a acquisition run.

        If no run ID is provided, information about the most recently started acquisition run is
        provided.

        Since 6.5

        This RPC has no side effects. Calling it will have no effect on the state of the
        system. It is safe to call repeatedly, or to retry on failure, although there is no
        guarantee it will return the same information each time.

        Args:
            _message (minknow_api.acquisition_pb2.GetAcquisitionRunInfoRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.
            run_id (str, optional): The acquisition period to get information about.

        Returns:
            minknow_api.acquisition_pb2.AcquisitionRunInfo

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.get_acquisition_info,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.v2.protocol.ProtocolsService")

        unused_args = set(kwargs.keys())

        _message = minknow_api.acquisition_pb2.GetAcquisitionRunInfoRequest()

        if "run_id" in kwargs:
            unused_args.remove("run_id")
            _message.run_id = kwargs['run_id']

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to get_acquisition_info: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.get_acquisition_info,
                              _message, _timeout,
                              [],
                              "minknow_api.v2.protocol.ProtocolsService")
