# `pj`


<!-- WARNING: THIS FILE WAS AUTOGENERATED! DO NOT EDIT! -->

[![PyPI](https://img.shields.io/pypi/v/pj-sh.svg)](https://pypi.org/project/pj-sh/)
<!-- [![PyPI - Downloads](https://img.shields.io/pypi/dm/pj-sh.svg)](https://pypi.org/project/pj-sh/) -->

`pj`, the **p**ro**j**ect shell, has four commands:  
`pj init` creates the entire nbdev project infrastructure and pushes to
GitHub,  
`pj sync` runs nbdev_prepare then commits and pushes,  
`pj ship` bumps up GitHub version and releases to PyPI.org, `pj kill`
stops background processes.  
That’s it.

## Install

Install from [PyPI](https://pypi.org/project/pj/), ideally with
[`uv`](https://docs.astral.sh/uv/):

``` sh
$ uv tool install pj-sh
```

or latest from the GitHub [repository](https://github.com/kitled/pj):

``` sh
$ uv tool install git+https://github.com/kitled/pj.git
```

## Usage

``` sh
pj init my-project  # start
pj sync             # work
pj kill             # end
```

Create complete nbdev project with `pj init`: GitHub repository, virtual
environment, registered Jupyter kernel, direnv activation, dark theme
toggle, initial commit pushed.

Subsequent `pj sync` runs the full export-test-clean-add-commit-push
workflow in one invocation.

Find all options with `--help` after any command.

``` sh
pj --help
pj init --help
```

### `init`

> Create new project

Start with `pj init proj_name` to create a GitHub repo, setup `nbdev`
fully, and push ready to code.

``` sh
pj init my-project -v \
 --desc "ML utilities" \
 --public \
 --python 3.12 \
 --license apache2
```

Everything is logged to `init.log` by default; use `-v` flag to see
stdin/out.

### [`sync`](https://kitled.github.io/pj/sync.html#sync)

> Automated `nbdev_prepare`, `git commit` and `push`.

Use `pj sync` to update remote;  
flag `-m "commit message"` (default: “save”).

``` sh
pj sync -m "Add new feature"
```

### `kill`

> Stop all servers

`pj kill` will terminate all running Jupyter, nbdev, Quarto processes on
the host.

## Why `pj`?

### Purpose

Create a fully-configured GitHub + nbdev project with one command.  
No manual setup, no forgotten steps. From zero to ready-to-code.

1.  Checks - Validate prerequisites
2.  Setup - Create repo, nbdev structure, venv, kernel, direnv
3.  Sync - Prepare nbdev, commit, push

### Features

- Clean output: One line per operation
- Verbose mode: Show commands and boxed output with `-v`
- Fail fast: Stop on first error
- Sensible defaults: Private repos, log to `init.log`, push immediately

## Devs

If you are new to using `nbdev` here are some useful pointers to get you
started.

### Install pj in Development mode

``` sh
# make sure pj package is installed in development mode
uv pip install -e .

# make changes under nbs/ directory
# ...

# compile to have changes apply to pj
nbdev_prepare
```

## Documentation

Documentation can be found hosted on this GitHub
[repository](https://github.com/kitled/pj)’s
[pages](https://kitled.github.io/pj/).  
Additionally you can find package manager specific guidelines on
[pypi](https://pypi.org/project/pj/).

See also [`uv`](https://docs.astral.sh/uv/) docs if needed.
