"""Phase 1: Prerequisites Validation"""

# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/01_checks.ipynb.

# %% auto 0
__all__ = ['check_prereqs']

# %% ../nbs/01_checks.ipynb 3
import sys
import subprocess
from .core import check_cmd, run_cmd, get_git_config, hr

# %% ../nbs/01_checks.ipynb 5
def check_prereqs():
    """
    Validate all prerequisites and gather system info.
    Returns dict with user info or exits on failure.
    """
    print(hr * 60)
    print("PHASE 1: CHECKS")
    
    # Check required tools
    checks = [
        ("gh", "sudo apt install gh  # See https://github.com/cli/cli/blob/trunk/docs/install_linux.md"),
        ("uv", "curl -LsSf https://astral.sh/uv/install.sh | sh"),
        ("direnv", "sudo apt install direnv  # Then add: eval \"$(direnv hook bash)\" to ~/.bashrc"),
        ("nbdev_new", "uv tool install nbdev  # or: pipx install nbdev"),
        ("git", "sudo apt install git"),
    ]
    
    all_ok = True
    for cmd, hint in checks:
        if not check_cmd(cmd, hint): all_ok = False
    
    if not all_ok: sys.exit(1)
    
    # Check GitHub auth
    try:
        result = subprocess.run(["gh", "auth", "status"], capture_output=True, text=True)
        if result.returncode != 0:
            print("❌ Error: GitHub CLI is not authenticated")
            print("   Run: gh auth login")
            sys.exit(1)
    except Exception:
        print("❌ Error: Cannot verify GitHub authentication")
        sys.exit(1)
    
    print("✅ All prerequisites satisfied")
    
    # Gather user info
    git_user = get_git_config("user.name") or "Your Name"
    git_email = get_git_config("user.email") or "you@example.com"
    
    # Get GitHub username
    gh_user_result = subprocess.run(["gh", "api", "user", "--jq", ".login"], capture_output=True, text=True, check=False)
    gh_username = gh_user_result.stdout.strip() if gh_user_result.returncode == 0 else "username"
    
    return {
        'git_user': git_user,
        'git_email': git_email,
        'gh_username': gh_username
    }
