ARROWS_HIDE=1

SHORT_DESCRIPTION="pybirdsreynolds is an interactive simulation of the Reynolds Boids model."
WIDTH_CONTROLS_DEFAULT=70
WIDTH_CONTROLS=70
WIDTH_PARAMS_DEFAULT=300
WIDTH_PARAMS=300

NUM_BIRDS_HIDEN=0
NUM_BIRDS_DOC="Number of birds"
NUM_BIRDS_DEFAULT=400
NUM_BIRDS=400
NUM_BIRDS_MIN=1
NUM_BIRDS_MAX=1000
NUM_BIRDS_FREE_MIN=1
NUM_BIRDS_FREE_MAX=None

COH_WEIGHT_HIDEN=0
COH_WEIGHT_DOC="Cohesion weight"
COH_WEIGHT_DEFAULT=1
COH_WEIGHT=1
COH_WEIGHT_MIN=0
COH_WEIGHT_MAX=10
COH_WEIGHT_FREE_MIN=None
COH_WEIGHT_FREE_MAX=None

ALIGN_WEIGHT_HIDEN=0
ALIGN_WEIGHT_DOC="Alignment weight"
ALIGN_WEIGHT_DEFAULT=2
ALIGN_WEIGHT=2
ALIGN_WEIGHT_MIN=0
ALIGN_WEIGHT_MAX=10
ALIGN_WEIGHT_FREE_MIN=None
ALIGN_WEIGHT_FREE_MAX=None

SEP_WEIGHT_HIDEN=0
SEP_WEIGHT_DOC="Separation weight"
SEP_WEIGHT_DEFAULT=3
SEP_WEIGHT=3
SEP_WEIGHT_MIN=0
SEP_WEIGHT_MAX=10
SEP_WEIGHT_FREE_MIN=None
SEP_WEIGHT_FREE_MAX=None

NEIGHBOR_RADIUS_HIDEN=0
NEIGHBOR_RADIUS_DOC="Distance to detect neighbors"
NEIGHBOR_RADIUS_DEFAULT=50
NEIGHBOR_RADIUS=50
NEIGHBOR_RADIUS_MIN=0
NEIGHBOR_RADIUS_MAX=None
NEIGHBOR_RADIUS_FREE_MIN=0
NEIGHBOR_RADIUS_FREE_MAX=None

WIDTH_HIDEN=0
WIDTH_DOC="Area width"
WIDTH_DEFAULT=1000
WIDTH=1000
WIDTH_MIN=200
WIDTH_MAX=None
WIDTH_FREE_MIN=200
WIDTH_FREE_MAX=None

HEIGHT_HIDEN=0
HEIGHT_DOC="Area height"
HEIGHT_DEFAULT=500
HEIGHT=500
HEIGHT_MIN=500
HEIGHT_MAX=None
HEIGHT_FREE_MIN=500
HEIGHT_FREE_MAX=None
#TODO BUGFIX
HEIGHT_PARAMS_CONTROLS_DEFAULT=500
HEIGHT_PARAMS_CONTROLS=450

MAX_SPEED_HIDEN=0
MAX_SPEED_DOC="Maximum speed of birds"
MAX_SPEED_DEFAULT=10
MAX_SPEED=10
MAX_SPEED_MIN=0
MAX_SPEED_MAX=100
MAX_SPEED_FREE_MIN=0
MAX_SPEED_FREE_MAX=100

RANDOM_SPEED_HIDEN=0
RANDOM_SPEED_DOC="Random speed variation ratio in percentage"
RANDOM_SPEED_DEFAULT=0
RANDOM_SPEED=0
RANDOM_SPEED_MIN=0
RANDOM_SPEED_MAX=10
RANDOM_SPEED_FREE_MIN=0
RANDOM_SPEED_FREE_MAX=None

RANDOM_ANGLE_HIDEN=0
RANDOM_ANGLE_DOC="Random angle variation in degrees"
RANDOM_ANGLE_DEFAULT=0
RANDOM_ANGLE=0
RANDOM_ANGLE_MIN=0
RANDOM_ANGLE_MAX=10
RANDOM_ANGLE_FREE_MIN=None
RANDOM_ANGLE_FREE_MAX=None

REFRESH_MS_HIDEN=0
REFRESH_MS_DOC="Refresh interval in milliseconds"
REFRESH_MS_DEFAULT=10
REFRESH_MS=10
REFRESH_MS_MIN=1
REFRESH_MS_MAX=100
REFRESH_MS_FREE_MIN=1
REFRESH_MS_FREE_MAX=None

SIZE_HIDEN=1
SIZE_DOC="Visual size of birds"
SIZE_DEFAULT=2
SIZE=2
SIZE_MIN=1
SIZE_MAX=3
SIZE_FREE_MIN=1
SIZE_FREE_MAX=None

TRIANGLES_HIDEN=2
TRIANGLES_DOC="Render birds as triangles instead of points"
TRIANGLES_DEFAULT=False
TRIANGLES=False

COLOR_HIDEN=1
COLOR_DOC="Enable colors"
COLOR_DEFAULT=False
COLOR=False

FONT_TYPE_HIDEN=2
FONT_TYPE_DEFAULT="Nota Sans Mono"
FONT_TYPE="Nota Sans Mono"
FONT_TYPE_DOC="Font"
FONT_TYPE_LIST=["Nota Sans Mono", "Consolas", "Courier"]

FONT_SIZE_HIDEN=2
FONT_SIZE_DOC="Font Size"
FONT_SIZE_DEFAULT=12
FONT_SIZE=12
FONT_SIZE_MIN=6
FONT_SIZE_MAX=12
FONT_SIZE_FREE_MIN=6
FONT_SIZE_FREE_MAX=12

FREE_HIDEN=0
FREE_DOC="Remove parameter limits"
FREE_DEFAULT=False
FREE=False

TOOGLE_START_PAUSE_HIDEN=0
TOOGLE_START_PAUSE_ICON="⏯"
TOOGLE_START_PAUSE_TEXT="Toggle start / stop"
TOOGLE_START_PAUSE_COMMAND='p'

RESET_HIDEN=0
RESET_ICON="⟳"
RESET_TEXT="Reset all params"
RESET_COMMAND='r'

REGENERATION_HIDEN=0
REGENERATION_ICON="🪶"
REGENERATION_COMMAND='b'
REGENERATION_TEXT="New generation of birds"

TOOGLE_FPS_HIDEN=0
TOOGLE_FPS_ICON="⏱"
TOOGLE_FPS_TEXT="Toggle FPS display"
TOOGLE_FPS_COMMAND='f'

NEXT_FRAME_HIDEN=0
NEXT_FRAME_ICON = "⏭"
NEXT_FRAME_TEXT="Next frame"
NEXT_FRAME_COMMAND='n'

TOOGLE_MAXIMIZE_HIDEN=0
TOOGLE_MAXIMIZE_ICON = "🗖"
TOOGLE_MAXIMIZE_TEXT="Maximize/Minimize"
TOOGLE_MAXIMIZE_COMMAND='m'

HIDE_HIDEN=0
HIDE_ICON="👁"
HIDE_TEXT="Hide Params and Controls"
HIDE_COMMAND='h'

SHIFT_HIDEN=1
SHIFT_ICON="⇧"
SHIFT_TEXT="With ⬅️/➡️ → Adjust param by ±10 instead of ±1"
SHIFT_COMMAND='<SHIFT>'

DOC_HIDEN=0
DOC_ICON="?"
DOC_TEXT="Open/Close the documentation"
DOC_COMMAND='d'

UP_HIDEN=ARROWS_HIDE
UP_ICON="⬆️"
UP_TEXT="Navigate params"
UP_COMMAND='<UP>'

DOWN_HIDEN=ARROWS_HIDE
DOWN_ICON="⬇️"
DOWN_TEXT="Navigate params"
DOWN_COMMAND='<DOWN>'

LEFT_HIDEN=ARROWS_HIDE
LEFT_ICON="⬅️"
LEFT_TEXT="Adjust param (-1)"
LEFT_COMMAND='<LEFT>'

RIGHT_HIDEN=ARROWS_HIDE
RIGHT_ICON="➡️"
RIGHT_TEXT="Adjust param (+1)"
RIGHT_COMMAND='<RIGHT>'

PAUSED = True
BLINK_STATE = True
FPS = False
HIDDEN=False
MARGIN=1

CANVAS_BG = None
FILL_COLOR = None
OUTLINE_COLOR = None