# Garden Map

Our garden map is where you can learn about what features we're working on, what stage they're in, and when we expect to bring them to you.
The content here follows that of a [technical roadmap](https://en.wikipedia.org/wiki/Technology_roadmap) (providing strategic visibility on implementation details and timelines).

## Ethos

We intend for the garden map to provide useful tools for us to efficiently create and maintain the Software Gardening Almanack.
We practice keeping the garden map as "petal-light" as possible through built-in tools, automation, and an avoidance of [analysis paralysis](https://en.wikipedia.org/wiki/Analysis_paralysis) where possible.

## We'd love your input

We welcome your input on the garden map and elements found within it!
Please see the [contributing](contributing.md) guide for more information on how to participate in this process.

## Active garden map(s)

The following are active garden maps for the Software Gardening Almanack.
Please see below for a further description of these projects.

<!-- vale alex.Gendered = NO -->

- [__2024 BSSw Fellowship Milestones__](https://github.com/orgs/software-gardening/projects/1): this project communicates activities associated with the 2024 [BSSw Fellowship](https://bssw.io/pages/bssw-fellowship-program) associated with the Software Gardening Almanack.

<!-- vale alex.Gendered = YES -->

## Sections

You can explore the garden map with different views:

- __"Canopy-view" development visibility__: We track new, existing, and previous work at a high-level using organization-wide [GitHub Projects](https://docs.github.com/en/issues/planning-and-tracking-with-projects/learning-about-projects/about-projects).
- __"Ground-level" development visibility__: We track repository-specific work using [GitHub issues](https://docs.github.com/en/issues/tracking-your-work-with-issues/about-issues) and a GitHub Project field called "status", which we associate with each issue (indicated as "Todo", "In progress", "Paused", or "Done").
- __Major milestones__: We track major milestones using common [GitHub issues labels](https://docs.github.com/en/issues/using-labels-and-milestones-to-track-work/managing-labels) across all repositories through their associated issues.

## Visualizations

It can be helpful to visualize the garden map using data plots or other images.
We use [GitHub Projects insights](https://docs.github.com/en/issues/planning-and-tracking-with-projects/viewing-insights-from-your-project/about-insights-for-projects) to assist with automated creation and updates to garden map activity.
Please see this [project insights page](https://github.com/orgs/software-gardening/projects/1/insights) for an example of these (using the insights button within any GitHub Projects for viewing others).

## Acknowledgments

We drew inspiration for this content from the [GitHub public roadmap](https://github.com/github/roadmap).
Big thanks to the original works found there.
