(garden-lattice-intro)=

# Garden Lattice

```{figure} ../assets/640px-Rundes_Fenster_mit_Gitter.jpeg
---
alt: Round window with lattice.
---
_The garden lattice facilitates growth on our software gardening journeys.  (Image source: {cite:alp}`image_gimmel_lattice`)._
```

> "To plant a garden is to believe in tomorrow."
> \- Audrey Hepburn

We enter the book through a garden lattice, both an acknowledgement and forward recognition of people who cultivate software.
The garden lattice is a celebration of our individual vibrancy and connection to the world around us.
"Here you will give your gifts and meet your responsibilities." {cite:p}`kimmerer_braiding_2013`
It also is a place to view our collective fates; as we grow an understanding emerges that we must commit ourselves toward a sustainable future through tending the garden.
This sustainability is undeniably coupled to our natural relationships, persisted even in the software realm.

Early roots from Ada Lovelace's work on an analytical engine algorithm in 1842 provide a glimpse of the natural world's influence on software development: "… the Analytical Engine weaves algebraical patterns just as the Jacquard-loom weaves flowers and leaves." {cite:p}`fuegi_lovelace_2003` <!-- codespell-ignore -->
Many years later, software development remains an effort of intertwining beauty and function to enhance well-being through a growing system, or lattice, of interconnected parts built upon layers of personal and technical advances.

Lattices, reminiscent of living structures built with willow or bamboo, emerge as a weaved foundation, both flexible and systematically resilient, protecting and inspiring new growth.
"The willow submits to the wind and prospers until one day it is many willows - a wall against the wind." {cite:p}`herbert_dune_2010`.
These lattices also signify our collective friendship and interdependence.
They echo the sentiment of "Be like bamboo. The higher you grow, the deeper you bow," (a Chinese proverb) embodying strength through flexibility and unity.
This concept mirrors the organic growth seen in software gardens, where a system of interweaved latticework supports the development of intricate and resilient structures.

The lattice also guards against both direct and indirect challenges we face on our journey as software gardeners.
These encumbrances can "overheat" our growth potential, leading us to early burnout or burn-down of gardens.
The lattice helps us as a carbon sequester, mitigating the excess heat caused by an imbalance in emissions, similar to bamboo garden forests {cite:p}`nath_managing_2015`.
Our individual experiences and personal network consume these difficulties to further grow the lattice through acts of harmonization (such as collaboration or apprenticeship).
We care for these experiences together on the lattice because "all flourishing is mutual." {cite:p}`kimmerer_braiding_2013`.

```{bibliography}
---
style: unsrt
filter: docname in docnames
labelprefix: GL
---
```
