(software-forest-intro)=

# Software Forest

```{figure} ../assets/640px-Forgard2-003.gif
---
alt: Forest garden diagram.
---
_The software forest is multi-layered like a forest garden. (Image source: {cite:alp}`image_burnett_forestgarden`)._
```

The software forest is a multidimensional garden, enriched by connections and minimal, iterative changes.
Both the practice and artifacts of software development can seem daunting, like an unfamiliar forest full of mystery and surprises.
However, through software gardening, we see these forests as opportunities for balanced cultivation.

> "Called Three-Dimensional Forestry or Forest Farming, … the three 'dimensions' of [Toyohiko Kagawa's] 3-D system were the trees as conservers of the soil and suppliers of food and the livestock which benefited from them." {cite:p}`hart_forest_1996`, {cite:p}`kagawa_fujisaki_3d_farming`

Forest gardening offers innovations from an ecological cultivation perspective by caring for trees, understory vegetation, soil, and other environmental factors.
Forest gardens take time to create because their slow-growing nature requires patience and careful, long-term nurturing.
Software forests are also created gradually, "… starting with the existing, living, breathing system, and working outward, a step at a time, in such a way as to not undermine the system’s viability." {cite:p}`foote1997big`
Nourishing the system in this way helps us practice _primum non nocere_ ("first, do no harm") to the garden and components within, conserving energy for necessary adaptations.

Dense networks of relationships surround software forest gardens in the form of software environments.
Some of these environments are portable, similar to [Wardian cases](https://en.wikipedia.org/wiki/Wardian_case) that provide loosely coupled habitats for software organisms (for example, through environment managers).
Others are exhibited through abstract relationships as [_nurse logs_](https://en.wikipedia.org/wiki/Nurse_log), [_Hügelkultur_](https://en.wikipedia.org/wiki/H%C3%BCgelkultur), or [mycorrhizal](https://en.wikipedia.org/wiki/Mycorrhiza)-like associations which redistribute energy among the entirety of a software region.

As software gardeners we must consider how energy is transferred to various portions of the forest.
Adventitious code, which "volunteers" by accident of growth, may create scenarios of energy waste in the form of cognitive or performance misalignment.
All waste in the forest is food {cite:p}`mcdonough1998waste`, therefore we must imagine and craft new homes for wasted energy through appropriate means.
This chaos of this soft-scaping (curating the software garden towards a goal) is in constant flux, tugging on our capacities as student and teacher of the garden to encourage growth and avoid harm.

"What gardens demand of us is lifelong learning." {cite:p}`stappmanns_garden_2023`
We discover and are discovered within the software garden.
As software forest gardens grow, they demonstrate emergent properties which are well suited for practices such as evolutionary architecture, object-orientated design, and coupling analysis.
These assist software gardeners as a shed of multi-dimensional concepts that must be employed to truly achieve effective multi-layered software garden maintenance.

```{bibliography}
---
style: unsrt
filter: docname in docnames
labelprefix: SF
---
```
