import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface FileConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/local/r/file.html#content File#content}.
     *
     * @stability stable
     */
    readonly content?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/local/r/file.html#content_base64 File#content_base64}.
     *
     * @stability stable
     */
    readonly contentBase64?: string;
    /**
     * Permissions to set for directories created.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/local/r/file.html#directory_permission File#directory_permission}
     *
     * @stability stable
     */
    readonly directoryPermission?: string;
    /**
     * Permissions to set for the output file.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/local/r/file.html#file_permission File#file_permission}
     *
     * @stability stable
     */
    readonly filePermission?: string;
    /**
     * Path to the output file.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/local/r/file.html#filename File#filename}
     *
     * @stability stable
     */
    readonly filename: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/local/r/file.html#sensitive_content File#sensitive_content}.
     *
     * @stability stable
     */
    readonly sensitiveContent?: string;
    /**
     * Path to file to use as source for content of output file.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/local/r/file.html#source File#source}
     *
     * @stability stable
     */
    readonly source?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/local/r/file.html local_file}.
 *
 * @stability stable
 */
export declare class File extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/local/r/file.html local_file} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: FileConfig);
    private _content?;
    /**
     * @stability stable
     */
    get content(): string;
    /**
     * @stability stable
     */
    set content(value: string);
    /**
     * @stability stable
     */
    resetContent(): void;
    /**
     * @stability stable
     */
    get contentInput(): string | undefined;
    private _contentBase64?;
    /**
     * @stability stable
     */
    get contentBase64(): string;
    /**
     * @stability stable
     */
    set contentBase64(value: string);
    /**
     * @stability stable
     */
    resetContentBase64(): void;
    /**
     * @stability stable
     */
    get contentBase64Input(): string | undefined;
    private _directoryPermission?;
    /**
     * @stability stable
     */
    get directoryPermission(): string;
    /**
     * @stability stable
     */
    set directoryPermission(value: string);
    /**
     * @stability stable
     */
    resetDirectoryPermission(): void;
    /**
     * @stability stable
     */
    get directoryPermissionInput(): string | undefined;
    private _filePermission?;
    /**
     * @stability stable
     */
    get filePermission(): string;
    /**
     * @stability stable
     */
    set filePermission(value: string);
    /**
     * @stability stable
     */
    resetFilePermission(): void;
    /**
     * @stability stable
     */
    get filePermissionInput(): string | undefined;
    private _filename?;
    /**
     * @stability stable
     */
    get filename(): string;
    /**
     * @stability stable
     */
    set filename(value: string);
    /**
     * @stability stable
     */
    get filenameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _sensitiveContent?;
    /**
     * @stability stable
     */
    get sensitiveContent(): string;
    /**
     * @stability stable
     */
    set sensitiveContent(value: string);
    /**
     * @stability stable
     */
    resetSensitiveContent(): void;
    /**
     * @stability stable
     */
    get sensitiveContentInput(): string | undefined;
    private _source?;
    /**
     * @stability stable
     */
    get source(): string;
    /**
     * @stability stable
     */
    set source(value: string);
    /**
     * @stability stable
     */
    resetSource(): void;
    /**
     * @stability stable
     */
    get sourceInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
