# `job` Submodule <a name="`job` Submodule" id="@cdktf/provider-databricks.job"></a>

## Constructs <a name="Constructs" id="Constructs"></a>

### Job <a name="Job" id="@cdktf/provider-databricks.job.Job"></a>

Represents a {@link https://www.terraform.io/docs/providers/databricks/r/job databricks_job}.

#### Initializers <a name="Initializers" id="@cdktf/provider-databricks.job.Job.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.Job;

Job.Builder.create(Construct scope, java.lang.String id)
//  .connection(SSHProvisionerConnection)
//  .connection(WinrmProvisionerConnection)
//  .count(java.lang.Number)
//  .dependsOn(java.util.List<ITerraformDependable>)
//  .forEach(ITerraformIterator)
//  .lifecycle(TerraformResourceLifecycle)
//  .provider(TerraformProvider)
//  .provisioners(java.util.List<FileProvisioner)
//  .provisioners(LocalExecProvisioner)
//  .provisioners(RemoteExecProvisioner>)
//  .alwaysRunning(java.lang.Boolean)
//  .alwaysRunning(IResolvable)
//  .continuous(JobContinuous)
//  .dbtTask(JobDbtTask)
//  .emailNotifications(JobEmailNotifications)
//  .existingClusterId(java.lang.String)
//  .format(java.lang.String)
//  .gitSource(JobGitSource)
//  .id(java.lang.String)
//  .jobCluster(IResolvable)
//  .jobCluster(java.util.List<JobJobCluster>)
//  .library(IResolvable)
//  .library(java.util.List<JobLibrary>)
//  .maxConcurrentRuns(java.lang.Number)
//  .maxRetries(java.lang.Number)
//  .minRetryIntervalMillis(java.lang.Number)
//  .name(java.lang.String)
//  .newCluster(JobNewCluster)
//  .notebookTask(JobNotebookTask)
//  .pipelineTask(JobPipelineTask)
//  .pythonWheelTask(JobPythonWheelTask)
//  .queue(JobQueue)
//  .retryOnTimeout(java.lang.Boolean)
//  .retryOnTimeout(IResolvable)
//  .schedule(JobSchedule)
//  .sparkJarTask(JobSparkJarTask)
//  .sparkPythonTask(JobSparkPythonTask)
//  .sparkSubmitTask(JobSparkSubmitTask)
//  .tags(java.util.Map<java.lang.String, java.lang.String>)
//  .task(IResolvable)
//  .task(java.util.List<JobTask>)
//  .timeouts(JobTimeouts)
//  .timeoutSeconds(java.lang.Number)
//  .trigger(JobTrigger)
//  .webhookNotifications(JobWebhookNotifications)
    .build();
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.Job.Initializer.parameter.scope">scope</a></code> | <code>software.constructs.Construct</code> | The scope in which to define this construct. |
| <code><a href="#@cdktf/provider-databricks.job.Job.Initializer.parameter.id">id</a></code> | <code>java.lang.String</code> | The scoped construct ID. |
| <code><a href="#@cdktf/provider-databricks.job.Job.Initializer.parameter.connection">connection</a></code> | <code>com.hashicorp.cdktf.SSHProvisionerConnection OR com.hashicorp.cdktf.WinrmProvisionerConnection</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.Initializer.parameter.count">count</a></code> | <code>java.lang.Number</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.Initializer.parameter.dependsOn">dependsOn</a></code> | <code>java.util.List<com.hashicorp.cdktf.ITerraformDependable></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.Initializer.parameter.forEach">forEach</a></code> | <code>com.hashicorp.cdktf.ITerraformIterator</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.Initializer.parameter.lifecycle">lifecycle</a></code> | <code>com.hashicorp.cdktf.TerraformResourceLifecycle</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.Initializer.parameter.provider">provider</a></code> | <code>com.hashicorp.cdktf.TerraformProvider</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.Initializer.parameter.provisioners">provisioners</a></code> | <code>java.util.List<com.hashicorp.cdktf.FileProvisioner OR com.hashicorp.cdktf.LocalExecProvisioner OR com.hashicorp.cdktf.RemoteExecProvisioner></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.Initializer.parameter.alwaysRunning">alwaysRunning</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#always_running Job#always_running}. |
| <code><a href="#@cdktf/provider-databricks.job.Job.Initializer.parameter.continuous">continuous</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobContinuous">JobContinuous</a></code> | continuous block. |
| <code><a href="#@cdktf/provider-databricks.job.Job.Initializer.parameter.dbtTask">dbtTask</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobDbtTask">JobDbtTask</a></code> | dbt_task block. |
| <code><a href="#@cdktf/provider-databricks.job.Job.Initializer.parameter.emailNotifications">emailNotifications</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobEmailNotifications">JobEmailNotifications</a></code> | email_notifications block. |
| <code><a href="#@cdktf/provider-databricks.job.Job.Initializer.parameter.existingClusterId">existingClusterId</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#existing_cluster_id Job#existing_cluster_id}. |
| <code><a href="#@cdktf/provider-databricks.job.Job.Initializer.parameter.format">format</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#format Job#format}. |
| <code><a href="#@cdktf/provider-databricks.job.Job.Initializer.parameter.gitSource">gitSource</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobGitSource">JobGitSource</a></code> | git_source block. |
| <code><a href="#@cdktf/provider-databricks.job.Job.Initializer.parameter.id">id</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#id Job#id}. |
| <code><a href="#@cdktf/provider-databricks.job.Job.Initializer.parameter.jobCluster">jobCluster</a></code> | <code>com.hashicorp.cdktf.IResolvable OR java.util.List<<a href="#@cdktf/provider-databricks.job.JobJobCluster">JobJobCluster</a>></code> | job_cluster block. |
| <code><a href="#@cdktf/provider-databricks.job.Job.Initializer.parameter.library">library</a></code> | <code>com.hashicorp.cdktf.IResolvable OR java.util.List<<a href="#@cdktf/provider-databricks.job.JobLibrary">JobLibrary</a>></code> | library block. |
| <code><a href="#@cdktf/provider-databricks.job.Job.Initializer.parameter.maxConcurrentRuns">maxConcurrentRuns</a></code> | <code>java.lang.Number</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#max_concurrent_runs Job#max_concurrent_runs}. |
| <code><a href="#@cdktf/provider-databricks.job.Job.Initializer.parameter.maxRetries">maxRetries</a></code> | <code>java.lang.Number</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#max_retries Job#max_retries}. |
| <code><a href="#@cdktf/provider-databricks.job.Job.Initializer.parameter.minRetryIntervalMillis">minRetryIntervalMillis</a></code> | <code>java.lang.Number</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#min_retry_interval_millis Job#min_retry_interval_millis}. |
| <code><a href="#@cdktf/provider-databricks.job.Job.Initializer.parameter.name">name</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#name Job#name}. |
| <code><a href="#@cdktf/provider-databricks.job.Job.Initializer.parameter.newCluster">newCluster</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobNewCluster">JobNewCluster</a></code> | new_cluster block. |
| <code><a href="#@cdktf/provider-databricks.job.Job.Initializer.parameter.notebookTask">notebookTask</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobNotebookTask">JobNotebookTask</a></code> | notebook_task block. |
| <code><a href="#@cdktf/provider-databricks.job.Job.Initializer.parameter.pipelineTask">pipelineTask</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobPipelineTask">JobPipelineTask</a></code> | pipeline_task block. |
| <code><a href="#@cdktf/provider-databricks.job.Job.Initializer.parameter.pythonWheelTask">pythonWheelTask</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobPythonWheelTask">JobPythonWheelTask</a></code> | python_wheel_task block. |
| <code><a href="#@cdktf/provider-databricks.job.Job.Initializer.parameter.queue">queue</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobQueue">JobQueue</a></code> | queue block. |
| <code><a href="#@cdktf/provider-databricks.job.Job.Initializer.parameter.retryOnTimeout">retryOnTimeout</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#retry_on_timeout Job#retry_on_timeout}. |
| <code><a href="#@cdktf/provider-databricks.job.Job.Initializer.parameter.schedule">schedule</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobSchedule">JobSchedule</a></code> | schedule block. |
| <code><a href="#@cdktf/provider-databricks.job.Job.Initializer.parameter.sparkJarTask">sparkJarTask</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobSparkJarTask">JobSparkJarTask</a></code> | spark_jar_task block. |
| <code><a href="#@cdktf/provider-databricks.job.Job.Initializer.parameter.sparkPythonTask">sparkPythonTask</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobSparkPythonTask">JobSparkPythonTask</a></code> | spark_python_task block. |
| <code><a href="#@cdktf/provider-databricks.job.Job.Initializer.parameter.sparkSubmitTask">sparkSubmitTask</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobSparkSubmitTask">JobSparkSubmitTask</a></code> | spark_submit_task block. |
| <code><a href="#@cdktf/provider-databricks.job.Job.Initializer.parameter.tags">tags</a></code> | <code>java.util.Map<java.lang.String, java.lang.String></code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#tags Job#tags}. |
| <code><a href="#@cdktf/provider-databricks.job.Job.Initializer.parameter.task">task</a></code> | <code>com.hashicorp.cdktf.IResolvable OR java.util.List<<a href="#@cdktf/provider-databricks.job.JobTask">JobTask</a>></code> | task block. |
| <code><a href="#@cdktf/provider-databricks.job.Job.Initializer.parameter.timeouts">timeouts</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobTimeouts">JobTimeouts</a></code> | timeouts block. |
| <code><a href="#@cdktf/provider-databricks.job.Job.Initializer.parameter.timeoutSeconds">timeoutSeconds</a></code> | <code>java.lang.Number</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#timeout_seconds Job#timeout_seconds}. |
| <code><a href="#@cdktf/provider-databricks.job.Job.Initializer.parameter.trigger">trigger</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobTrigger">JobTrigger</a></code> | trigger block. |
| <code><a href="#@cdktf/provider-databricks.job.Job.Initializer.parameter.webhookNotifications">webhookNotifications</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobWebhookNotifications">JobWebhookNotifications</a></code> | webhook_notifications block. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="@cdktf/provider-databricks.job.Job.Initializer.parameter.scope"></a>

- *Type:* software.constructs.Construct

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-databricks.job.Job.Initializer.parameter.id"></a>

- *Type:* java.lang.String

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `connection`<sup>Optional</sup> <a name="connection" id="@cdktf/provider-databricks.job.Job.Initializer.parameter.connection"></a>

- *Type:* com.hashicorp.cdktf.SSHProvisionerConnection OR com.hashicorp.cdktf.WinrmProvisionerConnection

---

##### `count`<sup>Optional</sup> <a name="count" id="@cdktf/provider-databricks.job.Job.Initializer.parameter.count"></a>

- *Type:* java.lang.Number

---

##### `dependsOn`<sup>Optional</sup> <a name="dependsOn" id="@cdktf/provider-databricks.job.Job.Initializer.parameter.dependsOn"></a>

- *Type:* java.util.List<com.hashicorp.cdktf.ITerraformDependable>

---

##### `forEach`<sup>Optional</sup> <a name="forEach" id="@cdktf/provider-databricks.job.Job.Initializer.parameter.forEach"></a>

- *Type:* com.hashicorp.cdktf.ITerraformIterator

---

##### `lifecycle`<sup>Optional</sup> <a name="lifecycle" id="@cdktf/provider-databricks.job.Job.Initializer.parameter.lifecycle"></a>

- *Type:* com.hashicorp.cdktf.TerraformResourceLifecycle

---

##### `provider`<sup>Optional</sup> <a name="provider" id="@cdktf/provider-databricks.job.Job.Initializer.parameter.provider"></a>

- *Type:* com.hashicorp.cdktf.TerraformProvider

---

##### `provisioners`<sup>Optional</sup> <a name="provisioners" id="@cdktf/provider-databricks.job.Job.Initializer.parameter.provisioners"></a>

- *Type:* java.util.List<com.hashicorp.cdktf.FileProvisioner OR com.hashicorp.cdktf.LocalExecProvisioner OR com.hashicorp.cdktf.RemoteExecProvisioner>

---

##### `alwaysRunning`<sup>Optional</sup> <a name="alwaysRunning" id="@cdktf/provider-databricks.job.Job.Initializer.parameter.alwaysRunning"></a>

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#always_running Job#always_running}.

---

##### `continuous`<sup>Optional</sup> <a name="continuous" id="@cdktf/provider-databricks.job.Job.Initializer.parameter.continuous"></a>

- *Type:* <a href="#@cdktf/provider-databricks.job.JobContinuous">JobContinuous</a>

continuous block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#continuous Job#continuous}

---

##### `dbtTask`<sup>Optional</sup> <a name="dbtTask" id="@cdktf/provider-databricks.job.Job.Initializer.parameter.dbtTask"></a>

- *Type:* <a href="#@cdktf/provider-databricks.job.JobDbtTask">JobDbtTask</a>

dbt_task block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#dbt_task Job#dbt_task}

---

##### `emailNotifications`<sup>Optional</sup> <a name="emailNotifications" id="@cdktf/provider-databricks.job.Job.Initializer.parameter.emailNotifications"></a>

- *Type:* <a href="#@cdktf/provider-databricks.job.JobEmailNotifications">JobEmailNotifications</a>

email_notifications block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#email_notifications Job#email_notifications}

---

##### `existingClusterId`<sup>Optional</sup> <a name="existingClusterId" id="@cdktf/provider-databricks.job.Job.Initializer.parameter.existingClusterId"></a>

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#existing_cluster_id Job#existing_cluster_id}.

---

##### `format`<sup>Optional</sup> <a name="format" id="@cdktf/provider-databricks.job.Job.Initializer.parameter.format"></a>

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#format Job#format}.

---

##### `gitSource`<sup>Optional</sup> <a name="gitSource" id="@cdktf/provider-databricks.job.Job.Initializer.parameter.gitSource"></a>

- *Type:* <a href="#@cdktf/provider-databricks.job.JobGitSource">JobGitSource</a>

git_source block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#git_source Job#git_source}

---

##### `id`<sup>Optional</sup> <a name="id" id="@cdktf/provider-databricks.job.Job.Initializer.parameter.id"></a>

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#id Job#id}.

Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.

---

##### `jobCluster`<sup>Optional</sup> <a name="jobCluster" id="@cdktf/provider-databricks.job.Job.Initializer.parameter.jobCluster"></a>

- *Type:* com.hashicorp.cdktf.IResolvable OR java.util.List<<a href="#@cdktf/provider-databricks.job.JobJobCluster">JobJobCluster</a>>

job_cluster block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#job_cluster Job#job_cluster}

---

##### `library`<sup>Optional</sup> <a name="library" id="@cdktf/provider-databricks.job.Job.Initializer.parameter.library"></a>

- *Type:* com.hashicorp.cdktf.IResolvable OR java.util.List<<a href="#@cdktf/provider-databricks.job.JobLibrary">JobLibrary</a>>

library block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#library Job#library}

---

##### `maxConcurrentRuns`<sup>Optional</sup> <a name="maxConcurrentRuns" id="@cdktf/provider-databricks.job.Job.Initializer.parameter.maxConcurrentRuns"></a>

- *Type:* java.lang.Number

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#max_concurrent_runs Job#max_concurrent_runs}.

---

##### `maxRetries`<sup>Optional</sup> <a name="maxRetries" id="@cdktf/provider-databricks.job.Job.Initializer.parameter.maxRetries"></a>

- *Type:* java.lang.Number

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#max_retries Job#max_retries}.

---

##### `minRetryIntervalMillis`<sup>Optional</sup> <a name="minRetryIntervalMillis" id="@cdktf/provider-databricks.job.Job.Initializer.parameter.minRetryIntervalMillis"></a>

- *Type:* java.lang.Number

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#min_retry_interval_millis Job#min_retry_interval_millis}.

---

##### `name`<sup>Optional</sup> <a name="name" id="@cdktf/provider-databricks.job.Job.Initializer.parameter.name"></a>

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#name Job#name}.

---

##### `newCluster`<sup>Optional</sup> <a name="newCluster" id="@cdktf/provider-databricks.job.Job.Initializer.parameter.newCluster"></a>

- *Type:* <a href="#@cdktf/provider-databricks.job.JobNewCluster">JobNewCluster</a>

new_cluster block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#new_cluster Job#new_cluster}

---

##### `notebookTask`<sup>Optional</sup> <a name="notebookTask" id="@cdktf/provider-databricks.job.Job.Initializer.parameter.notebookTask"></a>

- *Type:* <a href="#@cdktf/provider-databricks.job.JobNotebookTask">JobNotebookTask</a>

notebook_task block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#notebook_task Job#notebook_task}

---

##### `pipelineTask`<sup>Optional</sup> <a name="pipelineTask" id="@cdktf/provider-databricks.job.Job.Initializer.parameter.pipelineTask"></a>

- *Type:* <a href="#@cdktf/provider-databricks.job.JobPipelineTask">JobPipelineTask</a>

pipeline_task block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#pipeline_task Job#pipeline_task}

---

##### `pythonWheelTask`<sup>Optional</sup> <a name="pythonWheelTask" id="@cdktf/provider-databricks.job.Job.Initializer.parameter.pythonWheelTask"></a>

- *Type:* <a href="#@cdktf/provider-databricks.job.JobPythonWheelTask">JobPythonWheelTask</a>

python_wheel_task block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#python_wheel_task Job#python_wheel_task}

---

##### `queue`<sup>Optional</sup> <a name="queue" id="@cdktf/provider-databricks.job.Job.Initializer.parameter.queue"></a>

- *Type:* <a href="#@cdktf/provider-databricks.job.JobQueue">JobQueue</a>

queue block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#queue Job#queue}

---

##### `retryOnTimeout`<sup>Optional</sup> <a name="retryOnTimeout" id="@cdktf/provider-databricks.job.Job.Initializer.parameter.retryOnTimeout"></a>

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#retry_on_timeout Job#retry_on_timeout}.

---

##### `schedule`<sup>Optional</sup> <a name="schedule" id="@cdktf/provider-databricks.job.Job.Initializer.parameter.schedule"></a>

- *Type:* <a href="#@cdktf/provider-databricks.job.JobSchedule">JobSchedule</a>

schedule block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#schedule Job#schedule}

---

##### `sparkJarTask`<sup>Optional</sup> <a name="sparkJarTask" id="@cdktf/provider-databricks.job.Job.Initializer.parameter.sparkJarTask"></a>

- *Type:* <a href="#@cdktf/provider-databricks.job.JobSparkJarTask">JobSparkJarTask</a>

spark_jar_task block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#spark_jar_task Job#spark_jar_task}

---

##### `sparkPythonTask`<sup>Optional</sup> <a name="sparkPythonTask" id="@cdktf/provider-databricks.job.Job.Initializer.parameter.sparkPythonTask"></a>

- *Type:* <a href="#@cdktf/provider-databricks.job.JobSparkPythonTask">JobSparkPythonTask</a>

spark_python_task block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#spark_python_task Job#spark_python_task}

---

##### `sparkSubmitTask`<sup>Optional</sup> <a name="sparkSubmitTask" id="@cdktf/provider-databricks.job.Job.Initializer.parameter.sparkSubmitTask"></a>

- *Type:* <a href="#@cdktf/provider-databricks.job.JobSparkSubmitTask">JobSparkSubmitTask</a>

spark_submit_task block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#spark_submit_task Job#spark_submit_task}

---

##### `tags`<sup>Optional</sup> <a name="tags" id="@cdktf/provider-databricks.job.Job.Initializer.parameter.tags"></a>

- *Type:* java.util.Map<java.lang.String, java.lang.String>

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#tags Job#tags}.

---

##### `task`<sup>Optional</sup> <a name="task" id="@cdktf/provider-databricks.job.Job.Initializer.parameter.task"></a>

- *Type:* com.hashicorp.cdktf.IResolvable OR java.util.List<<a href="#@cdktf/provider-databricks.job.JobTask">JobTask</a>>

task block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#task Job#task}

---

##### `timeouts`<sup>Optional</sup> <a name="timeouts" id="@cdktf/provider-databricks.job.Job.Initializer.parameter.timeouts"></a>

- *Type:* <a href="#@cdktf/provider-databricks.job.JobTimeouts">JobTimeouts</a>

timeouts block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#timeouts Job#timeouts}

---

##### `timeoutSeconds`<sup>Optional</sup> <a name="timeoutSeconds" id="@cdktf/provider-databricks.job.Job.Initializer.parameter.timeoutSeconds"></a>

- *Type:* java.lang.Number

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#timeout_seconds Job#timeout_seconds}.

---

##### `trigger`<sup>Optional</sup> <a name="trigger" id="@cdktf/provider-databricks.job.Job.Initializer.parameter.trigger"></a>

- *Type:* <a href="#@cdktf/provider-databricks.job.JobTrigger">JobTrigger</a>

trigger block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#trigger Job#trigger}

---

##### `webhookNotifications`<sup>Optional</sup> <a name="webhookNotifications" id="@cdktf/provider-databricks.job.Job.Initializer.parameter.webhookNotifications"></a>

- *Type:* <a href="#@cdktf/provider-databricks.job.JobWebhookNotifications">JobWebhookNotifications</a>

webhook_notifications block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#webhook_notifications Job#webhook_notifications}

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.Job.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#@cdktf/provider-databricks.job.Job.addOverride">addOverride</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.overrideLogicalId">overrideLogicalId</a></code> | Overrides the auto-generated logical ID with a specific ID. |
| <code><a href="#@cdktf/provider-databricks.job.Job.resetOverrideLogicalId">resetOverrideLogicalId</a></code> | Resets a previously passed logical Id to use the auto-generated logical id again. |
| <code><a href="#@cdktf/provider-databricks.job.Job.toMetadata">toMetadata</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.toTerraform">toTerraform</a></code> | Adds this resource to the terraform JSON output. |
| <code><a href="#@cdktf/provider-databricks.job.Job.getAnyMapAttribute">getAnyMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.getBooleanAttribute">getBooleanAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.getBooleanMapAttribute">getBooleanMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.getListAttribute">getListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.getNumberAttribute">getNumberAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.getNumberListAttribute">getNumberListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.getNumberMapAttribute">getNumberMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.getStringAttribute">getStringAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.getStringMapAttribute">getStringMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.interpolationForAttribute">interpolationForAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.putContinuous">putContinuous</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.putDbtTask">putDbtTask</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.putEmailNotifications">putEmailNotifications</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.putGitSource">putGitSource</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.putJobCluster">putJobCluster</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.putLibrary">putLibrary</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.putNewCluster">putNewCluster</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.putNotebookTask">putNotebookTask</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.putPipelineTask">putPipelineTask</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.putPythonWheelTask">putPythonWheelTask</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.putQueue">putQueue</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.putSchedule">putSchedule</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.putSparkJarTask">putSparkJarTask</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.putSparkPythonTask">putSparkPythonTask</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.putSparkSubmitTask">putSparkSubmitTask</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.putTask">putTask</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.putTimeouts">putTimeouts</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.putTrigger">putTrigger</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.putWebhookNotifications">putWebhookNotifications</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.resetAlwaysRunning">resetAlwaysRunning</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.resetContinuous">resetContinuous</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.resetDbtTask">resetDbtTask</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.resetEmailNotifications">resetEmailNotifications</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.resetExistingClusterId">resetExistingClusterId</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.resetFormat">resetFormat</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.resetGitSource">resetGitSource</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.resetId">resetId</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.resetJobCluster">resetJobCluster</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.resetLibrary">resetLibrary</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.resetMaxConcurrentRuns">resetMaxConcurrentRuns</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.resetMaxRetries">resetMaxRetries</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.resetMinRetryIntervalMillis">resetMinRetryIntervalMillis</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.resetName">resetName</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.resetNewCluster">resetNewCluster</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.resetNotebookTask">resetNotebookTask</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.resetPipelineTask">resetPipelineTask</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.resetPythonWheelTask">resetPythonWheelTask</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.resetQueue">resetQueue</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.resetRetryOnTimeout">resetRetryOnTimeout</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.resetSchedule">resetSchedule</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.resetSparkJarTask">resetSparkJarTask</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.resetSparkPythonTask">resetSparkPythonTask</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.resetSparkSubmitTask">resetSparkSubmitTask</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.resetTags">resetTags</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.resetTask">resetTask</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.resetTimeouts">resetTimeouts</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.resetTimeoutSeconds">resetTimeoutSeconds</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.resetTrigger">resetTrigger</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.resetWebhookNotifications">resetWebhookNotifications</a></code> | *No description.* |

---

##### `toString` <a name="toString" id="@cdktf/provider-databricks.job.Job.toString"></a>

```java
public java.lang.String toString()
```

Returns a string representation of this construct.

##### `addOverride` <a name="addOverride" id="@cdktf/provider-databricks.job.Job.addOverride"></a>

```java
public void addOverride(java.lang.String path, java.lang.Object value)
```

###### `path`<sup>Required</sup> <a name="path" id="@cdktf/provider-databricks.job.Job.addOverride.parameter.path"></a>

- *Type:* java.lang.String

---

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-databricks.job.Job.addOverride.parameter.value"></a>

- *Type:* java.lang.Object

---

##### `overrideLogicalId` <a name="overrideLogicalId" id="@cdktf/provider-databricks.job.Job.overrideLogicalId"></a>

```java
public void overrideLogicalId(java.lang.String newLogicalId)
```

Overrides the auto-generated logical ID with a specific ID.

###### `newLogicalId`<sup>Required</sup> <a name="newLogicalId" id="@cdktf/provider-databricks.job.Job.overrideLogicalId.parameter.newLogicalId"></a>

- *Type:* java.lang.String

The new logical ID to use for this stack element.

---

##### `resetOverrideLogicalId` <a name="resetOverrideLogicalId" id="@cdktf/provider-databricks.job.Job.resetOverrideLogicalId"></a>

```java
public void resetOverrideLogicalId()
```

Resets a previously passed logical Id to use the auto-generated logical id again.

##### `toMetadata` <a name="toMetadata" id="@cdktf/provider-databricks.job.Job.toMetadata"></a>

```java
public java.lang.Object toMetadata()
```

##### `toTerraform` <a name="toTerraform" id="@cdktf/provider-databricks.job.Job.toTerraform"></a>

```java
public java.lang.Object toTerraform()
```

Adds this resource to the terraform JSON output.

##### `getAnyMapAttribute` <a name="getAnyMapAttribute" id="@cdktf/provider-databricks.job.Job.getAnyMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Object> getAnyMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.Job.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getBooleanAttribute` <a name="getBooleanAttribute" id="@cdktf/provider-databricks.job.Job.getBooleanAttribute"></a>

```java
public IResolvable getBooleanAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.Job.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getBooleanMapAttribute` <a name="getBooleanMapAttribute" id="@cdktf/provider-databricks.job.Job.getBooleanMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Boolean> getBooleanMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.Job.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getListAttribute` <a name="getListAttribute" id="@cdktf/provider-databricks.job.Job.getListAttribute"></a>

```java
public java.util.List<java.lang.String> getListAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.Job.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberAttribute` <a name="getNumberAttribute" id="@cdktf/provider-databricks.job.Job.getNumberAttribute"></a>

```java
public java.lang.Number getNumberAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.Job.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberListAttribute` <a name="getNumberListAttribute" id="@cdktf/provider-databricks.job.Job.getNumberListAttribute"></a>

```java
public java.util.List<java.lang.Number> getNumberListAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.Job.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberMapAttribute` <a name="getNumberMapAttribute" id="@cdktf/provider-databricks.job.Job.getNumberMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Number> getNumberMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.Job.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getStringAttribute` <a name="getStringAttribute" id="@cdktf/provider-databricks.job.Job.getStringAttribute"></a>

```java
public java.lang.String getStringAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.Job.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getStringMapAttribute` <a name="getStringMapAttribute" id="@cdktf/provider-databricks.job.Job.getStringMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.String> getStringMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.Job.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `interpolationForAttribute` <a name="interpolationForAttribute" id="@cdktf/provider-databricks.job.Job.interpolationForAttribute"></a>

```java
public IResolvable interpolationForAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.Job.interpolationForAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `putContinuous` <a name="putContinuous" id="@cdktf/provider-databricks.job.Job.putContinuous"></a>

```java
public void putContinuous(JobContinuous value)
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-databricks.job.Job.putContinuous.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-databricks.job.JobContinuous">JobContinuous</a>

---

##### `putDbtTask` <a name="putDbtTask" id="@cdktf/provider-databricks.job.Job.putDbtTask"></a>

```java
public void putDbtTask(JobDbtTask value)
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-databricks.job.Job.putDbtTask.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-databricks.job.JobDbtTask">JobDbtTask</a>

---

##### `putEmailNotifications` <a name="putEmailNotifications" id="@cdktf/provider-databricks.job.Job.putEmailNotifications"></a>

```java
public void putEmailNotifications(JobEmailNotifications value)
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-databricks.job.Job.putEmailNotifications.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-databricks.job.JobEmailNotifications">JobEmailNotifications</a>

---

##### `putGitSource` <a name="putGitSource" id="@cdktf/provider-databricks.job.Job.putGitSource"></a>

```java
public void putGitSource(JobGitSource value)
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-databricks.job.Job.putGitSource.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-databricks.job.JobGitSource">JobGitSource</a>

---

##### `putJobCluster` <a name="putJobCluster" id="@cdktf/provider-databricks.job.Job.putJobCluster"></a>

```java
public void putJobCluster(IResolvable OR java.util.List<JobJobCluster> value)
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-databricks.job.Job.putJobCluster.parameter.value"></a>

- *Type:* com.hashicorp.cdktf.IResolvable OR java.util.List<<a href="#@cdktf/provider-databricks.job.JobJobCluster">JobJobCluster</a>>

---

##### `putLibrary` <a name="putLibrary" id="@cdktf/provider-databricks.job.Job.putLibrary"></a>

```java
public void putLibrary(IResolvable OR java.util.List<JobLibrary> value)
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-databricks.job.Job.putLibrary.parameter.value"></a>

- *Type:* com.hashicorp.cdktf.IResolvable OR java.util.List<<a href="#@cdktf/provider-databricks.job.JobLibrary">JobLibrary</a>>

---

##### `putNewCluster` <a name="putNewCluster" id="@cdktf/provider-databricks.job.Job.putNewCluster"></a>

```java
public void putNewCluster(JobNewCluster value)
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-databricks.job.Job.putNewCluster.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-databricks.job.JobNewCluster">JobNewCluster</a>

---

##### `putNotebookTask` <a name="putNotebookTask" id="@cdktf/provider-databricks.job.Job.putNotebookTask"></a>

```java
public void putNotebookTask(JobNotebookTask value)
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-databricks.job.Job.putNotebookTask.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-databricks.job.JobNotebookTask">JobNotebookTask</a>

---

##### `putPipelineTask` <a name="putPipelineTask" id="@cdktf/provider-databricks.job.Job.putPipelineTask"></a>

```java
public void putPipelineTask(JobPipelineTask value)
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-databricks.job.Job.putPipelineTask.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-databricks.job.JobPipelineTask">JobPipelineTask</a>

---

##### `putPythonWheelTask` <a name="putPythonWheelTask" id="@cdktf/provider-databricks.job.Job.putPythonWheelTask"></a>

```java
public void putPythonWheelTask(JobPythonWheelTask value)
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-databricks.job.Job.putPythonWheelTask.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-databricks.job.JobPythonWheelTask">JobPythonWheelTask</a>

---

##### `putQueue` <a name="putQueue" id="@cdktf/provider-databricks.job.Job.putQueue"></a>

```java
public void putQueue(JobQueue value)
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-databricks.job.Job.putQueue.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-databricks.job.JobQueue">JobQueue</a>

---

##### `putSchedule` <a name="putSchedule" id="@cdktf/provider-databricks.job.Job.putSchedule"></a>

```java
public void putSchedule(JobSchedule value)
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-databricks.job.Job.putSchedule.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-databricks.job.JobSchedule">JobSchedule</a>

---

##### `putSparkJarTask` <a name="putSparkJarTask" id="@cdktf/provider-databricks.job.Job.putSparkJarTask"></a>

```java
public void putSparkJarTask(JobSparkJarTask value)
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-databricks.job.Job.putSparkJarTask.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-databricks.job.JobSparkJarTask">JobSparkJarTask</a>

---

##### `putSparkPythonTask` <a name="putSparkPythonTask" id="@cdktf/provider-databricks.job.Job.putSparkPythonTask"></a>

```java
public void putSparkPythonTask(JobSparkPythonTask value)
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-databricks.job.Job.putSparkPythonTask.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-databricks.job.JobSparkPythonTask">JobSparkPythonTask</a>

---

##### `putSparkSubmitTask` <a name="putSparkSubmitTask" id="@cdktf/provider-databricks.job.Job.putSparkSubmitTask"></a>

```java
public void putSparkSubmitTask(JobSparkSubmitTask value)
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-databricks.job.Job.putSparkSubmitTask.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-databricks.job.JobSparkSubmitTask">JobSparkSubmitTask</a>

---

##### `putTask` <a name="putTask" id="@cdktf/provider-databricks.job.Job.putTask"></a>

```java
public void putTask(IResolvable OR java.util.List<JobTask> value)
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-databricks.job.Job.putTask.parameter.value"></a>

- *Type:* com.hashicorp.cdktf.IResolvable OR java.util.List<<a href="#@cdktf/provider-databricks.job.JobTask">JobTask</a>>

---

##### `putTimeouts` <a name="putTimeouts" id="@cdktf/provider-databricks.job.Job.putTimeouts"></a>

```java
public void putTimeouts(JobTimeouts value)
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-databricks.job.Job.putTimeouts.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-databricks.job.JobTimeouts">JobTimeouts</a>

---

##### `putTrigger` <a name="putTrigger" id="@cdktf/provider-databricks.job.Job.putTrigger"></a>

```java
public void putTrigger(JobTrigger value)
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-databricks.job.Job.putTrigger.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-databricks.job.JobTrigger">JobTrigger</a>

---

##### `putWebhookNotifications` <a name="putWebhookNotifications" id="@cdktf/provider-databricks.job.Job.putWebhookNotifications"></a>

```java
public void putWebhookNotifications(JobWebhookNotifications value)
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-databricks.job.Job.putWebhookNotifications.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-databricks.job.JobWebhookNotifications">JobWebhookNotifications</a>

---

##### `resetAlwaysRunning` <a name="resetAlwaysRunning" id="@cdktf/provider-databricks.job.Job.resetAlwaysRunning"></a>

```java
public void resetAlwaysRunning()
```

##### `resetContinuous` <a name="resetContinuous" id="@cdktf/provider-databricks.job.Job.resetContinuous"></a>

```java
public void resetContinuous()
```

##### `resetDbtTask` <a name="resetDbtTask" id="@cdktf/provider-databricks.job.Job.resetDbtTask"></a>

```java
public void resetDbtTask()
```

##### `resetEmailNotifications` <a name="resetEmailNotifications" id="@cdktf/provider-databricks.job.Job.resetEmailNotifications"></a>

```java
public void resetEmailNotifications()
```

##### `resetExistingClusterId` <a name="resetExistingClusterId" id="@cdktf/provider-databricks.job.Job.resetExistingClusterId"></a>

```java
public void resetExistingClusterId()
```

##### `resetFormat` <a name="resetFormat" id="@cdktf/provider-databricks.job.Job.resetFormat"></a>

```java
public void resetFormat()
```

##### `resetGitSource` <a name="resetGitSource" id="@cdktf/provider-databricks.job.Job.resetGitSource"></a>

```java
public void resetGitSource()
```

##### `resetId` <a name="resetId" id="@cdktf/provider-databricks.job.Job.resetId"></a>

```java
public void resetId()
```

##### `resetJobCluster` <a name="resetJobCluster" id="@cdktf/provider-databricks.job.Job.resetJobCluster"></a>

```java
public void resetJobCluster()
```

##### `resetLibrary` <a name="resetLibrary" id="@cdktf/provider-databricks.job.Job.resetLibrary"></a>

```java
public void resetLibrary()
```

##### `resetMaxConcurrentRuns` <a name="resetMaxConcurrentRuns" id="@cdktf/provider-databricks.job.Job.resetMaxConcurrentRuns"></a>

```java
public void resetMaxConcurrentRuns()
```

##### `resetMaxRetries` <a name="resetMaxRetries" id="@cdktf/provider-databricks.job.Job.resetMaxRetries"></a>

```java
public void resetMaxRetries()
```

##### `resetMinRetryIntervalMillis` <a name="resetMinRetryIntervalMillis" id="@cdktf/provider-databricks.job.Job.resetMinRetryIntervalMillis"></a>

```java
public void resetMinRetryIntervalMillis()
```

##### `resetName` <a name="resetName" id="@cdktf/provider-databricks.job.Job.resetName"></a>

```java
public void resetName()
```

##### `resetNewCluster` <a name="resetNewCluster" id="@cdktf/provider-databricks.job.Job.resetNewCluster"></a>

```java
public void resetNewCluster()
```

##### `resetNotebookTask` <a name="resetNotebookTask" id="@cdktf/provider-databricks.job.Job.resetNotebookTask"></a>

```java
public void resetNotebookTask()
```

##### `resetPipelineTask` <a name="resetPipelineTask" id="@cdktf/provider-databricks.job.Job.resetPipelineTask"></a>

```java
public void resetPipelineTask()
```

##### `resetPythonWheelTask` <a name="resetPythonWheelTask" id="@cdktf/provider-databricks.job.Job.resetPythonWheelTask"></a>

```java
public void resetPythonWheelTask()
```

##### `resetQueue` <a name="resetQueue" id="@cdktf/provider-databricks.job.Job.resetQueue"></a>

```java
public void resetQueue()
```

##### `resetRetryOnTimeout` <a name="resetRetryOnTimeout" id="@cdktf/provider-databricks.job.Job.resetRetryOnTimeout"></a>

```java
public void resetRetryOnTimeout()
```

##### `resetSchedule` <a name="resetSchedule" id="@cdktf/provider-databricks.job.Job.resetSchedule"></a>

```java
public void resetSchedule()
```

##### `resetSparkJarTask` <a name="resetSparkJarTask" id="@cdktf/provider-databricks.job.Job.resetSparkJarTask"></a>

```java
public void resetSparkJarTask()
```

##### `resetSparkPythonTask` <a name="resetSparkPythonTask" id="@cdktf/provider-databricks.job.Job.resetSparkPythonTask"></a>

```java
public void resetSparkPythonTask()
```

##### `resetSparkSubmitTask` <a name="resetSparkSubmitTask" id="@cdktf/provider-databricks.job.Job.resetSparkSubmitTask"></a>

```java
public void resetSparkSubmitTask()
```

##### `resetTags` <a name="resetTags" id="@cdktf/provider-databricks.job.Job.resetTags"></a>

```java
public void resetTags()
```

##### `resetTask` <a name="resetTask" id="@cdktf/provider-databricks.job.Job.resetTask"></a>

```java
public void resetTask()
```

##### `resetTimeouts` <a name="resetTimeouts" id="@cdktf/provider-databricks.job.Job.resetTimeouts"></a>

```java
public void resetTimeouts()
```

##### `resetTimeoutSeconds` <a name="resetTimeoutSeconds" id="@cdktf/provider-databricks.job.Job.resetTimeoutSeconds"></a>

```java
public void resetTimeoutSeconds()
```

##### `resetTrigger` <a name="resetTrigger" id="@cdktf/provider-databricks.job.Job.resetTrigger"></a>

```java
public void resetTrigger()
```

##### `resetWebhookNotifications` <a name="resetWebhookNotifications" id="@cdktf/provider-databricks.job.Job.resetWebhookNotifications"></a>

```java
public void resetWebhookNotifications()
```

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.Job.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#@cdktf/provider-databricks.job.Job.isTerraformElement">isTerraformElement</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.isTerraformResource">isTerraformResource</a></code> | *No description.* |

---

##### `isConstruct` <a name="isConstruct" id="@cdktf/provider-databricks.job.Job.isConstruct"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.Job;

Job.isConstruct(java.lang.Object x)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="@cdktf/provider-databricks.job.Job.isConstruct.parameter.x"></a>

- *Type:* java.lang.Object

Any object.

---

##### `isTerraformElement` <a name="isTerraformElement" id="@cdktf/provider-databricks.job.Job.isTerraformElement"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.Job;

Job.isTerraformElement(java.lang.Object x)
```

###### `x`<sup>Required</sup> <a name="x" id="@cdktf/provider-databricks.job.Job.isTerraformElement.parameter.x"></a>

- *Type:* java.lang.Object

---

##### `isTerraformResource` <a name="isTerraformResource" id="@cdktf/provider-databricks.job.Job.isTerraformResource"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.Job;

Job.isTerraformResource(java.lang.Object x)
```

###### `x`<sup>Required</sup> <a name="x" id="@cdktf/provider-databricks.job.Job.isTerraformResource.parameter.x"></a>

- *Type:* java.lang.Object

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.Job.property.node">node</a></code> | <code>software.constructs.Node</code> | The tree node. |
| <code><a href="#@cdktf/provider-databricks.job.Job.property.cdktfStack">cdktfStack</a></code> | <code>com.hashicorp.cdktf.TerraformStack</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.property.fqn">fqn</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.property.friendlyUniqueId">friendlyUniqueId</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.property.terraformMetaArguments">terraformMetaArguments</a></code> | <code>java.util.Map<java.lang.String, java.lang.Object></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.property.terraformResourceType">terraformResourceType</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.property.terraformGeneratorMetadata">terraformGeneratorMetadata</a></code> | <code>com.hashicorp.cdktf.TerraformProviderGeneratorMetadata</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.property.connection">connection</a></code> | <code>com.hashicorp.cdktf.SSHProvisionerConnection OR com.hashicorp.cdktf.WinrmProvisionerConnection</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.property.count">count</a></code> | <code>java.lang.Number</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.property.dependsOn">dependsOn</a></code> | <code>java.util.List<java.lang.String></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.property.forEach">forEach</a></code> | <code>com.hashicorp.cdktf.ITerraformIterator</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.property.lifecycle">lifecycle</a></code> | <code>com.hashicorp.cdktf.TerraformResourceLifecycle</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.property.provider">provider</a></code> | <code>com.hashicorp.cdktf.TerraformProvider</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.property.provisioners">provisioners</a></code> | <code>java.util.List<com.hashicorp.cdktf.FileProvisioner OR com.hashicorp.cdktf.LocalExecProvisioner OR com.hashicorp.cdktf.RemoteExecProvisioner></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.property.continuous">continuous</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobContinuousOutputReference">JobContinuousOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.property.dbtTask">dbtTask</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobDbtTaskOutputReference">JobDbtTaskOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.property.emailNotifications">emailNotifications</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobEmailNotificationsOutputReference">JobEmailNotificationsOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.property.gitSource">gitSource</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobGitSourceOutputReference">JobGitSourceOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.property.jobCluster">jobCluster</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobJobClusterList">JobJobClusterList</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.property.library">library</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobLibraryList">JobLibraryList</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.property.newCluster">newCluster</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobNewClusterOutputReference">JobNewClusterOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.property.notebookTask">notebookTask</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobNotebookTaskOutputReference">JobNotebookTaskOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.property.pipelineTask">pipelineTask</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobPipelineTaskOutputReference">JobPipelineTaskOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.property.pythonWheelTask">pythonWheelTask</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobPythonWheelTaskOutputReference">JobPythonWheelTaskOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.property.queue">queue</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobQueueOutputReference">JobQueueOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.property.schedule">schedule</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobScheduleOutputReference">JobScheduleOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.property.sparkJarTask">sparkJarTask</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobSparkJarTaskOutputReference">JobSparkJarTaskOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.property.sparkPythonTask">sparkPythonTask</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobSparkPythonTaskOutputReference">JobSparkPythonTaskOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.property.sparkSubmitTask">sparkSubmitTask</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobSparkSubmitTaskOutputReference">JobSparkSubmitTaskOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.property.task">task</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobTaskList">JobTaskList</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.property.timeouts">timeouts</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobTimeoutsOutputReference">JobTimeoutsOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.property.trigger">trigger</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobTriggerOutputReference">JobTriggerOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.property.url">url</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.property.webhookNotifications">webhookNotifications</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobWebhookNotificationsOutputReference">JobWebhookNotificationsOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.property.alwaysRunningInput">alwaysRunningInput</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.property.continuousInput">continuousInput</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobContinuous">JobContinuous</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.property.dbtTaskInput">dbtTaskInput</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobDbtTask">JobDbtTask</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.property.emailNotificationsInput">emailNotificationsInput</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobEmailNotifications">JobEmailNotifications</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.property.existingClusterIdInput">existingClusterIdInput</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.property.formatInput">formatInput</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.property.gitSourceInput">gitSourceInput</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobGitSource">JobGitSource</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.property.idInput">idInput</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.property.jobClusterInput">jobClusterInput</a></code> | <code>com.hashicorp.cdktf.IResolvable OR java.util.List<<a href="#@cdktf/provider-databricks.job.JobJobCluster">JobJobCluster</a>></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.property.libraryInput">libraryInput</a></code> | <code>com.hashicorp.cdktf.IResolvable OR java.util.List<<a href="#@cdktf/provider-databricks.job.JobLibrary">JobLibrary</a>></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.property.maxConcurrentRunsInput">maxConcurrentRunsInput</a></code> | <code>java.lang.Number</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.property.maxRetriesInput">maxRetriesInput</a></code> | <code>java.lang.Number</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.property.minRetryIntervalMillisInput">minRetryIntervalMillisInput</a></code> | <code>java.lang.Number</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.property.nameInput">nameInput</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.property.newClusterInput">newClusterInput</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobNewCluster">JobNewCluster</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.property.notebookTaskInput">notebookTaskInput</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobNotebookTask">JobNotebookTask</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.property.pipelineTaskInput">pipelineTaskInput</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobPipelineTask">JobPipelineTask</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.property.pythonWheelTaskInput">pythonWheelTaskInput</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobPythonWheelTask">JobPythonWheelTask</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.property.queueInput">queueInput</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobQueue">JobQueue</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.property.retryOnTimeoutInput">retryOnTimeoutInput</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.property.scheduleInput">scheduleInput</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobSchedule">JobSchedule</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.property.sparkJarTaskInput">sparkJarTaskInput</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobSparkJarTask">JobSparkJarTask</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.property.sparkPythonTaskInput">sparkPythonTaskInput</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobSparkPythonTask">JobSparkPythonTask</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.property.sparkSubmitTaskInput">sparkSubmitTaskInput</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobSparkSubmitTask">JobSparkSubmitTask</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.property.tagsInput">tagsInput</a></code> | <code>java.util.Map<java.lang.String, java.lang.String></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.property.taskInput">taskInput</a></code> | <code>com.hashicorp.cdktf.IResolvable OR java.util.List<<a href="#@cdktf/provider-databricks.job.JobTask">JobTask</a>></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.property.timeoutSecondsInput">timeoutSecondsInput</a></code> | <code>java.lang.Number</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.property.timeoutsInput">timeoutsInput</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobTimeouts">JobTimeouts</a> OR com.hashicorp.cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.property.triggerInput">triggerInput</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobTrigger">JobTrigger</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.property.webhookNotificationsInput">webhookNotificationsInput</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobWebhookNotifications">JobWebhookNotifications</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.property.alwaysRunning">alwaysRunning</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.property.existingClusterId">existingClusterId</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.property.format">format</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.property.id">id</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.property.maxConcurrentRuns">maxConcurrentRuns</a></code> | <code>java.lang.Number</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.property.maxRetries">maxRetries</a></code> | <code>java.lang.Number</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.property.minRetryIntervalMillis">minRetryIntervalMillis</a></code> | <code>java.lang.Number</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.property.name">name</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.property.retryOnTimeout">retryOnTimeout</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.property.tags">tags</a></code> | <code>java.util.Map<java.lang.String, java.lang.String></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.Job.property.timeoutSeconds">timeoutSeconds</a></code> | <code>java.lang.Number</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="@cdktf/provider-databricks.job.Job.property.node"></a>

```java
public Node getNode();
```

- *Type:* software.constructs.Node

The tree node.

---

##### `cdktfStack`<sup>Required</sup> <a name="cdktfStack" id="@cdktf/provider-databricks.job.Job.property.cdktfStack"></a>

```java
public TerraformStack getCdktfStack();
```

- *Type:* com.hashicorp.cdktf.TerraformStack

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-databricks.job.Job.property.fqn"></a>

```java
public java.lang.String getFqn();
```

- *Type:* java.lang.String

---

##### `friendlyUniqueId`<sup>Required</sup> <a name="friendlyUniqueId" id="@cdktf/provider-databricks.job.Job.property.friendlyUniqueId"></a>

```java
public java.lang.String getFriendlyUniqueId();
```

- *Type:* java.lang.String

---

##### `terraformMetaArguments`<sup>Required</sup> <a name="terraformMetaArguments" id="@cdktf/provider-databricks.job.Job.property.terraformMetaArguments"></a>

```java
public java.util.Map<java.lang.String, java.lang.Object> getTerraformMetaArguments();
```

- *Type:* java.util.Map<java.lang.String, java.lang.Object>

---

##### `terraformResourceType`<sup>Required</sup> <a name="terraformResourceType" id="@cdktf/provider-databricks.job.Job.property.terraformResourceType"></a>

```java
public java.lang.String getTerraformResourceType();
```

- *Type:* java.lang.String

---

##### `terraformGeneratorMetadata`<sup>Optional</sup> <a name="terraformGeneratorMetadata" id="@cdktf/provider-databricks.job.Job.property.terraformGeneratorMetadata"></a>

```java
public TerraformProviderGeneratorMetadata getTerraformGeneratorMetadata();
```

- *Type:* com.hashicorp.cdktf.TerraformProviderGeneratorMetadata

---

##### `connection`<sup>Optional</sup> <a name="connection" id="@cdktf/provider-databricks.job.Job.property.connection"></a>

```java
public java.lang.Object getConnection();
```

- *Type:* com.hashicorp.cdktf.SSHProvisionerConnection OR com.hashicorp.cdktf.WinrmProvisionerConnection

---

##### `count`<sup>Optional</sup> <a name="count" id="@cdktf/provider-databricks.job.Job.property.count"></a>

```java
public java.lang.Number getCount();
```

- *Type:* java.lang.Number

---

##### `dependsOn`<sup>Optional</sup> <a name="dependsOn" id="@cdktf/provider-databricks.job.Job.property.dependsOn"></a>

```java
public java.util.List<java.lang.String> getDependsOn();
```

- *Type:* java.util.List<java.lang.String>

---

##### `forEach`<sup>Optional</sup> <a name="forEach" id="@cdktf/provider-databricks.job.Job.property.forEach"></a>

```java
public ITerraformIterator getForEach();
```

- *Type:* com.hashicorp.cdktf.ITerraformIterator

---

##### `lifecycle`<sup>Optional</sup> <a name="lifecycle" id="@cdktf/provider-databricks.job.Job.property.lifecycle"></a>

```java
public TerraformResourceLifecycle getLifecycle();
```

- *Type:* com.hashicorp.cdktf.TerraformResourceLifecycle

---

##### `provider`<sup>Optional</sup> <a name="provider" id="@cdktf/provider-databricks.job.Job.property.provider"></a>

```java
public TerraformProvider getProvider();
```

- *Type:* com.hashicorp.cdktf.TerraformProvider

---

##### `provisioners`<sup>Optional</sup> <a name="provisioners" id="@cdktf/provider-databricks.job.Job.property.provisioners"></a>

```java
public java.lang.Object getProvisioners();
```

- *Type:* java.util.List<com.hashicorp.cdktf.FileProvisioner OR com.hashicorp.cdktf.LocalExecProvisioner OR com.hashicorp.cdktf.RemoteExecProvisioner>

---

##### `continuous`<sup>Required</sup> <a name="continuous" id="@cdktf/provider-databricks.job.Job.property.continuous"></a>

```java
public JobContinuousOutputReference getContinuous();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobContinuousOutputReference">JobContinuousOutputReference</a>

---

##### `dbtTask`<sup>Required</sup> <a name="dbtTask" id="@cdktf/provider-databricks.job.Job.property.dbtTask"></a>

```java
public JobDbtTaskOutputReference getDbtTask();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobDbtTaskOutputReference">JobDbtTaskOutputReference</a>

---

##### `emailNotifications`<sup>Required</sup> <a name="emailNotifications" id="@cdktf/provider-databricks.job.Job.property.emailNotifications"></a>

```java
public JobEmailNotificationsOutputReference getEmailNotifications();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobEmailNotificationsOutputReference">JobEmailNotificationsOutputReference</a>

---

##### `gitSource`<sup>Required</sup> <a name="gitSource" id="@cdktf/provider-databricks.job.Job.property.gitSource"></a>

```java
public JobGitSourceOutputReference getGitSource();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobGitSourceOutputReference">JobGitSourceOutputReference</a>

---

##### `jobCluster`<sup>Required</sup> <a name="jobCluster" id="@cdktf/provider-databricks.job.Job.property.jobCluster"></a>

```java
public JobJobClusterList getJobCluster();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobJobClusterList">JobJobClusterList</a>

---

##### `library`<sup>Required</sup> <a name="library" id="@cdktf/provider-databricks.job.Job.property.library"></a>

```java
public JobLibraryList getLibrary();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobLibraryList">JobLibraryList</a>

---

##### `newCluster`<sup>Required</sup> <a name="newCluster" id="@cdktf/provider-databricks.job.Job.property.newCluster"></a>

```java
public JobNewClusterOutputReference getNewCluster();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobNewClusterOutputReference">JobNewClusterOutputReference</a>

---

##### `notebookTask`<sup>Required</sup> <a name="notebookTask" id="@cdktf/provider-databricks.job.Job.property.notebookTask"></a>

```java
public JobNotebookTaskOutputReference getNotebookTask();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobNotebookTaskOutputReference">JobNotebookTaskOutputReference</a>

---

##### `pipelineTask`<sup>Required</sup> <a name="pipelineTask" id="@cdktf/provider-databricks.job.Job.property.pipelineTask"></a>

```java
public JobPipelineTaskOutputReference getPipelineTask();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobPipelineTaskOutputReference">JobPipelineTaskOutputReference</a>

---

##### `pythonWheelTask`<sup>Required</sup> <a name="pythonWheelTask" id="@cdktf/provider-databricks.job.Job.property.pythonWheelTask"></a>

```java
public JobPythonWheelTaskOutputReference getPythonWheelTask();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobPythonWheelTaskOutputReference">JobPythonWheelTaskOutputReference</a>

---

##### `queue`<sup>Required</sup> <a name="queue" id="@cdktf/provider-databricks.job.Job.property.queue"></a>

```java
public JobQueueOutputReference getQueue();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobQueueOutputReference">JobQueueOutputReference</a>

---

##### `schedule`<sup>Required</sup> <a name="schedule" id="@cdktf/provider-databricks.job.Job.property.schedule"></a>

```java
public JobScheduleOutputReference getSchedule();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobScheduleOutputReference">JobScheduleOutputReference</a>

---

##### `sparkJarTask`<sup>Required</sup> <a name="sparkJarTask" id="@cdktf/provider-databricks.job.Job.property.sparkJarTask"></a>

```java
public JobSparkJarTaskOutputReference getSparkJarTask();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobSparkJarTaskOutputReference">JobSparkJarTaskOutputReference</a>

---

##### `sparkPythonTask`<sup>Required</sup> <a name="sparkPythonTask" id="@cdktf/provider-databricks.job.Job.property.sparkPythonTask"></a>

```java
public JobSparkPythonTaskOutputReference getSparkPythonTask();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobSparkPythonTaskOutputReference">JobSparkPythonTaskOutputReference</a>

---

##### `sparkSubmitTask`<sup>Required</sup> <a name="sparkSubmitTask" id="@cdktf/provider-databricks.job.Job.property.sparkSubmitTask"></a>

```java
public JobSparkSubmitTaskOutputReference getSparkSubmitTask();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobSparkSubmitTaskOutputReference">JobSparkSubmitTaskOutputReference</a>

---

##### `task`<sup>Required</sup> <a name="task" id="@cdktf/provider-databricks.job.Job.property.task"></a>

```java
public JobTaskList getTask();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobTaskList">JobTaskList</a>

---

##### `timeouts`<sup>Required</sup> <a name="timeouts" id="@cdktf/provider-databricks.job.Job.property.timeouts"></a>

```java
public JobTimeoutsOutputReference getTimeouts();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobTimeoutsOutputReference">JobTimeoutsOutputReference</a>

---

##### `trigger`<sup>Required</sup> <a name="trigger" id="@cdktf/provider-databricks.job.Job.property.trigger"></a>

```java
public JobTriggerOutputReference getTrigger();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobTriggerOutputReference">JobTriggerOutputReference</a>

---

##### `url`<sup>Required</sup> <a name="url" id="@cdktf/provider-databricks.job.Job.property.url"></a>

```java
public java.lang.String getUrl();
```

- *Type:* java.lang.String

---

##### `webhookNotifications`<sup>Required</sup> <a name="webhookNotifications" id="@cdktf/provider-databricks.job.Job.property.webhookNotifications"></a>

```java
public JobWebhookNotificationsOutputReference getWebhookNotifications();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobWebhookNotificationsOutputReference">JobWebhookNotificationsOutputReference</a>

---

##### `alwaysRunningInput`<sup>Optional</sup> <a name="alwaysRunningInput" id="@cdktf/provider-databricks.job.Job.property.alwaysRunningInput"></a>

```java
public java.lang.Object getAlwaysRunningInput();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

---

##### `continuousInput`<sup>Optional</sup> <a name="continuousInput" id="@cdktf/provider-databricks.job.Job.property.continuousInput"></a>

```java
public JobContinuous getContinuousInput();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobContinuous">JobContinuous</a>

---

##### `dbtTaskInput`<sup>Optional</sup> <a name="dbtTaskInput" id="@cdktf/provider-databricks.job.Job.property.dbtTaskInput"></a>

```java
public JobDbtTask getDbtTaskInput();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobDbtTask">JobDbtTask</a>

---

##### `emailNotificationsInput`<sup>Optional</sup> <a name="emailNotificationsInput" id="@cdktf/provider-databricks.job.Job.property.emailNotificationsInput"></a>

```java
public JobEmailNotifications getEmailNotificationsInput();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobEmailNotifications">JobEmailNotifications</a>

---

##### `existingClusterIdInput`<sup>Optional</sup> <a name="existingClusterIdInput" id="@cdktf/provider-databricks.job.Job.property.existingClusterIdInput"></a>

```java
public java.lang.String getExistingClusterIdInput();
```

- *Type:* java.lang.String

---

##### `formatInput`<sup>Optional</sup> <a name="formatInput" id="@cdktf/provider-databricks.job.Job.property.formatInput"></a>

```java
public java.lang.String getFormatInput();
```

- *Type:* java.lang.String

---

##### `gitSourceInput`<sup>Optional</sup> <a name="gitSourceInput" id="@cdktf/provider-databricks.job.Job.property.gitSourceInput"></a>

```java
public JobGitSource getGitSourceInput();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobGitSource">JobGitSource</a>

---

##### `idInput`<sup>Optional</sup> <a name="idInput" id="@cdktf/provider-databricks.job.Job.property.idInput"></a>

```java
public java.lang.String getIdInput();
```

- *Type:* java.lang.String

---

##### `jobClusterInput`<sup>Optional</sup> <a name="jobClusterInput" id="@cdktf/provider-databricks.job.Job.property.jobClusterInput"></a>

```java
public java.lang.Object getJobClusterInput();
```

- *Type:* com.hashicorp.cdktf.IResolvable OR java.util.List<<a href="#@cdktf/provider-databricks.job.JobJobCluster">JobJobCluster</a>>

---

##### `libraryInput`<sup>Optional</sup> <a name="libraryInput" id="@cdktf/provider-databricks.job.Job.property.libraryInput"></a>

```java
public java.lang.Object getLibraryInput();
```

- *Type:* com.hashicorp.cdktf.IResolvable OR java.util.List<<a href="#@cdktf/provider-databricks.job.JobLibrary">JobLibrary</a>>

---

##### `maxConcurrentRunsInput`<sup>Optional</sup> <a name="maxConcurrentRunsInput" id="@cdktf/provider-databricks.job.Job.property.maxConcurrentRunsInput"></a>

```java
public java.lang.Number getMaxConcurrentRunsInput();
```

- *Type:* java.lang.Number

---

##### `maxRetriesInput`<sup>Optional</sup> <a name="maxRetriesInput" id="@cdktf/provider-databricks.job.Job.property.maxRetriesInput"></a>

```java
public java.lang.Number getMaxRetriesInput();
```

- *Type:* java.lang.Number

---

##### `minRetryIntervalMillisInput`<sup>Optional</sup> <a name="minRetryIntervalMillisInput" id="@cdktf/provider-databricks.job.Job.property.minRetryIntervalMillisInput"></a>

```java
public java.lang.Number getMinRetryIntervalMillisInput();
```

- *Type:* java.lang.Number

---

##### `nameInput`<sup>Optional</sup> <a name="nameInput" id="@cdktf/provider-databricks.job.Job.property.nameInput"></a>

```java
public java.lang.String getNameInput();
```

- *Type:* java.lang.String

---

##### `newClusterInput`<sup>Optional</sup> <a name="newClusterInput" id="@cdktf/provider-databricks.job.Job.property.newClusterInput"></a>

```java
public JobNewCluster getNewClusterInput();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobNewCluster">JobNewCluster</a>

---

##### `notebookTaskInput`<sup>Optional</sup> <a name="notebookTaskInput" id="@cdktf/provider-databricks.job.Job.property.notebookTaskInput"></a>

```java
public JobNotebookTask getNotebookTaskInput();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobNotebookTask">JobNotebookTask</a>

---

##### `pipelineTaskInput`<sup>Optional</sup> <a name="pipelineTaskInput" id="@cdktf/provider-databricks.job.Job.property.pipelineTaskInput"></a>

```java
public JobPipelineTask getPipelineTaskInput();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobPipelineTask">JobPipelineTask</a>

---

##### `pythonWheelTaskInput`<sup>Optional</sup> <a name="pythonWheelTaskInput" id="@cdktf/provider-databricks.job.Job.property.pythonWheelTaskInput"></a>

```java
public JobPythonWheelTask getPythonWheelTaskInput();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobPythonWheelTask">JobPythonWheelTask</a>

---

##### `queueInput`<sup>Optional</sup> <a name="queueInput" id="@cdktf/provider-databricks.job.Job.property.queueInput"></a>

```java
public JobQueue getQueueInput();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobQueue">JobQueue</a>

---

##### `retryOnTimeoutInput`<sup>Optional</sup> <a name="retryOnTimeoutInput" id="@cdktf/provider-databricks.job.Job.property.retryOnTimeoutInput"></a>

```java
public java.lang.Object getRetryOnTimeoutInput();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

---

##### `scheduleInput`<sup>Optional</sup> <a name="scheduleInput" id="@cdktf/provider-databricks.job.Job.property.scheduleInput"></a>

```java
public JobSchedule getScheduleInput();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobSchedule">JobSchedule</a>

---

##### `sparkJarTaskInput`<sup>Optional</sup> <a name="sparkJarTaskInput" id="@cdktf/provider-databricks.job.Job.property.sparkJarTaskInput"></a>

```java
public JobSparkJarTask getSparkJarTaskInput();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobSparkJarTask">JobSparkJarTask</a>

---

##### `sparkPythonTaskInput`<sup>Optional</sup> <a name="sparkPythonTaskInput" id="@cdktf/provider-databricks.job.Job.property.sparkPythonTaskInput"></a>

```java
public JobSparkPythonTask getSparkPythonTaskInput();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobSparkPythonTask">JobSparkPythonTask</a>

---

##### `sparkSubmitTaskInput`<sup>Optional</sup> <a name="sparkSubmitTaskInput" id="@cdktf/provider-databricks.job.Job.property.sparkSubmitTaskInput"></a>

```java
public JobSparkSubmitTask getSparkSubmitTaskInput();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobSparkSubmitTask">JobSparkSubmitTask</a>

---

##### `tagsInput`<sup>Optional</sup> <a name="tagsInput" id="@cdktf/provider-databricks.job.Job.property.tagsInput"></a>

```java
public java.util.Map<java.lang.String, java.lang.String> getTagsInput();
```

- *Type:* java.util.Map<java.lang.String, java.lang.String>

---

##### `taskInput`<sup>Optional</sup> <a name="taskInput" id="@cdktf/provider-databricks.job.Job.property.taskInput"></a>

```java
public java.lang.Object getTaskInput();
```

- *Type:* com.hashicorp.cdktf.IResolvable OR java.util.List<<a href="#@cdktf/provider-databricks.job.JobTask">JobTask</a>>

---

##### `timeoutSecondsInput`<sup>Optional</sup> <a name="timeoutSecondsInput" id="@cdktf/provider-databricks.job.Job.property.timeoutSecondsInput"></a>

```java
public java.lang.Number getTimeoutSecondsInput();
```

- *Type:* java.lang.Number

---

##### `timeoutsInput`<sup>Optional</sup> <a name="timeoutsInput" id="@cdktf/provider-databricks.job.Job.property.timeoutsInput"></a>

```java
public java.lang.Object getTimeoutsInput();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobTimeouts">JobTimeouts</a> OR com.hashicorp.cdktf.IResolvable

---

##### `triggerInput`<sup>Optional</sup> <a name="triggerInput" id="@cdktf/provider-databricks.job.Job.property.triggerInput"></a>

```java
public JobTrigger getTriggerInput();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobTrigger">JobTrigger</a>

---

##### `webhookNotificationsInput`<sup>Optional</sup> <a name="webhookNotificationsInput" id="@cdktf/provider-databricks.job.Job.property.webhookNotificationsInput"></a>

```java
public JobWebhookNotifications getWebhookNotificationsInput();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobWebhookNotifications">JobWebhookNotifications</a>

---

##### `alwaysRunning`<sup>Required</sup> <a name="alwaysRunning" id="@cdktf/provider-databricks.job.Job.property.alwaysRunning"></a>

```java
public java.lang.Object getAlwaysRunning();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

---

##### `existingClusterId`<sup>Required</sup> <a name="existingClusterId" id="@cdktf/provider-databricks.job.Job.property.existingClusterId"></a>

```java
public java.lang.String getExistingClusterId();
```

- *Type:* java.lang.String

---

##### `format`<sup>Required</sup> <a name="format" id="@cdktf/provider-databricks.job.Job.property.format"></a>

```java
public java.lang.String getFormat();
```

- *Type:* java.lang.String

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-databricks.job.Job.property.id"></a>

```java
public java.lang.String getId();
```

- *Type:* java.lang.String

---

##### `maxConcurrentRuns`<sup>Required</sup> <a name="maxConcurrentRuns" id="@cdktf/provider-databricks.job.Job.property.maxConcurrentRuns"></a>

```java
public java.lang.Number getMaxConcurrentRuns();
```

- *Type:* java.lang.Number

---

##### `maxRetries`<sup>Required</sup> <a name="maxRetries" id="@cdktf/provider-databricks.job.Job.property.maxRetries"></a>

```java
public java.lang.Number getMaxRetries();
```

- *Type:* java.lang.Number

---

##### `minRetryIntervalMillis`<sup>Required</sup> <a name="minRetryIntervalMillis" id="@cdktf/provider-databricks.job.Job.property.minRetryIntervalMillis"></a>

```java
public java.lang.Number getMinRetryIntervalMillis();
```

- *Type:* java.lang.Number

---

##### `name`<sup>Required</sup> <a name="name" id="@cdktf/provider-databricks.job.Job.property.name"></a>

```java
public java.lang.String getName();
```

- *Type:* java.lang.String

---

##### `retryOnTimeout`<sup>Required</sup> <a name="retryOnTimeout" id="@cdktf/provider-databricks.job.Job.property.retryOnTimeout"></a>

```java
public java.lang.Object getRetryOnTimeout();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

---

##### `tags`<sup>Required</sup> <a name="tags" id="@cdktf/provider-databricks.job.Job.property.tags"></a>

```java
public java.util.Map<java.lang.String, java.lang.String> getTags();
```

- *Type:* java.util.Map<java.lang.String, java.lang.String>

---

##### `timeoutSeconds`<sup>Required</sup> <a name="timeoutSeconds" id="@cdktf/provider-databricks.job.Job.property.timeoutSeconds"></a>

```java
public java.lang.Number getTimeoutSeconds();
```

- *Type:* java.lang.Number

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.Job.property.tfResourceType">tfResourceType</a></code> | <code>java.lang.String</code> | *No description.* |

---

##### `tfResourceType`<sup>Required</sup> <a name="tfResourceType" id="@cdktf/provider-databricks.job.Job.property.tfResourceType"></a>

```java
public java.lang.String getTfResourceType();
```

- *Type:* java.lang.String

---

## Structs <a name="Structs" id="Structs"></a>

### JobConfig <a name="JobConfig" id="@cdktf/provider-databricks.job.JobConfig"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-databricks.job.JobConfig.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobConfig;

JobConfig.builder()
//  .connection(SSHProvisionerConnection)
//  .connection(WinrmProvisionerConnection)
//  .count(java.lang.Number)
//  .dependsOn(java.util.List<ITerraformDependable>)
//  .forEach(ITerraformIterator)
//  .lifecycle(TerraformResourceLifecycle)
//  .provider(TerraformProvider)
//  .provisioners(java.util.List<FileProvisioner)
//  .provisioners(LocalExecProvisioner)
//  .provisioners(RemoteExecProvisioner>)
//  .alwaysRunning(java.lang.Boolean)
//  .alwaysRunning(IResolvable)
//  .continuous(JobContinuous)
//  .dbtTask(JobDbtTask)
//  .emailNotifications(JobEmailNotifications)
//  .existingClusterId(java.lang.String)
//  .format(java.lang.String)
//  .gitSource(JobGitSource)
//  .id(java.lang.String)
//  .jobCluster(IResolvable)
//  .jobCluster(java.util.List<JobJobCluster>)
//  .library(IResolvable)
//  .library(java.util.List<JobLibrary>)
//  .maxConcurrentRuns(java.lang.Number)
//  .maxRetries(java.lang.Number)
//  .minRetryIntervalMillis(java.lang.Number)
//  .name(java.lang.String)
//  .newCluster(JobNewCluster)
//  .notebookTask(JobNotebookTask)
//  .pipelineTask(JobPipelineTask)
//  .pythonWheelTask(JobPythonWheelTask)
//  .queue(JobQueue)
//  .retryOnTimeout(java.lang.Boolean)
//  .retryOnTimeout(IResolvable)
//  .schedule(JobSchedule)
//  .sparkJarTask(JobSparkJarTask)
//  .sparkPythonTask(JobSparkPythonTask)
//  .sparkSubmitTask(JobSparkSubmitTask)
//  .tags(java.util.Map<java.lang.String, java.lang.String>)
//  .task(IResolvable)
//  .task(java.util.List<JobTask>)
//  .timeouts(JobTimeouts)
//  .timeoutSeconds(java.lang.Number)
//  .trigger(JobTrigger)
//  .webhookNotifications(JobWebhookNotifications)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobConfig.property.connection">connection</a></code> | <code>com.hashicorp.cdktf.SSHProvisionerConnection OR com.hashicorp.cdktf.WinrmProvisionerConnection</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobConfig.property.count">count</a></code> | <code>java.lang.Number</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobConfig.property.dependsOn">dependsOn</a></code> | <code>java.util.List<com.hashicorp.cdktf.ITerraformDependable></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobConfig.property.forEach">forEach</a></code> | <code>com.hashicorp.cdktf.ITerraformIterator</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobConfig.property.lifecycle">lifecycle</a></code> | <code>com.hashicorp.cdktf.TerraformResourceLifecycle</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobConfig.property.provider">provider</a></code> | <code>com.hashicorp.cdktf.TerraformProvider</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobConfig.property.provisioners">provisioners</a></code> | <code>java.util.List<com.hashicorp.cdktf.FileProvisioner OR com.hashicorp.cdktf.LocalExecProvisioner OR com.hashicorp.cdktf.RemoteExecProvisioner></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobConfig.property.alwaysRunning">alwaysRunning</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#always_running Job#always_running}. |
| <code><a href="#@cdktf/provider-databricks.job.JobConfig.property.continuous">continuous</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobContinuous">JobContinuous</a></code> | continuous block. |
| <code><a href="#@cdktf/provider-databricks.job.JobConfig.property.dbtTask">dbtTask</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobDbtTask">JobDbtTask</a></code> | dbt_task block. |
| <code><a href="#@cdktf/provider-databricks.job.JobConfig.property.emailNotifications">emailNotifications</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobEmailNotifications">JobEmailNotifications</a></code> | email_notifications block. |
| <code><a href="#@cdktf/provider-databricks.job.JobConfig.property.existingClusterId">existingClusterId</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#existing_cluster_id Job#existing_cluster_id}. |
| <code><a href="#@cdktf/provider-databricks.job.JobConfig.property.format">format</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#format Job#format}. |
| <code><a href="#@cdktf/provider-databricks.job.JobConfig.property.gitSource">gitSource</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobGitSource">JobGitSource</a></code> | git_source block. |
| <code><a href="#@cdktf/provider-databricks.job.JobConfig.property.id">id</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#id Job#id}. |
| <code><a href="#@cdktf/provider-databricks.job.JobConfig.property.jobCluster">jobCluster</a></code> | <code>com.hashicorp.cdktf.IResolvable OR java.util.List<<a href="#@cdktf/provider-databricks.job.JobJobCluster">JobJobCluster</a>></code> | job_cluster block. |
| <code><a href="#@cdktf/provider-databricks.job.JobConfig.property.library">library</a></code> | <code>com.hashicorp.cdktf.IResolvable OR java.util.List<<a href="#@cdktf/provider-databricks.job.JobLibrary">JobLibrary</a>></code> | library block. |
| <code><a href="#@cdktf/provider-databricks.job.JobConfig.property.maxConcurrentRuns">maxConcurrentRuns</a></code> | <code>java.lang.Number</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#max_concurrent_runs Job#max_concurrent_runs}. |
| <code><a href="#@cdktf/provider-databricks.job.JobConfig.property.maxRetries">maxRetries</a></code> | <code>java.lang.Number</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#max_retries Job#max_retries}. |
| <code><a href="#@cdktf/provider-databricks.job.JobConfig.property.minRetryIntervalMillis">minRetryIntervalMillis</a></code> | <code>java.lang.Number</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#min_retry_interval_millis Job#min_retry_interval_millis}. |
| <code><a href="#@cdktf/provider-databricks.job.JobConfig.property.name">name</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#name Job#name}. |
| <code><a href="#@cdktf/provider-databricks.job.JobConfig.property.newCluster">newCluster</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobNewCluster">JobNewCluster</a></code> | new_cluster block. |
| <code><a href="#@cdktf/provider-databricks.job.JobConfig.property.notebookTask">notebookTask</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobNotebookTask">JobNotebookTask</a></code> | notebook_task block. |
| <code><a href="#@cdktf/provider-databricks.job.JobConfig.property.pipelineTask">pipelineTask</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobPipelineTask">JobPipelineTask</a></code> | pipeline_task block. |
| <code><a href="#@cdktf/provider-databricks.job.JobConfig.property.pythonWheelTask">pythonWheelTask</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobPythonWheelTask">JobPythonWheelTask</a></code> | python_wheel_task block. |
| <code><a href="#@cdktf/provider-databricks.job.JobConfig.property.queue">queue</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobQueue">JobQueue</a></code> | queue block. |
| <code><a href="#@cdktf/provider-databricks.job.JobConfig.property.retryOnTimeout">retryOnTimeout</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#retry_on_timeout Job#retry_on_timeout}. |
| <code><a href="#@cdktf/provider-databricks.job.JobConfig.property.schedule">schedule</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobSchedule">JobSchedule</a></code> | schedule block. |
| <code><a href="#@cdktf/provider-databricks.job.JobConfig.property.sparkJarTask">sparkJarTask</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobSparkJarTask">JobSparkJarTask</a></code> | spark_jar_task block. |
| <code><a href="#@cdktf/provider-databricks.job.JobConfig.property.sparkPythonTask">sparkPythonTask</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobSparkPythonTask">JobSparkPythonTask</a></code> | spark_python_task block. |
| <code><a href="#@cdktf/provider-databricks.job.JobConfig.property.sparkSubmitTask">sparkSubmitTask</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobSparkSubmitTask">JobSparkSubmitTask</a></code> | spark_submit_task block. |
| <code><a href="#@cdktf/provider-databricks.job.JobConfig.property.tags">tags</a></code> | <code>java.util.Map<java.lang.String, java.lang.String></code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#tags Job#tags}. |
| <code><a href="#@cdktf/provider-databricks.job.JobConfig.property.task">task</a></code> | <code>com.hashicorp.cdktf.IResolvable OR java.util.List<<a href="#@cdktf/provider-databricks.job.JobTask">JobTask</a>></code> | task block. |
| <code><a href="#@cdktf/provider-databricks.job.JobConfig.property.timeouts">timeouts</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobTimeouts">JobTimeouts</a></code> | timeouts block. |
| <code><a href="#@cdktf/provider-databricks.job.JobConfig.property.timeoutSeconds">timeoutSeconds</a></code> | <code>java.lang.Number</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#timeout_seconds Job#timeout_seconds}. |
| <code><a href="#@cdktf/provider-databricks.job.JobConfig.property.trigger">trigger</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobTrigger">JobTrigger</a></code> | trigger block. |
| <code><a href="#@cdktf/provider-databricks.job.JobConfig.property.webhookNotifications">webhookNotifications</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobWebhookNotifications">JobWebhookNotifications</a></code> | webhook_notifications block. |

---

##### `connection`<sup>Optional</sup> <a name="connection" id="@cdktf/provider-databricks.job.JobConfig.property.connection"></a>

```java
public java.lang.Object getConnection();
```

- *Type:* com.hashicorp.cdktf.SSHProvisionerConnection OR com.hashicorp.cdktf.WinrmProvisionerConnection

---

##### `count`<sup>Optional</sup> <a name="count" id="@cdktf/provider-databricks.job.JobConfig.property.count"></a>

```java
public java.lang.Number getCount();
```

- *Type:* java.lang.Number

---

##### `dependsOn`<sup>Optional</sup> <a name="dependsOn" id="@cdktf/provider-databricks.job.JobConfig.property.dependsOn"></a>

```java
public java.util.List<ITerraformDependable> getDependsOn();
```

- *Type:* java.util.List<com.hashicorp.cdktf.ITerraformDependable>

---

##### `forEach`<sup>Optional</sup> <a name="forEach" id="@cdktf/provider-databricks.job.JobConfig.property.forEach"></a>

```java
public ITerraformIterator getForEach();
```

- *Type:* com.hashicorp.cdktf.ITerraformIterator

---

##### `lifecycle`<sup>Optional</sup> <a name="lifecycle" id="@cdktf/provider-databricks.job.JobConfig.property.lifecycle"></a>

```java
public TerraformResourceLifecycle getLifecycle();
```

- *Type:* com.hashicorp.cdktf.TerraformResourceLifecycle

---

##### `provider`<sup>Optional</sup> <a name="provider" id="@cdktf/provider-databricks.job.JobConfig.property.provider"></a>

```java
public TerraformProvider getProvider();
```

- *Type:* com.hashicorp.cdktf.TerraformProvider

---

##### `provisioners`<sup>Optional</sup> <a name="provisioners" id="@cdktf/provider-databricks.job.JobConfig.property.provisioners"></a>

```java
public java.lang.Object getProvisioners();
```

- *Type:* java.util.List<com.hashicorp.cdktf.FileProvisioner OR com.hashicorp.cdktf.LocalExecProvisioner OR com.hashicorp.cdktf.RemoteExecProvisioner>

---

##### `alwaysRunning`<sup>Optional</sup> <a name="alwaysRunning" id="@cdktf/provider-databricks.job.JobConfig.property.alwaysRunning"></a>

```java
public java.lang.Object getAlwaysRunning();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#always_running Job#always_running}.

---

##### `continuous`<sup>Optional</sup> <a name="continuous" id="@cdktf/provider-databricks.job.JobConfig.property.continuous"></a>

```java
public JobContinuous getContinuous();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobContinuous">JobContinuous</a>

continuous block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#continuous Job#continuous}

---

##### `dbtTask`<sup>Optional</sup> <a name="dbtTask" id="@cdktf/provider-databricks.job.JobConfig.property.dbtTask"></a>

```java
public JobDbtTask getDbtTask();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobDbtTask">JobDbtTask</a>

dbt_task block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#dbt_task Job#dbt_task}

---

##### `emailNotifications`<sup>Optional</sup> <a name="emailNotifications" id="@cdktf/provider-databricks.job.JobConfig.property.emailNotifications"></a>

```java
public JobEmailNotifications getEmailNotifications();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobEmailNotifications">JobEmailNotifications</a>

email_notifications block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#email_notifications Job#email_notifications}

---

##### `existingClusterId`<sup>Optional</sup> <a name="existingClusterId" id="@cdktf/provider-databricks.job.JobConfig.property.existingClusterId"></a>

```java
public java.lang.String getExistingClusterId();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#existing_cluster_id Job#existing_cluster_id}.

---

##### `format`<sup>Optional</sup> <a name="format" id="@cdktf/provider-databricks.job.JobConfig.property.format"></a>

```java
public java.lang.String getFormat();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#format Job#format}.

---

##### `gitSource`<sup>Optional</sup> <a name="gitSource" id="@cdktf/provider-databricks.job.JobConfig.property.gitSource"></a>

```java
public JobGitSource getGitSource();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobGitSource">JobGitSource</a>

git_source block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#git_source Job#git_source}

---

##### `id`<sup>Optional</sup> <a name="id" id="@cdktf/provider-databricks.job.JobConfig.property.id"></a>

```java
public java.lang.String getId();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#id Job#id}.

Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.

---

##### `jobCluster`<sup>Optional</sup> <a name="jobCluster" id="@cdktf/provider-databricks.job.JobConfig.property.jobCluster"></a>

```java
public java.lang.Object getJobCluster();
```

- *Type:* com.hashicorp.cdktf.IResolvable OR java.util.List<<a href="#@cdktf/provider-databricks.job.JobJobCluster">JobJobCluster</a>>

job_cluster block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#job_cluster Job#job_cluster}

---

##### `library`<sup>Optional</sup> <a name="library" id="@cdktf/provider-databricks.job.JobConfig.property.library"></a>

```java
public java.lang.Object getLibrary();
```

- *Type:* com.hashicorp.cdktf.IResolvable OR java.util.List<<a href="#@cdktf/provider-databricks.job.JobLibrary">JobLibrary</a>>

library block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#library Job#library}

---

##### `maxConcurrentRuns`<sup>Optional</sup> <a name="maxConcurrentRuns" id="@cdktf/provider-databricks.job.JobConfig.property.maxConcurrentRuns"></a>

```java
public java.lang.Number getMaxConcurrentRuns();
```

- *Type:* java.lang.Number

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#max_concurrent_runs Job#max_concurrent_runs}.

---

##### `maxRetries`<sup>Optional</sup> <a name="maxRetries" id="@cdktf/provider-databricks.job.JobConfig.property.maxRetries"></a>

```java
public java.lang.Number getMaxRetries();
```

- *Type:* java.lang.Number

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#max_retries Job#max_retries}.

---

##### `minRetryIntervalMillis`<sup>Optional</sup> <a name="minRetryIntervalMillis" id="@cdktf/provider-databricks.job.JobConfig.property.minRetryIntervalMillis"></a>

```java
public java.lang.Number getMinRetryIntervalMillis();
```

- *Type:* java.lang.Number

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#min_retry_interval_millis Job#min_retry_interval_millis}.

---

##### `name`<sup>Optional</sup> <a name="name" id="@cdktf/provider-databricks.job.JobConfig.property.name"></a>

```java
public java.lang.String getName();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#name Job#name}.

---

##### `newCluster`<sup>Optional</sup> <a name="newCluster" id="@cdktf/provider-databricks.job.JobConfig.property.newCluster"></a>

```java
public JobNewCluster getNewCluster();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobNewCluster">JobNewCluster</a>

new_cluster block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#new_cluster Job#new_cluster}

---

##### `notebookTask`<sup>Optional</sup> <a name="notebookTask" id="@cdktf/provider-databricks.job.JobConfig.property.notebookTask"></a>

```java
public JobNotebookTask getNotebookTask();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobNotebookTask">JobNotebookTask</a>

notebook_task block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#notebook_task Job#notebook_task}

---

##### `pipelineTask`<sup>Optional</sup> <a name="pipelineTask" id="@cdktf/provider-databricks.job.JobConfig.property.pipelineTask"></a>

```java
public JobPipelineTask getPipelineTask();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobPipelineTask">JobPipelineTask</a>

pipeline_task block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#pipeline_task Job#pipeline_task}

---

##### `pythonWheelTask`<sup>Optional</sup> <a name="pythonWheelTask" id="@cdktf/provider-databricks.job.JobConfig.property.pythonWheelTask"></a>

```java
public JobPythonWheelTask getPythonWheelTask();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobPythonWheelTask">JobPythonWheelTask</a>

python_wheel_task block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#python_wheel_task Job#python_wheel_task}

---

##### `queue`<sup>Optional</sup> <a name="queue" id="@cdktf/provider-databricks.job.JobConfig.property.queue"></a>

```java
public JobQueue getQueue();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobQueue">JobQueue</a>

queue block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#queue Job#queue}

---

##### `retryOnTimeout`<sup>Optional</sup> <a name="retryOnTimeout" id="@cdktf/provider-databricks.job.JobConfig.property.retryOnTimeout"></a>

```java
public java.lang.Object getRetryOnTimeout();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#retry_on_timeout Job#retry_on_timeout}.

---

##### `schedule`<sup>Optional</sup> <a name="schedule" id="@cdktf/provider-databricks.job.JobConfig.property.schedule"></a>

```java
public JobSchedule getSchedule();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobSchedule">JobSchedule</a>

schedule block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#schedule Job#schedule}

---

##### `sparkJarTask`<sup>Optional</sup> <a name="sparkJarTask" id="@cdktf/provider-databricks.job.JobConfig.property.sparkJarTask"></a>

```java
public JobSparkJarTask getSparkJarTask();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobSparkJarTask">JobSparkJarTask</a>

spark_jar_task block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#spark_jar_task Job#spark_jar_task}

---

##### `sparkPythonTask`<sup>Optional</sup> <a name="sparkPythonTask" id="@cdktf/provider-databricks.job.JobConfig.property.sparkPythonTask"></a>

```java
public JobSparkPythonTask getSparkPythonTask();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobSparkPythonTask">JobSparkPythonTask</a>

spark_python_task block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#spark_python_task Job#spark_python_task}

---

##### `sparkSubmitTask`<sup>Optional</sup> <a name="sparkSubmitTask" id="@cdktf/provider-databricks.job.JobConfig.property.sparkSubmitTask"></a>

```java
public JobSparkSubmitTask getSparkSubmitTask();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobSparkSubmitTask">JobSparkSubmitTask</a>

spark_submit_task block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#spark_submit_task Job#spark_submit_task}

---

##### `tags`<sup>Optional</sup> <a name="tags" id="@cdktf/provider-databricks.job.JobConfig.property.tags"></a>

```java
public java.util.Map<java.lang.String, java.lang.String> getTags();
```

- *Type:* java.util.Map<java.lang.String, java.lang.String>

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#tags Job#tags}.

---

##### `task`<sup>Optional</sup> <a name="task" id="@cdktf/provider-databricks.job.JobConfig.property.task"></a>

```java
public java.lang.Object getTask();
```

- *Type:* com.hashicorp.cdktf.IResolvable OR java.util.List<<a href="#@cdktf/provider-databricks.job.JobTask">JobTask</a>>

task block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#task Job#task}

---

##### `timeouts`<sup>Optional</sup> <a name="timeouts" id="@cdktf/provider-databricks.job.JobConfig.property.timeouts"></a>

```java
public JobTimeouts getTimeouts();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobTimeouts">JobTimeouts</a>

timeouts block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#timeouts Job#timeouts}

---

##### `timeoutSeconds`<sup>Optional</sup> <a name="timeoutSeconds" id="@cdktf/provider-databricks.job.JobConfig.property.timeoutSeconds"></a>

```java
public java.lang.Number getTimeoutSeconds();
```

- *Type:* java.lang.Number

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#timeout_seconds Job#timeout_seconds}.

---

##### `trigger`<sup>Optional</sup> <a name="trigger" id="@cdktf/provider-databricks.job.JobConfig.property.trigger"></a>

```java
public JobTrigger getTrigger();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobTrigger">JobTrigger</a>

trigger block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#trigger Job#trigger}

---

##### `webhookNotifications`<sup>Optional</sup> <a name="webhookNotifications" id="@cdktf/provider-databricks.job.JobConfig.property.webhookNotifications"></a>

```java
public JobWebhookNotifications getWebhookNotifications();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobWebhookNotifications">JobWebhookNotifications</a>

webhook_notifications block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#webhook_notifications Job#webhook_notifications}

---

### JobContinuous <a name="JobContinuous" id="@cdktf/provider-databricks.job.JobContinuous"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-databricks.job.JobContinuous.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobContinuous;

JobContinuous.builder()
//  .pauseStatus(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobContinuous.property.pauseStatus">pauseStatus</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#pause_status Job#pause_status}. |

---

##### `pauseStatus`<sup>Optional</sup> <a name="pauseStatus" id="@cdktf/provider-databricks.job.JobContinuous.property.pauseStatus"></a>

```java
public java.lang.String getPauseStatus();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#pause_status Job#pause_status}.

---

### JobDbtTask <a name="JobDbtTask" id="@cdktf/provider-databricks.job.JobDbtTask"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-databricks.job.JobDbtTask.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobDbtTask;

JobDbtTask.builder()
    .commands(java.util.List<java.lang.String>)
//  .catalog(java.lang.String)
//  .profilesDirectory(java.lang.String)
//  .projectDirectory(java.lang.String)
//  .schema(java.lang.String)
//  .warehouseId(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobDbtTask.property.commands">commands</a></code> | <code>java.util.List<java.lang.String></code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#commands Job#commands}. |
| <code><a href="#@cdktf/provider-databricks.job.JobDbtTask.property.catalog">catalog</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#catalog Job#catalog}. |
| <code><a href="#@cdktf/provider-databricks.job.JobDbtTask.property.profilesDirectory">profilesDirectory</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#profiles_directory Job#profiles_directory}. |
| <code><a href="#@cdktf/provider-databricks.job.JobDbtTask.property.projectDirectory">projectDirectory</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#project_directory Job#project_directory}. |
| <code><a href="#@cdktf/provider-databricks.job.JobDbtTask.property.schema">schema</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#schema Job#schema}. |
| <code><a href="#@cdktf/provider-databricks.job.JobDbtTask.property.warehouseId">warehouseId</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#warehouse_id Job#warehouse_id}. |

---

##### `commands`<sup>Required</sup> <a name="commands" id="@cdktf/provider-databricks.job.JobDbtTask.property.commands"></a>

```java
public java.util.List<java.lang.String> getCommands();
```

- *Type:* java.util.List<java.lang.String>

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#commands Job#commands}.

---

##### `catalog`<sup>Optional</sup> <a name="catalog" id="@cdktf/provider-databricks.job.JobDbtTask.property.catalog"></a>

```java
public java.lang.String getCatalog();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#catalog Job#catalog}.

---

##### `profilesDirectory`<sup>Optional</sup> <a name="profilesDirectory" id="@cdktf/provider-databricks.job.JobDbtTask.property.profilesDirectory"></a>

```java
public java.lang.String getProfilesDirectory();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#profiles_directory Job#profiles_directory}.

---

##### `projectDirectory`<sup>Optional</sup> <a name="projectDirectory" id="@cdktf/provider-databricks.job.JobDbtTask.property.projectDirectory"></a>

```java
public java.lang.String getProjectDirectory();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#project_directory Job#project_directory}.

---

##### `schema`<sup>Optional</sup> <a name="schema" id="@cdktf/provider-databricks.job.JobDbtTask.property.schema"></a>

```java
public java.lang.String getSchema();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#schema Job#schema}.

---

##### `warehouseId`<sup>Optional</sup> <a name="warehouseId" id="@cdktf/provider-databricks.job.JobDbtTask.property.warehouseId"></a>

```java
public java.lang.String getWarehouseId();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#warehouse_id Job#warehouse_id}.

---

### JobEmailNotifications <a name="JobEmailNotifications" id="@cdktf/provider-databricks.job.JobEmailNotifications"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-databricks.job.JobEmailNotifications.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobEmailNotifications;

JobEmailNotifications.builder()
//  .alertOnLastAttempt(java.lang.Boolean)
//  .alertOnLastAttempt(IResolvable)
//  .noAlertForSkippedRuns(java.lang.Boolean)
//  .noAlertForSkippedRuns(IResolvable)
//  .onFailure(java.util.List<java.lang.String>)
//  .onStart(java.util.List<java.lang.String>)
//  .onSuccess(java.util.List<java.lang.String>)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobEmailNotifications.property.alertOnLastAttempt">alertOnLastAttempt</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#alert_on_last_attempt Job#alert_on_last_attempt}. |
| <code><a href="#@cdktf/provider-databricks.job.JobEmailNotifications.property.noAlertForSkippedRuns">noAlertForSkippedRuns</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#no_alert_for_skipped_runs Job#no_alert_for_skipped_runs}. |
| <code><a href="#@cdktf/provider-databricks.job.JobEmailNotifications.property.onFailure">onFailure</a></code> | <code>java.util.List<java.lang.String></code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#on_failure Job#on_failure}. |
| <code><a href="#@cdktf/provider-databricks.job.JobEmailNotifications.property.onStart">onStart</a></code> | <code>java.util.List<java.lang.String></code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#on_start Job#on_start}. |
| <code><a href="#@cdktf/provider-databricks.job.JobEmailNotifications.property.onSuccess">onSuccess</a></code> | <code>java.util.List<java.lang.String></code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#on_success Job#on_success}. |

---

##### `alertOnLastAttempt`<sup>Optional</sup> <a name="alertOnLastAttempt" id="@cdktf/provider-databricks.job.JobEmailNotifications.property.alertOnLastAttempt"></a>

```java
public java.lang.Object getAlertOnLastAttempt();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#alert_on_last_attempt Job#alert_on_last_attempt}.

---

##### `noAlertForSkippedRuns`<sup>Optional</sup> <a name="noAlertForSkippedRuns" id="@cdktf/provider-databricks.job.JobEmailNotifications.property.noAlertForSkippedRuns"></a>

```java
public java.lang.Object getNoAlertForSkippedRuns();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#no_alert_for_skipped_runs Job#no_alert_for_skipped_runs}.

---

##### `onFailure`<sup>Optional</sup> <a name="onFailure" id="@cdktf/provider-databricks.job.JobEmailNotifications.property.onFailure"></a>

```java
public java.util.List<java.lang.String> getOnFailure();
```

- *Type:* java.util.List<java.lang.String>

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#on_failure Job#on_failure}.

---

##### `onStart`<sup>Optional</sup> <a name="onStart" id="@cdktf/provider-databricks.job.JobEmailNotifications.property.onStart"></a>

```java
public java.util.List<java.lang.String> getOnStart();
```

- *Type:* java.util.List<java.lang.String>

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#on_start Job#on_start}.

---

##### `onSuccess`<sup>Optional</sup> <a name="onSuccess" id="@cdktf/provider-databricks.job.JobEmailNotifications.property.onSuccess"></a>

```java
public java.util.List<java.lang.String> getOnSuccess();
```

- *Type:* java.util.List<java.lang.String>

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#on_success Job#on_success}.

---

### JobGitSource <a name="JobGitSource" id="@cdktf/provider-databricks.job.JobGitSource"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-databricks.job.JobGitSource.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobGitSource;

JobGitSource.builder()
    .url(java.lang.String)
//  .branch(java.lang.String)
//  .commit(java.lang.String)
//  .provider(java.lang.String)
//  .tag(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobGitSource.property.url">url</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#url Job#url}. |
| <code><a href="#@cdktf/provider-databricks.job.JobGitSource.property.branch">branch</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#branch Job#branch}. |
| <code><a href="#@cdktf/provider-databricks.job.JobGitSource.property.commit">commit</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#commit Job#commit}. |
| <code><a href="#@cdktf/provider-databricks.job.JobGitSource.property.provider">provider</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#provider Job#provider}. |
| <code><a href="#@cdktf/provider-databricks.job.JobGitSource.property.tag">tag</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#tag Job#tag}. |

---

##### `url`<sup>Required</sup> <a name="url" id="@cdktf/provider-databricks.job.JobGitSource.property.url"></a>

```java
public java.lang.String getUrl();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#url Job#url}.

---

##### `branch`<sup>Optional</sup> <a name="branch" id="@cdktf/provider-databricks.job.JobGitSource.property.branch"></a>

```java
public java.lang.String getBranch();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#branch Job#branch}.

---

##### `commit`<sup>Optional</sup> <a name="commit" id="@cdktf/provider-databricks.job.JobGitSource.property.commit"></a>

```java
public java.lang.String getCommit();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#commit Job#commit}.

---

##### `provider`<sup>Optional</sup> <a name="provider" id="@cdktf/provider-databricks.job.JobGitSource.property.provider"></a>

```java
public java.lang.String getProvider();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#provider Job#provider}.

---

##### `tag`<sup>Optional</sup> <a name="tag" id="@cdktf/provider-databricks.job.JobGitSource.property.tag"></a>

```java
public java.lang.String getTag();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#tag Job#tag}.

---

### JobJobCluster <a name="JobJobCluster" id="@cdktf/provider-databricks.job.JobJobCluster"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-databricks.job.JobJobCluster.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobJobCluster;

JobJobCluster.builder()
//  .jobClusterKey(java.lang.String)
//  .newCluster(JobJobClusterNewCluster)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobJobCluster.property.jobClusterKey">jobClusterKey</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#job_cluster_key Job#job_cluster_key}. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobCluster.property.newCluster">newCluster</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewCluster">JobJobClusterNewCluster</a></code> | new_cluster block. |

---

##### `jobClusterKey`<sup>Optional</sup> <a name="jobClusterKey" id="@cdktf/provider-databricks.job.JobJobCluster.property.jobClusterKey"></a>

```java
public java.lang.String getJobClusterKey();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#job_cluster_key Job#job_cluster_key}.

---

##### `newCluster`<sup>Optional</sup> <a name="newCluster" id="@cdktf/provider-databricks.job.JobJobCluster.property.newCluster"></a>

```java
public JobJobClusterNewCluster getNewCluster();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobJobClusterNewCluster">JobJobClusterNewCluster</a>

new_cluster block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#new_cluster Job#new_cluster}

---

### JobJobClusterNewCluster <a name="JobJobClusterNewCluster" id="@cdktf/provider-databricks.job.JobJobClusterNewCluster"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-databricks.job.JobJobClusterNewCluster.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobJobClusterNewCluster;

JobJobClusterNewCluster.builder()
    .sparkVersion(java.lang.String)
//  .applyPolicyDefaultValues(java.lang.Boolean)
//  .applyPolicyDefaultValues(IResolvable)
//  .autoscale(JobJobClusterNewClusterAutoscale)
//  .autoterminationMinutes(java.lang.Number)
//  .awsAttributes(JobJobClusterNewClusterAwsAttributes)
//  .azureAttributes(JobJobClusterNewClusterAzureAttributes)
//  .clusterId(java.lang.String)
//  .clusterLogConf(JobJobClusterNewClusterClusterLogConf)
//  .clusterMountInfo(IResolvable)
//  .clusterMountInfo(java.util.List<JobJobClusterNewClusterClusterMountInfo>)
//  .clusterName(java.lang.String)
//  .customTags(java.util.Map<java.lang.String, java.lang.String>)
//  .dataSecurityMode(java.lang.String)
//  .dockerImage(JobJobClusterNewClusterDockerImage)
//  .driverInstancePoolId(java.lang.String)
//  .driverNodeTypeId(java.lang.String)
//  .enableElasticDisk(java.lang.Boolean)
//  .enableElasticDisk(IResolvable)
//  .enableLocalDiskEncryption(java.lang.Boolean)
//  .enableLocalDiskEncryption(IResolvable)
//  .gcpAttributes(JobJobClusterNewClusterGcpAttributes)
//  .idempotencyToken(java.lang.String)
//  .initScripts(IResolvable)
//  .initScripts(java.util.List<JobJobClusterNewClusterInitScripts>)
//  .instancePoolId(java.lang.String)
//  .nodeTypeId(java.lang.String)
//  .numWorkers(java.lang.Number)
//  .policyId(java.lang.String)
//  .runtimeEngine(java.lang.String)
//  .singleUserName(java.lang.String)
//  .sparkConf(java.util.Map<java.lang.String, java.lang.String>)
//  .sparkEnvVars(java.util.Map<java.lang.String, java.lang.String>)
//  .sshPublicKeys(java.util.List<java.lang.String>)
//  .workloadType(JobJobClusterNewClusterWorkloadType)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewCluster.property.sparkVersion">sparkVersion</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#spark_version Job#spark_version}. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewCluster.property.applyPolicyDefaultValues">applyPolicyDefaultValues</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#apply_policy_default_values Job#apply_policy_default_values}. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewCluster.property.autoscale">autoscale</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAutoscale">JobJobClusterNewClusterAutoscale</a></code> | autoscale block. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewCluster.property.autoterminationMinutes">autoterminationMinutes</a></code> | <code>java.lang.Number</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#autotermination_minutes Job#autotermination_minutes}. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewCluster.property.awsAttributes">awsAttributes</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributes">JobJobClusterNewClusterAwsAttributes</a></code> | aws_attributes block. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewCluster.property.azureAttributes">azureAttributes</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAzureAttributes">JobJobClusterNewClusterAzureAttributes</a></code> | azure_attributes block. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewCluster.property.clusterId">clusterId</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#cluster_id Job#cluster_id}. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewCluster.property.clusterLogConf">clusterLogConf</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConf">JobJobClusterNewClusterClusterLogConf</a></code> | cluster_log_conf block. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewCluster.property.clusterMountInfo">clusterMountInfo</a></code> | <code>com.hashicorp.cdktf.IResolvable OR java.util.List<<a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfo">JobJobClusterNewClusterClusterMountInfo</a>></code> | cluster_mount_info block. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewCluster.property.clusterName">clusterName</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#cluster_name Job#cluster_name}. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewCluster.property.customTags">customTags</a></code> | <code>java.util.Map<java.lang.String, java.lang.String></code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#custom_tags Job#custom_tags}. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewCluster.property.dataSecurityMode">dataSecurityMode</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#data_security_mode Job#data_security_mode}. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewCluster.property.dockerImage">dockerImage</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImage">JobJobClusterNewClusterDockerImage</a></code> | docker_image block. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewCluster.property.driverInstancePoolId">driverInstancePoolId</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#driver_instance_pool_id Job#driver_instance_pool_id}. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewCluster.property.driverNodeTypeId">driverNodeTypeId</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#driver_node_type_id Job#driver_node_type_id}. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewCluster.property.enableElasticDisk">enableElasticDisk</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#enable_elastic_disk Job#enable_elastic_disk}. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewCluster.property.enableLocalDiskEncryption">enableLocalDiskEncryption</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#enable_local_disk_encryption Job#enable_local_disk_encryption}. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewCluster.property.gcpAttributes">gcpAttributes</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterGcpAttributes">JobJobClusterNewClusterGcpAttributes</a></code> | gcp_attributes block. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewCluster.property.idempotencyToken">idempotencyToken</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#idempotency_token Job#idempotency_token}. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewCluster.property.initScripts">initScripts</a></code> | <code>com.hashicorp.cdktf.IResolvable OR java.util.List<<a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScripts">JobJobClusterNewClusterInitScripts</a>></code> | init_scripts block. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewCluster.property.instancePoolId">instancePoolId</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#instance_pool_id Job#instance_pool_id}. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewCluster.property.nodeTypeId">nodeTypeId</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#node_type_id Job#node_type_id}. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewCluster.property.numWorkers">numWorkers</a></code> | <code>java.lang.Number</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#num_workers Job#num_workers}. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewCluster.property.policyId">policyId</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#policy_id Job#policy_id}. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewCluster.property.runtimeEngine">runtimeEngine</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#runtime_engine Job#runtime_engine}. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewCluster.property.singleUserName">singleUserName</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#single_user_name Job#single_user_name}. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewCluster.property.sparkConf">sparkConf</a></code> | <code>java.util.Map<java.lang.String, java.lang.String></code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#spark_conf Job#spark_conf}. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewCluster.property.sparkEnvVars">sparkEnvVars</a></code> | <code>java.util.Map<java.lang.String, java.lang.String></code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#spark_env_vars Job#spark_env_vars}. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewCluster.property.sshPublicKeys">sshPublicKeys</a></code> | <code>java.util.List<java.lang.String></code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#ssh_public_keys Job#ssh_public_keys}. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewCluster.property.workloadType">workloadType</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadType">JobJobClusterNewClusterWorkloadType</a></code> | workload_type block. |

---

##### `sparkVersion`<sup>Required</sup> <a name="sparkVersion" id="@cdktf/provider-databricks.job.JobJobClusterNewCluster.property.sparkVersion"></a>

```java
public java.lang.String getSparkVersion();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#spark_version Job#spark_version}.

---

##### `applyPolicyDefaultValues`<sup>Optional</sup> <a name="applyPolicyDefaultValues" id="@cdktf/provider-databricks.job.JobJobClusterNewCluster.property.applyPolicyDefaultValues"></a>

```java
public java.lang.Object getApplyPolicyDefaultValues();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#apply_policy_default_values Job#apply_policy_default_values}.

---

##### `autoscale`<sup>Optional</sup> <a name="autoscale" id="@cdktf/provider-databricks.job.JobJobClusterNewCluster.property.autoscale"></a>

```java
public JobJobClusterNewClusterAutoscale getAutoscale();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAutoscale">JobJobClusterNewClusterAutoscale</a>

autoscale block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#autoscale Job#autoscale}

---

##### `autoterminationMinutes`<sup>Optional</sup> <a name="autoterminationMinutes" id="@cdktf/provider-databricks.job.JobJobClusterNewCluster.property.autoterminationMinutes"></a>

```java
public java.lang.Number getAutoterminationMinutes();
```

- *Type:* java.lang.Number

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#autotermination_minutes Job#autotermination_minutes}.

---

##### `awsAttributes`<sup>Optional</sup> <a name="awsAttributes" id="@cdktf/provider-databricks.job.JobJobClusterNewCluster.property.awsAttributes"></a>

```java
public JobJobClusterNewClusterAwsAttributes getAwsAttributes();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributes">JobJobClusterNewClusterAwsAttributes</a>

aws_attributes block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#aws_attributes Job#aws_attributes}

---

##### `azureAttributes`<sup>Optional</sup> <a name="azureAttributes" id="@cdktf/provider-databricks.job.JobJobClusterNewCluster.property.azureAttributes"></a>

```java
public JobJobClusterNewClusterAzureAttributes getAzureAttributes();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAzureAttributes">JobJobClusterNewClusterAzureAttributes</a>

azure_attributes block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#azure_attributes Job#azure_attributes}

---

##### `clusterId`<sup>Optional</sup> <a name="clusterId" id="@cdktf/provider-databricks.job.JobJobClusterNewCluster.property.clusterId"></a>

```java
public java.lang.String getClusterId();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#cluster_id Job#cluster_id}.

---

##### `clusterLogConf`<sup>Optional</sup> <a name="clusterLogConf" id="@cdktf/provider-databricks.job.JobJobClusterNewCluster.property.clusterLogConf"></a>

```java
public JobJobClusterNewClusterClusterLogConf getClusterLogConf();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConf">JobJobClusterNewClusterClusterLogConf</a>

cluster_log_conf block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#cluster_log_conf Job#cluster_log_conf}

---

##### `clusterMountInfo`<sup>Optional</sup> <a name="clusterMountInfo" id="@cdktf/provider-databricks.job.JobJobClusterNewCluster.property.clusterMountInfo"></a>

```java
public java.lang.Object getClusterMountInfo();
```

- *Type:* com.hashicorp.cdktf.IResolvable OR java.util.List<<a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfo">JobJobClusterNewClusterClusterMountInfo</a>>

cluster_mount_info block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#cluster_mount_info Job#cluster_mount_info}

---

##### `clusterName`<sup>Optional</sup> <a name="clusterName" id="@cdktf/provider-databricks.job.JobJobClusterNewCluster.property.clusterName"></a>

```java
public java.lang.String getClusterName();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#cluster_name Job#cluster_name}.

---

##### `customTags`<sup>Optional</sup> <a name="customTags" id="@cdktf/provider-databricks.job.JobJobClusterNewCluster.property.customTags"></a>

```java
public java.util.Map<java.lang.String, java.lang.String> getCustomTags();
```

- *Type:* java.util.Map<java.lang.String, java.lang.String>

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#custom_tags Job#custom_tags}.

---

##### `dataSecurityMode`<sup>Optional</sup> <a name="dataSecurityMode" id="@cdktf/provider-databricks.job.JobJobClusterNewCluster.property.dataSecurityMode"></a>

```java
public java.lang.String getDataSecurityMode();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#data_security_mode Job#data_security_mode}.

---

##### `dockerImage`<sup>Optional</sup> <a name="dockerImage" id="@cdktf/provider-databricks.job.JobJobClusterNewCluster.property.dockerImage"></a>

```java
public JobJobClusterNewClusterDockerImage getDockerImage();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImage">JobJobClusterNewClusterDockerImage</a>

docker_image block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#docker_image Job#docker_image}

---

##### `driverInstancePoolId`<sup>Optional</sup> <a name="driverInstancePoolId" id="@cdktf/provider-databricks.job.JobJobClusterNewCluster.property.driverInstancePoolId"></a>

```java
public java.lang.String getDriverInstancePoolId();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#driver_instance_pool_id Job#driver_instance_pool_id}.

---

##### `driverNodeTypeId`<sup>Optional</sup> <a name="driverNodeTypeId" id="@cdktf/provider-databricks.job.JobJobClusterNewCluster.property.driverNodeTypeId"></a>

```java
public java.lang.String getDriverNodeTypeId();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#driver_node_type_id Job#driver_node_type_id}.

---

##### `enableElasticDisk`<sup>Optional</sup> <a name="enableElasticDisk" id="@cdktf/provider-databricks.job.JobJobClusterNewCluster.property.enableElasticDisk"></a>

```java
public java.lang.Object getEnableElasticDisk();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#enable_elastic_disk Job#enable_elastic_disk}.

---

##### `enableLocalDiskEncryption`<sup>Optional</sup> <a name="enableLocalDiskEncryption" id="@cdktf/provider-databricks.job.JobJobClusterNewCluster.property.enableLocalDiskEncryption"></a>

```java
public java.lang.Object getEnableLocalDiskEncryption();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#enable_local_disk_encryption Job#enable_local_disk_encryption}.

---

##### `gcpAttributes`<sup>Optional</sup> <a name="gcpAttributes" id="@cdktf/provider-databricks.job.JobJobClusterNewCluster.property.gcpAttributes"></a>

```java
public JobJobClusterNewClusterGcpAttributes getGcpAttributes();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterGcpAttributes">JobJobClusterNewClusterGcpAttributes</a>

gcp_attributes block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#gcp_attributes Job#gcp_attributes}

---

##### `idempotencyToken`<sup>Optional</sup> <a name="idempotencyToken" id="@cdktf/provider-databricks.job.JobJobClusterNewCluster.property.idempotencyToken"></a>

```java
public java.lang.String getIdempotencyToken();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#idempotency_token Job#idempotency_token}.

---

##### `initScripts`<sup>Optional</sup> <a name="initScripts" id="@cdktf/provider-databricks.job.JobJobClusterNewCluster.property.initScripts"></a>

```java
public java.lang.Object getInitScripts();
```

- *Type:* com.hashicorp.cdktf.IResolvable OR java.util.List<<a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScripts">JobJobClusterNewClusterInitScripts</a>>

init_scripts block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#init_scripts Job#init_scripts}

---

##### `instancePoolId`<sup>Optional</sup> <a name="instancePoolId" id="@cdktf/provider-databricks.job.JobJobClusterNewCluster.property.instancePoolId"></a>

```java
public java.lang.String getInstancePoolId();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#instance_pool_id Job#instance_pool_id}.

---

##### `nodeTypeId`<sup>Optional</sup> <a name="nodeTypeId" id="@cdktf/provider-databricks.job.JobJobClusterNewCluster.property.nodeTypeId"></a>

```java
public java.lang.String getNodeTypeId();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#node_type_id Job#node_type_id}.

---

##### `numWorkers`<sup>Optional</sup> <a name="numWorkers" id="@cdktf/provider-databricks.job.JobJobClusterNewCluster.property.numWorkers"></a>

```java
public java.lang.Number getNumWorkers();
```

- *Type:* java.lang.Number

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#num_workers Job#num_workers}.

---

##### `policyId`<sup>Optional</sup> <a name="policyId" id="@cdktf/provider-databricks.job.JobJobClusterNewCluster.property.policyId"></a>

```java
public java.lang.String getPolicyId();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#policy_id Job#policy_id}.

---

##### `runtimeEngine`<sup>Optional</sup> <a name="runtimeEngine" id="@cdktf/provider-databricks.job.JobJobClusterNewCluster.property.runtimeEngine"></a>

```java
public java.lang.String getRuntimeEngine();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#runtime_engine Job#runtime_engine}.

---

##### `singleUserName`<sup>Optional</sup> <a name="singleUserName" id="@cdktf/provider-databricks.job.JobJobClusterNewCluster.property.singleUserName"></a>

```java
public java.lang.String getSingleUserName();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#single_user_name Job#single_user_name}.

---

##### `sparkConf`<sup>Optional</sup> <a name="sparkConf" id="@cdktf/provider-databricks.job.JobJobClusterNewCluster.property.sparkConf"></a>

```java
public java.util.Map<java.lang.String, java.lang.String> getSparkConf();
```

- *Type:* java.util.Map<java.lang.String, java.lang.String>

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#spark_conf Job#spark_conf}.

---

##### `sparkEnvVars`<sup>Optional</sup> <a name="sparkEnvVars" id="@cdktf/provider-databricks.job.JobJobClusterNewCluster.property.sparkEnvVars"></a>

```java
public java.util.Map<java.lang.String, java.lang.String> getSparkEnvVars();
```

- *Type:* java.util.Map<java.lang.String, java.lang.String>

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#spark_env_vars Job#spark_env_vars}.

---

##### `sshPublicKeys`<sup>Optional</sup> <a name="sshPublicKeys" id="@cdktf/provider-databricks.job.JobJobClusterNewCluster.property.sshPublicKeys"></a>

```java
public java.util.List<java.lang.String> getSshPublicKeys();
```

- *Type:* java.util.List<java.lang.String>

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#ssh_public_keys Job#ssh_public_keys}.

---

##### `workloadType`<sup>Optional</sup> <a name="workloadType" id="@cdktf/provider-databricks.job.JobJobClusterNewCluster.property.workloadType"></a>

```java
public JobJobClusterNewClusterWorkloadType getWorkloadType();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadType">JobJobClusterNewClusterWorkloadType</a>

workload_type block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#workload_type Job#workload_type}

---

### JobJobClusterNewClusterAutoscale <a name="JobJobClusterNewClusterAutoscale" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAutoscale"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAutoscale.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobJobClusterNewClusterAutoscale;

JobJobClusterNewClusterAutoscale.builder()
//  .maxWorkers(java.lang.Number)
//  .minWorkers(java.lang.Number)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAutoscale.property.maxWorkers">maxWorkers</a></code> | <code>java.lang.Number</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#max_workers Job#max_workers}. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAutoscale.property.minWorkers">minWorkers</a></code> | <code>java.lang.Number</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#min_workers Job#min_workers}. |

---

##### `maxWorkers`<sup>Optional</sup> <a name="maxWorkers" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAutoscale.property.maxWorkers"></a>

```java
public java.lang.Number getMaxWorkers();
```

- *Type:* java.lang.Number

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#max_workers Job#max_workers}.

---

##### `minWorkers`<sup>Optional</sup> <a name="minWorkers" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAutoscale.property.minWorkers"></a>

```java
public java.lang.Number getMinWorkers();
```

- *Type:* java.lang.Number

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#min_workers Job#min_workers}.

---

### JobJobClusterNewClusterAwsAttributes <a name="JobJobClusterNewClusterAwsAttributes" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributes"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributes.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobJobClusterNewClusterAwsAttributes;

JobJobClusterNewClusterAwsAttributes.builder()
//  .availability(java.lang.String)
//  .ebsVolumeCount(java.lang.Number)
//  .ebsVolumeSize(java.lang.Number)
//  .ebsVolumeType(java.lang.String)
//  .firstOnDemand(java.lang.Number)
//  .instanceProfileArn(java.lang.String)
//  .spotBidPricePercent(java.lang.Number)
//  .zoneId(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributes.property.availability">availability</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#availability Job#availability}. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributes.property.ebsVolumeCount">ebsVolumeCount</a></code> | <code>java.lang.Number</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#ebs_volume_count Job#ebs_volume_count}. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributes.property.ebsVolumeSize">ebsVolumeSize</a></code> | <code>java.lang.Number</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#ebs_volume_size Job#ebs_volume_size}. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributes.property.ebsVolumeType">ebsVolumeType</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#ebs_volume_type Job#ebs_volume_type}. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributes.property.firstOnDemand">firstOnDemand</a></code> | <code>java.lang.Number</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#first_on_demand Job#first_on_demand}. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributes.property.instanceProfileArn">instanceProfileArn</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#instance_profile_arn Job#instance_profile_arn}. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributes.property.spotBidPricePercent">spotBidPricePercent</a></code> | <code>java.lang.Number</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#spot_bid_price_percent Job#spot_bid_price_percent}. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributes.property.zoneId">zoneId</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#zone_id Job#zone_id}. |

---

##### `availability`<sup>Optional</sup> <a name="availability" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributes.property.availability"></a>

```java
public java.lang.String getAvailability();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#availability Job#availability}.

---

##### `ebsVolumeCount`<sup>Optional</sup> <a name="ebsVolumeCount" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributes.property.ebsVolumeCount"></a>

```java
public java.lang.Number getEbsVolumeCount();
```

- *Type:* java.lang.Number

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#ebs_volume_count Job#ebs_volume_count}.

---

##### `ebsVolumeSize`<sup>Optional</sup> <a name="ebsVolumeSize" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributes.property.ebsVolumeSize"></a>

```java
public java.lang.Number getEbsVolumeSize();
```

- *Type:* java.lang.Number

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#ebs_volume_size Job#ebs_volume_size}.

---

##### `ebsVolumeType`<sup>Optional</sup> <a name="ebsVolumeType" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributes.property.ebsVolumeType"></a>

```java
public java.lang.String getEbsVolumeType();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#ebs_volume_type Job#ebs_volume_type}.

---

##### `firstOnDemand`<sup>Optional</sup> <a name="firstOnDemand" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributes.property.firstOnDemand"></a>

```java
public java.lang.Number getFirstOnDemand();
```

- *Type:* java.lang.Number

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#first_on_demand Job#first_on_demand}.

---

##### `instanceProfileArn`<sup>Optional</sup> <a name="instanceProfileArn" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributes.property.instanceProfileArn"></a>

```java
public java.lang.String getInstanceProfileArn();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#instance_profile_arn Job#instance_profile_arn}.

---

##### `spotBidPricePercent`<sup>Optional</sup> <a name="spotBidPricePercent" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributes.property.spotBidPricePercent"></a>

```java
public java.lang.Number getSpotBidPricePercent();
```

- *Type:* java.lang.Number

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#spot_bid_price_percent Job#spot_bid_price_percent}.

---

##### `zoneId`<sup>Optional</sup> <a name="zoneId" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributes.property.zoneId"></a>

```java
public java.lang.String getZoneId();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#zone_id Job#zone_id}.

---

### JobJobClusterNewClusterAzureAttributes <a name="JobJobClusterNewClusterAzureAttributes" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAzureAttributes"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAzureAttributes.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobJobClusterNewClusterAzureAttributes;

JobJobClusterNewClusterAzureAttributes.builder()
//  .availability(java.lang.String)
//  .firstOnDemand(java.lang.Number)
//  .spotBidMaxPrice(java.lang.Number)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAzureAttributes.property.availability">availability</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#availability Job#availability}. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAzureAttributes.property.firstOnDemand">firstOnDemand</a></code> | <code>java.lang.Number</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#first_on_demand Job#first_on_demand}. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAzureAttributes.property.spotBidMaxPrice">spotBidMaxPrice</a></code> | <code>java.lang.Number</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#spot_bid_max_price Job#spot_bid_max_price}. |

---

##### `availability`<sup>Optional</sup> <a name="availability" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAzureAttributes.property.availability"></a>

```java
public java.lang.String getAvailability();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#availability Job#availability}.

---

##### `firstOnDemand`<sup>Optional</sup> <a name="firstOnDemand" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAzureAttributes.property.firstOnDemand"></a>

```java
public java.lang.Number getFirstOnDemand();
```

- *Type:* java.lang.Number

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#first_on_demand Job#first_on_demand}.

---

##### `spotBidMaxPrice`<sup>Optional</sup> <a name="spotBidMaxPrice" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAzureAttributes.property.spotBidMaxPrice"></a>

```java
public java.lang.Number getSpotBidMaxPrice();
```

- *Type:* java.lang.Number

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#spot_bid_max_price Job#spot_bid_max_price}.

---

### JobJobClusterNewClusterClusterLogConf <a name="JobJobClusterNewClusterClusterLogConf" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConf"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConf.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobJobClusterNewClusterClusterLogConf;

JobJobClusterNewClusterClusterLogConf.builder()
//  .dbfs(JobJobClusterNewClusterClusterLogConfDbfs)
//  .s3(JobJobClusterNewClusterClusterLogConfS3)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConf.property.dbfs">dbfs</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfDbfs">JobJobClusterNewClusterClusterLogConfDbfs</a></code> | dbfs block. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConf.property.s3">s3</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3">JobJobClusterNewClusterClusterLogConfS3</a></code> | s3 block. |

---

##### `dbfs`<sup>Optional</sup> <a name="dbfs" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConf.property.dbfs"></a>

```java
public JobJobClusterNewClusterClusterLogConfDbfs getDbfs();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfDbfs">JobJobClusterNewClusterClusterLogConfDbfs</a>

dbfs block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#dbfs Job#dbfs}

---

##### `s3`<sup>Optional</sup> <a name="s3" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConf.property.s3"></a>

```java
public JobJobClusterNewClusterClusterLogConfS3 getS3();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3">JobJobClusterNewClusterClusterLogConfS3</a>

s3 block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#s3 Job#s3}

---

### JobJobClusterNewClusterClusterLogConfDbfs <a name="JobJobClusterNewClusterClusterLogConfDbfs" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfDbfs"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfDbfs.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobJobClusterNewClusterClusterLogConfDbfs;

JobJobClusterNewClusterClusterLogConfDbfs.builder()
    .destination(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfDbfs.property.destination">destination</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#destination Job#destination}. |

---

##### `destination`<sup>Required</sup> <a name="destination" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfDbfs.property.destination"></a>

```java
public java.lang.String getDestination();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#destination Job#destination}.

---

### JobJobClusterNewClusterClusterLogConfS3 <a name="JobJobClusterNewClusterClusterLogConfS3" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobJobClusterNewClusterClusterLogConfS3;

JobJobClusterNewClusterClusterLogConfS3.builder()
    .destination(java.lang.String)
//  .cannedAcl(java.lang.String)
//  .enableEncryption(java.lang.Boolean)
//  .enableEncryption(IResolvable)
//  .encryptionType(java.lang.String)
//  .endpoint(java.lang.String)
//  .kmsKey(java.lang.String)
//  .region(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3.property.destination">destination</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#destination Job#destination}. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3.property.cannedAcl">cannedAcl</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#canned_acl Job#canned_acl}. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3.property.enableEncryption">enableEncryption</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#enable_encryption Job#enable_encryption}. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3.property.encryptionType">encryptionType</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#encryption_type Job#encryption_type}. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3.property.endpoint">endpoint</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#endpoint Job#endpoint}. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3.property.kmsKey">kmsKey</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#kms_key Job#kms_key}. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3.property.region">region</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#region Job#region}. |

---

##### `destination`<sup>Required</sup> <a name="destination" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3.property.destination"></a>

```java
public java.lang.String getDestination();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#destination Job#destination}.

---

##### `cannedAcl`<sup>Optional</sup> <a name="cannedAcl" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3.property.cannedAcl"></a>

```java
public java.lang.String getCannedAcl();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#canned_acl Job#canned_acl}.

---

##### `enableEncryption`<sup>Optional</sup> <a name="enableEncryption" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3.property.enableEncryption"></a>

```java
public java.lang.Object getEnableEncryption();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#enable_encryption Job#enable_encryption}.

---

##### `encryptionType`<sup>Optional</sup> <a name="encryptionType" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3.property.encryptionType"></a>

```java
public java.lang.String getEncryptionType();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#encryption_type Job#encryption_type}.

---

##### `endpoint`<sup>Optional</sup> <a name="endpoint" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3.property.endpoint"></a>

```java
public java.lang.String getEndpoint();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#endpoint Job#endpoint}.

---

##### `kmsKey`<sup>Optional</sup> <a name="kmsKey" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3.property.kmsKey"></a>

```java
public java.lang.String getKmsKey();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#kms_key Job#kms_key}.

---

##### `region`<sup>Optional</sup> <a name="region" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3.property.region"></a>

```java
public java.lang.String getRegion();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#region Job#region}.

---

### JobJobClusterNewClusterClusterMountInfo <a name="JobJobClusterNewClusterClusterMountInfo" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfo"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfo.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobJobClusterNewClusterClusterMountInfo;

JobJobClusterNewClusterClusterMountInfo.builder()
    .localMountDirPath(java.lang.String)
    .networkFilesystemInfo(JobJobClusterNewClusterClusterMountInfoNetworkFilesystemInfo)
//  .remoteMountDirPath(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfo.property.localMountDirPath">localMountDirPath</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#local_mount_dir_path Job#local_mount_dir_path}. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfo.property.networkFilesystemInfo">networkFilesystemInfo</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoNetworkFilesystemInfo">JobJobClusterNewClusterClusterMountInfoNetworkFilesystemInfo</a></code> | network_filesystem_info block. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfo.property.remoteMountDirPath">remoteMountDirPath</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#remote_mount_dir_path Job#remote_mount_dir_path}. |

---

##### `localMountDirPath`<sup>Required</sup> <a name="localMountDirPath" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfo.property.localMountDirPath"></a>

```java
public java.lang.String getLocalMountDirPath();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#local_mount_dir_path Job#local_mount_dir_path}.

---

##### `networkFilesystemInfo`<sup>Required</sup> <a name="networkFilesystemInfo" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfo.property.networkFilesystemInfo"></a>

```java
public JobJobClusterNewClusterClusterMountInfoNetworkFilesystemInfo getNetworkFilesystemInfo();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoNetworkFilesystemInfo">JobJobClusterNewClusterClusterMountInfoNetworkFilesystemInfo</a>

network_filesystem_info block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#network_filesystem_info Job#network_filesystem_info}

---

##### `remoteMountDirPath`<sup>Optional</sup> <a name="remoteMountDirPath" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfo.property.remoteMountDirPath"></a>

```java
public java.lang.String getRemoteMountDirPath();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#remote_mount_dir_path Job#remote_mount_dir_path}.

---

### JobJobClusterNewClusterClusterMountInfoNetworkFilesystemInfo <a name="JobJobClusterNewClusterClusterMountInfoNetworkFilesystemInfo" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoNetworkFilesystemInfo"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoNetworkFilesystemInfo.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobJobClusterNewClusterClusterMountInfoNetworkFilesystemInfo;

JobJobClusterNewClusterClusterMountInfoNetworkFilesystemInfo.builder()
    .serverAddress(java.lang.String)
//  .mountOptions(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoNetworkFilesystemInfo.property.serverAddress">serverAddress</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#server_address Job#server_address}. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoNetworkFilesystemInfo.property.mountOptions">mountOptions</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#mount_options Job#mount_options}. |

---

##### `serverAddress`<sup>Required</sup> <a name="serverAddress" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoNetworkFilesystemInfo.property.serverAddress"></a>

```java
public java.lang.String getServerAddress();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#server_address Job#server_address}.

---

##### `mountOptions`<sup>Optional</sup> <a name="mountOptions" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoNetworkFilesystemInfo.property.mountOptions"></a>

```java
public java.lang.String getMountOptions();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#mount_options Job#mount_options}.

---

### JobJobClusterNewClusterDockerImage <a name="JobJobClusterNewClusterDockerImage" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImage"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImage.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobJobClusterNewClusterDockerImage;

JobJobClusterNewClusterDockerImage.builder()
    .url(java.lang.String)
//  .basicAuth(JobJobClusterNewClusterDockerImageBasicAuth)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImage.property.url">url</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#url Job#url}. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImage.property.basicAuth">basicAuth</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageBasicAuth">JobJobClusterNewClusterDockerImageBasicAuth</a></code> | basic_auth block. |

---

##### `url`<sup>Required</sup> <a name="url" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImage.property.url"></a>

```java
public java.lang.String getUrl();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#url Job#url}.

---

##### `basicAuth`<sup>Optional</sup> <a name="basicAuth" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImage.property.basicAuth"></a>

```java
public JobJobClusterNewClusterDockerImageBasicAuth getBasicAuth();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageBasicAuth">JobJobClusterNewClusterDockerImageBasicAuth</a>

basic_auth block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#basic_auth Job#basic_auth}

---

### JobJobClusterNewClusterDockerImageBasicAuth <a name="JobJobClusterNewClusterDockerImageBasicAuth" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageBasicAuth"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageBasicAuth.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobJobClusterNewClusterDockerImageBasicAuth;

JobJobClusterNewClusterDockerImageBasicAuth.builder()
    .password(java.lang.String)
    .username(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageBasicAuth.property.password">password</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#password Job#password}. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageBasicAuth.property.username">username</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#username Job#username}. |

---

##### `password`<sup>Required</sup> <a name="password" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageBasicAuth.property.password"></a>

```java
public java.lang.String getPassword();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#password Job#password}.

---

##### `username`<sup>Required</sup> <a name="username" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageBasicAuth.property.username"></a>

```java
public java.lang.String getUsername();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#username Job#username}.

---

### JobJobClusterNewClusterGcpAttributes <a name="JobJobClusterNewClusterGcpAttributes" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterGcpAttributes"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterGcpAttributes.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobJobClusterNewClusterGcpAttributes;

JobJobClusterNewClusterGcpAttributes.builder()
//  .availability(java.lang.String)
//  .bootDiskSize(java.lang.Number)
//  .googleServiceAccount(java.lang.String)
//  .usePreemptibleExecutors(java.lang.Boolean)
//  .usePreemptibleExecutors(IResolvable)
//  .zoneId(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterGcpAttributes.property.availability">availability</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#availability Job#availability}. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterGcpAttributes.property.bootDiskSize">bootDiskSize</a></code> | <code>java.lang.Number</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#boot_disk_size Job#boot_disk_size}. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterGcpAttributes.property.googleServiceAccount">googleServiceAccount</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#google_service_account Job#google_service_account}. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterGcpAttributes.property.usePreemptibleExecutors">usePreemptibleExecutors</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#use_preemptible_executors Job#use_preemptible_executors}. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterGcpAttributes.property.zoneId">zoneId</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#zone_id Job#zone_id}. |

---

##### `availability`<sup>Optional</sup> <a name="availability" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterGcpAttributes.property.availability"></a>

```java
public java.lang.String getAvailability();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#availability Job#availability}.

---

##### `bootDiskSize`<sup>Optional</sup> <a name="bootDiskSize" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterGcpAttributes.property.bootDiskSize"></a>

```java
public java.lang.Number getBootDiskSize();
```

- *Type:* java.lang.Number

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#boot_disk_size Job#boot_disk_size}.

---

##### `googleServiceAccount`<sup>Optional</sup> <a name="googleServiceAccount" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterGcpAttributes.property.googleServiceAccount"></a>

```java
public java.lang.String getGoogleServiceAccount();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#google_service_account Job#google_service_account}.

---

##### `usePreemptibleExecutors`<sup>Optional</sup> <a name="usePreemptibleExecutors" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterGcpAttributes.property.usePreemptibleExecutors"></a>

```java
public java.lang.Object getUsePreemptibleExecutors();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#use_preemptible_executors Job#use_preemptible_executors}.

---

##### `zoneId`<sup>Optional</sup> <a name="zoneId" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterGcpAttributes.property.zoneId"></a>

```java
public java.lang.String getZoneId();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#zone_id Job#zone_id}.

---

### JobJobClusterNewClusterInitScripts <a name="JobJobClusterNewClusterInitScripts" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScripts"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScripts.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobJobClusterNewClusterInitScripts;

JobJobClusterNewClusterInitScripts.builder()
//  .abfss(JobJobClusterNewClusterInitScriptsAbfss)
//  .dbfs(JobJobClusterNewClusterInitScriptsDbfs)
//  .file(JobJobClusterNewClusterInitScriptsFile)
//  .gcs(JobJobClusterNewClusterInitScriptsGcs)
//  .s3(JobJobClusterNewClusterInitScriptsS3)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScripts.property.abfss">abfss</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsAbfss">JobJobClusterNewClusterInitScriptsAbfss</a></code> | abfss block. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScripts.property.dbfs">dbfs</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsDbfs">JobJobClusterNewClusterInitScriptsDbfs</a></code> | dbfs block. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScripts.property.file">file</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsFile">JobJobClusterNewClusterInitScriptsFile</a></code> | file block. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScripts.property.gcs">gcs</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsGcs">JobJobClusterNewClusterInitScriptsGcs</a></code> | gcs block. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScripts.property.s3">s3</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3">JobJobClusterNewClusterInitScriptsS3</a></code> | s3 block. |

---

##### `abfss`<sup>Optional</sup> <a name="abfss" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScripts.property.abfss"></a>

```java
public JobJobClusterNewClusterInitScriptsAbfss getAbfss();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsAbfss">JobJobClusterNewClusterInitScriptsAbfss</a>

abfss block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#abfss Job#abfss}

---

##### `dbfs`<sup>Optional</sup> <a name="dbfs" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScripts.property.dbfs"></a>

```java
public JobJobClusterNewClusterInitScriptsDbfs getDbfs();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsDbfs">JobJobClusterNewClusterInitScriptsDbfs</a>

dbfs block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#dbfs Job#dbfs}

---

##### `file`<sup>Optional</sup> <a name="file" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScripts.property.file"></a>

```java
public JobJobClusterNewClusterInitScriptsFile getFile();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsFile">JobJobClusterNewClusterInitScriptsFile</a>

file block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#file Job#file}

---

##### `gcs`<sup>Optional</sup> <a name="gcs" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScripts.property.gcs"></a>

```java
public JobJobClusterNewClusterInitScriptsGcs getGcs();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsGcs">JobJobClusterNewClusterInitScriptsGcs</a>

gcs block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#gcs Job#gcs}

---

##### `s3`<sup>Optional</sup> <a name="s3" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScripts.property.s3"></a>

```java
public JobJobClusterNewClusterInitScriptsS3 getS3();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3">JobJobClusterNewClusterInitScriptsS3</a>

s3 block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#s3 Job#s3}

---

### JobJobClusterNewClusterInitScriptsAbfss <a name="JobJobClusterNewClusterInitScriptsAbfss" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsAbfss"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsAbfss.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobJobClusterNewClusterInitScriptsAbfss;

JobJobClusterNewClusterInitScriptsAbfss.builder()
//  .destination(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsAbfss.property.destination">destination</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#destination Job#destination}. |

---

##### `destination`<sup>Optional</sup> <a name="destination" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsAbfss.property.destination"></a>

```java
public java.lang.String getDestination();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#destination Job#destination}.

---

### JobJobClusterNewClusterInitScriptsDbfs <a name="JobJobClusterNewClusterInitScriptsDbfs" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsDbfs"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsDbfs.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobJobClusterNewClusterInitScriptsDbfs;

JobJobClusterNewClusterInitScriptsDbfs.builder()
    .destination(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsDbfs.property.destination">destination</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#destination Job#destination}. |

---

##### `destination`<sup>Required</sup> <a name="destination" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsDbfs.property.destination"></a>

```java
public java.lang.String getDestination();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#destination Job#destination}.

---

### JobJobClusterNewClusterInitScriptsFile <a name="JobJobClusterNewClusterInitScriptsFile" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsFile"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsFile.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobJobClusterNewClusterInitScriptsFile;

JobJobClusterNewClusterInitScriptsFile.builder()
//  .destination(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsFile.property.destination">destination</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#destination Job#destination}. |

---

##### `destination`<sup>Optional</sup> <a name="destination" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsFile.property.destination"></a>

```java
public java.lang.String getDestination();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#destination Job#destination}.

---

### JobJobClusterNewClusterInitScriptsGcs <a name="JobJobClusterNewClusterInitScriptsGcs" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsGcs"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsGcs.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobJobClusterNewClusterInitScriptsGcs;

JobJobClusterNewClusterInitScriptsGcs.builder()
//  .destination(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsGcs.property.destination">destination</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#destination Job#destination}. |

---

##### `destination`<sup>Optional</sup> <a name="destination" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsGcs.property.destination"></a>

```java
public java.lang.String getDestination();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#destination Job#destination}.

---

### JobJobClusterNewClusterInitScriptsS3 <a name="JobJobClusterNewClusterInitScriptsS3" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobJobClusterNewClusterInitScriptsS3;

JobJobClusterNewClusterInitScriptsS3.builder()
    .destination(java.lang.String)
//  .cannedAcl(java.lang.String)
//  .enableEncryption(java.lang.Boolean)
//  .enableEncryption(IResolvable)
//  .encryptionType(java.lang.String)
//  .endpoint(java.lang.String)
//  .kmsKey(java.lang.String)
//  .region(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3.property.destination">destination</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#destination Job#destination}. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3.property.cannedAcl">cannedAcl</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#canned_acl Job#canned_acl}. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3.property.enableEncryption">enableEncryption</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#enable_encryption Job#enable_encryption}. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3.property.encryptionType">encryptionType</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#encryption_type Job#encryption_type}. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3.property.endpoint">endpoint</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#endpoint Job#endpoint}. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3.property.kmsKey">kmsKey</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#kms_key Job#kms_key}. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3.property.region">region</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#region Job#region}. |

---

##### `destination`<sup>Required</sup> <a name="destination" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3.property.destination"></a>

```java
public java.lang.String getDestination();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#destination Job#destination}.

---

##### `cannedAcl`<sup>Optional</sup> <a name="cannedAcl" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3.property.cannedAcl"></a>

```java
public java.lang.String getCannedAcl();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#canned_acl Job#canned_acl}.

---

##### `enableEncryption`<sup>Optional</sup> <a name="enableEncryption" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3.property.enableEncryption"></a>

```java
public java.lang.Object getEnableEncryption();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#enable_encryption Job#enable_encryption}.

---

##### `encryptionType`<sup>Optional</sup> <a name="encryptionType" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3.property.encryptionType"></a>

```java
public java.lang.String getEncryptionType();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#encryption_type Job#encryption_type}.

---

##### `endpoint`<sup>Optional</sup> <a name="endpoint" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3.property.endpoint"></a>

```java
public java.lang.String getEndpoint();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#endpoint Job#endpoint}.

---

##### `kmsKey`<sup>Optional</sup> <a name="kmsKey" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3.property.kmsKey"></a>

```java
public java.lang.String getKmsKey();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#kms_key Job#kms_key}.

---

##### `region`<sup>Optional</sup> <a name="region" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3.property.region"></a>

```java
public java.lang.String getRegion();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#region Job#region}.

---

### JobJobClusterNewClusterWorkloadType <a name="JobJobClusterNewClusterWorkloadType" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadType"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadType.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobJobClusterNewClusterWorkloadType;

JobJobClusterNewClusterWorkloadType.builder()
    .clients(JobJobClusterNewClusterWorkloadTypeClients)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadType.property.clients">clients</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeClients">JobJobClusterNewClusterWorkloadTypeClients</a></code> | clients block. |

---

##### `clients`<sup>Required</sup> <a name="clients" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadType.property.clients"></a>

```java
public JobJobClusterNewClusterWorkloadTypeClients getClients();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeClients">JobJobClusterNewClusterWorkloadTypeClients</a>

clients block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#clients Job#clients}

---

### JobJobClusterNewClusterWorkloadTypeClients <a name="JobJobClusterNewClusterWorkloadTypeClients" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeClients"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeClients.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobJobClusterNewClusterWorkloadTypeClients;

JobJobClusterNewClusterWorkloadTypeClients.builder()
//  .jobs(java.lang.Boolean)
//  .jobs(IResolvable)
//  .notebooks(java.lang.Boolean)
//  .notebooks(IResolvable)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeClients.property.jobs">jobs</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#jobs Job#jobs}. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeClients.property.notebooks">notebooks</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#notebooks Job#notebooks}. |

---

##### `jobs`<sup>Optional</sup> <a name="jobs" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeClients.property.jobs"></a>

```java
public java.lang.Object getJobs();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#jobs Job#jobs}.

---

##### `notebooks`<sup>Optional</sup> <a name="notebooks" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeClients.property.notebooks"></a>

```java
public java.lang.Object getNotebooks();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#notebooks Job#notebooks}.

---

### JobLibrary <a name="JobLibrary" id="@cdktf/provider-databricks.job.JobLibrary"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-databricks.job.JobLibrary.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobLibrary;

JobLibrary.builder()
//  .cran(JobLibraryCran)
//  .egg(java.lang.String)
//  .jar(java.lang.String)
//  .maven(JobLibraryMaven)
//  .pypi(JobLibraryPypi)
//  .whl(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobLibrary.property.cran">cran</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobLibraryCran">JobLibraryCran</a></code> | cran block. |
| <code><a href="#@cdktf/provider-databricks.job.JobLibrary.property.egg">egg</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#egg Job#egg}. |
| <code><a href="#@cdktf/provider-databricks.job.JobLibrary.property.jar">jar</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#jar Job#jar}. |
| <code><a href="#@cdktf/provider-databricks.job.JobLibrary.property.maven">maven</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobLibraryMaven">JobLibraryMaven</a></code> | maven block. |
| <code><a href="#@cdktf/provider-databricks.job.JobLibrary.property.pypi">pypi</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobLibraryPypi">JobLibraryPypi</a></code> | pypi block. |
| <code><a href="#@cdktf/provider-databricks.job.JobLibrary.property.whl">whl</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#whl Job#whl}. |

---

##### `cran`<sup>Optional</sup> <a name="cran" id="@cdktf/provider-databricks.job.JobLibrary.property.cran"></a>

```java
public JobLibraryCran getCran();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobLibraryCran">JobLibraryCran</a>

cran block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#cran Job#cran}

---

##### `egg`<sup>Optional</sup> <a name="egg" id="@cdktf/provider-databricks.job.JobLibrary.property.egg"></a>

```java
public java.lang.String getEgg();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#egg Job#egg}.

---

##### `jar`<sup>Optional</sup> <a name="jar" id="@cdktf/provider-databricks.job.JobLibrary.property.jar"></a>

```java
public java.lang.String getJar();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#jar Job#jar}.

---

##### `maven`<sup>Optional</sup> <a name="maven" id="@cdktf/provider-databricks.job.JobLibrary.property.maven"></a>

```java
public JobLibraryMaven getMaven();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobLibraryMaven">JobLibraryMaven</a>

maven block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#maven Job#maven}

---

##### `pypi`<sup>Optional</sup> <a name="pypi" id="@cdktf/provider-databricks.job.JobLibrary.property.pypi"></a>

```java
public JobLibraryPypi getPypi();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobLibraryPypi">JobLibraryPypi</a>

pypi block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#pypi Job#pypi}

---

##### `whl`<sup>Optional</sup> <a name="whl" id="@cdktf/provider-databricks.job.JobLibrary.property.whl"></a>

```java
public java.lang.String getWhl();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#whl Job#whl}.

---

### JobLibraryCran <a name="JobLibraryCran" id="@cdktf/provider-databricks.job.JobLibraryCran"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-databricks.job.JobLibraryCran.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobLibraryCran;

JobLibraryCran.builder()
    .package(java.lang.String)
//  .repo(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryCran.property.package">package</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#package Job#package}. |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryCran.property.repo">repo</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#repo Job#repo}. |

---

##### `package`<sup>Required</sup> <a name="package" id="@cdktf/provider-databricks.job.JobLibraryCran.property.package"></a>

```java
public java.lang.String getPackage();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#package Job#package}.

---

##### `repo`<sup>Optional</sup> <a name="repo" id="@cdktf/provider-databricks.job.JobLibraryCran.property.repo"></a>

```java
public java.lang.String getRepo();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#repo Job#repo}.

---

### JobLibraryMaven <a name="JobLibraryMaven" id="@cdktf/provider-databricks.job.JobLibraryMaven"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-databricks.job.JobLibraryMaven.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobLibraryMaven;

JobLibraryMaven.builder()
    .coordinates(java.lang.String)
//  .exclusions(java.util.List<java.lang.String>)
//  .repo(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryMaven.property.coordinates">coordinates</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#coordinates Job#coordinates}. |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryMaven.property.exclusions">exclusions</a></code> | <code>java.util.List<java.lang.String></code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#exclusions Job#exclusions}. |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryMaven.property.repo">repo</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#repo Job#repo}. |

---

##### `coordinates`<sup>Required</sup> <a name="coordinates" id="@cdktf/provider-databricks.job.JobLibraryMaven.property.coordinates"></a>

```java
public java.lang.String getCoordinates();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#coordinates Job#coordinates}.

---

##### `exclusions`<sup>Optional</sup> <a name="exclusions" id="@cdktf/provider-databricks.job.JobLibraryMaven.property.exclusions"></a>

```java
public java.util.List<java.lang.String> getExclusions();
```

- *Type:* java.util.List<java.lang.String>

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#exclusions Job#exclusions}.

---

##### `repo`<sup>Optional</sup> <a name="repo" id="@cdktf/provider-databricks.job.JobLibraryMaven.property.repo"></a>

```java
public java.lang.String getRepo();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#repo Job#repo}.

---

### JobLibraryPypi <a name="JobLibraryPypi" id="@cdktf/provider-databricks.job.JobLibraryPypi"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-databricks.job.JobLibraryPypi.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobLibraryPypi;

JobLibraryPypi.builder()
    .package(java.lang.String)
//  .repo(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryPypi.property.package">package</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#package Job#package}. |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryPypi.property.repo">repo</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#repo Job#repo}. |

---

##### `package`<sup>Required</sup> <a name="package" id="@cdktf/provider-databricks.job.JobLibraryPypi.property.package"></a>

```java
public java.lang.String getPackage();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#package Job#package}.

---

##### `repo`<sup>Optional</sup> <a name="repo" id="@cdktf/provider-databricks.job.JobLibraryPypi.property.repo"></a>

```java
public java.lang.String getRepo();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#repo Job#repo}.

---

### JobNewCluster <a name="JobNewCluster" id="@cdktf/provider-databricks.job.JobNewCluster"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-databricks.job.JobNewCluster.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobNewCluster;

JobNewCluster.builder()
    .sparkVersion(java.lang.String)
//  .applyPolicyDefaultValues(java.lang.Boolean)
//  .applyPolicyDefaultValues(IResolvable)
//  .autoscale(JobNewClusterAutoscale)
//  .autoterminationMinutes(java.lang.Number)
//  .awsAttributes(JobNewClusterAwsAttributes)
//  .azureAttributes(JobNewClusterAzureAttributes)
//  .clusterId(java.lang.String)
//  .clusterLogConf(JobNewClusterClusterLogConf)
//  .clusterMountInfo(IResolvable)
//  .clusterMountInfo(java.util.List<JobNewClusterClusterMountInfo>)
//  .clusterName(java.lang.String)
//  .customTags(java.util.Map<java.lang.String, java.lang.String>)
//  .dataSecurityMode(java.lang.String)
//  .dockerImage(JobNewClusterDockerImage)
//  .driverInstancePoolId(java.lang.String)
//  .driverNodeTypeId(java.lang.String)
//  .enableElasticDisk(java.lang.Boolean)
//  .enableElasticDisk(IResolvable)
//  .enableLocalDiskEncryption(java.lang.Boolean)
//  .enableLocalDiskEncryption(IResolvable)
//  .gcpAttributes(JobNewClusterGcpAttributes)
//  .idempotencyToken(java.lang.String)
//  .initScripts(IResolvable)
//  .initScripts(java.util.List<JobNewClusterInitScripts>)
//  .instancePoolId(java.lang.String)
//  .nodeTypeId(java.lang.String)
//  .numWorkers(java.lang.Number)
//  .policyId(java.lang.String)
//  .runtimeEngine(java.lang.String)
//  .singleUserName(java.lang.String)
//  .sparkConf(java.util.Map<java.lang.String, java.lang.String>)
//  .sparkEnvVars(java.util.Map<java.lang.String, java.lang.String>)
//  .sshPublicKeys(java.util.List<java.lang.String>)
//  .workloadType(JobNewClusterWorkloadType)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobNewCluster.property.sparkVersion">sparkVersion</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#spark_version Job#spark_version}. |
| <code><a href="#@cdktf/provider-databricks.job.JobNewCluster.property.applyPolicyDefaultValues">applyPolicyDefaultValues</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#apply_policy_default_values Job#apply_policy_default_values}. |
| <code><a href="#@cdktf/provider-databricks.job.JobNewCluster.property.autoscale">autoscale</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobNewClusterAutoscale">JobNewClusterAutoscale</a></code> | autoscale block. |
| <code><a href="#@cdktf/provider-databricks.job.JobNewCluster.property.autoterminationMinutes">autoterminationMinutes</a></code> | <code>java.lang.Number</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#autotermination_minutes Job#autotermination_minutes}. |
| <code><a href="#@cdktf/provider-databricks.job.JobNewCluster.property.awsAttributes">awsAttributes</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobNewClusterAwsAttributes">JobNewClusterAwsAttributes</a></code> | aws_attributes block. |
| <code><a href="#@cdktf/provider-databricks.job.JobNewCluster.property.azureAttributes">azureAttributes</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobNewClusterAzureAttributes">JobNewClusterAzureAttributes</a></code> | azure_attributes block. |
| <code><a href="#@cdktf/provider-databricks.job.JobNewCluster.property.clusterId">clusterId</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#cluster_id Job#cluster_id}. |
| <code><a href="#@cdktf/provider-databricks.job.JobNewCluster.property.clusterLogConf">clusterLogConf</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobNewClusterClusterLogConf">JobNewClusterClusterLogConf</a></code> | cluster_log_conf block. |
| <code><a href="#@cdktf/provider-databricks.job.JobNewCluster.property.clusterMountInfo">clusterMountInfo</a></code> | <code>com.hashicorp.cdktf.IResolvable OR java.util.List<<a href="#@cdktf/provider-databricks.job.JobNewClusterClusterMountInfo">JobNewClusterClusterMountInfo</a>></code> | cluster_mount_info block. |
| <code><a href="#@cdktf/provider-databricks.job.JobNewCluster.property.clusterName">clusterName</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#cluster_name Job#cluster_name}. |
| <code><a href="#@cdktf/provider-databricks.job.JobNewCluster.property.customTags">customTags</a></code> | <code>java.util.Map<java.lang.String, java.lang.String></code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#custom_tags Job#custom_tags}. |
| <code><a href="#@cdktf/provider-databricks.job.JobNewCluster.property.dataSecurityMode">dataSecurityMode</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#data_security_mode Job#data_security_mode}. |
| <code><a href="#@cdktf/provider-databricks.job.JobNewCluster.property.dockerImage">dockerImage</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobNewClusterDockerImage">JobNewClusterDockerImage</a></code> | docker_image block. |
| <code><a href="#@cdktf/provider-databricks.job.JobNewCluster.property.driverInstancePoolId">driverInstancePoolId</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#driver_instance_pool_id Job#driver_instance_pool_id}. |
| <code><a href="#@cdktf/provider-databricks.job.JobNewCluster.property.driverNodeTypeId">driverNodeTypeId</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#driver_node_type_id Job#driver_node_type_id}. |
| <code><a href="#@cdktf/provider-databricks.job.JobNewCluster.property.enableElasticDisk">enableElasticDisk</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#enable_elastic_disk Job#enable_elastic_disk}. |
| <code><a href="#@cdktf/provider-databricks.job.JobNewCluster.property.enableLocalDiskEncryption">enableLocalDiskEncryption</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#enable_local_disk_encryption Job#enable_local_disk_encryption}. |
| <code><a href="#@cdktf/provider-databricks.job.JobNewCluster.property.gcpAttributes">gcpAttributes</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobNewClusterGcpAttributes">JobNewClusterGcpAttributes</a></code> | gcp_attributes block. |
| <code><a href="#@cdktf/provider-databricks.job.JobNewCluster.property.idempotencyToken">idempotencyToken</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#idempotency_token Job#idempotency_token}. |
| <code><a href="#@cdktf/provider-databricks.job.JobNewCluster.property.initScripts">initScripts</a></code> | <code>com.hashicorp.cdktf.IResolvable OR java.util.List<<a href="#@cdktf/provider-databricks.job.JobNewClusterInitScripts">JobNewClusterInitScripts</a>></code> | init_scripts block. |
| <code><a href="#@cdktf/provider-databricks.job.JobNewCluster.property.instancePoolId">instancePoolId</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#instance_pool_id Job#instance_pool_id}. |
| <code><a href="#@cdktf/provider-databricks.job.JobNewCluster.property.nodeTypeId">nodeTypeId</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#node_type_id Job#node_type_id}. |
| <code><a href="#@cdktf/provider-databricks.job.JobNewCluster.property.numWorkers">numWorkers</a></code> | <code>java.lang.Number</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#num_workers Job#num_workers}. |
| <code><a href="#@cdktf/provider-databricks.job.JobNewCluster.property.policyId">policyId</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#policy_id Job#policy_id}. |
| <code><a href="#@cdktf/provider-databricks.job.JobNewCluster.property.runtimeEngine">runtimeEngine</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#runtime_engine Job#runtime_engine}. |
| <code><a href="#@cdktf/provider-databricks.job.JobNewCluster.property.singleUserName">singleUserName</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#single_user_name Job#single_user_name}. |
| <code><a href="#@cdktf/provider-databricks.job.JobNewCluster.property.sparkConf">sparkConf</a></code> | <code>java.util.Map<java.lang.String, java.lang.String></code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#spark_conf Job#spark_conf}. |
| <code><a href="#@cdktf/provider-databricks.job.JobNewCluster.property.sparkEnvVars">sparkEnvVars</a></code> | <code>java.util.Map<java.lang.String, java.lang.String></code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#spark_env_vars Job#spark_env_vars}. |
| <code><a href="#@cdktf/provider-databricks.job.JobNewCluster.property.sshPublicKeys">sshPublicKeys</a></code> | <code>java.util.List<java.lang.String></code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#ssh_public_keys Job#ssh_public_keys}. |
| <code><a href="#@cdktf/provider-databricks.job.JobNewCluster.property.workloadType">workloadType</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobNewClusterWorkloadType">JobNewClusterWorkloadType</a></code> | workload_type block. |

---

##### `sparkVersion`<sup>Required</sup> <a name="sparkVersion" id="@cdktf/provider-databricks.job.JobNewCluster.property.sparkVersion"></a>

```java
public java.lang.String getSparkVersion();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#spark_version Job#spark_version}.

---

##### `applyPolicyDefaultValues`<sup>Optional</sup> <a name="applyPolicyDefaultValues" id="@cdktf/provider-databricks.job.JobNewCluster.property.applyPolicyDefaultValues"></a>

```java
public java.lang.Object getApplyPolicyDefaultValues();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#apply_policy_default_values Job#apply_policy_default_values}.

---

##### `autoscale`<sup>Optional</sup> <a name="autoscale" id="@cdktf/provider-databricks.job.JobNewCluster.property.autoscale"></a>

```java
public JobNewClusterAutoscale getAutoscale();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobNewClusterAutoscale">JobNewClusterAutoscale</a>

autoscale block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#autoscale Job#autoscale}

---

##### `autoterminationMinutes`<sup>Optional</sup> <a name="autoterminationMinutes" id="@cdktf/provider-databricks.job.JobNewCluster.property.autoterminationMinutes"></a>

```java
public java.lang.Number getAutoterminationMinutes();
```

- *Type:* java.lang.Number

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#autotermination_minutes Job#autotermination_minutes}.

---

##### `awsAttributes`<sup>Optional</sup> <a name="awsAttributes" id="@cdktf/provider-databricks.job.JobNewCluster.property.awsAttributes"></a>

```java
public JobNewClusterAwsAttributes getAwsAttributes();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobNewClusterAwsAttributes">JobNewClusterAwsAttributes</a>

aws_attributes block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#aws_attributes Job#aws_attributes}

---

##### `azureAttributes`<sup>Optional</sup> <a name="azureAttributes" id="@cdktf/provider-databricks.job.JobNewCluster.property.azureAttributes"></a>

```java
public JobNewClusterAzureAttributes getAzureAttributes();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobNewClusterAzureAttributes">JobNewClusterAzureAttributes</a>

azure_attributes block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#azure_attributes Job#azure_attributes}

---

##### `clusterId`<sup>Optional</sup> <a name="clusterId" id="@cdktf/provider-databricks.job.JobNewCluster.property.clusterId"></a>

```java
public java.lang.String getClusterId();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#cluster_id Job#cluster_id}.

---

##### `clusterLogConf`<sup>Optional</sup> <a name="clusterLogConf" id="@cdktf/provider-databricks.job.JobNewCluster.property.clusterLogConf"></a>

```java
public JobNewClusterClusterLogConf getClusterLogConf();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobNewClusterClusterLogConf">JobNewClusterClusterLogConf</a>

cluster_log_conf block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#cluster_log_conf Job#cluster_log_conf}

---

##### `clusterMountInfo`<sup>Optional</sup> <a name="clusterMountInfo" id="@cdktf/provider-databricks.job.JobNewCluster.property.clusterMountInfo"></a>

```java
public java.lang.Object getClusterMountInfo();
```

- *Type:* com.hashicorp.cdktf.IResolvable OR java.util.List<<a href="#@cdktf/provider-databricks.job.JobNewClusterClusterMountInfo">JobNewClusterClusterMountInfo</a>>

cluster_mount_info block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#cluster_mount_info Job#cluster_mount_info}

---

##### `clusterName`<sup>Optional</sup> <a name="clusterName" id="@cdktf/provider-databricks.job.JobNewCluster.property.clusterName"></a>

```java
public java.lang.String getClusterName();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#cluster_name Job#cluster_name}.

---

##### `customTags`<sup>Optional</sup> <a name="customTags" id="@cdktf/provider-databricks.job.JobNewCluster.property.customTags"></a>

```java
public java.util.Map<java.lang.String, java.lang.String> getCustomTags();
```

- *Type:* java.util.Map<java.lang.String, java.lang.String>

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#custom_tags Job#custom_tags}.

---

##### `dataSecurityMode`<sup>Optional</sup> <a name="dataSecurityMode" id="@cdktf/provider-databricks.job.JobNewCluster.property.dataSecurityMode"></a>

```java
public java.lang.String getDataSecurityMode();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#data_security_mode Job#data_security_mode}.

---

##### `dockerImage`<sup>Optional</sup> <a name="dockerImage" id="@cdktf/provider-databricks.job.JobNewCluster.property.dockerImage"></a>

```java
public JobNewClusterDockerImage getDockerImage();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobNewClusterDockerImage">JobNewClusterDockerImage</a>

docker_image block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#docker_image Job#docker_image}

---

##### `driverInstancePoolId`<sup>Optional</sup> <a name="driverInstancePoolId" id="@cdktf/provider-databricks.job.JobNewCluster.property.driverInstancePoolId"></a>

```java
public java.lang.String getDriverInstancePoolId();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#driver_instance_pool_id Job#driver_instance_pool_id}.

---

##### `driverNodeTypeId`<sup>Optional</sup> <a name="driverNodeTypeId" id="@cdktf/provider-databricks.job.JobNewCluster.property.driverNodeTypeId"></a>

```java
public java.lang.String getDriverNodeTypeId();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#driver_node_type_id Job#driver_node_type_id}.

---

##### `enableElasticDisk`<sup>Optional</sup> <a name="enableElasticDisk" id="@cdktf/provider-databricks.job.JobNewCluster.property.enableElasticDisk"></a>

```java
public java.lang.Object getEnableElasticDisk();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#enable_elastic_disk Job#enable_elastic_disk}.

---

##### `enableLocalDiskEncryption`<sup>Optional</sup> <a name="enableLocalDiskEncryption" id="@cdktf/provider-databricks.job.JobNewCluster.property.enableLocalDiskEncryption"></a>

```java
public java.lang.Object getEnableLocalDiskEncryption();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#enable_local_disk_encryption Job#enable_local_disk_encryption}.

---

##### `gcpAttributes`<sup>Optional</sup> <a name="gcpAttributes" id="@cdktf/provider-databricks.job.JobNewCluster.property.gcpAttributes"></a>

```java
public JobNewClusterGcpAttributes getGcpAttributes();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobNewClusterGcpAttributes">JobNewClusterGcpAttributes</a>

gcp_attributes block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#gcp_attributes Job#gcp_attributes}

---

##### `idempotencyToken`<sup>Optional</sup> <a name="idempotencyToken" id="@cdktf/provider-databricks.job.JobNewCluster.property.idempotencyToken"></a>

```java
public java.lang.String getIdempotencyToken();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#idempotency_token Job#idempotency_token}.

---

##### `initScripts`<sup>Optional</sup> <a name="initScripts" id="@cdktf/provider-databricks.job.JobNewCluster.property.initScripts"></a>

```java
public java.lang.Object getInitScripts();
```

- *Type:* com.hashicorp.cdktf.IResolvable OR java.util.List<<a href="#@cdktf/provider-databricks.job.JobNewClusterInitScripts">JobNewClusterInitScripts</a>>

init_scripts block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#init_scripts Job#init_scripts}

---

##### `instancePoolId`<sup>Optional</sup> <a name="instancePoolId" id="@cdktf/provider-databricks.job.JobNewCluster.property.instancePoolId"></a>

```java
public java.lang.String getInstancePoolId();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#instance_pool_id Job#instance_pool_id}.

---

##### `nodeTypeId`<sup>Optional</sup> <a name="nodeTypeId" id="@cdktf/provider-databricks.job.JobNewCluster.property.nodeTypeId"></a>

```java
public java.lang.String getNodeTypeId();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#node_type_id Job#node_type_id}.

---

##### `numWorkers`<sup>Optional</sup> <a name="numWorkers" id="@cdktf/provider-databricks.job.JobNewCluster.property.numWorkers"></a>

```java
public java.lang.Number getNumWorkers();
```

- *Type:* java.lang.Number

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#num_workers Job#num_workers}.

---

##### `policyId`<sup>Optional</sup> <a name="policyId" id="@cdktf/provider-databricks.job.JobNewCluster.property.policyId"></a>

```java
public java.lang.String getPolicyId();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#policy_id Job#policy_id}.

---

##### `runtimeEngine`<sup>Optional</sup> <a name="runtimeEngine" id="@cdktf/provider-databricks.job.JobNewCluster.property.runtimeEngine"></a>

```java
public java.lang.String getRuntimeEngine();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#runtime_engine Job#runtime_engine}.

---

##### `singleUserName`<sup>Optional</sup> <a name="singleUserName" id="@cdktf/provider-databricks.job.JobNewCluster.property.singleUserName"></a>

```java
public java.lang.String getSingleUserName();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#single_user_name Job#single_user_name}.

---

##### `sparkConf`<sup>Optional</sup> <a name="sparkConf" id="@cdktf/provider-databricks.job.JobNewCluster.property.sparkConf"></a>

```java
public java.util.Map<java.lang.String, java.lang.String> getSparkConf();
```

- *Type:* java.util.Map<java.lang.String, java.lang.String>

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#spark_conf Job#spark_conf}.

---

##### `sparkEnvVars`<sup>Optional</sup> <a name="sparkEnvVars" id="@cdktf/provider-databricks.job.JobNewCluster.property.sparkEnvVars"></a>

```java
public java.util.Map<java.lang.String, java.lang.String> getSparkEnvVars();
```

- *Type:* java.util.Map<java.lang.String, java.lang.String>

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#spark_env_vars Job#spark_env_vars}.

---

##### `sshPublicKeys`<sup>Optional</sup> <a name="sshPublicKeys" id="@cdktf/provider-databricks.job.JobNewCluster.property.sshPublicKeys"></a>

```java
public java.util.List<java.lang.String> getSshPublicKeys();
```

- *Type:* java.util.List<java.lang.String>

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#ssh_public_keys Job#ssh_public_keys}.

---

##### `workloadType`<sup>Optional</sup> <a name="workloadType" id="@cdktf/provider-databricks.job.JobNewCluster.property.workloadType"></a>

```java
public JobNewClusterWorkloadType getWorkloadType();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobNewClusterWorkloadType">JobNewClusterWorkloadType</a>

workload_type block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#workload_type Job#workload_type}

---

### JobNewClusterAutoscale <a name="JobNewClusterAutoscale" id="@cdktf/provider-databricks.job.JobNewClusterAutoscale"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-databricks.job.JobNewClusterAutoscale.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobNewClusterAutoscale;

JobNewClusterAutoscale.builder()
//  .maxWorkers(java.lang.Number)
//  .minWorkers(java.lang.Number)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobNewClusterAutoscale.property.maxWorkers">maxWorkers</a></code> | <code>java.lang.Number</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#max_workers Job#max_workers}. |
| <code><a href="#@cdktf/provider-databricks.job.JobNewClusterAutoscale.property.minWorkers">minWorkers</a></code> | <code>java.lang.Number</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#min_workers Job#min_workers}. |

---

##### `maxWorkers`<sup>Optional</sup> <a name="maxWorkers" id="@cdktf/provider-databricks.job.JobNewClusterAutoscale.property.maxWorkers"></a>

```java
public java.lang.Number getMaxWorkers();
```

- *Type:* java.lang.Number

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#max_workers Job#max_workers}.

---

##### `minWorkers`<sup>Optional</sup> <a name="minWorkers" id="@cdktf/provider-databricks.job.JobNewClusterAutoscale.property.minWorkers"></a>

```java
public java.lang.Number getMinWorkers();
```

- *Type:* java.lang.Number

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#min_workers Job#min_workers}.

---

### JobNewClusterAwsAttributes <a name="JobNewClusterAwsAttributes" id="@cdktf/provider-databricks.job.JobNewClusterAwsAttributes"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-databricks.job.JobNewClusterAwsAttributes.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobNewClusterAwsAttributes;

JobNewClusterAwsAttributes.builder()
//  .availability(java.lang.String)
//  .ebsVolumeCount(java.lang.Number)
//  .ebsVolumeSize(java.lang.Number)
//  .ebsVolumeType(java.lang.String)
//  .firstOnDemand(java.lang.Number)
//  .instanceProfileArn(java.lang.String)
//  .spotBidPricePercent(java.lang.Number)
//  .zoneId(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobNewClusterAwsAttributes.property.availability">availability</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#availability Job#availability}. |
| <code><a href="#@cdktf/provider-databricks.job.JobNewClusterAwsAttributes.property.ebsVolumeCount">ebsVolumeCount</a></code> | <code>java.lang.Number</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#ebs_volume_count Job#ebs_volume_count}. |
| <code><a href="#@cdktf/provider-databricks.job.JobNewClusterAwsAttributes.property.ebsVolumeSize">ebsVolumeSize</a></code> | <code>java.lang.Number</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#ebs_volume_size Job#ebs_volume_size}. |
| <code><a href="#@cdktf/provider-databricks.job.JobNewClusterAwsAttributes.property.ebsVolumeType">ebsVolumeType</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#ebs_volume_type Job#ebs_volume_type}. |
| <code><a href="#@cdktf/provider-databricks.job.JobNewClusterAwsAttributes.property.firstOnDemand">firstOnDemand</a></code> | <code>java.lang.Number</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#first_on_demand Job#first_on_demand}. |
| <code><a href="#@cdktf/provider-databricks.job.JobNewClusterAwsAttributes.property.instanceProfileArn">instanceProfileArn</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#instance_profile_arn Job#instance_profile_arn}. |
| <code><a href="#@cdktf/provider-databricks.job.JobNewClusterAwsAttributes.property.spotBidPricePercent">spotBidPricePercent</a></code> | <code>java.lang.Number</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#spot_bid_price_percent Job#spot_bid_price_percent}. |
| <code><a href="#@cdktf/provider-databricks.job.JobNewClusterAwsAttributes.property.zoneId">zoneId</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#zone_id Job#zone_id}. |

---

##### `availability`<sup>Optional</sup> <a name="availability" id="@cdktf/provider-databricks.job.JobNewClusterAwsAttributes.property.availability"></a>

```java
public java.lang.String getAvailability();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#availability Job#availability}.

---

##### `ebsVolumeCount`<sup>Optional</sup> <a name="ebsVolumeCount" id="@cdktf/provider-databricks.job.JobNewClusterAwsAttributes.property.ebsVolumeCount"></a>

```java
public java.lang.Number getEbsVolumeCount();
```

- *Type:* java.lang.Number

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#ebs_volume_count Job#ebs_volume_count}.

---

##### `ebsVolumeSize`<sup>Optional</sup> <a name="ebsVolumeSize" id="@cdktf/provider-databricks.job.JobNewClusterAwsAttributes.property.ebsVolumeSize"></a>

```java
public java.lang.Number getEbsVolumeSize();
```

- *Type:* java.lang.Number

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#ebs_volume_size Job#ebs_volume_size}.

---

##### `ebsVolumeType`<sup>Optional</sup> <a name="ebsVolumeType" id="@cdktf/provider-databricks.job.JobNewClusterAwsAttributes.property.ebsVolumeType"></a>

```java
public java.lang.String getEbsVolumeType();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#ebs_volume_type Job#ebs_volume_type}.

---

##### `firstOnDemand`<sup>Optional</sup> <a name="firstOnDemand" id="@cdktf/provider-databricks.job.JobNewClusterAwsAttributes.property.firstOnDemand"></a>

```java
public java.lang.Number getFirstOnDemand();
```

- *Type:* java.lang.Number

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#first_on_demand Job#first_on_demand}.

---

##### `instanceProfileArn`<sup>Optional</sup> <a name="instanceProfileArn" id="@cdktf/provider-databricks.job.JobNewClusterAwsAttributes.property.instanceProfileArn"></a>

```java
public java.lang.String getInstanceProfileArn();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#instance_profile_arn Job#instance_profile_arn}.

---

##### `spotBidPricePercent`<sup>Optional</sup> <a name="spotBidPricePercent" id="@cdktf/provider-databricks.job.JobNewClusterAwsAttributes.property.spotBidPricePercent"></a>

```java
public java.lang.Number getSpotBidPricePercent();
```

- *Type:* java.lang.Number

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#spot_bid_price_percent Job#spot_bid_price_percent}.

---

##### `zoneId`<sup>Optional</sup> <a name="zoneId" id="@cdktf/provider-databricks.job.JobNewClusterAwsAttributes.property.zoneId"></a>

```java
public java.lang.String getZoneId();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#zone_id Job#zone_id}.

---

### JobNewClusterAzureAttributes <a name="JobNewClusterAzureAttributes" id="@cdktf/provider-databricks.job.JobNewClusterAzureAttributes"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-databricks.job.JobNewClusterAzureAttributes.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobNewClusterAzureAttributes;

JobNewClusterAzureAttributes.builder()
//  .availability(java.lang.String)
//  .firstOnDemand(java.lang.Number)
//  .spotBidMaxPrice(java.lang.Number)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobNewClusterAzureAttributes.property.availability">availability</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#availability Job#availability}. |
| <code><a href="#@cdktf/provider-databricks.job.JobNewClusterAzureAttributes.property.firstOnDemand">firstOnDemand</a></code> | <code>java.lang.Number</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#first_on_demand Job#first_on_demand}. |
| <code><a href="#@cdktf/provider-databricks.job.JobNewClusterAzureAttributes.property.spotBidMaxPrice">spotBidMaxPrice</a></code> | <code>java.lang.Number</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#spot_bid_max_price Job#spot_bid_max_price}. |

---

##### `availability`<sup>Optional</sup> <a name="availability" id="@cdktf/provider-databricks.job.JobNewClusterAzureAttributes.property.availability"></a>

```java
public java.lang.String getAvailability();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#availability Job#availability}.

---

##### `firstOnDemand`<sup>Optional</sup> <a name="firstOnDemand" id="@cdktf/provider-databricks.job.JobNewClusterAzureAttributes.property.firstOnDemand"></a>

```java
public java.lang.Number getFirstOnDemand();
```

- *Type:* java.lang.Number

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#first_on_demand Job#first_on_demand}.

---

##### `spotBidMaxPrice`<sup>Optional</sup> <a name="spotBidMaxPrice" id="@cdktf/provider-databricks.job.JobNewClusterAzureAttributes.property.spotBidMaxPrice"></a>

```java
public java.lang.Number getSpotBidMaxPrice();
```

- *Type:* java.lang.Number

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#spot_bid_max_price Job#spot_bid_max_price}.

---

### JobNewClusterClusterLogConf <a name="JobNewClusterClusterLogConf" id="@cdktf/provider-databricks.job.JobNewClusterClusterLogConf"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-databricks.job.JobNewClusterClusterLogConf.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobNewClusterClusterLogConf;

JobNewClusterClusterLogConf.builder()
//  .dbfs(JobNewClusterClusterLogConfDbfs)
//  .s3(JobNewClusterClusterLogConfS3)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobNewClusterClusterLogConf.property.dbfs">dbfs</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobNewClusterClusterLogConfDbfs">JobNewClusterClusterLogConfDbfs</a></code> | dbfs block. |
| <code><a href="#@cdktf/provider-databricks.job.JobNewClusterClusterLogConf.property.s3">s3</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobNewClusterClusterLogConfS3">JobNewClusterClusterLogConfS3</a></code> | s3 block. |

---

##### `dbfs`<sup>Optional</sup> <a name="dbfs" id="@cdktf/provider-databricks.job.JobNewClusterClusterLogConf.property.dbfs"></a>

```java
public JobNewClusterClusterLogConfDbfs getDbfs();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobNewClusterClusterLogConfDbfs">JobNewClusterClusterLogConfDbfs</a>

dbfs block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#dbfs Job#dbfs}

---

##### `s3`<sup>Optional</sup> <a name="s3" id="@cdktf/provider-databricks.job.JobNewClusterClusterLogConf.property.s3"></a>

```java
public JobNewClusterClusterLogConfS3 getS3();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobNewClusterClusterLogConfS3">JobNewClusterClusterLogConfS3</a>

s3 block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#s3 Job#s3}

---

### JobNewClusterClusterLogConfDbfs <a name="JobNewClusterClusterLogConfDbfs" id="@cdktf/provider-databricks.job.JobNewClusterClusterLogConfDbfs"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-databricks.job.JobNewClusterClusterLogConfDbfs.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobNewClusterClusterLogConfDbfs;

JobNewClusterClusterLogConfDbfs.builder()
    .destination(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobNewClusterClusterLogConfDbfs.property.destination">destination</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#destination Job#destination}. |

---

##### `destination`<sup>Required</sup> <a name="destination" id="@cdktf/provider-databricks.job.JobNewClusterClusterLogConfDbfs.property.destination"></a>

```java
public java.lang.String getDestination();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#destination Job#destination}.

---

### JobNewClusterClusterLogConfS3 <a name="JobNewClusterClusterLogConfS3" id="@cdktf/provider-databricks.job.JobNewClusterClusterLogConfS3"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-databricks.job.JobNewClusterClusterLogConfS3.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobNewClusterClusterLogConfS3;

JobNewClusterClusterLogConfS3.builder()
    .destination(java.lang.String)
//  .cannedAcl(java.lang.String)
//  .enableEncryption(java.lang.Boolean)
//  .enableEncryption(IResolvable)
//  .encryptionType(java.lang.String)
//  .endpoint(java.lang.String)
//  .kmsKey(java.lang.String)
//  .region(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobNewClusterClusterLogConfS3.property.destination">destination</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#destination Job#destination}. |
| <code><a href="#@cdktf/provider-databricks.job.JobNewClusterClusterLogConfS3.property.cannedAcl">cannedAcl</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#canned_acl Job#canned_acl}. |
| <code><a href="#@cdktf/provider-databricks.job.JobNewClusterClusterLogConfS3.property.enableEncryption">enableEncryption</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#enable_encryption Job#enable_encryption}. |
| <code><a href="#@cdktf/provider-databricks.job.JobNewClusterClusterLogConfS3.property.encryptionType">encryptionType</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#encryption_type Job#encryption_type}. |
| <code><a href="#@cdktf/provider-databricks.job.JobNewClusterClusterLogConfS3.property.endpoint">endpoint</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#endpoint Job#endpoint}. |
| <code><a href="#@cdktf/provider-databricks.job.JobNewClusterClusterLogConfS3.property.kmsKey">kmsKey</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#kms_key Job#kms_key}. |
| <code><a href="#@cdktf/provider-databricks.job.JobNewClusterClusterLogConfS3.property.region">region</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#region Job#region}. |

---

##### `destination`<sup>Required</sup> <a name="destination" id="@cdktf/provider-databricks.job.JobNewClusterClusterLogConfS3.property.destination"></a>

```java
public java.lang.String getDestination();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#destination Job#destination}.

---

##### `cannedAcl`<sup>Optional</sup> <a name="cannedAcl" id="@cdktf/provider-databricks.job.JobNewClusterClusterLogConfS3.property.cannedAcl"></a>

```java
public java.lang.String getCannedAcl();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#canned_acl Job#canned_acl}.

---

##### `enableEncryption`<sup>Optional</sup> <a name="enableEncryption" id="@cdktf/provider-databricks.job.JobNewClusterClusterLogConfS3.property.enableEncryption"></a>

```java
public java.lang.Object getEnableEncryption();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#enable_encryption Job#enable_encryption}.

---

##### `encryptionType`<sup>Optional</sup> <a name="encryptionType" id="@cdktf/provider-databricks.job.JobNewClusterClusterLogConfS3.property.encryptionType"></a>

```java
public java.lang.String getEncryptionType();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#encryption_type Job#encryption_type}.

---

##### `endpoint`<sup>Optional</sup> <a name="endpoint" id="@cdktf/provider-databricks.job.JobNewClusterClusterLogConfS3.property.endpoint"></a>

```java
public java.lang.String getEndpoint();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#endpoint Job#endpoint}.

---

##### `kmsKey`<sup>Optional</sup> <a name="kmsKey" id="@cdktf/provider-databricks.job.JobNewClusterClusterLogConfS3.property.kmsKey"></a>

```java
public java.lang.String getKmsKey();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#kms_key Job#kms_key}.

---

##### `region`<sup>Optional</sup> <a name="region" id="@cdktf/provider-databricks.job.JobNewClusterClusterLogConfS3.property.region"></a>

```java
public java.lang.String getRegion();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#region Job#region}.

---

### JobNewClusterClusterMountInfo <a name="JobNewClusterClusterMountInfo" id="@cdktf/provider-databricks.job.JobNewClusterClusterMountInfo"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-databricks.job.JobNewClusterClusterMountInfo.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobNewClusterClusterMountInfo;

JobNewClusterClusterMountInfo.builder()
    .localMountDirPath(java.lang.String)
    .networkFilesystemInfo(JobNewClusterClusterMountInfoNetworkFilesystemInfo)
//  .remoteMountDirPath(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobNewClusterClusterMountInfo.property.localMountDirPath">localMountDirPath</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#local_mount_dir_path Job#local_mount_dir_path}. |
| <code><a href="#@cdktf/provider-databricks.job.JobNewClusterClusterMountInfo.property.networkFilesystemInfo">networkFilesystemInfo</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobNewClusterClusterMountInfoNetworkFilesystemInfo">JobNewClusterClusterMountInfoNetworkFilesystemInfo</a></code> | network_filesystem_info block. |
| <code><a href="#@cdktf/provider-databricks.job.JobNewClusterClusterMountInfo.property.remoteMountDirPath">remoteMountDirPath</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#remote_mount_dir_path Job#remote_mount_dir_path}. |

---

##### `localMountDirPath`<sup>Required</sup> <a name="localMountDirPath" id="@cdktf/provider-databricks.job.JobNewClusterClusterMountInfo.property.localMountDirPath"></a>

```java
public java.lang.String getLocalMountDirPath();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#local_mount_dir_path Job#local_mount_dir_path}.

---

##### `networkFilesystemInfo`<sup>Required</sup> <a name="networkFilesystemInfo" id="@cdktf/provider-databricks.job.JobNewClusterClusterMountInfo.property.networkFilesystemInfo"></a>

```java
public JobNewClusterClusterMountInfoNetworkFilesystemInfo getNetworkFilesystemInfo();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobNewClusterClusterMountInfoNetworkFilesystemInfo">JobNewClusterClusterMountInfoNetworkFilesystemInfo</a>

network_filesystem_info block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#network_filesystem_info Job#network_filesystem_info}

---

##### `remoteMountDirPath`<sup>Optional</sup> <a name="remoteMountDirPath" id="@cdktf/provider-databricks.job.JobNewClusterClusterMountInfo.property.remoteMountDirPath"></a>

```java
public java.lang.String getRemoteMountDirPath();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#remote_mount_dir_path Job#remote_mount_dir_path}.

---

### JobNewClusterClusterMountInfoNetworkFilesystemInfo <a name="JobNewClusterClusterMountInfoNetworkFilesystemInfo" id="@cdktf/provider-databricks.job.JobNewClusterClusterMountInfoNetworkFilesystemInfo"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-databricks.job.JobNewClusterClusterMountInfoNetworkFilesystemInfo.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobNewClusterClusterMountInfoNetworkFilesystemInfo;

JobNewClusterClusterMountInfoNetworkFilesystemInfo.builder()
    .serverAddress(java.lang.String)
//  .mountOptions(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobNewClusterClusterMountInfoNetworkFilesystemInfo.property.serverAddress">serverAddress</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#server_address Job#server_address}. |
| <code><a href="#@cdktf/provider-databricks.job.JobNewClusterClusterMountInfoNetworkFilesystemInfo.property.mountOptions">mountOptions</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#mount_options Job#mount_options}. |

---

##### `serverAddress`<sup>Required</sup> <a name="serverAddress" id="@cdktf/provider-databricks.job.JobNewClusterClusterMountInfoNetworkFilesystemInfo.property.serverAddress"></a>

```java
public java.lang.String getServerAddress();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#server_address Job#server_address}.

---

##### `mountOptions`<sup>Optional</sup> <a name="mountOptions" id="@cdktf/provider-databricks.job.JobNewClusterClusterMountInfoNetworkFilesystemInfo.property.mountOptions"></a>

```java
public java.lang.String getMountOptions();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#mount_options Job#mount_options}.

---

### JobNewClusterDockerImage <a name="JobNewClusterDockerImage" id="@cdktf/provider-databricks.job.JobNewClusterDockerImage"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-databricks.job.JobNewClusterDockerImage.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobNewClusterDockerImage;

JobNewClusterDockerImage.builder()
    .url(java.lang.String)
//  .basicAuth(JobNewClusterDockerImageBasicAuth)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobNewClusterDockerImage.property.url">url</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#url Job#url}. |
| <code><a href="#@cdktf/provider-databricks.job.JobNewClusterDockerImage.property.basicAuth">basicAuth</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobNewClusterDockerImageBasicAuth">JobNewClusterDockerImageBasicAuth</a></code> | basic_auth block. |

---

##### `url`<sup>Required</sup> <a name="url" id="@cdktf/provider-databricks.job.JobNewClusterDockerImage.property.url"></a>

```java
public java.lang.String getUrl();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#url Job#url}.

---

##### `basicAuth`<sup>Optional</sup> <a name="basicAuth" id="@cdktf/provider-databricks.job.JobNewClusterDockerImage.property.basicAuth"></a>

```java
public JobNewClusterDockerImageBasicAuth getBasicAuth();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobNewClusterDockerImageBasicAuth">JobNewClusterDockerImageBasicAuth</a>

basic_auth block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#basic_auth Job#basic_auth}

---

### JobNewClusterDockerImageBasicAuth <a name="JobNewClusterDockerImageBasicAuth" id="@cdktf/provider-databricks.job.JobNewClusterDockerImageBasicAuth"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-databricks.job.JobNewClusterDockerImageBasicAuth.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobNewClusterDockerImageBasicAuth;

JobNewClusterDockerImageBasicAuth.builder()
    .password(java.lang.String)
    .username(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobNewClusterDockerImageBasicAuth.property.password">password</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#password Job#password}. |
| <code><a href="#@cdktf/provider-databricks.job.JobNewClusterDockerImageBasicAuth.property.username">username</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#username Job#username}. |

---

##### `password`<sup>Required</sup> <a name="password" id="@cdktf/provider-databricks.job.JobNewClusterDockerImageBasicAuth.property.password"></a>

```java
public java.lang.String getPassword();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#password Job#password}.

---

##### `username`<sup>Required</sup> <a name="username" id="@cdktf/provider-databricks.job.JobNewClusterDockerImageBasicAuth.property.username"></a>

```java
public java.lang.String getUsername();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#username Job#username}.

---

### JobNewClusterGcpAttributes <a name="JobNewClusterGcpAttributes" id="@cdktf/provider-databricks.job.JobNewClusterGcpAttributes"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-databricks.job.JobNewClusterGcpAttributes.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobNewClusterGcpAttributes;

JobNewClusterGcpAttributes.builder()
//  .availability(java.lang.String)
//  .bootDiskSize(java.lang.Number)
//  .googleServiceAccount(java.lang.String)
//  .usePreemptibleExecutors(java.lang.Boolean)
//  .usePreemptibleExecutors(IResolvable)
//  .zoneId(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobNewClusterGcpAttributes.property.availability">availability</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#availability Job#availability}. |
| <code><a href="#@cdktf/provider-databricks.job.JobNewClusterGcpAttributes.property.bootDiskSize">bootDiskSize</a></code> | <code>java.lang.Number</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#boot_disk_size Job#boot_disk_size}. |
| <code><a href="#@cdktf/provider-databricks.job.JobNewClusterGcpAttributes.property.googleServiceAccount">googleServiceAccount</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#google_service_account Job#google_service_account}. |
| <code><a href="#@cdktf/provider-databricks.job.JobNewClusterGcpAttributes.property.usePreemptibleExecutors">usePreemptibleExecutors</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#use_preemptible_executors Job#use_preemptible_executors}. |
| <code><a href="#@cdktf/provider-databricks.job.JobNewClusterGcpAttributes.property.zoneId">zoneId</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#zone_id Job#zone_id}. |

---

##### `availability`<sup>Optional</sup> <a name="availability" id="@cdktf/provider-databricks.job.JobNewClusterGcpAttributes.property.availability"></a>

```java
public java.lang.String getAvailability();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#availability Job#availability}.

---

##### `bootDiskSize`<sup>Optional</sup> <a name="bootDiskSize" id="@cdktf/provider-databricks.job.JobNewClusterGcpAttributes.property.bootDiskSize"></a>

```java
public java.lang.Number getBootDiskSize();
```

- *Type:* java.lang.Number

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#boot_disk_size Job#boot_disk_size}.

---

##### `googleServiceAccount`<sup>Optional</sup> <a name="googleServiceAccount" id="@cdktf/provider-databricks.job.JobNewClusterGcpAttributes.property.googleServiceAccount"></a>

```java
public java.lang.String getGoogleServiceAccount();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#google_service_account Job#google_service_account}.

---

##### `usePreemptibleExecutors`<sup>Optional</sup> <a name="usePreemptibleExecutors" id="@cdktf/provider-databricks.job.JobNewClusterGcpAttributes.property.usePreemptibleExecutors"></a>

```java
public java.lang.Object getUsePreemptibleExecutors();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#use_preemptible_executors Job#use_preemptible_executors}.

---

##### `zoneId`<sup>Optional</sup> <a name="zoneId" id="@cdktf/provider-databricks.job.JobNewClusterGcpAttributes.property.zoneId"></a>

```java
public java.lang.String getZoneId();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#zone_id Job#zone_id}.

---

### JobNewClusterInitScripts <a name="JobNewClusterInitScripts" id="@cdktf/provider-databricks.job.JobNewClusterInitScripts"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-databricks.job.JobNewClusterInitScripts.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobNewClusterInitScripts;

JobNewClusterInitScripts.builder()
//  .abfss(JobNewClusterInitScriptsAbfss)
//  .dbfs(JobNewClusterInitScriptsDbfs)
//  .file(JobNewClusterInitScriptsFile)
//  .gcs(JobNewClusterInitScriptsGcs)
//  .s3(JobNewClusterInitScriptsS3)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobNewClusterInitScripts.property.abfss">abfss</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobNewClusterInitScriptsAbfss">JobNewClusterInitScriptsAbfss</a></code> | abfss block. |
| <code><a href="#@cdktf/provider-databricks.job.JobNewClusterInitScripts.property.dbfs">dbfs</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobNewClusterInitScriptsDbfs">JobNewClusterInitScriptsDbfs</a></code> | dbfs block. |
| <code><a href="#@cdktf/provider-databricks.job.JobNewClusterInitScripts.property.file">file</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobNewClusterInitScriptsFile">JobNewClusterInitScriptsFile</a></code> | file block. |
| <code><a href="#@cdktf/provider-databricks.job.JobNewClusterInitScripts.property.gcs">gcs</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobNewClusterInitScriptsGcs">JobNewClusterInitScriptsGcs</a></code> | gcs block. |
| <code><a href="#@cdktf/provider-databricks.job.JobNewClusterInitScripts.property.s3">s3</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobNewClusterInitScriptsS3">JobNewClusterInitScriptsS3</a></code> | s3 block. |

---

##### `abfss`<sup>Optional</sup> <a name="abfss" id="@cdktf/provider-databricks.job.JobNewClusterInitScripts.property.abfss"></a>

```java
public JobNewClusterInitScriptsAbfss getAbfss();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobNewClusterInitScriptsAbfss">JobNewClusterInitScriptsAbfss</a>

abfss block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#abfss Job#abfss}

---

##### `dbfs`<sup>Optional</sup> <a name="dbfs" id="@cdktf/provider-databricks.job.JobNewClusterInitScripts.property.dbfs"></a>

```java
public JobNewClusterInitScriptsDbfs getDbfs();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobNewClusterInitScriptsDbfs">JobNewClusterInitScriptsDbfs</a>

dbfs block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#dbfs Job#dbfs}

---

##### `file`<sup>Optional</sup> <a name="file" id="@cdktf/provider-databricks.job.JobNewClusterInitScripts.property.file"></a>

```java
public JobNewClusterInitScriptsFile getFile();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobNewClusterInitScriptsFile">JobNewClusterInitScriptsFile</a>

file block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#file Job#file}

---

##### `gcs`<sup>Optional</sup> <a name="gcs" id="@cdktf/provider-databricks.job.JobNewClusterInitScripts.property.gcs"></a>

```java
public JobNewClusterInitScriptsGcs getGcs();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobNewClusterInitScriptsGcs">JobNewClusterInitScriptsGcs</a>

gcs block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#gcs Job#gcs}

---

##### `s3`<sup>Optional</sup> <a name="s3" id="@cdktf/provider-databricks.job.JobNewClusterInitScripts.property.s3"></a>

```java
public JobNewClusterInitScriptsS3 getS3();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobNewClusterInitScriptsS3">JobNewClusterInitScriptsS3</a>

s3 block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#s3 Job#s3}

---

### JobNewClusterInitScriptsAbfss <a name="JobNewClusterInitScriptsAbfss" id="@cdktf/provider-databricks.job.JobNewClusterInitScriptsAbfss"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-databricks.job.JobNewClusterInitScriptsAbfss.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobNewClusterInitScriptsAbfss;

JobNewClusterInitScriptsAbfss.builder()
//  .destination(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobNewClusterInitScriptsAbfss.property.destination">destination</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#destination Job#destination}. |

---

##### `destination`<sup>Optional</sup> <a name="destination" id="@cdktf/provider-databricks.job.JobNewClusterInitScriptsAbfss.property.destination"></a>

```java
public java.lang.String getDestination();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#destination Job#destination}.

---

### JobNewClusterInitScriptsDbfs <a name="JobNewClusterInitScriptsDbfs" id="@cdktf/provider-databricks.job.JobNewClusterInitScriptsDbfs"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-databricks.job.JobNewClusterInitScriptsDbfs.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobNewClusterInitScriptsDbfs;

JobNewClusterInitScriptsDbfs.builder()
    .destination(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobNewClusterInitScriptsDbfs.property.destination">destination</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#destination Job#destination}. |

---

##### `destination`<sup>Required</sup> <a name="destination" id="@cdktf/provider-databricks.job.JobNewClusterInitScriptsDbfs.property.destination"></a>

```java
public java.lang.String getDestination();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#destination Job#destination}.

---

### JobNewClusterInitScriptsFile <a name="JobNewClusterInitScriptsFile" id="@cdktf/provider-databricks.job.JobNewClusterInitScriptsFile"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-databricks.job.JobNewClusterInitScriptsFile.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobNewClusterInitScriptsFile;

JobNewClusterInitScriptsFile.builder()
//  .destination(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobNewClusterInitScriptsFile.property.destination">destination</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#destination Job#destination}. |

---

##### `destination`<sup>Optional</sup> <a name="destination" id="@cdktf/provider-databricks.job.JobNewClusterInitScriptsFile.property.destination"></a>

```java
public java.lang.String getDestination();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#destination Job#destination}.

---

### JobNewClusterInitScriptsGcs <a name="JobNewClusterInitScriptsGcs" id="@cdktf/provider-databricks.job.JobNewClusterInitScriptsGcs"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-databricks.job.JobNewClusterInitScriptsGcs.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobNewClusterInitScriptsGcs;

JobNewClusterInitScriptsGcs.builder()
//  .destination(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobNewClusterInitScriptsGcs.property.destination">destination</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#destination Job#destination}. |

---

##### `destination`<sup>Optional</sup> <a name="destination" id="@cdktf/provider-databricks.job.JobNewClusterInitScriptsGcs.property.destination"></a>

```java
public java.lang.String getDestination();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#destination Job#destination}.

---

### JobNewClusterInitScriptsS3 <a name="JobNewClusterInitScriptsS3" id="@cdktf/provider-databricks.job.JobNewClusterInitScriptsS3"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-databricks.job.JobNewClusterInitScriptsS3.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobNewClusterInitScriptsS3;

JobNewClusterInitScriptsS3.builder()
    .destination(java.lang.String)
//  .cannedAcl(java.lang.String)
//  .enableEncryption(java.lang.Boolean)
//  .enableEncryption(IResolvable)
//  .encryptionType(java.lang.String)
//  .endpoint(java.lang.String)
//  .kmsKey(java.lang.String)
//  .region(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobNewClusterInitScriptsS3.property.destination">destination</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#destination Job#destination}. |
| <code><a href="#@cdktf/provider-databricks.job.JobNewClusterInitScriptsS3.property.cannedAcl">cannedAcl</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#canned_acl Job#canned_acl}. |
| <code><a href="#@cdktf/provider-databricks.job.JobNewClusterInitScriptsS3.property.enableEncryption">enableEncryption</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#enable_encryption Job#enable_encryption}. |
| <code><a href="#@cdktf/provider-databricks.job.JobNewClusterInitScriptsS3.property.encryptionType">encryptionType</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#encryption_type Job#encryption_type}. |
| <code><a href="#@cdktf/provider-databricks.job.JobNewClusterInitScriptsS3.property.endpoint">endpoint</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#endpoint Job#endpoint}. |
| <code><a href="#@cdktf/provider-databricks.job.JobNewClusterInitScriptsS3.property.kmsKey">kmsKey</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#kms_key Job#kms_key}. |
| <code><a href="#@cdktf/provider-databricks.job.JobNewClusterInitScriptsS3.property.region">region</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#region Job#region}. |

---

##### `destination`<sup>Required</sup> <a name="destination" id="@cdktf/provider-databricks.job.JobNewClusterInitScriptsS3.property.destination"></a>

```java
public java.lang.String getDestination();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#destination Job#destination}.

---

##### `cannedAcl`<sup>Optional</sup> <a name="cannedAcl" id="@cdktf/provider-databricks.job.JobNewClusterInitScriptsS3.property.cannedAcl"></a>

```java
public java.lang.String getCannedAcl();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#canned_acl Job#canned_acl}.

---

##### `enableEncryption`<sup>Optional</sup> <a name="enableEncryption" id="@cdktf/provider-databricks.job.JobNewClusterInitScriptsS3.property.enableEncryption"></a>

```java
public java.lang.Object getEnableEncryption();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#enable_encryption Job#enable_encryption}.

---

##### `encryptionType`<sup>Optional</sup> <a name="encryptionType" id="@cdktf/provider-databricks.job.JobNewClusterInitScriptsS3.property.encryptionType"></a>

```java
public java.lang.String getEncryptionType();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#encryption_type Job#encryption_type}.

---

##### `endpoint`<sup>Optional</sup> <a name="endpoint" id="@cdktf/provider-databricks.job.JobNewClusterInitScriptsS3.property.endpoint"></a>

```java
public java.lang.String getEndpoint();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#endpoint Job#endpoint}.

---

##### `kmsKey`<sup>Optional</sup> <a name="kmsKey" id="@cdktf/provider-databricks.job.JobNewClusterInitScriptsS3.property.kmsKey"></a>

```java
public java.lang.String getKmsKey();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#kms_key Job#kms_key}.

---

##### `region`<sup>Optional</sup> <a name="region" id="@cdktf/provider-databricks.job.JobNewClusterInitScriptsS3.property.region"></a>

```java
public java.lang.String getRegion();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#region Job#region}.

---

### JobNewClusterWorkloadType <a name="JobNewClusterWorkloadType" id="@cdktf/provider-databricks.job.JobNewClusterWorkloadType"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-databricks.job.JobNewClusterWorkloadType.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobNewClusterWorkloadType;

JobNewClusterWorkloadType.builder()
    .clients(JobNewClusterWorkloadTypeClients)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobNewClusterWorkloadType.property.clients">clients</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobNewClusterWorkloadTypeClients">JobNewClusterWorkloadTypeClients</a></code> | clients block. |

---

##### `clients`<sup>Required</sup> <a name="clients" id="@cdktf/provider-databricks.job.JobNewClusterWorkloadType.property.clients"></a>

```java
public JobNewClusterWorkloadTypeClients getClients();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobNewClusterWorkloadTypeClients">JobNewClusterWorkloadTypeClients</a>

clients block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#clients Job#clients}

---

### JobNewClusterWorkloadTypeClients <a name="JobNewClusterWorkloadTypeClients" id="@cdktf/provider-databricks.job.JobNewClusterWorkloadTypeClients"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-databricks.job.JobNewClusterWorkloadTypeClients.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobNewClusterWorkloadTypeClients;

JobNewClusterWorkloadTypeClients.builder()
//  .jobs(java.lang.Boolean)
//  .jobs(IResolvable)
//  .notebooks(java.lang.Boolean)
//  .notebooks(IResolvable)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobNewClusterWorkloadTypeClients.property.jobs">jobs</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#jobs Job#jobs}. |
| <code><a href="#@cdktf/provider-databricks.job.JobNewClusterWorkloadTypeClients.property.notebooks">notebooks</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#notebooks Job#notebooks}. |

---

##### `jobs`<sup>Optional</sup> <a name="jobs" id="@cdktf/provider-databricks.job.JobNewClusterWorkloadTypeClients.property.jobs"></a>

```java
public java.lang.Object getJobs();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#jobs Job#jobs}.

---

##### `notebooks`<sup>Optional</sup> <a name="notebooks" id="@cdktf/provider-databricks.job.JobNewClusterWorkloadTypeClients.property.notebooks"></a>

```java
public java.lang.Object getNotebooks();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#notebooks Job#notebooks}.

---

### JobNotebookTask <a name="JobNotebookTask" id="@cdktf/provider-databricks.job.JobNotebookTask"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-databricks.job.JobNotebookTask.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobNotebookTask;

JobNotebookTask.builder()
    .notebookPath(java.lang.String)
//  .baseParameters(java.util.Map<java.lang.String, java.lang.String>)
//  .source(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobNotebookTask.property.notebookPath">notebookPath</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#notebook_path Job#notebook_path}. |
| <code><a href="#@cdktf/provider-databricks.job.JobNotebookTask.property.baseParameters">baseParameters</a></code> | <code>java.util.Map<java.lang.String, java.lang.String></code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#base_parameters Job#base_parameters}. |
| <code><a href="#@cdktf/provider-databricks.job.JobNotebookTask.property.source">source</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#source Job#source}. |

---

##### `notebookPath`<sup>Required</sup> <a name="notebookPath" id="@cdktf/provider-databricks.job.JobNotebookTask.property.notebookPath"></a>

```java
public java.lang.String getNotebookPath();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#notebook_path Job#notebook_path}.

---

##### `baseParameters`<sup>Optional</sup> <a name="baseParameters" id="@cdktf/provider-databricks.job.JobNotebookTask.property.baseParameters"></a>

```java
public java.util.Map<java.lang.String, java.lang.String> getBaseParameters();
```

- *Type:* java.util.Map<java.lang.String, java.lang.String>

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#base_parameters Job#base_parameters}.

---

##### `source`<sup>Optional</sup> <a name="source" id="@cdktf/provider-databricks.job.JobNotebookTask.property.source"></a>

```java
public java.lang.String getSource();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#source Job#source}.

---

### JobPipelineTask <a name="JobPipelineTask" id="@cdktf/provider-databricks.job.JobPipelineTask"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-databricks.job.JobPipelineTask.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobPipelineTask;

JobPipelineTask.builder()
    .pipelineId(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobPipelineTask.property.pipelineId">pipelineId</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#pipeline_id Job#pipeline_id}. |

---

##### `pipelineId`<sup>Required</sup> <a name="pipelineId" id="@cdktf/provider-databricks.job.JobPipelineTask.property.pipelineId"></a>

```java
public java.lang.String getPipelineId();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#pipeline_id Job#pipeline_id}.

---

### JobPythonWheelTask <a name="JobPythonWheelTask" id="@cdktf/provider-databricks.job.JobPythonWheelTask"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-databricks.job.JobPythonWheelTask.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobPythonWheelTask;

JobPythonWheelTask.builder()
//  .entryPoint(java.lang.String)
//  .namedParameters(java.util.Map<java.lang.String, java.lang.String>)
//  .packageName(java.lang.String)
//  .parameters(java.util.List<java.lang.String>)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobPythonWheelTask.property.entryPoint">entryPoint</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#entry_point Job#entry_point}. |
| <code><a href="#@cdktf/provider-databricks.job.JobPythonWheelTask.property.namedParameters">namedParameters</a></code> | <code>java.util.Map<java.lang.String, java.lang.String></code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#named_parameters Job#named_parameters}. |
| <code><a href="#@cdktf/provider-databricks.job.JobPythonWheelTask.property.packageName">packageName</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#package_name Job#package_name}. |
| <code><a href="#@cdktf/provider-databricks.job.JobPythonWheelTask.property.parameters">parameters</a></code> | <code>java.util.List<java.lang.String></code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#parameters Job#parameters}. |

---

##### `entryPoint`<sup>Optional</sup> <a name="entryPoint" id="@cdktf/provider-databricks.job.JobPythonWheelTask.property.entryPoint"></a>

```java
public java.lang.String getEntryPoint();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#entry_point Job#entry_point}.

---

##### `namedParameters`<sup>Optional</sup> <a name="namedParameters" id="@cdktf/provider-databricks.job.JobPythonWheelTask.property.namedParameters"></a>

```java
public java.util.Map<java.lang.String, java.lang.String> getNamedParameters();
```

- *Type:* java.util.Map<java.lang.String, java.lang.String>

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#named_parameters Job#named_parameters}.

---

##### `packageName`<sup>Optional</sup> <a name="packageName" id="@cdktf/provider-databricks.job.JobPythonWheelTask.property.packageName"></a>

```java
public java.lang.String getPackageName();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#package_name Job#package_name}.

---

##### `parameters`<sup>Optional</sup> <a name="parameters" id="@cdktf/provider-databricks.job.JobPythonWheelTask.property.parameters"></a>

```java
public java.util.List<java.lang.String> getParameters();
```

- *Type:* java.util.List<java.lang.String>

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#parameters Job#parameters}.

---

### JobQueue <a name="JobQueue" id="@cdktf/provider-databricks.job.JobQueue"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-databricks.job.JobQueue.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobQueue;

JobQueue.builder()
    .build();
```


### JobSchedule <a name="JobSchedule" id="@cdktf/provider-databricks.job.JobSchedule"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-databricks.job.JobSchedule.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobSchedule;

JobSchedule.builder()
    .quartzCronExpression(java.lang.String)
    .timezoneId(java.lang.String)
//  .pauseStatus(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobSchedule.property.quartzCronExpression">quartzCronExpression</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#quartz_cron_expression Job#quartz_cron_expression}. |
| <code><a href="#@cdktf/provider-databricks.job.JobSchedule.property.timezoneId">timezoneId</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#timezone_id Job#timezone_id}. |
| <code><a href="#@cdktf/provider-databricks.job.JobSchedule.property.pauseStatus">pauseStatus</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#pause_status Job#pause_status}. |

---

##### `quartzCronExpression`<sup>Required</sup> <a name="quartzCronExpression" id="@cdktf/provider-databricks.job.JobSchedule.property.quartzCronExpression"></a>

```java
public java.lang.String getQuartzCronExpression();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#quartz_cron_expression Job#quartz_cron_expression}.

---

##### `timezoneId`<sup>Required</sup> <a name="timezoneId" id="@cdktf/provider-databricks.job.JobSchedule.property.timezoneId"></a>

```java
public java.lang.String getTimezoneId();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#timezone_id Job#timezone_id}.

---

##### `pauseStatus`<sup>Optional</sup> <a name="pauseStatus" id="@cdktf/provider-databricks.job.JobSchedule.property.pauseStatus"></a>

```java
public java.lang.String getPauseStatus();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#pause_status Job#pause_status}.

---

### JobSparkJarTask <a name="JobSparkJarTask" id="@cdktf/provider-databricks.job.JobSparkJarTask"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-databricks.job.JobSparkJarTask.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobSparkJarTask;

JobSparkJarTask.builder()
//  .jarUri(java.lang.String)
//  .mainClassName(java.lang.String)
//  .parameters(java.util.List<java.lang.String>)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobSparkJarTask.property.jarUri">jarUri</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#jar_uri Job#jar_uri}. |
| <code><a href="#@cdktf/provider-databricks.job.JobSparkJarTask.property.mainClassName">mainClassName</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#main_class_name Job#main_class_name}. |
| <code><a href="#@cdktf/provider-databricks.job.JobSparkJarTask.property.parameters">parameters</a></code> | <code>java.util.List<java.lang.String></code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#parameters Job#parameters}. |

---

##### `jarUri`<sup>Optional</sup> <a name="jarUri" id="@cdktf/provider-databricks.job.JobSparkJarTask.property.jarUri"></a>

```java
public java.lang.String getJarUri();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#jar_uri Job#jar_uri}.

---

##### `mainClassName`<sup>Optional</sup> <a name="mainClassName" id="@cdktf/provider-databricks.job.JobSparkJarTask.property.mainClassName"></a>

```java
public java.lang.String getMainClassName();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#main_class_name Job#main_class_name}.

---

##### `parameters`<sup>Optional</sup> <a name="parameters" id="@cdktf/provider-databricks.job.JobSparkJarTask.property.parameters"></a>

```java
public java.util.List<java.lang.String> getParameters();
```

- *Type:* java.util.List<java.lang.String>

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#parameters Job#parameters}.

---

### JobSparkPythonTask <a name="JobSparkPythonTask" id="@cdktf/provider-databricks.job.JobSparkPythonTask"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-databricks.job.JobSparkPythonTask.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobSparkPythonTask;

JobSparkPythonTask.builder()
    .pythonFile(java.lang.String)
//  .parameters(java.util.List<java.lang.String>)
//  .source(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobSparkPythonTask.property.pythonFile">pythonFile</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#python_file Job#python_file}. |
| <code><a href="#@cdktf/provider-databricks.job.JobSparkPythonTask.property.parameters">parameters</a></code> | <code>java.util.List<java.lang.String></code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#parameters Job#parameters}. |
| <code><a href="#@cdktf/provider-databricks.job.JobSparkPythonTask.property.source">source</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#source Job#source}. |

---

##### `pythonFile`<sup>Required</sup> <a name="pythonFile" id="@cdktf/provider-databricks.job.JobSparkPythonTask.property.pythonFile"></a>

```java
public java.lang.String getPythonFile();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#python_file Job#python_file}.

---

##### `parameters`<sup>Optional</sup> <a name="parameters" id="@cdktf/provider-databricks.job.JobSparkPythonTask.property.parameters"></a>

```java
public java.util.List<java.lang.String> getParameters();
```

- *Type:* java.util.List<java.lang.String>

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#parameters Job#parameters}.

---

##### `source`<sup>Optional</sup> <a name="source" id="@cdktf/provider-databricks.job.JobSparkPythonTask.property.source"></a>

```java
public java.lang.String getSource();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#source Job#source}.

---

### JobSparkSubmitTask <a name="JobSparkSubmitTask" id="@cdktf/provider-databricks.job.JobSparkSubmitTask"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-databricks.job.JobSparkSubmitTask.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobSparkSubmitTask;

JobSparkSubmitTask.builder()
//  .parameters(java.util.List<java.lang.String>)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobSparkSubmitTask.property.parameters">parameters</a></code> | <code>java.util.List<java.lang.String></code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#parameters Job#parameters}. |

---

##### `parameters`<sup>Optional</sup> <a name="parameters" id="@cdktf/provider-databricks.job.JobSparkSubmitTask.property.parameters"></a>

```java
public java.util.List<java.lang.String> getParameters();
```

- *Type:* java.util.List<java.lang.String>

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#parameters Job#parameters}.

---

### JobTask <a name="JobTask" id="@cdktf/provider-databricks.job.JobTask"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-databricks.job.JobTask.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobTask;

JobTask.builder()
//  .dbtTask(JobTaskDbtTask)
//  .dependsOn(IResolvable)
//  .dependsOn(java.util.List<JobTaskDependsOn>)
//  .description(java.lang.String)
//  .emailNotifications(JobTaskEmailNotifications)
//  .existingClusterId(java.lang.String)
//  .jobClusterKey(java.lang.String)
//  .library(IResolvable)
//  .library(java.util.List<JobTaskLibrary>)
//  .maxRetries(java.lang.Number)
//  .minRetryIntervalMillis(java.lang.Number)
//  .newCluster(JobTaskNewCluster)
//  .notebookTask(JobTaskNotebookTask)
//  .pipelineTask(JobTaskPipelineTask)
//  .pythonWheelTask(JobTaskPythonWheelTask)
//  .retryOnTimeout(java.lang.Boolean)
//  .retryOnTimeout(IResolvable)
//  .runIf(java.lang.String)
//  .sparkJarTask(JobTaskSparkJarTask)
//  .sparkPythonTask(JobTaskSparkPythonTask)
//  .sparkSubmitTask(JobTaskSparkSubmitTask)
//  .sqlTask(JobTaskSqlTask)
//  .taskKey(java.lang.String)
//  .timeoutSeconds(java.lang.Number)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobTask.property.dbtTask">dbtTask</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobTaskDbtTask">JobTaskDbtTask</a></code> | dbt_task block. |
| <code><a href="#@cdktf/provider-databricks.job.JobTask.property.dependsOn">dependsOn</a></code> | <code>com.hashicorp.cdktf.IResolvable OR java.util.List<<a href="#@cdktf/provider-databricks.job.JobTaskDependsOn">JobTaskDependsOn</a>></code> | depends_on block. |
| <code><a href="#@cdktf/provider-databricks.job.JobTask.property.description">description</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#description Job#description}. |
| <code><a href="#@cdktf/provider-databricks.job.JobTask.property.emailNotifications">emailNotifications</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobTaskEmailNotifications">JobTaskEmailNotifications</a></code> | email_notifications block. |
| <code><a href="#@cdktf/provider-databricks.job.JobTask.property.existingClusterId">existingClusterId</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#existing_cluster_id Job#existing_cluster_id}. |
| <code><a href="#@cdktf/provider-databricks.job.JobTask.property.jobClusterKey">jobClusterKey</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#job_cluster_key Job#job_cluster_key}. |
| <code><a href="#@cdktf/provider-databricks.job.JobTask.property.library">library</a></code> | <code>com.hashicorp.cdktf.IResolvable OR java.util.List<<a href="#@cdktf/provider-databricks.job.JobTaskLibrary">JobTaskLibrary</a>></code> | library block. |
| <code><a href="#@cdktf/provider-databricks.job.JobTask.property.maxRetries">maxRetries</a></code> | <code>java.lang.Number</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#max_retries Job#max_retries}. |
| <code><a href="#@cdktf/provider-databricks.job.JobTask.property.minRetryIntervalMillis">minRetryIntervalMillis</a></code> | <code>java.lang.Number</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#min_retry_interval_millis Job#min_retry_interval_millis}. |
| <code><a href="#@cdktf/provider-databricks.job.JobTask.property.newCluster">newCluster</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobTaskNewCluster">JobTaskNewCluster</a></code> | new_cluster block. |
| <code><a href="#@cdktf/provider-databricks.job.JobTask.property.notebookTask">notebookTask</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobTaskNotebookTask">JobTaskNotebookTask</a></code> | notebook_task block. |
| <code><a href="#@cdktf/provider-databricks.job.JobTask.property.pipelineTask">pipelineTask</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobTaskPipelineTask">JobTaskPipelineTask</a></code> | pipeline_task block. |
| <code><a href="#@cdktf/provider-databricks.job.JobTask.property.pythonWheelTask">pythonWheelTask</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobTaskPythonWheelTask">JobTaskPythonWheelTask</a></code> | python_wheel_task block. |
| <code><a href="#@cdktf/provider-databricks.job.JobTask.property.retryOnTimeout">retryOnTimeout</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#retry_on_timeout Job#retry_on_timeout}. |
| <code><a href="#@cdktf/provider-databricks.job.JobTask.property.runIf">runIf</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#run_if Job#run_if}. |
| <code><a href="#@cdktf/provider-databricks.job.JobTask.property.sparkJarTask">sparkJarTask</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobTaskSparkJarTask">JobTaskSparkJarTask</a></code> | spark_jar_task block. |
| <code><a href="#@cdktf/provider-databricks.job.JobTask.property.sparkPythonTask">sparkPythonTask</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobTaskSparkPythonTask">JobTaskSparkPythonTask</a></code> | spark_python_task block. |
| <code><a href="#@cdktf/provider-databricks.job.JobTask.property.sparkSubmitTask">sparkSubmitTask</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobTaskSparkSubmitTask">JobTaskSparkSubmitTask</a></code> | spark_submit_task block. |
| <code><a href="#@cdktf/provider-databricks.job.JobTask.property.sqlTask">sqlTask</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobTaskSqlTask">JobTaskSqlTask</a></code> | sql_task block. |
| <code><a href="#@cdktf/provider-databricks.job.JobTask.property.taskKey">taskKey</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#task_key Job#task_key}. |
| <code><a href="#@cdktf/provider-databricks.job.JobTask.property.timeoutSeconds">timeoutSeconds</a></code> | <code>java.lang.Number</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#timeout_seconds Job#timeout_seconds}. |

---

##### `dbtTask`<sup>Optional</sup> <a name="dbtTask" id="@cdktf/provider-databricks.job.JobTask.property.dbtTask"></a>

```java
public JobTaskDbtTask getDbtTask();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobTaskDbtTask">JobTaskDbtTask</a>

dbt_task block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#dbt_task Job#dbt_task}

---

##### `dependsOn`<sup>Optional</sup> <a name="dependsOn" id="@cdktf/provider-databricks.job.JobTask.property.dependsOn"></a>

```java
public java.lang.Object getDependsOn();
```

- *Type:* com.hashicorp.cdktf.IResolvable OR java.util.List<<a href="#@cdktf/provider-databricks.job.JobTaskDependsOn">JobTaskDependsOn</a>>

depends_on block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#depends_on Job#depends_on}

---

##### `description`<sup>Optional</sup> <a name="description" id="@cdktf/provider-databricks.job.JobTask.property.description"></a>

```java
public java.lang.String getDescription();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#description Job#description}.

---

##### `emailNotifications`<sup>Optional</sup> <a name="emailNotifications" id="@cdktf/provider-databricks.job.JobTask.property.emailNotifications"></a>

```java
public JobTaskEmailNotifications getEmailNotifications();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobTaskEmailNotifications">JobTaskEmailNotifications</a>

email_notifications block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#email_notifications Job#email_notifications}

---

##### `existingClusterId`<sup>Optional</sup> <a name="existingClusterId" id="@cdktf/provider-databricks.job.JobTask.property.existingClusterId"></a>

```java
public java.lang.String getExistingClusterId();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#existing_cluster_id Job#existing_cluster_id}.

---

##### `jobClusterKey`<sup>Optional</sup> <a name="jobClusterKey" id="@cdktf/provider-databricks.job.JobTask.property.jobClusterKey"></a>

```java
public java.lang.String getJobClusterKey();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#job_cluster_key Job#job_cluster_key}.

---

##### `library`<sup>Optional</sup> <a name="library" id="@cdktf/provider-databricks.job.JobTask.property.library"></a>

```java
public java.lang.Object getLibrary();
```

- *Type:* com.hashicorp.cdktf.IResolvable OR java.util.List<<a href="#@cdktf/provider-databricks.job.JobTaskLibrary">JobTaskLibrary</a>>

library block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#library Job#library}

---

##### `maxRetries`<sup>Optional</sup> <a name="maxRetries" id="@cdktf/provider-databricks.job.JobTask.property.maxRetries"></a>

```java
public java.lang.Number getMaxRetries();
```

- *Type:* java.lang.Number

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#max_retries Job#max_retries}.

---

##### `minRetryIntervalMillis`<sup>Optional</sup> <a name="minRetryIntervalMillis" id="@cdktf/provider-databricks.job.JobTask.property.minRetryIntervalMillis"></a>

```java
public java.lang.Number getMinRetryIntervalMillis();
```

- *Type:* java.lang.Number

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#min_retry_interval_millis Job#min_retry_interval_millis}.

---

##### `newCluster`<sup>Optional</sup> <a name="newCluster" id="@cdktf/provider-databricks.job.JobTask.property.newCluster"></a>

```java
public JobTaskNewCluster getNewCluster();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobTaskNewCluster">JobTaskNewCluster</a>

new_cluster block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#new_cluster Job#new_cluster}

---

##### `notebookTask`<sup>Optional</sup> <a name="notebookTask" id="@cdktf/provider-databricks.job.JobTask.property.notebookTask"></a>

```java
public JobTaskNotebookTask getNotebookTask();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobTaskNotebookTask">JobTaskNotebookTask</a>

notebook_task block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#notebook_task Job#notebook_task}

---

##### `pipelineTask`<sup>Optional</sup> <a name="pipelineTask" id="@cdktf/provider-databricks.job.JobTask.property.pipelineTask"></a>

```java
public JobTaskPipelineTask getPipelineTask();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobTaskPipelineTask">JobTaskPipelineTask</a>

pipeline_task block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#pipeline_task Job#pipeline_task}

---

##### `pythonWheelTask`<sup>Optional</sup> <a name="pythonWheelTask" id="@cdktf/provider-databricks.job.JobTask.property.pythonWheelTask"></a>

```java
public JobTaskPythonWheelTask getPythonWheelTask();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobTaskPythonWheelTask">JobTaskPythonWheelTask</a>

python_wheel_task block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#python_wheel_task Job#python_wheel_task}

---

##### `retryOnTimeout`<sup>Optional</sup> <a name="retryOnTimeout" id="@cdktf/provider-databricks.job.JobTask.property.retryOnTimeout"></a>

```java
public java.lang.Object getRetryOnTimeout();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#retry_on_timeout Job#retry_on_timeout}.

---

##### `runIf`<sup>Optional</sup> <a name="runIf" id="@cdktf/provider-databricks.job.JobTask.property.runIf"></a>

```java
public java.lang.String getRunIf();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#run_if Job#run_if}.

---

##### `sparkJarTask`<sup>Optional</sup> <a name="sparkJarTask" id="@cdktf/provider-databricks.job.JobTask.property.sparkJarTask"></a>

```java
public JobTaskSparkJarTask getSparkJarTask();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobTaskSparkJarTask">JobTaskSparkJarTask</a>

spark_jar_task block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#spark_jar_task Job#spark_jar_task}

---

##### `sparkPythonTask`<sup>Optional</sup> <a name="sparkPythonTask" id="@cdktf/provider-databricks.job.JobTask.property.sparkPythonTask"></a>

```java
public JobTaskSparkPythonTask getSparkPythonTask();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobTaskSparkPythonTask">JobTaskSparkPythonTask</a>

spark_python_task block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#spark_python_task Job#spark_python_task}

---

##### `sparkSubmitTask`<sup>Optional</sup> <a name="sparkSubmitTask" id="@cdktf/provider-databricks.job.JobTask.property.sparkSubmitTask"></a>

```java
public JobTaskSparkSubmitTask getSparkSubmitTask();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobTaskSparkSubmitTask">JobTaskSparkSubmitTask</a>

spark_submit_task block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#spark_submit_task Job#spark_submit_task}

---

##### `sqlTask`<sup>Optional</sup> <a name="sqlTask" id="@cdktf/provider-databricks.job.JobTask.property.sqlTask"></a>

```java
public JobTaskSqlTask getSqlTask();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobTaskSqlTask">JobTaskSqlTask</a>

sql_task block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#sql_task Job#sql_task}

---

##### `taskKey`<sup>Optional</sup> <a name="taskKey" id="@cdktf/provider-databricks.job.JobTask.property.taskKey"></a>

```java
public java.lang.String getTaskKey();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#task_key Job#task_key}.

---

##### `timeoutSeconds`<sup>Optional</sup> <a name="timeoutSeconds" id="@cdktf/provider-databricks.job.JobTask.property.timeoutSeconds"></a>

```java
public java.lang.Number getTimeoutSeconds();
```

- *Type:* java.lang.Number

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#timeout_seconds Job#timeout_seconds}.

---

### JobTaskDbtTask <a name="JobTaskDbtTask" id="@cdktf/provider-databricks.job.JobTaskDbtTask"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-databricks.job.JobTaskDbtTask.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobTaskDbtTask;

JobTaskDbtTask.builder()
    .commands(java.util.List<java.lang.String>)
//  .catalog(java.lang.String)
//  .profilesDirectory(java.lang.String)
//  .projectDirectory(java.lang.String)
//  .schema(java.lang.String)
//  .warehouseId(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskDbtTask.property.commands">commands</a></code> | <code>java.util.List<java.lang.String></code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#commands Job#commands}. |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskDbtTask.property.catalog">catalog</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#catalog Job#catalog}. |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskDbtTask.property.profilesDirectory">profilesDirectory</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#profiles_directory Job#profiles_directory}. |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskDbtTask.property.projectDirectory">projectDirectory</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#project_directory Job#project_directory}. |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskDbtTask.property.schema">schema</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#schema Job#schema}. |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskDbtTask.property.warehouseId">warehouseId</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#warehouse_id Job#warehouse_id}. |

---

##### `commands`<sup>Required</sup> <a name="commands" id="@cdktf/provider-databricks.job.JobTaskDbtTask.property.commands"></a>

```java
public java.util.List<java.lang.String> getCommands();
```

- *Type:* java.util.List<java.lang.String>

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#commands Job#commands}.

---

##### `catalog`<sup>Optional</sup> <a name="catalog" id="@cdktf/provider-databricks.job.JobTaskDbtTask.property.catalog"></a>

```java
public java.lang.String getCatalog();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#catalog Job#catalog}.

---

##### `profilesDirectory`<sup>Optional</sup> <a name="profilesDirectory" id="@cdktf/provider-databricks.job.JobTaskDbtTask.property.profilesDirectory"></a>

```java
public java.lang.String getProfilesDirectory();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#profiles_directory Job#profiles_directory}.

---

##### `projectDirectory`<sup>Optional</sup> <a name="projectDirectory" id="@cdktf/provider-databricks.job.JobTaskDbtTask.property.projectDirectory"></a>

```java
public java.lang.String getProjectDirectory();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#project_directory Job#project_directory}.

---

##### `schema`<sup>Optional</sup> <a name="schema" id="@cdktf/provider-databricks.job.JobTaskDbtTask.property.schema"></a>

```java
public java.lang.String getSchema();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#schema Job#schema}.

---

##### `warehouseId`<sup>Optional</sup> <a name="warehouseId" id="@cdktf/provider-databricks.job.JobTaskDbtTask.property.warehouseId"></a>

```java
public java.lang.String getWarehouseId();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#warehouse_id Job#warehouse_id}.

---

### JobTaskDependsOn <a name="JobTaskDependsOn" id="@cdktf/provider-databricks.job.JobTaskDependsOn"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-databricks.job.JobTaskDependsOn.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobTaskDependsOn;

JobTaskDependsOn.builder()
//  .taskKey(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskDependsOn.property.taskKey">taskKey</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#task_key Job#task_key}. |

---

##### `taskKey`<sup>Optional</sup> <a name="taskKey" id="@cdktf/provider-databricks.job.JobTaskDependsOn.property.taskKey"></a>

```java
public java.lang.String getTaskKey();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#task_key Job#task_key}.

---

### JobTaskEmailNotifications <a name="JobTaskEmailNotifications" id="@cdktf/provider-databricks.job.JobTaskEmailNotifications"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-databricks.job.JobTaskEmailNotifications.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobTaskEmailNotifications;

JobTaskEmailNotifications.builder()
//  .alertOnLastAttempt(java.lang.Boolean)
//  .alertOnLastAttempt(IResolvable)
//  .noAlertForSkippedRuns(java.lang.Boolean)
//  .noAlertForSkippedRuns(IResolvable)
//  .onFailure(java.util.List<java.lang.String>)
//  .onStart(java.util.List<java.lang.String>)
//  .onSuccess(java.util.List<java.lang.String>)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskEmailNotifications.property.alertOnLastAttempt">alertOnLastAttempt</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#alert_on_last_attempt Job#alert_on_last_attempt}. |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskEmailNotifications.property.noAlertForSkippedRuns">noAlertForSkippedRuns</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#no_alert_for_skipped_runs Job#no_alert_for_skipped_runs}. |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskEmailNotifications.property.onFailure">onFailure</a></code> | <code>java.util.List<java.lang.String></code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#on_failure Job#on_failure}. |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskEmailNotifications.property.onStart">onStart</a></code> | <code>java.util.List<java.lang.String></code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#on_start Job#on_start}. |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskEmailNotifications.property.onSuccess">onSuccess</a></code> | <code>java.util.List<java.lang.String></code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#on_success Job#on_success}. |

---

##### `alertOnLastAttempt`<sup>Optional</sup> <a name="alertOnLastAttempt" id="@cdktf/provider-databricks.job.JobTaskEmailNotifications.property.alertOnLastAttempt"></a>

```java
public java.lang.Object getAlertOnLastAttempt();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#alert_on_last_attempt Job#alert_on_last_attempt}.

---

##### `noAlertForSkippedRuns`<sup>Optional</sup> <a name="noAlertForSkippedRuns" id="@cdktf/provider-databricks.job.JobTaskEmailNotifications.property.noAlertForSkippedRuns"></a>

```java
public java.lang.Object getNoAlertForSkippedRuns();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#no_alert_for_skipped_runs Job#no_alert_for_skipped_runs}.

---

##### `onFailure`<sup>Optional</sup> <a name="onFailure" id="@cdktf/provider-databricks.job.JobTaskEmailNotifications.property.onFailure"></a>

```java
public java.util.List<java.lang.String> getOnFailure();
```

- *Type:* java.util.List<java.lang.String>

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#on_failure Job#on_failure}.

---

##### `onStart`<sup>Optional</sup> <a name="onStart" id="@cdktf/provider-databricks.job.JobTaskEmailNotifications.property.onStart"></a>

```java
public java.util.List<java.lang.String> getOnStart();
```

- *Type:* java.util.List<java.lang.String>

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#on_start Job#on_start}.

---

##### `onSuccess`<sup>Optional</sup> <a name="onSuccess" id="@cdktf/provider-databricks.job.JobTaskEmailNotifications.property.onSuccess"></a>

```java
public java.util.List<java.lang.String> getOnSuccess();
```

- *Type:* java.util.List<java.lang.String>

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#on_success Job#on_success}.

---

### JobTaskLibrary <a name="JobTaskLibrary" id="@cdktf/provider-databricks.job.JobTaskLibrary"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-databricks.job.JobTaskLibrary.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobTaskLibrary;

JobTaskLibrary.builder()
//  .cran(JobTaskLibraryCran)
//  .egg(java.lang.String)
//  .jar(java.lang.String)
//  .maven(JobTaskLibraryMaven)
//  .pypi(JobTaskLibraryPypi)
//  .whl(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskLibrary.property.cran">cran</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobTaskLibraryCran">JobTaskLibraryCran</a></code> | cran block. |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskLibrary.property.egg">egg</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#egg Job#egg}. |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskLibrary.property.jar">jar</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#jar Job#jar}. |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskLibrary.property.maven">maven</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobTaskLibraryMaven">JobTaskLibraryMaven</a></code> | maven block. |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskLibrary.property.pypi">pypi</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobTaskLibraryPypi">JobTaskLibraryPypi</a></code> | pypi block. |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskLibrary.property.whl">whl</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#whl Job#whl}. |

---

##### `cran`<sup>Optional</sup> <a name="cran" id="@cdktf/provider-databricks.job.JobTaskLibrary.property.cran"></a>

```java
public JobTaskLibraryCran getCran();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobTaskLibraryCran">JobTaskLibraryCran</a>

cran block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#cran Job#cran}

---

##### `egg`<sup>Optional</sup> <a name="egg" id="@cdktf/provider-databricks.job.JobTaskLibrary.property.egg"></a>

```java
public java.lang.String getEgg();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#egg Job#egg}.

---

##### `jar`<sup>Optional</sup> <a name="jar" id="@cdktf/provider-databricks.job.JobTaskLibrary.property.jar"></a>

```java
public java.lang.String getJar();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#jar Job#jar}.

---

##### `maven`<sup>Optional</sup> <a name="maven" id="@cdktf/provider-databricks.job.JobTaskLibrary.property.maven"></a>

```java
public JobTaskLibraryMaven getMaven();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobTaskLibraryMaven">JobTaskLibraryMaven</a>

maven block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#maven Job#maven}

---

##### `pypi`<sup>Optional</sup> <a name="pypi" id="@cdktf/provider-databricks.job.JobTaskLibrary.property.pypi"></a>

```java
public JobTaskLibraryPypi getPypi();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobTaskLibraryPypi">JobTaskLibraryPypi</a>

pypi block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#pypi Job#pypi}

---

##### `whl`<sup>Optional</sup> <a name="whl" id="@cdktf/provider-databricks.job.JobTaskLibrary.property.whl"></a>

```java
public java.lang.String getWhl();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#whl Job#whl}.

---

### JobTaskLibraryCran <a name="JobTaskLibraryCran" id="@cdktf/provider-databricks.job.JobTaskLibraryCran"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-databricks.job.JobTaskLibraryCran.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobTaskLibraryCran;

JobTaskLibraryCran.builder()
    .package(java.lang.String)
//  .repo(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskLibraryCran.property.package">package</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#package Job#package}. |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskLibraryCran.property.repo">repo</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#repo Job#repo}. |

---

##### `package`<sup>Required</sup> <a name="package" id="@cdktf/provider-databricks.job.JobTaskLibraryCran.property.package"></a>

```java
public java.lang.String getPackage();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#package Job#package}.

---

##### `repo`<sup>Optional</sup> <a name="repo" id="@cdktf/provider-databricks.job.JobTaskLibraryCran.property.repo"></a>

```java
public java.lang.String getRepo();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#repo Job#repo}.

---

### JobTaskLibraryMaven <a name="JobTaskLibraryMaven" id="@cdktf/provider-databricks.job.JobTaskLibraryMaven"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-databricks.job.JobTaskLibraryMaven.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobTaskLibraryMaven;

JobTaskLibraryMaven.builder()
    .coordinates(java.lang.String)
//  .exclusions(java.util.List<java.lang.String>)
//  .repo(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskLibraryMaven.property.coordinates">coordinates</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#coordinates Job#coordinates}. |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskLibraryMaven.property.exclusions">exclusions</a></code> | <code>java.util.List<java.lang.String></code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#exclusions Job#exclusions}. |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskLibraryMaven.property.repo">repo</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#repo Job#repo}. |

---

##### `coordinates`<sup>Required</sup> <a name="coordinates" id="@cdktf/provider-databricks.job.JobTaskLibraryMaven.property.coordinates"></a>

```java
public java.lang.String getCoordinates();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#coordinates Job#coordinates}.

---

##### `exclusions`<sup>Optional</sup> <a name="exclusions" id="@cdktf/provider-databricks.job.JobTaskLibraryMaven.property.exclusions"></a>

```java
public java.util.List<java.lang.String> getExclusions();
```

- *Type:* java.util.List<java.lang.String>

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#exclusions Job#exclusions}.

---

##### `repo`<sup>Optional</sup> <a name="repo" id="@cdktf/provider-databricks.job.JobTaskLibraryMaven.property.repo"></a>

```java
public java.lang.String getRepo();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#repo Job#repo}.

---

### JobTaskLibraryPypi <a name="JobTaskLibraryPypi" id="@cdktf/provider-databricks.job.JobTaskLibraryPypi"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-databricks.job.JobTaskLibraryPypi.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobTaskLibraryPypi;

JobTaskLibraryPypi.builder()
    .package(java.lang.String)
//  .repo(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskLibraryPypi.property.package">package</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#package Job#package}. |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskLibraryPypi.property.repo">repo</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#repo Job#repo}. |

---

##### `package`<sup>Required</sup> <a name="package" id="@cdktf/provider-databricks.job.JobTaskLibraryPypi.property.package"></a>

```java
public java.lang.String getPackage();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#package Job#package}.

---

##### `repo`<sup>Optional</sup> <a name="repo" id="@cdktf/provider-databricks.job.JobTaskLibraryPypi.property.repo"></a>

```java
public java.lang.String getRepo();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#repo Job#repo}.

---

### JobTaskNewCluster <a name="JobTaskNewCluster" id="@cdktf/provider-databricks.job.JobTaskNewCluster"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-databricks.job.JobTaskNewCluster.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobTaskNewCluster;

JobTaskNewCluster.builder()
    .sparkVersion(java.lang.String)
//  .applyPolicyDefaultValues(java.lang.Boolean)
//  .applyPolicyDefaultValues(IResolvable)
//  .autoscale(JobTaskNewClusterAutoscale)
//  .autoterminationMinutes(java.lang.Number)
//  .awsAttributes(JobTaskNewClusterAwsAttributes)
//  .azureAttributes(JobTaskNewClusterAzureAttributes)
//  .clusterId(java.lang.String)
//  .clusterLogConf(JobTaskNewClusterClusterLogConf)
//  .clusterMountInfo(IResolvable)
//  .clusterMountInfo(java.util.List<JobTaskNewClusterClusterMountInfo>)
//  .clusterName(java.lang.String)
//  .customTags(java.util.Map<java.lang.String, java.lang.String>)
//  .dataSecurityMode(java.lang.String)
//  .dockerImage(JobTaskNewClusterDockerImage)
//  .driverInstancePoolId(java.lang.String)
//  .driverNodeTypeId(java.lang.String)
//  .enableElasticDisk(java.lang.Boolean)
//  .enableElasticDisk(IResolvable)
//  .enableLocalDiskEncryption(java.lang.Boolean)
//  .enableLocalDiskEncryption(IResolvable)
//  .gcpAttributes(JobTaskNewClusterGcpAttributes)
//  .idempotencyToken(java.lang.String)
//  .initScripts(IResolvable)
//  .initScripts(java.util.List<JobTaskNewClusterInitScripts>)
//  .instancePoolId(java.lang.String)
//  .nodeTypeId(java.lang.String)
//  .numWorkers(java.lang.Number)
//  .policyId(java.lang.String)
//  .runtimeEngine(java.lang.String)
//  .singleUserName(java.lang.String)
//  .sparkConf(java.util.Map<java.lang.String, java.lang.String>)
//  .sparkEnvVars(java.util.Map<java.lang.String, java.lang.String>)
//  .sshPublicKeys(java.util.List<java.lang.String>)
//  .workloadType(JobTaskNewClusterWorkloadType)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskNewCluster.property.sparkVersion">sparkVersion</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#spark_version Job#spark_version}. |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskNewCluster.property.applyPolicyDefaultValues">applyPolicyDefaultValues</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#apply_policy_default_values Job#apply_policy_default_values}. |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskNewCluster.property.autoscale">autoscale</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobTaskNewClusterAutoscale">JobTaskNewClusterAutoscale</a></code> | autoscale block. |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskNewCluster.property.autoterminationMinutes">autoterminationMinutes</a></code> | <code>java.lang.Number</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#autotermination_minutes Job#autotermination_minutes}. |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskNewCluster.property.awsAttributes">awsAttributes</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobTaskNewClusterAwsAttributes">JobTaskNewClusterAwsAttributes</a></code> | aws_attributes block. |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskNewCluster.property.azureAttributes">azureAttributes</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobTaskNewClusterAzureAttributes">JobTaskNewClusterAzureAttributes</a></code> | azure_attributes block. |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskNewCluster.property.clusterId">clusterId</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#cluster_id Job#cluster_id}. |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskNewCluster.property.clusterLogConf">clusterLogConf</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobTaskNewClusterClusterLogConf">JobTaskNewClusterClusterLogConf</a></code> | cluster_log_conf block. |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskNewCluster.property.clusterMountInfo">clusterMountInfo</a></code> | <code>com.hashicorp.cdktf.IResolvable OR java.util.List<<a href="#@cdktf/provider-databricks.job.JobTaskNewClusterClusterMountInfo">JobTaskNewClusterClusterMountInfo</a>></code> | cluster_mount_info block. |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskNewCluster.property.clusterName">clusterName</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#cluster_name Job#cluster_name}. |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskNewCluster.property.customTags">customTags</a></code> | <code>java.util.Map<java.lang.String, java.lang.String></code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#custom_tags Job#custom_tags}. |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskNewCluster.property.dataSecurityMode">dataSecurityMode</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#data_security_mode Job#data_security_mode}. |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskNewCluster.property.dockerImage">dockerImage</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobTaskNewClusterDockerImage">JobTaskNewClusterDockerImage</a></code> | docker_image block. |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskNewCluster.property.driverInstancePoolId">driverInstancePoolId</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#driver_instance_pool_id Job#driver_instance_pool_id}. |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskNewCluster.property.driverNodeTypeId">driverNodeTypeId</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#driver_node_type_id Job#driver_node_type_id}. |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskNewCluster.property.enableElasticDisk">enableElasticDisk</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#enable_elastic_disk Job#enable_elastic_disk}. |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskNewCluster.property.enableLocalDiskEncryption">enableLocalDiskEncryption</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#enable_local_disk_encryption Job#enable_local_disk_encryption}. |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskNewCluster.property.gcpAttributes">gcpAttributes</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobTaskNewClusterGcpAttributes">JobTaskNewClusterGcpAttributes</a></code> | gcp_attributes block. |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskNewCluster.property.idempotencyToken">idempotencyToken</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#idempotency_token Job#idempotency_token}. |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskNewCluster.property.initScripts">initScripts</a></code> | <code>com.hashicorp.cdktf.IResolvable OR java.util.List<<a href="#@cdktf/provider-databricks.job.JobTaskNewClusterInitScripts">JobTaskNewClusterInitScripts</a>></code> | init_scripts block. |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskNewCluster.property.instancePoolId">instancePoolId</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#instance_pool_id Job#instance_pool_id}. |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskNewCluster.property.nodeTypeId">nodeTypeId</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#node_type_id Job#node_type_id}. |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskNewCluster.property.numWorkers">numWorkers</a></code> | <code>java.lang.Number</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#num_workers Job#num_workers}. |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskNewCluster.property.policyId">policyId</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#policy_id Job#policy_id}. |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskNewCluster.property.runtimeEngine">runtimeEngine</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#runtime_engine Job#runtime_engine}. |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskNewCluster.property.singleUserName">singleUserName</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#single_user_name Job#single_user_name}. |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskNewCluster.property.sparkConf">sparkConf</a></code> | <code>java.util.Map<java.lang.String, java.lang.String></code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#spark_conf Job#spark_conf}. |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskNewCluster.property.sparkEnvVars">sparkEnvVars</a></code> | <code>java.util.Map<java.lang.String, java.lang.String></code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#spark_env_vars Job#spark_env_vars}. |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskNewCluster.property.sshPublicKeys">sshPublicKeys</a></code> | <code>java.util.List<java.lang.String></code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#ssh_public_keys Job#ssh_public_keys}. |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskNewCluster.property.workloadType">workloadType</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobTaskNewClusterWorkloadType">JobTaskNewClusterWorkloadType</a></code> | workload_type block. |

---

##### `sparkVersion`<sup>Required</sup> <a name="sparkVersion" id="@cdktf/provider-databricks.job.JobTaskNewCluster.property.sparkVersion"></a>

```java
public java.lang.String getSparkVersion();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#spark_version Job#spark_version}.

---

##### `applyPolicyDefaultValues`<sup>Optional</sup> <a name="applyPolicyDefaultValues" id="@cdktf/provider-databricks.job.JobTaskNewCluster.property.applyPolicyDefaultValues"></a>

```java
public java.lang.Object getApplyPolicyDefaultValues();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#apply_policy_default_values Job#apply_policy_default_values}.

---

##### `autoscale`<sup>Optional</sup> <a name="autoscale" id="@cdktf/provider-databricks.job.JobTaskNewCluster.property.autoscale"></a>

```java
public JobTaskNewClusterAutoscale getAutoscale();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobTaskNewClusterAutoscale">JobTaskNewClusterAutoscale</a>

autoscale block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#autoscale Job#autoscale}

---

##### `autoterminationMinutes`<sup>Optional</sup> <a name="autoterminationMinutes" id="@cdktf/provider-databricks.job.JobTaskNewCluster.property.autoterminationMinutes"></a>

```java
public java.lang.Number getAutoterminationMinutes();
```

- *Type:* java.lang.Number

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#autotermination_minutes Job#autotermination_minutes}.

---

##### `awsAttributes`<sup>Optional</sup> <a name="awsAttributes" id="@cdktf/provider-databricks.job.JobTaskNewCluster.property.awsAttributes"></a>

```java
public JobTaskNewClusterAwsAttributes getAwsAttributes();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobTaskNewClusterAwsAttributes">JobTaskNewClusterAwsAttributes</a>

aws_attributes block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#aws_attributes Job#aws_attributes}

---

##### `azureAttributes`<sup>Optional</sup> <a name="azureAttributes" id="@cdktf/provider-databricks.job.JobTaskNewCluster.property.azureAttributes"></a>

```java
public JobTaskNewClusterAzureAttributes getAzureAttributes();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobTaskNewClusterAzureAttributes">JobTaskNewClusterAzureAttributes</a>

azure_attributes block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#azure_attributes Job#azure_attributes}

---

##### `clusterId`<sup>Optional</sup> <a name="clusterId" id="@cdktf/provider-databricks.job.JobTaskNewCluster.property.clusterId"></a>

```java
public java.lang.String getClusterId();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#cluster_id Job#cluster_id}.

---

##### `clusterLogConf`<sup>Optional</sup> <a name="clusterLogConf" id="@cdktf/provider-databricks.job.JobTaskNewCluster.property.clusterLogConf"></a>

```java
public JobTaskNewClusterClusterLogConf getClusterLogConf();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobTaskNewClusterClusterLogConf">JobTaskNewClusterClusterLogConf</a>

cluster_log_conf block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#cluster_log_conf Job#cluster_log_conf}

---

##### `clusterMountInfo`<sup>Optional</sup> <a name="clusterMountInfo" id="@cdktf/provider-databricks.job.JobTaskNewCluster.property.clusterMountInfo"></a>

```java
public java.lang.Object getClusterMountInfo();
```

- *Type:* com.hashicorp.cdktf.IResolvable OR java.util.List<<a href="#@cdktf/provider-databricks.job.JobTaskNewClusterClusterMountInfo">JobTaskNewClusterClusterMountInfo</a>>

cluster_mount_info block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#cluster_mount_info Job#cluster_mount_info}

---

##### `clusterName`<sup>Optional</sup> <a name="clusterName" id="@cdktf/provider-databricks.job.JobTaskNewCluster.property.clusterName"></a>

```java
public java.lang.String getClusterName();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#cluster_name Job#cluster_name}.

---

##### `customTags`<sup>Optional</sup> <a name="customTags" id="@cdktf/provider-databricks.job.JobTaskNewCluster.property.customTags"></a>

```java
public java.util.Map<java.lang.String, java.lang.String> getCustomTags();
```

- *Type:* java.util.Map<java.lang.String, java.lang.String>

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#custom_tags Job#custom_tags}.

---

##### `dataSecurityMode`<sup>Optional</sup> <a name="dataSecurityMode" id="@cdktf/provider-databricks.job.JobTaskNewCluster.property.dataSecurityMode"></a>

```java
public java.lang.String getDataSecurityMode();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#data_security_mode Job#data_security_mode}.

---

##### `dockerImage`<sup>Optional</sup> <a name="dockerImage" id="@cdktf/provider-databricks.job.JobTaskNewCluster.property.dockerImage"></a>

```java
public JobTaskNewClusterDockerImage getDockerImage();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobTaskNewClusterDockerImage">JobTaskNewClusterDockerImage</a>

docker_image block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#docker_image Job#docker_image}

---

##### `driverInstancePoolId`<sup>Optional</sup> <a name="driverInstancePoolId" id="@cdktf/provider-databricks.job.JobTaskNewCluster.property.driverInstancePoolId"></a>

```java
public java.lang.String getDriverInstancePoolId();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#driver_instance_pool_id Job#driver_instance_pool_id}.

---

##### `driverNodeTypeId`<sup>Optional</sup> <a name="driverNodeTypeId" id="@cdktf/provider-databricks.job.JobTaskNewCluster.property.driverNodeTypeId"></a>

```java
public java.lang.String getDriverNodeTypeId();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#driver_node_type_id Job#driver_node_type_id}.

---

##### `enableElasticDisk`<sup>Optional</sup> <a name="enableElasticDisk" id="@cdktf/provider-databricks.job.JobTaskNewCluster.property.enableElasticDisk"></a>

```java
public java.lang.Object getEnableElasticDisk();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#enable_elastic_disk Job#enable_elastic_disk}.

---

##### `enableLocalDiskEncryption`<sup>Optional</sup> <a name="enableLocalDiskEncryption" id="@cdktf/provider-databricks.job.JobTaskNewCluster.property.enableLocalDiskEncryption"></a>

```java
public java.lang.Object getEnableLocalDiskEncryption();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#enable_local_disk_encryption Job#enable_local_disk_encryption}.

---

##### `gcpAttributes`<sup>Optional</sup> <a name="gcpAttributes" id="@cdktf/provider-databricks.job.JobTaskNewCluster.property.gcpAttributes"></a>

```java
public JobTaskNewClusterGcpAttributes getGcpAttributes();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobTaskNewClusterGcpAttributes">JobTaskNewClusterGcpAttributes</a>

gcp_attributes block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#gcp_attributes Job#gcp_attributes}

---

##### `idempotencyToken`<sup>Optional</sup> <a name="idempotencyToken" id="@cdktf/provider-databricks.job.JobTaskNewCluster.property.idempotencyToken"></a>

```java
public java.lang.String getIdempotencyToken();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#idempotency_token Job#idempotency_token}.

---

##### `initScripts`<sup>Optional</sup> <a name="initScripts" id="@cdktf/provider-databricks.job.JobTaskNewCluster.property.initScripts"></a>

```java
public java.lang.Object getInitScripts();
```

- *Type:* com.hashicorp.cdktf.IResolvable OR java.util.List<<a href="#@cdktf/provider-databricks.job.JobTaskNewClusterInitScripts">JobTaskNewClusterInitScripts</a>>

init_scripts block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#init_scripts Job#init_scripts}

---

##### `instancePoolId`<sup>Optional</sup> <a name="instancePoolId" id="@cdktf/provider-databricks.job.JobTaskNewCluster.property.instancePoolId"></a>

```java
public java.lang.String getInstancePoolId();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#instance_pool_id Job#instance_pool_id}.

---

##### `nodeTypeId`<sup>Optional</sup> <a name="nodeTypeId" id="@cdktf/provider-databricks.job.JobTaskNewCluster.property.nodeTypeId"></a>

```java
public java.lang.String getNodeTypeId();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#node_type_id Job#node_type_id}.

---

##### `numWorkers`<sup>Optional</sup> <a name="numWorkers" id="@cdktf/provider-databricks.job.JobTaskNewCluster.property.numWorkers"></a>

```java
public java.lang.Number getNumWorkers();
```

- *Type:* java.lang.Number

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#num_workers Job#num_workers}.

---

##### `policyId`<sup>Optional</sup> <a name="policyId" id="@cdktf/provider-databricks.job.JobTaskNewCluster.property.policyId"></a>

```java
public java.lang.String getPolicyId();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#policy_id Job#policy_id}.

---

##### `runtimeEngine`<sup>Optional</sup> <a name="runtimeEngine" id="@cdktf/provider-databricks.job.JobTaskNewCluster.property.runtimeEngine"></a>

```java
public java.lang.String getRuntimeEngine();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#runtime_engine Job#runtime_engine}.

---

##### `singleUserName`<sup>Optional</sup> <a name="singleUserName" id="@cdktf/provider-databricks.job.JobTaskNewCluster.property.singleUserName"></a>

```java
public java.lang.String getSingleUserName();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#single_user_name Job#single_user_name}.

---

##### `sparkConf`<sup>Optional</sup> <a name="sparkConf" id="@cdktf/provider-databricks.job.JobTaskNewCluster.property.sparkConf"></a>

```java
public java.util.Map<java.lang.String, java.lang.String> getSparkConf();
```

- *Type:* java.util.Map<java.lang.String, java.lang.String>

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#spark_conf Job#spark_conf}.

---

##### `sparkEnvVars`<sup>Optional</sup> <a name="sparkEnvVars" id="@cdktf/provider-databricks.job.JobTaskNewCluster.property.sparkEnvVars"></a>

```java
public java.util.Map<java.lang.String, java.lang.String> getSparkEnvVars();
```

- *Type:* java.util.Map<java.lang.String, java.lang.String>

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#spark_env_vars Job#spark_env_vars}.

---

##### `sshPublicKeys`<sup>Optional</sup> <a name="sshPublicKeys" id="@cdktf/provider-databricks.job.JobTaskNewCluster.property.sshPublicKeys"></a>

```java
public java.util.List<java.lang.String> getSshPublicKeys();
```

- *Type:* java.util.List<java.lang.String>

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#ssh_public_keys Job#ssh_public_keys}.

---

##### `workloadType`<sup>Optional</sup> <a name="workloadType" id="@cdktf/provider-databricks.job.JobTaskNewCluster.property.workloadType"></a>

```java
public JobTaskNewClusterWorkloadType getWorkloadType();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobTaskNewClusterWorkloadType">JobTaskNewClusterWorkloadType</a>

workload_type block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#workload_type Job#workload_type}

---

### JobTaskNewClusterAutoscale <a name="JobTaskNewClusterAutoscale" id="@cdktf/provider-databricks.job.JobTaskNewClusterAutoscale"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-databricks.job.JobTaskNewClusterAutoscale.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobTaskNewClusterAutoscale;

JobTaskNewClusterAutoscale.builder()
//  .maxWorkers(java.lang.Number)
//  .minWorkers(java.lang.Number)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskNewClusterAutoscale.property.maxWorkers">maxWorkers</a></code> | <code>java.lang.Number</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#max_workers Job#max_workers}. |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskNewClusterAutoscale.property.minWorkers">minWorkers</a></code> | <code>java.lang.Number</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#min_workers Job#min_workers}. |

---

##### `maxWorkers`<sup>Optional</sup> <a name="maxWorkers" id="@cdktf/provider-databricks.job.JobTaskNewClusterAutoscale.property.maxWorkers"></a>

```java
public java.lang.Number getMaxWorkers();
```

- *Type:* java.lang.Number

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#max_workers Job#max_workers}.

---

##### `minWorkers`<sup>Optional</sup> <a name="minWorkers" id="@cdktf/provider-databricks.job.JobTaskNewClusterAutoscale.property.minWorkers"></a>

```java
public java.lang.Number getMinWorkers();
```

- *Type:* java.lang.Number

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#min_workers Job#min_workers}.

---

### JobTaskNewClusterAwsAttributes <a name="JobTaskNewClusterAwsAttributes" id="@cdktf/provider-databricks.job.JobTaskNewClusterAwsAttributes"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-databricks.job.JobTaskNewClusterAwsAttributes.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobTaskNewClusterAwsAttributes;

JobTaskNewClusterAwsAttributes.builder()
//  .availability(java.lang.String)
//  .ebsVolumeCount(java.lang.Number)
//  .ebsVolumeSize(java.lang.Number)
//  .ebsVolumeType(java.lang.String)
//  .firstOnDemand(java.lang.Number)
//  .instanceProfileArn(java.lang.String)
//  .spotBidPricePercent(java.lang.Number)
//  .zoneId(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskNewClusterAwsAttributes.property.availability">availability</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#availability Job#availability}. |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskNewClusterAwsAttributes.property.ebsVolumeCount">ebsVolumeCount</a></code> | <code>java.lang.Number</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#ebs_volume_count Job#ebs_volume_count}. |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskNewClusterAwsAttributes.property.ebsVolumeSize">ebsVolumeSize</a></code> | <code>java.lang.Number</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#ebs_volume_size Job#ebs_volume_size}. |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskNewClusterAwsAttributes.property.ebsVolumeType">ebsVolumeType</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#ebs_volume_type Job#ebs_volume_type}. |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskNewClusterAwsAttributes.property.firstOnDemand">firstOnDemand</a></code> | <code>java.lang.Number</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#first_on_demand Job#first_on_demand}. |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskNewClusterAwsAttributes.property.instanceProfileArn">instanceProfileArn</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#instance_profile_arn Job#instance_profile_arn}. |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskNewClusterAwsAttributes.property.spotBidPricePercent">spotBidPricePercent</a></code> | <code>java.lang.Number</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#spot_bid_price_percent Job#spot_bid_price_percent}. |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskNewClusterAwsAttributes.property.zoneId">zoneId</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#zone_id Job#zone_id}. |

---

##### `availability`<sup>Optional</sup> <a name="availability" id="@cdktf/provider-databricks.job.JobTaskNewClusterAwsAttributes.property.availability"></a>

```java
public java.lang.String getAvailability();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#availability Job#availability}.

---

##### `ebsVolumeCount`<sup>Optional</sup> <a name="ebsVolumeCount" id="@cdktf/provider-databricks.job.JobTaskNewClusterAwsAttributes.property.ebsVolumeCount"></a>

```java
public java.lang.Number getEbsVolumeCount();
```

- *Type:* java.lang.Number

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#ebs_volume_count Job#ebs_volume_count}.

---

##### `ebsVolumeSize`<sup>Optional</sup> <a name="ebsVolumeSize" id="@cdktf/provider-databricks.job.JobTaskNewClusterAwsAttributes.property.ebsVolumeSize"></a>

```java
public java.lang.Number getEbsVolumeSize();
```

- *Type:* java.lang.Number

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#ebs_volume_size Job#ebs_volume_size}.

---

##### `ebsVolumeType`<sup>Optional</sup> <a name="ebsVolumeType" id="@cdktf/provider-databricks.job.JobTaskNewClusterAwsAttributes.property.ebsVolumeType"></a>

```java
public java.lang.String getEbsVolumeType();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#ebs_volume_type Job#ebs_volume_type}.

---

##### `firstOnDemand`<sup>Optional</sup> <a name="firstOnDemand" id="@cdktf/provider-databricks.job.JobTaskNewClusterAwsAttributes.property.firstOnDemand"></a>

```java
public java.lang.Number getFirstOnDemand();
```

- *Type:* java.lang.Number

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#first_on_demand Job#first_on_demand}.

---

##### `instanceProfileArn`<sup>Optional</sup> <a name="instanceProfileArn" id="@cdktf/provider-databricks.job.JobTaskNewClusterAwsAttributes.property.instanceProfileArn"></a>

```java
public java.lang.String getInstanceProfileArn();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#instance_profile_arn Job#instance_profile_arn}.

---

##### `spotBidPricePercent`<sup>Optional</sup> <a name="spotBidPricePercent" id="@cdktf/provider-databricks.job.JobTaskNewClusterAwsAttributes.property.spotBidPricePercent"></a>

```java
public java.lang.Number getSpotBidPricePercent();
```

- *Type:* java.lang.Number

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#spot_bid_price_percent Job#spot_bid_price_percent}.

---

##### `zoneId`<sup>Optional</sup> <a name="zoneId" id="@cdktf/provider-databricks.job.JobTaskNewClusterAwsAttributes.property.zoneId"></a>

```java
public java.lang.String getZoneId();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#zone_id Job#zone_id}.

---

### JobTaskNewClusterAzureAttributes <a name="JobTaskNewClusterAzureAttributes" id="@cdktf/provider-databricks.job.JobTaskNewClusterAzureAttributes"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-databricks.job.JobTaskNewClusterAzureAttributes.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobTaskNewClusterAzureAttributes;

JobTaskNewClusterAzureAttributes.builder()
//  .availability(java.lang.String)
//  .firstOnDemand(java.lang.Number)
//  .spotBidMaxPrice(java.lang.Number)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskNewClusterAzureAttributes.property.availability">availability</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#availability Job#availability}. |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskNewClusterAzureAttributes.property.firstOnDemand">firstOnDemand</a></code> | <code>java.lang.Number</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#first_on_demand Job#first_on_demand}. |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskNewClusterAzureAttributes.property.spotBidMaxPrice">spotBidMaxPrice</a></code> | <code>java.lang.Number</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#spot_bid_max_price Job#spot_bid_max_price}. |

---

##### `availability`<sup>Optional</sup> <a name="availability" id="@cdktf/provider-databricks.job.JobTaskNewClusterAzureAttributes.property.availability"></a>

```java
public java.lang.String getAvailability();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#availability Job#availability}.

---

##### `firstOnDemand`<sup>Optional</sup> <a name="firstOnDemand" id="@cdktf/provider-databricks.job.JobTaskNewClusterAzureAttributes.property.firstOnDemand"></a>

```java
public java.lang.Number getFirstOnDemand();
```

- *Type:* java.lang.Number

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#first_on_demand Job#first_on_demand}.

---

##### `spotBidMaxPrice`<sup>Optional</sup> <a name="spotBidMaxPrice" id="@cdktf/provider-databricks.job.JobTaskNewClusterAzureAttributes.property.spotBidMaxPrice"></a>

```java
public java.lang.Number getSpotBidMaxPrice();
```

- *Type:* java.lang.Number

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#spot_bid_max_price Job#spot_bid_max_price}.

---

### JobTaskNewClusterClusterLogConf <a name="JobTaskNewClusterClusterLogConf" id="@cdktf/provider-databricks.job.JobTaskNewClusterClusterLogConf"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-databricks.job.JobTaskNewClusterClusterLogConf.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobTaskNewClusterClusterLogConf;

JobTaskNewClusterClusterLogConf.builder()
//  .dbfs(JobTaskNewClusterClusterLogConfDbfs)
//  .s3(JobTaskNewClusterClusterLogConfS3)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskNewClusterClusterLogConf.property.dbfs">dbfs</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobTaskNewClusterClusterLogConfDbfs">JobTaskNewClusterClusterLogConfDbfs</a></code> | dbfs block. |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskNewClusterClusterLogConf.property.s3">s3</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobTaskNewClusterClusterLogConfS3">JobTaskNewClusterClusterLogConfS3</a></code> | s3 block. |

---

##### `dbfs`<sup>Optional</sup> <a name="dbfs" id="@cdktf/provider-databricks.job.JobTaskNewClusterClusterLogConf.property.dbfs"></a>

```java
public JobTaskNewClusterClusterLogConfDbfs getDbfs();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobTaskNewClusterClusterLogConfDbfs">JobTaskNewClusterClusterLogConfDbfs</a>

dbfs block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#dbfs Job#dbfs}

---

##### `s3`<sup>Optional</sup> <a name="s3" id="@cdktf/provider-databricks.job.JobTaskNewClusterClusterLogConf.property.s3"></a>

```java
public JobTaskNewClusterClusterLogConfS3 getS3();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobTaskNewClusterClusterLogConfS3">JobTaskNewClusterClusterLogConfS3</a>

s3 block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#s3 Job#s3}

---

### JobTaskNewClusterClusterLogConfDbfs <a name="JobTaskNewClusterClusterLogConfDbfs" id="@cdktf/provider-databricks.job.JobTaskNewClusterClusterLogConfDbfs"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-databricks.job.JobTaskNewClusterClusterLogConfDbfs.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobTaskNewClusterClusterLogConfDbfs;

JobTaskNewClusterClusterLogConfDbfs.builder()
    .destination(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskNewClusterClusterLogConfDbfs.property.destination">destination</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#destination Job#destination}. |

---

##### `destination`<sup>Required</sup> <a name="destination" id="@cdktf/provider-databricks.job.JobTaskNewClusterClusterLogConfDbfs.property.destination"></a>

```java
public java.lang.String getDestination();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#destination Job#destination}.

---

### JobTaskNewClusterClusterLogConfS3 <a name="JobTaskNewClusterClusterLogConfS3" id="@cdktf/provider-databricks.job.JobTaskNewClusterClusterLogConfS3"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-databricks.job.JobTaskNewClusterClusterLogConfS3.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobTaskNewClusterClusterLogConfS3;

JobTaskNewClusterClusterLogConfS3.builder()
    .destination(java.lang.String)
//  .cannedAcl(java.lang.String)
//  .enableEncryption(java.lang.Boolean)
//  .enableEncryption(IResolvable)
//  .encryptionType(java.lang.String)
//  .endpoint(java.lang.String)
//  .kmsKey(java.lang.String)
//  .region(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskNewClusterClusterLogConfS3.property.destination">destination</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#destination Job#destination}. |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskNewClusterClusterLogConfS3.property.cannedAcl">cannedAcl</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#canned_acl Job#canned_acl}. |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskNewClusterClusterLogConfS3.property.enableEncryption">enableEncryption</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#enable_encryption Job#enable_encryption}. |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskNewClusterClusterLogConfS3.property.encryptionType">encryptionType</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#encryption_type Job#encryption_type}. |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskNewClusterClusterLogConfS3.property.endpoint">endpoint</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#endpoint Job#endpoint}. |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskNewClusterClusterLogConfS3.property.kmsKey">kmsKey</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#kms_key Job#kms_key}. |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskNewClusterClusterLogConfS3.property.region">region</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#region Job#region}. |

---

##### `destination`<sup>Required</sup> <a name="destination" id="@cdktf/provider-databricks.job.JobTaskNewClusterClusterLogConfS3.property.destination"></a>

```java
public java.lang.String getDestination();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#destination Job#destination}.

---

##### `cannedAcl`<sup>Optional</sup> <a name="cannedAcl" id="@cdktf/provider-databricks.job.JobTaskNewClusterClusterLogConfS3.property.cannedAcl"></a>

```java
public java.lang.String getCannedAcl();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#canned_acl Job#canned_acl}.

---

##### `enableEncryption`<sup>Optional</sup> <a name="enableEncryption" id="@cdktf/provider-databricks.job.JobTaskNewClusterClusterLogConfS3.property.enableEncryption"></a>

```java
public java.lang.Object getEnableEncryption();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#enable_encryption Job#enable_encryption}.

---

##### `encryptionType`<sup>Optional</sup> <a name="encryptionType" id="@cdktf/provider-databricks.job.JobTaskNewClusterClusterLogConfS3.property.encryptionType"></a>

```java
public java.lang.String getEncryptionType();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#encryption_type Job#encryption_type}.

---

##### `endpoint`<sup>Optional</sup> <a name="endpoint" id="@cdktf/provider-databricks.job.JobTaskNewClusterClusterLogConfS3.property.endpoint"></a>

```java
public java.lang.String getEndpoint();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#endpoint Job#endpoint}.

---

##### `kmsKey`<sup>Optional</sup> <a name="kmsKey" id="@cdktf/provider-databricks.job.JobTaskNewClusterClusterLogConfS3.property.kmsKey"></a>

```java
public java.lang.String getKmsKey();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#kms_key Job#kms_key}.

---

##### `region`<sup>Optional</sup> <a name="region" id="@cdktf/provider-databricks.job.JobTaskNewClusterClusterLogConfS3.property.region"></a>

```java
public java.lang.String getRegion();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#region Job#region}.

---

### JobTaskNewClusterClusterMountInfo <a name="JobTaskNewClusterClusterMountInfo" id="@cdktf/provider-databricks.job.JobTaskNewClusterClusterMountInfo"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-databricks.job.JobTaskNewClusterClusterMountInfo.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobTaskNewClusterClusterMountInfo;

JobTaskNewClusterClusterMountInfo.builder()
    .localMountDirPath(java.lang.String)
    .networkFilesystemInfo(JobTaskNewClusterClusterMountInfoNetworkFilesystemInfo)
//  .remoteMountDirPath(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskNewClusterClusterMountInfo.property.localMountDirPath">localMountDirPath</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#local_mount_dir_path Job#local_mount_dir_path}. |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskNewClusterClusterMountInfo.property.networkFilesystemInfo">networkFilesystemInfo</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobTaskNewClusterClusterMountInfoNetworkFilesystemInfo">JobTaskNewClusterClusterMountInfoNetworkFilesystemInfo</a></code> | network_filesystem_info block. |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskNewClusterClusterMountInfo.property.remoteMountDirPath">remoteMountDirPath</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#remote_mount_dir_path Job#remote_mount_dir_path}. |

---

##### `localMountDirPath`<sup>Required</sup> <a name="localMountDirPath" id="@cdktf/provider-databricks.job.JobTaskNewClusterClusterMountInfo.property.localMountDirPath"></a>

```java
public java.lang.String getLocalMountDirPath();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#local_mount_dir_path Job#local_mount_dir_path}.

---

##### `networkFilesystemInfo`<sup>Required</sup> <a name="networkFilesystemInfo" id="@cdktf/provider-databricks.job.JobTaskNewClusterClusterMountInfo.property.networkFilesystemInfo"></a>

```java
public JobTaskNewClusterClusterMountInfoNetworkFilesystemInfo getNetworkFilesystemInfo();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobTaskNewClusterClusterMountInfoNetworkFilesystemInfo">JobTaskNewClusterClusterMountInfoNetworkFilesystemInfo</a>

network_filesystem_info block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#network_filesystem_info Job#network_filesystem_info}

---

##### `remoteMountDirPath`<sup>Optional</sup> <a name="remoteMountDirPath" id="@cdktf/provider-databricks.job.JobTaskNewClusterClusterMountInfo.property.remoteMountDirPath"></a>

```java
public java.lang.String getRemoteMountDirPath();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#remote_mount_dir_path Job#remote_mount_dir_path}.

---

### JobTaskNewClusterClusterMountInfoNetworkFilesystemInfo <a name="JobTaskNewClusterClusterMountInfoNetworkFilesystemInfo" id="@cdktf/provider-databricks.job.JobTaskNewClusterClusterMountInfoNetworkFilesystemInfo"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-databricks.job.JobTaskNewClusterClusterMountInfoNetworkFilesystemInfo.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobTaskNewClusterClusterMountInfoNetworkFilesystemInfo;

JobTaskNewClusterClusterMountInfoNetworkFilesystemInfo.builder()
    .serverAddress(java.lang.String)
//  .mountOptions(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskNewClusterClusterMountInfoNetworkFilesystemInfo.property.serverAddress">serverAddress</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#server_address Job#server_address}. |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskNewClusterClusterMountInfoNetworkFilesystemInfo.property.mountOptions">mountOptions</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#mount_options Job#mount_options}. |

---

##### `serverAddress`<sup>Required</sup> <a name="serverAddress" id="@cdktf/provider-databricks.job.JobTaskNewClusterClusterMountInfoNetworkFilesystemInfo.property.serverAddress"></a>

```java
public java.lang.String getServerAddress();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#server_address Job#server_address}.

---

##### `mountOptions`<sup>Optional</sup> <a name="mountOptions" id="@cdktf/provider-databricks.job.JobTaskNewClusterClusterMountInfoNetworkFilesystemInfo.property.mountOptions"></a>

```java
public java.lang.String getMountOptions();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#mount_options Job#mount_options}.

---

### JobTaskNewClusterDockerImage <a name="JobTaskNewClusterDockerImage" id="@cdktf/provider-databricks.job.JobTaskNewClusterDockerImage"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-databricks.job.JobTaskNewClusterDockerImage.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobTaskNewClusterDockerImage;

JobTaskNewClusterDockerImage.builder()
    .url(java.lang.String)
//  .basicAuth(JobTaskNewClusterDockerImageBasicAuth)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskNewClusterDockerImage.property.url">url</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#url Job#url}. |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskNewClusterDockerImage.property.basicAuth">basicAuth</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobTaskNewClusterDockerImageBasicAuth">JobTaskNewClusterDockerImageBasicAuth</a></code> | basic_auth block. |

---

##### `url`<sup>Required</sup> <a name="url" id="@cdktf/provider-databricks.job.JobTaskNewClusterDockerImage.property.url"></a>

```java
public java.lang.String getUrl();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#url Job#url}.

---

##### `basicAuth`<sup>Optional</sup> <a name="basicAuth" id="@cdktf/provider-databricks.job.JobTaskNewClusterDockerImage.property.basicAuth"></a>

```java
public JobTaskNewClusterDockerImageBasicAuth getBasicAuth();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobTaskNewClusterDockerImageBasicAuth">JobTaskNewClusterDockerImageBasicAuth</a>

basic_auth block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#basic_auth Job#basic_auth}

---

### JobTaskNewClusterDockerImageBasicAuth <a name="JobTaskNewClusterDockerImageBasicAuth" id="@cdktf/provider-databricks.job.JobTaskNewClusterDockerImageBasicAuth"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-databricks.job.JobTaskNewClusterDockerImageBasicAuth.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobTaskNewClusterDockerImageBasicAuth;

JobTaskNewClusterDockerImageBasicAuth.builder()
    .password(java.lang.String)
    .username(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskNewClusterDockerImageBasicAuth.property.password">password</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#password Job#password}. |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskNewClusterDockerImageBasicAuth.property.username">username</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#username Job#username}. |

---

##### `password`<sup>Required</sup> <a name="password" id="@cdktf/provider-databricks.job.JobTaskNewClusterDockerImageBasicAuth.property.password"></a>

```java
public java.lang.String getPassword();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#password Job#password}.

---

##### `username`<sup>Required</sup> <a name="username" id="@cdktf/provider-databricks.job.JobTaskNewClusterDockerImageBasicAuth.property.username"></a>

```java
public java.lang.String getUsername();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#username Job#username}.

---

### JobTaskNewClusterGcpAttributes <a name="JobTaskNewClusterGcpAttributes" id="@cdktf/provider-databricks.job.JobTaskNewClusterGcpAttributes"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-databricks.job.JobTaskNewClusterGcpAttributes.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobTaskNewClusterGcpAttributes;

JobTaskNewClusterGcpAttributes.builder()
//  .availability(java.lang.String)
//  .bootDiskSize(java.lang.Number)
//  .googleServiceAccount(java.lang.String)
//  .usePreemptibleExecutors(java.lang.Boolean)
//  .usePreemptibleExecutors(IResolvable)
//  .zoneId(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskNewClusterGcpAttributes.property.availability">availability</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#availability Job#availability}. |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskNewClusterGcpAttributes.property.bootDiskSize">bootDiskSize</a></code> | <code>java.lang.Number</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#boot_disk_size Job#boot_disk_size}. |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskNewClusterGcpAttributes.property.googleServiceAccount">googleServiceAccount</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#google_service_account Job#google_service_account}. |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskNewClusterGcpAttributes.property.usePreemptibleExecutors">usePreemptibleExecutors</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#use_preemptible_executors Job#use_preemptible_executors}. |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskNewClusterGcpAttributes.property.zoneId">zoneId</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#zone_id Job#zone_id}. |

---

##### `availability`<sup>Optional</sup> <a name="availability" id="@cdktf/provider-databricks.job.JobTaskNewClusterGcpAttributes.property.availability"></a>

```java
public java.lang.String getAvailability();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#availability Job#availability}.

---

##### `bootDiskSize`<sup>Optional</sup> <a name="bootDiskSize" id="@cdktf/provider-databricks.job.JobTaskNewClusterGcpAttributes.property.bootDiskSize"></a>

```java
public java.lang.Number getBootDiskSize();
```

- *Type:* java.lang.Number

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#boot_disk_size Job#boot_disk_size}.

---

##### `googleServiceAccount`<sup>Optional</sup> <a name="googleServiceAccount" id="@cdktf/provider-databricks.job.JobTaskNewClusterGcpAttributes.property.googleServiceAccount"></a>

```java
public java.lang.String getGoogleServiceAccount();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#google_service_account Job#google_service_account}.

---

##### `usePreemptibleExecutors`<sup>Optional</sup> <a name="usePreemptibleExecutors" id="@cdktf/provider-databricks.job.JobTaskNewClusterGcpAttributes.property.usePreemptibleExecutors"></a>

```java
public java.lang.Object getUsePreemptibleExecutors();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#use_preemptible_executors Job#use_preemptible_executors}.

---

##### `zoneId`<sup>Optional</sup> <a name="zoneId" id="@cdktf/provider-databricks.job.JobTaskNewClusterGcpAttributes.property.zoneId"></a>

```java
public java.lang.String getZoneId();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#zone_id Job#zone_id}.

---

### JobTaskNewClusterInitScripts <a name="JobTaskNewClusterInitScripts" id="@cdktf/provider-databricks.job.JobTaskNewClusterInitScripts"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-databricks.job.JobTaskNewClusterInitScripts.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobTaskNewClusterInitScripts;

JobTaskNewClusterInitScripts.builder()
//  .abfss(JobTaskNewClusterInitScriptsAbfss)
//  .dbfs(JobTaskNewClusterInitScriptsDbfs)
//  .file(JobTaskNewClusterInitScriptsFile)
//  .gcs(JobTaskNewClusterInitScriptsGcs)
//  .s3(JobTaskNewClusterInitScriptsS3)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskNewClusterInitScripts.property.abfss">abfss</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobTaskNewClusterInitScriptsAbfss">JobTaskNewClusterInitScriptsAbfss</a></code> | abfss block. |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskNewClusterInitScripts.property.dbfs">dbfs</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobTaskNewClusterInitScriptsDbfs">JobTaskNewClusterInitScriptsDbfs</a></code> | dbfs block. |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskNewClusterInitScripts.property.file">file</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobTaskNewClusterInitScriptsFile">JobTaskNewClusterInitScriptsFile</a></code> | file block. |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskNewClusterInitScripts.property.gcs">gcs</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobTaskNewClusterInitScriptsGcs">JobTaskNewClusterInitScriptsGcs</a></code> | gcs block. |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskNewClusterInitScripts.property.s3">s3</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobTaskNewClusterInitScriptsS3">JobTaskNewClusterInitScriptsS3</a></code> | s3 block. |

---

##### `abfss`<sup>Optional</sup> <a name="abfss" id="@cdktf/provider-databricks.job.JobTaskNewClusterInitScripts.property.abfss"></a>

```java
public JobTaskNewClusterInitScriptsAbfss getAbfss();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobTaskNewClusterInitScriptsAbfss">JobTaskNewClusterInitScriptsAbfss</a>

abfss block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#abfss Job#abfss}

---

##### `dbfs`<sup>Optional</sup> <a name="dbfs" id="@cdktf/provider-databricks.job.JobTaskNewClusterInitScripts.property.dbfs"></a>

```java
public JobTaskNewClusterInitScriptsDbfs getDbfs();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobTaskNewClusterInitScriptsDbfs">JobTaskNewClusterInitScriptsDbfs</a>

dbfs block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#dbfs Job#dbfs}

---

##### `file`<sup>Optional</sup> <a name="file" id="@cdktf/provider-databricks.job.JobTaskNewClusterInitScripts.property.file"></a>

```java
public JobTaskNewClusterInitScriptsFile getFile();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobTaskNewClusterInitScriptsFile">JobTaskNewClusterInitScriptsFile</a>

file block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#file Job#file}

---

##### `gcs`<sup>Optional</sup> <a name="gcs" id="@cdktf/provider-databricks.job.JobTaskNewClusterInitScripts.property.gcs"></a>

```java
public JobTaskNewClusterInitScriptsGcs getGcs();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobTaskNewClusterInitScriptsGcs">JobTaskNewClusterInitScriptsGcs</a>

gcs block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#gcs Job#gcs}

---

##### `s3`<sup>Optional</sup> <a name="s3" id="@cdktf/provider-databricks.job.JobTaskNewClusterInitScripts.property.s3"></a>

```java
public JobTaskNewClusterInitScriptsS3 getS3();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobTaskNewClusterInitScriptsS3">JobTaskNewClusterInitScriptsS3</a>

s3 block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#s3 Job#s3}

---

### JobTaskNewClusterInitScriptsAbfss <a name="JobTaskNewClusterInitScriptsAbfss" id="@cdktf/provider-databricks.job.JobTaskNewClusterInitScriptsAbfss"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-databricks.job.JobTaskNewClusterInitScriptsAbfss.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobTaskNewClusterInitScriptsAbfss;

JobTaskNewClusterInitScriptsAbfss.builder()
//  .destination(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskNewClusterInitScriptsAbfss.property.destination">destination</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#destination Job#destination}. |

---

##### `destination`<sup>Optional</sup> <a name="destination" id="@cdktf/provider-databricks.job.JobTaskNewClusterInitScriptsAbfss.property.destination"></a>

```java
public java.lang.String getDestination();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#destination Job#destination}.

---

### JobTaskNewClusterInitScriptsDbfs <a name="JobTaskNewClusterInitScriptsDbfs" id="@cdktf/provider-databricks.job.JobTaskNewClusterInitScriptsDbfs"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-databricks.job.JobTaskNewClusterInitScriptsDbfs.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobTaskNewClusterInitScriptsDbfs;

JobTaskNewClusterInitScriptsDbfs.builder()
    .destination(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskNewClusterInitScriptsDbfs.property.destination">destination</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#destination Job#destination}. |

---

##### `destination`<sup>Required</sup> <a name="destination" id="@cdktf/provider-databricks.job.JobTaskNewClusterInitScriptsDbfs.property.destination"></a>

```java
public java.lang.String getDestination();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#destination Job#destination}.

---

### JobTaskNewClusterInitScriptsFile <a name="JobTaskNewClusterInitScriptsFile" id="@cdktf/provider-databricks.job.JobTaskNewClusterInitScriptsFile"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-databricks.job.JobTaskNewClusterInitScriptsFile.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobTaskNewClusterInitScriptsFile;

JobTaskNewClusterInitScriptsFile.builder()
//  .destination(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskNewClusterInitScriptsFile.property.destination">destination</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#destination Job#destination}. |

---

##### `destination`<sup>Optional</sup> <a name="destination" id="@cdktf/provider-databricks.job.JobTaskNewClusterInitScriptsFile.property.destination"></a>

```java
public java.lang.String getDestination();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#destination Job#destination}.

---

### JobTaskNewClusterInitScriptsGcs <a name="JobTaskNewClusterInitScriptsGcs" id="@cdktf/provider-databricks.job.JobTaskNewClusterInitScriptsGcs"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-databricks.job.JobTaskNewClusterInitScriptsGcs.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobTaskNewClusterInitScriptsGcs;

JobTaskNewClusterInitScriptsGcs.builder()
//  .destination(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskNewClusterInitScriptsGcs.property.destination">destination</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#destination Job#destination}. |

---

##### `destination`<sup>Optional</sup> <a name="destination" id="@cdktf/provider-databricks.job.JobTaskNewClusterInitScriptsGcs.property.destination"></a>

```java
public java.lang.String getDestination();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#destination Job#destination}.

---

### JobTaskNewClusterInitScriptsS3 <a name="JobTaskNewClusterInitScriptsS3" id="@cdktf/provider-databricks.job.JobTaskNewClusterInitScriptsS3"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-databricks.job.JobTaskNewClusterInitScriptsS3.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobTaskNewClusterInitScriptsS3;

JobTaskNewClusterInitScriptsS3.builder()
    .destination(java.lang.String)
//  .cannedAcl(java.lang.String)
//  .enableEncryption(java.lang.Boolean)
//  .enableEncryption(IResolvable)
//  .encryptionType(java.lang.String)
//  .endpoint(java.lang.String)
//  .kmsKey(java.lang.String)
//  .region(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskNewClusterInitScriptsS3.property.destination">destination</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#destination Job#destination}. |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskNewClusterInitScriptsS3.property.cannedAcl">cannedAcl</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#canned_acl Job#canned_acl}. |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskNewClusterInitScriptsS3.property.enableEncryption">enableEncryption</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#enable_encryption Job#enable_encryption}. |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskNewClusterInitScriptsS3.property.encryptionType">encryptionType</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#encryption_type Job#encryption_type}. |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskNewClusterInitScriptsS3.property.endpoint">endpoint</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#endpoint Job#endpoint}. |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskNewClusterInitScriptsS3.property.kmsKey">kmsKey</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#kms_key Job#kms_key}. |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskNewClusterInitScriptsS3.property.region">region</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#region Job#region}. |

---

##### `destination`<sup>Required</sup> <a name="destination" id="@cdktf/provider-databricks.job.JobTaskNewClusterInitScriptsS3.property.destination"></a>

```java
public java.lang.String getDestination();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#destination Job#destination}.

---

##### `cannedAcl`<sup>Optional</sup> <a name="cannedAcl" id="@cdktf/provider-databricks.job.JobTaskNewClusterInitScriptsS3.property.cannedAcl"></a>

```java
public java.lang.String getCannedAcl();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#canned_acl Job#canned_acl}.

---

##### `enableEncryption`<sup>Optional</sup> <a name="enableEncryption" id="@cdktf/provider-databricks.job.JobTaskNewClusterInitScriptsS3.property.enableEncryption"></a>

```java
public java.lang.Object getEnableEncryption();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#enable_encryption Job#enable_encryption}.

---

##### `encryptionType`<sup>Optional</sup> <a name="encryptionType" id="@cdktf/provider-databricks.job.JobTaskNewClusterInitScriptsS3.property.encryptionType"></a>

```java
public java.lang.String getEncryptionType();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#encryption_type Job#encryption_type}.

---

##### `endpoint`<sup>Optional</sup> <a name="endpoint" id="@cdktf/provider-databricks.job.JobTaskNewClusterInitScriptsS3.property.endpoint"></a>

```java
public java.lang.String getEndpoint();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#endpoint Job#endpoint}.

---

##### `kmsKey`<sup>Optional</sup> <a name="kmsKey" id="@cdktf/provider-databricks.job.JobTaskNewClusterInitScriptsS3.property.kmsKey"></a>

```java
public java.lang.String getKmsKey();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#kms_key Job#kms_key}.

---

##### `region`<sup>Optional</sup> <a name="region" id="@cdktf/provider-databricks.job.JobTaskNewClusterInitScriptsS3.property.region"></a>

```java
public java.lang.String getRegion();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#region Job#region}.

---

### JobTaskNewClusterWorkloadType <a name="JobTaskNewClusterWorkloadType" id="@cdktf/provider-databricks.job.JobTaskNewClusterWorkloadType"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-databricks.job.JobTaskNewClusterWorkloadType.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobTaskNewClusterWorkloadType;

JobTaskNewClusterWorkloadType.builder()
    .clients(JobTaskNewClusterWorkloadTypeClients)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskNewClusterWorkloadType.property.clients">clients</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobTaskNewClusterWorkloadTypeClients">JobTaskNewClusterWorkloadTypeClients</a></code> | clients block. |

---

##### `clients`<sup>Required</sup> <a name="clients" id="@cdktf/provider-databricks.job.JobTaskNewClusterWorkloadType.property.clients"></a>

```java
public JobTaskNewClusterWorkloadTypeClients getClients();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobTaskNewClusterWorkloadTypeClients">JobTaskNewClusterWorkloadTypeClients</a>

clients block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#clients Job#clients}

---

### JobTaskNewClusterWorkloadTypeClients <a name="JobTaskNewClusterWorkloadTypeClients" id="@cdktf/provider-databricks.job.JobTaskNewClusterWorkloadTypeClients"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-databricks.job.JobTaskNewClusterWorkloadTypeClients.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobTaskNewClusterWorkloadTypeClients;

JobTaskNewClusterWorkloadTypeClients.builder()
//  .jobs(java.lang.Boolean)
//  .jobs(IResolvable)
//  .notebooks(java.lang.Boolean)
//  .notebooks(IResolvable)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskNewClusterWorkloadTypeClients.property.jobs">jobs</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#jobs Job#jobs}. |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskNewClusterWorkloadTypeClients.property.notebooks">notebooks</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#notebooks Job#notebooks}. |

---

##### `jobs`<sup>Optional</sup> <a name="jobs" id="@cdktf/provider-databricks.job.JobTaskNewClusterWorkloadTypeClients.property.jobs"></a>

```java
public java.lang.Object getJobs();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#jobs Job#jobs}.

---

##### `notebooks`<sup>Optional</sup> <a name="notebooks" id="@cdktf/provider-databricks.job.JobTaskNewClusterWorkloadTypeClients.property.notebooks"></a>

```java
public java.lang.Object getNotebooks();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#notebooks Job#notebooks}.

---

### JobTaskNotebookTask <a name="JobTaskNotebookTask" id="@cdktf/provider-databricks.job.JobTaskNotebookTask"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-databricks.job.JobTaskNotebookTask.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobTaskNotebookTask;

JobTaskNotebookTask.builder()
    .notebookPath(java.lang.String)
//  .baseParameters(java.util.Map<java.lang.String, java.lang.String>)
//  .source(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskNotebookTask.property.notebookPath">notebookPath</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#notebook_path Job#notebook_path}. |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskNotebookTask.property.baseParameters">baseParameters</a></code> | <code>java.util.Map<java.lang.String, java.lang.String></code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#base_parameters Job#base_parameters}. |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskNotebookTask.property.source">source</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#source Job#source}. |

---

##### `notebookPath`<sup>Required</sup> <a name="notebookPath" id="@cdktf/provider-databricks.job.JobTaskNotebookTask.property.notebookPath"></a>

```java
public java.lang.String getNotebookPath();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#notebook_path Job#notebook_path}.

---

##### `baseParameters`<sup>Optional</sup> <a name="baseParameters" id="@cdktf/provider-databricks.job.JobTaskNotebookTask.property.baseParameters"></a>

```java
public java.util.Map<java.lang.String, java.lang.String> getBaseParameters();
```

- *Type:* java.util.Map<java.lang.String, java.lang.String>

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#base_parameters Job#base_parameters}.

---

##### `source`<sup>Optional</sup> <a name="source" id="@cdktf/provider-databricks.job.JobTaskNotebookTask.property.source"></a>

```java
public java.lang.String getSource();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#source Job#source}.

---

### JobTaskPipelineTask <a name="JobTaskPipelineTask" id="@cdktf/provider-databricks.job.JobTaskPipelineTask"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-databricks.job.JobTaskPipelineTask.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobTaskPipelineTask;

JobTaskPipelineTask.builder()
    .pipelineId(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskPipelineTask.property.pipelineId">pipelineId</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#pipeline_id Job#pipeline_id}. |

---

##### `pipelineId`<sup>Required</sup> <a name="pipelineId" id="@cdktf/provider-databricks.job.JobTaskPipelineTask.property.pipelineId"></a>

```java
public java.lang.String getPipelineId();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#pipeline_id Job#pipeline_id}.

---

### JobTaskPythonWheelTask <a name="JobTaskPythonWheelTask" id="@cdktf/provider-databricks.job.JobTaskPythonWheelTask"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-databricks.job.JobTaskPythonWheelTask.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobTaskPythonWheelTask;

JobTaskPythonWheelTask.builder()
//  .entryPoint(java.lang.String)
//  .namedParameters(java.util.Map<java.lang.String, java.lang.String>)
//  .packageName(java.lang.String)
//  .parameters(java.util.List<java.lang.String>)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskPythonWheelTask.property.entryPoint">entryPoint</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#entry_point Job#entry_point}. |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskPythonWheelTask.property.namedParameters">namedParameters</a></code> | <code>java.util.Map<java.lang.String, java.lang.String></code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#named_parameters Job#named_parameters}. |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskPythonWheelTask.property.packageName">packageName</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#package_name Job#package_name}. |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskPythonWheelTask.property.parameters">parameters</a></code> | <code>java.util.List<java.lang.String></code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#parameters Job#parameters}. |

---

##### `entryPoint`<sup>Optional</sup> <a name="entryPoint" id="@cdktf/provider-databricks.job.JobTaskPythonWheelTask.property.entryPoint"></a>

```java
public java.lang.String getEntryPoint();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#entry_point Job#entry_point}.

---

##### `namedParameters`<sup>Optional</sup> <a name="namedParameters" id="@cdktf/provider-databricks.job.JobTaskPythonWheelTask.property.namedParameters"></a>

```java
public java.util.Map<java.lang.String, java.lang.String> getNamedParameters();
```

- *Type:* java.util.Map<java.lang.String, java.lang.String>

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#named_parameters Job#named_parameters}.

---

##### `packageName`<sup>Optional</sup> <a name="packageName" id="@cdktf/provider-databricks.job.JobTaskPythonWheelTask.property.packageName"></a>

```java
public java.lang.String getPackageName();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#package_name Job#package_name}.

---

##### `parameters`<sup>Optional</sup> <a name="parameters" id="@cdktf/provider-databricks.job.JobTaskPythonWheelTask.property.parameters"></a>

```java
public java.util.List<java.lang.String> getParameters();
```

- *Type:* java.util.List<java.lang.String>

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#parameters Job#parameters}.

---

### JobTaskSparkJarTask <a name="JobTaskSparkJarTask" id="@cdktf/provider-databricks.job.JobTaskSparkJarTask"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-databricks.job.JobTaskSparkJarTask.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobTaskSparkJarTask;

JobTaskSparkJarTask.builder()
//  .jarUri(java.lang.String)
//  .mainClassName(java.lang.String)
//  .parameters(java.util.List<java.lang.String>)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskSparkJarTask.property.jarUri">jarUri</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#jar_uri Job#jar_uri}. |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskSparkJarTask.property.mainClassName">mainClassName</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#main_class_name Job#main_class_name}. |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskSparkJarTask.property.parameters">parameters</a></code> | <code>java.util.List<java.lang.String></code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#parameters Job#parameters}. |

---

##### `jarUri`<sup>Optional</sup> <a name="jarUri" id="@cdktf/provider-databricks.job.JobTaskSparkJarTask.property.jarUri"></a>

```java
public java.lang.String getJarUri();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#jar_uri Job#jar_uri}.

---

##### `mainClassName`<sup>Optional</sup> <a name="mainClassName" id="@cdktf/provider-databricks.job.JobTaskSparkJarTask.property.mainClassName"></a>

```java
public java.lang.String getMainClassName();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#main_class_name Job#main_class_name}.

---

##### `parameters`<sup>Optional</sup> <a name="parameters" id="@cdktf/provider-databricks.job.JobTaskSparkJarTask.property.parameters"></a>

```java
public java.util.List<java.lang.String> getParameters();
```

- *Type:* java.util.List<java.lang.String>

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#parameters Job#parameters}.

---

### JobTaskSparkPythonTask <a name="JobTaskSparkPythonTask" id="@cdktf/provider-databricks.job.JobTaskSparkPythonTask"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-databricks.job.JobTaskSparkPythonTask.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobTaskSparkPythonTask;

JobTaskSparkPythonTask.builder()
    .pythonFile(java.lang.String)
//  .parameters(java.util.List<java.lang.String>)
//  .source(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskSparkPythonTask.property.pythonFile">pythonFile</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#python_file Job#python_file}. |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskSparkPythonTask.property.parameters">parameters</a></code> | <code>java.util.List<java.lang.String></code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#parameters Job#parameters}. |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskSparkPythonTask.property.source">source</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#source Job#source}. |

---

##### `pythonFile`<sup>Required</sup> <a name="pythonFile" id="@cdktf/provider-databricks.job.JobTaskSparkPythonTask.property.pythonFile"></a>

```java
public java.lang.String getPythonFile();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#python_file Job#python_file}.

---

##### `parameters`<sup>Optional</sup> <a name="parameters" id="@cdktf/provider-databricks.job.JobTaskSparkPythonTask.property.parameters"></a>

```java
public java.util.List<java.lang.String> getParameters();
```

- *Type:* java.util.List<java.lang.String>

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#parameters Job#parameters}.

---

##### `source`<sup>Optional</sup> <a name="source" id="@cdktf/provider-databricks.job.JobTaskSparkPythonTask.property.source"></a>

```java
public java.lang.String getSource();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#source Job#source}.

---

### JobTaskSparkSubmitTask <a name="JobTaskSparkSubmitTask" id="@cdktf/provider-databricks.job.JobTaskSparkSubmitTask"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-databricks.job.JobTaskSparkSubmitTask.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobTaskSparkSubmitTask;

JobTaskSparkSubmitTask.builder()
//  .parameters(java.util.List<java.lang.String>)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskSparkSubmitTask.property.parameters">parameters</a></code> | <code>java.util.List<java.lang.String></code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#parameters Job#parameters}. |

---

##### `parameters`<sup>Optional</sup> <a name="parameters" id="@cdktf/provider-databricks.job.JobTaskSparkSubmitTask.property.parameters"></a>

```java
public java.util.List<java.lang.String> getParameters();
```

- *Type:* java.util.List<java.lang.String>

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#parameters Job#parameters}.

---

### JobTaskSqlTask <a name="JobTaskSqlTask" id="@cdktf/provider-databricks.job.JobTaskSqlTask"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-databricks.job.JobTaskSqlTask.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobTaskSqlTask;

JobTaskSqlTask.builder()
//  .alert(JobTaskSqlTaskAlert)
//  .dashboard(JobTaskSqlTaskDashboard)
//  .file(JobTaskSqlTaskFile)
//  .parameters(java.util.Map<java.lang.String, java.lang.String>)
//  .query(JobTaskSqlTaskQuery)
//  .warehouseId(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskSqlTask.property.alert">alert</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobTaskSqlTaskAlert">JobTaskSqlTaskAlert</a></code> | alert block. |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskSqlTask.property.dashboard">dashboard</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobTaskSqlTaskDashboard">JobTaskSqlTaskDashboard</a></code> | dashboard block. |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskSqlTask.property.file">file</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobTaskSqlTaskFile">JobTaskSqlTaskFile</a></code> | file block. |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskSqlTask.property.parameters">parameters</a></code> | <code>java.util.Map<java.lang.String, java.lang.String></code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#parameters Job#parameters}. |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskSqlTask.property.query">query</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobTaskSqlTaskQuery">JobTaskSqlTaskQuery</a></code> | query block. |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskSqlTask.property.warehouseId">warehouseId</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#warehouse_id Job#warehouse_id}. |

---

##### `alert`<sup>Optional</sup> <a name="alert" id="@cdktf/provider-databricks.job.JobTaskSqlTask.property.alert"></a>

```java
public JobTaskSqlTaskAlert getAlert();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobTaskSqlTaskAlert">JobTaskSqlTaskAlert</a>

alert block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#alert Job#alert}

---

##### `dashboard`<sup>Optional</sup> <a name="dashboard" id="@cdktf/provider-databricks.job.JobTaskSqlTask.property.dashboard"></a>

```java
public JobTaskSqlTaskDashboard getDashboard();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobTaskSqlTaskDashboard">JobTaskSqlTaskDashboard</a>

dashboard block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#dashboard Job#dashboard}

---

##### `file`<sup>Optional</sup> <a name="file" id="@cdktf/provider-databricks.job.JobTaskSqlTask.property.file"></a>

```java
public JobTaskSqlTaskFile getFile();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobTaskSqlTaskFile">JobTaskSqlTaskFile</a>

file block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#file Job#file}

---

##### `parameters`<sup>Optional</sup> <a name="parameters" id="@cdktf/provider-databricks.job.JobTaskSqlTask.property.parameters"></a>

```java
public java.util.Map<java.lang.String, java.lang.String> getParameters();
```

- *Type:* java.util.Map<java.lang.String, java.lang.String>

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#parameters Job#parameters}.

---

##### `query`<sup>Optional</sup> <a name="query" id="@cdktf/provider-databricks.job.JobTaskSqlTask.property.query"></a>

```java
public JobTaskSqlTaskQuery getQuery();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobTaskSqlTaskQuery">JobTaskSqlTaskQuery</a>

query block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#query Job#query}

---

##### `warehouseId`<sup>Optional</sup> <a name="warehouseId" id="@cdktf/provider-databricks.job.JobTaskSqlTask.property.warehouseId"></a>

```java
public java.lang.String getWarehouseId();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#warehouse_id Job#warehouse_id}.

---

### JobTaskSqlTaskAlert <a name="JobTaskSqlTaskAlert" id="@cdktf/provider-databricks.job.JobTaskSqlTaskAlert"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-databricks.job.JobTaskSqlTaskAlert.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobTaskSqlTaskAlert;

JobTaskSqlTaskAlert.builder()
    .alertId(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskSqlTaskAlert.property.alertId">alertId</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#alert_id Job#alert_id}. |

---

##### `alertId`<sup>Required</sup> <a name="alertId" id="@cdktf/provider-databricks.job.JobTaskSqlTaskAlert.property.alertId"></a>

```java
public java.lang.String getAlertId();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#alert_id Job#alert_id}.

---

### JobTaskSqlTaskDashboard <a name="JobTaskSqlTaskDashboard" id="@cdktf/provider-databricks.job.JobTaskSqlTaskDashboard"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-databricks.job.JobTaskSqlTaskDashboard.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobTaskSqlTaskDashboard;

JobTaskSqlTaskDashboard.builder()
    .dashboardId(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskSqlTaskDashboard.property.dashboardId">dashboardId</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#dashboard_id Job#dashboard_id}. |

---

##### `dashboardId`<sup>Required</sup> <a name="dashboardId" id="@cdktf/provider-databricks.job.JobTaskSqlTaskDashboard.property.dashboardId"></a>

```java
public java.lang.String getDashboardId();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#dashboard_id Job#dashboard_id}.

---

### JobTaskSqlTaskFile <a name="JobTaskSqlTaskFile" id="@cdktf/provider-databricks.job.JobTaskSqlTaskFile"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-databricks.job.JobTaskSqlTaskFile.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobTaskSqlTaskFile;

JobTaskSqlTaskFile.builder()
    .path(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskSqlTaskFile.property.path">path</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#path Job#path}. |

---

##### `path`<sup>Required</sup> <a name="path" id="@cdktf/provider-databricks.job.JobTaskSqlTaskFile.property.path"></a>

```java
public java.lang.String getPath();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#path Job#path}.

---

### JobTaskSqlTaskQuery <a name="JobTaskSqlTaskQuery" id="@cdktf/provider-databricks.job.JobTaskSqlTaskQuery"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-databricks.job.JobTaskSqlTaskQuery.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobTaskSqlTaskQuery;

JobTaskSqlTaskQuery.builder()
    .queryId(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobTaskSqlTaskQuery.property.queryId">queryId</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#query_id Job#query_id}. |

---

##### `queryId`<sup>Required</sup> <a name="queryId" id="@cdktf/provider-databricks.job.JobTaskSqlTaskQuery.property.queryId"></a>

```java
public java.lang.String getQueryId();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#query_id Job#query_id}.

---

### JobTimeouts <a name="JobTimeouts" id="@cdktf/provider-databricks.job.JobTimeouts"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-databricks.job.JobTimeouts.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobTimeouts;

JobTimeouts.builder()
//  .create(java.lang.String)
//  .update(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobTimeouts.property.create">create</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#create Job#create}. |
| <code><a href="#@cdktf/provider-databricks.job.JobTimeouts.property.update">update</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#update Job#update}. |

---

##### `create`<sup>Optional</sup> <a name="create" id="@cdktf/provider-databricks.job.JobTimeouts.property.create"></a>

```java
public java.lang.String getCreate();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#create Job#create}.

---

##### `update`<sup>Optional</sup> <a name="update" id="@cdktf/provider-databricks.job.JobTimeouts.property.update"></a>

```java
public java.lang.String getUpdate();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#update Job#update}.

---

### JobTrigger <a name="JobTrigger" id="@cdktf/provider-databricks.job.JobTrigger"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-databricks.job.JobTrigger.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobTrigger;

JobTrigger.builder()
    .fileArrival(JobTriggerFileArrival)
//  .pauseStatus(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobTrigger.property.fileArrival">fileArrival</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobTriggerFileArrival">JobTriggerFileArrival</a></code> | file_arrival block. |
| <code><a href="#@cdktf/provider-databricks.job.JobTrigger.property.pauseStatus">pauseStatus</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#pause_status Job#pause_status}. |

---

##### `fileArrival`<sup>Required</sup> <a name="fileArrival" id="@cdktf/provider-databricks.job.JobTrigger.property.fileArrival"></a>

```java
public JobTriggerFileArrival getFileArrival();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobTriggerFileArrival">JobTriggerFileArrival</a>

file_arrival block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#file_arrival Job#file_arrival}

---

##### `pauseStatus`<sup>Optional</sup> <a name="pauseStatus" id="@cdktf/provider-databricks.job.JobTrigger.property.pauseStatus"></a>

```java
public java.lang.String getPauseStatus();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#pause_status Job#pause_status}.

---

### JobTriggerFileArrival <a name="JobTriggerFileArrival" id="@cdktf/provider-databricks.job.JobTriggerFileArrival"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-databricks.job.JobTriggerFileArrival.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobTriggerFileArrival;

JobTriggerFileArrival.builder()
    .url(java.lang.String)
//  .minTimeBetweenTriggerSeconds(java.lang.Number)
//  .waitAfterLastChangeSeconds(java.lang.Number)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobTriggerFileArrival.property.url">url</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#url Job#url}. |
| <code><a href="#@cdktf/provider-databricks.job.JobTriggerFileArrival.property.minTimeBetweenTriggerSeconds">minTimeBetweenTriggerSeconds</a></code> | <code>java.lang.Number</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#min_time_between_trigger_seconds Job#min_time_between_trigger_seconds}. |
| <code><a href="#@cdktf/provider-databricks.job.JobTriggerFileArrival.property.waitAfterLastChangeSeconds">waitAfterLastChangeSeconds</a></code> | <code>java.lang.Number</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#wait_after_last_change_seconds Job#wait_after_last_change_seconds}. |

---

##### `url`<sup>Required</sup> <a name="url" id="@cdktf/provider-databricks.job.JobTriggerFileArrival.property.url"></a>

```java
public java.lang.String getUrl();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#url Job#url}.

---

##### `minTimeBetweenTriggerSeconds`<sup>Optional</sup> <a name="minTimeBetweenTriggerSeconds" id="@cdktf/provider-databricks.job.JobTriggerFileArrival.property.minTimeBetweenTriggerSeconds"></a>

```java
public java.lang.Number getMinTimeBetweenTriggerSeconds();
```

- *Type:* java.lang.Number

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#min_time_between_trigger_seconds Job#min_time_between_trigger_seconds}.

---

##### `waitAfterLastChangeSeconds`<sup>Optional</sup> <a name="waitAfterLastChangeSeconds" id="@cdktf/provider-databricks.job.JobTriggerFileArrival.property.waitAfterLastChangeSeconds"></a>

```java
public java.lang.Number getWaitAfterLastChangeSeconds();
```

- *Type:* java.lang.Number

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#wait_after_last_change_seconds Job#wait_after_last_change_seconds}.

---

### JobWebhookNotifications <a name="JobWebhookNotifications" id="@cdktf/provider-databricks.job.JobWebhookNotifications"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-databricks.job.JobWebhookNotifications.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobWebhookNotifications;

JobWebhookNotifications.builder()
//  .onFailure(IResolvable)
//  .onFailure(java.util.List<JobWebhookNotificationsOnFailure>)
//  .onStart(IResolvable)
//  .onStart(java.util.List<JobWebhookNotificationsOnStart>)
//  .onSuccess(IResolvable)
//  .onSuccess(java.util.List<JobWebhookNotificationsOnSuccess>)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobWebhookNotifications.property.onFailure">onFailure</a></code> | <code>com.hashicorp.cdktf.IResolvable OR java.util.List<<a href="#@cdktf/provider-databricks.job.JobWebhookNotificationsOnFailure">JobWebhookNotificationsOnFailure</a>></code> | on_failure block. |
| <code><a href="#@cdktf/provider-databricks.job.JobWebhookNotifications.property.onStart">onStart</a></code> | <code>com.hashicorp.cdktf.IResolvable OR java.util.List<<a href="#@cdktf/provider-databricks.job.JobWebhookNotificationsOnStart">JobWebhookNotificationsOnStart</a>></code> | on_start block. |
| <code><a href="#@cdktf/provider-databricks.job.JobWebhookNotifications.property.onSuccess">onSuccess</a></code> | <code>com.hashicorp.cdktf.IResolvable OR java.util.List<<a href="#@cdktf/provider-databricks.job.JobWebhookNotificationsOnSuccess">JobWebhookNotificationsOnSuccess</a>></code> | on_success block. |

---

##### `onFailure`<sup>Optional</sup> <a name="onFailure" id="@cdktf/provider-databricks.job.JobWebhookNotifications.property.onFailure"></a>

```java
public java.lang.Object getOnFailure();
```

- *Type:* com.hashicorp.cdktf.IResolvable OR java.util.List<<a href="#@cdktf/provider-databricks.job.JobWebhookNotificationsOnFailure">JobWebhookNotificationsOnFailure</a>>

on_failure block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#on_failure Job#on_failure}

---

##### `onStart`<sup>Optional</sup> <a name="onStart" id="@cdktf/provider-databricks.job.JobWebhookNotifications.property.onStart"></a>

```java
public java.lang.Object getOnStart();
```

- *Type:* com.hashicorp.cdktf.IResolvable OR java.util.List<<a href="#@cdktf/provider-databricks.job.JobWebhookNotificationsOnStart">JobWebhookNotificationsOnStart</a>>

on_start block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#on_start Job#on_start}

---

##### `onSuccess`<sup>Optional</sup> <a name="onSuccess" id="@cdktf/provider-databricks.job.JobWebhookNotifications.property.onSuccess"></a>

```java
public java.lang.Object getOnSuccess();
```

- *Type:* com.hashicorp.cdktf.IResolvable OR java.util.List<<a href="#@cdktf/provider-databricks.job.JobWebhookNotificationsOnSuccess">JobWebhookNotificationsOnSuccess</a>>

on_success block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#on_success Job#on_success}

---

### JobWebhookNotificationsOnFailure <a name="JobWebhookNotificationsOnFailure" id="@cdktf/provider-databricks.job.JobWebhookNotificationsOnFailure"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-databricks.job.JobWebhookNotificationsOnFailure.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobWebhookNotificationsOnFailure;

JobWebhookNotificationsOnFailure.builder()
    .id(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobWebhookNotificationsOnFailure.property.id">id</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#id Job#id}. |

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-databricks.job.JobWebhookNotificationsOnFailure.property.id"></a>

```java
public java.lang.String getId();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#id Job#id}.

Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.

---

### JobWebhookNotificationsOnStart <a name="JobWebhookNotificationsOnStart" id="@cdktf/provider-databricks.job.JobWebhookNotificationsOnStart"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-databricks.job.JobWebhookNotificationsOnStart.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobWebhookNotificationsOnStart;

JobWebhookNotificationsOnStart.builder()
    .id(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobWebhookNotificationsOnStart.property.id">id</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#id Job#id}. |

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-databricks.job.JobWebhookNotificationsOnStart.property.id"></a>

```java
public java.lang.String getId();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#id Job#id}.

Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.

---

### JobWebhookNotificationsOnSuccess <a name="JobWebhookNotificationsOnSuccess" id="@cdktf/provider-databricks.job.JobWebhookNotificationsOnSuccess"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-databricks.job.JobWebhookNotificationsOnSuccess.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobWebhookNotificationsOnSuccess;

JobWebhookNotificationsOnSuccess.builder()
    .id(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobWebhookNotificationsOnSuccess.property.id">id</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#id Job#id}. |

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-databricks.job.JobWebhookNotificationsOnSuccess.property.id"></a>

```java
public java.lang.String getId();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#id Job#id}.

Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.

---

## Classes <a name="Classes" id="Classes"></a>

### JobContinuousOutputReference <a name="JobContinuousOutputReference" id="@cdktf/provider-databricks.job.JobContinuousOutputReference"></a>

#### Initializers <a name="Initializers" id="@cdktf/provider-databricks.job.JobContinuousOutputReference.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobContinuousOutputReference;

new JobContinuousOutputReference(IInterpolatingParent terraformResource, java.lang.String terraformAttribute);
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobContinuousOutputReference.Initializer.parameter.terraformResource">terraformResource</a></code> | <code>com.hashicorp.cdktf.IInterpolatingParent</code> | The parent resource. |
| <code><a href="#@cdktf/provider-databricks.job.JobContinuousOutputReference.Initializer.parameter.terraformAttribute">terraformAttribute</a></code> | <code>java.lang.String</code> | The attribute on the parent resource this class is referencing. |

---

##### `terraformResource`<sup>Required</sup> <a name="terraformResource" id="@cdktf/provider-databricks.job.JobContinuousOutputReference.Initializer.parameter.terraformResource"></a>

- *Type:* com.hashicorp.cdktf.IInterpolatingParent

The parent resource.

---

##### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobContinuousOutputReference.Initializer.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

The attribute on the parent resource this class is referencing.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobContinuousOutputReference.computeFqn">computeFqn</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobContinuousOutputReference.getAnyMapAttribute">getAnyMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobContinuousOutputReference.getBooleanAttribute">getBooleanAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobContinuousOutputReference.getBooleanMapAttribute">getBooleanMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobContinuousOutputReference.getListAttribute">getListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobContinuousOutputReference.getNumberAttribute">getNumberAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobContinuousOutputReference.getNumberListAttribute">getNumberListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobContinuousOutputReference.getNumberMapAttribute">getNumberMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobContinuousOutputReference.getStringAttribute">getStringAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobContinuousOutputReference.getStringMapAttribute">getStringMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobContinuousOutputReference.interpolationForAttribute">interpolationForAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobContinuousOutputReference.resolve">resolve</a></code> | Produce the Token's value at resolution time. |
| <code><a href="#@cdktf/provider-databricks.job.JobContinuousOutputReference.toString">toString</a></code> | Return a string representation of this resolvable object. |
| <code><a href="#@cdktf/provider-databricks.job.JobContinuousOutputReference.resetPauseStatus">resetPauseStatus</a></code> | *No description.* |

---

##### `computeFqn` <a name="computeFqn" id="@cdktf/provider-databricks.job.JobContinuousOutputReference.computeFqn"></a>

```java
public java.lang.String computeFqn()
```

##### `getAnyMapAttribute` <a name="getAnyMapAttribute" id="@cdktf/provider-databricks.job.JobContinuousOutputReference.getAnyMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Object> getAnyMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobContinuousOutputReference.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getBooleanAttribute` <a name="getBooleanAttribute" id="@cdktf/provider-databricks.job.JobContinuousOutputReference.getBooleanAttribute"></a>

```java
public IResolvable getBooleanAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobContinuousOutputReference.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getBooleanMapAttribute` <a name="getBooleanMapAttribute" id="@cdktf/provider-databricks.job.JobContinuousOutputReference.getBooleanMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Boolean> getBooleanMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobContinuousOutputReference.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getListAttribute` <a name="getListAttribute" id="@cdktf/provider-databricks.job.JobContinuousOutputReference.getListAttribute"></a>

```java
public java.util.List<java.lang.String> getListAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobContinuousOutputReference.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberAttribute` <a name="getNumberAttribute" id="@cdktf/provider-databricks.job.JobContinuousOutputReference.getNumberAttribute"></a>

```java
public java.lang.Number getNumberAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobContinuousOutputReference.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberListAttribute` <a name="getNumberListAttribute" id="@cdktf/provider-databricks.job.JobContinuousOutputReference.getNumberListAttribute"></a>

```java
public java.util.List<java.lang.Number> getNumberListAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobContinuousOutputReference.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberMapAttribute` <a name="getNumberMapAttribute" id="@cdktf/provider-databricks.job.JobContinuousOutputReference.getNumberMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Number> getNumberMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobContinuousOutputReference.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getStringAttribute` <a name="getStringAttribute" id="@cdktf/provider-databricks.job.JobContinuousOutputReference.getStringAttribute"></a>

```java
public java.lang.String getStringAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobContinuousOutputReference.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getStringMapAttribute` <a name="getStringMapAttribute" id="@cdktf/provider-databricks.job.JobContinuousOutputReference.getStringMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.String> getStringMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobContinuousOutputReference.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `interpolationForAttribute` <a name="interpolationForAttribute" id="@cdktf/provider-databricks.job.JobContinuousOutputReference.interpolationForAttribute"></a>

```java
public IResolvable interpolationForAttribute(java.lang.String property)
```

###### `property`<sup>Required</sup> <a name="property" id="@cdktf/provider-databricks.job.JobContinuousOutputReference.interpolationForAttribute.parameter.property"></a>

- *Type:* java.lang.String

---

##### `resolve` <a name="resolve" id="@cdktf/provider-databricks.job.JobContinuousOutputReference.resolve"></a>

```java
public java.lang.Object resolve(IResolveContext _context)
```

Produce the Token's value at resolution time.

###### `_context`<sup>Required</sup> <a name="_context" id="@cdktf/provider-databricks.job.JobContinuousOutputReference.resolve.parameter._context"></a>

- *Type:* com.hashicorp.cdktf.IResolveContext

---

##### `toString` <a name="toString" id="@cdktf/provider-databricks.job.JobContinuousOutputReference.toString"></a>

```java
public java.lang.String toString()
```

Return a string representation of this resolvable object.

Returns a reversible string representation.

##### `resetPauseStatus` <a name="resetPauseStatus" id="@cdktf/provider-databricks.job.JobContinuousOutputReference.resetPauseStatus"></a>

```java
public void resetPauseStatus()
```


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobContinuousOutputReference.property.creationStack">creationStack</a></code> | <code>java.util.List<java.lang.String></code> | The creation stack of this resolvable which will be appended to errors thrown during resolution. |
| <code><a href="#@cdktf/provider-databricks.job.JobContinuousOutputReference.property.fqn">fqn</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobContinuousOutputReference.property.pauseStatusInput">pauseStatusInput</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobContinuousOutputReference.property.pauseStatus">pauseStatus</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobContinuousOutputReference.property.internalValue">internalValue</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobContinuous">JobContinuous</a></code> | *No description.* |

---

##### `creationStack`<sup>Required</sup> <a name="creationStack" id="@cdktf/provider-databricks.job.JobContinuousOutputReference.property.creationStack"></a>

```java
public java.util.List<java.lang.String> getCreationStack();
```

- *Type:* java.util.List<java.lang.String>

The creation stack of this resolvable which will be appended to errors thrown during resolution.

If this returns an empty array the stack will not be attached.

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-databricks.job.JobContinuousOutputReference.property.fqn"></a>

```java
public java.lang.String getFqn();
```

- *Type:* java.lang.String

---

##### `pauseStatusInput`<sup>Optional</sup> <a name="pauseStatusInput" id="@cdktf/provider-databricks.job.JobContinuousOutputReference.property.pauseStatusInput"></a>

```java
public java.lang.String getPauseStatusInput();
```

- *Type:* java.lang.String

---

##### `pauseStatus`<sup>Required</sup> <a name="pauseStatus" id="@cdktf/provider-databricks.job.JobContinuousOutputReference.property.pauseStatus"></a>

```java
public java.lang.String getPauseStatus();
```

- *Type:* java.lang.String

---

##### `internalValue`<sup>Optional</sup> <a name="internalValue" id="@cdktf/provider-databricks.job.JobContinuousOutputReference.property.internalValue"></a>

```java
public JobContinuous getInternalValue();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobContinuous">JobContinuous</a>

---


### JobDbtTaskOutputReference <a name="JobDbtTaskOutputReference" id="@cdktf/provider-databricks.job.JobDbtTaskOutputReference"></a>

#### Initializers <a name="Initializers" id="@cdktf/provider-databricks.job.JobDbtTaskOutputReference.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobDbtTaskOutputReference;

new JobDbtTaskOutputReference(IInterpolatingParent terraformResource, java.lang.String terraformAttribute);
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobDbtTaskOutputReference.Initializer.parameter.terraformResource">terraformResource</a></code> | <code>com.hashicorp.cdktf.IInterpolatingParent</code> | The parent resource. |
| <code><a href="#@cdktf/provider-databricks.job.JobDbtTaskOutputReference.Initializer.parameter.terraformAttribute">terraformAttribute</a></code> | <code>java.lang.String</code> | The attribute on the parent resource this class is referencing. |

---

##### `terraformResource`<sup>Required</sup> <a name="terraformResource" id="@cdktf/provider-databricks.job.JobDbtTaskOutputReference.Initializer.parameter.terraformResource"></a>

- *Type:* com.hashicorp.cdktf.IInterpolatingParent

The parent resource.

---

##### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobDbtTaskOutputReference.Initializer.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

The attribute on the parent resource this class is referencing.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobDbtTaskOutputReference.computeFqn">computeFqn</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobDbtTaskOutputReference.getAnyMapAttribute">getAnyMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobDbtTaskOutputReference.getBooleanAttribute">getBooleanAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobDbtTaskOutputReference.getBooleanMapAttribute">getBooleanMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobDbtTaskOutputReference.getListAttribute">getListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobDbtTaskOutputReference.getNumberAttribute">getNumberAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobDbtTaskOutputReference.getNumberListAttribute">getNumberListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobDbtTaskOutputReference.getNumberMapAttribute">getNumberMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobDbtTaskOutputReference.getStringAttribute">getStringAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobDbtTaskOutputReference.getStringMapAttribute">getStringMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobDbtTaskOutputReference.interpolationForAttribute">interpolationForAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobDbtTaskOutputReference.resolve">resolve</a></code> | Produce the Token's value at resolution time. |
| <code><a href="#@cdktf/provider-databricks.job.JobDbtTaskOutputReference.toString">toString</a></code> | Return a string representation of this resolvable object. |
| <code><a href="#@cdktf/provider-databricks.job.JobDbtTaskOutputReference.resetCatalog">resetCatalog</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobDbtTaskOutputReference.resetProfilesDirectory">resetProfilesDirectory</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobDbtTaskOutputReference.resetProjectDirectory">resetProjectDirectory</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobDbtTaskOutputReference.resetSchema">resetSchema</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobDbtTaskOutputReference.resetWarehouseId">resetWarehouseId</a></code> | *No description.* |

---

##### `computeFqn` <a name="computeFqn" id="@cdktf/provider-databricks.job.JobDbtTaskOutputReference.computeFqn"></a>

```java
public java.lang.String computeFqn()
```

##### `getAnyMapAttribute` <a name="getAnyMapAttribute" id="@cdktf/provider-databricks.job.JobDbtTaskOutputReference.getAnyMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Object> getAnyMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobDbtTaskOutputReference.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getBooleanAttribute` <a name="getBooleanAttribute" id="@cdktf/provider-databricks.job.JobDbtTaskOutputReference.getBooleanAttribute"></a>

```java
public IResolvable getBooleanAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobDbtTaskOutputReference.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getBooleanMapAttribute` <a name="getBooleanMapAttribute" id="@cdktf/provider-databricks.job.JobDbtTaskOutputReference.getBooleanMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Boolean> getBooleanMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobDbtTaskOutputReference.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getListAttribute` <a name="getListAttribute" id="@cdktf/provider-databricks.job.JobDbtTaskOutputReference.getListAttribute"></a>

```java
public java.util.List<java.lang.String> getListAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobDbtTaskOutputReference.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberAttribute` <a name="getNumberAttribute" id="@cdktf/provider-databricks.job.JobDbtTaskOutputReference.getNumberAttribute"></a>

```java
public java.lang.Number getNumberAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobDbtTaskOutputReference.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberListAttribute` <a name="getNumberListAttribute" id="@cdktf/provider-databricks.job.JobDbtTaskOutputReference.getNumberListAttribute"></a>

```java
public java.util.List<java.lang.Number> getNumberListAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobDbtTaskOutputReference.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberMapAttribute` <a name="getNumberMapAttribute" id="@cdktf/provider-databricks.job.JobDbtTaskOutputReference.getNumberMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Number> getNumberMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobDbtTaskOutputReference.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getStringAttribute` <a name="getStringAttribute" id="@cdktf/provider-databricks.job.JobDbtTaskOutputReference.getStringAttribute"></a>

```java
public java.lang.String getStringAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobDbtTaskOutputReference.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getStringMapAttribute` <a name="getStringMapAttribute" id="@cdktf/provider-databricks.job.JobDbtTaskOutputReference.getStringMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.String> getStringMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobDbtTaskOutputReference.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `interpolationForAttribute` <a name="interpolationForAttribute" id="@cdktf/provider-databricks.job.JobDbtTaskOutputReference.interpolationForAttribute"></a>

```java
public IResolvable interpolationForAttribute(java.lang.String property)
```

###### `property`<sup>Required</sup> <a name="property" id="@cdktf/provider-databricks.job.JobDbtTaskOutputReference.interpolationForAttribute.parameter.property"></a>

- *Type:* java.lang.String

---

##### `resolve` <a name="resolve" id="@cdktf/provider-databricks.job.JobDbtTaskOutputReference.resolve"></a>

```java
public java.lang.Object resolve(IResolveContext _context)
```

Produce the Token's value at resolution time.

###### `_context`<sup>Required</sup> <a name="_context" id="@cdktf/provider-databricks.job.JobDbtTaskOutputReference.resolve.parameter._context"></a>

- *Type:* com.hashicorp.cdktf.IResolveContext

---

##### `toString` <a name="toString" id="@cdktf/provider-databricks.job.JobDbtTaskOutputReference.toString"></a>

```java
public java.lang.String toString()
```

Return a string representation of this resolvable object.

Returns a reversible string representation.

##### `resetCatalog` <a name="resetCatalog" id="@cdktf/provider-databricks.job.JobDbtTaskOutputReference.resetCatalog"></a>

```java
public void resetCatalog()
```

##### `resetProfilesDirectory` <a name="resetProfilesDirectory" id="@cdktf/provider-databricks.job.JobDbtTaskOutputReference.resetProfilesDirectory"></a>

```java
public void resetProfilesDirectory()
```

##### `resetProjectDirectory` <a name="resetProjectDirectory" id="@cdktf/provider-databricks.job.JobDbtTaskOutputReference.resetProjectDirectory"></a>

```java
public void resetProjectDirectory()
```

##### `resetSchema` <a name="resetSchema" id="@cdktf/provider-databricks.job.JobDbtTaskOutputReference.resetSchema"></a>

```java
public void resetSchema()
```

##### `resetWarehouseId` <a name="resetWarehouseId" id="@cdktf/provider-databricks.job.JobDbtTaskOutputReference.resetWarehouseId"></a>

```java
public void resetWarehouseId()
```


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobDbtTaskOutputReference.property.creationStack">creationStack</a></code> | <code>java.util.List<java.lang.String></code> | The creation stack of this resolvable which will be appended to errors thrown during resolution. |
| <code><a href="#@cdktf/provider-databricks.job.JobDbtTaskOutputReference.property.fqn">fqn</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobDbtTaskOutputReference.property.catalogInput">catalogInput</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobDbtTaskOutputReference.property.commandsInput">commandsInput</a></code> | <code>java.util.List<java.lang.String></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobDbtTaskOutputReference.property.profilesDirectoryInput">profilesDirectoryInput</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobDbtTaskOutputReference.property.projectDirectoryInput">projectDirectoryInput</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobDbtTaskOutputReference.property.schemaInput">schemaInput</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobDbtTaskOutputReference.property.warehouseIdInput">warehouseIdInput</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobDbtTaskOutputReference.property.catalog">catalog</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobDbtTaskOutputReference.property.commands">commands</a></code> | <code>java.util.List<java.lang.String></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobDbtTaskOutputReference.property.profilesDirectory">profilesDirectory</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobDbtTaskOutputReference.property.projectDirectory">projectDirectory</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobDbtTaskOutputReference.property.schema">schema</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobDbtTaskOutputReference.property.warehouseId">warehouseId</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobDbtTaskOutputReference.property.internalValue">internalValue</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobDbtTask">JobDbtTask</a></code> | *No description.* |

---

##### `creationStack`<sup>Required</sup> <a name="creationStack" id="@cdktf/provider-databricks.job.JobDbtTaskOutputReference.property.creationStack"></a>

```java
public java.util.List<java.lang.String> getCreationStack();
```

- *Type:* java.util.List<java.lang.String>

The creation stack of this resolvable which will be appended to errors thrown during resolution.

If this returns an empty array the stack will not be attached.

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-databricks.job.JobDbtTaskOutputReference.property.fqn"></a>

```java
public java.lang.String getFqn();
```

- *Type:* java.lang.String

---

##### `catalogInput`<sup>Optional</sup> <a name="catalogInput" id="@cdktf/provider-databricks.job.JobDbtTaskOutputReference.property.catalogInput"></a>

```java
public java.lang.String getCatalogInput();
```

- *Type:* java.lang.String

---

##### `commandsInput`<sup>Optional</sup> <a name="commandsInput" id="@cdktf/provider-databricks.job.JobDbtTaskOutputReference.property.commandsInput"></a>

```java
public java.util.List<java.lang.String> getCommandsInput();
```

- *Type:* java.util.List<java.lang.String>

---

##### `profilesDirectoryInput`<sup>Optional</sup> <a name="profilesDirectoryInput" id="@cdktf/provider-databricks.job.JobDbtTaskOutputReference.property.profilesDirectoryInput"></a>

```java
public java.lang.String getProfilesDirectoryInput();
```

- *Type:* java.lang.String

---

##### `projectDirectoryInput`<sup>Optional</sup> <a name="projectDirectoryInput" id="@cdktf/provider-databricks.job.JobDbtTaskOutputReference.property.projectDirectoryInput"></a>

```java
public java.lang.String getProjectDirectoryInput();
```

- *Type:* java.lang.String

---

##### `schemaInput`<sup>Optional</sup> <a name="schemaInput" id="@cdktf/provider-databricks.job.JobDbtTaskOutputReference.property.schemaInput"></a>

```java
public java.lang.String getSchemaInput();
```

- *Type:* java.lang.String

---

##### `warehouseIdInput`<sup>Optional</sup> <a name="warehouseIdInput" id="@cdktf/provider-databricks.job.JobDbtTaskOutputReference.property.warehouseIdInput"></a>

```java
public java.lang.String getWarehouseIdInput();
```

- *Type:* java.lang.String

---

##### `catalog`<sup>Required</sup> <a name="catalog" id="@cdktf/provider-databricks.job.JobDbtTaskOutputReference.property.catalog"></a>

```java
public java.lang.String getCatalog();
```

- *Type:* java.lang.String

---

##### `commands`<sup>Required</sup> <a name="commands" id="@cdktf/provider-databricks.job.JobDbtTaskOutputReference.property.commands"></a>

```java
public java.util.List<java.lang.String> getCommands();
```

- *Type:* java.util.List<java.lang.String>

---

##### `profilesDirectory`<sup>Required</sup> <a name="profilesDirectory" id="@cdktf/provider-databricks.job.JobDbtTaskOutputReference.property.profilesDirectory"></a>

```java
public java.lang.String getProfilesDirectory();
```

- *Type:* java.lang.String

---

##### `projectDirectory`<sup>Required</sup> <a name="projectDirectory" id="@cdktf/provider-databricks.job.JobDbtTaskOutputReference.property.projectDirectory"></a>

```java
public java.lang.String getProjectDirectory();
```

- *Type:* java.lang.String

---

##### `schema`<sup>Required</sup> <a name="schema" id="@cdktf/provider-databricks.job.JobDbtTaskOutputReference.property.schema"></a>

```java
public java.lang.String getSchema();
```

- *Type:* java.lang.String

---

##### `warehouseId`<sup>Required</sup> <a name="warehouseId" id="@cdktf/provider-databricks.job.JobDbtTaskOutputReference.property.warehouseId"></a>

```java
public java.lang.String getWarehouseId();
```

- *Type:* java.lang.String

---

##### `internalValue`<sup>Optional</sup> <a name="internalValue" id="@cdktf/provider-databricks.job.JobDbtTaskOutputReference.property.internalValue"></a>

```java
public JobDbtTask getInternalValue();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobDbtTask">JobDbtTask</a>

---


### JobEmailNotificationsOutputReference <a name="JobEmailNotificationsOutputReference" id="@cdktf/provider-databricks.job.JobEmailNotificationsOutputReference"></a>

#### Initializers <a name="Initializers" id="@cdktf/provider-databricks.job.JobEmailNotificationsOutputReference.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobEmailNotificationsOutputReference;

new JobEmailNotificationsOutputReference(IInterpolatingParent terraformResource, java.lang.String terraformAttribute);
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobEmailNotificationsOutputReference.Initializer.parameter.terraformResource">terraformResource</a></code> | <code>com.hashicorp.cdktf.IInterpolatingParent</code> | The parent resource. |
| <code><a href="#@cdktf/provider-databricks.job.JobEmailNotificationsOutputReference.Initializer.parameter.terraformAttribute">terraformAttribute</a></code> | <code>java.lang.String</code> | The attribute on the parent resource this class is referencing. |

---

##### `terraformResource`<sup>Required</sup> <a name="terraformResource" id="@cdktf/provider-databricks.job.JobEmailNotificationsOutputReference.Initializer.parameter.terraformResource"></a>

- *Type:* com.hashicorp.cdktf.IInterpolatingParent

The parent resource.

---

##### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobEmailNotificationsOutputReference.Initializer.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

The attribute on the parent resource this class is referencing.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobEmailNotificationsOutputReference.computeFqn">computeFqn</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobEmailNotificationsOutputReference.getAnyMapAttribute">getAnyMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobEmailNotificationsOutputReference.getBooleanAttribute">getBooleanAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobEmailNotificationsOutputReference.getBooleanMapAttribute">getBooleanMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobEmailNotificationsOutputReference.getListAttribute">getListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobEmailNotificationsOutputReference.getNumberAttribute">getNumberAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobEmailNotificationsOutputReference.getNumberListAttribute">getNumberListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobEmailNotificationsOutputReference.getNumberMapAttribute">getNumberMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobEmailNotificationsOutputReference.getStringAttribute">getStringAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobEmailNotificationsOutputReference.getStringMapAttribute">getStringMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobEmailNotificationsOutputReference.interpolationForAttribute">interpolationForAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobEmailNotificationsOutputReference.resolve">resolve</a></code> | Produce the Token's value at resolution time. |
| <code><a href="#@cdktf/provider-databricks.job.JobEmailNotificationsOutputReference.toString">toString</a></code> | Return a string representation of this resolvable object. |
| <code><a href="#@cdktf/provider-databricks.job.JobEmailNotificationsOutputReference.resetAlertOnLastAttempt">resetAlertOnLastAttempt</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobEmailNotificationsOutputReference.resetNoAlertForSkippedRuns">resetNoAlertForSkippedRuns</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobEmailNotificationsOutputReference.resetOnFailure">resetOnFailure</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobEmailNotificationsOutputReference.resetOnStart">resetOnStart</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobEmailNotificationsOutputReference.resetOnSuccess">resetOnSuccess</a></code> | *No description.* |

---

##### `computeFqn` <a name="computeFqn" id="@cdktf/provider-databricks.job.JobEmailNotificationsOutputReference.computeFqn"></a>

```java
public java.lang.String computeFqn()
```

##### `getAnyMapAttribute` <a name="getAnyMapAttribute" id="@cdktf/provider-databricks.job.JobEmailNotificationsOutputReference.getAnyMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Object> getAnyMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobEmailNotificationsOutputReference.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getBooleanAttribute` <a name="getBooleanAttribute" id="@cdktf/provider-databricks.job.JobEmailNotificationsOutputReference.getBooleanAttribute"></a>

```java
public IResolvable getBooleanAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobEmailNotificationsOutputReference.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getBooleanMapAttribute` <a name="getBooleanMapAttribute" id="@cdktf/provider-databricks.job.JobEmailNotificationsOutputReference.getBooleanMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Boolean> getBooleanMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobEmailNotificationsOutputReference.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getListAttribute` <a name="getListAttribute" id="@cdktf/provider-databricks.job.JobEmailNotificationsOutputReference.getListAttribute"></a>

```java
public java.util.List<java.lang.String> getListAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobEmailNotificationsOutputReference.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberAttribute` <a name="getNumberAttribute" id="@cdktf/provider-databricks.job.JobEmailNotificationsOutputReference.getNumberAttribute"></a>

```java
public java.lang.Number getNumberAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobEmailNotificationsOutputReference.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberListAttribute` <a name="getNumberListAttribute" id="@cdktf/provider-databricks.job.JobEmailNotificationsOutputReference.getNumberListAttribute"></a>

```java
public java.util.List<java.lang.Number> getNumberListAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobEmailNotificationsOutputReference.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberMapAttribute` <a name="getNumberMapAttribute" id="@cdktf/provider-databricks.job.JobEmailNotificationsOutputReference.getNumberMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Number> getNumberMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobEmailNotificationsOutputReference.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getStringAttribute` <a name="getStringAttribute" id="@cdktf/provider-databricks.job.JobEmailNotificationsOutputReference.getStringAttribute"></a>

```java
public java.lang.String getStringAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobEmailNotificationsOutputReference.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getStringMapAttribute` <a name="getStringMapAttribute" id="@cdktf/provider-databricks.job.JobEmailNotificationsOutputReference.getStringMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.String> getStringMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobEmailNotificationsOutputReference.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `interpolationForAttribute` <a name="interpolationForAttribute" id="@cdktf/provider-databricks.job.JobEmailNotificationsOutputReference.interpolationForAttribute"></a>

```java
public IResolvable interpolationForAttribute(java.lang.String property)
```

###### `property`<sup>Required</sup> <a name="property" id="@cdktf/provider-databricks.job.JobEmailNotificationsOutputReference.interpolationForAttribute.parameter.property"></a>

- *Type:* java.lang.String

---

##### `resolve` <a name="resolve" id="@cdktf/provider-databricks.job.JobEmailNotificationsOutputReference.resolve"></a>

```java
public java.lang.Object resolve(IResolveContext _context)
```

Produce the Token's value at resolution time.

###### `_context`<sup>Required</sup> <a name="_context" id="@cdktf/provider-databricks.job.JobEmailNotificationsOutputReference.resolve.parameter._context"></a>

- *Type:* com.hashicorp.cdktf.IResolveContext

---

##### `toString` <a name="toString" id="@cdktf/provider-databricks.job.JobEmailNotificationsOutputReference.toString"></a>

```java
public java.lang.String toString()
```

Return a string representation of this resolvable object.

Returns a reversible string representation.

##### `resetAlertOnLastAttempt` <a name="resetAlertOnLastAttempt" id="@cdktf/provider-databricks.job.JobEmailNotificationsOutputReference.resetAlertOnLastAttempt"></a>

```java
public void resetAlertOnLastAttempt()
```

##### `resetNoAlertForSkippedRuns` <a name="resetNoAlertForSkippedRuns" id="@cdktf/provider-databricks.job.JobEmailNotificationsOutputReference.resetNoAlertForSkippedRuns"></a>

```java
public void resetNoAlertForSkippedRuns()
```

##### `resetOnFailure` <a name="resetOnFailure" id="@cdktf/provider-databricks.job.JobEmailNotificationsOutputReference.resetOnFailure"></a>

```java
public void resetOnFailure()
```

##### `resetOnStart` <a name="resetOnStart" id="@cdktf/provider-databricks.job.JobEmailNotificationsOutputReference.resetOnStart"></a>

```java
public void resetOnStart()
```

##### `resetOnSuccess` <a name="resetOnSuccess" id="@cdktf/provider-databricks.job.JobEmailNotificationsOutputReference.resetOnSuccess"></a>

```java
public void resetOnSuccess()
```


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobEmailNotificationsOutputReference.property.creationStack">creationStack</a></code> | <code>java.util.List<java.lang.String></code> | The creation stack of this resolvable which will be appended to errors thrown during resolution. |
| <code><a href="#@cdktf/provider-databricks.job.JobEmailNotificationsOutputReference.property.fqn">fqn</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobEmailNotificationsOutputReference.property.alertOnLastAttemptInput">alertOnLastAttemptInput</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobEmailNotificationsOutputReference.property.noAlertForSkippedRunsInput">noAlertForSkippedRunsInput</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobEmailNotificationsOutputReference.property.onFailureInput">onFailureInput</a></code> | <code>java.util.List<java.lang.String></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobEmailNotificationsOutputReference.property.onStartInput">onStartInput</a></code> | <code>java.util.List<java.lang.String></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobEmailNotificationsOutputReference.property.onSuccessInput">onSuccessInput</a></code> | <code>java.util.List<java.lang.String></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobEmailNotificationsOutputReference.property.alertOnLastAttempt">alertOnLastAttempt</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobEmailNotificationsOutputReference.property.noAlertForSkippedRuns">noAlertForSkippedRuns</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobEmailNotificationsOutputReference.property.onFailure">onFailure</a></code> | <code>java.util.List<java.lang.String></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobEmailNotificationsOutputReference.property.onStart">onStart</a></code> | <code>java.util.List<java.lang.String></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobEmailNotificationsOutputReference.property.onSuccess">onSuccess</a></code> | <code>java.util.List<java.lang.String></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobEmailNotificationsOutputReference.property.internalValue">internalValue</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobEmailNotifications">JobEmailNotifications</a></code> | *No description.* |

---

##### `creationStack`<sup>Required</sup> <a name="creationStack" id="@cdktf/provider-databricks.job.JobEmailNotificationsOutputReference.property.creationStack"></a>

```java
public java.util.List<java.lang.String> getCreationStack();
```

- *Type:* java.util.List<java.lang.String>

The creation stack of this resolvable which will be appended to errors thrown during resolution.

If this returns an empty array the stack will not be attached.

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-databricks.job.JobEmailNotificationsOutputReference.property.fqn"></a>

```java
public java.lang.String getFqn();
```

- *Type:* java.lang.String

---

##### `alertOnLastAttemptInput`<sup>Optional</sup> <a name="alertOnLastAttemptInput" id="@cdktf/provider-databricks.job.JobEmailNotificationsOutputReference.property.alertOnLastAttemptInput"></a>

```java
public java.lang.Object getAlertOnLastAttemptInput();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

---

##### `noAlertForSkippedRunsInput`<sup>Optional</sup> <a name="noAlertForSkippedRunsInput" id="@cdktf/provider-databricks.job.JobEmailNotificationsOutputReference.property.noAlertForSkippedRunsInput"></a>

```java
public java.lang.Object getNoAlertForSkippedRunsInput();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

---

##### `onFailureInput`<sup>Optional</sup> <a name="onFailureInput" id="@cdktf/provider-databricks.job.JobEmailNotificationsOutputReference.property.onFailureInput"></a>

```java
public java.util.List<java.lang.String> getOnFailureInput();
```

- *Type:* java.util.List<java.lang.String>

---

##### `onStartInput`<sup>Optional</sup> <a name="onStartInput" id="@cdktf/provider-databricks.job.JobEmailNotificationsOutputReference.property.onStartInput"></a>

```java
public java.util.List<java.lang.String> getOnStartInput();
```

- *Type:* java.util.List<java.lang.String>

---

##### `onSuccessInput`<sup>Optional</sup> <a name="onSuccessInput" id="@cdktf/provider-databricks.job.JobEmailNotificationsOutputReference.property.onSuccessInput"></a>

```java
public java.util.List<java.lang.String> getOnSuccessInput();
```

- *Type:* java.util.List<java.lang.String>

---

##### `alertOnLastAttempt`<sup>Required</sup> <a name="alertOnLastAttempt" id="@cdktf/provider-databricks.job.JobEmailNotificationsOutputReference.property.alertOnLastAttempt"></a>

```java
public java.lang.Object getAlertOnLastAttempt();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

---

##### `noAlertForSkippedRuns`<sup>Required</sup> <a name="noAlertForSkippedRuns" id="@cdktf/provider-databricks.job.JobEmailNotificationsOutputReference.property.noAlertForSkippedRuns"></a>

```java
public java.lang.Object getNoAlertForSkippedRuns();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

---

##### `onFailure`<sup>Required</sup> <a name="onFailure" id="@cdktf/provider-databricks.job.JobEmailNotificationsOutputReference.property.onFailure"></a>

```java
public java.util.List<java.lang.String> getOnFailure();
```

- *Type:* java.util.List<java.lang.String>

---

##### `onStart`<sup>Required</sup> <a name="onStart" id="@cdktf/provider-databricks.job.JobEmailNotificationsOutputReference.property.onStart"></a>

```java
public java.util.List<java.lang.String> getOnStart();
```

- *Type:* java.util.List<java.lang.String>

---

##### `onSuccess`<sup>Required</sup> <a name="onSuccess" id="@cdktf/provider-databricks.job.JobEmailNotificationsOutputReference.property.onSuccess"></a>

```java
public java.util.List<java.lang.String> getOnSuccess();
```

- *Type:* java.util.List<java.lang.String>

---

##### `internalValue`<sup>Optional</sup> <a name="internalValue" id="@cdktf/provider-databricks.job.JobEmailNotificationsOutputReference.property.internalValue"></a>

```java
public JobEmailNotifications getInternalValue();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobEmailNotifications">JobEmailNotifications</a>

---


### JobGitSourceOutputReference <a name="JobGitSourceOutputReference" id="@cdktf/provider-databricks.job.JobGitSourceOutputReference"></a>

#### Initializers <a name="Initializers" id="@cdktf/provider-databricks.job.JobGitSourceOutputReference.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobGitSourceOutputReference;

new JobGitSourceOutputReference(IInterpolatingParent terraformResource, java.lang.String terraformAttribute);
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobGitSourceOutputReference.Initializer.parameter.terraformResource">terraformResource</a></code> | <code>com.hashicorp.cdktf.IInterpolatingParent</code> | The parent resource. |
| <code><a href="#@cdktf/provider-databricks.job.JobGitSourceOutputReference.Initializer.parameter.terraformAttribute">terraformAttribute</a></code> | <code>java.lang.String</code> | The attribute on the parent resource this class is referencing. |

---

##### `terraformResource`<sup>Required</sup> <a name="terraformResource" id="@cdktf/provider-databricks.job.JobGitSourceOutputReference.Initializer.parameter.terraformResource"></a>

- *Type:* com.hashicorp.cdktf.IInterpolatingParent

The parent resource.

---

##### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobGitSourceOutputReference.Initializer.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

The attribute on the parent resource this class is referencing.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobGitSourceOutputReference.computeFqn">computeFqn</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobGitSourceOutputReference.getAnyMapAttribute">getAnyMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobGitSourceOutputReference.getBooleanAttribute">getBooleanAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobGitSourceOutputReference.getBooleanMapAttribute">getBooleanMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobGitSourceOutputReference.getListAttribute">getListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobGitSourceOutputReference.getNumberAttribute">getNumberAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobGitSourceOutputReference.getNumberListAttribute">getNumberListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobGitSourceOutputReference.getNumberMapAttribute">getNumberMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobGitSourceOutputReference.getStringAttribute">getStringAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobGitSourceOutputReference.getStringMapAttribute">getStringMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobGitSourceOutputReference.interpolationForAttribute">interpolationForAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobGitSourceOutputReference.resolve">resolve</a></code> | Produce the Token's value at resolution time. |
| <code><a href="#@cdktf/provider-databricks.job.JobGitSourceOutputReference.toString">toString</a></code> | Return a string representation of this resolvable object. |
| <code><a href="#@cdktf/provider-databricks.job.JobGitSourceOutputReference.resetBranch">resetBranch</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobGitSourceOutputReference.resetCommit">resetCommit</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobGitSourceOutputReference.resetProvider">resetProvider</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobGitSourceOutputReference.resetTag">resetTag</a></code> | *No description.* |

---

##### `computeFqn` <a name="computeFqn" id="@cdktf/provider-databricks.job.JobGitSourceOutputReference.computeFqn"></a>

```java
public java.lang.String computeFqn()
```

##### `getAnyMapAttribute` <a name="getAnyMapAttribute" id="@cdktf/provider-databricks.job.JobGitSourceOutputReference.getAnyMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Object> getAnyMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobGitSourceOutputReference.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getBooleanAttribute` <a name="getBooleanAttribute" id="@cdktf/provider-databricks.job.JobGitSourceOutputReference.getBooleanAttribute"></a>

```java
public IResolvable getBooleanAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobGitSourceOutputReference.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getBooleanMapAttribute` <a name="getBooleanMapAttribute" id="@cdktf/provider-databricks.job.JobGitSourceOutputReference.getBooleanMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Boolean> getBooleanMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobGitSourceOutputReference.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getListAttribute` <a name="getListAttribute" id="@cdktf/provider-databricks.job.JobGitSourceOutputReference.getListAttribute"></a>

```java
public java.util.List<java.lang.String> getListAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobGitSourceOutputReference.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberAttribute` <a name="getNumberAttribute" id="@cdktf/provider-databricks.job.JobGitSourceOutputReference.getNumberAttribute"></a>

```java
public java.lang.Number getNumberAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobGitSourceOutputReference.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberListAttribute` <a name="getNumberListAttribute" id="@cdktf/provider-databricks.job.JobGitSourceOutputReference.getNumberListAttribute"></a>

```java
public java.util.List<java.lang.Number> getNumberListAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobGitSourceOutputReference.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberMapAttribute` <a name="getNumberMapAttribute" id="@cdktf/provider-databricks.job.JobGitSourceOutputReference.getNumberMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Number> getNumberMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobGitSourceOutputReference.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getStringAttribute` <a name="getStringAttribute" id="@cdktf/provider-databricks.job.JobGitSourceOutputReference.getStringAttribute"></a>

```java
public java.lang.String getStringAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobGitSourceOutputReference.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getStringMapAttribute` <a name="getStringMapAttribute" id="@cdktf/provider-databricks.job.JobGitSourceOutputReference.getStringMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.String> getStringMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobGitSourceOutputReference.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `interpolationForAttribute` <a name="interpolationForAttribute" id="@cdktf/provider-databricks.job.JobGitSourceOutputReference.interpolationForAttribute"></a>

```java
public IResolvable interpolationForAttribute(java.lang.String property)
```

###### `property`<sup>Required</sup> <a name="property" id="@cdktf/provider-databricks.job.JobGitSourceOutputReference.interpolationForAttribute.parameter.property"></a>

- *Type:* java.lang.String

---

##### `resolve` <a name="resolve" id="@cdktf/provider-databricks.job.JobGitSourceOutputReference.resolve"></a>

```java
public java.lang.Object resolve(IResolveContext _context)
```

Produce the Token's value at resolution time.

###### `_context`<sup>Required</sup> <a name="_context" id="@cdktf/provider-databricks.job.JobGitSourceOutputReference.resolve.parameter._context"></a>

- *Type:* com.hashicorp.cdktf.IResolveContext

---

##### `toString` <a name="toString" id="@cdktf/provider-databricks.job.JobGitSourceOutputReference.toString"></a>

```java
public java.lang.String toString()
```

Return a string representation of this resolvable object.

Returns a reversible string representation.

##### `resetBranch` <a name="resetBranch" id="@cdktf/provider-databricks.job.JobGitSourceOutputReference.resetBranch"></a>

```java
public void resetBranch()
```

##### `resetCommit` <a name="resetCommit" id="@cdktf/provider-databricks.job.JobGitSourceOutputReference.resetCommit"></a>

```java
public void resetCommit()
```

##### `resetProvider` <a name="resetProvider" id="@cdktf/provider-databricks.job.JobGitSourceOutputReference.resetProvider"></a>

```java
public void resetProvider()
```

##### `resetTag` <a name="resetTag" id="@cdktf/provider-databricks.job.JobGitSourceOutputReference.resetTag"></a>

```java
public void resetTag()
```


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobGitSourceOutputReference.property.creationStack">creationStack</a></code> | <code>java.util.List<java.lang.String></code> | The creation stack of this resolvable which will be appended to errors thrown during resolution. |
| <code><a href="#@cdktf/provider-databricks.job.JobGitSourceOutputReference.property.fqn">fqn</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobGitSourceOutputReference.property.branchInput">branchInput</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobGitSourceOutputReference.property.commitInput">commitInput</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobGitSourceOutputReference.property.providerInput">providerInput</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobGitSourceOutputReference.property.tagInput">tagInput</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobGitSourceOutputReference.property.urlInput">urlInput</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobGitSourceOutputReference.property.branch">branch</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobGitSourceOutputReference.property.commit">commit</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobGitSourceOutputReference.property.provider">provider</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobGitSourceOutputReference.property.tag">tag</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobGitSourceOutputReference.property.url">url</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobGitSourceOutputReference.property.internalValue">internalValue</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobGitSource">JobGitSource</a></code> | *No description.* |

---

##### `creationStack`<sup>Required</sup> <a name="creationStack" id="@cdktf/provider-databricks.job.JobGitSourceOutputReference.property.creationStack"></a>

```java
public java.util.List<java.lang.String> getCreationStack();
```

- *Type:* java.util.List<java.lang.String>

The creation stack of this resolvable which will be appended to errors thrown during resolution.

If this returns an empty array the stack will not be attached.

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-databricks.job.JobGitSourceOutputReference.property.fqn"></a>

```java
public java.lang.String getFqn();
```

- *Type:* java.lang.String

---

##### `branchInput`<sup>Optional</sup> <a name="branchInput" id="@cdktf/provider-databricks.job.JobGitSourceOutputReference.property.branchInput"></a>

```java
public java.lang.String getBranchInput();
```

- *Type:* java.lang.String

---

##### `commitInput`<sup>Optional</sup> <a name="commitInput" id="@cdktf/provider-databricks.job.JobGitSourceOutputReference.property.commitInput"></a>

```java
public java.lang.String getCommitInput();
```

- *Type:* java.lang.String

---

##### `providerInput`<sup>Optional</sup> <a name="providerInput" id="@cdktf/provider-databricks.job.JobGitSourceOutputReference.property.providerInput"></a>

```java
public java.lang.String getProviderInput();
```

- *Type:* java.lang.String

---

##### `tagInput`<sup>Optional</sup> <a name="tagInput" id="@cdktf/provider-databricks.job.JobGitSourceOutputReference.property.tagInput"></a>

```java
public java.lang.String getTagInput();
```

- *Type:* java.lang.String

---

##### `urlInput`<sup>Optional</sup> <a name="urlInput" id="@cdktf/provider-databricks.job.JobGitSourceOutputReference.property.urlInput"></a>

```java
public java.lang.String getUrlInput();
```

- *Type:* java.lang.String

---

##### `branch`<sup>Required</sup> <a name="branch" id="@cdktf/provider-databricks.job.JobGitSourceOutputReference.property.branch"></a>

```java
public java.lang.String getBranch();
```

- *Type:* java.lang.String

---

##### `commit`<sup>Required</sup> <a name="commit" id="@cdktf/provider-databricks.job.JobGitSourceOutputReference.property.commit"></a>

```java
public java.lang.String getCommit();
```

- *Type:* java.lang.String

---

##### `provider`<sup>Required</sup> <a name="provider" id="@cdktf/provider-databricks.job.JobGitSourceOutputReference.property.provider"></a>

```java
public java.lang.String getProvider();
```

- *Type:* java.lang.String

---

##### `tag`<sup>Required</sup> <a name="tag" id="@cdktf/provider-databricks.job.JobGitSourceOutputReference.property.tag"></a>

```java
public java.lang.String getTag();
```

- *Type:* java.lang.String

---

##### `url`<sup>Required</sup> <a name="url" id="@cdktf/provider-databricks.job.JobGitSourceOutputReference.property.url"></a>

```java
public java.lang.String getUrl();
```

- *Type:* java.lang.String

---

##### `internalValue`<sup>Optional</sup> <a name="internalValue" id="@cdktf/provider-databricks.job.JobGitSourceOutputReference.property.internalValue"></a>

```java
public JobGitSource getInternalValue();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobGitSource">JobGitSource</a>

---


### JobJobClusterList <a name="JobJobClusterList" id="@cdktf/provider-databricks.job.JobJobClusterList"></a>

#### Initializers <a name="Initializers" id="@cdktf/provider-databricks.job.JobJobClusterList.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobJobClusterList;

new JobJobClusterList(IInterpolatingParent terraformResource, java.lang.String terraformAttribute, java.lang.Boolean wrapsSet);
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterList.Initializer.parameter.terraformResource">terraformResource</a></code> | <code>com.hashicorp.cdktf.IInterpolatingParent</code> | The parent resource. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterList.Initializer.parameter.terraformAttribute">terraformAttribute</a></code> | <code>java.lang.String</code> | The attribute on the parent resource this class is referencing. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterList.Initializer.parameter.wrapsSet">wrapsSet</a></code> | <code>java.lang.Boolean</code> | whether the list is wrapping a set (will add tolist() to be able to access an item via an index). |

---

##### `terraformResource`<sup>Required</sup> <a name="terraformResource" id="@cdktf/provider-databricks.job.JobJobClusterList.Initializer.parameter.terraformResource"></a>

- *Type:* com.hashicorp.cdktf.IInterpolatingParent

The parent resource.

---

##### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterList.Initializer.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

The attribute on the parent resource this class is referencing.

---

##### `wrapsSet`<sup>Required</sup> <a name="wrapsSet" id="@cdktf/provider-databricks.job.JobJobClusterList.Initializer.parameter.wrapsSet"></a>

- *Type:* java.lang.Boolean

whether the list is wrapping a set (will add tolist() to be able to access an item via an index).

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterList.computeFqn">computeFqn</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterList.resolve">resolve</a></code> | Produce the Token's value at resolution time. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterList.toString">toString</a></code> | Return a string representation of this resolvable object. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterList.get">get</a></code> | *No description.* |

---

##### `computeFqn` <a name="computeFqn" id="@cdktf/provider-databricks.job.JobJobClusterList.computeFqn"></a>

```java
public java.lang.String computeFqn()
```

##### `resolve` <a name="resolve" id="@cdktf/provider-databricks.job.JobJobClusterList.resolve"></a>

```java
public java.lang.Object resolve(IResolveContext _context)
```

Produce the Token's value at resolution time.

###### `_context`<sup>Required</sup> <a name="_context" id="@cdktf/provider-databricks.job.JobJobClusterList.resolve.parameter._context"></a>

- *Type:* com.hashicorp.cdktf.IResolveContext

---

##### `toString` <a name="toString" id="@cdktf/provider-databricks.job.JobJobClusterList.toString"></a>

```java
public java.lang.String toString()
```

Return a string representation of this resolvable object.

Returns a reversible string representation.

##### `get` <a name="get" id="@cdktf/provider-databricks.job.JobJobClusterList.get"></a>

```java
public JobJobClusterOutputReference get(java.lang.Number index)
```

###### `index`<sup>Required</sup> <a name="index" id="@cdktf/provider-databricks.job.JobJobClusterList.get.parameter.index"></a>

- *Type:* java.lang.Number

the index of the item to return.

---


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterList.property.creationStack">creationStack</a></code> | <code>java.util.List<java.lang.String></code> | The creation stack of this resolvable which will be appended to errors thrown during resolution. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterList.property.fqn">fqn</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterList.property.internalValue">internalValue</a></code> | <code>com.hashicorp.cdktf.IResolvable OR java.util.List<<a href="#@cdktf/provider-databricks.job.JobJobCluster">JobJobCluster</a>></code> | *No description.* |

---

##### `creationStack`<sup>Required</sup> <a name="creationStack" id="@cdktf/provider-databricks.job.JobJobClusterList.property.creationStack"></a>

```java
public java.util.List<java.lang.String> getCreationStack();
```

- *Type:* java.util.List<java.lang.String>

The creation stack of this resolvable which will be appended to errors thrown during resolution.

If this returns an empty array the stack will not be attached.

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-databricks.job.JobJobClusterList.property.fqn"></a>

```java
public java.lang.String getFqn();
```

- *Type:* java.lang.String

---

##### `internalValue`<sup>Optional</sup> <a name="internalValue" id="@cdktf/provider-databricks.job.JobJobClusterList.property.internalValue"></a>

```java
public java.lang.Object getInternalValue();
```

- *Type:* com.hashicorp.cdktf.IResolvable OR java.util.List<<a href="#@cdktf/provider-databricks.job.JobJobCluster">JobJobCluster</a>>

---


### JobJobClusterNewClusterAutoscaleOutputReference <a name="JobJobClusterNewClusterAutoscaleOutputReference" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAutoscaleOutputReference"></a>

#### Initializers <a name="Initializers" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAutoscaleOutputReference.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobJobClusterNewClusterAutoscaleOutputReference;

new JobJobClusterNewClusterAutoscaleOutputReference(IInterpolatingParent terraformResource, java.lang.String terraformAttribute);
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAutoscaleOutputReference.Initializer.parameter.terraformResource">terraformResource</a></code> | <code>com.hashicorp.cdktf.IInterpolatingParent</code> | The parent resource. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAutoscaleOutputReference.Initializer.parameter.terraformAttribute">terraformAttribute</a></code> | <code>java.lang.String</code> | The attribute on the parent resource this class is referencing. |

---

##### `terraformResource`<sup>Required</sup> <a name="terraformResource" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAutoscaleOutputReference.Initializer.parameter.terraformResource"></a>

- *Type:* com.hashicorp.cdktf.IInterpolatingParent

The parent resource.

---

##### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAutoscaleOutputReference.Initializer.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

The attribute on the parent resource this class is referencing.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAutoscaleOutputReference.computeFqn">computeFqn</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAutoscaleOutputReference.getAnyMapAttribute">getAnyMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAutoscaleOutputReference.getBooleanAttribute">getBooleanAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAutoscaleOutputReference.getBooleanMapAttribute">getBooleanMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAutoscaleOutputReference.getListAttribute">getListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAutoscaleOutputReference.getNumberAttribute">getNumberAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAutoscaleOutputReference.getNumberListAttribute">getNumberListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAutoscaleOutputReference.getNumberMapAttribute">getNumberMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAutoscaleOutputReference.getStringAttribute">getStringAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAutoscaleOutputReference.getStringMapAttribute">getStringMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAutoscaleOutputReference.interpolationForAttribute">interpolationForAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAutoscaleOutputReference.resolve">resolve</a></code> | Produce the Token's value at resolution time. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAutoscaleOutputReference.toString">toString</a></code> | Return a string representation of this resolvable object. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAutoscaleOutputReference.resetMaxWorkers">resetMaxWorkers</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAutoscaleOutputReference.resetMinWorkers">resetMinWorkers</a></code> | *No description.* |

---

##### `computeFqn` <a name="computeFqn" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAutoscaleOutputReference.computeFqn"></a>

```java
public java.lang.String computeFqn()
```

##### `getAnyMapAttribute` <a name="getAnyMapAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAutoscaleOutputReference.getAnyMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Object> getAnyMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAutoscaleOutputReference.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getBooleanAttribute` <a name="getBooleanAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAutoscaleOutputReference.getBooleanAttribute"></a>

```java
public IResolvable getBooleanAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAutoscaleOutputReference.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getBooleanMapAttribute` <a name="getBooleanMapAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAutoscaleOutputReference.getBooleanMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Boolean> getBooleanMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAutoscaleOutputReference.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getListAttribute` <a name="getListAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAutoscaleOutputReference.getListAttribute"></a>

```java
public java.util.List<java.lang.String> getListAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAutoscaleOutputReference.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberAttribute` <a name="getNumberAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAutoscaleOutputReference.getNumberAttribute"></a>

```java
public java.lang.Number getNumberAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAutoscaleOutputReference.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberListAttribute` <a name="getNumberListAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAutoscaleOutputReference.getNumberListAttribute"></a>

```java
public java.util.List<java.lang.Number> getNumberListAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAutoscaleOutputReference.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberMapAttribute` <a name="getNumberMapAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAutoscaleOutputReference.getNumberMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Number> getNumberMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAutoscaleOutputReference.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getStringAttribute` <a name="getStringAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAutoscaleOutputReference.getStringAttribute"></a>

```java
public java.lang.String getStringAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAutoscaleOutputReference.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getStringMapAttribute` <a name="getStringMapAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAutoscaleOutputReference.getStringMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.String> getStringMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAutoscaleOutputReference.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `interpolationForAttribute` <a name="interpolationForAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAutoscaleOutputReference.interpolationForAttribute"></a>

```java
public IResolvable interpolationForAttribute(java.lang.String property)
```

###### `property`<sup>Required</sup> <a name="property" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAutoscaleOutputReference.interpolationForAttribute.parameter.property"></a>

- *Type:* java.lang.String

---

##### `resolve` <a name="resolve" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAutoscaleOutputReference.resolve"></a>

```java
public java.lang.Object resolve(IResolveContext _context)
```

Produce the Token's value at resolution time.

###### `_context`<sup>Required</sup> <a name="_context" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAutoscaleOutputReference.resolve.parameter._context"></a>

- *Type:* com.hashicorp.cdktf.IResolveContext

---

##### `toString` <a name="toString" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAutoscaleOutputReference.toString"></a>

```java
public java.lang.String toString()
```

Return a string representation of this resolvable object.

Returns a reversible string representation.

##### `resetMaxWorkers` <a name="resetMaxWorkers" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAutoscaleOutputReference.resetMaxWorkers"></a>

```java
public void resetMaxWorkers()
```

##### `resetMinWorkers` <a name="resetMinWorkers" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAutoscaleOutputReference.resetMinWorkers"></a>

```java
public void resetMinWorkers()
```


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAutoscaleOutputReference.property.creationStack">creationStack</a></code> | <code>java.util.List<java.lang.String></code> | The creation stack of this resolvable which will be appended to errors thrown during resolution. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAutoscaleOutputReference.property.fqn">fqn</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAutoscaleOutputReference.property.maxWorkersInput">maxWorkersInput</a></code> | <code>java.lang.Number</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAutoscaleOutputReference.property.minWorkersInput">minWorkersInput</a></code> | <code>java.lang.Number</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAutoscaleOutputReference.property.maxWorkers">maxWorkers</a></code> | <code>java.lang.Number</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAutoscaleOutputReference.property.minWorkers">minWorkers</a></code> | <code>java.lang.Number</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAutoscaleOutputReference.property.internalValue">internalValue</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAutoscale">JobJobClusterNewClusterAutoscale</a></code> | *No description.* |

---

##### `creationStack`<sup>Required</sup> <a name="creationStack" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAutoscaleOutputReference.property.creationStack"></a>

```java
public java.util.List<java.lang.String> getCreationStack();
```

- *Type:* java.util.List<java.lang.String>

The creation stack of this resolvable which will be appended to errors thrown during resolution.

If this returns an empty array the stack will not be attached.

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAutoscaleOutputReference.property.fqn"></a>

```java
public java.lang.String getFqn();
```

- *Type:* java.lang.String

---

##### `maxWorkersInput`<sup>Optional</sup> <a name="maxWorkersInput" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAutoscaleOutputReference.property.maxWorkersInput"></a>

```java
public java.lang.Number getMaxWorkersInput();
```

- *Type:* java.lang.Number

---

##### `minWorkersInput`<sup>Optional</sup> <a name="minWorkersInput" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAutoscaleOutputReference.property.minWorkersInput"></a>

```java
public java.lang.Number getMinWorkersInput();
```

- *Type:* java.lang.Number

---

##### `maxWorkers`<sup>Required</sup> <a name="maxWorkers" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAutoscaleOutputReference.property.maxWorkers"></a>

```java
public java.lang.Number getMaxWorkers();
```

- *Type:* java.lang.Number

---

##### `minWorkers`<sup>Required</sup> <a name="minWorkers" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAutoscaleOutputReference.property.minWorkers"></a>

```java
public java.lang.Number getMinWorkers();
```

- *Type:* java.lang.Number

---

##### `internalValue`<sup>Optional</sup> <a name="internalValue" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAutoscaleOutputReference.property.internalValue"></a>

```java
public JobJobClusterNewClusterAutoscale getInternalValue();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAutoscale">JobJobClusterNewClusterAutoscale</a>

---


### JobJobClusterNewClusterAwsAttributesOutputReference <a name="JobJobClusterNewClusterAwsAttributesOutputReference" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributesOutputReference"></a>

#### Initializers <a name="Initializers" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributesOutputReference.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobJobClusterNewClusterAwsAttributesOutputReference;

new JobJobClusterNewClusterAwsAttributesOutputReference(IInterpolatingParent terraformResource, java.lang.String terraformAttribute);
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributesOutputReference.Initializer.parameter.terraformResource">terraformResource</a></code> | <code>com.hashicorp.cdktf.IInterpolatingParent</code> | The parent resource. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributesOutputReference.Initializer.parameter.terraformAttribute">terraformAttribute</a></code> | <code>java.lang.String</code> | The attribute on the parent resource this class is referencing. |

---

##### `terraformResource`<sup>Required</sup> <a name="terraformResource" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributesOutputReference.Initializer.parameter.terraformResource"></a>

- *Type:* com.hashicorp.cdktf.IInterpolatingParent

The parent resource.

---

##### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributesOutputReference.Initializer.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

The attribute on the parent resource this class is referencing.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributesOutputReference.computeFqn">computeFqn</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributesOutputReference.getAnyMapAttribute">getAnyMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributesOutputReference.getBooleanAttribute">getBooleanAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributesOutputReference.getBooleanMapAttribute">getBooleanMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributesOutputReference.getListAttribute">getListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributesOutputReference.getNumberAttribute">getNumberAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributesOutputReference.getNumberListAttribute">getNumberListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributesOutputReference.getNumberMapAttribute">getNumberMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributesOutputReference.getStringAttribute">getStringAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributesOutputReference.getStringMapAttribute">getStringMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributesOutputReference.interpolationForAttribute">interpolationForAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributesOutputReference.resolve">resolve</a></code> | Produce the Token's value at resolution time. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributesOutputReference.toString">toString</a></code> | Return a string representation of this resolvable object. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributesOutputReference.resetAvailability">resetAvailability</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributesOutputReference.resetEbsVolumeCount">resetEbsVolumeCount</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributesOutputReference.resetEbsVolumeSize">resetEbsVolumeSize</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributesOutputReference.resetEbsVolumeType">resetEbsVolumeType</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributesOutputReference.resetFirstOnDemand">resetFirstOnDemand</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributesOutputReference.resetInstanceProfileArn">resetInstanceProfileArn</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributesOutputReference.resetSpotBidPricePercent">resetSpotBidPricePercent</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributesOutputReference.resetZoneId">resetZoneId</a></code> | *No description.* |

---

##### `computeFqn` <a name="computeFqn" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributesOutputReference.computeFqn"></a>

```java
public java.lang.String computeFqn()
```

##### `getAnyMapAttribute` <a name="getAnyMapAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributesOutputReference.getAnyMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Object> getAnyMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributesOutputReference.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getBooleanAttribute` <a name="getBooleanAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributesOutputReference.getBooleanAttribute"></a>

```java
public IResolvable getBooleanAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributesOutputReference.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getBooleanMapAttribute` <a name="getBooleanMapAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributesOutputReference.getBooleanMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Boolean> getBooleanMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributesOutputReference.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getListAttribute` <a name="getListAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributesOutputReference.getListAttribute"></a>

```java
public java.util.List<java.lang.String> getListAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributesOutputReference.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberAttribute` <a name="getNumberAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributesOutputReference.getNumberAttribute"></a>

```java
public java.lang.Number getNumberAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributesOutputReference.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberListAttribute` <a name="getNumberListAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributesOutputReference.getNumberListAttribute"></a>

```java
public java.util.List<java.lang.Number> getNumberListAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributesOutputReference.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberMapAttribute` <a name="getNumberMapAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributesOutputReference.getNumberMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Number> getNumberMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributesOutputReference.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getStringAttribute` <a name="getStringAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributesOutputReference.getStringAttribute"></a>

```java
public java.lang.String getStringAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributesOutputReference.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getStringMapAttribute` <a name="getStringMapAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributesOutputReference.getStringMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.String> getStringMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributesOutputReference.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `interpolationForAttribute` <a name="interpolationForAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributesOutputReference.interpolationForAttribute"></a>

```java
public IResolvable interpolationForAttribute(java.lang.String property)
```

###### `property`<sup>Required</sup> <a name="property" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributesOutputReference.interpolationForAttribute.parameter.property"></a>

- *Type:* java.lang.String

---

##### `resolve` <a name="resolve" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributesOutputReference.resolve"></a>

```java
public java.lang.Object resolve(IResolveContext _context)
```

Produce the Token's value at resolution time.

###### `_context`<sup>Required</sup> <a name="_context" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributesOutputReference.resolve.parameter._context"></a>

- *Type:* com.hashicorp.cdktf.IResolveContext

---

##### `toString` <a name="toString" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributesOutputReference.toString"></a>

```java
public java.lang.String toString()
```

Return a string representation of this resolvable object.

Returns a reversible string representation.

##### `resetAvailability` <a name="resetAvailability" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributesOutputReference.resetAvailability"></a>

```java
public void resetAvailability()
```

##### `resetEbsVolumeCount` <a name="resetEbsVolumeCount" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributesOutputReference.resetEbsVolumeCount"></a>

```java
public void resetEbsVolumeCount()
```

##### `resetEbsVolumeSize` <a name="resetEbsVolumeSize" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributesOutputReference.resetEbsVolumeSize"></a>

```java
public void resetEbsVolumeSize()
```

##### `resetEbsVolumeType` <a name="resetEbsVolumeType" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributesOutputReference.resetEbsVolumeType"></a>

```java
public void resetEbsVolumeType()
```

##### `resetFirstOnDemand` <a name="resetFirstOnDemand" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributesOutputReference.resetFirstOnDemand"></a>

```java
public void resetFirstOnDemand()
```

##### `resetInstanceProfileArn` <a name="resetInstanceProfileArn" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributesOutputReference.resetInstanceProfileArn"></a>

```java
public void resetInstanceProfileArn()
```

##### `resetSpotBidPricePercent` <a name="resetSpotBidPricePercent" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributesOutputReference.resetSpotBidPricePercent"></a>

```java
public void resetSpotBidPricePercent()
```

##### `resetZoneId` <a name="resetZoneId" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributesOutputReference.resetZoneId"></a>

```java
public void resetZoneId()
```


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributesOutputReference.property.creationStack">creationStack</a></code> | <code>java.util.List<java.lang.String></code> | The creation stack of this resolvable which will be appended to errors thrown during resolution. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributesOutputReference.property.fqn">fqn</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributesOutputReference.property.availabilityInput">availabilityInput</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributesOutputReference.property.ebsVolumeCountInput">ebsVolumeCountInput</a></code> | <code>java.lang.Number</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributesOutputReference.property.ebsVolumeSizeInput">ebsVolumeSizeInput</a></code> | <code>java.lang.Number</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributesOutputReference.property.ebsVolumeTypeInput">ebsVolumeTypeInput</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributesOutputReference.property.firstOnDemandInput">firstOnDemandInput</a></code> | <code>java.lang.Number</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributesOutputReference.property.instanceProfileArnInput">instanceProfileArnInput</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributesOutputReference.property.spotBidPricePercentInput">spotBidPricePercentInput</a></code> | <code>java.lang.Number</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributesOutputReference.property.zoneIdInput">zoneIdInput</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributesOutputReference.property.availability">availability</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributesOutputReference.property.ebsVolumeCount">ebsVolumeCount</a></code> | <code>java.lang.Number</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributesOutputReference.property.ebsVolumeSize">ebsVolumeSize</a></code> | <code>java.lang.Number</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributesOutputReference.property.ebsVolumeType">ebsVolumeType</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributesOutputReference.property.firstOnDemand">firstOnDemand</a></code> | <code>java.lang.Number</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributesOutputReference.property.instanceProfileArn">instanceProfileArn</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributesOutputReference.property.spotBidPricePercent">spotBidPricePercent</a></code> | <code>java.lang.Number</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributesOutputReference.property.zoneId">zoneId</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributesOutputReference.property.internalValue">internalValue</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributes">JobJobClusterNewClusterAwsAttributes</a></code> | *No description.* |

---

##### `creationStack`<sup>Required</sup> <a name="creationStack" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributesOutputReference.property.creationStack"></a>

```java
public java.util.List<java.lang.String> getCreationStack();
```

- *Type:* java.util.List<java.lang.String>

The creation stack of this resolvable which will be appended to errors thrown during resolution.

If this returns an empty array the stack will not be attached.

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributesOutputReference.property.fqn"></a>

```java
public java.lang.String getFqn();
```

- *Type:* java.lang.String

---

##### `availabilityInput`<sup>Optional</sup> <a name="availabilityInput" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributesOutputReference.property.availabilityInput"></a>

```java
public java.lang.String getAvailabilityInput();
```

- *Type:* java.lang.String

---

##### `ebsVolumeCountInput`<sup>Optional</sup> <a name="ebsVolumeCountInput" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributesOutputReference.property.ebsVolumeCountInput"></a>

```java
public java.lang.Number getEbsVolumeCountInput();
```

- *Type:* java.lang.Number

---

##### `ebsVolumeSizeInput`<sup>Optional</sup> <a name="ebsVolumeSizeInput" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributesOutputReference.property.ebsVolumeSizeInput"></a>

```java
public java.lang.Number getEbsVolumeSizeInput();
```

- *Type:* java.lang.Number

---

##### `ebsVolumeTypeInput`<sup>Optional</sup> <a name="ebsVolumeTypeInput" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributesOutputReference.property.ebsVolumeTypeInput"></a>

```java
public java.lang.String getEbsVolumeTypeInput();
```

- *Type:* java.lang.String

---

##### `firstOnDemandInput`<sup>Optional</sup> <a name="firstOnDemandInput" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributesOutputReference.property.firstOnDemandInput"></a>

```java
public java.lang.Number getFirstOnDemandInput();
```

- *Type:* java.lang.Number

---

##### `instanceProfileArnInput`<sup>Optional</sup> <a name="instanceProfileArnInput" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributesOutputReference.property.instanceProfileArnInput"></a>

```java
public java.lang.String getInstanceProfileArnInput();
```

- *Type:* java.lang.String

---

##### `spotBidPricePercentInput`<sup>Optional</sup> <a name="spotBidPricePercentInput" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributesOutputReference.property.spotBidPricePercentInput"></a>

```java
public java.lang.Number getSpotBidPricePercentInput();
```

- *Type:* java.lang.Number

---

##### `zoneIdInput`<sup>Optional</sup> <a name="zoneIdInput" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributesOutputReference.property.zoneIdInput"></a>

```java
public java.lang.String getZoneIdInput();
```

- *Type:* java.lang.String

---

##### `availability`<sup>Required</sup> <a name="availability" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributesOutputReference.property.availability"></a>

```java
public java.lang.String getAvailability();
```

- *Type:* java.lang.String

---

##### `ebsVolumeCount`<sup>Required</sup> <a name="ebsVolumeCount" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributesOutputReference.property.ebsVolumeCount"></a>

```java
public java.lang.Number getEbsVolumeCount();
```

- *Type:* java.lang.Number

---

##### `ebsVolumeSize`<sup>Required</sup> <a name="ebsVolumeSize" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributesOutputReference.property.ebsVolumeSize"></a>

```java
public java.lang.Number getEbsVolumeSize();
```

- *Type:* java.lang.Number

---

##### `ebsVolumeType`<sup>Required</sup> <a name="ebsVolumeType" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributesOutputReference.property.ebsVolumeType"></a>

```java
public java.lang.String getEbsVolumeType();
```

- *Type:* java.lang.String

---

##### `firstOnDemand`<sup>Required</sup> <a name="firstOnDemand" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributesOutputReference.property.firstOnDemand"></a>

```java
public java.lang.Number getFirstOnDemand();
```

- *Type:* java.lang.Number

---

##### `instanceProfileArn`<sup>Required</sup> <a name="instanceProfileArn" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributesOutputReference.property.instanceProfileArn"></a>

```java
public java.lang.String getInstanceProfileArn();
```

- *Type:* java.lang.String

---

##### `spotBidPricePercent`<sup>Required</sup> <a name="spotBidPricePercent" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributesOutputReference.property.spotBidPricePercent"></a>

```java
public java.lang.Number getSpotBidPricePercent();
```

- *Type:* java.lang.Number

---

##### `zoneId`<sup>Required</sup> <a name="zoneId" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributesOutputReference.property.zoneId"></a>

```java
public java.lang.String getZoneId();
```

- *Type:* java.lang.String

---

##### `internalValue`<sup>Optional</sup> <a name="internalValue" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributesOutputReference.property.internalValue"></a>

```java
public JobJobClusterNewClusterAwsAttributes getInternalValue();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributes">JobJobClusterNewClusterAwsAttributes</a>

---


### JobJobClusterNewClusterAzureAttributesOutputReference <a name="JobJobClusterNewClusterAzureAttributesOutputReference" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAzureAttributesOutputReference"></a>

#### Initializers <a name="Initializers" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAzureAttributesOutputReference.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobJobClusterNewClusterAzureAttributesOutputReference;

new JobJobClusterNewClusterAzureAttributesOutputReference(IInterpolatingParent terraformResource, java.lang.String terraformAttribute);
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAzureAttributesOutputReference.Initializer.parameter.terraformResource">terraformResource</a></code> | <code>com.hashicorp.cdktf.IInterpolatingParent</code> | The parent resource. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAzureAttributesOutputReference.Initializer.parameter.terraformAttribute">terraformAttribute</a></code> | <code>java.lang.String</code> | The attribute on the parent resource this class is referencing. |

---

##### `terraformResource`<sup>Required</sup> <a name="terraformResource" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAzureAttributesOutputReference.Initializer.parameter.terraformResource"></a>

- *Type:* com.hashicorp.cdktf.IInterpolatingParent

The parent resource.

---

##### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAzureAttributesOutputReference.Initializer.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

The attribute on the parent resource this class is referencing.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAzureAttributesOutputReference.computeFqn">computeFqn</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAzureAttributesOutputReference.getAnyMapAttribute">getAnyMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAzureAttributesOutputReference.getBooleanAttribute">getBooleanAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAzureAttributesOutputReference.getBooleanMapAttribute">getBooleanMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAzureAttributesOutputReference.getListAttribute">getListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAzureAttributesOutputReference.getNumberAttribute">getNumberAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAzureAttributesOutputReference.getNumberListAttribute">getNumberListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAzureAttributesOutputReference.getNumberMapAttribute">getNumberMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAzureAttributesOutputReference.getStringAttribute">getStringAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAzureAttributesOutputReference.getStringMapAttribute">getStringMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAzureAttributesOutputReference.interpolationForAttribute">interpolationForAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAzureAttributesOutputReference.resolve">resolve</a></code> | Produce the Token's value at resolution time. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAzureAttributesOutputReference.toString">toString</a></code> | Return a string representation of this resolvable object. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAzureAttributesOutputReference.resetAvailability">resetAvailability</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAzureAttributesOutputReference.resetFirstOnDemand">resetFirstOnDemand</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAzureAttributesOutputReference.resetSpotBidMaxPrice">resetSpotBidMaxPrice</a></code> | *No description.* |

---

##### `computeFqn` <a name="computeFqn" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAzureAttributesOutputReference.computeFqn"></a>

```java
public java.lang.String computeFqn()
```

##### `getAnyMapAttribute` <a name="getAnyMapAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAzureAttributesOutputReference.getAnyMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Object> getAnyMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAzureAttributesOutputReference.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getBooleanAttribute` <a name="getBooleanAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAzureAttributesOutputReference.getBooleanAttribute"></a>

```java
public IResolvable getBooleanAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAzureAttributesOutputReference.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getBooleanMapAttribute` <a name="getBooleanMapAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAzureAttributesOutputReference.getBooleanMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Boolean> getBooleanMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAzureAttributesOutputReference.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getListAttribute` <a name="getListAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAzureAttributesOutputReference.getListAttribute"></a>

```java
public java.util.List<java.lang.String> getListAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAzureAttributesOutputReference.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberAttribute` <a name="getNumberAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAzureAttributesOutputReference.getNumberAttribute"></a>

```java
public java.lang.Number getNumberAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAzureAttributesOutputReference.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberListAttribute` <a name="getNumberListAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAzureAttributesOutputReference.getNumberListAttribute"></a>

```java
public java.util.List<java.lang.Number> getNumberListAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAzureAttributesOutputReference.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberMapAttribute` <a name="getNumberMapAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAzureAttributesOutputReference.getNumberMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Number> getNumberMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAzureAttributesOutputReference.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getStringAttribute` <a name="getStringAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAzureAttributesOutputReference.getStringAttribute"></a>

```java
public java.lang.String getStringAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAzureAttributesOutputReference.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getStringMapAttribute` <a name="getStringMapAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAzureAttributesOutputReference.getStringMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.String> getStringMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAzureAttributesOutputReference.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `interpolationForAttribute` <a name="interpolationForAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAzureAttributesOutputReference.interpolationForAttribute"></a>

```java
public IResolvable interpolationForAttribute(java.lang.String property)
```

###### `property`<sup>Required</sup> <a name="property" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAzureAttributesOutputReference.interpolationForAttribute.parameter.property"></a>

- *Type:* java.lang.String

---

##### `resolve` <a name="resolve" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAzureAttributesOutputReference.resolve"></a>

```java
public java.lang.Object resolve(IResolveContext _context)
```

Produce the Token's value at resolution time.

###### `_context`<sup>Required</sup> <a name="_context" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAzureAttributesOutputReference.resolve.parameter._context"></a>

- *Type:* com.hashicorp.cdktf.IResolveContext

---

##### `toString` <a name="toString" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAzureAttributesOutputReference.toString"></a>

```java
public java.lang.String toString()
```

Return a string representation of this resolvable object.

Returns a reversible string representation.

##### `resetAvailability` <a name="resetAvailability" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAzureAttributesOutputReference.resetAvailability"></a>

```java
public void resetAvailability()
```

##### `resetFirstOnDemand` <a name="resetFirstOnDemand" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAzureAttributesOutputReference.resetFirstOnDemand"></a>

```java
public void resetFirstOnDemand()
```

##### `resetSpotBidMaxPrice` <a name="resetSpotBidMaxPrice" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAzureAttributesOutputReference.resetSpotBidMaxPrice"></a>

```java
public void resetSpotBidMaxPrice()
```


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAzureAttributesOutputReference.property.creationStack">creationStack</a></code> | <code>java.util.List<java.lang.String></code> | The creation stack of this resolvable which will be appended to errors thrown during resolution. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAzureAttributesOutputReference.property.fqn">fqn</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAzureAttributesOutputReference.property.availabilityInput">availabilityInput</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAzureAttributesOutputReference.property.firstOnDemandInput">firstOnDemandInput</a></code> | <code>java.lang.Number</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAzureAttributesOutputReference.property.spotBidMaxPriceInput">spotBidMaxPriceInput</a></code> | <code>java.lang.Number</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAzureAttributesOutputReference.property.availability">availability</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAzureAttributesOutputReference.property.firstOnDemand">firstOnDemand</a></code> | <code>java.lang.Number</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAzureAttributesOutputReference.property.spotBidMaxPrice">spotBidMaxPrice</a></code> | <code>java.lang.Number</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAzureAttributesOutputReference.property.internalValue">internalValue</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAzureAttributes">JobJobClusterNewClusterAzureAttributes</a></code> | *No description.* |

---

##### `creationStack`<sup>Required</sup> <a name="creationStack" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAzureAttributesOutputReference.property.creationStack"></a>

```java
public java.util.List<java.lang.String> getCreationStack();
```

- *Type:* java.util.List<java.lang.String>

The creation stack of this resolvable which will be appended to errors thrown during resolution.

If this returns an empty array the stack will not be attached.

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAzureAttributesOutputReference.property.fqn"></a>

```java
public java.lang.String getFqn();
```

- *Type:* java.lang.String

---

##### `availabilityInput`<sup>Optional</sup> <a name="availabilityInput" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAzureAttributesOutputReference.property.availabilityInput"></a>

```java
public java.lang.String getAvailabilityInput();
```

- *Type:* java.lang.String

---

##### `firstOnDemandInput`<sup>Optional</sup> <a name="firstOnDemandInput" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAzureAttributesOutputReference.property.firstOnDemandInput"></a>

```java
public java.lang.Number getFirstOnDemandInput();
```

- *Type:* java.lang.Number

---

##### `spotBidMaxPriceInput`<sup>Optional</sup> <a name="spotBidMaxPriceInput" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAzureAttributesOutputReference.property.spotBidMaxPriceInput"></a>

```java
public java.lang.Number getSpotBidMaxPriceInput();
```

- *Type:* java.lang.Number

---

##### `availability`<sup>Required</sup> <a name="availability" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAzureAttributesOutputReference.property.availability"></a>

```java
public java.lang.String getAvailability();
```

- *Type:* java.lang.String

---

##### `firstOnDemand`<sup>Required</sup> <a name="firstOnDemand" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAzureAttributesOutputReference.property.firstOnDemand"></a>

```java
public java.lang.Number getFirstOnDemand();
```

- *Type:* java.lang.Number

---

##### `spotBidMaxPrice`<sup>Required</sup> <a name="spotBidMaxPrice" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAzureAttributesOutputReference.property.spotBidMaxPrice"></a>

```java
public java.lang.Number getSpotBidMaxPrice();
```

- *Type:* java.lang.Number

---

##### `internalValue`<sup>Optional</sup> <a name="internalValue" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterAzureAttributesOutputReference.property.internalValue"></a>

```java
public JobJobClusterNewClusterAzureAttributes getInternalValue();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAzureAttributes">JobJobClusterNewClusterAzureAttributes</a>

---


### JobJobClusterNewClusterClusterLogConfDbfsOutputReference <a name="JobJobClusterNewClusterClusterLogConfDbfsOutputReference" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfDbfsOutputReference"></a>

#### Initializers <a name="Initializers" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfDbfsOutputReference.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobJobClusterNewClusterClusterLogConfDbfsOutputReference;

new JobJobClusterNewClusterClusterLogConfDbfsOutputReference(IInterpolatingParent terraformResource, java.lang.String terraformAttribute);
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfDbfsOutputReference.Initializer.parameter.terraformResource">terraformResource</a></code> | <code>com.hashicorp.cdktf.IInterpolatingParent</code> | The parent resource. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfDbfsOutputReference.Initializer.parameter.terraformAttribute">terraformAttribute</a></code> | <code>java.lang.String</code> | The attribute on the parent resource this class is referencing. |

---

##### `terraformResource`<sup>Required</sup> <a name="terraformResource" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfDbfsOutputReference.Initializer.parameter.terraformResource"></a>

- *Type:* com.hashicorp.cdktf.IInterpolatingParent

The parent resource.

---

##### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfDbfsOutputReference.Initializer.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

The attribute on the parent resource this class is referencing.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfDbfsOutputReference.computeFqn">computeFqn</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfDbfsOutputReference.getAnyMapAttribute">getAnyMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfDbfsOutputReference.getBooleanAttribute">getBooleanAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfDbfsOutputReference.getBooleanMapAttribute">getBooleanMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfDbfsOutputReference.getListAttribute">getListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfDbfsOutputReference.getNumberAttribute">getNumberAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfDbfsOutputReference.getNumberListAttribute">getNumberListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfDbfsOutputReference.getNumberMapAttribute">getNumberMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfDbfsOutputReference.getStringAttribute">getStringAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfDbfsOutputReference.getStringMapAttribute">getStringMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfDbfsOutputReference.interpolationForAttribute">interpolationForAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfDbfsOutputReference.resolve">resolve</a></code> | Produce the Token's value at resolution time. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfDbfsOutputReference.toString">toString</a></code> | Return a string representation of this resolvable object. |

---

##### `computeFqn` <a name="computeFqn" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfDbfsOutputReference.computeFqn"></a>

```java
public java.lang.String computeFqn()
```

##### `getAnyMapAttribute` <a name="getAnyMapAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfDbfsOutputReference.getAnyMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Object> getAnyMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfDbfsOutputReference.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getBooleanAttribute` <a name="getBooleanAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfDbfsOutputReference.getBooleanAttribute"></a>

```java
public IResolvable getBooleanAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfDbfsOutputReference.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getBooleanMapAttribute` <a name="getBooleanMapAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfDbfsOutputReference.getBooleanMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Boolean> getBooleanMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfDbfsOutputReference.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getListAttribute` <a name="getListAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfDbfsOutputReference.getListAttribute"></a>

```java
public java.util.List<java.lang.String> getListAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfDbfsOutputReference.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberAttribute` <a name="getNumberAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfDbfsOutputReference.getNumberAttribute"></a>

```java
public java.lang.Number getNumberAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfDbfsOutputReference.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberListAttribute` <a name="getNumberListAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfDbfsOutputReference.getNumberListAttribute"></a>

```java
public java.util.List<java.lang.Number> getNumberListAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfDbfsOutputReference.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberMapAttribute` <a name="getNumberMapAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfDbfsOutputReference.getNumberMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Number> getNumberMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfDbfsOutputReference.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getStringAttribute` <a name="getStringAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfDbfsOutputReference.getStringAttribute"></a>

```java
public java.lang.String getStringAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfDbfsOutputReference.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getStringMapAttribute` <a name="getStringMapAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfDbfsOutputReference.getStringMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.String> getStringMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfDbfsOutputReference.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `interpolationForAttribute` <a name="interpolationForAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfDbfsOutputReference.interpolationForAttribute"></a>

```java
public IResolvable interpolationForAttribute(java.lang.String property)
```

###### `property`<sup>Required</sup> <a name="property" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfDbfsOutputReference.interpolationForAttribute.parameter.property"></a>

- *Type:* java.lang.String

---

##### `resolve` <a name="resolve" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfDbfsOutputReference.resolve"></a>

```java
public java.lang.Object resolve(IResolveContext _context)
```

Produce the Token's value at resolution time.

###### `_context`<sup>Required</sup> <a name="_context" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfDbfsOutputReference.resolve.parameter._context"></a>

- *Type:* com.hashicorp.cdktf.IResolveContext

---

##### `toString` <a name="toString" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfDbfsOutputReference.toString"></a>

```java
public java.lang.String toString()
```

Return a string representation of this resolvable object.

Returns a reversible string representation.


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfDbfsOutputReference.property.creationStack">creationStack</a></code> | <code>java.util.List<java.lang.String></code> | The creation stack of this resolvable which will be appended to errors thrown during resolution. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfDbfsOutputReference.property.fqn">fqn</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfDbfsOutputReference.property.destinationInput">destinationInput</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfDbfsOutputReference.property.destination">destination</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfDbfsOutputReference.property.internalValue">internalValue</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfDbfs">JobJobClusterNewClusterClusterLogConfDbfs</a></code> | *No description.* |

---

##### `creationStack`<sup>Required</sup> <a name="creationStack" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfDbfsOutputReference.property.creationStack"></a>

```java
public java.util.List<java.lang.String> getCreationStack();
```

- *Type:* java.util.List<java.lang.String>

The creation stack of this resolvable which will be appended to errors thrown during resolution.

If this returns an empty array the stack will not be attached.

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfDbfsOutputReference.property.fqn"></a>

```java
public java.lang.String getFqn();
```

- *Type:* java.lang.String

---

##### `destinationInput`<sup>Optional</sup> <a name="destinationInput" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfDbfsOutputReference.property.destinationInput"></a>

```java
public java.lang.String getDestinationInput();
```

- *Type:* java.lang.String

---

##### `destination`<sup>Required</sup> <a name="destination" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfDbfsOutputReference.property.destination"></a>

```java
public java.lang.String getDestination();
```

- *Type:* java.lang.String

---

##### `internalValue`<sup>Optional</sup> <a name="internalValue" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfDbfsOutputReference.property.internalValue"></a>

```java
public JobJobClusterNewClusterClusterLogConfDbfs getInternalValue();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfDbfs">JobJobClusterNewClusterClusterLogConfDbfs</a>

---


### JobJobClusterNewClusterClusterLogConfOutputReference <a name="JobJobClusterNewClusterClusterLogConfOutputReference" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfOutputReference"></a>

#### Initializers <a name="Initializers" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfOutputReference.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobJobClusterNewClusterClusterLogConfOutputReference;

new JobJobClusterNewClusterClusterLogConfOutputReference(IInterpolatingParent terraformResource, java.lang.String terraformAttribute);
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfOutputReference.Initializer.parameter.terraformResource">terraformResource</a></code> | <code>com.hashicorp.cdktf.IInterpolatingParent</code> | The parent resource. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfOutputReference.Initializer.parameter.terraformAttribute">terraformAttribute</a></code> | <code>java.lang.String</code> | The attribute on the parent resource this class is referencing. |

---

##### `terraformResource`<sup>Required</sup> <a name="terraformResource" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfOutputReference.Initializer.parameter.terraformResource"></a>

- *Type:* com.hashicorp.cdktf.IInterpolatingParent

The parent resource.

---

##### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfOutputReference.Initializer.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

The attribute on the parent resource this class is referencing.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfOutputReference.computeFqn">computeFqn</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfOutputReference.getAnyMapAttribute">getAnyMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfOutputReference.getBooleanAttribute">getBooleanAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfOutputReference.getBooleanMapAttribute">getBooleanMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfOutputReference.getListAttribute">getListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfOutputReference.getNumberAttribute">getNumberAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfOutputReference.getNumberListAttribute">getNumberListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfOutputReference.getNumberMapAttribute">getNumberMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfOutputReference.getStringAttribute">getStringAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfOutputReference.getStringMapAttribute">getStringMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfOutputReference.interpolationForAttribute">interpolationForAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfOutputReference.resolve">resolve</a></code> | Produce the Token's value at resolution time. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfOutputReference.toString">toString</a></code> | Return a string representation of this resolvable object. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfOutputReference.putDbfs">putDbfs</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfOutputReference.putS3">putS3</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfOutputReference.resetDbfs">resetDbfs</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfOutputReference.resetS3">resetS3</a></code> | *No description.* |

---

##### `computeFqn` <a name="computeFqn" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfOutputReference.computeFqn"></a>

```java
public java.lang.String computeFqn()
```

##### `getAnyMapAttribute` <a name="getAnyMapAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfOutputReference.getAnyMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Object> getAnyMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfOutputReference.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getBooleanAttribute` <a name="getBooleanAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfOutputReference.getBooleanAttribute"></a>

```java
public IResolvable getBooleanAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfOutputReference.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getBooleanMapAttribute` <a name="getBooleanMapAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfOutputReference.getBooleanMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Boolean> getBooleanMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfOutputReference.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getListAttribute` <a name="getListAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfOutputReference.getListAttribute"></a>

```java
public java.util.List<java.lang.String> getListAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfOutputReference.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberAttribute` <a name="getNumberAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfOutputReference.getNumberAttribute"></a>

```java
public java.lang.Number getNumberAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfOutputReference.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberListAttribute` <a name="getNumberListAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfOutputReference.getNumberListAttribute"></a>

```java
public java.util.List<java.lang.Number> getNumberListAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfOutputReference.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberMapAttribute` <a name="getNumberMapAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfOutputReference.getNumberMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Number> getNumberMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfOutputReference.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getStringAttribute` <a name="getStringAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfOutputReference.getStringAttribute"></a>

```java
public java.lang.String getStringAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfOutputReference.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getStringMapAttribute` <a name="getStringMapAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfOutputReference.getStringMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.String> getStringMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfOutputReference.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `interpolationForAttribute` <a name="interpolationForAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfOutputReference.interpolationForAttribute"></a>

```java
public IResolvable interpolationForAttribute(java.lang.String property)
```

###### `property`<sup>Required</sup> <a name="property" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfOutputReference.interpolationForAttribute.parameter.property"></a>

- *Type:* java.lang.String

---

##### `resolve` <a name="resolve" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfOutputReference.resolve"></a>

```java
public java.lang.Object resolve(IResolveContext _context)
```

Produce the Token's value at resolution time.

###### `_context`<sup>Required</sup> <a name="_context" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfOutputReference.resolve.parameter._context"></a>

- *Type:* com.hashicorp.cdktf.IResolveContext

---

##### `toString` <a name="toString" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfOutputReference.toString"></a>

```java
public java.lang.String toString()
```

Return a string representation of this resolvable object.

Returns a reversible string representation.

##### `putDbfs` <a name="putDbfs" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfOutputReference.putDbfs"></a>

```java
public void putDbfs(JobJobClusterNewClusterClusterLogConfDbfs value)
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfOutputReference.putDbfs.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfDbfs">JobJobClusterNewClusterClusterLogConfDbfs</a>

---

##### `putS3` <a name="putS3" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfOutputReference.putS3"></a>

```java
public void putS3(JobJobClusterNewClusterClusterLogConfS3 value)
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfOutputReference.putS3.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3">JobJobClusterNewClusterClusterLogConfS3</a>

---

##### `resetDbfs` <a name="resetDbfs" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfOutputReference.resetDbfs"></a>

```java
public void resetDbfs()
```

##### `resetS3` <a name="resetS3" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfOutputReference.resetS3"></a>

```java
public void resetS3()
```


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfOutputReference.property.creationStack">creationStack</a></code> | <code>java.util.List<java.lang.String></code> | The creation stack of this resolvable which will be appended to errors thrown during resolution. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfOutputReference.property.fqn">fqn</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfOutputReference.property.dbfs">dbfs</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfDbfsOutputReference">JobJobClusterNewClusterClusterLogConfDbfsOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfOutputReference.property.s3">s3</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3OutputReference">JobJobClusterNewClusterClusterLogConfS3OutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfOutputReference.property.dbfsInput">dbfsInput</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfDbfs">JobJobClusterNewClusterClusterLogConfDbfs</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfOutputReference.property.s3Input">s3Input</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3">JobJobClusterNewClusterClusterLogConfS3</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfOutputReference.property.internalValue">internalValue</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConf">JobJobClusterNewClusterClusterLogConf</a></code> | *No description.* |

---

##### `creationStack`<sup>Required</sup> <a name="creationStack" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfOutputReference.property.creationStack"></a>

```java
public java.util.List<java.lang.String> getCreationStack();
```

- *Type:* java.util.List<java.lang.String>

The creation stack of this resolvable which will be appended to errors thrown during resolution.

If this returns an empty array the stack will not be attached.

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfOutputReference.property.fqn"></a>

```java
public java.lang.String getFqn();
```

- *Type:* java.lang.String

---

##### `dbfs`<sup>Required</sup> <a name="dbfs" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfOutputReference.property.dbfs"></a>

```java
public JobJobClusterNewClusterClusterLogConfDbfsOutputReference getDbfs();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfDbfsOutputReference">JobJobClusterNewClusterClusterLogConfDbfsOutputReference</a>

---

##### `s3`<sup>Required</sup> <a name="s3" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfOutputReference.property.s3"></a>

```java
public JobJobClusterNewClusterClusterLogConfS3OutputReference getS3();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3OutputReference">JobJobClusterNewClusterClusterLogConfS3OutputReference</a>

---

##### `dbfsInput`<sup>Optional</sup> <a name="dbfsInput" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfOutputReference.property.dbfsInput"></a>

```java
public JobJobClusterNewClusterClusterLogConfDbfs getDbfsInput();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfDbfs">JobJobClusterNewClusterClusterLogConfDbfs</a>

---

##### `s3Input`<sup>Optional</sup> <a name="s3Input" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfOutputReference.property.s3Input"></a>

```java
public JobJobClusterNewClusterClusterLogConfS3 getS3Input();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3">JobJobClusterNewClusterClusterLogConfS3</a>

---

##### `internalValue`<sup>Optional</sup> <a name="internalValue" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfOutputReference.property.internalValue"></a>

```java
public JobJobClusterNewClusterClusterLogConf getInternalValue();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConf">JobJobClusterNewClusterClusterLogConf</a>

---


### JobJobClusterNewClusterClusterLogConfS3OutputReference <a name="JobJobClusterNewClusterClusterLogConfS3OutputReference" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3OutputReference"></a>

#### Initializers <a name="Initializers" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3OutputReference.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobJobClusterNewClusterClusterLogConfS3OutputReference;

new JobJobClusterNewClusterClusterLogConfS3OutputReference(IInterpolatingParent terraformResource, java.lang.String terraformAttribute);
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3OutputReference.Initializer.parameter.terraformResource">terraformResource</a></code> | <code>com.hashicorp.cdktf.IInterpolatingParent</code> | The parent resource. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3OutputReference.Initializer.parameter.terraformAttribute">terraformAttribute</a></code> | <code>java.lang.String</code> | The attribute on the parent resource this class is referencing. |

---

##### `terraformResource`<sup>Required</sup> <a name="terraformResource" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3OutputReference.Initializer.parameter.terraformResource"></a>

- *Type:* com.hashicorp.cdktf.IInterpolatingParent

The parent resource.

---

##### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3OutputReference.Initializer.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

The attribute on the parent resource this class is referencing.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3OutputReference.computeFqn">computeFqn</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3OutputReference.getAnyMapAttribute">getAnyMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3OutputReference.getBooleanAttribute">getBooleanAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3OutputReference.getBooleanMapAttribute">getBooleanMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3OutputReference.getListAttribute">getListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3OutputReference.getNumberAttribute">getNumberAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3OutputReference.getNumberListAttribute">getNumberListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3OutputReference.getNumberMapAttribute">getNumberMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3OutputReference.getStringAttribute">getStringAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3OutputReference.getStringMapAttribute">getStringMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3OutputReference.interpolationForAttribute">interpolationForAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3OutputReference.resolve">resolve</a></code> | Produce the Token's value at resolution time. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3OutputReference.toString">toString</a></code> | Return a string representation of this resolvable object. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3OutputReference.resetCannedAcl">resetCannedAcl</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3OutputReference.resetEnableEncryption">resetEnableEncryption</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3OutputReference.resetEncryptionType">resetEncryptionType</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3OutputReference.resetEndpoint">resetEndpoint</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3OutputReference.resetKmsKey">resetKmsKey</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3OutputReference.resetRegion">resetRegion</a></code> | *No description.* |

---

##### `computeFqn` <a name="computeFqn" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3OutputReference.computeFqn"></a>

```java
public java.lang.String computeFqn()
```

##### `getAnyMapAttribute` <a name="getAnyMapAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3OutputReference.getAnyMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Object> getAnyMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3OutputReference.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getBooleanAttribute` <a name="getBooleanAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3OutputReference.getBooleanAttribute"></a>

```java
public IResolvable getBooleanAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3OutputReference.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getBooleanMapAttribute` <a name="getBooleanMapAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3OutputReference.getBooleanMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Boolean> getBooleanMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3OutputReference.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getListAttribute` <a name="getListAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3OutputReference.getListAttribute"></a>

```java
public java.util.List<java.lang.String> getListAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3OutputReference.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberAttribute` <a name="getNumberAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3OutputReference.getNumberAttribute"></a>

```java
public java.lang.Number getNumberAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3OutputReference.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberListAttribute` <a name="getNumberListAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3OutputReference.getNumberListAttribute"></a>

```java
public java.util.List<java.lang.Number> getNumberListAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3OutputReference.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberMapAttribute` <a name="getNumberMapAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3OutputReference.getNumberMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Number> getNumberMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3OutputReference.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getStringAttribute` <a name="getStringAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3OutputReference.getStringAttribute"></a>

```java
public java.lang.String getStringAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3OutputReference.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getStringMapAttribute` <a name="getStringMapAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3OutputReference.getStringMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.String> getStringMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3OutputReference.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `interpolationForAttribute` <a name="interpolationForAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3OutputReference.interpolationForAttribute"></a>

```java
public IResolvable interpolationForAttribute(java.lang.String property)
```

###### `property`<sup>Required</sup> <a name="property" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3OutputReference.interpolationForAttribute.parameter.property"></a>

- *Type:* java.lang.String

---

##### `resolve` <a name="resolve" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3OutputReference.resolve"></a>

```java
public java.lang.Object resolve(IResolveContext _context)
```

Produce the Token's value at resolution time.

###### `_context`<sup>Required</sup> <a name="_context" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3OutputReference.resolve.parameter._context"></a>

- *Type:* com.hashicorp.cdktf.IResolveContext

---

##### `toString` <a name="toString" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3OutputReference.toString"></a>

```java
public java.lang.String toString()
```

Return a string representation of this resolvable object.

Returns a reversible string representation.

##### `resetCannedAcl` <a name="resetCannedAcl" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3OutputReference.resetCannedAcl"></a>

```java
public void resetCannedAcl()
```

##### `resetEnableEncryption` <a name="resetEnableEncryption" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3OutputReference.resetEnableEncryption"></a>

```java
public void resetEnableEncryption()
```

##### `resetEncryptionType` <a name="resetEncryptionType" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3OutputReference.resetEncryptionType"></a>

```java
public void resetEncryptionType()
```

##### `resetEndpoint` <a name="resetEndpoint" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3OutputReference.resetEndpoint"></a>

```java
public void resetEndpoint()
```

##### `resetKmsKey` <a name="resetKmsKey" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3OutputReference.resetKmsKey"></a>

```java
public void resetKmsKey()
```

##### `resetRegion` <a name="resetRegion" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3OutputReference.resetRegion"></a>

```java
public void resetRegion()
```


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3OutputReference.property.creationStack">creationStack</a></code> | <code>java.util.List<java.lang.String></code> | The creation stack of this resolvable which will be appended to errors thrown during resolution. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3OutputReference.property.fqn">fqn</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3OutputReference.property.cannedAclInput">cannedAclInput</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3OutputReference.property.destinationInput">destinationInput</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3OutputReference.property.enableEncryptionInput">enableEncryptionInput</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3OutputReference.property.encryptionTypeInput">encryptionTypeInput</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3OutputReference.property.endpointInput">endpointInput</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3OutputReference.property.kmsKeyInput">kmsKeyInput</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3OutputReference.property.regionInput">regionInput</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3OutputReference.property.cannedAcl">cannedAcl</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3OutputReference.property.destination">destination</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3OutputReference.property.enableEncryption">enableEncryption</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3OutputReference.property.encryptionType">encryptionType</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3OutputReference.property.endpoint">endpoint</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3OutputReference.property.kmsKey">kmsKey</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3OutputReference.property.region">region</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3OutputReference.property.internalValue">internalValue</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3">JobJobClusterNewClusterClusterLogConfS3</a></code> | *No description.* |

---

##### `creationStack`<sup>Required</sup> <a name="creationStack" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3OutputReference.property.creationStack"></a>

```java
public java.util.List<java.lang.String> getCreationStack();
```

- *Type:* java.util.List<java.lang.String>

The creation stack of this resolvable which will be appended to errors thrown during resolution.

If this returns an empty array the stack will not be attached.

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3OutputReference.property.fqn"></a>

```java
public java.lang.String getFqn();
```

- *Type:* java.lang.String

---

##### `cannedAclInput`<sup>Optional</sup> <a name="cannedAclInput" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3OutputReference.property.cannedAclInput"></a>

```java
public java.lang.String getCannedAclInput();
```

- *Type:* java.lang.String

---

##### `destinationInput`<sup>Optional</sup> <a name="destinationInput" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3OutputReference.property.destinationInput"></a>

```java
public java.lang.String getDestinationInput();
```

- *Type:* java.lang.String

---

##### `enableEncryptionInput`<sup>Optional</sup> <a name="enableEncryptionInput" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3OutputReference.property.enableEncryptionInput"></a>

```java
public java.lang.Object getEnableEncryptionInput();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

---

##### `encryptionTypeInput`<sup>Optional</sup> <a name="encryptionTypeInput" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3OutputReference.property.encryptionTypeInput"></a>

```java
public java.lang.String getEncryptionTypeInput();
```

- *Type:* java.lang.String

---

##### `endpointInput`<sup>Optional</sup> <a name="endpointInput" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3OutputReference.property.endpointInput"></a>

```java
public java.lang.String getEndpointInput();
```

- *Type:* java.lang.String

---

##### `kmsKeyInput`<sup>Optional</sup> <a name="kmsKeyInput" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3OutputReference.property.kmsKeyInput"></a>

```java
public java.lang.String getKmsKeyInput();
```

- *Type:* java.lang.String

---

##### `regionInput`<sup>Optional</sup> <a name="regionInput" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3OutputReference.property.regionInput"></a>

```java
public java.lang.String getRegionInput();
```

- *Type:* java.lang.String

---

##### `cannedAcl`<sup>Required</sup> <a name="cannedAcl" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3OutputReference.property.cannedAcl"></a>

```java
public java.lang.String getCannedAcl();
```

- *Type:* java.lang.String

---

##### `destination`<sup>Required</sup> <a name="destination" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3OutputReference.property.destination"></a>

```java
public java.lang.String getDestination();
```

- *Type:* java.lang.String

---

##### `enableEncryption`<sup>Required</sup> <a name="enableEncryption" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3OutputReference.property.enableEncryption"></a>

```java
public java.lang.Object getEnableEncryption();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

---

##### `encryptionType`<sup>Required</sup> <a name="encryptionType" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3OutputReference.property.encryptionType"></a>

```java
public java.lang.String getEncryptionType();
```

- *Type:* java.lang.String

---

##### `endpoint`<sup>Required</sup> <a name="endpoint" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3OutputReference.property.endpoint"></a>

```java
public java.lang.String getEndpoint();
```

- *Type:* java.lang.String

---

##### `kmsKey`<sup>Required</sup> <a name="kmsKey" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3OutputReference.property.kmsKey"></a>

```java
public java.lang.String getKmsKey();
```

- *Type:* java.lang.String

---

##### `region`<sup>Required</sup> <a name="region" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3OutputReference.property.region"></a>

```java
public java.lang.String getRegion();
```

- *Type:* java.lang.String

---

##### `internalValue`<sup>Optional</sup> <a name="internalValue" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3OutputReference.property.internalValue"></a>

```java
public JobJobClusterNewClusterClusterLogConfS3 getInternalValue();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfS3">JobJobClusterNewClusterClusterLogConfS3</a>

---


### JobJobClusterNewClusterClusterMountInfoList <a name="JobJobClusterNewClusterClusterMountInfoList" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoList"></a>

#### Initializers <a name="Initializers" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoList.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobJobClusterNewClusterClusterMountInfoList;

new JobJobClusterNewClusterClusterMountInfoList(IInterpolatingParent terraformResource, java.lang.String terraformAttribute, java.lang.Boolean wrapsSet);
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoList.Initializer.parameter.terraformResource">terraformResource</a></code> | <code>com.hashicorp.cdktf.IInterpolatingParent</code> | The parent resource. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoList.Initializer.parameter.terraformAttribute">terraformAttribute</a></code> | <code>java.lang.String</code> | The attribute on the parent resource this class is referencing. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoList.Initializer.parameter.wrapsSet">wrapsSet</a></code> | <code>java.lang.Boolean</code> | whether the list is wrapping a set (will add tolist() to be able to access an item via an index). |

---

##### `terraformResource`<sup>Required</sup> <a name="terraformResource" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoList.Initializer.parameter.terraformResource"></a>

- *Type:* com.hashicorp.cdktf.IInterpolatingParent

The parent resource.

---

##### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoList.Initializer.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

The attribute on the parent resource this class is referencing.

---

##### `wrapsSet`<sup>Required</sup> <a name="wrapsSet" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoList.Initializer.parameter.wrapsSet"></a>

- *Type:* java.lang.Boolean

whether the list is wrapping a set (will add tolist() to be able to access an item via an index).

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoList.computeFqn">computeFqn</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoList.resolve">resolve</a></code> | Produce the Token's value at resolution time. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoList.toString">toString</a></code> | Return a string representation of this resolvable object. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoList.get">get</a></code> | *No description.* |

---

##### `computeFqn` <a name="computeFqn" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoList.computeFqn"></a>

```java
public java.lang.String computeFqn()
```

##### `resolve` <a name="resolve" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoList.resolve"></a>

```java
public java.lang.Object resolve(IResolveContext _context)
```

Produce the Token's value at resolution time.

###### `_context`<sup>Required</sup> <a name="_context" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoList.resolve.parameter._context"></a>

- *Type:* com.hashicorp.cdktf.IResolveContext

---

##### `toString` <a name="toString" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoList.toString"></a>

```java
public java.lang.String toString()
```

Return a string representation of this resolvable object.

Returns a reversible string representation.

##### `get` <a name="get" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoList.get"></a>

```java
public JobJobClusterNewClusterClusterMountInfoOutputReference get(java.lang.Number index)
```

###### `index`<sup>Required</sup> <a name="index" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoList.get.parameter.index"></a>

- *Type:* java.lang.Number

the index of the item to return.

---


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoList.property.creationStack">creationStack</a></code> | <code>java.util.List<java.lang.String></code> | The creation stack of this resolvable which will be appended to errors thrown during resolution. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoList.property.fqn">fqn</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoList.property.internalValue">internalValue</a></code> | <code>com.hashicorp.cdktf.IResolvable OR java.util.List<<a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfo">JobJobClusterNewClusterClusterMountInfo</a>></code> | *No description.* |

---

##### `creationStack`<sup>Required</sup> <a name="creationStack" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoList.property.creationStack"></a>

```java
public java.util.List<java.lang.String> getCreationStack();
```

- *Type:* java.util.List<java.lang.String>

The creation stack of this resolvable which will be appended to errors thrown during resolution.

If this returns an empty array the stack will not be attached.

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoList.property.fqn"></a>

```java
public java.lang.String getFqn();
```

- *Type:* java.lang.String

---

##### `internalValue`<sup>Optional</sup> <a name="internalValue" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoList.property.internalValue"></a>

```java
public java.lang.Object getInternalValue();
```

- *Type:* com.hashicorp.cdktf.IResolvable OR java.util.List<<a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfo">JobJobClusterNewClusterClusterMountInfo</a>>

---


### JobJobClusterNewClusterClusterMountInfoNetworkFilesystemInfoOutputReference <a name="JobJobClusterNewClusterClusterMountInfoNetworkFilesystemInfoOutputReference" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoNetworkFilesystemInfoOutputReference"></a>

#### Initializers <a name="Initializers" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoNetworkFilesystemInfoOutputReference.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobJobClusterNewClusterClusterMountInfoNetworkFilesystemInfoOutputReference;

new JobJobClusterNewClusterClusterMountInfoNetworkFilesystemInfoOutputReference(IInterpolatingParent terraformResource, java.lang.String terraformAttribute);
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoNetworkFilesystemInfoOutputReference.Initializer.parameter.terraformResource">terraformResource</a></code> | <code>com.hashicorp.cdktf.IInterpolatingParent</code> | The parent resource. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoNetworkFilesystemInfoOutputReference.Initializer.parameter.terraformAttribute">terraformAttribute</a></code> | <code>java.lang.String</code> | The attribute on the parent resource this class is referencing. |

---

##### `terraformResource`<sup>Required</sup> <a name="terraformResource" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoNetworkFilesystemInfoOutputReference.Initializer.parameter.terraformResource"></a>

- *Type:* com.hashicorp.cdktf.IInterpolatingParent

The parent resource.

---

##### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoNetworkFilesystemInfoOutputReference.Initializer.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

The attribute on the parent resource this class is referencing.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoNetworkFilesystemInfoOutputReference.computeFqn">computeFqn</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoNetworkFilesystemInfoOutputReference.getAnyMapAttribute">getAnyMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoNetworkFilesystemInfoOutputReference.getBooleanAttribute">getBooleanAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoNetworkFilesystemInfoOutputReference.getBooleanMapAttribute">getBooleanMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoNetworkFilesystemInfoOutputReference.getListAttribute">getListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoNetworkFilesystemInfoOutputReference.getNumberAttribute">getNumberAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoNetworkFilesystemInfoOutputReference.getNumberListAttribute">getNumberListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoNetworkFilesystemInfoOutputReference.getNumberMapAttribute">getNumberMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoNetworkFilesystemInfoOutputReference.getStringAttribute">getStringAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoNetworkFilesystemInfoOutputReference.getStringMapAttribute">getStringMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoNetworkFilesystemInfoOutputReference.interpolationForAttribute">interpolationForAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoNetworkFilesystemInfoOutputReference.resolve">resolve</a></code> | Produce the Token's value at resolution time. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoNetworkFilesystemInfoOutputReference.toString">toString</a></code> | Return a string representation of this resolvable object. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoNetworkFilesystemInfoOutputReference.resetMountOptions">resetMountOptions</a></code> | *No description.* |

---

##### `computeFqn` <a name="computeFqn" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoNetworkFilesystemInfoOutputReference.computeFqn"></a>

```java
public java.lang.String computeFqn()
```

##### `getAnyMapAttribute` <a name="getAnyMapAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoNetworkFilesystemInfoOutputReference.getAnyMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Object> getAnyMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoNetworkFilesystemInfoOutputReference.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getBooleanAttribute` <a name="getBooleanAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoNetworkFilesystemInfoOutputReference.getBooleanAttribute"></a>

```java
public IResolvable getBooleanAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoNetworkFilesystemInfoOutputReference.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getBooleanMapAttribute` <a name="getBooleanMapAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoNetworkFilesystemInfoOutputReference.getBooleanMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Boolean> getBooleanMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoNetworkFilesystemInfoOutputReference.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getListAttribute` <a name="getListAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoNetworkFilesystemInfoOutputReference.getListAttribute"></a>

```java
public java.util.List<java.lang.String> getListAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoNetworkFilesystemInfoOutputReference.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberAttribute` <a name="getNumberAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoNetworkFilesystemInfoOutputReference.getNumberAttribute"></a>

```java
public java.lang.Number getNumberAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoNetworkFilesystemInfoOutputReference.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberListAttribute` <a name="getNumberListAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoNetworkFilesystemInfoOutputReference.getNumberListAttribute"></a>

```java
public java.util.List<java.lang.Number> getNumberListAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoNetworkFilesystemInfoOutputReference.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberMapAttribute` <a name="getNumberMapAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoNetworkFilesystemInfoOutputReference.getNumberMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Number> getNumberMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoNetworkFilesystemInfoOutputReference.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getStringAttribute` <a name="getStringAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoNetworkFilesystemInfoOutputReference.getStringAttribute"></a>

```java
public java.lang.String getStringAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoNetworkFilesystemInfoOutputReference.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getStringMapAttribute` <a name="getStringMapAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoNetworkFilesystemInfoOutputReference.getStringMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.String> getStringMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoNetworkFilesystemInfoOutputReference.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `interpolationForAttribute` <a name="interpolationForAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoNetworkFilesystemInfoOutputReference.interpolationForAttribute"></a>

```java
public IResolvable interpolationForAttribute(java.lang.String property)
```

###### `property`<sup>Required</sup> <a name="property" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoNetworkFilesystemInfoOutputReference.interpolationForAttribute.parameter.property"></a>

- *Type:* java.lang.String

---

##### `resolve` <a name="resolve" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoNetworkFilesystemInfoOutputReference.resolve"></a>

```java
public java.lang.Object resolve(IResolveContext _context)
```

Produce the Token's value at resolution time.

###### `_context`<sup>Required</sup> <a name="_context" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoNetworkFilesystemInfoOutputReference.resolve.parameter._context"></a>

- *Type:* com.hashicorp.cdktf.IResolveContext

---

##### `toString` <a name="toString" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoNetworkFilesystemInfoOutputReference.toString"></a>

```java
public java.lang.String toString()
```

Return a string representation of this resolvable object.

Returns a reversible string representation.

##### `resetMountOptions` <a name="resetMountOptions" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoNetworkFilesystemInfoOutputReference.resetMountOptions"></a>

```java
public void resetMountOptions()
```


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoNetworkFilesystemInfoOutputReference.property.creationStack">creationStack</a></code> | <code>java.util.List<java.lang.String></code> | The creation stack of this resolvable which will be appended to errors thrown during resolution. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoNetworkFilesystemInfoOutputReference.property.fqn">fqn</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoNetworkFilesystemInfoOutputReference.property.mountOptionsInput">mountOptionsInput</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoNetworkFilesystemInfoOutputReference.property.serverAddressInput">serverAddressInput</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoNetworkFilesystemInfoOutputReference.property.mountOptions">mountOptions</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoNetworkFilesystemInfoOutputReference.property.serverAddress">serverAddress</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoNetworkFilesystemInfoOutputReference.property.internalValue">internalValue</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoNetworkFilesystemInfo">JobJobClusterNewClusterClusterMountInfoNetworkFilesystemInfo</a></code> | *No description.* |

---

##### `creationStack`<sup>Required</sup> <a name="creationStack" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoNetworkFilesystemInfoOutputReference.property.creationStack"></a>

```java
public java.util.List<java.lang.String> getCreationStack();
```

- *Type:* java.util.List<java.lang.String>

The creation stack of this resolvable which will be appended to errors thrown during resolution.

If this returns an empty array the stack will not be attached.

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoNetworkFilesystemInfoOutputReference.property.fqn"></a>

```java
public java.lang.String getFqn();
```

- *Type:* java.lang.String

---

##### `mountOptionsInput`<sup>Optional</sup> <a name="mountOptionsInput" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoNetworkFilesystemInfoOutputReference.property.mountOptionsInput"></a>

```java
public java.lang.String getMountOptionsInput();
```

- *Type:* java.lang.String

---

##### `serverAddressInput`<sup>Optional</sup> <a name="serverAddressInput" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoNetworkFilesystemInfoOutputReference.property.serverAddressInput"></a>

```java
public java.lang.String getServerAddressInput();
```

- *Type:* java.lang.String

---

##### `mountOptions`<sup>Required</sup> <a name="mountOptions" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoNetworkFilesystemInfoOutputReference.property.mountOptions"></a>

```java
public java.lang.String getMountOptions();
```

- *Type:* java.lang.String

---

##### `serverAddress`<sup>Required</sup> <a name="serverAddress" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoNetworkFilesystemInfoOutputReference.property.serverAddress"></a>

```java
public java.lang.String getServerAddress();
```

- *Type:* java.lang.String

---

##### `internalValue`<sup>Optional</sup> <a name="internalValue" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoNetworkFilesystemInfoOutputReference.property.internalValue"></a>

```java
public JobJobClusterNewClusterClusterMountInfoNetworkFilesystemInfo getInternalValue();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoNetworkFilesystemInfo">JobJobClusterNewClusterClusterMountInfoNetworkFilesystemInfo</a>

---


### JobJobClusterNewClusterClusterMountInfoOutputReference <a name="JobJobClusterNewClusterClusterMountInfoOutputReference" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoOutputReference"></a>

#### Initializers <a name="Initializers" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoOutputReference.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobJobClusterNewClusterClusterMountInfoOutputReference;

new JobJobClusterNewClusterClusterMountInfoOutputReference(IInterpolatingParent terraformResource, java.lang.String terraformAttribute, java.lang.Number complexObjectIndex, java.lang.Boolean complexObjectIsFromSet);
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoOutputReference.Initializer.parameter.terraformResource">terraformResource</a></code> | <code>com.hashicorp.cdktf.IInterpolatingParent</code> | The parent resource. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoOutputReference.Initializer.parameter.terraformAttribute">terraformAttribute</a></code> | <code>java.lang.String</code> | The attribute on the parent resource this class is referencing. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoOutputReference.Initializer.parameter.complexObjectIndex">complexObjectIndex</a></code> | <code>java.lang.Number</code> | the index of this item in the list. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoOutputReference.Initializer.parameter.complexObjectIsFromSet">complexObjectIsFromSet</a></code> | <code>java.lang.Boolean</code> | whether the list is wrapping a set (will add tolist() to be able to access an item via an index). |

---

##### `terraformResource`<sup>Required</sup> <a name="terraformResource" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoOutputReference.Initializer.parameter.terraformResource"></a>

- *Type:* com.hashicorp.cdktf.IInterpolatingParent

The parent resource.

---

##### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoOutputReference.Initializer.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

The attribute on the parent resource this class is referencing.

---

##### `complexObjectIndex`<sup>Required</sup> <a name="complexObjectIndex" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoOutputReference.Initializer.parameter.complexObjectIndex"></a>

- *Type:* java.lang.Number

the index of this item in the list.

---

##### `complexObjectIsFromSet`<sup>Required</sup> <a name="complexObjectIsFromSet" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoOutputReference.Initializer.parameter.complexObjectIsFromSet"></a>

- *Type:* java.lang.Boolean

whether the list is wrapping a set (will add tolist() to be able to access an item via an index).

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoOutputReference.computeFqn">computeFqn</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoOutputReference.getAnyMapAttribute">getAnyMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoOutputReference.getBooleanAttribute">getBooleanAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoOutputReference.getBooleanMapAttribute">getBooleanMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoOutputReference.getListAttribute">getListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoOutputReference.getNumberAttribute">getNumberAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoOutputReference.getNumberListAttribute">getNumberListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoOutputReference.getNumberMapAttribute">getNumberMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoOutputReference.getStringAttribute">getStringAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoOutputReference.getStringMapAttribute">getStringMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoOutputReference.interpolationForAttribute">interpolationForAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoOutputReference.resolve">resolve</a></code> | Produce the Token's value at resolution time. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoOutputReference.toString">toString</a></code> | Return a string representation of this resolvable object. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoOutputReference.putNetworkFilesystemInfo">putNetworkFilesystemInfo</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoOutputReference.resetRemoteMountDirPath">resetRemoteMountDirPath</a></code> | *No description.* |

---

##### `computeFqn` <a name="computeFqn" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoOutputReference.computeFqn"></a>

```java
public java.lang.String computeFqn()
```

##### `getAnyMapAttribute` <a name="getAnyMapAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoOutputReference.getAnyMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Object> getAnyMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoOutputReference.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getBooleanAttribute` <a name="getBooleanAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoOutputReference.getBooleanAttribute"></a>

```java
public IResolvable getBooleanAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoOutputReference.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getBooleanMapAttribute` <a name="getBooleanMapAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoOutputReference.getBooleanMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Boolean> getBooleanMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoOutputReference.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getListAttribute` <a name="getListAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoOutputReference.getListAttribute"></a>

```java
public java.util.List<java.lang.String> getListAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoOutputReference.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberAttribute` <a name="getNumberAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoOutputReference.getNumberAttribute"></a>

```java
public java.lang.Number getNumberAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoOutputReference.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberListAttribute` <a name="getNumberListAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoOutputReference.getNumberListAttribute"></a>

```java
public java.util.List<java.lang.Number> getNumberListAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoOutputReference.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberMapAttribute` <a name="getNumberMapAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoOutputReference.getNumberMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Number> getNumberMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoOutputReference.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getStringAttribute` <a name="getStringAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoOutputReference.getStringAttribute"></a>

```java
public java.lang.String getStringAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoOutputReference.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getStringMapAttribute` <a name="getStringMapAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoOutputReference.getStringMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.String> getStringMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoOutputReference.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `interpolationForAttribute` <a name="interpolationForAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoOutputReference.interpolationForAttribute"></a>

```java
public IResolvable interpolationForAttribute(java.lang.String property)
```

###### `property`<sup>Required</sup> <a name="property" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoOutputReference.interpolationForAttribute.parameter.property"></a>

- *Type:* java.lang.String

---

##### `resolve` <a name="resolve" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoOutputReference.resolve"></a>

```java
public java.lang.Object resolve(IResolveContext _context)
```

Produce the Token's value at resolution time.

###### `_context`<sup>Required</sup> <a name="_context" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoOutputReference.resolve.parameter._context"></a>

- *Type:* com.hashicorp.cdktf.IResolveContext

---

##### `toString` <a name="toString" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoOutputReference.toString"></a>

```java
public java.lang.String toString()
```

Return a string representation of this resolvable object.

Returns a reversible string representation.

##### `putNetworkFilesystemInfo` <a name="putNetworkFilesystemInfo" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoOutputReference.putNetworkFilesystemInfo"></a>

```java
public void putNetworkFilesystemInfo(JobJobClusterNewClusterClusterMountInfoNetworkFilesystemInfo value)
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoOutputReference.putNetworkFilesystemInfo.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoNetworkFilesystemInfo">JobJobClusterNewClusterClusterMountInfoNetworkFilesystemInfo</a>

---

##### `resetRemoteMountDirPath` <a name="resetRemoteMountDirPath" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoOutputReference.resetRemoteMountDirPath"></a>

```java
public void resetRemoteMountDirPath()
```


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoOutputReference.property.creationStack">creationStack</a></code> | <code>java.util.List<java.lang.String></code> | The creation stack of this resolvable which will be appended to errors thrown during resolution. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoOutputReference.property.fqn">fqn</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoOutputReference.property.networkFilesystemInfo">networkFilesystemInfo</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoNetworkFilesystemInfoOutputReference">JobJobClusterNewClusterClusterMountInfoNetworkFilesystemInfoOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoOutputReference.property.localMountDirPathInput">localMountDirPathInput</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoOutputReference.property.networkFilesystemInfoInput">networkFilesystemInfoInput</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoNetworkFilesystemInfo">JobJobClusterNewClusterClusterMountInfoNetworkFilesystemInfo</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoOutputReference.property.remoteMountDirPathInput">remoteMountDirPathInput</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoOutputReference.property.localMountDirPath">localMountDirPath</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoOutputReference.property.remoteMountDirPath">remoteMountDirPath</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoOutputReference.property.internalValue">internalValue</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfo">JobJobClusterNewClusterClusterMountInfo</a> OR com.hashicorp.cdktf.IResolvable</code> | *No description.* |

---

##### `creationStack`<sup>Required</sup> <a name="creationStack" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoOutputReference.property.creationStack"></a>

```java
public java.util.List<java.lang.String> getCreationStack();
```

- *Type:* java.util.List<java.lang.String>

The creation stack of this resolvable which will be appended to errors thrown during resolution.

If this returns an empty array the stack will not be attached.

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoOutputReference.property.fqn"></a>

```java
public java.lang.String getFqn();
```

- *Type:* java.lang.String

---

##### `networkFilesystemInfo`<sup>Required</sup> <a name="networkFilesystemInfo" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoOutputReference.property.networkFilesystemInfo"></a>

```java
public JobJobClusterNewClusterClusterMountInfoNetworkFilesystemInfoOutputReference getNetworkFilesystemInfo();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoNetworkFilesystemInfoOutputReference">JobJobClusterNewClusterClusterMountInfoNetworkFilesystemInfoOutputReference</a>

---

##### `localMountDirPathInput`<sup>Optional</sup> <a name="localMountDirPathInput" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoOutputReference.property.localMountDirPathInput"></a>

```java
public java.lang.String getLocalMountDirPathInput();
```

- *Type:* java.lang.String

---

##### `networkFilesystemInfoInput`<sup>Optional</sup> <a name="networkFilesystemInfoInput" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoOutputReference.property.networkFilesystemInfoInput"></a>

```java
public JobJobClusterNewClusterClusterMountInfoNetworkFilesystemInfo getNetworkFilesystemInfoInput();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoNetworkFilesystemInfo">JobJobClusterNewClusterClusterMountInfoNetworkFilesystemInfo</a>

---

##### `remoteMountDirPathInput`<sup>Optional</sup> <a name="remoteMountDirPathInput" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoOutputReference.property.remoteMountDirPathInput"></a>

```java
public java.lang.String getRemoteMountDirPathInput();
```

- *Type:* java.lang.String

---

##### `localMountDirPath`<sup>Required</sup> <a name="localMountDirPath" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoOutputReference.property.localMountDirPath"></a>

```java
public java.lang.String getLocalMountDirPath();
```

- *Type:* java.lang.String

---

##### `remoteMountDirPath`<sup>Required</sup> <a name="remoteMountDirPath" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoOutputReference.property.remoteMountDirPath"></a>

```java
public java.lang.String getRemoteMountDirPath();
```

- *Type:* java.lang.String

---

##### `internalValue`<sup>Optional</sup> <a name="internalValue" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoOutputReference.property.internalValue"></a>

```java
public java.lang.Object getInternalValue();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfo">JobJobClusterNewClusterClusterMountInfo</a> OR com.hashicorp.cdktf.IResolvable

---


### JobJobClusterNewClusterDockerImageBasicAuthOutputReference <a name="JobJobClusterNewClusterDockerImageBasicAuthOutputReference" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageBasicAuthOutputReference"></a>

#### Initializers <a name="Initializers" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageBasicAuthOutputReference.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobJobClusterNewClusterDockerImageBasicAuthOutputReference;

new JobJobClusterNewClusterDockerImageBasicAuthOutputReference(IInterpolatingParent terraformResource, java.lang.String terraformAttribute);
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageBasicAuthOutputReference.Initializer.parameter.terraformResource">terraformResource</a></code> | <code>com.hashicorp.cdktf.IInterpolatingParent</code> | The parent resource. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageBasicAuthOutputReference.Initializer.parameter.terraformAttribute">terraformAttribute</a></code> | <code>java.lang.String</code> | The attribute on the parent resource this class is referencing. |

---

##### `terraformResource`<sup>Required</sup> <a name="terraformResource" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageBasicAuthOutputReference.Initializer.parameter.terraformResource"></a>

- *Type:* com.hashicorp.cdktf.IInterpolatingParent

The parent resource.

---

##### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageBasicAuthOutputReference.Initializer.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

The attribute on the parent resource this class is referencing.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageBasicAuthOutputReference.computeFqn">computeFqn</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageBasicAuthOutputReference.getAnyMapAttribute">getAnyMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageBasicAuthOutputReference.getBooleanAttribute">getBooleanAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageBasicAuthOutputReference.getBooleanMapAttribute">getBooleanMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageBasicAuthOutputReference.getListAttribute">getListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageBasicAuthOutputReference.getNumberAttribute">getNumberAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageBasicAuthOutputReference.getNumberListAttribute">getNumberListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageBasicAuthOutputReference.getNumberMapAttribute">getNumberMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageBasicAuthOutputReference.getStringAttribute">getStringAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageBasicAuthOutputReference.getStringMapAttribute">getStringMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageBasicAuthOutputReference.interpolationForAttribute">interpolationForAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageBasicAuthOutputReference.resolve">resolve</a></code> | Produce the Token's value at resolution time. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageBasicAuthOutputReference.toString">toString</a></code> | Return a string representation of this resolvable object. |

---

##### `computeFqn` <a name="computeFqn" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageBasicAuthOutputReference.computeFqn"></a>

```java
public java.lang.String computeFqn()
```

##### `getAnyMapAttribute` <a name="getAnyMapAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageBasicAuthOutputReference.getAnyMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Object> getAnyMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageBasicAuthOutputReference.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getBooleanAttribute` <a name="getBooleanAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageBasicAuthOutputReference.getBooleanAttribute"></a>

```java
public IResolvable getBooleanAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageBasicAuthOutputReference.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getBooleanMapAttribute` <a name="getBooleanMapAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageBasicAuthOutputReference.getBooleanMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Boolean> getBooleanMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageBasicAuthOutputReference.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getListAttribute` <a name="getListAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageBasicAuthOutputReference.getListAttribute"></a>

```java
public java.util.List<java.lang.String> getListAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageBasicAuthOutputReference.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberAttribute` <a name="getNumberAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageBasicAuthOutputReference.getNumberAttribute"></a>

```java
public java.lang.Number getNumberAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageBasicAuthOutputReference.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberListAttribute` <a name="getNumberListAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageBasicAuthOutputReference.getNumberListAttribute"></a>

```java
public java.util.List<java.lang.Number> getNumberListAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageBasicAuthOutputReference.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberMapAttribute` <a name="getNumberMapAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageBasicAuthOutputReference.getNumberMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Number> getNumberMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageBasicAuthOutputReference.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getStringAttribute` <a name="getStringAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageBasicAuthOutputReference.getStringAttribute"></a>

```java
public java.lang.String getStringAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageBasicAuthOutputReference.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getStringMapAttribute` <a name="getStringMapAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageBasicAuthOutputReference.getStringMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.String> getStringMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageBasicAuthOutputReference.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `interpolationForAttribute` <a name="interpolationForAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageBasicAuthOutputReference.interpolationForAttribute"></a>

```java
public IResolvable interpolationForAttribute(java.lang.String property)
```

###### `property`<sup>Required</sup> <a name="property" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageBasicAuthOutputReference.interpolationForAttribute.parameter.property"></a>

- *Type:* java.lang.String

---

##### `resolve` <a name="resolve" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageBasicAuthOutputReference.resolve"></a>

```java
public java.lang.Object resolve(IResolveContext _context)
```

Produce the Token's value at resolution time.

###### `_context`<sup>Required</sup> <a name="_context" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageBasicAuthOutputReference.resolve.parameter._context"></a>

- *Type:* com.hashicorp.cdktf.IResolveContext

---

##### `toString` <a name="toString" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageBasicAuthOutputReference.toString"></a>

```java
public java.lang.String toString()
```

Return a string representation of this resolvable object.

Returns a reversible string representation.


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageBasicAuthOutputReference.property.creationStack">creationStack</a></code> | <code>java.util.List<java.lang.String></code> | The creation stack of this resolvable which will be appended to errors thrown during resolution. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageBasicAuthOutputReference.property.fqn">fqn</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageBasicAuthOutputReference.property.passwordInput">passwordInput</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageBasicAuthOutputReference.property.usernameInput">usernameInput</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageBasicAuthOutputReference.property.password">password</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageBasicAuthOutputReference.property.username">username</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageBasicAuthOutputReference.property.internalValue">internalValue</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageBasicAuth">JobJobClusterNewClusterDockerImageBasicAuth</a></code> | *No description.* |

---

##### `creationStack`<sup>Required</sup> <a name="creationStack" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageBasicAuthOutputReference.property.creationStack"></a>

```java
public java.util.List<java.lang.String> getCreationStack();
```

- *Type:* java.util.List<java.lang.String>

The creation stack of this resolvable which will be appended to errors thrown during resolution.

If this returns an empty array the stack will not be attached.

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageBasicAuthOutputReference.property.fqn"></a>

```java
public java.lang.String getFqn();
```

- *Type:* java.lang.String

---

##### `passwordInput`<sup>Optional</sup> <a name="passwordInput" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageBasicAuthOutputReference.property.passwordInput"></a>

```java
public java.lang.String getPasswordInput();
```

- *Type:* java.lang.String

---

##### `usernameInput`<sup>Optional</sup> <a name="usernameInput" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageBasicAuthOutputReference.property.usernameInput"></a>

```java
public java.lang.String getUsernameInput();
```

- *Type:* java.lang.String

---

##### `password`<sup>Required</sup> <a name="password" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageBasicAuthOutputReference.property.password"></a>

```java
public java.lang.String getPassword();
```

- *Type:* java.lang.String

---

##### `username`<sup>Required</sup> <a name="username" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageBasicAuthOutputReference.property.username"></a>

```java
public java.lang.String getUsername();
```

- *Type:* java.lang.String

---

##### `internalValue`<sup>Optional</sup> <a name="internalValue" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageBasicAuthOutputReference.property.internalValue"></a>

```java
public JobJobClusterNewClusterDockerImageBasicAuth getInternalValue();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageBasicAuth">JobJobClusterNewClusterDockerImageBasicAuth</a>

---


### JobJobClusterNewClusterDockerImageOutputReference <a name="JobJobClusterNewClusterDockerImageOutputReference" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageOutputReference"></a>

#### Initializers <a name="Initializers" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageOutputReference.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobJobClusterNewClusterDockerImageOutputReference;

new JobJobClusterNewClusterDockerImageOutputReference(IInterpolatingParent terraformResource, java.lang.String terraformAttribute);
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageOutputReference.Initializer.parameter.terraformResource">terraformResource</a></code> | <code>com.hashicorp.cdktf.IInterpolatingParent</code> | The parent resource. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageOutputReference.Initializer.parameter.terraformAttribute">terraformAttribute</a></code> | <code>java.lang.String</code> | The attribute on the parent resource this class is referencing. |

---

##### `terraformResource`<sup>Required</sup> <a name="terraformResource" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageOutputReference.Initializer.parameter.terraformResource"></a>

- *Type:* com.hashicorp.cdktf.IInterpolatingParent

The parent resource.

---

##### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageOutputReference.Initializer.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

The attribute on the parent resource this class is referencing.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageOutputReference.computeFqn">computeFqn</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageOutputReference.getAnyMapAttribute">getAnyMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageOutputReference.getBooleanAttribute">getBooleanAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageOutputReference.getBooleanMapAttribute">getBooleanMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageOutputReference.getListAttribute">getListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageOutputReference.getNumberAttribute">getNumberAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageOutputReference.getNumberListAttribute">getNumberListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageOutputReference.getNumberMapAttribute">getNumberMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageOutputReference.getStringAttribute">getStringAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageOutputReference.getStringMapAttribute">getStringMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageOutputReference.interpolationForAttribute">interpolationForAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageOutputReference.resolve">resolve</a></code> | Produce the Token's value at resolution time. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageOutputReference.toString">toString</a></code> | Return a string representation of this resolvable object. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageOutputReference.putBasicAuth">putBasicAuth</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageOutputReference.resetBasicAuth">resetBasicAuth</a></code> | *No description.* |

---

##### `computeFqn` <a name="computeFqn" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageOutputReference.computeFqn"></a>

```java
public java.lang.String computeFqn()
```

##### `getAnyMapAttribute` <a name="getAnyMapAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageOutputReference.getAnyMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Object> getAnyMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageOutputReference.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getBooleanAttribute` <a name="getBooleanAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageOutputReference.getBooleanAttribute"></a>

```java
public IResolvable getBooleanAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageOutputReference.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getBooleanMapAttribute` <a name="getBooleanMapAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageOutputReference.getBooleanMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Boolean> getBooleanMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageOutputReference.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getListAttribute` <a name="getListAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageOutputReference.getListAttribute"></a>

```java
public java.util.List<java.lang.String> getListAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageOutputReference.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberAttribute` <a name="getNumberAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageOutputReference.getNumberAttribute"></a>

```java
public java.lang.Number getNumberAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageOutputReference.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberListAttribute` <a name="getNumberListAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageOutputReference.getNumberListAttribute"></a>

```java
public java.util.List<java.lang.Number> getNumberListAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageOutputReference.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberMapAttribute` <a name="getNumberMapAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageOutputReference.getNumberMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Number> getNumberMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageOutputReference.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getStringAttribute` <a name="getStringAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageOutputReference.getStringAttribute"></a>

```java
public java.lang.String getStringAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageOutputReference.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getStringMapAttribute` <a name="getStringMapAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageOutputReference.getStringMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.String> getStringMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageOutputReference.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `interpolationForAttribute` <a name="interpolationForAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageOutputReference.interpolationForAttribute"></a>

```java
public IResolvable interpolationForAttribute(java.lang.String property)
```

###### `property`<sup>Required</sup> <a name="property" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageOutputReference.interpolationForAttribute.parameter.property"></a>

- *Type:* java.lang.String

---

##### `resolve` <a name="resolve" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageOutputReference.resolve"></a>

```java
public java.lang.Object resolve(IResolveContext _context)
```

Produce the Token's value at resolution time.

###### `_context`<sup>Required</sup> <a name="_context" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageOutputReference.resolve.parameter._context"></a>

- *Type:* com.hashicorp.cdktf.IResolveContext

---

##### `toString` <a name="toString" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageOutputReference.toString"></a>

```java
public java.lang.String toString()
```

Return a string representation of this resolvable object.

Returns a reversible string representation.

##### `putBasicAuth` <a name="putBasicAuth" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageOutputReference.putBasicAuth"></a>

```java
public void putBasicAuth(JobJobClusterNewClusterDockerImageBasicAuth value)
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageOutputReference.putBasicAuth.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageBasicAuth">JobJobClusterNewClusterDockerImageBasicAuth</a>

---

##### `resetBasicAuth` <a name="resetBasicAuth" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageOutputReference.resetBasicAuth"></a>

```java
public void resetBasicAuth()
```


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageOutputReference.property.creationStack">creationStack</a></code> | <code>java.util.List<java.lang.String></code> | The creation stack of this resolvable which will be appended to errors thrown during resolution. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageOutputReference.property.fqn">fqn</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageOutputReference.property.basicAuth">basicAuth</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageBasicAuthOutputReference">JobJobClusterNewClusterDockerImageBasicAuthOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageOutputReference.property.basicAuthInput">basicAuthInput</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageBasicAuth">JobJobClusterNewClusterDockerImageBasicAuth</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageOutputReference.property.urlInput">urlInput</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageOutputReference.property.url">url</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageOutputReference.property.internalValue">internalValue</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImage">JobJobClusterNewClusterDockerImage</a></code> | *No description.* |

---

##### `creationStack`<sup>Required</sup> <a name="creationStack" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageOutputReference.property.creationStack"></a>

```java
public java.util.List<java.lang.String> getCreationStack();
```

- *Type:* java.util.List<java.lang.String>

The creation stack of this resolvable which will be appended to errors thrown during resolution.

If this returns an empty array the stack will not be attached.

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageOutputReference.property.fqn"></a>

```java
public java.lang.String getFqn();
```

- *Type:* java.lang.String

---

##### `basicAuth`<sup>Required</sup> <a name="basicAuth" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageOutputReference.property.basicAuth"></a>

```java
public JobJobClusterNewClusterDockerImageBasicAuthOutputReference getBasicAuth();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageBasicAuthOutputReference">JobJobClusterNewClusterDockerImageBasicAuthOutputReference</a>

---

##### `basicAuthInput`<sup>Optional</sup> <a name="basicAuthInput" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageOutputReference.property.basicAuthInput"></a>

```java
public JobJobClusterNewClusterDockerImageBasicAuth getBasicAuthInput();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageBasicAuth">JobJobClusterNewClusterDockerImageBasicAuth</a>

---

##### `urlInput`<sup>Optional</sup> <a name="urlInput" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageOutputReference.property.urlInput"></a>

```java
public java.lang.String getUrlInput();
```

- *Type:* java.lang.String

---

##### `url`<sup>Required</sup> <a name="url" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageOutputReference.property.url"></a>

```java
public java.lang.String getUrl();
```

- *Type:* java.lang.String

---

##### `internalValue`<sup>Optional</sup> <a name="internalValue" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageOutputReference.property.internalValue"></a>

```java
public JobJobClusterNewClusterDockerImage getInternalValue();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImage">JobJobClusterNewClusterDockerImage</a>

---


### JobJobClusterNewClusterGcpAttributesOutputReference <a name="JobJobClusterNewClusterGcpAttributesOutputReference" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterGcpAttributesOutputReference"></a>

#### Initializers <a name="Initializers" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterGcpAttributesOutputReference.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobJobClusterNewClusterGcpAttributesOutputReference;

new JobJobClusterNewClusterGcpAttributesOutputReference(IInterpolatingParent terraformResource, java.lang.String terraformAttribute);
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterGcpAttributesOutputReference.Initializer.parameter.terraformResource">terraformResource</a></code> | <code>com.hashicorp.cdktf.IInterpolatingParent</code> | The parent resource. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterGcpAttributesOutputReference.Initializer.parameter.terraformAttribute">terraformAttribute</a></code> | <code>java.lang.String</code> | The attribute on the parent resource this class is referencing. |

---

##### `terraformResource`<sup>Required</sup> <a name="terraformResource" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterGcpAttributesOutputReference.Initializer.parameter.terraformResource"></a>

- *Type:* com.hashicorp.cdktf.IInterpolatingParent

The parent resource.

---

##### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterGcpAttributesOutputReference.Initializer.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

The attribute on the parent resource this class is referencing.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterGcpAttributesOutputReference.computeFqn">computeFqn</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterGcpAttributesOutputReference.getAnyMapAttribute">getAnyMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterGcpAttributesOutputReference.getBooleanAttribute">getBooleanAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterGcpAttributesOutputReference.getBooleanMapAttribute">getBooleanMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterGcpAttributesOutputReference.getListAttribute">getListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterGcpAttributesOutputReference.getNumberAttribute">getNumberAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterGcpAttributesOutputReference.getNumberListAttribute">getNumberListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterGcpAttributesOutputReference.getNumberMapAttribute">getNumberMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterGcpAttributesOutputReference.getStringAttribute">getStringAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterGcpAttributesOutputReference.getStringMapAttribute">getStringMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterGcpAttributesOutputReference.interpolationForAttribute">interpolationForAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterGcpAttributesOutputReference.resolve">resolve</a></code> | Produce the Token's value at resolution time. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterGcpAttributesOutputReference.toString">toString</a></code> | Return a string representation of this resolvable object. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterGcpAttributesOutputReference.resetAvailability">resetAvailability</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterGcpAttributesOutputReference.resetBootDiskSize">resetBootDiskSize</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterGcpAttributesOutputReference.resetGoogleServiceAccount">resetGoogleServiceAccount</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterGcpAttributesOutputReference.resetUsePreemptibleExecutors">resetUsePreemptibleExecutors</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterGcpAttributesOutputReference.resetZoneId">resetZoneId</a></code> | *No description.* |

---

##### `computeFqn` <a name="computeFqn" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterGcpAttributesOutputReference.computeFqn"></a>

```java
public java.lang.String computeFqn()
```

##### `getAnyMapAttribute` <a name="getAnyMapAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterGcpAttributesOutputReference.getAnyMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Object> getAnyMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterGcpAttributesOutputReference.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getBooleanAttribute` <a name="getBooleanAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterGcpAttributesOutputReference.getBooleanAttribute"></a>

```java
public IResolvable getBooleanAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterGcpAttributesOutputReference.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getBooleanMapAttribute` <a name="getBooleanMapAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterGcpAttributesOutputReference.getBooleanMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Boolean> getBooleanMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterGcpAttributesOutputReference.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getListAttribute` <a name="getListAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterGcpAttributesOutputReference.getListAttribute"></a>

```java
public java.util.List<java.lang.String> getListAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterGcpAttributesOutputReference.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberAttribute` <a name="getNumberAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterGcpAttributesOutputReference.getNumberAttribute"></a>

```java
public java.lang.Number getNumberAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterGcpAttributesOutputReference.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberListAttribute` <a name="getNumberListAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterGcpAttributesOutputReference.getNumberListAttribute"></a>

```java
public java.util.List<java.lang.Number> getNumberListAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterGcpAttributesOutputReference.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberMapAttribute` <a name="getNumberMapAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterGcpAttributesOutputReference.getNumberMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Number> getNumberMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterGcpAttributesOutputReference.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getStringAttribute` <a name="getStringAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterGcpAttributesOutputReference.getStringAttribute"></a>

```java
public java.lang.String getStringAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterGcpAttributesOutputReference.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getStringMapAttribute` <a name="getStringMapAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterGcpAttributesOutputReference.getStringMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.String> getStringMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterGcpAttributesOutputReference.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `interpolationForAttribute` <a name="interpolationForAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterGcpAttributesOutputReference.interpolationForAttribute"></a>

```java
public IResolvable interpolationForAttribute(java.lang.String property)
```

###### `property`<sup>Required</sup> <a name="property" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterGcpAttributesOutputReference.interpolationForAttribute.parameter.property"></a>

- *Type:* java.lang.String

---

##### `resolve` <a name="resolve" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterGcpAttributesOutputReference.resolve"></a>

```java
public java.lang.Object resolve(IResolveContext _context)
```

Produce the Token's value at resolution time.

###### `_context`<sup>Required</sup> <a name="_context" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterGcpAttributesOutputReference.resolve.parameter._context"></a>

- *Type:* com.hashicorp.cdktf.IResolveContext

---

##### `toString` <a name="toString" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterGcpAttributesOutputReference.toString"></a>

```java
public java.lang.String toString()
```

Return a string representation of this resolvable object.

Returns a reversible string representation.

##### `resetAvailability` <a name="resetAvailability" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterGcpAttributesOutputReference.resetAvailability"></a>

```java
public void resetAvailability()
```

##### `resetBootDiskSize` <a name="resetBootDiskSize" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterGcpAttributesOutputReference.resetBootDiskSize"></a>

```java
public void resetBootDiskSize()
```

##### `resetGoogleServiceAccount` <a name="resetGoogleServiceAccount" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterGcpAttributesOutputReference.resetGoogleServiceAccount"></a>

```java
public void resetGoogleServiceAccount()
```

##### `resetUsePreemptibleExecutors` <a name="resetUsePreemptibleExecutors" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterGcpAttributesOutputReference.resetUsePreemptibleExecutors"></a>

```java
public void resetUsePreemptibleExecutors()
```

##### `resetZoneId` <a name="resetZoneId" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterGcpAttributesOutputReference.resetZoneId"></a>

```java
public void resetZoneId()
```


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterGcpAttributesOutputReference.property.creationStack">creationStack</a></code> | <code>java.util.List<java.lang.String></code> | The creation stack of this resolvable which will be appended to errors thrown during resolution. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterGcpAttributesOutputReference.property.fqn">fqn</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterGcpAttributesOutputReference.property.availabilityInput">availabilityInput</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterGcpAttributesOutputReference.property.bootDiskSizeInput">bootDiskSizeInput</a></code> | <code>java.lang.Number</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterGcpAttributesOutputReference.property.googleServiceAccountInput">googleServiceAccountInput</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterGcpAttributesOutputReference.property.usePreemptibleExecutorsInput">usePreemptibleExecutorsInput</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterGcpAttributesOutputReference.property.zoneIdInput">zoneIdInput</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterGcpAttributesOutputReference.property.availability">availability</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterGcpAttributesOutputReference.property.bootDiskSize">bootDiskSize</a></code> | <code>java.lang.Number</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterGcpAttributesOutputReference.property.googleServiceAccount">googleServiceAccount</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterGcpAttributesOutputReference.property.usePreemptibleExecutors">usePreemptibleExecutors</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterGcpAttributesOutputReference.property.zoneId">zoneId</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterGcpAttributesOutputReference.property.internalValue">internalValue</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterGcpAttributes">JobJobClusterNewClusterGcpAttributes</a></code> | *No description.* |

---

##### `creationStack`<sup>Required</sup> <a name="creationStack" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterGcpAttributesOutputReference.property.creationStack"></a>

```java
public java.util.List<java.lang.String> getCreationStack();
```

- *Type:* java.util.List<java.lang.String>

The creation stack of this resolvable which will be appended to errors thrown during resolution.

If this returns an empty array the stack will not be attached.

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterGcpAttributesOutputReference.property.fqn"></a>

```java
public java.lang.String getFqn();
```

- *Type:* java.lang.String

---

##### `availabilityInput`<sup>Optional</sup> <a name="availabilityInput" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterGcpAttributesOutputReference.property.availabilityInput"></a>

```java
public java.lang.String getAvailabilityInput();
```

- *Type:* java.lang.String

---

##### `bootDiskSizeInput`<sup>Optional</sup> <a name="bootDiskSizeInput" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterGcpAttributesOutputReference.property.bootDiskSizeInput"></a>

```java
public java.lang.Number getBootDiskSizeInput();
```

- *Type:* java.lang.Number

---

##### `googleServiceAccountInput`<sup>Optional</sup> <a name="googleServiceAccountInput" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterGcpAttributesOutputReference.property.googleServiceAccountInput"></a>

```java
public java.lang.String getGoogleServiceAccountInput();
```

- *Type:* java.lang.String

---

##### `usePreemptibleExecutorsInput`<sup>Optional</sup> <a name="usePreemptibleExecutorsInput" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterGcpAttributesOutputReference.property.usePreemptibleExecutorsInput"></a>

```java
public java.lang.Object getUsePreemptibleExecutorsInput();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

---

##### `zoneIdInput`<sup>Optional</sup> <a name="zoneIdInput" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterGcpAttributesOutputReference.property.zoneIdInput"></a>

```java
public java.lang.String getZoneIdInput();
```

- *Type:* java.lang.String

---

##### `availability`<sup>Required</sup> <a name="availability" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterGcpAttributesOutputReference.property.availability"></a>

```java
public java.lang.String getAvailability();
```

- *Type:* java.lang.String

---

##### `bootDiskSize`<sup>Required</sup> <a name="bootDiskSize" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterGcpAttributesOutputReference.property.bootDiskSize"></a>

```java
public java.lang.Number getBootDiskSize();
```

- *Type:* java.lang.Number

---

##### `googleServiceAccount`<sup>Required</sup> <a name="googleServiceAccount" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterGcpAttributesOutputReference.property.googleServiceAccount"></a>

```java
public java.lang.String getGoogleServiceAccount();
```

- *Type:* java.lang.String

---

##### `usePreemptibleExecutors`<sup>Required</sup> <a name="usePreemptibleExecutors" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterGcpAttributesOutputReference.property.usePreemptibleExecutors"></a>

```java
public java.lang.Object getUsePreemptibleExecutors();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

---

##### `zoneId`<sup>Required</sup> <a name="zoneId" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterGcpAttributesOutputReference.property.zoneId"></a>

```java
public java.lang.String getZoneId();
```

- *Type:* java.lang.String

---

##### `internalValue`<sup>Optional</sup> <a name="internalValue" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterGcpAttributesOutputReference.property.internalValue"></a>

```java
public JobJobClusterNewClusterGcpAttributes getInternalValue();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterGcpAttributes">JobJobClusterNewClusterGcpAttributes</a>

---


### JobJobClusterNewClusterInitScriptsAbfssOutputReference <a name="JobJobClusterNewClusterInitScriptsAbfssOutputReference" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsAbfssOutputReference"></a>

#### Initializers <a name="Initializers" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsAbfssOutputReference.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobJobClusterNewClusterInitScriptsAbfssOutputReference;

new JobJobClusterNewClusterInitScriptsAbfssOutputReference(IInterpolatingParent terraformResource, java.lang.String terraformAttribute);
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsAbfssOutputReference.Initializer.parameter.terraformResource">terraformResource</a></code> | <code>com.hashicorp.cdktf.IInterpolatingParent</code> | The parent resource. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsAbfssOutputReference.Initializer.parameter.terraformAttribute">terraformAttribute</a></code> | <code>java.lang.String</code> | The attribute on the parent resource this class is referencing. |

---

##### `terraformResource`<sup>Required</sup> <a name="terraformResource" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsAbfssOutputReference.Initializer.parameter.terraformResource"></a>

- *Type:* com.hashicorp.cdktf.IInterpolatingParent

The parent resource.

---

##### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsAbfssOutputReference.Initializer.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

The attribute on the parent resource this class is referencing.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsAbfssOutputReference.computeFqn">computeFqn</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsAbfssOutputReference.getAnyMapAttribute">getAnyMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsAbfssOutputReference.getBooleanAttribute">getBooleanAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsAbfssOutputReference.getBooleanMapAttribute">getBooleanMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsAbfssOutputReference.getListAttribute">getListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsAbfssOutputReference.getNumberAttribute">getNumberAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsAbfssOutputReference.getNumberListAttribute">getNumberListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsAbfssOutputReference.getNumberMapAttribute">getNumberMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsAbfssOutputReference.getStringAttribute">getStringAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsAbfssOutputReference.getStringMapAttribute">getStringMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsAbfssOutputReference.interpolationForAttribute">interpolationForAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsAbfssOutputReference.resolve">resolve</a></code> | Produce the Token's value at resolution time. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsAbfssOutputReference.toString">toString</a></code> | Return a string representation of this resolvable object. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsAbfssOutputReference.resetDestination">resetDestination</a></code> | *No description.* |

---

##### `computeFqn` <a name="computeFqn" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsAbfssOutputReference.computeFqn"></a>

```java
public java.lang.String computeFqn()
```

##### `getAnyMapAttribute` <a name="getAnyMapAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsAbfssOutputReference.getAnyMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Object> getAnyMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsAbfssOutputReference.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getBooleanAttribute` <a name="getBooleanAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsAbfssOutputReference.getBooleanAttribute"></a>

```java
public IResolvable getBooleanAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsAbfssOutputReference.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getBooleanMapAttribute` <a name="getBooleanMapAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsAbfssOutputReference.getBooleanMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Boolean> getBooleanMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsAbfssOutputReference.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getListAttribute` <a name="getListAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsAbfssOutputReference.getListAttribute"></a>

```java
public java.util.List<java.lang.String> getListAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsAbfssOutputReference.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberAttribute` <a name="getNumberAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsAbfssOutputReference.getNumberAttribute"></a>

```java
public java.lang.Number getNumberAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsAbfssOutputReference.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberListAttribute` <a name="getNumberListAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsAbfssOutputReference.getNumberListAttribute"></a>

```java
public java.util.List<java.lang.Number> getNumberListAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsAbfssOutputReference.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberMapAttribute` <a name="getNumberMapAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsAbfssOutputReference.getNumberMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Number> getNumberMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsAbfssOutputReference.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getStringAttribute` <a name="getStringAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsAbfssOutputReference.getStringAttribute"></a>

```java
public java.lang.String getStringAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsAbfssOutputReference.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getStringMapAttribute` <a name="getStringMapAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsAbfssOutputReference.getStringMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.String> getStringMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsAbfssOutputReference.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `interpolationForAttribute` <a name="interpolationForAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsAbfssOutputReference.interpolationForAttribute"></a>

```java
public IResolvable interpolationForAttribute(java.lang.String property)
```

###### `property`<sup>Required</sup> <a name="property" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsAbfssOutputReference.interpolationForAttribute.parameter.property"></a>

- *Type:* java.lang.String

---

##### `resolve` <a name="resolve" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsAbfssOutputReference.resolve"></a>

```java
public java.lang.Object resolve(IResolveContext _context)
```

Produce the Token's value at resolution time.

###### `_context`<sup>Required</sup> <a name="_context" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsAbfssOutputReference.resolve.parameter._context"></a>

- *Type:* com.hashicorp.cdktf.IResolveContext

---

##### `toString` <a name="toString" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsAbfssOutputReference.toString"></a>

```java
public java.lang.String toString()
```

Return a string representation of this resolvable object.

Returns a reversible string representation.

##### `resetDestination` <a name="resetDestination" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsAbfssOutputReference.resetDestination"></a>

```java
public void resetDestination()
```


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsAbfssOutputReference.property.creationStack">creationStack</a></code> | <code>java.util.List<java.lang.String></code> | The creation stack of this resolvable which will be appended to errors thrown during resolution. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsAbfssOutputReference.property.fqn">fqn</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsAbfssOutputReference.property.destinationInput">destinationInput</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsAbfssOutputReference.property.destination">destination</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsAbfssOutputReference.property.internalValue">internalValue</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsAbfss">JobJobClusterNewClusterInitScriptsAbfss</a></code> | *No description.* |

---

##### `creationStack`<sup>Required</sup> <a name="creationStack" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsAbfssOutputReference.property.creationStack"></a>

```java
public java.util.List<java.lang.String> getCreationStack();
```

- *Type:* java.util.List<java.lang.String>

The creation stack of this resolvable which will be appended to errors thrown during resolution.

If this returns an empty array the stack will not be attached.

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsAbfssOutputReference.property.fqn"></a>

```java
public java.lang.String getFqn();
```

- *Type:* java.lang.String

---

##### `destinationInput`<sup>Optional</sup> <a name="destinationInput" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsAbfssOutputReference.property.destinationInput"></a>

```java
public java.lang.String getDestinationInput();
```

- *Type:* java.lang.String

---

##### `destination`<sup>Required</sup> <a name="destination" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsAbfssOutputReference.property.destination"></a>

```java
public java.lang.String getDestination();
```

- *Type:* java.lang.String

---

##### `internalValue`<sup>Optional</sup> <a name="internalValue" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsAbfssOutputReference.property.internalValue"></a>

```java
public JobJobClusterNewClusterInitScriptsAbfss getInternalValue();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsAbfss">JobJobClusterNewClusterInitScriptsAbfss</a>

---


### JobJobClusterNewClusterInitScriptsDbfsOutputReference <a name="JobJobClusterNewClusterInitScriptsDbfsOutputReference" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsDbfsOutputReference"></a>

#### Initializers <a name="Initializers" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsDbfsOutputReference.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobJobClusterNewClusterInitScriptsDbfsOutputReference;

new JobJobClusterNewClusterInitScriptsDbfsOutputReference(IInterpolatingParent terraformResource, java.lang.String terraformAttribute);
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsDbfsOutputReference.Initializer.parameter.terraformResource">terraformResource</a></code> | <code>com.hashicorp.cdktf.IInterpolatingParent</code> | The parent resource. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsDbfsOutputReference.Initializer.parameter.terraformAttribute">terraformAttribute</a></code> | <code>java.lang.String</code> | The attribute on the parent resource this class is referencing. |

---

##### `terraformResource`<sup>Required</sup> <a name="terraformResource" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsDbfsOutputReference.Initializer.parameter.terraformResource"></a>

- *Type:* com.hashicorp.cdktf.IInterpolatingParent

The parent resource.

---

##### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsDbfsOutputReference.Initializer.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

The attribute on the parent resource this class is referencing.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsDbfsOutputReference.computeFqn">computeFqn</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsDbfsOutputReference.getAnyMapAttribute">getAnyMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsDbfsOutputReference.getBooleanAttribute">getBooleanAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsDbfsOutputReference.getBooleanMapAttribute">getBooleanMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsDbfsOutputReference.getListAttribute">getListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsDbfsOutputReference.getNumberAttribute">getNumberAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsDbfsOutputReference.getNumberListAttribute">getNumberListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsDbfsOutputReference.getNumberMapAttribute">getNumberMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsDbfsOutputReference.getStringAttribute">getStringAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsDbfsOutputReference.getStringMapAttribute">getStringMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsDbfsOutputReference.interpolationForAttribute">interpolationForAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsDbfsOutputReference.resolve">resolve</a></code> | Produce the Token's value at resolution time. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsDbfsOutputReference.toString">toString</a></code> | Return a string representation of this resolvable object. |

---

##### `computeFqn` <a name="computeFqn" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsDbfsOutputReference.computeFqn"></a>

```java
public java.lang.String computeFqn()
```

##### `getAnyMapAttribute` <a name="getAnyMapAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsDbfsOutputReference.getAnyMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Object> getAnyMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsDbfsOutputReference.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getBooleanAttribute` <a name="getBooleanAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsDbfsOutputReference.getBooleanAttribute"></a>

```java
public IResolvable getBooleanAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsDbfsOutputReference.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getBooleanMapAttribute` <a name="getBooleanMapAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsDbfsOutputReference.getBooleanMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Boolean> getBooleanMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsDbfsOutputReference.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getListAttribute` <a name="getListAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsDbfsOutputReference.getListAttribute"></a>

```java
public java.util.List<java.lang.String> getListAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsDbfsOutputReference.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberAttribute` <a name="getNumberAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsDbfsOutputReference.getNumberAttribute"></a>

```java
public java.lang.Number getNumberAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsDbfsOutputReference.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberListAttribute` <a name="getNumberListAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsDbfsOutputReference.getNumberListAttribute"></a>

```java
public java.util.List<java.lang.Number> getNumberListAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsDbfsOutputReference.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberMapAttribute` <a name="getNumberMapAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsDbfsOutputReference.getNumberMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Number> getNumberMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsDbfsOutputReference.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getStringAttribute` <a name="getStringAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsDbfsOutputReference.getStringAttribute"></a>

```java
public java.lang.String getStringAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsDbfsOutputReference.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getStringMapAttribute` <a name="getStringMapAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsDbfsOutputReference.getStringMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.String> getStringMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsDbfsOutputReference.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `interpolationForAttribute` <a name="interpolationForAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsDbfsOutputReference.interpolationForAttribute"></a>

```java
public IResolvable interpolationForAttribute(java.lang.String property)
```

###### `property`<sup>Required</sup> <a name="property" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsDbfsOutputReference.interpolationForAttribute.parameter.property"></a>

- *Type:* java.lang.String

---

##### `resolve` <a name="resolve" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsDbfsOutputReference.resolve"></a>

```java
public java.lang.Object resolve(IResolveContext _context)
```

Produce the Token's value at resolution time.

###### `_context`<sup>Required</sup> <a name="_context" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsDbfsOutputReference.resolve.parameter._context"></a>

- *Type:* com.hashicorp.cdktf.IResolveContext

---

##### `toString` <a name="toString" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsDbfsOutputReference.toString"></a>

```java
public java.lang.String toString()
```

Return a string representation of this resolvable object.

Returns a reversible string representation.


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsDbfsOutputReference.property.creationStack">creationStack</a></code> | <code>java.util.List<java.lang.String></code> | The creation stack of this resolvable which will be appended to errors thrown during resolution. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsDbfsOutputReference.property.fqn">fqn</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsDbfsOutputReference.property.destinationInput">destinationInput</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsDbfsOutputReference.property.destination">destination</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsDbfsOutputReference.property.internalValue">internalValue</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsDbfs">JobJobClusterNewClusterInitScriptsDbfs</a></code> | *No description.* |

---

##### `creationStack`<sup>Required</sup> <a name="creationStack" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsDbfsOutputReference.property.creationStack"></a>

```java
public java.util.List<java.lang.String> getCreationStack();
```

- *Type:* java.util.List<java.lang.String>

The creation stack of this resolvable which will be appended to errors thrown during resolution.

If this returns an empty array the stack will not be attached.

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsDbfsOutputReference.property.fqn"></a>

```java
public java.lang.String getFqn();
```

- *Type:* java.lang.String

---

##### `destinationInput`<sup>Optional</sup> <a name="destinationInput" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsDbfsOutputReference.property.destinationInput"></a>

```java
public java.lang.String getDestinationInput();
```

- *Type:* java.lang.String

---

##### `destination`<sup>Required</sup> <a name="destination" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsDbfsOutputReference.property.destination"></a>

```java
public java.lang.String getDestination();
```

- *Type:* java.lang.String

---

##### `internalValue`<sup>Optional</sup> <a name="internalValue" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsDbfsOutputReference.property.internalValue"></a>

```java
public JobJobClusterNewClusterInitScriptsDbfs getInternalValue();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsDbfs">JobJobClusterNewClusterInitScriptsDbfs</a>

---


### JobJobClusterNewClusterInitScriptsFileOutputReference <a name="JobJobClusterNewClusterInitScriptsFileOutputReference" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsFileOutputReference"></a>

#### Initializers <a name="Initializers" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsFileOutputReference.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobJobClusterNewClusterInitScriptsFileOutputReference;

new JobJobClusterNewClusterInitScriptsFileOutputReference(IInterpolatingParent terraformResource, java.lang.String terraformAttribute);
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsFileOutputReference.Initializer.parameter.terraformResource">terraformResource</a></code> | <code>com.hashicorp.cdktf.IInterpolatingParent</code> | The parent resource. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsFileOutputReference.Initializer.parameter.terraformAttribute">terraformAttribute</a></code> | <code>java.lang.String</code> | The attribute on the parent resource this class is referencing. |

---

##### `terraformResource`<sup>Required</sup> <a name="terraformResource" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsFileOutputReference.Initializer.parameter.terraformResource"></a>

- *Type:* com.hashicorp.cdktf.IInterpolatingParent

The parent resource.

---

##### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsFileOutputReference.Initializer.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

The attribute on the parent resource this class is referencing.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsFileOutputReference.computeFqn">computeFqn</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsFileOutputReference.getAnyMapAttribute">getAnyMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsFileOutputReference.getBooleanAttribute">getBooleanAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsFileOutputReference.getBooleanMapAttribute">getBooleanMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsFileOutputReference.getListAttribute">getListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsFileOutputReference.getNumberAttribute">getNumberAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsFileOutputReference.getNumberListAttribute">getNumberListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsFileOutputReference.getNumberMapAttribute">getNumberMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsFileOutputReference.getStringAttribute">getStringAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsFileOutputReference.getStringMapAttribute">getStringMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsFileOutputReference.interpolationForAttribute">interpolationForAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsFileOutputReference.resolve">resolve</a></code> | Produce the Token's value at resolution time. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsFileOutputReference.toString">toString</a></code> | Return a string representation of this resolvable object. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsFileOutputReference.resetDestination">resetDestination</a></code> | *No description.* |

---

##### `computeFqn` <a name="computeFqn" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsFileOutputReference.computeFqn"></a>

```java
public java.lang.String computeFqn()
```

##### `getAnyMapAttribute` <a name="getAnyMapAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsFileOutputReference.getAnyMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Object> getAnyMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsFileOutputReference.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getBooleanAttribute` <a name="getBooleanAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsFileOutputReference.getBooleanAttribute"></a>

```java
public IResolvable getBooleanAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsFileOutputReference.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getBooleanMapAttribute` <a name="getBooleanMapAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsFileOutputReference.getBooleanMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Boolean> getBooleanMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsFileOutputReference.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getListAttribute` <a name="getListAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsFileOutputReference.getListAttribute"></a>

```java
public java.util.List<java.lang.String> getListAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsFileOutputReference.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberAttribute` <a name="getNumberAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsFileOutputReference.getNumberAttribute"></a>

```java
public java.lang.Number getNumberAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsFileOutputReference.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberListAttribute` <a name="getNumberListAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsFileOutputReference.getNumberListAttribute"></a>

```java
public java.util.List<java.lang.Number> getNumberListAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsFileOutputReference.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberMapAttribute` <a name="getNumberMapAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsFileOutputReference.getNumberMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Number> getNumberMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsFileOutputReference.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getStringAttribute` <a name="getStringAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsFileOutputReference.getStringAttribute"></a>

```java
public java.lang.String getStringAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsFileOutputReference.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getStringMapAttribute` <a name="getStringMapAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsFileOutputReference.getStringMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.String> getStringMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsFileOutputReference.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `interpolationForAttribute` <a name="interpolationForAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsFileOutputReference.interpolationForAttribute"></a>

```java
public IResolvable interpolationForAttribute(java.lang.String property)
```

###### `property`<sup>Required</sup> <a name="property" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsFileOutputReference.interpolationForAttribute.parameter.property"></a>

- *Type:* java.lang.String

---

##### `resolve` <a name="resolve" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsFileOutputReference.resolve"></a>

```java
public java.lang.Object resolve(IResolveContext _context)
```

Produce the Token's value at resolution time.

###### `_context`<sup>Required</sup> <a name="_context" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsFileOutputReference.resolve.parameter._context"></a>

- *Type:* com.hashicorp.cdktf.IResolveContext

---

##### `toString` <a name="toString" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsFileOutputReference.toString"></a>

```java
public java.lang.String toString()
```

Return a string representation of this resolvable object.

Returns a reversible string representation.

##### `resetDestination` <a name="resetDestination" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsFileOutputReference.resetDestination"></a>

```java
public void resetDestination()
```


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsFileOutputReference.property.creationStack">creationStack</a></code> | <code>java.util.List<java.lang.String></code> | The creation stack of this resolvable which will be appended to errors thrown during resolution. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsFileOutputReference.property.fqn">fqn</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsFileOutputReference.property.destinationInput">destinationInput</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsFileOutputReference.property.destination">destination</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsFileOutputReference.property.internalValue">internalValue</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsFile">JobJobClusterNewClusterInitScriptsFile</a></code> | *No description.* |

---

##### `creationStack`<sup>Required</sup> <a name="creationStack" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsFileOutputReference.property.creationStack"></a>

```java
public java.util.List<java.lang.String> getCreationStack();
```

- *Type:* java.util.List<java.lang.String>

The creation stack of this resolvable which will be appended to errors thrown during resolution.

If this returns an empty array the stack will not be attached.

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsFileOutputReference.property.fqn"></a>

```java
public java.lang.String getFqn();
```

- *Type:* java.lang.String

---

##### `destinationInput`<sup>Optional</sup> <a name="destinationInput" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsFileOutputReference.property.destinationInput"></a>

```java
public java.lang.String getDestinationInput();
```

- *Type:* java.lang.String

---

##### `destination`<sup>Required</sup> <a name="destination" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsFileOutputReference.property.destination"></a>

```java
public java.lang.String getDestination();
```

- *Type:* java.lang.String

---

##### `internalValue`<sup>Optional</sup> <a name="internalValue" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsFileOutputReference.property.internalValue"></a>

```java
public JobJobClusterNewClusterInitScriptsFile getInternalValue();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsFile">JobJobClusterNewClusterInitScriptsFile</a>

---


### JobJobClusterNewClusterInitScriptsGcsOutputReference <a name="JobJobClusterNewClusterInitScriptsGcsOutputReference" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsGcsOutputReference"></a>

#### Initializers <a name="Initializers" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsGcsOutputReference.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobJobClusterNewClusterInitScriptsGcsOutputReference;

new JobJobClusterNewClusterInitScriptsGcsOutputReference(IInterpolatingParent terraformResource, java.lang.String terraformAttribute);
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsGcsOutputReference.Initializer.parameter.terraformResource">terraformResource</a></code> | <code>com.hashicorp.cdktf.IInterpolatingParent</code> | The parent resource. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsGcsOutputReference.Initializer.parameter.terraformAttribute">terraformAttribute</a></code> | <code>java.lang.String</code> | The attribute on the parent resource this class is referencing. |

---

##### `terraformResource`<sup>Required</sup> <a name="terraformResource" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsGcsOutputReference.Initializer.parameter.terraformResource"></a>

- *Type:* com.hashicorp.cdktf.IInterpolatingParent

The parent resource.

---

##### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsGcsOutputReference.Initializer.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

The attribute on the parent resource this class is referencing.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsGcsOutputReference.computeFqn">computeFqn</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsGcsOutputReference.getAnyMapAttribute">getAnyMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsGcsOutputReference.getBooleanAttribute">getBooleanAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsGcsOutputReference.getBooleanMapAttribute">getBooleanMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsGcsOutputReference.getListAttribute">getListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsGcsOutputReference.getNumberAttribute">getNumberAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsGcsOutputReference.getNumberListAttribute">getNumberListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsGcsOutputReference.getNumberMapAttribute">getNumberMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsGcsOutputReference.getStringAttribute">getStringAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsGcsOutputReference.getStringMapAttribute">getStringMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsGcsOutputReference.interpolationForAttribute">interpolationForAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsGcsOutputReference.resolve">resolve</a></code> | Produce the Token's value at resolution time. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsGcsOutputReference.toString">toString</a></code> | Return a string representation of this resolvable object. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsGcsOutputReference.resetDestination">resetDestination</a></code> | *No description.* |

---

##### `computeFqn` <a name="computeFqn" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsGcsOutputReference.computeFqn"></a>

```java
public java.lang.String computeFqn()
```

##### `getAnyMapAttribute` <a name="getAnyMapAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsGcsOutputReference.getAnyMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Object> getAnyMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsGcsOutputReference.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getBooleanAttribute` <a name="getBooleanAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsGcsOutputReference.getBooleanAttribute"></a>

```java
public IResolvable getBooleanAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsGcsOutputReference.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getBooleanMapAttribute` <a name="getBooleanMapAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsGcsOutputReference.getBooleanMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Boolean> getBooleanMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsGcsOutputReference.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getListAttribute` <a name="getListAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsGcsOutputReference.getListAttribute"></a>

```java
public java.util.List<java.lang.String> getListAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsGcsOutputReference.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberAttribute` <a name="getNumberAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsGcsOutputReference.getNumberAttribute"></a>

```java
public java.lang.Number getNumberAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsGcsOutputReference.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberListAttribute` <a name="getNumberListAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsGcsOutputReference.getNumberListAttribute"></a>

```java
public java.util.List<java.lang.Number> getNumberListAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsGcsOutputReference.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberMapAttribute` <a name="getNumberMapAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsGcsOutputReference.getNumberMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Number> getNumberMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsGcsOutputReference.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getStringAttribute` <a name="getStringAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsGcsOutputReference.getStringAttribute"></a>

```java
public java.lang.String getStringAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsGcsOutputReference.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getStringMapAttribute` <a name="getStringMapAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsGcsOutputReference.getStringMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.String> getStringMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsGcsOutputReference.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `interpolationForAttribute` <a name="interpolationForAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsGcsOutputReference.interpolationForAttribute"></a>

```java
public IResolvable interpolationForAttribute(java.lang.String property)
```

###### `property`<sup>Required</sup> <a name="property" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsGcsOutputReference.interpolationForAttribute.parameter.property"></a>

- *Type:* java.lang.String

---

##### `resolve` <a name="resolve" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsGcsOutputReference.resolve"></a>

```java
public java.lang.Object resolve(IResolveContext _context)
```

Produce the Token's value at resolution time.

###### `_context`<sup>Required</sup> <a name="_context" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsGcsOutputReference.resolve.parameter._context"></a>

- *Type:* com.hashicorp.cdktf.IResolveContext

---

##### `toString` <a name="toString" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsGcsOutputReference.toString"></a>

```java
public java.lang.String toString()
```

Return a string representation of this resolvable object.

Returns a reversible string representation.

##### `resetDestination` <a name="resetDestination" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsGcsOutputReference.resetDestination"></a>

```java
public void resetDestination()
```


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsGcsOutputReference.property.creationStack">creationStack</a></code> | <code>java.util.List<java.lang.String></code> | The creation stack of this resolvable which will be appended to errors thrown during resolution. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsGcsOutputReference.property.fqn">fqn</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsGcsOutputReference.property.destinationInput">destinationInput</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsGcsOutputReference.property.destination">destination</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsGcsOutputReference.property.internalValue">internalValue</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsGcs">JobJobClusterNewClusterInitScriptsGcs</a></code> | *No description.* |

---

##### `creationStack`<sup>Required</sup> <a name="creationStack" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsGcsOutputReference.property.creationStack"></a>

```java
public java.util.List<java.lang.String> getCreationStack();
```

- *Type:* java.util.List<java.lang.String>

The creation stack of this resolvable which will be appended to errors thrown during resolution.

If this returns an empty array the stack will not be attached.

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsGcsOutputReference.property.fqn"></a>

```java
public java.lang.String getFqn();
```

- *Type:* java.lang.String

---

##### `destinationInput`<sup>Optional</sup> <a name="destinationInput" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsGcsOutputReference.property.destinationInput"></a>

```java
public java.lang.String getDestinationInput();
```

- *Type:* java.lang.String

---

##### `destination`<sup>Required</sup> <a name="destination" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsGcsOutputReference.property.destination"></a>

```java
public java.lang.String getDestination();
```

- *Type:* java.lang.String

---

##### `internalValue`<sup>Optional</sup> <a name="internalValue" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsGcsOutputReference.property.internalValue"></a>

```java
public JobJobClusterNewClusterInitScriptsGcs getInternalValue();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsGcs">JobJobClusterNewClusterInitScriptsGcs</a>

---


### JobJobClusterNewClusterInitScriptsList <a name="JobJobClusterNewClusterInitScriptsList" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsList"></a>

#### Initializers <a name="Initializers" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsList.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobJobClusterNewClusterInitScriptsList;

new JobJobClusterNewClusterInitScriptsList(IInterpolatingParent terraformResource, java.lang.String terraformAttribute, java.lang.Boolean wrapsSet);
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsList.Initializer.parameter.terraformResource">terraformResource</a></code> | <code>com.hashicorp.cdktf.IInterpolatingParent</code> | The parent resource. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsList.Initializer.parameter.terraformAttribute">terraformAttribute</a></code> | <code>java.lang.String</code> | The attribute on the parent resource this class is referencing. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsList.Initializer.parameter.wrapsSet">wrapsSet</a></code> | <code>java.lang.Boolean</code> | whether the list is wrapping a set (will add tolist() to be able to access an item via an index). |

---

##### `terraformResource`<sup>Required</sup> <a name="terraformResource" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsList.Initializer.parameter.terraformResource"></a>

- *Type:* com.hashicorp.cdktf.IInterpolatingParent

The parent resource.

---

##### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsList.Initializer.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

The attribute on the parent resource this class is referencing.

---

##### `wrapsSet`<sup>Required</sup> <a name="wrapsSet" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsList.Initializer.parameter.wrapsSet"></a>

- *Type:* java.lang.Boolean

whether the list is wrapping a set (will add tolist() to be able to access an item via an index).

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsList.computeFqn">computeFqn</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsList.resolve">resolve</a></code> | Produce the Token's value at resolution time. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsList.toString">toString</a></code> | Return a string representation of this resolvable object. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsList.get">get</a></code> | *No description.* |

---

##### `computeFqn` <a name="computeFqn" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsList.computeFqn"></a>

```java
public java.lang.String computeFqn()
```

##### `resolve` <a name="resolve" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsList.resolve"></a>

```java
public java.lang.Object resolve(IResolveContext _context)
```

Produce the Token's value at resolution time.

###### `_context`<sup>Required</sup> <a name="_context" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsList.resolve.parameter._context"></a>

- *Type:* com.hashicorp.cdktf.IResolveContext

---

##### `toString` <a name="toString" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsList.toString"></a>

```java
public java.lang.String toString()
```

Return a string representation of this resolvable object.

Returns a reversible string representation.

##### `get` <a name="get" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsList.get"></a>

```java
public JobJobClusterNewClusterInitScriptsOutputReference get(java.lang.Number index)
```

###### `index`<sup>Required</sup> <a name="index" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsList.get.parameter.index"></a>

- *Type:* java.lang.Number

the index of the item to return.

---


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsList.property.creationStack">creationStack</a></code> | <code>java.util.List<java.lang.String></code> | The creation stack of this resolvable which will be appended to errors thrown during resolution. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsList.property.fqn">fqn</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsList.property.internalValue">internalValue</a></code> | <code>com.hashicorp.cdktf.IResolvable OR java.util.List<<a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScripts">JobJobClusterNewClusterInitScripts</a>></code> | *No description.* |

---

##### `creationStack`<sup>Required</sup> <a name="creationStack" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsList.property.creationStack"></a>

```java
public java.util.List<java.lang.String> getCreationStack();
```

- *Type:* java.util.List<java.lang.String>

The creation stack of this resolvable which will be appended to errors thrown during resolution.

If this returns an empty array the stack will not be attached.

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsList.property.fqn"></a>

```java
public java.lang.String getFqn();
```

- *Type:* java.lang.String

---

##### `internalValue`<sup>Optional</sup> <a name="internalValue" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsList.property.internalValue"></a>

```java
public java.lang.Object getInternalValue();
```

- *Type:* com.hashicorp.cdktf.IResolvable OR java.util.List<<a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScripts">JobJobClusterNewClusterInitScripts</a>>

---


### JobJobClusterNewClusterInitScriptsOutputReference <a name="JobJobClusterNewClusterInitScriptsOutputReference" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsOutputReference"></a>

#### Initializers <a name="Initializers" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsOutputReference.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobJobClusterNewClusterInitScriptsOutputReference;

new JobJobClusterNewClusterInitScriptsOutputReference(IInterpolatingParent terraformResource, java.lang.String terraformAttribute, java.lang.Number complexObjectIndex, java.lang.Boolean complexObjectIsFromSet);
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsOutputReference.Initializer.parameter.terraformResource">terraformResource</a></code> | <code>com.hashicorp.cdktf.IInterpolatingParent</code> | The parent resource. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsOutputReference.Initializer.parameter.terraformAttribute">terraformAttribute</a></code> | <code>java.lang.String</code> | The attribute on the parent resource this class is referencing. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsOutputReference.Initializer.parameter.complexObjectIndex">complexObjectIndex</a></code> | <code>java.lang.Number</code> | the index of this item in the list. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsOutputReference.Initializer.parameter.complexObjectIsFromSet">complexObjectIsFromSet</a></code> | <code>java.lang.Boolean</code> | whether the list is wrapping a set (will add tolist() to be able to access an item via an index). |

---

##### `terraformResource`<sup>Required</sup> <a name="terraformResource" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsOutputReference.Initializer.parameter.terraformResource"></a>

- *Type:* com.hashicorp.cdktf.IInterpolatingParent

The parent resource.

---

##### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsOutputReference.Initializer.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

The attribute on the parent resource this class is referencing.

---

##### `complexObjectIndex`<sup>Required</sup> <a name="complexObjectIndex" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsOutputReference.Initializer.parameter.complexObjectIndex"></a>

- *Type:* java.lang.Number

the index of this item in the list.

---

##### `complexObjectIsFromSet`<sup>Required</sup> <a name="complexObjectIsFromSet" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsOutputReference.Initializer.parameter.complexObjectIsFromSet"></a>

- *Type:* java.lang.Boolean

whether the list is wrapping a set (will add tolist() to be able to access an item via an index).

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsOutputReference.computeFqn">computeFqn</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsOutputReference.getAnyMapAttribute">getAnyMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsOutputReference.getBooleanAttribute">getBooleanAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsOutputReference.getBooleanMapAttribute">getBooleanMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsOutputReference.getListAttribute">getListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsOutputReference.getNumberAttribute">getNumberAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsOutputReference.getNumberListAttribute">getNumberListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsOutputReference.getNumberMapAttribute">getNumberMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsOutputReference.getStringAttribute">getStringAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsOutputReference.getStringMapAttribute">getStringMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsOutputReference.interpolationForAttribute">interpolationForAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsOutputReference.resolve">resolve</a></code> | Produce the Token's value at resolution time. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsOutputReference.toString">toString</a></code> | Return a string representation of this resolvable object. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsOutputReference.putAbfss">putAbfss</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsOutputReference.putDbfs">putDbfs</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsOutputReference.putFile">putFile</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsOutputReference.putGcs">putGcs</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsOutputReference.putS3">putS3</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsOutputReference.resetAbfss">resetAbfss</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsOutputReference.resetDbfs">resetDbfs</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsOutputReference.resetFile">resetFile</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsOutputReference.resetGcs">resetGcs</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsOutputReference.resetS3">resetS3</a></code> | *No description.* |

---

##### `computeFqn` <a name="computeFqn" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsOutputReference.computeFqn"></a>

```java
public java.lang.String computeFqn()
```

##### `getAnyMapAttribute` <a name="getAnyMapAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsOutputReference.getAnyMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Object> getAnyMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsOutputReference.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getBooleanAttribute` <a name="getBooleanAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsOutputReference.getBooleanAttribute"></a>

```java
public IResolvable getBooleanAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsOutputReference.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getBooleanMapAttribute` <a name="getBooleanMapAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsOutputReference.getBooleanMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Boolean> getBooleanMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsOutputReference.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getListAttribute` <a name="getListAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsOutputReference.getListAttribute"></a>

```java
public java.util.List<java.lang.String> getListAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsOutputReference.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberAttribute` <a name="getNumberAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsOutputReference.getNumberAttribute"></a>

```java
public java.lang.Number getNumberAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsOutputReference.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberListAttribute` <a name="getNumberListAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsOutputReference.getNumberListAttribute"></a>

```java
public java.util.List<java.lang.Number> getNumberListAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsOutputReference.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberMapAttribute` <a name="getNumberMapAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsOutputReference.getNumberMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Number> getNumberMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsOutputReference.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getStringAttribute` <a name="getStringAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsOutputReference.getStringAttribute"></a>

```java
public java.lang.String getStringAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsOutputReference.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getStringMapAttribute` <a name="getStringMapAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsOutputReference.getStringMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.String> getStringMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsOutputReference.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `interpolationForAttribute` <a name="interpolationForAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsOutputReference.interpolationForAttribute"></a>

```java
public IResolvable interpolationForAttribute(java.lang.String property)
```

###### `property`<sup>Required</sup> <a name="property" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsOutputReference.interpolationForAttribute.parameter.property"></a>

- *Type:* java.lang.String

---

##### `resolve` <a name="resolve" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsOutputReference.resolve"></a>

```java
public java.lang.Object resolve(IResolveContext _context)
```

Produce the Token's value at resolution time.

###### `_context`<sup>Required</sup> <a name="_context" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsOutputReference.resolve.parameter._context"></a>

- *Type:* com.hashicorp.cdktf.IResolveContext

---

##### `toString` <a name="toString" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsOutputReference.toString"></a>

```java
public java.lang.String toString()
```

Return a string representation of this resolvable object.

Returns a reversible string representation.

##### `putAbfss` <a name="putAbfss" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsOutputReference.putAbfss"></a>

```java
public void putAbfss(JobJobClusterNewClusterInitScriptsAbfss value)
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsOutputReference.putAbfss.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsAbfss">JobJobClusterNewClusterInitScriptsAbfss</a>

---

##### `putDbfs` <a name="putDbfs" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsOutputReference.putDbfs"></a>

```java
public void putDbfs(JobJobClusterNewClusterInitScriptsDbfs value)
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsOutputReference.putDbfs.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsDbfs">JobJobClusterNewClusterInitScriptsDbfs</a>

---

##### `putFile` <a name="putFile" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsOutputReference.putFile"></a>

```java
public void putFile(JobJobClusterNewClusterInitScriptsFile value)
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsOutputReference.putFile.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsFile">JobJobClusterNewClusterInitScriptsFile</a>

---

##### `putGcs` <a name="putGcs" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsOutputReference.putGcs"></a>

```java
public void putGcs(JobJobClusterNewClusterInitScriptsGcs value)
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsOutputReference.putGcs.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsGcs">JobJobClusterNewClusterInitScriptsGcs</a>

---

##### `putS3` <a name="putS3" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsOutputReference.putS3"></a>

```java
public void putS3(JobJobClusterNewClusterInitScriptsS3 value)
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsOutputReference.putS3.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3">JobJobClusterNewClusterInitScriptsS3</a>

---

##### `resetAbfss` <a name="resetAbfss" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsOutputReference.resetAbfss"></a>

```java
public void resetAbfss()
```

##### `resetDbfs` <a name="resetDbfs" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsOutputReference.resetDbfs"></a>

```java
public void resetDbfs()
```

##### `resetFile` <a name="resetFile" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsOutputReference.resetFile"></a>

```java
public void resetFile()
```

##### `resetGcs` <a name="resetGcs" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsOutputReference.resetGcs"></a>

```java
public void resetGcs()
```

##### `resetS3` <a name="resetS3" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsOutputReference.resetS3"></a>

```java
public void resetS3()
```


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsOutputReference.property.creationStack">creationStack</a></code> | <code>java.util.List<java.lang.String></code> | The creation stack of this resolvable which will be appended to errors thrown during resolution. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsOutputReference.property.fqn">fqn</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsOutputReference.property.abfss">abfss</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsAbfssOutputReference">JobJobClusterNewClusterInitScriptsAbfssOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsOutputReference.property.dbfs">dbfs</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsDbfsOutputReference">JobJobClusterNewClusterInitScriptsDbfsOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsOutputReference.property.file">file</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsFileOutputReference">JobJobClusterNewClusterInitScriptsFileOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsOutputReference.property.gcs">gcs</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsGcsOutputReference">JobJobClusterNewClusterInitScriptsGcsOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsOutputReference.property.s3">s3</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3OutputReference">JobJobClusterNewClusterInitScriptsS3OutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsOutputReference.property.abfssInput">abfssInput</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsAbfss">JobJobClusterNewClusterInitScriptsAbfss</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsOutputReference.property.dbfsInput">dbfsInput</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsDbfs">JobJobClusterNewClusterInitScriptsDbfs</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsOutputReference.property.fileInput">fileInput</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsFile">JobJobClusterNewClusterInitScriptsFile</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsOutputReference.property.gcsInput">gcsInput</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsGcs">JobJobClusterNewClusterInitScriptsGcs</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsOutputReference.property.s3Input">s3Input</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3">JobJobClusterNewClusterInitScriptsS3</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsOutputReference.property.internalValue">internalValue</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScripts">JobJobClusterNewClusterInitScripts</a> OR com.hashicorp.cdktf.IResolvable</code> | *No description.* |

---

##### `creationStack`<sup>Required</sup> <a name="creationStack" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsOutputReference.property.creationStack"></a>

```java
public java.util.List<java.lang.String> getCreationStack();
```

- *Type:* java.util.List<java.lang.String>

The creation stack of this resolvable which will be appended to errors thrown during resolution.

If this returns an empty array the stack will not be attached.

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsOutputReference.property.fqn"></a>

```java
public java.lang.String getFqn();
```

- *Type:* java.lang.String

---

##### `abfss`<sup>Required</sup> <a name="abfss" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsOutputReference.property.abfss"></a>

```java
public JobJobClusterNewClusterInitScriptsAbfssOutputReference getAbfss();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsAbfssOutputReference">JobJobClusterNewClusterInitScriptsAbfssOutputReference</a>

---

##### `dbfs`<sup>Required</sup> <a name="dbfs" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsOutputReference.property.dbfs"></a>

```java
public JobJobClusterNewClusterInitScriptsDbfsOutputReference getDbfs();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsDbfsOutputReference">JobJobClusterNewClusterInitScriptsDbfsOutputReference</a>

---

##### `file`<sup>Required</sup> <a name="file" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsOutputReference.property.file"></a>

```java
public JobJobClusterNewClusterInitScriptsFileOutputReference getFile();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsFileOutputReference">JobJobClusterNewClusterInitScriptsFileOutputReference</a>

---

##### `gcs`<sup>Required</sup> <a name="gcs" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsOutputReference.property.gcs"></a>

```java
public JobJobClusterNewClusterInitScriptsGcsOutputReference getGcs();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsGcsOutputReference">JobJobClusterNewClusterInitScriptsGcsOutputReference</a>

---

##### `s3`<sup>Required</sup> <a name="s3" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsOutputReference.property.s3"></a>

```java
public JobJobClusterNewClusterInitScriptsS3OutputReference getS3();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3OutputReference">JobJobClusterNewClusterInitScriptsS3OutputReference</a>

---

##### `abfssInput`<sup>Optional</sup> <a name="abfssInput" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsOutputReference.property.abfssInput"></a>

```java
public JobJobClusterNewClusterInitScriptsAbfss getAbfssInput();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsAbfss">JobJobClusterNewClusterInitScriptsAbfss</a>

---

##### `dbfsInput`<sup>Optional</sup> <a name="dbfsInput" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsOutputReference.property.dbfsInput"></a>

```java
public JobJobClusterNewClusterInitScriptsDbfs getDbfsInput();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsDbfs">JobJobClusterNewClusterInitScriptsDbfs</a>

---

##### `fileInput`<sup>Optional</sup> <a name="fileInput" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsOutputReference.property.fileInput"></a>

```java
public JobJobClusterNewClusterInitScriptsFile getFileInput();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsFile">JobJobClusterNewClusterInitScriptsFile</a>

---

##### `gcsInput`<sup>Optional</sup> <a name="gcsInput" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsOutputReference.property.gcsInput"></a>

```java
public JobJobClusterNewClusterInitScriptsGcs getGcsInput();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsGcs">JobJobClusterNewClusterInitScriptsGcs</a>

---

##### `s3Input`<sup>Optional</sup> <a name="s3Input" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsOutputReference.property.s3Input"></a>

```java
public JobJobClusterNewClusterInitScriptsS3 getS3Input();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3">JobJobClusterNewClusterInitScriptsS3</a>

---

##### `internalValue`<sup>Optional</sup> <a name="internalValue" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsOutputReference.property.internalValue"></a>

```java
public java.lang.Object getInternalValue();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScripts">JobJobClusterNewClusterInitScripts</a> OR com.hashicorp.cdktf.IResolvable

---


### JobJobClusterNewClusterInitScriptsS3OutputReference <a name="JobJobClusterNewClusterInitScriptsS3OutputReference" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3OutputReference"></a>

#### Initializers <a name="Initializers" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3OutputReference.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobJobClusterNewClusterInitScriptsS3OutputReference;

new JobJobClusterNewClusterInitScriptsS3OutputReference(IInterpolatingParent terraformResource, java.lang.String terraformAttribute);
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3OutputReference.Initializer.parameter.terraformResource">terraformResource</a></code> | <code>com.hashicorp.cdktf.IInterpolatingParent</code> | The parent resource. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3OutputReference.Initializer.parameter.terraformAttribute">terraformAttribute</a></code> | <code>java.lang.String</code> | The attribute on the parent resource this class is referencing. |

---

##### `terraformResource`<sup>Required</sup> <a name="terraformResource" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3OutputReference.Initializer.parameter.terraformResource"></a>

- *Type:* com.hashicorp.cdktf.IInterpolatingParent

The parent resource.

---

##### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3OutputReference.Initializer.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

The attribute on the parent resource this class is referencing.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3OutputReference.computeFqn">computeFqn</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3OutputReference.getAnyMapAttribute">getAnyMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3OutputReference.getBooleanAttribute">getBooleanAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3OutputReference.getBooleanMapAttribute">getBooleanMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3OutputReference.getListAttribute">getListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3OutputReference.getNumberAttribute">getNumberAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3OutputReference.getNumberListAttribute">getNumberListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3OutputReference.getNumberMapAttribute">getNumberMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3OutputReference.getStringAttribute">getStringAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3OutputReference.getStringMapAttribute">getStringMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3OutputReference.interpolationForAttribute">interpolationForAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3OutputReference.resolve">resolve</a></code> | Produce the Token's value at resolution time. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3OutputReference.toString">toString</a></code> | Return a string representation of this resolvable object. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3OutputReference.resetCannedAcl">resetCannedAcl</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3OutputReference.resetEnableEncryption">resetEnableEncryption</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3OutputReference.resetEncryptionType">resetEncryptionType</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3OutputReference.resetEndpoint">resetEndpoint</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3OutputReference.resetKmsKey">resetKmsKey</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3OutputReference.resetRegion">resetRegion</a></code> | *No description.* |

---

##### `computeFqn` <a name="computeFqn" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3OutputReference.computeFqn"></a>

```java
public java.lang.String computeFqn()
```

##### `getAnyMapAttribute` <a name="getAnyMapAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3OutputReference.getAnyMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Object> getAnyMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3OutputReference.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getBooleanAttribute` <a name="getBooleanAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3OutputReference.getBooleanAttribute"></a>

```java
public IResolvable getBooleanAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3OutputReference.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getBooleanMapAttribute` <a name="getBooleanMapAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3OutputReference.getBooleanMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Boolean> getBooleanMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3OutputReference.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getListAttribute` <a name="getListAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3OutputReference.getListAttribute"></a>

```java
public java.util.List<java.lang.String> getListAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3OutputReference.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberAttribute` <a name="getNumberAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3OutputReference.getNumberAttribute"></a>

```java
public java.lang.Number getNumberAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3OutputReference.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberListAttribute` <a name="getNumberListAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3OutputReference.getNumberListAttribute"></a>

```java
public java.util.List<java.lang.Number> getNumberListAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3OutputReference.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberMapAttribute` <a name="getNumberMapAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3OutputReference.getNumberMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Number> getNumberMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3OutputReference.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getStringAttribute` <a name="getStringAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3OutputReference.getStringAttribute"></a>

```java
public java.lang.String getStringAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3OutputReference.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getStringMapAttribute` <a name="getStringMapAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3OutputReference.getStringMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.String> getStringMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3OutputReference.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `interpolationForAttribute` <a name="interpolationForAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3OutputReference.interpolationForAttribute"></a>

```java
public IResolvable interpolationForAttribute(java.lang.String property)
```

###### `property`<sup>Required</sup> <a name="property" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3OutputReference.interpolationForAttribute.parameter.property"></a>

- *Type:* java.lang.String

---

##### `resolve` <a name="resolve" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3OutputReference.resolve"></a>

```java
public java.lang.Object resolve(IResolveContext _context)
```

Produce the Token's value at resolution time.

###### `_context`<sup>Required</sup> <a name="_context" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3OutputReference.resolve.parameter._context"></a>

- *Type:* com.hashicorp.cdktf.IResolveContext

---

##### `toString` <a name="toString" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3OutputReference.toString"></a>

```java
public java.lang.String toString()
```

Return a string representation of this resolvable object.

Returns a reversible string representation.

##### `resetCannedAcl` <a name="resetCannedAcl" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3OutputReference.resetCannedAcl"></a>

```java
public void resetCannedAcl()
```

##### `resetEnableEncryption` <a name="resetEnableEncryption" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3OutputReference.resetEnableEncryption"></a>

```java
public void resetEnableEncryption()
```

##### `resetEncryptionType` <a name="resetEncryptionType" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3OutputReference.resetEncryptionType"></a>

```java
public void resetEncryptionType()
```

##### `resetEndpoint` <a name="resetEndpoint" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3OutputReference.resetEndpoint"></a>

```java
public void resetEndpoint()
```

##### `resetKmsKey` <a name="resetKmsKey" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3OutputReference.resetKmsKey"></a>

```java
public void resetKmsKey()
```

##### `resetRegion` <a name="resetRegion" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3OutputReference.resetRegion"></a>

```java
public void resetRegion()
```


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3OutputReference.property.creationStack">creationStack</a></code> | <code>java.util.List<java.lang.String></code> | The creation stack of this resolvable which will be appended to errors thrown during resolution. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3OutputReference.property.fqn">fqn</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3OutputReference.property.cannedAclInput">cannedAclInput</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3OutputReference.property.destinationInput">destinationInput</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3OutputReference.property.enableEncryptionInput">enableEncryptionInput</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3OutputReference.property.encryptionTypeInput">encryptionTypeInput</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3OutputReference.property.endpointInput">endpointInput</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3OutputReference.property.kmsKeyInput">kmsKeyInput</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3OutputReference.property.regionInput">regionInput</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3OutputReference.property.cannedAcl">cannedAcl</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3OutputReference.property.destination">destination</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3OutputReference.property.enableEncryption">enableEncryption</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3OutputReference.property.encryptionType">encryptionType</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3OutputReference.property.endpoint">endpoint</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3OutputReference.property.kmsKey">kmsKey</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3OutputReference.property.region">region</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3OutputReference.property.internalValue">internalValue</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3">JobJobClusterNewClusterInitScriptsS3</a></code> | *No description.* |

---

##### `creationStack`<sup>Required</sup> <a name="creationStack" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3OutputReference.property.creationStack"></a>

```java
public java.util.List<java.lang.String> getCreationStack();
```

- *Type:* java.util.List<java.lang.String>

The creation stack of this resolvable which will be appended to errors thrown during resolution.

If this returns an empty array the stack will not be attached.

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3OutputReference.property.fqn"></a>

```java
public java.lang.String getFqn();
```

- *Type:* java.lang.String

---

##### `cannedAclInput`<sup>Optional</sup> <a name="cannedAclInput" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3OutputReference.property.cannedAclInput"></a>

```java
public java.lang.String getCannedAclInput();
```

- *Type:* java.lang.String

---

##### `destinationInput`<sup>Optional</sup> <a name="destinationInput" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3OutputReference.property.destinationInput"></a>

```java
public java.lang.String getDestinationInput();
```

- *Type:* java.lang.String

---

##### `enableEncryptionInput`<sup>Optional</sup> <a name="enableEncryptionInput" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3OutputReference.property.enableEncryptionInput"></a>

```java
public java.lang.Object getEnableEncryptionInput();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

---

##### `encryptionTypeInput`<sup>Optional</sup> <a name="encryptionTypeInput" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3OutputReference.property.encryptionTypeInput"></a>

```java
public java.lang.String getEncryptionTypeInput();
```

- *Type:* java.lang.String

---

##### `endpointInput`<sup>Optional</sup> <a name="endpointInput" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3OutputReference.property.endpointInput"></a>

```java
public java.lang.String getEndpointInput();
```

- *Type:* java.lang.String

---

##### `kmsKeyInput`<sup>Optional</sup> <a name="kmsKeyInput" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3OutputReference.property.kmsKeyInput"></a>

```java
public java.lang.String getKmsKeyInput();
```

- *Type:* java.lang.String

---

##### `regionInput`<sup>Optional</sup> <a name="regionInput" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3OutputReference.property.regionInput"></a>

```java
public java.lang.String getRegionInput();
```

- *Type:* java.lang.String

---

##### `cannedAcl`<sup>Required</sup> <a name="cannedAcl" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3OutputReference.property.cannedAcl"></a>

```java
public java.lang.String getCannedAcl();
```

- *Type:* java.lang.String

---

##### `destination`<sup>Required</sup> <a name="destination" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3OutputReference.property.destination"></a>

```java
public java.lang.String getDestination();
```

- *Type:* java.lang.String

---

##### `enableEncryption`<sup>Required</sup> <a name="enableEncryption" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3OutputReference.property.enableEncryption"></a>

```java
public java.lang.Object getEnableEncryption();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

---

##### `encryptionType`<sup>Required</sup> <a name="encryptionType" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3OutputReference.property.encryptionType"></a>

```java
public java.lang.String getEncryptionType();
```

- *Type:* java.lang.String

---

##### `endpoint`<sup>Required</sup> <a name="endpoint" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3OutputReference.property.endpoint"></a>

```java
public java.lang.String getEndpoint();
```

- *Type:* java.lang.String

---

##### `kmsKey`<sup>Required</sup> <a name="kmsKey" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3OutputReference.property.kmsKey"></a>

```java
public java.lang.String getKmsKey();
```

- *Type:* java.lang.String

---

##### `region`<sup>Required</sup> <a name="region" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3OutputReference.property.region"></a>

```java
public java.lang.String getRegion();
```

- *Type:* java.lang.String

---

##### `internalValue`<sup>Optional</sup> <a name="internalValue" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3OutputReference.property.internalValue"></a>

```java
public JobJobClusterNewClusterInitScriptsS3 getInternalValue();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsS3">JobJobClusterNewClusterInitScriptsS3</a>

---


### JobJobClusterNewClusterOutputReference <a name="JobJobClusterNewClusterOutputReference" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference"></a>

#### Initializers <a name="Initializers" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobJobClusterNewClusterOutputReference;

new JobJobClusterNewClusterOutputReference(IInterpolatingParent terraformResource, java.lang.String terraformAttribute);
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.Initializer.parameter.terraformResource">terraformResource</a></code> | <code>com.hashicorp.cdktf.IInterpolatingParent</code> | The parent resource. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.Initializer.parameter.terraformAttribute">terraformAttribute</a></code> | <code>java.lang.String</code> | The attribute on the parent resource this class is referencing. |

---

##### `terraformResource`<sup>Required</sup> <a name="terraformResource" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.Initializer.parameter.terraformResource"></a>

- *Type:* com.hashicorp.cdktf.IInterpolatingParent

The parent resource.

---

##### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.Initializer.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

The attribute on the parent resource this class is referencing.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.computeFqn">computeFqn</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.getAnyMapAttribute">getAnyMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.getBooleanAttribute">getBooleanAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.getBooleanMapAttribute">getBooleanMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.getListAttribute">getListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.getNumberAttribute">getNumberAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.getNumberListAttribute">getNumberListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.getNumberMapAttribute">getNumberMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.getStringAttribute">getStringAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.getStringMapAttribute">getStringMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.interpolationForAttribute">interpolationForAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.resolve">resolve</a></code> | Produce the Token's value at resolution time. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.toString">toString</a></code> | Return a string representation of this resolvable object. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.putAutoscale">putAutoscale</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.putAwsAttributes">putAwsAttributes</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.putAzureAttributes">putAzureAttributes</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.putClusterLogConf">putClusterLogConf</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.putClusterMountInfo">putClusterMountInfo</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.putDockerImage">putDockerImage</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.putGcpAttributes">putGcpAttributes</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.putInitScripts">putInitScripts</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.putWorkloadType">putWorkloadType</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.resetApplyPolicyDefaultValues">resetApplyPolicyDefaultValues</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.resetAutoscale">resetAutoscale</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.resetAutoterminationMinutes">resetAutoterminationMinutes</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.resetAwsAttributes">resetAwsAttributes</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.resetAzureAttributes">resetAzureAttributes</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.resetClusterId">resetClusterId</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.resetClusterLogConf">resetClusterLogConf</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.resetClusterMountInfo">resetClusterMountInfo</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.resetClusterName">resetClusterName</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.resetCustomTags">resetCustomTags</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.resetDataSecurityMode">resetDataSecurityMode</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.resetDockerImage">resetDockerImage</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.resetDriverInstancePoolId">resetDriverInstancePoolId</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.resetDriverNodeTypeId">resetDriverNodeTypeId</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.resetEnableElasticDisk">resetEnableElasticDisk</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.resetEnableLocalDiskEncryption">resetEnableLocalDiskEncryption</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.resetGcpAttributes">resetGcpAttributes</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.resetIdempotencyToken">resetIdempotencyToken</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.resetInitScripts">resetInitScripts</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.resetInstancePoolId">resetInstancePoolId</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.resetNodeTypeId">resetNodeTypeId</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.resetNumWorkers">resetNumWorkers</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.resetPolicyId">resetPolicyId</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.resetRuntimeEngine">resetRuntimeEngine</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.resetSingleUserName">resetSingleUserName</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.resetSparkConf">resetSparkConf</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.resetSparkEnvVars">resetSparkEnvVars</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.resetSshPublicKeys">resetSshPublicKeys</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.resetWorkloadType">resetWorkloadType</a></code> | *No description.* |

---

##### `computeFqn` <a name="computeFqn" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.computeFqn"></a>

```java
public java.lang.String computeFqn()
```

##### `getAnyMapAttribute` <a name="getAnyMapAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.getAnyMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Object> getAnyMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getBooleanAttribute` <a name="getBooleanAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.getBooleanAttribute"></a>

```java
public IResolvable getBooleanAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getBooleanMapAttribute` <a name="getBooleanMapAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.getBooleanMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Boolean> getBooleanMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getListAttribute` <a name="getListAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.getListAttribute"></a>

```java
public java.util.List<java.lang.String> getListAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberAttribute` <a name="getNumberAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.getNumberAttribute"></a>

```java
public java.lang.Number getNumberAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberListAttribute` <a name="getNumberListAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.getNumberListAttribute"></a>

```java
public java.util.List<java.lang.Number> getNumberListAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberMapAttribute` <a name="getNumberMapAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.getNumberMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Number> getNumberMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getStringAttribute` <a name="getStringAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.getStringAttribute"></a>

```java
public java.lang.String getStringAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getStringMapAttribute` <a name="getStringMapAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.getStringMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.String> getStringMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `interpolationForAttribute` <a name="interpolationForAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.interpolationForAttribute"></a>

```java
public IResolvable interpolationForAttribute(java.lang.String property)
```

###### `property`<sup>Required</sup> <a name="property" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.interpolationForAttribute.parameter.property"></a>

- *Type:* java.lang.String

---

##### `resolve` <a name="resolve" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.resolve"></a>

```java
public java.lang.Object resolve(IResolveContext _context)
```

Produce the Token's value at resolution time.

###### `_context`<sup>Required</sup> <a name="_context" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.resolve.parameter._context"></a>

- *Type:* com.hashicorp.cdktf.IResolveContext

---

##### `toString` <a name="toString" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.toString"></a>

```java
public java.lang.String toString()
```

Return a string representation of this resolvable object.

Returns a reversible string representation.

##### `putAutoscale` <a name="putAutoscale" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.putAutoscale"></a>

```java
public void putAutoscale(JobJobClusterNewClusterAutoscale value)
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.putAutoscale.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAutoscale">JobJobClusterNewClusterAutoscale</a>

---

##### `putAwsAttributes` <a name="putAwsAttributes" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.putAwsAttributes"></a>

```java
public void putAwsAttributes(JobJobClusterNewClusterAwsAttributes value)
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.putAwsAttributes.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributes">JobJobClusterNewClusterAwsAttributes</a>

---

##### `putAzureAttributes` <a name="putAzureAttributes" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.putAzureAttributes"></a>

```java
public void putAzureAttributes(JobJobClusterNewClusterAzureAttributes value)
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.putAzureAttributes.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAzureAttributes">JobJobClusterNewClusterAzureAttributes</a>

---

##### `putClusterLogConf` <a name="putClusterLogConf" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.putClusterLogConf"></a>

```java
public void putClusterLogConf(JobJobClusterNewClusterClusterLogConf value)
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.putClusterLogConf.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConf">JobJobClusterNewClusterClusterLogConf</a>

---

##### `putClusterMountInfo` <a name="putClusterMountInfo" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.putClusterMountInfo"></a>

```java
public void putClusterMountInfo(IResolvable OR java.util.List<JobJobClusterNewClusterClusterMountInfo> value)
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.putClusterMountInfo.parameter.value"></a>

- *Type:* com.hashicorp.cdktf.IResolvable OR java.util.List<<a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfo">JobJobClusterNewClusterClusterMountInfo</a>>

---

##### `putDockerImage` <a name="putDockerImage" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.putDockerImage"></a>

```java
public void putDockerImage(JobJobClusterNewClusterDockerImage value)
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.putDockerImage.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImage">JobJobClusterNewClusterDockerImage</a>

---

##### `putGcpAttributes` <a name="putGcpAttributes" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.putGcpAttributes"></a>

```java
public void putGcpAttributes(JobJobClusterNewClusterGcpAttributes value)
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.putGcpAttributes.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterGcpAttributes">JobJobClusterNewClusterGcpAttributes</a>

---

##### `putInitScripts` <a name="putInitScripts" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.putInitScripts"></a>

```java
public void putInitScripts(IResolvable OR java.util.List<JobJobClusterNewClusterInitScripts> value)
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.putInitScripts.parameter.value"></a>

- *Type:* com.hashicorp.cdktf.IResolvable OR java.util.List<<a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScripts">JobJobClusterNewClusterInitScripts</a>>

---

##### `putWorkloadType` <a name="putWorkloadType" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.putWorkloadType"></a>

```java
public void putWorkloadType(JobJobClusterNewClusterWorkloadType value)
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.putWorkloadType.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadType">JobJobClusterNewClusterWorkloadType</a>

---

##### `resetApplyPolicyDefaultValues` <a name="resetApplyPolicyDefaultValues" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.resetApplyPolicyDefaultValues"></a>

```java
public void resetApplyPolicyDefaultValues()
```

##### `resetAutoscale` <a name="resetAutoscale" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.resetAutoscale"></a>

```java
public void resetAutoscale()
```

##### `resetAutoterminationMinutes` <a name="resetAutoterminationMinutes" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.resetAutoterminationMinutes"></a>

```java
public void resetAutoterminationMinutes()
```

##### `resetAwsAttributes` <a name="resetAwsAttributes" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.resetAwsAttributes"></a>

```java
public void resetAwsAttributes()
```

##### `resetAzureAttributes` <a name="resetAzureAttributes" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.resetAzureAttributes"></a>

```java
public void resetAzureAttributes()
```

##### `resetClusterId` <a name="resetClusterId" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.resetClusterId"></a>

```java
public void resetClusterId()
```

##### `resetClusterLogConf` <a name="resetClusterLogConf" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.resetClusterLogConf"></a>

```java
public void resetClusterLogConf()
```

##### `resetClusterMountInfo` <a name="resetClusterMountInfo" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.resetClusterMountInfo"></a>

```java
public void resetClusterMountInfo()
```

##### `resetClusterName` <a name="resetClusterName" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.resetClusterName"></a>

```java
public void resetClusterName()
```

##### `resetCustomTags` <a name="resetCustomTags" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.resetCustomTags"></a>

```java
public void resetCustomTags()
```

##### `resetDataSecurityMode` <a name="resetDataSecurityMode" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.resetDataSecurityMode"></a>

```java
public void resetDataSecurityMode()
```

##### `resetDockerImage` <a name="resetDockerImage" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.resetDockerImage"></a>

```java
public void resetDockerImage()
```

##### `resetDriverInstancePoolId` <a name="resetDriverInstancePoolId" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.resetDriverInstancePoolId"></a>

```java
public void resetDriverInstancePoolId()
```

##### `resetDriverNodeTypeId` <a name="resetDriverNodeTypeId" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.resetDriverNodeTypeId"></a>

```java
public void resetDriverNodeTypeId()
```

##### `resetEnableElasticDisk` <a name="resetEnableElasticDisk" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.resetEnableElasticDisk"></a>

```java
public void resetEnableElasticDisk()
```

##### `resetEnableLocalDiskEncryption` <a name="resetEnableLocalDiskEncryption" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.resetEnableLocalDiskEncryption"></a>

```java
public void resetEnableLocalDiskEncryption()
```

##### `resetGcpAttributes` <a name="resetGcpAttributes" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.resetGcpAttributes"></a>

```java
public void resetGcpAttributes()
```

##### `resetIdempotencyToken` <a name="resetIdempotencyToken" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.resetIdempotencyToken"></a>

```java
public void resetIdempotencyToken()
```

##### `resetInitScripts` <a name="resetInitScripts" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.resetInitScripts"></a>

```java
public void resetInitScripts()
```

##### `resetInstancePoolId` <a name="resetInstancePoolId" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.resetInstancePoolId"></a>

```java
public void resetInstancePoolId()
```

##### `resetNodeTypeId` <a name="resetNodeTypeId" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.resetNodeTypeId"></a>

```java
public void resetNodeTypeId()
```

##### `resetNumWorkers` <a name="resetNumWorkers" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.resetNumWorkers"></a>

```java
public void resetNumWorkers()
```

##### `resetPolicyId` <a name="resetPolicyId" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.resetPolicyId"></a>

```java
public void resetPolicyId()
```

##### `resetRuntimeEngine` <a name="resetRuntimeEngine" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.resetRuntimeEngine"></a>

```java
public void resetRuntimeEngine()
```

##### `resetSingleUserName` <a name="resetSingleUserName" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.resetSingleUserName"></a>

```java
public void resetSingleUserName()
```

##### `resetSparkConf` <a name="resetSparkConf" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.resetSparkConf"></a>

```java
public void resetSparkConf()
```

##### `resetSparkEnvVars` <a name="resetSparkEnvVars" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.resetSparkEnvVars"></a>

```java
public void resetSparkEnvVars()
```

##### `resetSshPublicKeys` <a name="resetSshPublicKeys" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.resetSshPublicKeys"></a>

```java
public void resetSshPublicKeys()
```

##### `resetWorkloadType` <a name="resetWorkloadType" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.resetWorkloadType"></a>

```java
public void resetWorkloadType()
```


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.creationStack">creationStack</a></code> | <code>java.util.List<java.lang.String></code> | The creation stack of this resolvable which will be appended to errors thrown during resolution. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.fqn">fqn</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.autoscale">autoscale</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAutoscaleOutputReference">JobJobClusterNewClusterAutoscaleOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.awsAttributes">awsAttributes</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributesOutputReference">JobJobClusterNewClusterAwsAttributesOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.azureAttributes">azureAttributes</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAzureAttributesOutputReference">JobJobClusterNewClusterAzureAttributesOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.clusterLogConf">clusterLogConf</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfOutputReference">JobJobClusterNewClusterClusterLogConfOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.clusterMountInfo">clusterMountInfo</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoList">JobJobClusterNewClusterClusterMountInfoList</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.dockerImage">dockerImage</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageOutputReference">JobJobClusterNewClusterDockerImageOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.gcpAttributes">gcpAttributes</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterGcpAttributesOutputReference">JobJobClusterNewClusterGcpAttributesOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.initScripts">initScripts</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsList">JobJobClusterNewClusterInitScriptsList</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.workloadType">workloadType</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeOutputReference">JobJobClusterNewClusterWorkloadTypeOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.applyPolicyDefaultValuesInput">applyPolicyDefaultValuesInput</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.autoscaleInput">autoscaleInput</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAutoscale">JobJobClusterNewClusterAutoscale</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.autoterminationMinutesInput">autoterminationMinutesInput</a></code> | <code>java.lang.Number</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.awsAttributesInput">awsAttributesInput</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributes">JobJobClusterNewClusterAwsAttributes</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.azureAttributesInput">azureAttributesInput</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAzureAttributes">JobJobClusterNewClusterAzureAttributes</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.clusterIdInput">clusterIdInput</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.clusterLogConfInput">clusterLogConfInput</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConf">JobJobClusterNewClusterClusterLogConf</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.clusterMountInfoInput">clusterMountInfoInput</a></code> | <code>com.hashicorp.cdktf.IResolvable OR java.util.List<<a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfo">JobJobClusterNewClusterClusterMountInfo</a>></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.clusterNameInput">clusterNameInput</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.customTagsInput">customTagsInput</a></code> | <code>java.util.Map<java.lang.String, java.lang.String></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.dataSecurityModeInput">dataSecurityModeInput</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.dockerImageInput">dockerImageInput</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImage">JobJobClusterNewClusterDockerImage</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.driverInstancePoolIdInput">driverInstancePoolIdInput</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.driverNodeTypeIdInput">driverNodeTypeIdInput</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.enableElasticDiskInput">enableElasticDiskInput</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.enableLocalDiskEncryptionInput">enableLocalDiskEncryptionInput</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.gcpAttributesInput">gcpAttributesInput</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterGcpAttributes">JobJobClusterNewClusterGcpAttributes</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.idempotencyTokenInput">idempotencyTokenInput</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.initScriptsInput">initScriptsInput</a></code> | <code>com.hashicorp.cdktf.IResolvable OR java.util.List<<a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScripts">JobJobClusterNewClusterInitScripts</a>></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.instancePoolIdInput">instancePoolIdInput</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.nodeTypeIdInput">nodeTypeIdInput</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.numWorkersInput">numWorkersInput</a></code> | <code>java.lang.Number</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.policyIdInput">policyIdInput</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.runtimeEngineInput">runtimeEngineInput</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.singleUserNameInput">singleUserNameInput</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.sparkConfInput">sparkConfInput</a></code> | <code>java.util.Map<java.lang.String, java.lang.String></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.sparkEnvVarsInput">sparkEnvVarsInput</a></code> | <code>java.util.Map<java.lang.String, java.lang.String></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.sparkVersionInput">sparkVersionInput</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.sshPublicKeysInput">sshPublicKeysInput</a></code> | <code>java.util.List<java.lang.String></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.workloadTypeInput">workloadTypeInput</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadType">JobJobClusterNewClusterWorkloadType</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.applyPolicyDefaultValues">applyPolicyDefaultValues</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.autoterminationMinutes">autoterminationMinutes</a></code> | <code>java.lang.Number</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.clusterId">clusterId</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.clusterName">clusterName</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.customTags">customTags</a></code> | <code>java.util.Map<java.lang.String, java.lang.String></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.dataSecurityMode">dataSecurityMode</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.driverInstancePoolId">driverInstancePoolId</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.driverNodeTypeId">driverNodeTypeId</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.enableElasticDisk">enableElasticDisk</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.enableLocalDiskEncryption">enableLocalDiskEncryption</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.idempotencyToken">idempotencyToken</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.instancePoolId">instancePoolId</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.nodeTypeId">nodeTypeId</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.numWorkers">numWorkers</a></code> | <code>java.lang.Number</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.policyId">policyId</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.runtimeEngine">runtimeEngine</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.singleUserName">singleUserName</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.sparkConf">sparkConf</a></code> | <code>java.util.Map<java.lang.String, java.lang.String></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.sparkEnvVars">sparkEnvVars</a></code> | <code>java.util.Map<java.lang.String, java.lang.String></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.sparkVersion">sparkVersion</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.sshPublicKeys">sshPublicKeys</a></code> | <code>java.util.List<java.lang.String></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.internalValue">internalValue</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewCluster">JobJobClusterNewCluster</a></code> | *No description.* |

---

##### `creationStack`<sup>Required</sup> <a name="creationStack" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.creationStack"></a>

```java
public java.util.List<java.lang.String> getCreationStack();
```

- *Type:* java.util.List<java.lang.String>

The creation stack of this resolvable which will be appended to errors thrown during resolution.

If this returns an empty array the stack will not be attached.

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.fqn"></a>

```java
public java.lang.String getFqn();
```

- *Type:* java.lang.String

---

##### `autoscale`<sup>Required</sup> <a name="autoscale" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.autoscale"></a>

```java
public JobJobClusterNewClusterAutoscaleOutputReference getAutoscale();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAutoscaleOutputReference">JobJobClusterNewClusterAutoscaleOutputReference</a>

---

##### `awsAttributes`<sup>Required</sup> <a name="awsAttributes" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.awsAttributes"></a>

```java
public JobJobClusterNewClusterAwsAttributesOutputReference getAwsAttributes();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributesOutputReference">JobJobClusterNewClusterAwsAttributesOutputReference</a>

---

##### `azureAttributes`<sup>Required</sup> <a name="azureAttributes" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.azureAttributes"></a>

```java
public JobJobClusterNewClusterAzureAttributesOutputReference getAzureAttributes();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAzureAttributesOutputReference">JobJobClusterNewClusterAzureAttributesOutputReference</a>

---

##### `clusterLogConf`<sup>Required</sup> <a name="clusterLogConf" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.clusterLogConf"></a>

```java
public JobJobClusterNewClusterClusterLogConfOutputReference getClusterLogConf();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConfOutputReference">JobJobClusterNewClusterClusterLogConfOutputReference</a>

---

##### `clusterMountInfo`<sup>Required</sup> <a name="clusterMountInfo" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.clusterMountInfo"></a>

```java
public JobJobClusterNewClusterClusterMountInfoList getClusterMountInfo();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfoList">JobJobClusterNewClusterClusterMountInfoList</a>

---

##### `dockerImage`<sup>Required</sup> <a name="dockerImage" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.dockerImage"></a>

```java
public JobJobClusterNewClusterDockerImageOutputReference getDockerImage();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImageOutputReference">JobJobClusterNewClusterDockerImageOutputReference</a>

---

##### `gcpAttributes`<sup>Required</sup> <a name="gcpAttributes" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.gcpAttributes"></a>

```java
public JobJobClusterNewClusterGcpAttributesOutputReference getGcpAttributes();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterGcpAttributesOutputReference">JobJobClusterNewClusterGcpAttributesOutputReference</a>

---

##### `initScripts`<sup>Required</sup> <a name="initScripts" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.initScripts"></a>

```java
public JobJobClusterNewClusterInitScriptsList getInitScripts();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScriptsList">JobJobClusterNewClusterInitScriptsList</a>

---

##### `workloadType`<sup>Required</sup> <a name="workloadType" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.workloadType"></a>

```java
public JobJobClusterNewClusterWorkloadTypeOutputReference getWorkloadType();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeOutputReference">JobJobClusterNewClusterWorkloadTypeOutputReference</a>

---

##### `applyPolicyDefaultValuesInput`<sup>Optional</sup> <a name="applyPolicyDefaultValuesInput" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.applyPolicyDefaultValuesInput"></a>

```java
public java.lang.Object getApplyPolicyDefaultValuesInput();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

---

##### `autoscaleInput`<sup>Optional</sup> <a name="autoscaleInput" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.autoscaleInput"></a>

```java
public JobJobClusterNewClusterAutoscale getAutoscaleInput();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAutoscale">JobJobClusterNewClusterAutoscale</a>

---

##### `autoterminationMinutesInput`<sup>Optional</sup> <a name="autoterminationMinutesInput" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.autoterminationMinutesInput"></a>

```java
public java.lang.Number getAutoterminationMinutesInput();
```

- *Type:* java.lang.Number

---

##### `awsAttributesInput`<sup>Optional</sup> <a name="awsAttributesInput" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.awsAttributesInput"></a>

```java
public JobJobClusterNewClusterAwsAttributes getAwsAttributesInput();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAwsAttributes">JobJobClusterNewClusterAwsAttributes</a>

---

##### `azureAttributesInput`<sup>Optional</sup> <a name="azureAttributesInput" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.azureAttributesInput"></a>

```java
public JobJobClusterNewClusterAzureAttributes getAzureAttributesInput();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterAzureAttributes">JobJobClusterNewClusterAzureAttributes</a>

---

##### `clusterIdInput`<sup>Optional</sup> <a name="clusterIdInput" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.clusterIdInput"></a>

```java
public java.lang.String getClusterIdInput();
```

- *Type:* java.lang.String

---

##### `clusterLogConfInput`<sup>Optional</sup> <a name="clusterLogConfInput" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.clusterLogConfInput"></a>

```java
public JobJobClusterNewClusterClusterLogConf getClusterLogConfInput();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterLogConf">JobJobClusterNewClusterClusterLogConf</a>

---

##### `clusterMountInfoInput`<sup>Optional</sup> <a name="clusterMountInfoInput" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.clusterMountInfoInput"></a>

```java
public java.lang.Object getClusterMountInfoInput();
```

- *Type:* com.hashicorp.cdktf.IResolvable OR java.util.List<<a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterClusterMountInfo">JobJobClusterNewClusterClusterMountInfo</a>>

---

##### `clusterNameInput`<sup>Optional</sup> <a name="clusterNameInput" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.clusterNameInput"></a>

```java
public java.lang.String getClusterNameInput();
```

- *Type:* java.lang.String

---

##### `customTagsInput`<sup>Optional</sup> <a name="customTagsInput" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.customTagsInput"></a>

```java
public java.util.Map<java.lang.String, java.lang.String> getCustomTagsInput();
```

- *Type:* java.util.Map<java.lang.String, java.lang.String>

---

##### `dataSecurityModeInput`<sup>Optional</sup> <a name="dataSecurityModeInput" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.dataSecurityModeInput"></a>

```java
public java.lang.String getDataSecurityModeInput();
```

- *Type:* java.lang.String

---

##### `dockerImageInput`<sup>Optional</sup> <a name="dockerImageInput" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.dockerImageInput"></a>

```java
public JobJobClusterNewClusterDockerImage getDockerImageInput();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterDockerImage">JobJobClusterNewClusterDockerImage</a>

---

##### `driverInstancePoolIdInput`<sup>Optional</sup> <a name="driverInstancePoolIdInput" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.driverInstancePoolIdInput"></a>

```java
public java.lang.String getDriverInstancePoolIdInput();
```

- *Type:* java.lang.String

---

##### `driverNodeTypeIdInput`<sup>Optional</sup> <a name="driverNodeTypeIdInput" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.driverNodeTypeIdInput"></a>

```java
public java.lang.String getDriverNodeTypeIdInput();
```

- *Type:* java.lang.String

---

##### `enableElasticDiskInput`<sup>Optional</sup> <a name="enableElasticDiskInput" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.enableElasticDiskInput"></a>

```java
public java.lang.Object getEnableElasticDiskInput();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

---

##### `enableLocalDiskEncryptionInput`<sup>Optional</sup> <a name="enableLocalDiskEncryptionInput" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.enableLocalDiskEncryptionInput"></a>

```java
public java.lang.Object getEnableLocalDiskEncryptionInput();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

---

##### `gcpAttributesInput`<sup>Optional</sup> <a name="gcpAttributesInput" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.gcpAttributesInput"></a>

```java
public JobJobClusterNewClusterGcpAttributes getGcpAttributesInput();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterGcpAttributes">JobJobClusterNewClusterGcpAttributes</a>

---

##### `idempotencyTokenInput`<sup>Optional</sup> <a name="idempotencyTokenInput" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.idempotencyTokenInput"></a>

```java
public java.lang.String getIdempotencyTokenInput();
```

- *Type:* java.lang.String

---

##### `initScriptsInput`<sup>Optional</sup> <a name="initScriptsInput" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.initScriptsInput"></a>

```java
public java.lang.Object getInitScriptsInput();
```

- *Type:* com.hashicorp.cdktf.IResolvable OR java.util.List<<a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterInitScripts">JobJobClusterNewClusterInitScripts</a>>

---

##### `instancePoolIdInput`<sup>Optional</sup> <a name="instancePoolIdInput" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.instancePoolIdInput"></a>

```java
public java.lang.String getInstancePoolIdInput();
```

- *Type:* java.lang.String

---

##### `nodeTypeIdInput`<sup>Optional</sup> <a name="nodeTypeIdInput" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.nodeTypeIdInput"></a>

```java
public java.lang.String getNodeTypeIdInput();
```

- *Type:* java.lang.String

---

##### `numWorkersInput`<sup>Optional</sup> <a name="numWorkersInput" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.numWorkersInput"></a>

```java
public java.lang.Number getNumWorkersInput();
```

- *Type:* java.lang.Number

---

##### `policyIdInput`<sup>Optional</sup> <a name="policyIdInput" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.policyIdInput"></a>

```java
public java.lang.String getPolicyIdInput();
```

- *Type:* java.lang.String

---

##### `runtimeEngineInput`<sup>Optional</sup> <a name="runtimeEngineInput" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.runtimeEngineInput"></a>

```java
public java.lang.String getRuntimeEngineInput();
```

- *Type:* java.lang.String

---

##### `singleUserNameInput`<sup>Optional</sup> <a name="singleUserNameInput" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.singleUserNameInput"></a>

```java
public java.lang.String getSingleUserNameInput();
```

- *Type:* java.lang.String

---

##### `sparkConfInput`<sup>Optional</sup> <a name="sparkConfInput" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.sparkConfInput"></a>

```java
public java.util.Map<java.lang.String, java.lang.String> getSparkConfInput();
```

- *Type:* java.util.Map<java.lang.String, java.lang.String>

---

##### `sparkEnvVarsInput`<sup>Optional</sup> <a name="sparkEnvVarsInput" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.sparkEnvVarsInput"></a>

```java
public java.util.Map<java.lang.String, java.lang.String> getSparkEnvVarsInput();
```

- *Type:* java.util.Map<java.lang.String, java.lang.String>

---

##### `sparkVersionInput`<sup>Optional</sup> <a name="sparkVersionInput" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.sparkVersionInput"></a>

```java
public java.lang.String getSparkVersionInput();
```

- *Type:* java.lang.String

---

##### `sshPublicKeysInput`<sup>Optional</sup> <a name="sshPublicKeysInput" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.sshPublicKeysInput"></a>

```java
public java.util.List<java.lang.String> getSshPublicKeysInput();
```

- *Type:* java.util.List<java.lang.String>

---

##### `workloadTypeInput`<sup>Optional</sup> <a name="workloadTypeInput" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.workloadTypeInput"></a>

```java
public JobJobClusterNewClusterWorkloadType getWorkloadTypeInput();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadType">JobJobClusterNewClusterWorkloadType</a>

---

##### `applyPolicyDefaultValues`<sup>Required</sup> <a name="applyPolicyDefaultValues" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.applyPolicyDefaultValues"></a>

```java
public java.lang.Object getApplyPolicyDefaultValues();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

---

##### `autoterminationMinutes`<sup>Required</sup> <a name="autoterminationMinutes" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.autoterminationMinutes"></a>

```java
public java.lang.Number getAutoterminationMinutes();
```

- *Type:* java.lang.Number

---

##### `clusterId`<sup>Required</sup> <a name="clusterId" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.clusterId"></a>

```java
public java.lang.String getClusterId();
```

- *Type:* java.lang.String

---

##### `clusterName`<sup>Required</sup> <a name="clusterName" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.clusterName"></a>

```java
public java.lang.String getClusterName();
```

- *Type:* java.lang.String

---

##### `customTags`<sup>Required</sup> <a name="customTags" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.customTags"></a>

```java
public java.util.Map<java.lang.String, java.lang.String> getCustomTags();
```

- *Type:* java.util.Map<java.lang.String, java.lang.String>

---

##### `dataSecurityMode`<sup>Required</sup> <a name="dataSecurityMode" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.dataSecurityMode"></a>

```java
public java.lang.String getDataSecurityMode();
```

- *Type:* java.lang.String

---

##### `driverInstancePoolId`<sup>Required</sup> <a name="driverInstancePoolId" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.driverInstancePoolId"></a>

```java
public java.lang.String getDriverInstancePoolId();
```

- *Type:* java.lang.String

---

##### `driverNodeTypeId`<sup>Required</sup> <a name="driverNodeTypeId" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.driverNodeTypeId"></a>

```java
public java.lang.String getDriverNodeTypeId();
```

- *Type:* java.lang.String

---

##### `enableElasticDisk`<sup>Required</sup> <a name="enableElasticDisk" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.enableElasticDisk"></a>

```java
public java.lang.Object getEnableElasticDisk();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

---

##### `enableLocalDiskEncryption`<sup>Required</sup> <a name="enableLocalDiskEncryption" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.enableLocalDiskEncryption"></a>

```java
public java.lang.Object getEnableLocalDiskEncryption();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

---

##### `idempotencyToken`<sup>Required</sup> <a name="idempotencyToken" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.idempotencyToken"></a>

```java
public java.lang.String getIdempotencyToken();
```

- *Type:* java.lang.String

---

##### `instancePoolId`<sup>Required</sup> <a name="instancePoolId" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.instancePoolId"></a>

```java
public java.lang.String getInstancePoolId();
```

- *Type:* java.lang.String

---

##### `nodeTypeId`<sup>Required</sup> <a name="nodeTypeId" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.nodeTypeId"></a>

```java
public java.lang.String getNodeTypeId();
```

- *Type:* java.lang.String

---

##### `numWorkers`<sup>Required</sup> <a name="numWorkers" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.numWorkers"></a>

```java
public java.lang.Number getNumWorkers();
```

- *Type:* java.lang.Number

---

##### `policyId`<sup>Required</sup> <a name="policyId" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.policyId"></a>

```java
public java.lang.String getPolicyId();
```

- *Type:* java.lang.String

---

##### `runtimeEngine`<sup>Required</sup> <a name="runtimeEngine" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.runtimeEngine"></a>

```java
public java.lang.String getRuntimeEngine();
```

- *Type:* java.lang.String

---

##### `singleUserName`<sup>Required</sup> <a name="singleUserName" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.singleUserName"></a>

```java
public java.lang.String getSingleUserName();
```

- *Type:* java.lang.String

---

##### `sparkConf`<sup>Required</sup> <a name="sparkConf" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.sparkConf"></a>

```java
public java.util.Map<java.lang.String, java.lang.String> getSparkConf();
```

- *Type:* java.util.Map<java.lang.String, java.lang.String>

---

##### `sparkEnvVars`<sup>Required</sup> <a name="sparkEnvVars" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.sparkEnvVars"></a>

```java
public java.util.Map<java.lang.String, java.lang.String> getSparkEnvVars();
```

- *Type:* java.util.Map<java.lang.String, java.lang.String>

---

##### `sparkVersion`<sup>Required</sup> <a name="sparkVersion" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.sparkVersion"></a>

```java
public java.lang.String getSparkVersion();
```

- *Type:* java.lang.String

---

##### `sshPublicKeys`<sup>Required</sup> <a name="sshPublicKeys" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.sshPublicKeys"></a>

```java
public java.util.List<java.lang.String> getSshPublicKeys();
```

- *Type:* java.util.List<java.lang.String>

---

##### `internalValue`<sup>Optional</sup> <a name="internalValue" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference.property.internalValue"></a>

```java
public JobJobClusterNewCluster getInternalValue();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobJobClusterNewCluster">JobJobClusterNewCluster</a>

---


### JobJobClusterNewClusterWorkloadTypeClientsOutputReference <a name="JobJobClusterNewClusterWorkloadTypeClientsOutputReference" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeClientsOutputReference"></a>

#### Initializers <a name="Initializers" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeClientsOutputReference.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobJobClusterNewClusterWorkloadTypeClientsOutputReference;

new JobJobClusterNewClusterWorkloadTypeClientsOutputReference(IInterpolatingParent terraformResource, java.lang.String terraformAttribute);
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeClientsOutputReference.Initializer.parameter.terraformResource">terraformResource</a></code> | <code>com.hashicorp.cdktf.IInterpolatingParent</code> | The parent resource. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeClientsOutputReference.Initializer.parameter.terraformAttribute">terraformAttribute</a></code> | <code>java.lang.String</code> | The attribute on the parent resource this class is referencing. |

---

##### `terraformResource`<sup>Required</sup> <a name="terraformResource" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeClientsOutputReference.Initializer.parameter.terraformResource"></a>

- *Type:* com.hashicorp.cdktf.IInterpolatingParent

The parent resource.

---

##### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeClientsOutputReference.Initializer.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

The attribute on the parent resource this class is referencing.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeClientsOutputReference.computeFqn">computeFqn</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeClientsOutputReference.getAnyMapAttribute">getAnyMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeClientsOutputReference.getBooleanAttribute">getBooleanAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeClientsOutputReference.getBooleanMapAttribute">getBooleanMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeClientsOutputReference.getListAttribute">getListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeClientsOutputReference.getNumberAttribute">getNumberAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeClientsOutputReference.getNumberListAttribute">getNumberListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeClientsOutputReference.getNumberMapAttribute">getNumberMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeClientsOutputReference.getStringAttribute">getStringAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeClientsOutputReference.getStringMapAttribute">getStringMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeClientsOutputReference.interpolationForAttribute">interpolationForAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeClientsOutputReference.resolve">resolve</a></code> | Produce the Token's value at resolution time. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeClientsOutputReference.toString">toString</a></code> | Return a string representation of this resolvable object. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeClientsOutputReference.resetJobs">resetJobs</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeClientsOutputReference.resetNotebooks">resetNotebooks</a></code> | *No description.* |

---

##### `computeFqn` <a name="computeFqn" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeClientsOutputReference.computeFqn"></a>

```java
public java.lang.String computeFqn()
```

##### `getAnyMapAttribute` <a name="getAnyMapAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeClientsOutputReference.getAnyMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Object> getAnyMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeClientsOutputReference.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getBooleanAttribute` <a name="getBooleanAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeClientsOutputReference.getBooleanAttribute"></a>

```java
public IResolvable getBooleanAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeClientsOutputReference.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getBooleanMapAttribute` <a name="getBooleanMapAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeClientsOutputReference.getBooleanMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Boolean> getBooleanMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeClientsOutputReference.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getListAttribute` <a name="getListAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeClientsOutputReference.getListAttribute"></a>

```java
public java.util.List<java.lang.String> getListAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeClientsOutputReference.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberAttribute` <a name="getNumberAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeClientsOutputReference.getNumberAttribute"></a>

```java
public java.lang.Number getNumberAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeClientsOutputReference.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberListAttribute` <a name="getNumberListAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeClientsOutputReference.getNumberListAttribute"></a>

```java
public java.util.List<java.lang.Number> getNumberListAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeClientsOutputReference.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberMapAttribute` <a name="getNumberMapAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeClientsOutputReference.getNumberMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Number> getNumberMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeClientsOutputReference.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getStringAttribute` <a name="getStringAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeClientsOutputReference.getStringAttribute"></a>

```java
public java.lang.String getStringAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeClientsOutputReference.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getStringMapAttribute` <a name="getStringMapAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeClientsOutputReference.getStringMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.String> getStringMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeClientsOutputReference.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `interpolationForAttribute` <a name="interpolationForAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeClientsOutputReference.interpolationForAttribute"></a>

```java
public IResolvable interpolationForAttribute(java.lang.String property)
```

###### `property`<sup>Required</sup> <a name="property" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeClientsOutputReference.interpolationForAttribute.parameter.property"></a>

- *Type:* java.lang.String

---

##### `resolve` <a name="resolve" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeClientsOutputReference.resolve"></a>

```java
public java.lang.Object resolve(IResolveContext _context)
```

Produce the Token's value at resolution time.

###### `_context`<sup>Required</sup> <a name="_context" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeClientsOutputReference.resolve.parameter._context"></a>

- *Type:* com.hashicorp.cdktf.IResolveContext

---

##### `toString` <a name="toString" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeClientsOutputReference.toString"></a>

```java
public java.lang.String toString()
```

Return a string representation of this resolvable object.

Returns a reversible string representation.

##### `resetJobs` <a name="resetJobs" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeClientsOutputReference.resetJobs"></a>

```java
public void resetJobs()
```

##### `resetNotebooks` <a name="resetNotebooks" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeClientsOutputReference.resetNotebooks"></a>

```java
public void resetNotebooks()
```


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeClientsOutputReference.property.creationStack">creationStack</a></code> | <code>java.util.List<java.lang.String></code> | The creation stack of this resolvable which will be appended to errors thrown during resolution. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeClientsOutputReference.property.fqn">fqn</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeClientsOutputReference.property.jobsInput">jobsInput</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeClientsOutputReference.property.notebooksInput">notebooksInput</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeClientsOutputReference.property.jobs">jobs</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeClientsOutputReference.property.notebooks">notebooks</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeClientsOutputReference.property.internalValue">internalValue</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeClients">JobJobClusterNewClusterWorkloadTypeClients</a></code> | *No description.* |

---

##### `creationStack`<sup>Required</sup> <a name="creationStack" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeClientsOutputReference.property.creationStack"></a>

```java
public java.util.List<java.lang.String> getCreationStack();
```

- *Type:* java.util.List<java.lang.String>

The creation stack of this resolvable which will be appended to errors thrown during resolution.

If this returns an empty array the stack will not be attached.

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeClientsOutputReference.property.fqn"></a>

```java
public java.lang.String getFqn();
```

- *Type:* java.lang.String

---

##### `jobsInput`<sup>Optional</sup> <a name="jobsInput" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeClientsOutputReference.property.jobsInput"></a>

```java
public java.lang.Object getJobsInput();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

---

##### `notebooksInput`<sup>Optional</sup> <a name="notebooksInput" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeClientsOutputReference.property.notebooksInput"></a>

```java
public java.lang.Object getNotebooksInput();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

---

##### `jobs`<sup>Required</sup> <a name="jobs" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeClientsOutputReference.property.jobs"></a>

```java
public java.lang.Object getJobs();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

---

##### `notebooks`<sup>Required</sup> <a name="notebooks" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeClientsOutputReference.property.notebooks"></a>

```java
public java.lang.Object getNotebooks();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

---

##### `internalValue`<sup>Optional</sup> <a name="internalValue" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeClientsOutputReference.property.internalValue"></a>

```java
public JobJobClusterNewClusterWorkloadTypeClients getInternalValue();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeClients">JobJobClusterNewClusterWorkloadTypeClients</a>

---


### JobJobClusterNewClusterWorkloadTypeOutputReference <a name="JobJobClusterNewClusterWorkloadTypeOutputReference" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeOutputReference"></a>

#### Initializers <a name="Initializers" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeOutputReference.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobJobClusterNewClusterWorkloadTypeOutputReference;

new JobJobClusterNewClusterWorkloadTypeOutputReference(IInterpolatingParent terraformResource, java.lang.String terraformAttribute);
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeOutputReference.Initializer.parameter.terraformResource">terraformResource</a></code> | <code>com.hashicorp.cdktf.IInterpolatingParent</code> | The parent resource. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeOutputReference.Initializer.parameter.terraformAttribute">terraformAttribute</a></code> | <code>java.lang.String</code> | The attribute on the parent resource this class is referencing. |

---

##### `terraformResource`<sup>Required</sup> <a name="terraformResource" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeOutputReference.Initializer.parameter.terraformResource"></a>

- *Type:* com.hashicorp.cdktf.IInterpolatingParent

The parent resource.

---

##### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeOutputReference.Initializer.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

The attribute on the parent resource this class is referencing.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeOutputReference.computeFqn">computeFqn</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeOutputReference.getAnyMapAttribute">getAnyMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeOutputReference.getBooleanAttribute">getBooleanAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeOutputReference.getBooleanMapAttribute">getBooleanMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeOutputReference.getListAttribute">getListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeOutputReference.getNumberAttribute">getNumberAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeOutputReference.getNumberListAttribute">getNumberListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeOutputReference.getNumberMapAttribute">getNumberMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeOutputReference.getStringAttribute">getStringAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeOutputReference.getStringMapAttribute">getStringMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeOutputReference.interpolationForAttribute">interpolationForAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeOutputReference.resolve">resolve</a></code> | Produce the Token's value at resolution time. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeOutputReference.toString">toString</a></code> | Return a string representation of this resolvable object. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeOutputReference.putClients">putClients</a></code> | *No description.* |

---

##### `computeFqn` <a name="computeFqn" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeOutputReference.computeFqn"></a>

```java
public java.lang.String computeFqn()
```

##### `getAnyMapAttribute` <a name="getAnyMapAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeOutputReference.getAnyMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Object> getAnyMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeOutputReference.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getBooleanAttribute` <a name="getBooleanAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeOutputReference.getBooleanAttribute"></a>

```java
public IResolvable getBooleanAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeOutputReference.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getBooleanMapAttribute` <a name="getBooleanMapAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeOutputReference.getBooleanMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Boolean> getBooleanMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeOutputReference.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getListAttribute` <a name="getListAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeOutputReference.getListAttribute"></a>

```java
public java.util.List<java.lang.String> getListAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeOutputReference.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberAttribute` <a name="getNumberAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeOutputReference.getNumberAttribute"></a>

```java
public java.lang.Number getNumberAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeOutputReference.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberListAttribute` <a name="getNumberListAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeOutputReference.getNumberListAttribute"></a>

```java
public java.util.List<java.lang.Number> getNumberListAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeOutputReference.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberMapAttribute` <a name="getNumberMapAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeOutputReference.getNumberMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Number> getNumberMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeOutputReference.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getStringAttribute` <a name="getStringAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeOutputReference.getStringAttribute"></a>

```java
public java.lang.String getStringAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeOutputReference.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getStringMapAttribute` <a name="getStringMapAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeOutputReference.getStringMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.String> getStringMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeOutputReference.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `interpolationForAttribute` <a name="interpolationForAttribute" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeOutputReference.interpolationForAttribute"></a>

```java
public IResolvable interpolationForAttribute(java.lang.String property)
```

###### `property`<sup>Required</sup> <a name="property" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeOutputReference.interpolationForAttribute.parameter.property"></a>

- *Type:* java.lang.String

---

##### `resolve` <a name="resolve" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeOutputReference.resolve"></a>

```java
public java.lang.Object resolve(IResolveContext _context)
```

Produce the Token's value at resolution time.

###### `_context`<sup>Required</sup> <a name="_context" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeOutputReference.resolve.parameter._context"></a>

- *Type:* com.hashicorp.cdktf.IResolveContext

---

##### `toString` <a name="toString" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeOutputReference.toString"></a>

```java
public java.lang.String toString()
```

Return a string representation of this resolvable object.

Returns a reversible string representation.

##### `putClients` <a name="putClients" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeOutputReference.putClients"></a>

```java
public void putClients(JobJobClusterNewClusterWorkloadTypeClients value)
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeOutputReference.putClients.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeClients">JobJobClusterNewClusterWorkloadTypeClients</a>

---


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeOutputReference.property.creationStack">creationStack</a></code> | <code>java.util.List<java.lang.String></code> | The creation stack of this resolvable which will be appended to errors thrown during resolution. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeOutputReference.property.fqn">fqn</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeOutputReference.property.clients">clients</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeClientsOutputReference">JobJobClusterNewClusterWorkloadTypeClientsOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeOutputReference.property.clientsInput">clientsInput</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeClients">JobJobClusterNewClusterWorkloadTypeClients</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeOutputReference.property.internalValue">internalValue</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadType">JobJobClusterNewClusterWorkloadType</a></code> | *No description.* |

---

##### `creationStack`<sup>Required</sup> <a name="creationStack" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeOutputReference.property.creationStack"></a>

```java
public java.util.List<java.lang.String> getCreationStack();
```

- *Type:* java.util.List<java.lang.String>

The creation stack of this resolvable which will be appended to errors thrown during resolution.

If this returns an empty array the stack will not be attached.

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeOutputReference.property.fqn"></a>

```java
public java.lang.String getFqn();
```

- *Type:* java.lang.String

---

##### `clients`<sup>Required</sup> <a name="clients" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeOutputReference.property.clients"></a>

```java
public JobJobClusterNewClusterWorkloadTypeClientsOutputReference getClients();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeClientsOutputReference">JobJobClusterNewClusterWorkloadTypeClientsOutputReference</a>

---

##### `clientsInput`<sup>Optional</sup> <a name="clientsInput" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeOutputReference.property.clientsInput"></a>

```java
public JobJobClusterNewClusterWorkloadTypeClients getClientsInput();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeClients">JobJobClusterNewClusterWorkloadTypeClients</a>

---

##### `internalValue`<sup>Optional</sup> <a name="internalValue" id="@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadTypeOutputReference.property.internalValue"></a>

```java
public JobJobClusterNewClusterWorkloadType getInternalValue();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterWorkloadType">JobJobClusterNewClusterWorkloadType</a>

---


### JobJobClusterOutputReference <a name="JobJobClusterOutputReference" id="@cdktf/provider-databricks.job.JobJobClusterOutputReference"></a>

#### Initializers <a name="Initializers" id="@cdktf/provider-databricks.job.JobJobClusterOutputReference.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobJobClusterOutputReference;

new JobJobClusterOutputReference(IInterpolatingParent terraformResource, java.lang.String terraformAttribute, java.lang.Number complexObjectIndex, java.lang.Boolean complexObjectIsFromSet);
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterOutputReference.Initializer.parameter.terraformResource">terraformResource</a></code> | <code>com.hashicorp.cdktf.IInterpolatingParent</code> | The parent resource. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterOutputReference.Initializer.parameter.terraformAttribute">terraformAttribute</a></code> | <code>java.lang.String</code> | The attribute on the parent resource this class is referencing. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterOutputReference.Initializer.parameter.complexObjectIndex">complexObjectIndex</a></code> | <code>java.lang.Number</code> | the index of this item in the list. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterOutputReference.Initializer.parameter.complexObjectIsFromSet">complexObjectIsFromSet</a></code> | <code>java.lang.Boolean</code> | whether the list is wrapping a set (will add tolist() to be able to access an item via an index). |

---

##### `terraformResource`<sup>Required</sup> <a name="terraformResource" id="@cdktf/provider-databricks.job.JobJobClusterOutputReference.Initializer.parameter.terraformResource"></a>

- *Type:* com.hashicorp.cdktf.IInterpolatingParent

The parent resource.

---

##### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterOutputReference.Initializer.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

The attribute on the parent resource this class is referencing.

---

##### `complexObjectIndex`<sup>Required</sup> <a name="complexObjectIndex" id="@cdktf/provider-databricks.job.JobJobClusterOutputReference.Initializer.parameter.complexObjectIndex"></a>

- *Type:* java.lang.Number

the index of this item in the list.

---

##### `complexObjectIsFromSet`<sup>Required</sup> <a name="complexObjectIsFromSet" id="@cdktf/provider-databricks.job.JobJobClusterOutputReference.Initializer.parameter.complexObjectIsFromSet"></a>

- *Type:* java.lang.Boolean

whether the list is wrapping a set (will add tolist() to be able to access an item via an index).

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterOutputReference.computeFqn">computeFqn</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterOutputReference.getAnyMapAttribute">getAnyMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterOutputReference.getBooleanAttribute">getBooleanAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterOutputReference.getBooleanMapAttribute">getBooleanMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterOutputReference.getListAttribute">getListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterOutputReference.getNumberAttribute">getNumberAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterOutputReference.getNumberListAttribute">getNumberListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterOutputReference.getNumberMapAttribute">getNumberMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterOutputReference.getStringAttribute">getStringAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterOutputReference.getStringMapAttribute">getStringMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterOutputReference.interpolationForAttribute">interpolationForAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterOutputReference.resolve">resolve</a></code> | Produce the Token's value at resolution time. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterOutputReference.toString">toString</a></code> | Return a string representation of this resolvable object. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterOutputReference.putNewCluster">putNewCluster</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterOutputReference.resetJobClusterKey">resetJobClusterKey</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterOutputReference.resetNewCluster">resetNewCluster</a></code> | *No description.* |

---

##### `computeFqn` <a name="computeFqn" id="@cdktf/provider-databricks.job.JobJobClusterOutputReference.computeFqn"></a>

```java
public java.lang.String computeFqn()
```

##### `getAnyMapAttribute` <a name="getAnyMapAttribute" id="@cdktf/provider-databricks.job.JobJobClusterOutputReference.getAnyMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Object> getAnyMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterOutputReference.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getBooleanAttribute` <a name="getBooleanAttribute" id="@cdktf/provider-databricks.job.JobJobClusterOutputReference.getBooleanAttribute"></a>

```java
public IResolvable getBooleanAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterOutputReference.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getBooleanMapAttribute` <a name="getBooleanMapAttribute" id="@cdktf/provider-databricks.job.JobJobClusterOutputReference.getBooleanMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Boolean> getBooleanMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterOutputReference.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getListAttribute` <a name="getListAttribute" id="@cdktf/provider-databricks.job.JobJobClusterOutputReference.getListAttribute"></a>

```java
public java.util.List<java.lang.String> getListAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterOutputReference.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberAttribute` <a name="getNumberAttribute" id="@cdktf/provider-databricks.job.JobJobClusterOutputReference.getNumberAttribute"></a>

```java
public java.lang.Number getNumberAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterOutputReference.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberListAttribute` <a name="getNumberListAttribute" id="@cdktf/provider-databricks.job.JobJobClusterOutputReference.getNumberListAttribute"></a>

```java
public java.util.List<java.lang.Number> getNumberListAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterOutputReference.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberMapAttribute` <a name="getNumberMapAttribute" id="@cdktf/provider-databricks.job.JobJobClusterOutputReference.getNumberMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Number> getNumberMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterOutputReference.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getStringAttribute` <a name="getStringAttribute" id="@cdktf/provider-databricks.job.JobJobClusterOutputReference.getStringAttribute"></a>

```java
public java.lang.String getStringAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterOutputReference.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getStringMapAttribute` <a name="getStringMapAttribute" id="@cdktf/provider-databricks.job.JobJobClusterOutputReference.getStringMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.String> getStringMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobJobClusterOutputReference.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `interpolationForAttribute` <a name="interpolationForAttribute" id="@cdktf/provider-databricks.job.JobJobClusterOutputReference.interpolationForAttribute"></a>

```java
public IResolvable interpolationForAttribute(java.lang.String property)
```

###### `property`<sup>Required</sup> <a name="property" id="@cdktf/provider-databricks.job.JobJobClusterOutputReference.interpolationForAttribute.parameter.property"></a>

- *Type:* java.lang.String

---

##### `resolve` <a name="resolve" id="@cdktf/provider-databricks.job.JobJobClusterOutputReference.resolve"></a>

```java
public java.lang.Object resolve(IResolveContext _context)
```

Produce the Token's value at resolution time.

###### `_context`<sup>Required</sup> <a name="_context" id="@cdktf/provider-databricks.job.JobJobClusterOutputReference.resolve.parameter._context"></a>

- *Type:* com.hashicorp.cdktf.IResolveContext

---

##### `toString` <a name="toString" id="@cdktf/provider-databricks.job.JobJobClusterOutputReference.toString"></a>

```java
public java.lang.String toString()
```

Return a string representation of this resolvable object.

Returns a reversible string representation.

##### `putNewCluster` <a name="putNewCluster" id="@cdktf/provider-databricks.job.JobJobClusterOutputReference.putNewCluster"></a>

```java
public void putNewCluster(JobJobClusterNewCluster value)
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-databricks.job.JobJobClusterOutputReference.putNewCluster.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-databricks.job.JobJobClusterNewCluster">JobJobClusterNewCluster</a>

---

##### `resetJobClusterKey` <a name="resetJobClusterKey" id="@cdktf/provider-databricks.job.JobJobClusterOutputReference.resetJobClusterKey"></a>

```java
public void resetJobClusterKey()
```

##### `resetNewCluster` <a name="resetNewCluster" id="@cdktf/provider-databricks.job.JobJobClusterOutputReference.resetNewCluster"></a>

```java
public void resetNewCluster()
```


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterOutputReference.property.creationStack">creationStack</a></code> | <code>java.util.List<java.lang.String></code> | The creation stack of this resolvable which will be appended to errors thrown during resolution. |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterOutputReference.property.fqn">fqn</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterOutputReference.property.newCluster">newCluster</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference">JobJobClusterNewClusterOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterOutputReference.property.jobClusterKeyInput">jobClusterKeyInput</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterOutputReference.property.newClusterInput">newClusterInput</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobJobClusterNewCluster">JobJobClusterNewCluster</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterOutputReference.property.jobClusterKey">jobClusterKey</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobJobClusterOutputReference.property.internalValue">internalValue</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobJobCluster">JobJobCluster</a> OR com.hashicorp.cdktf.IResolvable</code> | *No description.* |

---

##### `creationStack`<sup>Required</sup> <a name="creationStack" id="@cdktf/provider-databricks.job.JobJobClusterOutputReference.property.creationStack"></a>

```java
public java.util.List<java.lang.String> getCreationStack();
```

- *Type:* java.util.List<java.lang.String>

The creation stack of this resolvable which will be appended to errors thrown during resolution.

If this returns an empty array the stack will not be attached.

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-databricks.job.JobJobClusterOutputReference.property.fqn"></a>

```java
public java.lang.String getFqn();
```

- *Type:* java.lang.String

---

##### `newCluster`<sup>Required</sup> <a name="newCluster" id="@cdktf/provider-databricks.job.JobJobClusterOutputReference.property.newCluster"></a>

```java
public JobJobClusterNewClusterOutputReference getNewCluster();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobJobClusterNewClusterOutputReference">JobJobClusterNewClusterOutputReference</a>

---

##### `jobClusterKeyInput`<sup>Optional</sup> <a name="jobClusterKeyInput" id="@cdktf/provider-databricks.job.JobJobClusterOutputReference.property.jobClusterKeyInput"></a>

```java
public java.lang.String getJobClusterKeyInput();
```

- *Type:* java.lang.String

---

##### `newClusterInput`<sup>Optional</sup> <a name="newClusterInput" id="@cdktf/provider-databricks.job.JobJobClusterOutputReference.property.newClusterInput"></a>

```java
public JobJobClusterNewCluster getNewClusterInput();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobJobClusterNewCluster">JobJobClusterNewCluster</a>

---

##### `jobClusterKey`<sup>Required</sup> <a name="jobClusterKey" id="@cdktf/provider-databricks.job.JobJobClusterOutputReference.property.jobClusterKey"></a>

```java
public java.lang.String getJobClusterKey();
```

- *Type:* java.lang.String

---

##### `internalValue`<sup>Optional</sup> <a name="internalValue" id="@cdktf/provider-databricks.job.JobJobClusterOutputReference.property.internalValue"></a>

```java
public java.lang.Object getInternalValue();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobJobCluster">JobJobCluster</a> OR com.hashicorp.cdktf.IResolvable

---


### JobLibraryCranOutputReference <a name="JobLibraryCranOutputReference" id="@cdktf/provider-databricks.job.JobLibraryCranOutputReference"></a>

#### Initializers <a name="Initializers" id="@cdktf/provider-databricks.job.JobLibraryCranOutputReference.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobLibraryCranOutputReference;

new JobLibraryCranOutputReference(IInterpolatingParent terraformResource, java.lang.String terraformAttribute);
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryCranOutputReference.Initializer.parameter.terraformResource">terraformResource</a></code> | <code>com.hashicorp.cdktf.IInterpolatingParent</code> | The parent resource. |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryCranOutputReference.Initializer.parameter.terraformAttribute">terraformAttribute</a></code> | <code>java.lang.String</code> | The attribute on the parent resource this class is referencing. |

---

##### `terraformResource`<sup>Required</sup> <a name="terraformResource" id="@cdktf/provider-databricks.job.JobLibraryCranOutputReference.Initializer.parameter.terraformResource"></a>

- *Type:* com.hashicorp.cdktf.IInterpolatingParent

The parent resource.

---

##### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobLibraryCranOutputReference.Initializer.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

The attribute on the parent resource this class is referencing.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryCranOutputReference.computeFqn">computeFqn</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryCranOutputReference.getAnyMapAttribute">getAnyMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryCranOutputReference.getBooleanAttribute">getBooleanAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryCranOutputReference.getBooleanMapAttribute">getBooleanMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryCranOutputReference.getListAttribute">getListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryCranOutputReference.getNumberAttribute">getNumberAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryCranOutputReference.getNumberListAttribute">getNumberListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryCranOutputReference.getNumberMapAttribute">getNumberMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryCranOutputReference.getStringAttribute">getStringAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryCranOutputReference.getStringMapAttribute">getStringMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryCranOutputReference.interpolationForAttribute">interpolationForAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryCranOutputReference.resolve">resolve</a></code> | Produce the Token's value at resolution time. |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryCranOutputReference.toString">toString</a></code> | Return a string representation of this resolvable object. |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryCranOutputReference.resetRepo">resetRepo</a></code> | *No description.* |

---

##### `computeFqn` <a name="computeFqn" id="@cdktf/provider-databricks.job.JobLibraryCranOutputReference.computeFqn"></a>

```java
public java.lang.String computeFqn()
```

##### `getAnyMapAttribute` <a name="getAnyMapAttribute" id="@cdktf/provider-databricks.job.JobLibraryCranOutputReference.getAnyMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Object> getAnyMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobLibraryCranOutputReference.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getBooleanAttribute` <a name="getBooleanAttribute" id="@cdktf/provider-databricks.job.JobLibraryCranOutputReference.getBooleanAttribute"></a>

```java
public IResolvable getBooleanAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobLibraryCranOutputReference.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getBooleanMapAttribute` <a name="getBooleanMapAttribute" id="@cdktf/provider-databricks.job.JobLibraryCranOutputReference.getBooleanMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Boolean> getBooleanMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobLibraryCranOutputReference.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getListAttribute` <a name="getListAttribute" id="@cdktf/provider-databricks.job.JobLibraryCranOutputReference.getListAttribute"></a>

```java
public java.util.List<java.lang.String> getListAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobLibraryCranOutputReference.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberAttribute` <a name="getNumberAttribute" id="@cdktf/provider-databricks.job.JobLibraryCranOutputReference.getNumberAttribute"></a>

```java
public java.lang.Number getNumberAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobLibraryCranOutputReference.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberListAttribute` <a name="getNumberListAttribute" id="@cdktf/provider-databricks.job.JobLibraryCranOutputReference.getNumberListAttribute"></a>

```java
public java.util.List<java.lang.Number> getNumberListAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobLibraryCranOutputReference.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberMapAttribute` <a name="getNumberMapAttribute" id="@cdktf/provider-databricks.job.JobLibraryCranOutputReference.getNumberMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Number> getNumberMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobLibraryCranOutputReference.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getStringAttribute` <a name="getStringAttribute" id="@cdktf/provider-databricks.job.JobLibraryCranOutputReference.getStringAttribute"></a>

```java
public java.lang.String getStringAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobLibraryCranOutputReference.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getStringMapAttribute` <a name="getStringMapAttribute" id="@cdktf/provider-databricks.job.JobLibraryCranOutputReference.getStringMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.String> getStringMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobLibraryCranOutputReference.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `interpolationForAttribute` <a name="interpolationForAttribute" id="@cdktf/provider-databricks.job.JobLibraryCranOutputReference.interpolationForAttribute"></a>

```java
public IResolvable interpolationForAttribute(java.lang.String property)
```

###### `property`<sup>Required</sup> <a name="property" id="@cdktf/provider-databricks.job.JobLibraryCranOutputReference.interpolationForAttribute.parameter.property"></a>

- *Type:* java.lang.String

---

##### `resolve` <a name="resolve" id="@cdktf/provider-databricks.job.JobLibraryCranOutputReference.resolve"></a>

```java
public java.lang.Object resolve(IResolveContext _context)
```

Produce the Token's value at resolution time.

###### `_context`<sup>Required</sup> <a name="_context" id="@cdktf/provider-databricks.job.JobLibraryCranOutputReference.resolve.parameter._context"></a>

- *Type:* com.hashicorp.cdktf.IResolveContext

---

##### `toString` <a name="toString" id="@cdktf/provider-databricks.job.JobLibraryCranOutputReference.toString"></a>

```java
public java.lang.String toString()
```

Return a string representation of this resolvable object.

Returns a reversible string representation.

##### `resetRepo` <a name="resetRepo" id="@cdktf/provider-databricks.job.JobLibraryCranOutputReference.resetRepo"></a>

```java
public void resetRepo()
```


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryCranOutputReference.property.creationStack">creationStack</a></code> | <code>java.util.List<java.lang.String></code> | The creation stack of this resolvable which will be appended to errors thrown during resolution. |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryCranOutputReference.property.fqn">fqn</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryCranOutputReference.property.packageInput">packageInput</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryCranOutputReference.property.repoInput">repoInput</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryCranOutputReference.property.package">package</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryCranOutputReference.property.repo">repo</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryCranOutputReference.property.internalValue">internalValue</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobLibraryCran">JobLibraryCran</a></code> | *No description.* |

---

##### `creationStack`<sup>Required</sup> <a name="creationStack" id="@cdktf/provider-databricks.job.JobLibraryCranOutputReference.property.creationStack"></a>

```java
public java.util.List<java.lang.String> getCreationStack();
```

- *Type:* java.util.List<java.lang.String>

The creation stack of this resolvable which will be appended to errors thrown during resolution.

If this returns an empty array the stack will not be attached.

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-databricks.job.JobLibraryCranOutputReference.property.fqn"></a>

```java
public java.lang.String getFqn();
```

- *Type:* java.lang.String

---

##### `packageInput`<sup>Optional</sup> <a name="packageInput" id="@cdktf/provider-databricks.job.JobLibraryCranOutputReference.property.packageInput"></a>

```java
public java.lang.String getPackageInput();
```

- *Type:* java.lang.String

---

##### `repoInput`<sup>Optional</sup> <a name="repoInput" id="@cdktf/provider-databricks.job.JobLibraryCranOutputReference.property.repoInput"></a>

```java
public java.lang.String getRepoInput();
```

- *Type:* java.lang.String

---

##### `package`<sup>Required</sup> <a name="package" id="@cdktf/provider-databricks.job.JobLibraryCranOutputReference.property.package"></a>

```java
public java.lang.String getPackage();
```

- *Type:* java.lang.String

---

##### `repo`<sup>Required</sup> <a name="repo" id="@cdktf/provider-databricks.job.JobLibraryCranOutputReference.property.repo"></a>

```java
public java.lang.String getRepo();
```

- *Type:* java.lang.String

---

##### `internalValue`<sup>Optional</sup> <a name="internalValue" id="@cdktf/provider-databricks.job.JobLibraryCranOutputReference.property.internalValue"></a>

```java
public JobLibraryCran getInternalValue();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobLibraryCran">JobLibraryCran</a>

---


### JobLibraryList <a name="JobLibraryList" id="@cdktf/provider-databricks.job.JobLibraryList"></a>

#### Initializers <a name="Initializers" id="@cdktf/provider-databricks.job.JobLibraryList.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobLibraryList;

new JobLibraryList(IInterpolatingParent terraformResource, java.lang.String terraformAttribute, java.lang.Boolean wrapsSet);
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryList.Initializer.parameter.terraformResource">terraformResource</a></code> | <code>com.hashicorp.cdktf.IInterpolatingParent</code> | The parent resource. |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryList.Initializer.parameter.terraformAttribute">terraformAttribute</a></code> | <code>java.lang.String</code> | The attribute on the parent resource this class is referencing. |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryList.Initializer.parameter.wrapsSet">wrapsSet</a></code> | <code>java.lang.Boolean</code> | whether the list is wrapping a set (will add tolist() to be able to access an item via an index). |

---

##### `terraformResource`<sup>Required</sup> <a name="terraformResource" id="@cdktf/provider-databricks.job.JobLibraryList.Initializer.parameter.terraformResource"></a>

- *Type:* com.hashicorp.cdktf.IInterpolatingParent

The parent resource.

---

##### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobLibraryList.Initializer.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

The attribute on the parent resource this class is referencing.

---

##### `wrapsSet`<sup>Required</sup> <a name="wrapsSet" id="@cdktf/provider-databricks.job.JobLibraryList.Initializer.parameter.wrapsSet"></a>

- *Type:* java.lang.Boolean

whether the list is wrapping a set (will add tolist() to be able to access an item via an index).

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryList.computeFqn">computeFqn</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryList.resolve">resolve</a></code> | Produce the Token's value at resolution time. |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryList.toString">toString</a></code> | Return a string representation of this resolvable object. |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryList.get">get</a></code> | *No description.* |

---

##### `computeFqn` <a name="computeFqn" id="@cdktf/provider-databricks.job.JobLibraryList.computeFqn"></a>

```java
public java.lang.String computeFqn()
```

##### `resolve` <a name="resolve" id="@cdktf/provider-databricks.job.JobLibraryList.resolve"></a>

```java
public java.lang.Object resolve(IResolveContext _context)
```

Produce the Token's value at resolution time.

###### `_context`<sup>Required</sup> <a name="_context" id="@cdktf/provider-databricks.job.JobLibraryList.resolve.parameter._context"></a>

- *Type:* com.hashicorp.cdktf.IResolveContext

---

##### `toString` <a name="toString" id="@cdktf/provider-databricks.job.JobLibraryList.toString"></a>

```java
public java.lang.String toString()
```

Return a string representation of this resolvable object.

Returns a reversible string representation.

##### `get` <a name="get" id="@cdktf/provider-databricks.job.JobLibraryList.get"></a>

```java
public JobLibraryOutputReference get(java.lang.Number index)
```

###### `index`<sup>Required</sup> <a name="index" id="@cdktf/provider-databricks.job.JobLibraryList.get.parameter.index"></a>

- *Type:* java.lang.Number

the index of the item to return.

---


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryList.property.creationStack">creationStack</a></code> | <code>java.util.List<java.lang.String></code> | The creation stack of this resolvable which will be appended to errors thrown during resolution. |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryList.property.fqn">fqn</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryList.property.internalValue">internalValue</a></code> | <code>com.hashicorp.cdktf.IResolvable OR java.util.List<<a href="#@cdktf/provider-databricks.job.JobLibrary">JobLibrary</a>></code> | *No description.* |

---

##### `creationStack`<sup>Required</sup> <a name="creationStack" id="@cdktf/provider-databricks.job.JobLibraryList.property.creationStack"></a>

```java
public java.util.List<java.lang.String> getCreationStack();
```

- *Type:* java.util.List<java.lang.String>

The creation stack of this resolvable which will be appended to errors thrown during resolution.

If this returns an empty array the stack will not be attached.

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-databricks.job.JobLibraryList.property.fqn"></a>

```java
public java.lang.String getFqn();
```

- *Type:* java.lang.String

---

##### `internalValue`<sup>Optional</sup> <a name="internalValue" id="@cdktf/provider-databricks.job.JobLibraryList.property.internalValue"></a>

```java
public java.lang.Object getInternalValue();
```

- *Type:* com.hashicorp.cdktf.IResolvable OR java.util.List<<a href="#@cdktf/provider-databricks.job.JobLibrary">JobLibrary</a>>

---


### JobLibraryMavenOutputReference <a name="JobLibraryMavenOutputReference" id="@cdktf/provider-databricks.job.JobLibraryMavenOutputReference"></a>

#### Initializers <a name="Initializers" id="@cdktf/provider-databricks.job.JobLibraryMavenOutputReference.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobLibraryMavenOutputReference;

new JobLibraryMavenOutputReference(IInterpolatingParent terraformResource, java.lang.String terraformAttribute);
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryMavenOutputReference.Initializer.parameter.terraformResource">terraformResource</a></code> | <code>com.hashicorp.cdktf.IInterpolatingParent</code> | The parent resource. |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryMavenOutputReference.Initializer.parameter.terraformAttribute">terraformAttribute</a></code> | <code>java.lang.String</code> | The attribute on the parent resource this class is referencing. |

---

##### `terraformResource`<sup>Required</sup> <a name="terraformResource" id="@cdktf/provider-databricks.job.JobLibraryMavenOutputReference.Initializer.parameter.terraformResource"></a>

- *Type:* com.hashicorp.cdktf.IInterpolatingParent

The parent resource.

---

##### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobLibraryMavenOutputReference.Initializer.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

The attribute on the parent resource this class is referencing.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryMavenOutputReference.computeFqn">computeFqn</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryMavenOutputReference.getAnyMapAttribute">getAnyMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryMavenOutputReference.getBooleanAttribute">getBooleanAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryMavenOutputReference.getBooleanMapAttribute">getBooleanMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryMavenOutputReference.getListAttribute">getListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryMavenOutputReference.getNumberAttribute">getNumberAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryMavenOutputReference.getNumberListAttribute">getNumberListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryMavenOutputReference.getNumberMapAttribute">getNumberMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryMavenOutputReference.getStringAttribute">getStringAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryMavenOutputReference.getStringMapAttribute">getStringMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryMavenOutputReference.interpolationForAttribute">interpolationForAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryMavenOutputReference.resolve">resolve</a></code> | Produce the Token's value at resolution time. |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryMavenOutputReference.toString">toString</a></code> | Return a string representation of this resolvable object. |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryMavenOutputReference.resetExclusions">resetExclusions</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryMavenOutputReference.resetRepo">resetRepo</a></code> | *No description.* |

---

##### `computeFqn` <a name="computeFqn" id="@cdktf/provider-databricks.job.JobLibraryMavenOutputReference.computeFqn"></a>

```java
public java.lang.String computeFqn()
```

##### `getAnyMapAttribute` <a name="getAnyMapAttribute" id="@cdktf/provider-databricks.job.JobLibraryMavenOutputReference.getAnyMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Object> getAnyMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobLibraryMavenOutputReference.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getBooleanAttribute` <a name="getBooleanAttribute" id="@cdktf/provider-databricks.job.JobLibraryMavenOutputReference.getBooleanAttribute"></a>

```java
public IResolvable getBooleanAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobLibraryMavenOutputReference.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getBooleanMapAttribute` <a name="getBooleanMapAttribute" id="@cdktf/provider-databricks.job.JobLibraryMavenOutputReference.getBooleanMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Boolean> getBooleanMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobLibraryMavenOutputReference.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getListAttribute` <a name="getListAttribute" id="@cdktf/provider-databricks.job.JobLibraryMavenOutputReference.getListAttribute"></a>

```java
public java.util.List<java.lang.String> getListAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobLibraryMavenOutputReference.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberAttribute` <a name="getNumberAttribute" id="@cdktf/provider-databricks.job.JobLibraryMavenOutputReference.getNumberAttribute"></a>

```java
public java.lang.Number getNumberAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobLibraryMavenOutputReference.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberListAttribute` <a name="getNumberListAttribute" id="@cdktf/provider-databricks.job.JobLibraryMavenOutputReference.getNumberListAttribute"></a>

```java
public java.util.List<java.lang.Number> getNumberListAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobLibraryMavenOutputReference.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberMapAttribute` <a name="getNumberMapAttribute" id="@cdktf/provider-databricks.job.JobLibraryMavenOutputReference.getNumberMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Number> getNumberMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobLibraryMavenOutputReference.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getStringAttribute` <a name="getStringAttribute" id="@cdktf/provider-databricks.job.JobLibraryMavenOutputReference.getStringAttribute"></a>

```java
public java.lang.String getStringAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobLibraryMavenOutputReference.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getStringMapAttribute` <a name="getStringMapAttribute" id="@cdktf/provider-databricks.job.JobLibraryMavenOutputReference.getStringMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.String> getStringMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobLibraryMavenOutputReference.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `interpolationForAttribute` <a name="interpolationForAttribute" id="@cdktf/provider-databricks.job.JobLibraryMavenOutputReference.interpolationForAttribute"></a>

```java
public IResolvable interpolationForAttribute(java.lang.String property)
```

###### `property`<sup>Required</sup> <a name="property" id="@cdktf/provider-databricks.job.JobLibraryMavenOutputReference.interpolationForAttribute.parameter.property"></a>

- *Type:* java.lang.String

---

##### `resolve` <a name="resolve" id="@cdktf/provider-databricks.job.JobLibraryMavenOutputReference.resolve"></a>

```java
public java.lang.Object resolve(IResolveContext _context)
```

Produce the Token's value at resolution time.

###### `_context`<sup>Required</sup> <a name="_context" id="@cdktf/provider-databricks.job.JobLibraryMavenOutputReference.resolve.parameter._context"></a>

- *Type:* com.hashicorp.cdktf.IResolveContext

---

##### `toString` <a name="toString" id="@cdktf/provider-databricks.job.JobLibraryMavenOutputReference.toString"></a>

```java
public java.lang.String toString()
```

Return a string representation of this resolvable object.

Returns a reversible string representation.

##### `resetExclusions` <a name="resetExclusions" id="@cdktf/provider-databricks.job.JobLibraryMavenOutputReference.resetExclusions"></a>

```java
public void resetExclusions()
```

##### `resetRepo` <a name="resetRepo" id="@cdktf/provider-databricks.job.JobLibraryMavenOutputReference.resetRepo"></a>

```java
public void resetRepo()
```


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryMavenOutputReference.property.creationStack">creationStack</a></code> | <code>java.util.List<java.lang.String></code> | The creation stack of this resolvable which will be appended to errors thrown during resolution. |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryMavenOutputReference.property.fqn">fqn</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryMavenOutputReference.property.coordinatesInput">coordinatesInput</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryMavenOutputReference.property.exclusionsInput">exclusionsInput</a></code> | <code>java.util.List<java.lang.String></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryMavenOutputReference.property.repoInput">repoInput</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryMavenOutputReference.property.coordinates">coordinates</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryMavenOutputReference.property.exclusions">exclusions</a></code> | <code>java.util.List<java.lang.String></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryMavenOutputReference.property.repo">repo</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryMavenOutputReference.property.internalValue">internalValue</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobLibraryMaven">JobLibraryMaven</a></code> | *No description.* |

---

##### `creationStack`<sup>Required</sup> <a name="creationStack" id="@cdktf/provider-databricks.job.JobLibraryMavenOutputReference.property.creationStack"></a>

```java
public java.util.List<java.lang.String> getCreationStack();
```

- *Type:* java.util.List<java.lang.String>

The creation stack of this resolvable which will be appended to errors thrown during resolution.

If this returns an empty array the stack will not be attached.

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-databricks.job.JobLibraryMavenOutputReference.property.fqn"></a>

```java
public java.lang.String getFqn();
```

- *Type:* java.lang.String

---

##### `coordinatesInput`<sup>Optional</sup> <a name="coordinatesInput" id="@cdktf/provider-databricks.job.JobLibraryMavenOutputReference.property.coordinatesInput"></a>

```java
public java.lang.String getCoordinatesInput();
```

- *Type:* java.lang.String

---

##### `exclusionsInput`<sup>Optional</sup> <a name="exclusionsInput" id="@cdktf/provider-databricks.job.JobLibraryMavenOutputReference.property.exclusionsInput"></a>

```java
public java.util.List<java.lang.String> getExclusionsInput();
```

- *Type:* java.util.List<java.lang.String>

---

##### `repoInput`<sup>Optional</sup> <a name="repoInput" id="@cdktf/provider-databricks.job.JobLibraryMavenOutputReference.property.repoInput"></a>

```java
public java.lang.String getRepoInput();
```

- *Type:* java.lang.String

---

##### `coordinates`<sup>Required</sup> <a name="coordinates" id="@cdktf/provider-databricks.job.JobLibraryMavenOutputReference.property.coordinates"></a>

```java
public java.lang.String getCoordinates();
```

- *Type:* java.lang.String

---

##### `exclusions`<sup>Required</sup> <a name="exclusions" id="@cdktf/provider-databricks.job.JobLibraryMavenOutputReference.property.exclusions"></a>

```java
public java.util.List<java.lang.String> getExclusions();
```

- *Type:* java.util.List<java.lang.String>

---

##### `repo`<sup>Required</sup> <a name="repo" id="@cdktf/provider-databricks.job.JobLibraryMavenOutputReference.property.repo"></a>

```java
public java.lang.String getRepo();
```

- *Type:* java.lang.String

---

##### `internalValue`<sup>Optional</sup> <a name="internalValue" id="@cdktf/provider-databricks.job.JobLibraryMavenOutputReference.property.internalValue"></a>

```java
public JobLibraryMaven getInternalValue();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobLibraryMaven">JobLibraryMaven</a>

---


### JobLibraryOutputReference <a name="JobLibraryOutputReference" id="@cdktf/provider-databricks.job.JobLibraryOutputReference"></a>

#### Initializers <a name="Initializers" id="@cdktf/provider-databricks.job.JobLibraryOutputReference.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobLibraryOutputReference;

new JobLibraryOutputReference(IInterpolatingParent terraformResource, java.lang.String terraformAttribute, java.lang.Number complexObjectIndex, java.lang.Boolean complexObjectIsFromSet);
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryOutputReference.Initializer.parameter.terraformResource">terraformResource</a></code> | <code>com.hashicorp.cdktf.IInterpolatingParent</code> | The parent resource. |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryOutputReference.Initializer.parameter.terraformAttribute">terraformAttribute</a></code> | <code>java.lang.String</code> | The attribute on the parent resource this class is referencing. |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryOutputReference.Initializer.parameter.complexObjectIndex">complexObjectIndex</a></code> | <code>java.lang.Number</code> | the index of this item in the list. |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryOutputReference.Initializer.parameter.complexObjectIsFromSet">complexObjectIsFromSet</a></code> | <code>java.lang.Boolean</code> | whether the list is wrapping a set (will add tolist() to be able to access an item via an index). |

---

##### `terraformResource`<sup>Required</sup> <a name="terraformResource" id="@cdktf/provider-databricks.job.JobLibraryOutputReference.Initializer.parameter.terraformResource"></a>

- *Type:* com.hashicorp.cdktf.IInterpolatingParent

The parent resource.

---

##### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobLibraryOutputReference.Initializer.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

The attribute on the parent resource this class is referencing.

---

##### `complexObjectIndex`<sup>Required</sup> <a name="complexObjectIndex" id="@cdktf/provider-databricks.job.JobLibraryOutputReference.Initializer.parameter.complexObjectIndex"></a>

- *Type:* java.lang.Number

the index of this item in the list.

---

##### `complexObjectIsFromSet`<sup>Required</sup> <a name="complexObjectIsFromSet" id="@cdktf/provider-databricks.job.JobLibraryOutputReference.Initializer.parameter.complexObjectIsFromSet"></a>

- *Type:* java.lang.Boolean

whether the list is wrapping a set (will add tolist() to be able to access an item via an index).

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryOutputReference.computeFqn">computeFqn</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryOutputReference.getAnyMapAttribute">getAnyMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryOutputReference.getBooleanAttribute">getBooleanAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryOutputReference.getBooleanMapAttribute">getBooleanMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryOutputReference.getListAttribute">getListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryOutputReference.getNumberAttribute">getNumberAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryOutputReference.getNumberListAttribute">getNumberListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryOutputReference.getNumberMapAttribute">getNumberMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryOutputReference.getStringAttribute">getStringAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryOutputReference.getStringMapAttribute">getStringMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryOutputReference.interpolationForAttribute">interpolationForAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryOutputReference.resolve">resolve</a></code> | Produce the Token's value at resolution time. |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryOutputReference.toString">toString</a></code> | Return a string representation of this resolvable object. |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryOutputReference.putCran">putCran</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryOutputReference.putMaven">putMaven</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryOutputReference.putPypi">putPypi</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryOutputReference.resetCran">resetCran</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryOutputReference.resetEgg">resetEgg</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryOutputReference.resetJar">resetJar</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryOutputReference.resetMaven">resetMaven</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryOutputReference.resetPypi">resetPypi</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryOutputReference.resetWhl">resetWhl</a></code> | *No description.* |

---

##### `computeFqn` <a name="computeFqn" id="@cdktf/provider-databricks.job.JobLibraryOutputReference.computeFqn"></a>

```java
public java.lang.String computeFqn()
```

##### `getAnyMapAttribute` <a name="getAnyMapAttribute" id="@cdktf/provider-databricks.job.JobLibraryOutputReference.getAnyMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Object> getAnyMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobLibraryOutputReference.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getBooleanAttribute` <a name="getBooleanAttribute" id="@cdktf/provider-databricks.job.JobLibraryOutputReference.getBooleanAttribute"></a>

```java
public IResolvable getBooleanAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobLibraryOutputReference.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getBooleanMapAttribute` <a name="getBooleanMapAttribute" id="@cdktf/provider-databricks.job.JobLibraryOutputReference.getBooleanMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Boolean> getBooleanMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobLibraryOutputReference.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getListAttribute` <a name="getListAttribute" id="@cdktf/provider-databricks.job.JobLibraryOutputReference.getListAttribute"></a>

```java
public java.util.List<java.lang.String> getListAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobLibraryOutputReference.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberAttribute` <a name="getNumberAttribute" id="@cdktf/provider-databricks.job.JobLibraryOutputReference.getNumberAttribute"></a>

```java
public java.lang.Number getNumberAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobLibraryOutputReference.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberListAttribute` <a name="getNumberListAttribute" id="@cdktf/provider-databricks.job.JobLibraryOutputReference.getNumberListAttribute"></a>

```java
public java.util.List<java.lang.Number> getNumberListAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobLibraryOutputReference.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberMapAttribute` <a name="getNumberMapAttribute" id="@cdktf/provider-databricks.job.JobLibraryOutputReference.getNumberMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Number> getNumberMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobLibraryOutputReference.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getStringAttribute` <a name="getStringAttribute" id="@cdktf/provider-databricks.job.JobLibraryOutputReference.getStringAttribute"></a>

```java
public java.lang.String getStringAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobLibraryOutputReference.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getStringMapAttribute` <a name="getStringMapAttribute" id="@cdktf/provider-databricks.job.JobLibraryOutputReference.getStringMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.String> getStringMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobLibraryOutputReference.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `interpolationForAttribute` <a name="interpolationForAttribute" id="@cdktf/provider-databricks.job.JobLibraryOutputReference.interpolationForAttribute"></a>

```java
public IResolvable interpolationForAttribute(java.lang.String property)
```

###### `property`<sup>Required</sup> <a name="property" id="@cdktf/provider-databricks.job.JobLibraryOutputReference.interpolationForAttribute.parameter.property"></a>

- *Type:* java.lang.String

---

##### `resolve` <a name="resolve" id="@cdktf/provider-databricks.job.JobLibraryOutputReference.resolve"></a>

```java
public java.lang.Object resolve(IResolveContext _context)
```

Produce the Token's value at resolution time.

###### `_context`<sup>Required</sup> <a name="_context" id="@cdktf/provider-databricks.job.JobLibraryOutputReference.resolve.parameter._context"></a>

- *Type:* com.hashicorp.cdktf.IResolveContext

---

##### `toString` <a name="toString" id="@cdktf/provider-databricks.job.JobLibraryOutputReference.toString"></a>

```java
public java.lang.String toString()
```

Return a string representation of this resolvable object.

Returns a reversible string representation.

##### `putCran` <a name="putCran" id="@cdktf/provider-databricks.job.JobLibraryOutputReference.putCran"></a>

```java
public void putCran(JobLibraryCran value)
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-databricks.job.JobLibraryOutputReference.putCran.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-databricks.job.JobLibraryCran">JobLibraryCran</a>

---

##### `putMaven` <a name="putMaven" id="@cdktf/provider-databricks.job.JobLibraryOutputReference.putMaven"></a>

```java
public void putMaven(JobLibraryMaven value)
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-databricks.job.JobLibraryOutputReference.putMaven.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-databricks.job.JobLibraryMaven">JobLibraryMaven</a>

---

##### `putPypi` <a name="putPypi" id="@cdktf/provider-databricks.job.JobLibraryOutputReference.putPypi"></a>

```java
public void putPypi(JobLibraryPypi value)
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-databricks.job.JobLibraryOutputReference.putPypi.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-databricks.job.JobLibraryPypi">JobLibraryPypi</a>

---

##### `resetCran` <a name="resetCran" id="@cdktf/provider-databricks.job.JobLibraryOutputReference.resetCran"></a>

```java
public void resetCran()
```

##### `resetEgg` <a name="resetEgg" id="@cdktf/provider-databricks.job.JobLibraryOutputReference.resetEgg"></a>

```java
public void resetEgg()
```

##### `resetJar` <a name="resetJar" id="@cdktf/provider-databricks.job.JobLibraryOutputReference.resetJar"></a>

```java
public void resetJar()
```

##### `resetMaven` <a name="resetMaven" id="@cdktf/provider-databricks.job.JobLibraryOutputReference.resetMaven"></a>

```java
public void resetMaven()
```

##### `resetPypi` <a name="resetPypi" id="@cdktf/provider-databricks.job.JobLibraryOutputReference.resetPypi"></a>

```java
public void resetPypi()
```

##### `resetWhl` <a name="resetWhl" id="@cdktf/provider-databricks.job.JobLibraryOutputReference.resetWhl"></a>

```java
public void resetWhl()
```


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryOutputReference.property.creationStack">creationStack</a></code> | <code>java.util.List<java.lang.String></code> | The creation stack of this resolvable which will be appended to errors thrown during resolution. |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryOutputReference.property.fqn">fqn</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryOutputReference.property.cran">cran</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobLibraryCranOutputReference">JobLibraryCranOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryOutputReference.property.maven">maven</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobLibraryMavenOutputReference">JobLibraryMavenOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryOutputReference.property.pypi">pypi</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobLibraryPypiOutputReference">JobLibraryPypiOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryOutputReference.property.cranInput">cranInput</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobLibraryCran">JobLibraryCran</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryOutputReference.property.eggInput">eggInput</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryOutputReference.property.jarInput">jarInput</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryOutputReference.property.mavenInput">mavenInput</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobLibraryMaven">JobLibraryMaven</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryOutputReference.property.pypiInput">pypiInput</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobLibraryPypi">JobLibraryPypi</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryOutputReference.property.whlInput">whlInput</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryOutputReference.property.egg">egg</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryOutputReference.property.jar">jar</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryOutputReference.property.whl">whl</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryOutputReference.property.internalValue">internalValue</a></code> | <code><a href="#@cdktf/provider-databricks.job.JobLibrary">JobLibrary</a> OR com.hashicorp.cdktf.IResolvable</code> | *No description.* |

---

##### `creationStack`<sup>Required</sup> <a name="creationStack" id="@cdktf/provider-databricks.job.JobLibraryOutputReference.property.creationStack"></a>

```java
public java.util.List<java.lang.String> getCreationStack();
```

- *Type:* java.util.List<java.lang.String>

The creation stack of this resolvable which will be appended to errors thrown during resolution.

If this returns an empty array the stack will not be attached.

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-databricks.job.JobLibraryOutputReference.property.fqn"></a>

```java
public java.lang.String getFqn();
```

- *Type:* java.lang.String

---

##### `cran`<sup>Required</sup> <a name="cran" id="@cdktf/provider-databricks.job.JobLibraryOutputReference.property.cran"></a>

```java
public JobLibraryCranOutputReference getCran();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobLibraryCranOutputReference">JobLibraryCranOutputReference</a>

---

##### `maven`<sup>Required</sup> <a name="maven" id="@cdktf/provider-databricks.job.JobLibraryOutputReference.property.maven"></a>

```java
public JobLibraryMavenOutputReference getMaven();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobLibraryMavenOutputReference">JobLibraryMavenOutputReference</a>

---

##### `pypi`<sup>Required</sup> <a name="pypi" id="@cdktf/provider-databricks.job.JobLibraryOutputReference.property.pypi"></a>

```java
public JobLibraryPypiOutputReference getPypi();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobLibraryPypiOutputReference">JobLibraryPypiOutputReference</a>

---

##### `cranInput`<sup>Optional</sup> <a name="cranInput" id="@cdktf/provider-databricks.job.JobLibraryOutputReference.property.cranInput"></a>

```java
public JobLibraryCran getCranInput();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobLibraryCran">JobLibraryCran</a>

---

##### `eggInput`<sup>Optional</sup> <a name="eggInput" id="@cdktf/provider-databricks.job.JobLibraryOutputReference.property.eggInput"></a>

```java
public java.lang.String getEggInput();
```

- *Type:* java.lang.String

---

##### `jarInput`<sup>Optional</sup> <a name="jarInput" id="@cdktf/provider-databricks.job.JobLibraryOutputReference.property.jarInput"></a>

```java
public java.lang.String getJarInput();
```

- *Type:* java.lang.String

---

##### `mavenInput`<sup>Optional</sup> <a name="mavenInput" id="@cdktf/provider-databricks.job.JobLibraryOutputReference.property.mavenInput"></a>

```java
public JobLibraryMaven getMavenInput();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobLibraryMaven">JobLibraryMaven</a>

---

##### `pypiInput`<sup>Optional</sup> <a name="pypiInput" id="@cdktf/provider-databricks.job.JobLibraryOutputReference.property.pypiInput"></a>

```java
public JobLibraryPypi getPypiInput();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobLibraryPypi">JobLibraryPypi</a>

---

##### `whlInput`<sup>Optional</sup> <a name="whlInput" id="@cdktf/provider-databricks.job.JobLibraryOutputReference.property.whlInput"></a>

```java
public java.lang.String getWhlInput();
```

- *Type:* java.lang.String

---

##### `egg`<sup>Required</sup> <a name="egg" id="@cdktf/provider-databricks.job.JobLibraryOutputReference.property.egg"></a>

```java
public java.lang.String getEgg();
```

- *Type:* java.lang.String

---

##### `jar`<sup>Required</sup> <a name="jar" id="@cdktf/provider-databricks.job.JobLibraryOutputReference.property.jar"></a>

```java
public java.lang.String getJar();
```

- *Type:* java.lang.String

---

##### `whl`<sup>Required</sup> <a name="whl" id="@cdktf/provider-databricks.job.JobLibraryOutputReference.property.whl"></a>

```java
public java.lang.String getWhl();
```

- *Type:* java.lang.String

---

##### `internalValue`<sup>Optional</sup> <a name="internalValue" id="@cdktf/provider-databricks.job.JobLibraryOutputReference.property.internalValue"></a>

```java
public java.lang.Object getInternalValue();
```

- *Type:* <a href="#@cdktf/provider-databricks.job.JobLibrary">JobLibrary</a> OR com.hashicorp.cdktf.IResolvable

---


### JobLibraryPypiOutputReference <a name="JobLibraryPypiOutputReference" id="@cdktf/provider-databricks.job.JobLibraryPypiOutputReference"></a>

#### Initializers <a name="Initializers" id="@cdktf/provider-databricks.job.JobLibraryPypiOutputReference.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.databricks.job.JobLibraryPypiOutputReference;

new JobLibraryPypiOutputReference(IInterpolatingParent terraformResource, java.lang.String terraformAttribute);
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryPypiOutputReference.Initializer.parameter.terraformResource">terraformResource</a></code> | <code>com.hashicorp.cdktf.IInterpolatingParent</code> | The parent resource. |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryPypiOutputReference.Initializer.parameter.terraformAttribute">terraformAttribute</a></code> | <code>java.lang.String</code> | The attribute on the parent resource this class is referencing. |

---

##### `terraformResource`<sup>Required</sup> <a name="terraformResource" id="@cdktf/provider-databricks.job.JobLibraryPypiOutputReference.Initializer.parameter.terraformResource"></a>

- *Type:* com.hashicorp.cdktf.IInterpolatingParent

The parent resource.

---

##### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-databricks.job.JobLibraryPypiOutputReference.Initializer.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

The attribute on the parent resource this class is referencing.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryPypiOutputReference.computeFqn">computeFqn</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryPypiOutputReference.getAnyMapAttribute">getAnyMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryPypiOutputReference.getBooleanAttribute">getBooleanAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryPypiOutputReference.getBooleanMapAttribute">getBooleanMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryPypiOutputReference.getListAttribute">getListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryPypiOutputReference.getNumberAttribute">getNumberAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryPypiOutputReference.getNumberListAttribute">getNumberListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryPypiOutputReference.getNumberMapAttribute">getNumberMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryPypiOutputReference.getStringAttribute">getStringAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryPypiOutputReference.getStringMapAttribute">getStringMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-databricks.job.JobLibraryPypiOutputReference.interpolationForAttribute">interpolationForAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/prov