import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ClusterPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Policy definition JSON document expressed in
  Databricks Policy Definition Language.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster_policy#definition ClusterPolicy#definition}
    */
    readonly definition: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster_policy#id ClusterPolicy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Max number of clusters per user that can be active
  using this policy. If not present, there is no max limit.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster_policy#max_clusters_per_user ClusterPolicy#max_clusters_per_user}
    */
    readonly maxClustersPerUser?: number;
    /**
    * Cluster policy name. This must be unique.
  Length must be between 1 and 100 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster_policy#name ClusterPolicy#name}
    */
    readonly name: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/databricks/r/cluster_policy databricks_cluster_policy}
*/
export declare class ClusterPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType = "databricks_cluster_policy";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/databricks/r/cluster_policy databricks_cluster_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ClusterPolicyConfig
    */
    constructor(scope: Construct, id: string, config: ClusterPolicyConfig);
    private _definition?;
    get definition(): string;
    set definition(value: string);
    get definitionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _maxClustersPerUser?;
    get maxClustersPerUser(): number;
    set maxClustersPerUser(value: number);
    resetMaxClustersPerUser(): void;
    get maxClustersPerUserInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get policyId(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
