import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ClusterConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster#apply_policy_default_values Cluster#apply_policy_default_values}
    */
    readonly applyPolicyDefaultValues?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster#autotermination_minutes Cluster#autotermination_minutes}
    */
    readonly autoterminationMinutes?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster#cluster_id Cluster#cluster_id}
    */
    readonly clusterId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster#cluster_name Cluster#cluster_name}
    */
    readonly clusterName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster#custom_tags Cluster#custom_tags}
    */
    readonly customTags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster#data_security_mode Cluster#data_security_mode}
    */
    readonly dataSecurityMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster#driver_instance_pool_id Cluster#driver_instance_pool_id}
    */
    readonly driverInstancePoolId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster#driver_node_type_id Cluster#driver_node_type_id}
    */
    readonly driverNodeTypeId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster#enable_elastic_disk Cluster#enable_elastic_disk}
    */
    readonly enableElasticDisk?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster#enable_local_disk_encryption Cluster#enable_local_disk_encryption}
    */
    readonly enableLocalDiskEncryption?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster#id Cluster#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster#idempotency_token Cluster#idempotency_token}
    */
    readonly idempotencyToken?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster#instance_pool_id Cluster#instance_pool_id}
    */
    readonly instancePoolId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster#is_pinned Cluster#is_pinned}
    */
    readonly isPinned?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster#node_type_id Cluster#node_type_id}
    */
    readonly nodeTypeId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster#num_workers Cluster#num_workers}
    */
    readonly numWorkers?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster#policy_id Cluster#policy_id}
    */
    readonly policyId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster#runtime_engine Cluster#runtime_engine}
    */
    readonly runtimeEngine?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster#single_user_name Cluster#single_user_name}
    */
    readonly singleUserName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster#spark_conf Cluster#spark_conf}
    */
    readonly sparkConf?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster#spark_env_vars Cluster#spark_env_vars}
    */
    readonly sparkEnvVars?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster#spark_version Cluster#spark_version}
    */
    readonly sparkVersion: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster#ssh_public_keys Cluster#ssh_public_keys}
    */
    readonly sshPublicKeys?: string[];
    /**
    * autoscale block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster#autoscale Cluster#autoscale}
    */
    readonly autoscale?: ClusterAutoscale;
    /**
    * aws_attributes block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster#aws_attributes Cluster#aws_attributes}
    */
    readonly awsAttributes?: ClusterAwsAttributes;
    /**
    * azure_attributes block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster#azure_attributes Cluster#azure_attributes}
    */
    readonly azureAttributes?: ClusterAzureAttributes;
    /**
    * cluster_log_conf block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster#cluster_log_conf Cluster#cluster_log_conf}
    */
    readonly clusterLogConf?: ClusterClusterLogConf;
    /**
    * cluster_mount_info block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster#cluster_mount_info Cluster#cluster_mount_info}
    */
    readonly clusterMountInfo?: ClusterClusterMountInfo[] | cdktf.IResolvable;
    /**
    * docker_image block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster#docker_image Cluster#docker_image}
    */
    readonly dockerImage?: ClusterDockerImage;
    /**
    * gcp_attributes block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster#gcp_attributes Cluster#gcp_attributes}
    */
    readonly gcpAttributes?: ClusterGcpAttributes;
    /**
    * init_scripts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster#init_scripts Cluster#init_scripts}
    */
    readonly initScripts?: ClusterInitScripts[] | cdktf.IResolvable;
    /**
    * library block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster#library Cluster#library}
    */
    readonly library?: ClusterLibrary[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster#timeouts Cluster#timeouts}
    */
    readonly timeouts?: ClusterTimeouts;
    /**
    * workload_type block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster#workload_type Cluster#workload_type}
    */
    readonly workloadType?: ClusterWorkloadType;
}
export interface ClusterAutoscale {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster#max_workers Cluster#max_workers}
    */
    readonly maxWorkers?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster#min_workers Cluster#min_workers}
    */
    readonly minWorkers?: number;
}
export declare function clusterAutoscaleToTerraform(struct?: ClusterAutoscaleOutputReference | ClusterAutoscale): any;
export declare class ClusterAutoscaleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ClusterAutoscale | undefined;
    set internalValue(value: ClusterAutoscale | undefined);
    private _maxWorkers?;
    get maxWorkers(): number;
    set maxWorkers(value: number);
    resetMaxWorkers(): void;
    get maxWorkersInput(): number | undefined;
    private _minWorkers?;
    get minWorkers(): number;
    set minWorkers(value: number);
    resetMinWorkers(): void;
    get minWorkersInput(): number | undefined;
}
export interface ClusterAwsAttributes {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster#availability Cluster#availability}
    */
    readonly availability?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster#ebs_volume_count Cluster#ebs_volume_count}
    */
    readonly ebsVolumeCount?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster#ebs_volume_size Cluster#ebs_volume_size}
    */
    readonly ebsVolumeSize?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster#ebs_volume_type Cluster#ebs_volume_type}
    */
    readonly ebsVolumeType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster#first_on_demand Cluster#first_on_demand}
    */
    readonly firstOnDemand?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster#instance_profile_arn Cluster#instance_profile_arn}
    */
    readonly instanceProfileArn?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster#spot_bid_price_percent Cluster#spot_bid_price_percent}
    */
    readonly spotBidPricePercent?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster#zone_id Cluster#zone_id}
    */
    readonly zoneId?: string;
}
export declare function clusterAwsAttributesToTerraform(struct?: ClusterAwsAttributesOutputReference | ClusterAwsAttributes): any;
export declare class ClusterAwsAttributesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ClusterAwsAttributes | undefined;
    set internalValue(value: ClusterAwsAttributes | undefined);
    private _availability?;
    get availability(): string;
    set availability(value: string);
    resetAvailability(): void;
    get availabilityInput(): string | undefined;
    private _ebsVolumeCount?;
    get ebsVolumeCount(): number;
    set ebsVolumeCount(value: number);
    resetEbsVolumeCount(): void;
    get ebsVolumeCountInput(): number | undefined;
    private _ebsVolumeSize?;
    get ebsVolumeSize(): number;
    set ebsVolumeSize(value: number);
    resetEbsVolumeSize(): void;
    get ebsVolumeSizeInput(): number | undefined;
    private _ebsVolumeType?;
    get ebsVolumeType(): string;
    set ebsVolumeType(value: string);
    resetEbsVolumeType(): void;
    get ebsVolumeTypeInput(): string | undefined;
    private _firstOnDemand?;
    get firstOnDemand(): number;
    set firstOnDemand(value: number);
    resetFirstOnDemand(): void;
    get firstOnDemandInput(): number | undefined;
    private _instanceProfileArn?;
    get instanceProfileArn(): string;
    set instanceProfileArn(value: string);
    resetInstanceProfileArn(): void;
    get instanceProfileArnInput(): string | undefined;
    private _spotBidPricePercent?;
    get spotBidPricePercent(): number;
    set spotBidPricePercent(value: number);
    resetSpotBidPricePercent(): void;
    get spotBidPricePercentInput(): number | undefined;
    private _zoneId?;
    get zoneId(): string;
    set zoneId(value: string);
    resetZoneId(): void;
    get zoneIdInput(): string | undefined;
}
export interface ClusterAzureAttributes {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster#availability Cluster#availability}
    */
    readonly availability?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster#first_on_demand Cluster#first_on_demand}
    */
    readonly firstOnDemand?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster#spot_bid_max_price Cluster#spot_bid_max_price}
    */
    readonly spotBidMaxPrice?: number;
}
export declare function clusterAzureAttributesToTerraform(struct?: ClusterAzureAttributesOutputReference | ClusterAzureAttributes): any;
export declare class ClusterAzureAttributesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ClusterAzureAttributes | undefined;
    set internalValue(value: ClusterAzureAttributes | undefined);
    private _availability?;
    get availability(): string;
    set availability(value: string);
    resetAvailability(): void;
    get availabilityInput(): string | undefined;
    private _firstOnDemand?;
    get firstOnDemand(): number;
    set firstOnDemand(value: number);
    resetFirstOnDemand(): void;
    get firstOnDemandInput(): number | undefined;
    private _spotBidMaxPrice?;
    get spotBidMaxPrice(): number;
    set spotBidMaxPrice(value: number);
    resetSpotBidMaxPrice(): void;
    get spotBidMaxPriceInput(): number | undefined;
}
export interface ClusterClusterLogConfDbfs {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster#destination Cluster#destination}
    */
    readonly destination: string;
}
export declare function clusterClusterLogConfDbfsToTerraform(struct?: ClusterClusterLogConfDbfsOutputReference | ClusterClusterLogConfDbfs): any;
export declare class ClusterClusterLogConfDbfsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ClusterClusterLogConfDbfs | undefined;
    set internalValue(value: ClusterClusterLogConfDbfs | undefined);
    private _destination?;
    get destination(): string;
    set destination(value: string);
    get destinationInput(): string | undefined;
}
export interface ClusterClusterLogConfS3 {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster#canned_acl Cluster#canned_acl}
    */
    readonly cannedAcl?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster#destination Cluster#destination}
    */
    readonly destination: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster#enable_encryption Cluster#enable_encryption}
    */
    readonly enableEncryption?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster#encryption_type Cluster#encryption_type}
    */
    readonly encryptionType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster#endpoint Cluster#endpoint}
    */
    readonly endpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster#kms_key Cluster#kms_key}
    */
    readonly kmsKey?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster#region Cluster#region}
    */
    readonly region?: string;
}
export declare function clusterClusterLogConfS3ToTerraform(struct?: ClusterClusterLogConfS3OutputReference | ClusterClusterLogConfS3): any;
export declare class ClusterClusterLogConfS3OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ClusterClusterLogConfS3 | undefined;
    set internalValue(value: ClusterClusterLogConfS3 | undefined);
    private _cannedAcl?;
    get cannedAcl(): string;
    set cannedAcl(value: string);
    resetCannedAcl(): void;
    get cannedAclInput(): string | undefined;
    private _destination?;
    get destination(): string;
    set destination(value: string);
    get destinationInput(): string | undefined;
    private _enableEncryption?;
    get enableEncryption(): boolean | cdktf.IResolvable;
    set enableEncryption(value: boolean | cdktf.IResolvable);
    resetEnableEncryption(): void;
    get enableEncryptionInput(): boolean | cdktf.IResolvable | undefined;
    private _encryptionType?;
    get encryptionType(): string;
    set encryptionType(value: string);
    resetEncryptionType(): void;
    get encryptionTypeInput(): string | undefined;
    private _endpoint?;
    get endpoint(): string;
    set endpoint(value: string);
    resetEndpoint(): void;
    get endpointInput(): string | undefined;
    private _kmsKey?;
    get kmsKey(): string;
    set kmsKey(value: string);
    resetKmsKey(): void;
    get kmsKeyInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
}
export interface ClusterClusterLogConf {
    /**
    * dbfs block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster#dbfs Cluster#dbfs}
    */
    readonly dbfs?: ClusterClusterLogConfDbfs;
    /**
    * s3 block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster#s3 Cluster#s3}
    */
    readonly s3?: ClusterClusterLogConfS3;
}
export declare function clusterClusterLogConfToTerraform(struct?: ClusterClusterLogConfOutputReference | ClusterClusterLogConf): any;
export declare class ClusterClusterLogConfOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ClusterClusterLogConf | undefined;
    set internalValue(value: ClusterClusterLogConf | undefined);
    private _dbfs;
    get dbfs(): ClusterClusterLogConfDbfsOutputReference;
    putDbfs(value: ClusterClusterLogConfDbfs): void;
    resetDbfs(): void;
    get dbfsInput(): ClusterClusterLogConfDbfs | undefined;
    private _s3;
    get s3(): ClusterClusterLogConfS3OutputReference;
    putS3(value: ClusterClusterLogConfS3): void;
    resetS3(): void;
    get s3Input(): ClusterClusterLogConfS3 | undefined;
}
export interface ClusterClusterMountInfoNetworkFilesystemInfo {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster#mount_options Cluster#mount_options}
    */
    readonly mountOptions?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster#server_address Cluster#server_address}
    */
    readonly serverAddress: string;
}
export declare function clusterClusterMountInfoNetworkFilesystemInfoToTerraform(struct?: ClusterClusterMountInfoNetworkFilesystemInfoOutputReference | ClusterClusterMountInfoNetworkFilesystemInfo): any;
export declare class ClusterClusterMountInfoNetworkFilesystemInfoOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ClusterClusterMountInfoNetworkFilesystemInfo | undefined;
    set internalValue(value: ClusterClusterMountInfoNetworkFilesystemInfo | undefined);
    private _mountOptions?;
    get mountOptions(): string;
    set mountOptions(value: string);
    resetMountOptions(): void;
    get mountOptionsInput(): string | undefined;
    private _serverAddress?;
    get serverAddress(): string;
    set serverAddress(value: string);
    get serverAddressInput(): string | undefined;
}
export interface ClusterClusterMountInfo {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster#local_mount_dir_path Cluster#local_mount_dir_path}
    */
    readonly localMountDirPath: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster#remote_mount_dir_path Cluster#remote_mount_dir_path}
    */
    readonly remoteMountDirPath?: string;
    /**
    * network_filesystem_info block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster#network_filesystem_info Cluster#network_filesystem_info}
    */
    readonly networkFilesystemInfo: ClusterClusterMountInfoNetworkFilesystemInfo;
}
export declare function clusterClusterMountInfoToTerraform(struct?: ClusterClusterMountInfo | cdktf.IResolvable): any;
export declare class ClusterClusterMountInfoOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ClusterClusterMountInfo | cdktf.IResolvable | undefined;
    set internalValue(value: ClusterClusterMountInfo | cdktf.IResolvable | undefined);
    private _localMountDirPath?;
    get localMountDirPath(): string;
    set localMountDirPath(value: string);
    get localMountDirPathInput(): string | undefined;
    private _remoteMountDirPath?;
    get remoteMountDirPath(): string;
    set remoteMountDirPath(value: string);
    resetRemoteMountDirPath(): void;
    get remoteMountDirPathInput(): string | undefined;
    private _networkFilesystemInfo;
    get networkFilesystemInfo(): ClusterClusterMountInfoNetworkFilesystemInfoOutputReference;
    putNetworkFilesystemInfo(value: ClusterClusterMountInfoNetworkFilesystemInfo): void;
    get networkFilesystemInfoInput(): ClusterClusterMountInfoNetworkFilesystemInfo | undefined;
}
export declare class ClusterClusterMountInfoList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ClusterClusterMountInfo[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ClusterClusterMountInfoOutputReference;
}
export interface ClusterDockerImageBasicAuth {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster#password Cluster#password}
    */
    readonly password: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster#username Cluster#username}
    */
    readonly username: string;
}
export declare function clusterDockerImageBasicAuthToTerraform(struct?: ClusterDockerImageBasicAuthOutputReference | ClusterDockerImageBasicAuth): any;
export declare class ClusterDockerImageBasicAuthOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ClusterDockerImageBasicAuth | undefined;
    set internalValue(value: ClusterDockerImageBasicAuth | undefined);
    private _password?;
    get password(): string;
    set password(value: string);
    get passwordInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
}
export interface ClusterDockerImage {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster#url Cluster#url}
    */
    readonly url: string;
    /**
    * basic_auth block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster#basic_auth Cluster#basic_auth}
    */
    readonly basicAuth?: ClusterDockerImageBasicAuth;
}
export declare function clusterDockerImageToTerraform(struct?: ClusterDockerImageOutputReference | ClusterDockerImage): any;
export declare class ClusterDockerImageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ClusterDockerImage | undefined;
    set internalValue(value: ClusterDockerImage | undefined);
    private _url?;
    get url(): string;
    set url(value: string);
    get urlInput(): string | undefined;
    private _basicAuth;
    get basicAuth(): ClusterDockerImageBasicAuthOutputReference;
    putBasicAuth(value: ClusterDockerImageBasicAuth): void;
    resetBasicAuth(): void;
    get basicAuthInput(): ClusterDockerImageBasicAuth | undefined;
}
export interface ClusterGcpAttributes {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster#availability Cluster#availability}
    */
    readonly availability?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster#boot_disk_size Cluster#boot_disk_size}
    */
    readonly bootDiskSize?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster#google_service_account Cluster#google_service_account}
    */
    readonly googleServiceAccount?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster#use_preemptible_executors Cluster#use_preemptible_executors}
    */
    readonly usePreemptibleExecutors?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster#zone_id Cluster#zone_id}
    */
    readonly zoneId?: string;
}
export declare function clusterGcpAttributesToTerraform(struct?: ClusterGcpAttributesOutputReference | ClusterGcpAttributes): any;
export declare class ClusterGcpAttributesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ClusterGcpAttributes | undefined;
    set internalValue(value: ClusterGcpAttributes | undefined);
    private _availability?;
    get availability(): string;
    set availability(value: string);
    resetAvailability(): void;
    get availabilityInput(): string | undefined;
    private _bootDiskSize?;
    get bootDiskSize(): number;
    set bootDiskSize(value: number);
    resetBootDiskSize(): void;
    get bootDiskSizeInput(): number | undefined;
    private _googleServiceAccount?;
    get googleServiceAccount(): string;
    set googleServiceAccount(value: string);
    resetGoogleServiceAccount(): void;
    get googleServiceAccountInput(): string | undefined;
    private _usePreemptibleExecutors?;
    get usePreemptibleExecutors(): boolean | cdktf.IResolvable;
    set usePreemptibleExecutors(value: boolean | cdktf.IResolvable);
    resetUsePreemptibleExecutors(): void;
    get usePreemptibleExecutorsInput(): boolean | cdktf.IResolvable | undefined;
    private _zoneId?;
    get zoneId(): string;
    set zoneId(value: string);
    resetZoneId(): void;
    get zoneIdInput(): string | undefined;
}
export interface ClusterInitScriptsAbfss {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster#destination Cluster#destination}
    */
    readonly destination?: string;
}
export declare function clusterInitScriptsAbfssToTerraform(struct?: ClusterInitScriptsAbfssOutputReference | ClusterInitScriptsAbfss): any;
export declare class ClusterInitScriptsAbfssOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ClusterInitScriptsAbfss | undefined;
    set internalValue(value: ClusterInitScriptsAbfss | undefined);
    private _destination?;
    get destination(): string;
    set destination(value: string);
    resetDestination(): void;
    get destinationInput(): string | undefined;
}
export interface ClusterInitScriptsDbfs {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster#destination Cluster#destination}
    */
    readonly destination: string;
}
export declare function clusterInitScriptsDbfsToTerraform(struct?: ClusterInitScriptsDbfsOutputReference | ClusterInitScriptsDbfs): any;
export declare class ClusterInitScriptsDbfsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ClusterInitScriptsDbfs | undefined;
    set internalValue(value: ClusterInitScriptsDbfs | undefined);
    private _destination?;
    get destination(): string;
    set destination(value: string);
    get destinationInput(): string | undefined;
}
export interface ClusterInitScriptsFile {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster#destination Cluster#destination}
    */
    readonly destination?: string;
}
export declare function clusterInitScriptsFileToTerraform(struct?: ClusterInitScriptsFileOutputReference | ClusterInitScriptsFile): any;
export declare class ClusterInitScriptsFileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ClusterInitScriptsFile | undefined;
    set internalValue(value: ClusterInitScriptsFile | undefined);
    private _destination?;
    get destination(): string;
    set destination(value: string);
    resetDestination(): void;
    get destinationInput(): string | undefined;
}
export interface ClusterInitScriptsGcs {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster#destination Cluster#destination}
    */
    readonly destination?: string;
}
export declare function clusterInitScriptsGcsToTerraform(struct?: ClusterInitScriptsGcsOutputReference | ClusterInitScriptsGcs): any;
export declare class ClusterInitScriptsGcsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ClusterInitScriptsGcs | undefined;
    set internalValue(value: ClusterInitScriptsGcs | undefined);
    private _destination?;
    get destination(): string;
    set destination(value: string);
    resetDestination(): void;
    get destinationInput(): string | undefined;
}
export interface ClusterInitScriptsS3 {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster#canned_acl Cluster#canned_acl}
    */
    readonly cannedAcl?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster#destination Cluster#destination}
    */
    readonly destination: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster#enable_encryption Cluster#enable_encryption}
    */
    readonly enableEncryption?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster#encryption_type Cluster#encryption_type}
    */
    readonly encryptionType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster#endpoint Cluster#endpoint}
    */
    readonly endpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster#kms_key Cluster#kms_key}
    */
    readonly kmsKey?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster#region Cluster#region}
    */
    readonly region?: string;
}
export declare function clusterInitScriptsS3ToTerraform(struct?: ClusterInitScriptsS3OutputReference | ClusterInitScriptsS3): any;
export declare class ClusterInitScriptsS3OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ClusterInitScriptsS3 | undefined;
    set internalValue(value: ClusterInitScriptsS3 | undefined);
    private _cannedAcl?;
    get cannedAcl(): string;
    set cannedAcl(value: string);
    resetCannedAcl(): void;
    get cannedAclInput(): string | undefined;
    private _destination?;
    get destination(): string;
    set destination(value: string);
    get destinationInput(): string | undefined;
    private _enableEncryption?;
    get enableEncryption(): boolean | cdktf.IResolvable;
    set enableEncryption(value: boolean | cdktf.IResolvable);
    resetEnableEncryption(): void;
    get enableEncryptionInput(): boolean | cdktf.IResolvable | undefined;
    private _encryptionType?;
    get encryptionType(): string;
    set encryptionType(value: string);
    resetEncryptionType(): void;
    get encryptionTypeInput(): string | undefined;
    private _endpoint?;
    get endpoint(): string;
    set endpoint(value: string);
    resetEndpoint(): void;
    get endpointInput(): string | undefined;
    private _kmsKey?;
    get kmsKey(): string;
    set kmsKey(value: string);
    resetKmsKey(): void;
    get kmsKeyInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
}
export interface ClusterInitScripts {
    /**
    * abfss block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster#abfss Cluster#abfss}
    */
    readonly abfss?: ClusterInitScriptsAbfss;
    /**
    * dbfs block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster#dbfs Cluster#dbfs}
    */
    readonly dbfs?: ClusterInitScriptsDbfs;
    /**
    * file block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster#file Cluster#file}
    */
    readonly file?: ClusterInitScriptsFile;
    /**
    * gcs block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster#gcs Cluster#gcs}
    */
    readonly gcs?: ClusterInitScriptsGcs;
    /**
    * s3 block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster#s3 Cluster#s3}
    */
    readonly s3?: ClusterInitScriptsS3;
}
export declare function clusterInitScriptsToTerraform(struct?: ClusterInitScripts | cdktf.IResolvable): any;
export declare class ClusterInitScriptsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ClusterInitScripts | cdktf.IResolvable | undefined;
    set internalValue(value: ClusterInitScripts | cdktf.IResolvable | undefined);
    private _abfss;
    get abfss(): ClusterInitScriptsAbfssOutputReference;
    putAbfss(value: ClusterInitScriptsAbfss): void;
    resetAbfss(): void;
    get abfssInput(): ClusterInitScriptsAbfss | undefined;
    private _dbfs;
    get dbfs(): ClusterInitScriptsDbfsOutputReference;
    putDbfs(value: ClusterInitScriptsDbfs): void;
    resetDbfs(): void;
    get dbfsInput(): ClusterInitScriptsDbfs | undefined;
    private _file;
    get file(): ClusterInitScriptsFileOutputReference;
    putFile(value: ClusterInitScriptsFile): void;
    resetFile(): void;
    get fileInput(): ClusterInitScriptsFile | undefined;
    private _gcs;
    get gcs(): ClusterInitScriptsGcsOutputReference;
    putGcs(value: ClusterInitScriptsGcs): void;
    resetGcs(): void;
    get gcsInput(): ClusterInitScriptsGcs | undefined;
    private _s3;
    get s3(): ClusterInitScriptsS3OutputReference;
    putS3(value: ClusterInitScriptsS3): void;
    resetS3(): void;
    get s3Input(): ClusterInitScriptsS3 | undefined;
}
export declare class ClusterInitScriptsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ClusterInitScripts[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ClusterInitScriptsOutputReference;
}
export interface ClusterLibraryCran {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster#package Cluster#package}
    */
    readonly package: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster#repo Cluster#repo}
    */
    readonly repo?: string;
}
export declare function clusterLibraryCranToTerraform(struct?: ClusterLibraryCranOutputReference | ClusterLibraryCran): any;
export declare class ClusterLibraryCranOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ClusterLibraryCran | undefined;
    set internalValue(value: ClusterLibraryCran | undefined);
    private _package?;
    get package(): string;
    set package(value: string);
    get packageInput(): string | undefined;
    private _repo?;
    get repo(): string;
    set repo(value: string);
    resetRepo(): void;
    get repoInput(): string | undefined;
}
export interface ClusterLibraryMaven {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster#coordinates Cluster#coordinates}
    */
    readonly coordinates: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster#exclusions Cluster#exclusions}
    */
    readonly exclusions?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster#repo Cluster#repo}
    */
    readonly repo?: string;
}
export declare function clusterLibraryMavenToTerraform(struct?: ClusterLibraryMavenOutputReference | ClusterLibraryMaven): any;
export declare class ClusterLibraryMavenOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ClusterLibraryMaven | undefined;
    set internalValue(value: ClusterLibraryMaven | undefined);
    private _coordinates?;
    get coordinates(): string;
    set coordinates(value: string);
    get coordinatesInput(): string | undefined;
    private _exclusions?;
    get exclusions(): string[];
    set exclusions(value: string[]);
    resetExclusions(): void;
    get exclusionsInput(): string[] | undefined;
    private _repo?;
    get repo(): string;
    set repo(value: string);
    resetRepo(): void;
    get repoInput(): string | undefined;
}
export interface ClusterLibraryPypi {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster#package Cluster#package}
    */
    readonly package: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster#repo Cluster#repo}
    */
    readonly repo?: string;
}
export declare function clusterLibraryPypiToTerraform(struct?: ClusterLibraryPypiOutputReference | ClusterLibraryPypi): any;
export declare class ClusterLibraryPypiOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ClusterLibraryPypi | undefined;
    set internalValue(value: ClusterLibraryPypi | undefined);
    private _package?;
    get package(): string;
    set package(value: string);
    get packageInput(): string | undefined;
    private _repo?;
    get repo(): string;
    set repo(value: string);
    resetRepo(): void;
    get repoInput(): string | undefined;
}
export interface ClusterLibrary {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster#egg Cluster#egg}
    */
    readonly egg?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster#jar Cluster#jar}
    */
    readonly jar?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster#whl Cluster#whl}
    */
    readonly whl?: string;
    /**
    * cran block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster#cran Cluster#cran}
    */
    readonly cran?: ClusterLibraryCran;
    /**
    * maven block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster#maven Cluster#maven}
    */
    readonly maven?: ClusterLibraryMaven;
    /**
    * pypi block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster#pypi Cluster#pypi}
    */
    readonly pypi?: ClusterLibraryPypi;
}
export declare function clusterLibraryToTerraform(struct?: ClusterLibrary | cdktf.IResolvable): any;
export declare class ClusterLibraryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ClusterLibrary | cdktf.IResolvable | undefined;
    set internalValue(value: ClusterLibrary | cdktf.IResolvable | undefined);
    private _egg?;
    get egg(): string;
    set egg(value: string);
    resetEgg(): void;
    get eggInput(): string | undefined;
    private _jar?;
    get jar(): string;
    set jar(value: string);
    resetJar(): void;
    get jarInput(): string | undefined;
    private _whl?;
    get whl(): string;
    set whl(value: string);
    resetWhl(): void;
    get whlInput(): string | undefined;
    private _cran;
    get cran(): ClusterLibraryCranOutputReference;
    putCran(value: ClusterLibraryCran): void;
    resetCran(): void;
    get cranInput(): ClusterLibraryCran | undefined;
    private _maven;
    get maven(): ClusterLibraryMavenOutputReference;
    putMaven(value: ClusterLibraryMaven): void;
    resetMaven(): void;
    get mavenInput(): ClusterLibraryMaven | undefined;
    private _pypi;
    get pypi(): ClusterLibraryPypiOutputReference;
    putPypi(value: ClusterLibraryPypi): void;
    resetPypi(): void;
    get pypiInput(): ClusterLibraryPypi | undefined;
}
export declare class ClusterLibraryList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ClusterLibrary[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ClusterLibraryOutputReference;
}
export interface ClusterTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster#create Cluster#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster#delete Cluster#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster#update Cluster#update}
    */
    readonly update?: string;
}
export declare function clusterTimeoutsToTerraform(struct?: ClusterTimeoutsOutputReference | ClusterTimeouts | cdktf.IResolvable): any;
export declare class ClusterTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ClusterTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ClusterTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface ClusterWorkloadTypeClients {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster#jobs Cluster#jobs}
    */
    readonly jobs?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster#notebooks Cluster#notebooks}
    */
    readonly notebooks?: boolean | cdktf.IResolvable;
}
export declare function clusterWorkloadTypeClientsToTerraform(struct?: ClusterWorkloadTypeClientsOutputReference | ClusterWorkloadTypeClients): any;
export declare class ClusterWorkloadTypeClientsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ClusterWorkloadTypeClients | undefined;
    set internalValue(value: ClusterWorkloadTypeClients | undefined);
    private _jobs?;
    get jobs(): boolean | cdktf.IResolvable;
    set jobs(value: boolean | cdktf.IResolvable);
    resetJobs(): void;
    get jobsInput(): boolean | cdktf.IResolvable | undefined;
    private _notebooks?;
    get notebooks(): boolean | cdktf.IResolvable;
    set notebooks(value: boolean | cdktf.IResolvable);
    resetNotebooks(): void;
    get notebooksInput(): boolean | cdktf.IResolvable | undefined;
}
export interface ClusterWorkloadType {
    /**
    * clients block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/cluster#clients Cluster#clients}
    */
    readonly clients: ClusterWorkloadTypeClients;
}
export declare function clusterWorkloadTypeToTerraform(struct?: ClusterWorkloadTypeOutputReference | ClusterWorkloadType): any;
export declare class ClusterWorkloadTypeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ClusterWorkloadType | undefined;
    set internalValue(value: ClusterWorkloadType | undefined);
    private _clients;
    get clients(): ClusterWorkloadTypeClientsOutputReference;
    putClients(value: ClusterWorkloadTypeClients): void;
    get clientsInput(): ClusterWorkloadTypeClients | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/databricks/r/cluster databricks_cluster}
*/
export declare class Cluster extends cdktf.TerraformResource {
    static readonly tfResourceType = "databricks_cluster";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/databricks/r/cluster databricks_cluster} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ClusterConfig
    */
    constructor(scope: Construct, id: string, config: ClusterConfig);
    private _applyPolicyDefaultValues?;
    get applyPolicyDefaultValues(): boolean | cdktf.IResolvable;
    set applyPolicyDefaultValues(value: boolean | cdktf.IResolvable);
    resetApplyPolicyDefaultValues(): void;
    get applyPolicyDefaultValuesInput(): boolean | cdktf.IResolvable | undefined;
    private _autoterminationMinutes?;
    get autoterminationMinutes(): number;
    set autoterminationMinutes(value: number);
    resetAutoterminationMinutes(): void;
    get autoterminationMinutesInput(): number | undefined;
    private _clusterId?;
    get clusterId(): string;
    set clusterId(value: string);
    resetClusterId(): void;
    get clusterIdInput(): string | undefined;
    private _clusterName?;
    get clusterName(): string;
    set clusterName(value: string);
    resetClusterName(): void;
    get clusterNameInput(): string | undefined;
    private _customTags?;
    get customTags(): {
        [key: string]: string;
    };
    set customTags(value: {
        [key: string]: string;
    });
    resetCustomTags(): void;
    get customTagsInput(): {
        [key: string]: string;
    } | undefined;
    private _dataSecurityMode?;
    get dataSecurityMode(): string;
    set dataSecurityMode(value: string);
    resetDataSecurityMode(): void;
    get dataSecurityModeInput(): string | undefined;
    private _defaultTags;
    get defaultTags(): cdktf.StringMap;
    private _driverInstancePoolId?;
    get driverInstancePoolId(): string;
    set driverInstancePoolId(value: string);
    resetDriverInstancePoolId(): void;
    get driverInstancePoolIdInput(): string | undefined;
    private _driverNodeTypeId?;
    get driverNodeTypeId(): string;
    set driverNodeTypeId(value: string);
    resetDriverNodeTypeId(): void;
    get driverNodeTypeIdInput(): string | undefined;
    private _enableElasticDisk?;
    get enableElasticDisk(): boolean | cdktf.IResolvable;
    set enableElasticDisk(value: boolean | cdktf.IResolvable);
    resetEnableElasticDisk(): void;
    get enableElasticDiskInput(): boolean | cdktf.IResolvable | undefined;
    private _enableLocalDiskEncryption?;
    get enableLocalDiskEncryption(): boolean | cdktf.IResolvable;
    set enableLocalDiskEncryption(value: boolean | cdktf.IResolvable);
    resetEnableLocalDiskEncryption(): void;
    get enableLocalDiskEncryptionInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _idempotencyToken?;
    get idempotencyToken(): string;
    set idempotencyToken(value: string);
    resetIdempotencyToken(): void;
    get idempotencyTokenInput(): string | undefined;
    private _instancePoolId?;
    get instancePoolId(): string;
    set instancePoolId(value: string);
    resetInstancePoolId(): void;
    get instancePoolIdInput(): string | undefined;
    private _isPinned?;
    get isPinned(): boolean | cdktf.IResolvable;
    set isPinned(value: boolean | cdktf.IResolvable);
    resetIsPinned(): void;
    get isPinnedInput(): boolean | cdktf.IResolvable | undefined;
    private _nodeTypeId?;
    get nodeTypeId(): string;
    set nodeTypeId(value: string);
    resetNodeTypeId(): void;
    get nodeTypeIdInput(): string | undefined;
    private _numWorkers?;
    get numWorkers(): number;
    set numWorkers(value: number);
    resetNumWorkers(): void;
    get numWorkersInput(): number | undefined;
    private _policyId?;
    get policyId(): string;
    set policyId(value: string);
    resetPolicyId(): void;
    get policyIdInput(): string | undefined;
    private _runtimeEngine?;
    get runtimeEngine(): string;
    set runtimeEngine(value: string);
    resetRuntimeEngine(): void;
    get runtimeEngineInput(): string | undefined;
    private _singleUserName?;
    get singleUserName(): string;
    set singleUserName(value: string);
    resetSingleUserName(): void;
    get singleUserNameInput(): string | undefined;
    private _sparkConf?;
    get sparkConf(): {
        [key: string]: string;
    };
    set sparkConf(value: {
        [key: string]: string;
    });
    resetSparkConf(): void;
    get sparkConfInput(): {
        [key: string]: string;
    } | undefined;
    private _sparkEnvVars?;
    get sparkEnvVars(): {
        [key: string]: string;
    };
    set sparkEnvVars(value: {
        [key: string]: string;
    });
    resetSparkEnvVars(): void;
    get sparkEnvVarsInput(): {
        [key: string]: string;
    } | undefined;
    private _sparkVersion?;
    get sparkVersion(): string;
    set sparkVersion(value: string);
    get sparkVersionInput(): string | undefined;
    private _sshPublicKeys?;
    get sshPublicKeys(): string[];
    set sshPublicKeys(value: string[]);
    resetSshPublicKeys(): void;
    get sshPublicKeysInput(): string[] | undefined;
    get state(): string;
    get url(): string;
    private _autoscale;
    get autoscale(): ClusterAutoscaleOutputReference;
    putAutoscale(value: ClusterAutoscale): void;
    resetAutoscale(): void;
    get autoscaleInput(): ClusterAutoscale | undefined;
    private _awsAttributes;
    get awsAttributes(): ClusterAwsAttributesOutputReference;
    putAwsAttributes(value: ClusterAwsAttributes): void;
    resetAwsAttributes(): void;
    get awsAttributesInput(): ClusterAwsAttributes | undefined;
    private _azureAttributes;
    get azureAttributes(): ClusterAzureAttributesOutputReference;
    putAzureAttributes(value: ClusterAzureAttributes): void;
    resetAzureAttributes(): void;
    get azureAttributesInput(): ClusterAzureAttributes | undefined;
    private _clusterLogConf;
    get clusterLogConf(): ClusterClusterLogConfOutputReference;
    putClusterLogConf(value: ClusterClusterLogConf): void;
    resetClusterLogConf(): void;
    get clusterLogConfInput(): ClusterClusterLogConf | undefined;
    private _clusterMountInfo;
    get clusterMountInfo(): ClusterClusterMountInfoList;
    putClusterMountInfo(value: ClusterClusterMountInfo[] | cdktf.IResolvable): void;
    resetClusterMountInfo(): void;
    get clusterMountInfoInput(): cdktf.IResolvable | ClusterClusterMountInfo[] | undefined;
    private _dockerImage;
    get dockerImage(): ClusterDockerImageOutputReference;
    putDockerImage(value: ClusterDockerImage): void;
    resetDockerImage(): void;
    get dockerImageInput(): ClusterDockerImage | undefined;
    private _gcpAttributes;
    get gcpAttributes(): ClusterGcpAttributesOutputReference;
    putGcpAttributes(value: ClusterGcpAttributes): void;
    resetGcpAttributes(): void;
    get gcpAttributesInput(): ClusterGcpAttributes | undefined;
    private _initScripts;
    get initScripts(): ClusterInitScriptsList;
    putInitScripts(value: ClusterInitScripts[] | cdktf.IResolvable): void;
    resetInitScripts(): void;
    get initScriptsInput(): cdktf.IResolvable | ClusterInitScripts[] | undefined;
    private _library;
    get library(): ClusterLibraryList;
    putLibrary(value: ClusterLibrary[] | cdktf.IResolvable): void;
    resetLibrary(): void;
    get libraryInput(): cdktf.IResolvable | ClusterLibrary[] | undefined;
    private _timeouts;
    get timeouts(): ClusterTimeoutsOutputReference;
    putTimeouts(value: ClusterTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ClusterTimeouts | undefined;
    private _workloadType;
    get workloadType(): ClusterWorkloadTypeOutputReference;
    putWorkloadType(value: ClusterWorkloadType): void;
    resetWorkloadType(): void;
    get workloadTypeInput(): ClusterWorkloadType | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
