import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataDatabricksAwsBucketPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/aws_bucket_policy#bucket DataDatabricksAwsBucketPolicy#bucket}
    */
    readonly bucket: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/aws_bucket_policy#databricks_account_id DataDatabricksAwsBucketPolicy#databricks_account_id}
    */
    readonly databricksAccountId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/aws_bucket_policy#databricks_e2_account_id DataDatabricksAwsBucketPolicy#databricks_e2_account_id}
    */
    readonly databricksE2AccountId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/aws_bucket_policy#full_access_role DataDatabricksAwsBucketPolicy#full_access_role}
    */
    readonly fullAccessRole?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/aws_bucket_policy#id DataDatabricksAwsBucketPolicy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/databricks/d/aws_bucket_policy databricks_aws_bucket_policy}
*/
export declare class DataDatabricksAwsBucketPolicy extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "databricks_aws_bucket_policy";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/databricks/d/aws_bucket_policy databricks_aws_bucket_policy} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataDatabricksAwsBucketPolicyConfig
    */
    constructor(scope: Construct, id: string, config: DataDatabricksAwsBucketPolicyConfig);
    private _bucket?;
    get bucket(): string;
    set bucket(value: string);
    get bucketInput(): string | undefined;
    private _databricksAccountId?;
    get databricksAccountId(): string;
    set databricksAccountId(value: string);
    resetDatabricksAccountId(): void;
    get databricksAccountIdInput(): string | undefined;
    private _databricksE2AccountId?;
    get databricksE2AccountId(): string;
    set databricksE2AccountId(value: string);
    resetDatabricksE2AccountId(): void;
    get databricksE2AccountIdInput(): string | undefined;
    private _fullAccessRole?;
    get fullAccessRole(): string;
    set fullAccessRole(value: string);
    resetFullAccessRole(): void;
    get fullAccessRoleInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get json(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
