import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataDatabricksCatalogsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/catalogs#id DataDatabricksCatalogs#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/catalogs#ids DataDatabricksCatalogs#ids}
    */
    readonly ids?: string[];
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/databricks/d/catalogs databricks_catalogs}
*/
export declare class DataDatabricksCatalogs extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "databricks_catalogs";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/databricks/d/catalogs databricks_catalogs} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataDatabricksCatalogsConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataDatabricksCatalogsConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _ids?;
    get ids(): string[];
    set ids(value: string[]);
    resetIds(): void;
    get idsInput(): string[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
