import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataDatabricksClusterPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster_policy#definition DataDatabricksClusterPolicy#definition}
    */
    readonly definition?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster_policy#id DataDatabricksClusterPolicy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster_policy#max_clusters_per_user DataDatabricksClusterPolicy#max_clusters_per_user}
    */
    readonly maxClustersPerUser?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/cluster_policy#name DataDatabricksClusterPolicy#name}
    */
    readonly name?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/databricks/d/cluster_policy databricks_cluster_policy}
*/
export declare class DataDatabricksClusterPolicy extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "databricks_cluster_policy";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/databricks/d/cluster_policy databricks_cluster_policy} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataDatabricksClusterPolicyConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataDatabricksClusterPolicyConfig);
    private _definition?;
    get definition(): string;
    set definition(value: string);
    resetDefinition(): void;
    get definitionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _maxClustersPerUser?;
    get maxClustersPerUser(): number;
    set maxClustersPerUser(value: number);
    resetMaxClustersPerUser(): void;
    get maxClustersPerUserInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
