import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataDatabricksClustersConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/clusters#cluster_name_contains DataDatabricksClusters#cluster_name_contains}
    */
    readonly clusterNameContains?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/clusters#id DataDatabricksClusters#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/databricks/d/clusters databricks_clusters}
*/
export declare class DataDatabricksClusters extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "databricks_clusters";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/databricks/d/clusters databricks_clusters} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataDatabricksClustersConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataDatabricksClustersConfig);
    private _clusterNameContains?;
    get clusterNameContains(): string;
    set clusterNameContains(value: string);
    resetClusterNameContains(): void;
    get clusterNameContainsInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get ids(): string[];
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
