import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataDatabricksCurrentUserConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/current_user#id DataDatabricksCurrentUser#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/databricks/d/current_user databricks_current_user}
*/
export declare class DataDatabricksCurrentUser extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "databricks_current_user";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/databricks/d/current_user databricks_current_user} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataDatabricksCurrentUserConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataDatabricksCurrentUserConfig);
    get alphanumeric(): string;
    get externalId(): string;
    get home(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get repos(): string;
    get userName(): string;
    get workspaceUrl(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
