import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataDatabricksDbfsFilePathsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/dbfs_file_paths#id DataDatabricksDbfsFilePaths#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/dbfs_file_paths#path DataDatabricksDbfsFilePaths#path}
    */
    readonly path: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/dbfs_file_paths#recursive DataDatabricksDbfsFilePaths#recursive}
    */
    readonly recursive: boolean | cdktf.IResolvable;
}
export interface DataDatabricksDbfsFilePathsPathList {
}
export declare function dataDatabricksDbfsFilePathsPathListToTerraform(struct?: DataDatabricksDbfsFilePathsPathList): any;
export declare class DataDatabricksDbfsFilePathsPathListOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDatabricksDbfsFilePathsPathList | undefined;
    set internalValue(value: DataDatabricksDbfsFilePathsPathList | undefined);
    get fileSize(): number;
    get path(): string;
}
export declare class DataDatabricksDbfsFilePathsPathListList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDatabricksDbfsFilePathsPathListOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/databricks/d/dbfs_file_paths databricks_dbfs_file_paths}
*/
export declare class DataDatabricksDbfsFilePaths extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "databricks_dbfs_file_paths";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/databricks/d/dbfs_file_paths databricks_dbfs_file_paths} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataDatabricksDbfsFilePathsConfig
    */
    constructor(scope: Construct, id: string, config: DataDatabricksDbfsFilePathsConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
    private _pathList;
    get pathList(): DataDatabricksDbfsFilePathsPathListList;
    private _recursive?;
    get recursive(): boolean | cdktf.IResolvable;
    set recursive(value: boolean | cdktf.IResolvable);
    get recursiveInput(): boolean | cdktf.IResolvable | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
