import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataDatabricksGroupConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/group#allow_cluster_create DataDatabricksGroup#allow_cluster_create}
    */
    readonly allowClusterCreate?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/group#allow_instance_pool_create DataDatabricksGroup#allow_instance_pool_create}
    */
    readonly allowInstancePoolCreate?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/group#child_groups DataDatabricksGroup#child_groups}
    */
    readonly childGroups?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/group#databricks_sql_access DataDatabricksGroup#databricks_sql_access}
    */
    readonly databricksSqlAccess?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/group#display_name DataDatabricksGroup#display_name}
    */
    readonly displayName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/group#external_id DataDatabricksGroup#external_id}
    */
    readonly externalId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/group#groups DataDatabricksGroup#groups}
    */
    readonly groups?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/group#id DataDatabricksGroup#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/group#instance_profiles DataDatabricksGroup#instance_profiles}
    */
    readonly instanceProfiles?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/group#members DataDatabricksGroup#members}
    */
    readonly members?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/group#recursive DataDatabricksGroup#recursive}
    */
    readonly recursive?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/group#service_principals DataDatabricksGroup#service_principals}
    */
    readonly servicePrincipals?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/group#users DataDatabricksGroup#users}
    */
    readonly users?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/group#workspace_access DataDatabricksGroup#workspace_access}
    */
    readonly workspaceAccess?: boolean | cdktf.IResolvable;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/databricks/d/group databricks_group}
*/
export declare class DataDatabricksGroup extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "databricks_group";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/databricks/d/group databricks_group} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataDatabricksGroupConfig
    */
    constructor(scope: Construct, id: string, config: DataDatabricksGroupConfig);
    private _allowClusterCreate?;
    get allowClusterCreate(): boolean | cdktf.IResolvable;
    set allowClusterCreate(value: boolean | cdktf.IResolvable);
    resetAllowClusterCreate(): void;
    get allowClusterCreateInput(): boolean | cdktf.IResolvable | undefined;
    private _allowInstancePoolCreate?;
    get allowInstancePoolCreate(): boolean | cdktf.IResolvable;
    set allowInstancePoolCreate(value: boolean | cdktf.IResolvable);
    resetAllowInstancePoolCreate(): void;
    get allowInstancePoolCreateInput(): boolean | cdktf.IResolvable | undefined;
    private _childGroups?;
    get childGroups(): string[];
    set childGroups(value: string[]);
    resetChildGroups(): void;
    get childGroupsInput(): string[] | undefined;
    private _databricksSqlAccess?;
    get databricksSqlAccess(): boolean | cdktf.IResolvable;
    set databricksSqlAccess(value: boolean | cdktf.IResolvable);
    resetDatabricksSqlAccess(): void;
    get databricksSqlAccessInput(): boolean | cdktf.IResolvable | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    private _externalId?;
    get externalId(): string;
    set externalId(value: string);
    resetExternalId(): void;
    get externalIdInput(): string | undefined;
    private _groups?;
    get groups(): string[];
    set groups(value: string[]);
    resetGroups(): void;
    get groupsInput(): string[] | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _instanceProfiles?;
    get instanceProfiles(): string[];
    set instanceProfiles(value: string[]);
    resetInstanceProfiles(): void;
    get instanceProfilesInput(): string[] | undefined;
    private _members?;
    get members(): string[];
    set members(value: string[]);
    resetMembers(): void;
    get membersInput(): string[] | undefined;
    private _recursive?;
    get recursive(): boolean | cdktf.IResolvable;
    set recursive(value: boolean | cdktf.IResolvable);
    resetRecursive(): void;
    get recursiveInput(): boolean | cdktf.IResolvable | undefined;
    private _servicePrincipals?;
    get servicePrincipals(): string[];
    set servicePrincipals(value: string[]);
    resetServicePrincipals(): void;
    get servicePrincipalsInput(): string[] | undefined;
    private _users?;
    get users(): string[];
    set users(value: string[]);
    resetUsers(): void;
    get usersInput(): string[] | undefined;
    private _workspaceAccess?;
    get workspaceAccess(): boolean | cdktf.IResolvable;
    set workspaceAccess(value: boolean | cdktf.IResolvable);
    resetWorkspaceAccess(): void;
    get workspaceAccessInput(): boolean | cdktf.IResolvable | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
