"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DataDatabricksGroup = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://www.terraform.io/docs/providers/databricks/d/group databricks_group}
*/
class DataDatabricksGroup extends cdktf.TerraformDataSource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/databricks/d/group databricks_group} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataDatabricksGroupConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'databricks_group',
            terraformGeneratorMetadata: {
                providerName: 'databricks',
                providerVersion: '1.14.3',
                providerVersionConstraint: '~> 1.0'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        this._allowClusterCreate = config.allowClusterCreate;
        this._allowInstancePoolCreate = config.allowInstancePoolCreate;
        this._childGroups = config.childGroups;
        this._databricksSqlAccess = config.databricksSqlAccess;
        this._displayName = config.displayName;
        this._externalId = config.externalId;
        this._groups = config.groups;
        this._id = config.id;
        this._instanceProfiles = config.instanceProfiles;
        this._members = config.members;
        this._recursive = config.recursive;
        this._servicePrincipals = config.servicePrincipals;
        this._users = config.users;
        this._workspaceAccess = config.workspaceAccess;
    }
    get allowClusterCreate() {
        return this.getBooleanAttribute('allow_cluster_create');
    }
    set allowClusterCreate(value) {
        this._allowClusterCreate = value;
    }
    resetAllowClusterCreate() {
        this._allowClusterCreate = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get allowClusterCreateInput() {
        return this._allowClusterCreate;
    }
    get allowInstancePoolCreate() {
        return this.getBooleanAttribute('allow_instance_pool_create');
    }
    set allowInstancePoolCreate(value) {
        this._allowInstancePoolCreate = value;
    }
    resetAllowInstancePoolCreate() {
        this._allowInstancePoolCreate = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get allowInstancePoolCreateInput() {
        return this._allowInstancePoolCreate;
    }
    get childGroups() {
        return cdktf.Fn.tolist(this.getListAttribute('child_groups'));
    }
    set childGroups(value) {
        this._childGroups = value;
    }
    resetChildGroups() {
        this._childGroups = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get childGroupsInput() {
        return this._childGroups;
    }
    get databricksSqlAccess() {
        return this.getBooleanAttribute('databricks_sql_access');
    }
    set databricksSqlAccess(value) {
        this._databricksSqlAccess = value;
    }
    resetDatabricksSqlAccess() {
        this._databricksSqlAccess = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get databricksSqlAccessInput() {
        return this._databricksSqlAccess;
    }
    get displayName() {
        return this.getStringAttribute('display_name');
    }
    set displayName(value) {
        this._displayName = value;
    }
    // Temporarily expose input value. Use with caution.
    get displayNameInput() {
        return this._displayName;
    }
    get externalId() {
        return this.getStringAttribute('external_id');
    }
    set externalId(value) {
        this._externalId = value;
    }
    resetExternalId() {
        this._externalId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get externalIdInput() {
        return this._externalId;
    }
    get groups() {
        return cdktf.Fn.tolist(this.getListAttribute('groups'));
    }
    set groups(value) {
        this._groups = value;
    }
    resetGroups() {
        this._groups = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get groupsInput() {
        return this._groups;
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get instanceProfiles() {
        return cdktf.Fn.tolist(this.getListAttribute('instance_profiles'));
    }
    set instanceProfiles(value) {
        this._instanceProfiles = value;
    }
    resetInstanceProfiles() {
        this._instanceProfiles = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get instanceProfilesInput() {
        return this._instanceProfiles;
    }
    get members() {
        return cdktf.Fn.tolist(this.getListAttribute('members'));
    }
    set members(value) {
        this._members = value;
    }
    resetMembers() {
        this._members = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get membersInput() {
        return this._members;
    }
    get recursive() {
        return this.getBooleanAttribute('recursive');
    }
    set recursive(value) {
        this._recursive = value;
    }
    resetRecursive() {
        this._recursive = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get recursiveInput() {
        return this._recursive;
    }
    get servicePrincipals() {
        return cdktf.Fn.tolist(this.getListAttribute('service_principals'));
    }
    set servicePrincipals(value) {
        this._servicePrincipals = value;
    }
    resetServicePrincipals() {
        this._servicePrincipals = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get servicePrincipalsInput() {
        return this._servicePrincipals;
    }
    get users() {
        return cdktf.Fn.tolist(this.getListAttribute('users'));
    }
    set users(value) {
        this._users = value;
    }
    resetUsers() {
        this._users = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get usersInput() {
        return this._users;
    }
    get workspaceAccess() {
        return this.getBooleanAttribute('workspace_access');
    }
    set workspaceAccess(value) {
        this._workspaceAccess = value;
    }
    resetWorkspaceAccess() {
        this._workspaceAccess = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get workspaceAccessInput() {
        return this._workspaceAccess;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            allow_cluster_create: cdktf.booleanToTerraform(this._allowClusterCreate),
            allow_instance_pool_create: cdktf.booleanToTerraform(this._allowInstancePoolCreate),
            child_groups: cdktf.listMapper(cdktf.stringToTerraform, false)(this._childGroups),
            databricks_sql_access: cdktf.booleanToTerraform(this._databricksSqlAccess),
            display_name: cdktf.stringToTerraform(this._displayName),
            external_id: cdktf.stringToTerraform(this._externalId),
            groups: cdktf.listMapper(cdktf.stringToTerraform, false)(this._groups),
            id: cdktf.stringToTerraform(this._id),
            instance_profiles: cdktf.listMapper(cdktf.stringToTerraform, false)(this._instanceProfiles),
            members: cdktf.listMapper(cdktf.stringToTerraform, false)(this._members),
            recursive: cdktf.booleanToTerraform(this._recursive),
            service_principals: cdktf.listMapper(cdktf.stringToTerraform, false)(this._servicePrincipals),
            users: cdktf.listMapper(cdktf.stringToTerraform, false)(this._users),
            workspace_access: cdktf.booleanToTerraform(this._workspaceAccess),
        };
    }
}
exports.DataDatabricksGroup = DataDatabricksGroup;
_a = JSII_RTTI_SYMBOL_1;
DataDatabricksGroup[_a] = { fqn: "@cdktf/provider-databricks.dataDatabricksGroup.DataDatabricksGroup", version: "6.0.0" };
// =================
// STATIC PROPERTIES
// =================
DataDatabricksGroup.tfResourceType = "databricks_group";
//# sourceMappingURL=data:application/json;base64,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