import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataDatabricksInstancePoolConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/instance_pool#id DataDatabricksInstancePool#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/instance_pool#name DataDatabricksInstancePool#name}
    */
    readonly name: string;
    /**
    * pool_info block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/instance_pool#pool_info DataDatabricksInstancePool#pool_info}
    */
    readonly poolInfo?: DataDatabricksInstancePoolPoolInfo;
}
export interface DataDatabricksInstancePoolPoolInfoAwsAttributes {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/instance_pool#availability DataDatabricksInstancePool#availability}
    */
    readonly availability?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/instance_pool#spot_bid_price_percent DataDatabricksInstancePool#spot_bid_price_percent}
    */
    readonly spotBidPricePercent?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/instance_pool#zone_id DataDatabricksInstancePool#zone_id}
    */
    readonly zoneId?: string;
}
export declare function dataDatabricksInstancePoolPoolInfoAwsAttributesToTerraform(struct?: DataDatabricksInstancePoolPoolInfoAwsAttributesOutputReference | DataDatabricksInstancePoolPoolInfoAwsAttributes): any;
export declare class DataDatabricksInstancePoolPoolInfoAwsAttributesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksInstancePoolPoolInfoAwsAttributes | undefined;
    set internalValue(value: DataDatabricksInstancePoolPoolInfoAwsAttributes | undefined);
    private _availability?;
    get availability(): string;
    set availability(value: string);
    resetAvailability(): void;
    get availabilityInput(): string | undefined;
    private _spotBidPricePercent?;
    get spotBidPricePercent(): number;
    set spotBidPricePercent(value: number);
    resetSpotBidPricePercent(): void;
    get spotBidPricePercentInput(): number | undefined;
    private _zoneId?;
    get zoneId(): string;
    set zoneId(value: string);
    resetZoneId(): void;
    get zoneIdInput(): string | undefined;
}
export interface DataDatabricksInstancePoolPoolInfoAzureAttributes {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/instance_pool#availability DataDatabricksInstancePool#availability}
    */
    readonly availability?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/instance_pool#spot_bid_max_price DataDatabricksInstancePool#spot_bid_max_price}
    */
    readonly spotBidMaxPrice?: number;
}
export declare function dataDatabricksInstancePoolPoolInfoAzureAttributesToTerraform(struct?: DataDatabricksInstancePoolPoolInfoAzureAttributesOutputReference | DataDatabricksInstancePoolPoolInfoAzureAttributes): any;
export declare class DataDatabricksInstancePoolPoolInfoAzureAttributesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksInstancePoolPoolInfoAzureAttributes | undefined;
    set internalValue(value: DataDatabricksInstancePoolPoolInfoAzureAttributes | undefined);
    private _availability?;
    get availability(): string;
    set availability(value: string);
    resetAvailability(): void;
    get availabilityInput(): string | undefined;
    private _spotBidMaxPrice?;
    get spotBidMaxPrice(): number;
    set spotBidMaxPrice(value: number);
    resetSpotBidMaxPrice(): void;
    get spotBidMaxPriceInput(): number | undefined;
}
export interface DataDatabricksInstancePoolPoolInfoDiskSpecDiskType {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/instance_pool#azure_disk_volume_type DataDatabricksInstancePool#azure_disk_volume_type}
    */
    readonly azureDiskVolumeType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/instance_pool#ebs_volume_type DataDatabricksInstancePool#ebs_volume_type}
    */
    readonly ebsVolumeType?: string;
}
export declare function dataDatabricksInstancePoolPoolInfoDiskSpecDiskTypeToTerraform(struct?: DataDatabricksInstancePoolPoolInfoDiskSpecDiskTypeOutputReference | DataDatabricksInstancePoolPoolInfoDiskSpecDiskType): any;
export declare class DataDatabricksInstancePoolPoolInfoDiskSpecDiskTypeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksInstancePoolPoolInfoDiskSpecDiskType | undefined;
    set internalValue(value: DataDatabricksInstancePoolPoolInfoDiskSpecDiskType | undefined);
    private _azureDiskVolumeType?;
    get azureDiskVolumeType(): string;
    set azureDiskVolumeType(value: string);
    resetAzureDiskVolumeType(): void;
    get azureDiskVolumeTypeInput(): string | undefined;
    private _ebsVolumeType?;
    get ebsVolumeType(): string;
    set ebsVolumeType(value: string);
    resetEbsVolumeType(): void;
    get ebsVolumeTypeInput(): string | undefined;
}
export interface DataDatabricksInstancePoolPoolInfoDiskSpec {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/instance_pool#disk_count DataDatabricksInstancePool#disk_count}
    */
    readonly diskCount?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/instance_pool#disk_size DataDatabricksInstancePool#disk_size}
    */
    readonly diskSize?: number;
    /**
    * disk_type block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/instance_pool#disk_type DataDatabricksInstancePool#disk_type}
    */
    readonly diskType?: DataDatabricksInstancePoolPoolInfoDiskSpecDiskType;
}
export declare function dataDatabricksInstancePoolPoolInfoDiskSpecToTerraform(struct?: DataDatabricksInstancePoolPoolInfoDiskSpecOutputReference | DataDatabricksInstancePoolPoolInfoDiskSpec): any;
export declare class DataDatabricksInstancePoolPoolInfoDiskSpecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksInstancePoolPoolInfoDiskSpec | undefined;
    set internalValue(value: DataDatabricksInstancePoolPoolInfoDiskSpec | undefined);
    private _diskCount?;
    get diskCount(): number;
    set diskCount(value: number);
    resetDiskCount(): void;
    get diskCountInput(): number | undefined;
    private _diskSize?;
    get diskSize(): number;
    set diskSize(value: number);
    resetDiskSize(): void;
    get diskSizeInput(): number | undefined;
    private _diskType;
    get diskType(): DataDatabricksInstancePoolPoolInfoDiskSpecDiskTypeOutputReference;
    putDiskType(value: DataDatabricksInstancePoolPoolInfoDiskSpecDiskType): void;
    resetDiskType(): void;
    get diskTypeInput(): DataDatabricksInstancePoolPoolInfoDiskSpecDiskType | undefined;
}
export interface DataDatabricksInstancePoolPoolInfoGcpAttributes {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/instance_pool#gcp_availability DataDatabricksInstancePool#gcp_availability}
    */
    readonly gcpAvailability?: string;
}
export declare function dataDatabricksInstancePoolPoolInfoGcpAttributesToTerraform(struct?: DataDatabricksInstancePoolPoolInfoGcpAttributesOutputReference | DataDatabricksInstancePoolPoolInfoGcpAttributes): any;
export declare class DataDatabricksInstancePoolPoolInfoGcpAttributesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksInstancePoolPoolInfoGcpAttributes | undefined;
    set internalValue(value: DataDatabricksInstancePoolPoolInfoGcpAttributes | undefined);
    private _gcpAvailability?;
    get gcpAvailability(): string;
    set gcpAvailability(value: string);
    resetGcpAvailability(): void;
    get gcpAvailabilityInput(): string | undefined;
}
export interface DataDatabricksInstancePoolPoolInfoInstancePoolFleetAttributesFleetOnDemandOption {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/instance_pool#allocation_strategy DataDatabricksInstancePool#allocation_strategy}
    */
    readonly allocationStrategy: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/instance_pool#instance_pools_to_use_count DataDatabricksInstancePool#instance_pools_to_use_count}
    */
    readonly instancePoolsToUseCount?: number;
}
export declare function dataDatabricksInstancePoolPoolInfoInstancePoolFleetAttributesFleetOnDemandOptionToTerraform(struct?: DataDatabricksInstancePoolPoolInfoInstancePoolFleetAttributesFleetOnDemandOptionOutputReference | DataDatabricksInstancePoolPoolInfoInstancePoolFleetAttributesFleetOnDemandOption): any;
export declare class DataDatabricksInstancePoolPoolInfoInstancePoolFleetAttributesFleetOnDemandOptionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksInstancePoolPoolInfoInstancePoolFleetAttributesFleetOnDemandOption | undefined;
    set internalValue(value: DataDatabricksInstancePoolPoolInfoInstancePoolFleetAttributesFleetOnDemandOption | undefined);
    private _allocationStrategy?;
    get allocationStrategy(): string;
    set allocationStrategy(value: string);
    get allocationStrategyInput(): string | undefined;
    private _instancePoolsToUseCount?;
    get instancePoolsToUseCount(): number;
    set instancePoolsToUseCount(value: number);
    resetInstancePoolsToUseCount(): void;
    get instancePoolsToUseCountInput(): number | undefined;
}
export interface DataDatabricksInstancePoolPoolInfoInstancePoolFleetAttributesFleetSpotOption {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/instance_pool#allocation_strategy DataDatabricksInstancePool#allocation_strategy}
    */
    readonly allocationStrategy: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/instance_pool#instance_pools_to_use_count DataDatabricksInstancePool#instance_pools_to_use_count}
    */
    readonly instancePoolsToUseCount?: number;
}
export declare function dataDatabricksInstancePoolPoolInfoInstancePoolFleetAttributesFleetSpotOptionToTerraform(struct?: DataDatabricksInstancePoolPoolInfoInstancePoolFleetAttributesFleetSpotOptionOutputReference | DataDatabricksInstancePoolPoolInfoInstancePoolFleetAttributesFleetSpotOption): any;
export declare class DataDatabricksInstancePoolPoolInfoInstancePoolFleetAttributesFleetSpotOptionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksInstancePoolPoolInfoInstancePoolFleetAttributesFleetSpotOption | undefined;
    set internalValue(value: DataDatabricksInstancePoolPoolInfoInstancePoolFleetAttributesFleetSpotOption | undefined);
    private _allocationStrategy?;
    get allocationStrategy(): string;
    set allocationStrategy(value: string);
    get allocationStrategyInput(): string | undefined;
    private _instancePoolsToUseCount?;
    get instancePoolsToUseCount(): number;
    set instancePoolsToUseCount(value: number);
    resetInstancePoolsToUseCount(): void;
    get instancePoolsToUseCountInput(): number | undefined;
}
export interface DataDatabricksInstancePoolPoolInfoInstancePoolFleetAttributesLaunchTemplateOverride {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/instance_pool#availability_zone DataDatabricksInstancePool#availability_zone}
    */
    readonly availabilityZone: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/instance_pool#instance_type DataDatabricksInstancePool#instance_type}
    */
    readonly instanceType: string;
}
export declare function dataDatabricksInstancePoolPoolInfoInstancePoolFleetAttributesLaunchTemplateOverrideToTerraform(struct?: DataDatabricksInstancePoolPoolInfoInstancePoolFleetAttributesLaunchTemplateOverride | cdktf.IResolvable): any;
export declare class DataDatabricksInstancePoolPoolInfoInstancePoolFleetAttributesLaunchTemplateOverrideOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDatabricksInstancePoolPoolInfoInstancePoolFleetAttributesLaunchTemplateOverride | cdktf.IResolvable | undefined;
    set internalValue(value: DataDatabricksInstancePoolPoolInfoInstancePoolFleetAttributesLaunchTemplateOverride | cdktf.IResolvable | undefined);
    private _availabilityZone?;
    get availabilityZone(): string;
    set availabilityZone(value: string);
    get availabilityZoneInput(): string | undefined;
    private _instanceType?;
    get instanceType(): string;
    set instanceType(value: string);
    get instanceTypeInput(): string | undefined;
}
export declare class DataDatabricksInstancePoolPoolInfoInstancePoolFleetAttributesLaunchTemplateOverrideList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DataDatabricksInstancePoolPoolInfoInstancePoolFleetAttributesLaunchTemplateOverride[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDatabricksInstancePoolPoolInfoInstancePoolFleetAttributesLaunchTemplateOverrideOutputReference;
}
export interface DataDatabricksInstancePoolPoolInfoInstancePoolFleetAttributes {
    /**
    * fleet_on_demand_option block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/instance_pool#fleet_on_demand_option DataDatabricksInstancePool#fleet_on_demand_option}
    */
    readonly fleetOnDemandOption?: DataDatabricksInstancePoolPoolInfoInstancePoolFleetAttributesFleetOnDemandOption;
    /**
    * fleet_spot_option block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/instance_pool#fleet_spot_option DataDatabricksInstancePool#fleet_spot_option}
    */
    readonly fleetSpotOption?: DataDatabricksInstancePoolPoolInfoInstancePoolFleetAttributesFleetSpotOption;
    /**
    * launch_template_override block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/instance_pool#launch_template_override DataDatabricksInstancePool#launch_template_override}
    */
    readonly launchTemplateOverride: DataDatabricksInstancePoolPoolInfoInstancePoolFleetAttributesLaunchTemplateOverride[] | cdktf.IResolvable;
}
export declare function dataDatabricksInstancePoolPoolInfoInstancePoolFleetAttributesToTerraform(struct?: DataDatabricksInstancePoolPoolInfoInstancePoolFleetAttributes | cdktf.IResolvable): any;
export declare class DataDatabricksInstancePoolPoolInfoInstancePoolFleetAttributesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDatabricksInstancePoolPoolInfoInstancePoolFleetAttributes | cdktf.IResolvable | undefined;
    set internalValue(value: DataDatabricksInstancePoolPoolInfoInstancePoolFleetAttributes | cdktf.IResolvable | undefined);
    private _fleetOnDemandOption;
    get fleetOnDemandOption(): DataDatabricksInstancePoolPoolInfoInstancePoolFleetAttributesFleetOnDemandOptionOutputReference;
    putFleetOnDemandOption(value: DataDatabricksInstancePoolPoolInfoInstancePoolFleetAttributesFleetOnDemandOption): void;
    resetFleetOnDemandOption(): void;
    get fleetOnDemandOptionInput(): DataDatabricksInstancePoolPoolInfoInstancePoolFleetAttributesFleetOnDemandOption | undefined;
    private _fleetSpotOption;
    get fleetSpotOption(): DataDatabricksInstancePoolPoolInfoInstancePoolFleetAttributesFleetSpotOptionOutputReference;
    putFleetSpotOption(value: DataDatabricksInstancePoolPoolInfoInstancePoolFleetAttributesFleetSpotOption): void;
    resetFleetSpotOption(): void;
    get fleetSpotOptionInput(): DataDatabricksInstancePoolPoolInfoInstancePoolFleetAttributesFleetSpotOption | undefined;
    private _launchTemplateOverride;
    get launchTemplateOverride(): DataDatabricksInstancePoolPoolInfoInstancePoolFleetAttributesLaunchTemplateOverrideList;
    putLaunchTemplateOverride(value: DataDatabricksInstancePoolPoolInfoInstancePoolFleetAttributesLaunchTemplateOverride[] | cdktf.IResolvable): void;
    get launchTemplateOverrideInput(): cdktf.IResolvable | DataDatabricksInstancePoolPoolInfoInstancePoolFleetAttributesLaunchTemplateOverride[] | undefined;
}
export declare class DataDatabricksInstancePoolPoolInfoInstancePoolFleetAttributesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DataDatabricksInstancePoolPoolInfoInstancePoolFleetAttributes[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDatabricksInstancePoolPoolInfoInstancePoolFleetAttributesOutputReference;
}
export interface DataDatabricksInstancePoolPoolInfoPreloadedDockerImageBasicAuth {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/instance_pool#password DataDatabricksInstancePool#password}
    */
    readonly password: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/instance_pool#username DataDatabricksInstancePool#username}
    */
    readonly username: string;
}
export declare function dataDatabricksInstancePoolPoolInfoPreloadedDockerImageBasicAuthToTerraform(struct?: DataDatabricksInstancePoolPoolInfoPreloadedDockerImageBasicAuthOutputReference | DataDatabricksInstancePoolPoolInfoPreloadedDockerImageBasicAuth): any;
export declare class DataDatabricksInstancePoolPoolInfoPreloadedDockerImageBasicAuthOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksInstancePoolPoolInfoPreloadedDockerImageBasicAuth | undefined;
    set internalValue(value: DataDatabricksInstancePoolPoolInfoPreloadedDockerImageBasicAuth | undefined);
    private _password?;
    get password(): string;
    set password(value: string);
    get passwordInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
}
export interface DataDatabricksInstancePoolPoolInfoPreloadedDockerImage {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/instance_pool#url DataDatabricksInstancePool#url}
    */
    readonly url: string;
    /**
    * basic_auth block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/instance_pool#basic_auth DataDatabricksInstancePool#basic_auth}
    */
    readonly basicAuth?: DataDatabricksInstancePoolPoolInfoPreloadedDockerImageBasicAuth;
}
export declare function dataDatabricksInstancePoolPoolInfoPreloadedDockerImageToTerraform(struct?: DataDatabricksInstancePoolPoolInfoPreloadedDockerImage | cdktf.IResolvable): any;
export declare class DataDatabricksInstancePoolPoolInfoPreloadedDockerImageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDatabricksInstancePoolPoolInfoPreloadedDockerImage | cdktf.IResolvable | undefined;
    set internalValue(value: DataDatabricksInstancePoolPoolInfoPreloadedDockerImage | cdktf.IResolvable | undefined);
    private _url?;
    get url(): string;
    set url(value: string);
    get urlInput(): string | undefined;
    private _basicAuth;
    get basicAuth(): DataDatabricksInstancePoolPoolInfoPreloadedDockerImageBasicAuthOutputReference;
    putBasicAuth(value: DataDatabricksInstancePoolPoolInfoPreloadedDockerImageBasicAuth): void;
    resetBasicAuth(): void;
    get basicAuthInput(): DataDatabricksInstancePoolPoolInfoPreloadedDockerImageBasicAuth | undefined;
}
export declare class DataDatabricksInstancePoolPoolInfoPreloadedDockerImageList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DataDatabricksInstancePoolPoolInfoPreloadedDockerImage[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDatabricksInstancePoolPoolInfoPreloadedDockerImageOutputReference;
}
export interface DataDatabricksInstancePoolPoolInfoStats {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/instance_pool#idle_count DataDatabricksInstancePool#idle_count}
    */
    readonly idleCount?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/instance_pool#pending_idle_count DataDatabricksInstancePool#pending_idle_count}
    */
    readonly pendingIdleCount?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/instance_pool#pending_used_count DataDatabricksInstancePool#pending_used_count}
    */
    readonly pendingUsedCount?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/instance_pool#used_count DataDatabricksInstancePool#used_count}
    */
    readonly usedCount?: number;
}
export declare function dataDatabricksInstancePoolPoolInfoStatsToTerraform(struct?: DataDatabricksInstancePoolPoolInfoStatsOutputReference | DataDatabricksInstancePoolPoolInfoStats): any;
export declare class DataDatabricksInstancePoolPoolInfoStatsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksInstancePoolPoolInfoStats | undefined;
    set internalValue(value: DataDatabricksInstancePoolPoolInfoStats | undefined);
    private _idleCount?;
    get idleCount(): number;
    set idleCount(value: number);
    resetIdleCount(): void;
    get idleCountInput(): number | undefined;
    private _pendingIdleCount?;
    get pendingIdleCount(): number;
    set pendingIdleCount(value: number);
    resetPendingIdleCount(): void;
    get pendingIdleCountInput(): number | undefined;
    private _pendingUsedCount?;
    get pendingUsedCount(): number;
    set pendingUsedCount(value: number);
    resetPendingUsedCount(): void;
    get pendingUsedCountInput(): number | undefined;
    private _usedCount?;
    get usedCount(): number;
    set usedCount(value: number);
    resetUsedCount(): void;
    get usedCountInput(): number | undefined;
}
export interface DataDatabricksInstancePoolPoolInfo {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/instance_pool#custom_tags DataDatabricksInstancePool#custom_tags}
    */
    readonly customTags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/instance_pool#default_tags DataDatabricksInstancePool#default_tags}
    */
    readonly defaultTags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/instance_pool#enable_elastic_disk DataDatabricksInstancePool#enable_elastic_disk}
    */
    readonly enableElasticDisk?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/instance_pool#idle_instance_autotermination_minutes DataDatabricksInstancePool#idle_instance_autotermination_minutes}
    */
    readonly idleInstanceAutoterminationMinutes: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/instance_pool#instance_pool_id DataDatabricksInstancePool#instance_pool_id}
    */
    readonly instancePoolId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/instance_pool#instance_pool_name DataDatabricksInstancePool#instance_pool_name}
    */
    readonly instancePoolName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/instance_pool#max_capacity DataDatabricksInstancePool#max_capacity}
    */
    readonly maxCapacity?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/instance_pool#min_idle_instances DataDatabricksInstancePool#min_idle_instances}
    */
    readonly minIdleInstances?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/instance_pool#node_type_id DataDatabricksInstancePool#node_type_id}
    */
    readonly nodeTypeId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/instance_pool#preloaded_spark_versions DataDatabricksInstancePool#preloaded_spark_versions}
    */
    readonly preloadedSparkVersions?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/instance_pool#state DataDatabricksInstancePool#state}
    */
    readonly state?: string;
    /**
    * aws_attributes block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/instance_pool#aws_attributes DataDatabricksInstancePool#aws_attributes}
    */
    readonly awsAttributes?: DataDatabricksInstancePoolPoolInfoAwsAttributes;
    /**
    * azure_attributes block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/instance_pool#azure_attributes DataDatabricksInstancePool#azure_attributes}
    */
    readonly azureAttributes?: DataDatabricksInstancePoolPoolInfoAzureAttributes;
    /**
    * disk_spec block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/instance_pool#disk_spec DataDatabricksInstancePool#disk_spec}
    */
    readonly diskSpec?: DataDatabricksInstancePoolPoolInfoDiskSpec;
    /**
    * gcp_attributes block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/instance_pool#gcp_attributes DataDatabricksInstancePool#gcp_attributes}
    */
    readonly gcpAttributes?: DataDatabricksInstancePoolPoolInfoGcpAttributes;
    /**
    * instance_pool_fleet_attributes block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/instance_pool#instance_pool_fleet_attributes DataDatabricksInstancePool#instance_pool_fleet_attributes}
    */
    readonly instancePoolFleetAttributes?: DataDatabricksInstancePoolPoolInfoInstancePoolFleetAttributes[] | cdktf.IResolvable;
    /**
    * preloaded_docker_image block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/instance_pool#preloaded_docker_image DataDatabricksInstancePool#preloaded_docker_image}
    */
    readonly preloadedDockerImage?: DataDatabricksInstancePoolPoolInfoPreloadedDockerImage[] | cdktf.IResolvable;
    /**
    * stats block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/instance_pool#stats DataDatabricksInstancePool#stats}
    */
    readonly stats?: DataDatabricksInstancePoolPoolInfoStats;
}
export declare function dataDatabricksInstancePoolPoolInfoToTerraform(struct?: DataDatabricksInstancePoolPoolInfoOutputReference | DataDatabricksInstancePoolPoolInfo): any;
export declare class DataDatabricksInstancePoolPoolInfoOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksInstancePoolPoolInfo | undefined;
    set internalValue(value: DataDatabricksInstancePoolPoolInfo | undefined);
    private _customTags?;
    get customTags(): {
        [key: string]: string;
    };
    set customTags(value: {
        [key: string]: string;
    });
    resetCustomTags(): void;
    get customTagsInput(): {
        [key: string]: string;
    } | undefined;
    private _defaultTags?;
    get defaultTags(): {
        [key: string]: string;
    };
    set defaultTags(value: {
        [key: string]: string;
    });
    resetDefaultTags(): void;
    get defaultTagsInput(): {
        [key: string]: string;
    } | undefined;
    private _enableElasticDisk?;
    get enableElasticDisk(): boolean | cdktf.IResolvable;
    set enableElasticDisk(value: boolean | cdktf.IResolvable);
    resetEnableElasticDisk(): void;
    get enableElasticDiskInput(): boolean | cdktf.IResolvable | undefined;
    private _idleInstanceAutoterminationMinutes?;
    get idleInstanceAutoterminationMinutes(): number;
    set idleInstanceAutoterminationMinutes(value: number);
    get idleInstanceAutoterminationMinutesInput(): number | undefined;
    private _instancePoolId?;
    get instancePoolId(): string;
    set instancePoolId(value: string);
    resetInstancePoolId(): void;
    get instancePoolIdInput(): string | undefined;
    private _instancePoolName?;
    get instancePoolName(): string;
    set instancePoolName(value: string);
    get instancePoolNameInput(): string | undefined;
    private _maxCapacity?;
    get maxCapacity(): number;
    set maxCapacity(value: number);
    resetMaxCapacity(): void;
    get maxCapacityInput(): number | undefined;
    private _minIdleInstances?;
    get minIdleInstances(): number;
    set minIdleInstances(value: number);
    resetMinIdleInstances(): void;
    get minIdleInstancesInput(): number | undefined;
    private _nodeTypeId?;
    get nodeTypeId(): string;
    set nodeTypeId(value: string);
    resetNodeTypeId(): void;
    get nodeTypeIdInput(): string | undefined;
    private _preloadedSparkVersions?;
    get preloadedSparkVersions(): string[];
    set preloadedSparkVersions(value: string[]);
    resetPreloadedSparkVersions(): void;
    get preloadedSparkVersionsInput(): string[] | undefined;
    private _state?;
    get state(): string;
    set state(value: string);
    resetState(): void;
    get stateInput(): string | undefined;
    private _awsAttributes;
    get awsAttributes(): DataDatabricksInstancePoolPoolInfoAwsAttributesOutputReference;
    putAwsAttributes(value: DataDatabricksInstancePoolPoolInfoAwsAttributes): void;
    resetAwsAttributes(): void;
    get awsAttributesInput(): DataDatabricksInstancePoolPoolInfoAwsAttributes | undefined;
    private _azureAttributes;
    get azureAttributes(): DataDatabricksInstancePoolPoolInfoAzureAttributesOutputReference;
    putAzureAttributes(value: DataDatabricksInstancePoolPoolInfoAzureAttributes): void;
    resetAzureAttributes(): void;
    get azureAttributesInput(): DataDatabricksInstancePoolPoolInfoAzureAttributes | undefined;
    private _diskSpec;
    get diskSpec(): DataDatabricksInstancePoolPoolInfoDiskSpecOutputReference;
    putDiskSpec(value: DataDatabricksInstancePoolPoolInfoDiskSpec): void;
    resetDiskSpec(): void;
    get diskSpecInput(): DataDatabricksInstancePoolPoolInfoDiskSpec | undefined;
    private _gcpAttributes;
    get gcpAttributes(): DataDatabricksInstancePoolPoolInfoGcpAttributesOutputReference;
    putGcpAttributes(value: DataDatabricksInstancePoolPoolInfoGcpAttributes): void;
    resetGcpAttributes(): void;
    get gcpAttributesInput(): DataDatabricksInstancePoolPoolInfoGcpAttributes | undefined;
    private _instancePoolFleetAttributes;
    get instancePoolFleetAttributes(): DataDatabricksInstancePoolPoolInfoInstancePoolFleetAttributesList;
    putInstancePoolFleetAttributes(value: DataDatabricksInstancePoolPoolInfoInstancePoolFleetAttributes[] | cdktf.IResolvable): void;
    resetInstancePoolFleetAttributes(): void;
    get instancePoolFleetAttributesInput(): cdktf.IResolvable | DataDatabricksInstancePoolPoolInfoInstancePoolFleetAttributes[] | undefined;
    private _preloadedDockerImage;
    get preloadedDockerImage(): DataDatabricksInstancePoolPoolInfoPreloadedDockerImageList;
    putPreloadedDockerImage(value: DataDatabricksInstancePoolPoolInfoPreloadedDockerImage[] | cdktf.IResolvable): void;
    resetPreloadedDockerImage(): void;
    get preloadedDockerImageInput(): cdktf.IResolvable | DataDatabricksInstancePoolPoolInfoPreloadedDockerImage[] | undefined;
    private _stats;
    get stats(): DataDatabricksInstancePoolPoolInfoStatsOutputReference;
    putStats(value: DataDatabricksInstancePoolPoolInfoStats): void;
    resetStats(): void;
    get statsInput(): DataDatabricksInstancePoolPoolInfoStats | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/databricks/d/instance_pool databricks_instance_pool}
*/
export declare class DataDatabricksInstancePool extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "databricks_instance_pool";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/databricks/d/instance_pool databricks_instance_pool} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataDatabricksInstancePoolConfig
    */
    constructor(scope: Construct, id: string, config: DataDatabricksInstancePoolConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _poolInfo;
    get poolInfo(): DataDatabricksInstancePoolPoolInfoOutputReference;
    putPoolInfo(value: DataDatabricksInstancePoolPoolInfo): void;
    resetPoolInfo(): void;
    get poolInfoInput(): DataDatabricksInstancePoolPoolInfo | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
