import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataDatabricksJobConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#id DataDatabricksJob#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#job_id DataDatabricksJob#job_id}
    */
    readonly jobId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#job_name DataDatabricksJob#job_name}
    */
    readonly jobName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#name DataDatabricksJob#name}
    */
    readonly name?: string;
    /**
    * job_settings block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#job_settings DataDatabricksJob#job_settings}
    */
    readonly jobSettings?: DataDatabricksJobJobSettings;
}
export interface DataDatabricksJobJobSettingsSettingsContinuous {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#pause_status DataDatabricksJob#pause_status}
    */
    readonly pauseStatus?: string;
}
export declare function dataDatabricksJobJobSettingsSettingsContinuousToTerraform(struct?: DataDatabricksJobJobSettingsSettingsContinuousOutputReference | DataDatabricksJobJobSettingsSettingsContinuous): any;
export declare class DataDatabricksJobJobSettingsSettingsContinuousOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksJobJobSettingsSettingsContinuous | undefined;
    set internalValue(value: DataDatabricksJobJobSettingsSettingsContinuous | undefined);
    private _pauseStatus?;
    get pauseStatus(): string;
    set pauseStatus(value: string);
    resetPauseStatus(): void;
    get pauseStatusInput(): string | undefined;
}
export interface DataDatabricksJobJobSettingsSettingsDbtTask {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#catalog DataDatabricksJob#catalog}
    */
    readonly catalog?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#commands DataDatabricksJob#commands}
    */
    readonly commands: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#profiles_directory DataDatabricksJob#profiles_directory}
    */
    readonly profilesDirectory?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#project_directory DataDatabricksJob#project_directory}
    */
    readonly projectDirectory?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#schema DataDatabricksJob#schema}
    */
    readonly schema?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#warehouse_id DataDatabricksJob#warehouse_id}
    */
    readonly warehouseId?: string;
}
export declare function dataDatabricksJobJobSettingsSettingsDbtTaskToTerraform(struct?: DataDatabricksJobJobSettingsSettingsDbtTaskOutputReference | DataDatabricksJobJobSettingsSettingsDbtTask): any;
export declare class DataDatabricksJobJobSettingsSettingsDbtTaskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksJobJobSettingsSettingsDbtTask | undefined;
    set internalValue(value: DataDatabricksJobJobSettingsSettingsDbtTask | undefined);
    private _catalog?;
    get catalog(): string;
    set catalog(value: string);
    resetCatalog(): void;
    get catalogInput(): string | undefined;
    private _commands?;
    get commands(): string[];
    set commands(value: string[]);
    get commandsInput(): string[] | undefined;
    private _profilesDirectory?;
    get profilesDirectory(): string;
    set profilesDirectory(value: string);
    resetProfilesDirectory(): void;
    get profilesDirectoryInput(): string | undefined;
    private _projectDirectory?;
    get projectDirectory(): string;
    set projectDirectory(value: string);
    resetProjectDirectory(): void;
    get projectDirectoryInput(): string | undefined;
    private _schema?;
    get schema(): string;
    set schema(value: string);
    resetSchema(): void;
    get schemaInput(): string | undefined;
    private _warehouseId?;
    get warehouseId(): string;
    set warehouseId(value: string);
    resetWarehouseId(): void;
    get warehouseIdInput(): string | undefined;
}
export interface DataDatabricksJobJobSettingsSettingsEmailNotifications {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#alert_on_last_attempt DataDatabricksJob#alert_on_last_attempt}
    */
    readonly alertOnLastAttempt?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#no_alert_for_skipped_runs DataDatabricksJob#no_alert_for_skipped_runs}
    */
    readonly noAlertForSkippedRuns?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#on_failure DataDatabricksJob#on_failure}
    */
    readonly onFailure?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#on_start DataDatabricksJob#on_start}
    */
    readonly onStart?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#on_success DataDatabricksJob#on_success}
    */
    readonly onSuccess?: string[];
}
export declare function dataDatabricksJobJobSettingsSettingsEmailNotificationsToTerraform(struct?: DataDatabricksJobJobSettingsSettingsEmailNotificationsOutputReference | DataDatabricksJobJobSettingsSettingsEmailNotifications): any;
export declare class DataDatabricksJobJobSettingsSettingsEmailNotificationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksJobJobSettingsSettingsEmailNotifications | undefined;
    set internalValue(value: DataDatabricksJobJobSettingsSettingsEmailNotifications | undefined);
    private _alertOnLastAttempt?;
    get alertOnLastAttempt(): boolean | cdktf.IResolvable;
    set alertOnLastAttempt(value: boolean | cdktf.IResolvable);
    resetAlertOnLastAttempt(): void;
    get alertOnLastAttemptInput(): boolean | cdktf.IResolvable | undefined;
    private _noAlertForSkippedRuns?;
    get noAlertForSkippedRuns(): boolean | cdktf.IResolvable;
    set noAlertForSkippedRuns(value: boolean | cdktf.IResolvable);
    resetNoAlertForSkippedRuns(): void;
    get noAlertForSkippedRunsInput(): boolean | cdktf.IResolvable | undefined;
    private _onFailure?;
    get onFailure(): string[];
    set onFailure(value: string[]);
    resetOnFailure(): void;
    get onFailureInput(): string[] | undefined;
    private _onStart?;
    get onStart(): string[];
    set onStart(value: string[]);
    resetOnStart(): void;
    get onStartInput(): string[] | undefined;
    private _onSuccess?;
    get onSuccess(): string[];
    set onSuccess(value: string[]);
    resetOnSuccess(): void;
    get onSuccessInput(): string[] | undefined;
}
export interface DataDatabricksJobJobSettingsSettingsGitSource {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#branch DataDatabricksJob#branch}
    */
    readonly branch?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#commit DataDatabricksJob#commit}
    */
    readonly commit?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#provider DataDatabricksJob#provider}
    */
    readonly provider?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#tag DataDatabricksJob#tag}
    */
    readonly tag?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#url DataDatabricksJob#url}
    */
    readonly url: string;
}
export declare function dataDatabricksJobJobSettingsSettingsGitSourceToTerraform(struct?: DataDatabricksJobJobSettingsSettingsGitSourceOutputReference | DataDatabricksJobJobSettingsSettingsGitSource): any;
export declare class DataDatabricksJobJobSettingsSettingsGitSourceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksJobJobSettingsSettingsGitSource | undefined;
    set internalValue(value: DataDatabricksJobJobSettingsSettingsGitSource | undefined);
    private _branch?;
    get branch(): string;
    set branch(value: string);
    resetBranch(): void;
    get branchInput(): string | undefined;
    private _commit?;
    get commit(): string;
    set commit(value: string);
    resetCommit(): void;
    get commitInput(): string | undefined;
    private _provider?;
    get provider(): string;
    set provider(value: string);
    resetProvider(): void;
    get providerInput(): string | undefined;
    private _tag?;
    get tag(): string;
    set tag(value: string);
    resetTag(): void;
    get tagInput(): string | undefined;
    private _url?;
    get url(): string;
    set url(value: string);
    get urlInput(): string | undefined;
}
export interface DataDatabricksJobJobSettingsSettingsJobClusterNewClusterAutoscale {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#max_workers DataDatabricksJob#max_workers}
    */
    readonly maxWorkers?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#min_workers DataDatabricksJob#min_workers}
    */
    readonly minWorkers?: number;
}
export declare function dataDatabricksJobJobSettingsSettingsJobClusterNewClusterAutoscaleToTerraform(struct?: DataDatabricksJobJobSettingsSettingsJobClusterNewClusterAutoscaleOutputReference | DataDatabricksJobJobSettingsSettingsJobClusterNewClusterAutoscale): any;
export declare class DataDatabricksJobJobSettingsSettingsJobClusterNewClusterAutoscaleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksJobJobSettingsSettingsJobClusterNewClusterAutoscale | undefined;
    set internalValue(value: DataDatabricksJobJobSettingsSettingsJobClusterNewClusterAutoscale | undefined);
    private _maxWorkers?;
    get maxWorkers(): number;
    set maxWorkers(value: number);
    resetMaxWorkers(): void;
    get maxWorkersInput(): number | undefined;
    private _minWorkers?;
    get minWorkers(): number;
    set minWorkers(value: number);
    resetMinWorkers(): void;
    get minWorkersInput(): number | undefined;
}
export interface DataDatabricksJobJobSettingsSettingsJobClusterNewClusterAwsAttributes {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#availability DataDatabricksJob#availability}
    */
    readonly availability?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#ebs_volume_count DataDatabricksJob#ebs_volume_count}
    */
    readonly ebsVolumeCount?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#ebs_volume_size DataDatabricksJob#ebs_volume_size}
    */
    readonly ebsVolumeSize?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#ebs_volume_type DataDatabricksJob#ebs_volume_type}
    */
    readonly ebsVolumeType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#first_on_demand DataDatabricksJob#first_on_demand}
    */
    readonly firstOnDemand?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#instance_profile_arn DataDatabricksJob#instance_profile_arn}
    */
    readonly instanceProfileArn?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#spot_bid_price_percent DataDatabricksJob#spot_bid_price_percent}
    */
    readonly spotBidPricePercent?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#zone_id DataDatabricksJob#zone_id}
    */
    readonly zoneId?: string;
}
export declare function dataDatabricksJobJobSettingsSettingsJobClusterNewClusterAwsAttributesToTerraform(struct?: DataDatabricksJobJobSettingsSettingsJobClusterNewClusterAwsAttributesOutputReference | DataDatabricksJobJobSettingsSettingsJobClusterNewClusterAwsAttributes): any;
export declare class DataDatabricksJobJobSettingsSettingsJobClusterNewClusterAwsAttributesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksJobJobSettingsSettingsJobClusterNewClusterAwsAttributes | undefined;
    set internalValue(value: DataDatabricksJobJobSettingsSettingsJobClusterNewClusterAwsAttributes | undefined);
    private _availability?;
    get availability(): string;
    set availability(value: string);
    resetAvailability(): void;
    get availabilityInput(): string | undefined;
    private _ebsVolumeCount?;
    get ebsVolumeCount(): number;
    set ebsVolumeCount(value: number);
    resetEbsVolumeCount(): void;
    get ebsVolumeCountInput(): number | undefined;
    private _ebsVolumeSize?;
    get ebsVolumeSize(): number;
    set ebsVolumeSize(value: number);
    resetEbsVolumeSize(): void;
    get ebsVolumeSizeInput(): number | undefined;
    private _ebsVolumeType?;
    get ebsVolumeType(): string;
    set ebsVolumeType(value: string);
    resetEbsVolumeType(): void;
    get ebsVolumeTypeInput(): string | undefined;
    private _firstOnDemand?;
    get firstOnDemand(): number;
    set firstOnDemand(value: number);
    resetFirstOnDemand(): void;
    get firstOnDemandInput(): number | undefined;
    private _instanceProfileArn?;
    get instanceProfileArn(): string;
    set instanceProfileArn(value: string);
    resetInstanceProfileArn(): void;
    get instanceProfileArnInput(): string | undefined;
    private _spotBidPricePercent?;
    get spotBidPricePercent(): number;
    set spotBidPricePercent(value: number);
    resetSpotBidPricePercent(): void;
    get spotBidPricePercentInput(): number | undefined;
    private _zoneId?;
    get zoneId(): string;
    set zoneId(value: string);
    resetZoneId(): void;
    get zoneIdInput(): string | undefined;
}
export interface DataDatabricksJobJobSettingsSettingsJobClusterNewClusterAzureAttributes {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#availability DataDatabricksJob#availability}
    */
    readonly availability?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#first_on_demand DataDatabricksJob#first_on_demand}
    */
    readonly firstOnDemand?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#spot_bid_max_price DataDatabricksJob#spot_bid_max_price}
    */
    readonly spotBidMaxPrice?: number;
}
export declare function dataDatabricksJobJobSettingsSettingsJobClusterNewClusterAzureAttributesToTerraform(struct?: DataDatabricksJobJobSettingsSettingsJobClusterNewClusterAzureAttributesOutputReference | DataDatabricksJobJobSettingsSettingsJobClusterNewClusterAzureAttributes): any;
export declare class DataDatabricksJobJobSettingsSettingsJobClusterNewClusterAzureAttributesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksJobJobSettingsSettingsJobClusterNewClusterAzureAttributes | undefined;
    set internalValue(value: DataDatabricksJobJobSettingsSettingsJobClusterNewClusterAzureAttributes | undefined);
    private _availability?;
    get availability(): string;
    set availability(value: string);
    resetAvailability(): void;
    get availabilityInput(): string | undefined;
    private _firstOnDemand?;
    get firstOnDemand(): number;
    set firstOnDemand(value: number);
    resetFirstOnDemand(): void;
    get firstOnDemandInput(): number | undefined;
    private _spotBidMaxPrice?;
    get spotBidMaxPrice(): number;
    set spotBidMaxPrice(value: number);
    resetSpotBidMaxPrice(): void;
    get spotBidMaxPriceInput(): number | undefined;
}
export interface DataDatabricksJobJobSettingsSettingsJobClusterNewClusterClusterLogConfDbfs {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#destination DataDatabricksJob#destination}
    */
    readonly destination: string;
}
export declare function dataDatabricksJobJobSettingsSettingsJobClusterNewClusterClusterLogConfDbfsToTerraform(struct?: DataDatabricksJobJobSettingsSettingsJobClusterNewClusterClusterLogConfDbfsOutputReference | DataDatabricksJobJobSettingsSettingsJobClusterNewClusterClusterLogConfDbfs): any;
export declare class DataDatabricksJobJobSettingsSettingsJobClusterNewClusterClusterLogConfDbfsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksJobJobSettingsSettingsJobClusterNewClusterClusterLogConfDbfs | undefined;
    set internalValue(value: DataDatabricksJobJobSettingsSettingsJobClusterNewClusterClusterLogConfDbfs | undefined);
    private _destination?;
    get destination(): string;
    set destination(value: string);
    get destinationInput(): string | undefined;
}
export interface DataDatabricksJobJobSettingsSettingsJobClusterNewClusterClusterLogConfS3 {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#canned_acl DataDatabricksJob#canned_acl}
    */
    readonly cannedAcl?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#destination DataDatabricksJob#destination}
    */
    readonly destination: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#enable_encryption DataDatabricksJob#enable_encryption}
    */
    readonly enableEncryption?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#encryption_type DataDatabricksJob#encryption_type}
    */
    readonly encryptionType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#endpoint DataDatabricksJob#endpoint}
    */
    readonly endpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#kms_key DataDatabricksJob#kms_key}
    */
    readonly kmsKey?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#region DataDatabricksJob#region}
    */
    readonly region?: string;
}
export declare function dataDatabricksJobJobSettingsSettingsJobClusterNewClusterClusterLogConfS3ToTerraform(struct?: DataDatabricksJobJobSettingsSettingsJobClusterNewClusterClusterLogConfS3OutputReference | DataDatabricksJobJobSettingsSettingsJobClusterNewClusterClusterLogConfS3): any;
export declare class DataDatabricksJobJobSettingsSettingsJobClusterNewClusterClusterLogConfS3OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksJobJobSettingsSettingsJobClusterNewClusterClusterLogConfS3 | undefined;
    set internalValue(value: DataDatabricksJobJobSettingsSettingsJobClusterNewClusterClusterLogConfS3 | undefined);
    private _cannedAcl?;
    get cannedAcl(): string;
    set cannedAcl(value: string);
    resetCannedAcl(): void;
    get cannedAclInput(): string | undefined;
    private _destination?;
    get destination(): string;
    set destination(value: string);
    get destinationInput(): string | undefined;
    private _enableEncryption?;
    get enableEncryption(): boolean | cdktf.IResolvable;
    set enableEncryption(value: boolean | cdktf.IResolvable);
    resetEnableEncryption(): void;
    get enableEncryptionInput(): boolean | cdktf.IResolvable | undefined;
    private _encryptionType?;
    get encryptionType(): string;
    set encryptionType(value: string);
    resetEncryptionType(): void;
    get encryptionTypeInput(): string | undefined;
    private _endpoint?;
    get endpoint(): string;
    set endpoint(value: string);
    resetEndpoint(): void;
    get endpointInput(): string | undefined;
    private _kmsKey?;
    get kmsKey(): string;
    set kmsKey(value: string);
    resetKmsKey(): void;
    get kmsKeyInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
}
export interface DataDatabricksJobJobSettingsSettingsJobClusterNewClusterClusterLogConf {
    /**
    * dbfs block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#dbfs DataDatabricksJob#dbfs}
    */
    readonly dbfs?: DataDatabricksJobJobSettingsSettingsJobClusterNewClusterClusterLogConfDbfs;
    /**
    * s3 block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#s3 DataDatabricksJob#s3}
    */
    readonly s3?: DataDatabricksJobJobSettingsSettingsJobClusterNewClusterClusterLogConfS3;
}
export declare function dataDatabricksJobJobSettingsSettingsJobClusterNewClusterClusterLogConfToTerraform(struct?: DataDatabricksJobJobSettingsSettingsJobClusterNewClusterClusterLogConfOutputReference | DataDatabricksJobJobSettingsSettingsJobClusterNewClusterClusterLogConf): any;
export declare class DataDatabricksJobJobSettingsSettingsJobClusterNewClusterClusterLogConfOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksJobJobSettingsSettingsJobClusterNewClusterClusterLogConf | undefined;
    set internalValue(value: DataDatabricksJobJobSettingsSettingsJobClusterNewClusterClusterLogConf | undefined);
    private _dbfs;
    get dbfs(): DataDatabricksJobJobSettingsSettingsJobClusterNewClusterClusterLogConfDbfsOutputReference;
    putDbfs(value: DataDatabricksJobJobSettingsSettingsJobClusterNewClusterClusterLogConfDbfs): void;
    resetDbfs(): void;
    get dbfsInput(): DataDatabricksJobJobSettingsSettingsJobClusterNewClusterClusterLogConfDbfs | undefined;
    private _s3;
    get s3(): DataDatabricksJobJobSettingsSettingsJobClusterNewClusterClusterLogConfS3OutputReference;
    putS3(value: DataDatabricksJobJobSettingsSettingsJobClusterNewClusterClusterLogConfS3): void;
    resetS3(): void;
    get s3Input(): DataDatabricksJobJobSettingsSettingsJobClusterNewClusterClusterLogConfS3 | undefined;
}
export interface DataDatabricksJobJobSettingsSettingsJobClusterNewClusterClusterMountInfoNetworkFilesystemInfo {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#mount_options DataDatabricksJob#mount_options}
    */
    readonly mountOptions?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#server_address DataDatabricksJob#server_address}
    */
    readonly serverAddress: string;
}
export declare function dataDatabricksJobJobSettingsSettingsJobClusterNewClusterClusterMountInfoNetworkFilesystemInfoToTerraform(struct?: DataDatabricksJobJobSettingsSettingsJobClusterNewClusterClusterMountInfoNetworkFilesystemInfoOutputReference | DataDatabricksJobJobSettingsSettingsJobClusterNewClusterClusterMountInfoNetworkFilesystemInfo): any;
export declare class DataDatabricksJobJobSettingsSettingsJobClusterNewClusterClusterMountInfoNetworkFilesystemInfoOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksJobJobSettingsSettingsJobClusterNewClusterClusterMountInfoNetworkFilesystemInfo | undefined;
    set internalValue(value: DataDatabricksJobJobSettingsSettingsJobClusterNewClusterClusterMountInfoNetworkFilesystemInfo | undefined);
    private _mountOptions?;
    get mountOptions(): string;
    set mountOptions(value: string);
    resetMountOptions(): void;
    get mountOptionsInput(): string | undefined;
    private _serverAddress?;
    get serverAddress(): string;
    set serverAddress(value: string);
    get serverAddressInput(): string | undefined;
}
export interface DataDatabricksJobJobSettingsSettingsJobClusterNewClusterClusterMountInfo {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#local_mount_dir_path DataDatabricksJob#local_mount_dir_path}
    */
    readonly localMountDirPath: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#remote_mount_dir_path DataDatabricksJob#remote_mount_dir_path}
    */
    readonly remoteMountDirPath?: string;
    /**
    * network_filesystem_info block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#network_filesystem_info DataDatabricksJob#network_filesystem_info}
    */
    readonly networkFilesystemInfo: DataDatabricksJobJobSettingsSettingsJobClusterNewClusterClusterMountInfoNetworkFilesystemInfo;
}
export declare function dataDatabricksJobJobSettingsSettingsJobClusterNewClusterClusterMountInfoToTerraform(struct?: DataDatabricksJobJobSettingsSettingsJobClusterNewClusterClusterMountInfo | cdktf.IResolvable): any;
export declare class DataDatabricksJobJobSettingsSettingsJobClusterNewClusterClusterMountInfoOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDatabricksJobJobSettingsSettingsJobClusterNewClusterClusterMountInfo | cdktf.IResolvable | undefined;
    set internalValue(value: DataDatabricksJobJobSettingsSettingsJobClusterNewClusterClusterMountInfo | cdktf.IResolvable | undefined);
    private _localMountDirPath?;
    get localMountDirPath(): string;
    set localMountDirPath(value: string);
    get localMountDirPathInput(): string | undefined;
    private _remoteMountDirPath?;
    get remoteMountDirPath(): string;
    set remoteMountDirPath(value: string);
    resetRemoteMountDirPath(): void;
    get remoteMountDirPathInput(): string | undefined;
    private _networkFilesystemInfo;
    get networkFilesystemInfo(): DataDatabricksJobJobSettingsSettingsJobClusterNewClusterClusterMountInfoNetworkFilesystemInfoOutputReference;
    putNetworkFilesystemInfo(value: DataDatabricksJobJobSettingsSettingsJobClusterNewClusterClusterMountInfoNetworkFilesystemInfo): void;
    get networkFilesystemInfoInput(): DataDatabricksJobJobSettingsSettingsJobClusterNewClusterClusterMountInfoNetworkFilesystemInfo | undefined;
}
export declare class DataDatabricksJobJobSettingsSettingsJobClusterNewClusterClusterMountInfoList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DataDatabricksJobJobSettingsSettingsJobClusterNewClusterClusterMountInfo[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDatabricksJobJobSettingsSettingsJobClusterNewClusterClusterMountInfoOutputReference;
}
export interface DataDatabricksJobJobSettingsSettingsJobClusterNewClusterDockerImageBasicAuth {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#password DataDatabricksJob#password}
    */
    readonly password: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#username DataDatabricksJob#username}
    */
    readonly username: string;
}
export declare function dataDatabricksJobJobSettingsSettingsJobClusterNewClusterDockerImageBasicAuthToTerraform(struct?: DataDatabricksJobJobSettingsSettingsJobClusterNewClusterDockerImageBasicAuthOutputReference | DataDatabricksJobJobSettingsSettingsJobClusterNewClusterDockerImageBasicAuth): any;
export declare class DataDatabricksJobJobSettingsSettingsJobClusterNewClusterDockerImageBasicAuthOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksJobJobSettingsSettingsJobClusterNewClusterDockerImageBasicAuth | undefined;
    set internalValue(value: DataDatabricksJobJobSettingsSettingsJobClusterNewClusterDockerImageBasicAuth | undefined);
    private _password?;
    get password(): string;
    set password(value: string);
    get passwordInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
}
export interface DataDatabricksJobJobSettingsSettingsJobClusterNewClusterDockerImage {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#url DataDatabricksJob#url}
    */
    readonly url: string;
    /**
    * basic_auth block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#basic_auth DataDatabricksJob#basic_auth}
    */
    readonly basicAuth?: DataDatabricksJobJobSettingsSettingsJobClusterNewClusterDockerImageBasicAuth;
}
export declare function dataDatabricksJobJobSettingsSettingsJobClusterNewClusterDockerImageToTerraform(struct?: DataDatabricksJobJobSettingsSettingsJobClusterNewClusterDockerImageOutputReference | DataDatabricksJobJobSettingsSettingsJobClusterNewClusterDockerImage): any;
export declare class DataDatabricksJobJobSettingsSettingsJobClusterNewClusterDockerImageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksJobJobSettingsSettingsJobClusterNewClusterDockerImage | undefined;
    set internalValue(value: DataDatabricksJobJobSettingsSettingsJobClusterNewClusterDockerImage | undefined);
    private _url?;
    get url(): string;
    set url(value: string);
    get urlInput(): string | undefined;
    private _basicAuth;
    get basicAuth(): DataDatabricksJobJobSettingsSettingsJobClusterNewClusterDockerImageBasicAuthOutputReference;
    putBasicAuth(value: DataDatabricksJobJobSettingsSettingsJobClusterNewClusterDockerImageBasicAuth): void;
    resetBasicAuth(): void;
    get basicAuthInput(): DataDatabricksJobJobSettingsSettingsJobClusterNewClusterDockerImageBasicAuth | undefined;
}
export interface DataDatabricksJobJobSettingsSettingsJobClusterNewClusterGcpAttributes {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#availability DataDatabricksJob#availability}
    */
    readonly availability?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#boot_disk_size DataDatabricksJob#boot_disk_size}
    */
    readonly bootDiskSize?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#google_service_account DataDatabricksJob#google_service_account}
    */
    readonly googleServiceAccount?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#use_preemptible_executors DataDatabricksJob#use_preemptible_executors}
    */
    readonly usePreemptibleExecutors?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#zone_id DataDatabricksJob#zone_id}
    */
    readonly zoneId?: string;
}
export declare function dataDatabricksJobJobSettingsSettingsJobClusterNewClusterGcpAttributesToTerraform(struct?: DataDatabricksJobJobSettingsSettingsJobClusterNewClusterGcpAttributesOutputReference | DataDatabricksJobJobSettingsSettingsJobClusterNewClusterGcpAttributes): any;
export declare class DataDatabricksJobJobSettingsSettingsJobClusterNewClusterGcpAttributesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksJobJobSettingsSettingsJobClusterNewClusterGcpAttributes | undefined;
    set internalValue(value: DataDatabricksJobJobSettingsSettingsJobClusterNewClusterGcpAttributes | undefined);
    private _availability?;
    get availability(): string;
    set availability(value: string);
    resetAvailability(): void;
    get availabilityInput(): string | undefined;
    private _bootDiskSize?;
    get bootDiskSize(): number;
    set bootDiskSize(value: number);
    resetBootDiskSize(): void;
    get bootDiskSizeInput(): number | undefined;
    private _googleServiceAccount?;
    get googleServiceAccount(): string;
    set googleServiceAccount(value: string);
    resetGoogleServiceAccount(): void;
    get googleServiceAccountInput(): string | undefined;
    private _usePreemptibleExecutors?;
    get usePreemptibleExecutors(): boolean | cdktf.IResolvable;
    set usePreemptibleExecutors(value: boolean | cdktf.IResolvable);
    resetUsePreemptibleExecutors(): void;
    get usePreemptibleExecutorsInput(): boolean | cdktf.IResolvable | undefined;
    private _zoneId?;
    get zoneId(): string;
    set zoneId(value: string);
    resetZoneId(): void;
    get zoneIdInput(): string | undefined;
}
export interface DataDatabricksJobJobSettingsSettingsJobClusterNewClusterInitScriptsAbfss {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#destination DataDatabricksJob#destination}
    */
    readonly destination?: string;
}
export declare function dataDatabricksJobJobSettingsSettingsJobClusterNewClusterInitScriptsAbfssToTerraform(struct?: DataDatabricksJobJobSettingsSettingsJobClusterNewClusterInitScriptsAbfssOutputReference | DataDatabricksJobJobSettingsSettingsJobClusterNewClusterInitScriptsAbfss): any;
export declare class DataDatabricksJobJobSettingsSettingsJobClusterNewClusterInitScriptsAbfssOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksJobJobSettingsSettingsJobClusterNewClusterInitScriptsAbfss | undefined;
    set internalValue(value: DataDatabricksJobJobSettingsSettingsJobClusterNewClusterInitScriptsAbfss | undefined);
    private _destination?;
    get destination(): string;
    set destination(value: string);
    resetDestination(): void;
    get destinationInput(): string | undefined;
}
export interface DataDatabricksJobJobSettingsSettingsJobClusterNewClusterInitScriptsDbfs {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#destination DataDatabricksJob#destination}
    */
    readonly destination: string;
}
export declare function dataDatabricksJobJobSettingsSettingsJobClusterNewClusterInitScriptsDbfsToTerraform(struct?: DataDatabricksJobJobSettingsSettingsJobClusterNewClusterInitScriptsDbfsOutputReference | DataDatabricksJobJobSettingsSettingsJobClusterNewClusterInitScriptsDbfs): any;
export declare class DataDatabricksJobJobSettingsSettingsJobClusterNewClusterInitScriptsDbfsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksJobJobSettingsSettingsJobClusterNewClusterInitScriptsDbfs | undefined;
    set internalValue(value: DataDatabricksJobJobSettingsSettingsJobClusterNewClusterInitScriptsDbfs | undefined);
    private _destination?;
    get destination(): string;
    set destination(value: string);
    get destinationInput(): string | undefined;
}
export interface DataDatabricksJobJobSettingsSettingsJobClusterNewClusterInitScriptsFile {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#destination DataDatabricksJob#destination}
    */
    readonly destination?: string;
}
export declare function dataDatabricksJobJobSettingsSettingsJobClusterNewClusterInitScriptsFileToTerraform(struct?: DataDatabricksJobJobSettingsSettingsJobClusterNewClusterInitScriptsFileOutputReference | DataDatabricksJobJobSettingsSettingsJobClusterNewClusterInitScriptsFile): any;
export declare class DataDatabricksJobJobSettingsSettingsJobClusterNewClusterInitScriptsFileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksJobJobSettingsSettingsJobClusterNewClusterInitScriptsFile | undefined;
    set internalValue(value: DataDatabricksJobJobSettingsSettingsJobClusterNewClusterInitScriptsFile | undefined);
    private _destination?;
    get destination(): string;
    set destination(value: string);
    resetDestination(): void;
    get destinationInput(): string | undefined;
}
export interface DataDatabricksJobJobSettingsSettingsJobClusterNewClusterInitScriptsGcs {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#destination DataDatabricksJob#destination}
    */
    readonly destination?: string;
}
export declare function dataDatabricksJobJobSettingsSettingsJobClusterNewClusterInitScriptsGcsToTerraform(struct?: DataDatabricksJobJobSettingsSettingsJobClusterNewClusterInitScriptsGcsOutputReference | DataDatabricksJobJobSettingsSettingsJobClusterNewClusterInitScriptsGcs): any;
export declare class DataDatabricksJobJobSettingsSettingsJobClusterNewClusterInitScriptsGcsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksJobJobSettingsSettingsJobClusterNewClusterInitScriptsGcs | undefined;
    set internalValue(value: DataDatabricksJobJobSettingsSettingsJobClusterNewClusterInitScriptsGcs | undefined);
    private _destination?;
    get destination(): string;
    set destination(value: string);
    resetDestination(): void;
    get destinationInput(): string | undefined;
}
export interface DataDatabricksJobJobSettingsSettingsJobClusterNewClusterInitScriptsS3 {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#canned_acl DataDatabricksJob#canned_acl}
    */
    readonly cannedAcl?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#destination DataDatabricksJob#destination}
    */
    readonly destination: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#enable_encryption DataDatabricksJob#enable_encryption}
    */
    readonly enableEncryption?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#encryption_type DataDatabricksJob#encryption_type}
    */
    readonly encryptionType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#endpoint DataDatabricksJob#endpoint}
    */
    readonly endpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#kms_key DataDatabricksJob#kms_key}
    */
    readonly kmsKey?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#region DataDatabricksJob#region}
    */
    readonly region?: string;
}
export declare function dataDatabricksJobJobSettingsSettingsJobClusterNewClusterInitScriptsS3ToTerraform(struct?: DataDatabricksJobJobSettingsSettingsJobClusterNewClusterInitScriptsS3OutputReference | DataDatabricksJobJobSettingsSettingsJobClusterNewClusterInitScriptsS3): any;
export declare class DataDatabricksJobJobSettingsSettingsJobClusterNewClusterInitScriptsS3OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksJobJobSettingsSettingsJobClusterNewClusterInitScriptsS3 | undefined;
    set internalValue(value: DataDatabricksJobJobSettingsSettingsJobClusterNewClusterInitScriptsS3 | undefined);
    private _cannedAcl?;
    get cannedAcl(): string;
    set cannedAcl(value: string);
    resetCannedAcl(): void;
    get cannedAclInput(): string | undefined;
    private _destination?;
    get destination(): string;
    set destination(value: string);
    get destinationInput(): string | undefined;
    private _enableEncryption?;
    get enableEncryption(): boolean | cdktf.IResolvable;
    set enableEncryption(value: boolean | cdktf.IResolvable);
    resetEnableEncryption(): void;
    get enableEncryptionInput(): boolean | cdktf.IResolvable | undefined;
    private _encryptionType?;
    get encryptionType(): string;
    set encryptionType(value: string);
    resetEncryptionType(): void;
    get encryptionTypeInput(): string | undefined;
    private _endpoint?;
    get endpoint(): string;
    set endpoint(value: string);
    resetEndpoint(): void;
    get endpointInput(): string | undefined;
    private _kmsKey?;
    get kmsKey(): string;
    set kmsKey(value: string);
    resetKmsKey(): void;
    get kmsKeyInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
}
export interface DataDatabricksJobJobSettingsSettingsJobClusterNewClusterInitScripts {
    /**
    * abfss block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#abfss DataDatabricksJob#abfss}
    */
    readonly abfss?: DataDatabricksJobJobSettingsSettingsJobClusterNewClusterInitScriptsAbfss;
    /**
    * dbfs block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#dbfs DataDatabricksJob#dbfs}
    */
    readonly dbfs?: DataDatabricksJobJobSettingsSettingsJobClusterNewClusterInitScriptsDbfs;
    /**
    * file block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#file DataDatabricksJob#file}
    */
    readonly file?: DataDatabricksJobJobSettingsSettingsJobClusterNewClusterInitScriptsFile;
    /**
    * gcs block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#gcs DataDatabricksJob#gcs}
    */
    readonly gcs?: DataDatabricksJobJobSettingsSettingsJobClusterNewClusterInitScriptsGcs;
    /**
    * s3 block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#s3 DataDatabricksJob#s3}
    */
    readonly s3?: DataDatabricksJobJobSettingsSettingsJobClusterNewClusterInitScriptsS3;
}
export declare function dataDatabricksJobJobSettingsSettingsJobClusterNewClusterInitScriptsToTerraform(struct?: DataDatabricksJobJobSettingsSettingsJobClusterNewClusterInitScripts | cdktf.IResolvable): any;
export declare class DataDatabricksJobJobSettingsSettingsJobClusterNewClusterInitScriptsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDatabricksJobJobSettingsSettingsJobClusterNewClusterInitScripts | cdktf.IResolvable | undefined;
    set internalValue(value: DataDatabricksJobJobSettingsSettingsJobClusterNewClusterInitScripts | cdktf.IResolvable | undefined);
    private _abfss;
    get abfss(): DataDatabricksJobJobSettingsSettingsJobClusterNewClusterInitScriptsAbfssOutputReference;
    putAbfss(value: DataDatabricksJobJobSettingsSettingsJobClusterNewClusterInitScriptsAbfss): void;
    resetAbfss(): void;
    get abfssInput(): DataDatabricksJobJobSettingsSettingsJobClusterNewClusterInitScriptsAbfss | undefined;
    private _dbfs;
    get dbfs(): DataDatabricksJobJobSettingsSettingsJobClusterNewClusterInitScriptsDbfsOutputReference;
    putDbfs(value: DataDatabricksJobJobSettingsSettingsJobClusterNewClusterInitScriptsDbfs): void;
    resetDbfs(): void;
    get dbfsInput(): DataDatabricksJobJobSettingsSettingsJobClusterNewClusterInitScriptsDbfs | undefined;
    private _file;
    get file(): DataDatabricksJobJobSettingsSettingsJobClusterNewClusterInitScriptsFileOutputReference;
    putFile(value: DataDatabricksJobJobSettingsSettingsJobClusterNewClusterInitScriptsFile): void;
    resetFile(): void;
    get fileInput(): DataDatabricksJobJobSettingsSettingsJobClusterNewClusterInitScriptsFile | undefined;
    private _gcs;
    get gcs(): DataDatabricksJobJobSettingsSettingsJobClusterNewClusterInitScriptsGcsOutputReference;
    putGcs(value: DataDatabricksJobJobSettingsSettingsJobClusterNewClusterInitScriptsGcs): void;
    resetGcs(): void;
    get gcsInput(): DataDatabricksJobJobSettingsSettingsJobClusterNewClusterInitScriptsGcs | undefined;
    private _s3;
    get s3(): DataDatabricksJobJobSettingsSettingsJobClusterNewClusterInitScriptsS3OutputReference;
    putS3(value: DataDatabricksJobJobSettingsSettingsJobClusterNewClusterInitScriptsS3): void;
    resetS3(): void;
    get s3Input(): DataDatabricksJobJobSettingsSettingsJobClusterNewClusterInitScriptsS3 | undefined;
}
export declare class DataDatabricksJobJobSettingsSettingsJobClusterNewClusterInitScriptsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DataDatabricksJobJobSettingsSettingsJobClusterNewClusterInitScripts[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDatabricksJobJobSettingsSettingsJobClusterNewClusterInitScriptsOutputReference;
}
export interface DataDatabricksJobJobSettingsSettingsJobClusterNewClusterWorkloadTypeClients {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#jobs DataDatabricksJob#jobs}
    */
    readonly jobs?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#notebooks DataDatabricksJob#notebooks}
    */
    readonly notebooks?: boolean | cdktf.IResolvable;
}
export declare function dataDatabricksJobJobSettingsSettingsJobClusterNewClusterWorkloadTypeClientsToTerraform(struct?: DataDatabricksJobJobSettingsSettingsJobClusterNewClusterWorkloadTypeClientsOutputReference | DataDatabricksJobJobSettingsSettingsJobClusterNewClusterWorkloadTypeClients): any;
export declare class DataDatabricksJobJobSettingsSettingsJobClusterNewClusterWorkloadTypeClientsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksJobJobSettingsSettingsJobClusterNewClusterWorkloadTypeClients | undefined;
    set internalValue(value: DataDatabricksJobJobSettingsSettingsJobClusterNewClusterWorkloadTypeClients | undefined);
    private _jobs?;
    get jobs(): boolean | cdktf.IResolvable;
    set jobs(value: boolean | cdktf.IResolvable);
    resetJobs(): void;
    get jobsInput(): boolean | cdktf.IResolvable | undefined;
    private _notebooks?;
    get notebooks(): boolean | cdktf.IResolvable;
    set notebooks(value: boolean | cdktf.IResolvable);
    resetNotebooks(): void;
    get notebooksInput(): boolean | cdktf.IResolvable | undefined;
}
export interface DataDatabricksJobJobSettingsSettingsJobClusterNewClusterWorkloadType {
    /**
    * clients block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#clients DataDatabricksJob#clients}
    */
    readonly clients: DataDatabricksJobJobSettingsSettingsJobClusterNewClusterWorkloadTypeClients;
}
export declare function dataDatabricksJobJobSettingsSettingsJobClusterNewClusterWorkloadTypeToTerraform(struct?: DataDatabricksJobJobSettingsSettingsJobClusterNewClusterWorkloadTypeOutputReference | DataDatabricksJobJobSettingsSettingsJobClusterNewClusterWorkloadType): any;
export declare class DataDatabricksJobJobSettingsSettingsJobClusterNewClusterWorkloadTypeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksJobJobSettingsSettingsJobClusterNewClusterWorkloadType | undefined;
    set internalValue(value: DataDatabricksJobJobSettingsSettingsJobClusterNewClusterWorkloadType | undefined);
    private _clients;
    get clients(): DataDatabricksJobJobSettingsSettingsJobClusterNewClusterWorkloadTypeClientsOutputReference;
    putClients(value: DataDatabricksJobJobSettingsSettingsJobClusterNewClusterWorkloadTypeClients): void;
    get clientsInput(): DataDatabricksJobJobSettingsSettingsJobClusterNewClusterWorkloadTypeClients | undefined;
}
export interface DataDatabricksJobJobSettingsSettingsJobClusterNewCluster {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#apply_policy_default_values DataDatabricksJob#apply_policy_default_values}
    */
    readonly applyPolicyDefaultValues?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#autotermination_minutes DataDatabricksJob#autotermination_minutes}
    */
    readonly autoterminationMinutes?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#cluster_id DataDatabricksJob#cluster_id}
    */
    readonly clusterId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#cluster_name DataDatabricksJob#cluster_name}
    */
    readonly clusterName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#custom_tags DataDatabricksJob#custom_tags}
    */
    readonly customTags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#data_security_mode DataDatabricksJob#data_security_mode}
    */
    readonly dataSecurityMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#driver_instance_pool_id DataDatabricksJob#driver_instance_pool_id}
    */
    readonly driverInstancePoolId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#driver_node_type_id DataDatabricksJob#driver_node_type_id}
    */
    readonly driverNodeTypeId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#enable_elastic_disk DataDatabricksJob#enable_elastic_disk}
    */
    readonly enableElasticDisk?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#enable_local_disk_encryption DataDatabricksJob#enable_local_disk_encryption}
    */
    readonly enableLocalDiskEncryption?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#idempotency_token DataDatabricksJob#idempotency_token}
    */
    readonly idempotencyToken?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#instance_pool_id DataDatabricksJob#instance_pool_id}
    */
    readonly instancePoolId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#node_type_id DataDatabricksJob#node_type_id}
    */
    readonly nodeTypeId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#num_workers DataDatabricksJob#num_workers}
    */
    readonly numWorkers: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#policy_id DataDatabricksJob#policy_id}
    */
    readonly policyId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#runtime_engine DataDatabricksJob#runtime_engine}
    */
    readonly runtimeEngine?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#single_user_name DataDatabricksJob#single_user_name}
    */
    readonly singleUserName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#spark_conf DataDatabricksJob#spark_conf}
    */
    readonly sparkConf?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#spark_env_vars DataDatabricksJob#spark_env_vars}
    */
    readonly sparkEnvVars?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#spark_version DataDatabricksJob#spark_version}
    */
    readonly sparkVersion: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#ssh_public_keys DataDatabricksJob#ssh_public_keys}
    */
    readonly sshPublicKeys?: string[];
    /**
    * autoscale block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#autoscale DataDatabricksJob#autoscale}
    */
    readonly autoscale?: DataDatabricksJobJobSettingsSettingsJobClusterNewClusterAutoscale;
    /**
    * aws_attributes block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#aws_attributes DataDatabricksJob#aws_attributes}
    */
    readonly awsAttributes?: DataDatabricksJobJobSettingsSettingsJobClusterNewClusterAwsAttributes;
    /**
    * azure_attributes block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#azure_attributes DataDatabricksJob#azure_attributes}
    */
    readonly azureAttributes?: DataDatabricksJobJobSettingsSettingsJobClusterNewClusterAzureAttributes;
    /**
    * cluster_log_conf block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#cluster_log_conf DataDatabricksJob#cluster_log_conf}
    */
    readonly clusterLogConf?: DataDatabricksJobJobSettingsSettingsJobClusterNewClusterClusterLogConf;
    /**
    * cluster_mount_info block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#cluster_mount_info DataDatabricksJob#cluster_mount_info}
    */
    readonly clusterMountInfo?: DataDatabricksJobJobSettingsSettingsJobClusterNewClusterClusterMountInfo[] | cdktf.IResolvable;
    /**
    * docker_image block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#docker_image DataDatabricksJob#docker_image}
    */
    readonly dockerImage?: DataDatabricksJobJobSettingsSettingsJobClusterNewClusterDockerImage;
    /**
    * gcp_attributes block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#gcp_attributes DataDatabricksJob#gcp_attributes}
    */
    readonly gcpAttributes?: DataDatabricksJobJobSettingsSettingsJobClusterNewClusterGcpAttributes;
    /**
    * init_scripts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#init_scripts DataDatabricksJob#init_scripts}
    */
    readonly initScripts?: DataDatabricksJobJobSettingsSettingsJobClusterNewClusterInitScripts[] | cdktf.IResolvable;
    /**
    * workload_type block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#workload_type DataDatabricksJob#workload_type}
    */
    readonly workloadType?: DataDatabricksJobJobSettingsSettingsJobClusterNewClusterWorkloadType;
}
export declare function dataDatabricksJobJobSettingsSettingsJobClusterNewClusterToTerraform(struct?: DataDatabricksJobJobSettingsSettingsJobClusterNewClusterOutputReference | DataDatabricksJobJobSettingsSettingsJobClusterNewCluster): any;
export declare class DataDatabricksJobJobSettingsSettingsJobClusterNewClusterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksJobJobSettingsSettingsJobClusterNewCluster | undefined;
    set internalValue(value: DataDatabricksJobJobSettingsSettingsJobClusterNewCluster | undefined);
    private _applyPolicyDefaultValues?;
    get applyPolicyDefaultValues(): boolean | cdktf.IResolvable;
    set applyPolicyDefaultValues(value: boolean | cdktf.IResolvable);
    resetApplyPolicyDefaultValues(): void;
    get applyPolicyDefaultValuesInput(): boolean | cdktf.IResolvable | undefined;
    private _autoterminationMinutes?;
    get autoterminationMinutes(): number;
    set autoterminationMinutes(value: number);
    resetAutoterminationMinutes(): void;
    get autoterminationMinutesInput(): number | undefined;
    private _clusterId?;
    get clusterId(): string;
    set clusterId(value: string);
    resetClusterId(): void;
    get clusterIdInput(): string | undefined;
    private _clusterName?;
    get clusterName(): string;
    set clusterName(value: string);
    resetClusterName(): void;
    get clusterNameInput(): string | undefined;
    private _customTags?;
    get customTags(): {
        [key: string]: string;
    };
    set customTags(value: {
        [key: string]: string;
    });
    resetCustomTags(): void;
    get customTagsInput(): {
        [key: string]: string;
    } | undefined;
    private _dataSecurityMode?;
    get dataSecurityMode(): string;
    set dataSecurityMode(value: string);
    resetDataSecurityMode(): void;
    get dataSecurityModeInput(): string | undefined;
    private _driverInstancePoolId?;
    get driverInstancePoolId(): string;
    set driverInstancePoolId(value: string);
    resetDriverInstancePoolId(): void;
    get driverInstancePoolIdInput(): string | undefined;
    private _driverNodeTypeId?;
    get driverNodeTypeId(): string;
    set driverNodeTypeId(value: string);
    resetDriverNodeTypeId(): void;
    get driverNodeTypeIdInput(): string | undefined;
    private _enableElasticDisk?;
    get enableElasticDisk(): boolean | cdktf.IResolvable;
    set enableElasticDisk(value: boolean | cdktf.IResolvable);
    resetEnableElasticDisk(): void;
    get enableElasticDiskInput(): boolean | cdktf.IResolvable | undefined;
    private _enableLocalDiskEncryption?;
    get enableLocalDiskEncryption(): boolean | cdktf.IResolvable;
    set enableLocalDiskEncryption(value: boolean | cdktf.IResolvable);
    resetEnableLocalDiskEncryption(): void;
    get enableLocalDiskEncryptionInput(): boolean | cdktf.IResolvable | undefined;
    private _idempotencyToken?;
    get idempotencyToken(): string;
    set idempotencyToken(value: string);
    resetIdempotencyToken(): void;
    get idempotencyTokenInput(): string | undefined;
    private _instancePoolId?;
    get instancePoolId(): string;
    set instancePoolId(value: string);
    resetInstancePoolId(): void;
    get instancePoolIdInput(): string | undefined;
    private _nodeTypeId?;
    get nodeTypeId(): string;
    set nodeTypeId(value: string);
    resetNodeTypeId(): void;
    get nodeTypeIdInput(): string | undefined;
    private _numWorkers?;
    get numWorkers(): number;
    set numWorkers(value: number);
    get numWorkersInput(): number | undefined;
    private _policyId?;
    get policyId(): string;
    set policyId(value: string);
    resetPolicyId(): void;
    get policyIdInput(): string | undefined;
    private _runtimeEngine?;
    get runtimeEngine(): string;
    set runtimeEngine(value: string);
    resetRuntimeEngine(): void;
    get runtimeEngineInput(): string | undefined;
    private _singleUserName?;
    get singleUserName(): string;
    set singleUserName(value: string);
    resetSingleUserName(): void;
    get singleUserNameInput(): string | undefined;
    private _sparkConf?;
    get sparkConf(): {
        [key: string]: string;
    };
    set sparkConf(value: {
        [key: string]: string;
    });
    resetSparkConf(): void;
    get sparkConfInput(): {
        [key: string]: string;
    } | undefined;
    private _sparkEnvVars?;
    get sparkEnvVars(): {
        [key: string]: string;
    };
    set sparkEnvVars(value: {
        [key: string]: string;
    });
    resetSparkEnvVars(): void;
    get sparkEnvVarsInput(): {
        [key: string]: string;
    } | undefined;
    private _sparkVersion?;
    get sparkVersion(): string;
    set sparkVersion(value: string);
    get sparkVersionInput(): string | undefined;
    private _sshPublicKeys?;
    get sshPublicKeys(): string[];
    set sshPublicKeys(value: string[]);
    resetSshPublicKeys(): void;
    get sshPublicKeysInput(): string[] | undefined;
    private _autoscale;
    get autoscale(): DataDatabricksJobJobSettingsSettingsJobClusterNewClusterAutoscaleOutputReference;
    putAutoscale(value: DataDatabricksJobJobSettingsSettingsJobClusterNewClusterAutoscale): void;
    resetAutoscale(): void;
    get autoscaleInput(): DataDatabricksJobJobSettingsSettingsJobClusterNewClusterAutoscale | undefined;
    private _awsAttributes;
    get awsAttributes(): DataDatabricksJobJobSettingsSettingsJobClusterNewClusterAwsAttributesOutputReference;
    putAwsAttributes(value: DataDatabricksJobJobSettingsSettingsJobClusterNewClusterAwsAttributes): void;
    resetAwsAttributes(): void;
    get awsAttributesInput(): DataDatabricksJobJobSettingsSettingsJobClusterNewClusterAwsAttributes | undefined;
    private _azureAttributes;
    get azureAttributes(): DataDatabricksJobJobSettingsSettingsJobClusterNewClusterAzureAttributesOutputReference;
    putAzureAttributes(value: DataDatabricksJobJobSettingsSettingsJobClusterNewClusterAzureAttributes): void;
    resetAzureAttributes(): void;
    get azureAttributesInput(): DataDatabricksJobJobSettingsSettingsJobClusterNewClusterAzureAttributes | undefined;
    private _clusterLogConf;
    get clusterLogConf(): DataDatabricksJobJobSettingsSettingsJobClusterNewClusterClusterLogConfOutputReference;
    putClusterLogConf(value: DataDatabricksJobJobSettingsSettingsJobClusterNewClusterClusterLogConf): void;
    resetClusterLogConf(): void;
    get clusterLogConfInput(): DataDatabricksJobJobSettingsSettingsJobClusterNewClusterClusterLogConf | undefined;
    private _clusterMountInfo;
    get clusterMountInfo(): DataDatabricksJobJobSettingsSettingsJobClusterNewClusterClusterMountInfoList;
    putClusterMountInfo(value: DataDatabricksJobJobSettingsSettingsJobClusterNewClusterClusterMountInfo[] | cdktf.IResolvable): void;
    resetClusterMountInfo(): void;
    get clusterMountInfoInput(): cdktf.IResolvable | DataDatabricksJobJobSettingsSettingsJobClusterNewClusterClusterMountInfo[] | undefined;
    private _dockerImage;
    get dockerImage(): DataDatabricksJobJobSettingsSettingsJobClusterNewClusterDockerImageOutputReference;
    putDockerImage(value: DataDatabricksJobJobSettingsSettingsJobClusterNewClusterDockerImage): void;
    resetDockerImage(): void;
    get dockerImageInput(): DataDatabricksJobJobSettingsSettingsJobClusterNewClusterDockerImage | undefined;
    private _gcpAttributes;
    get gcpAttributes(): DataDatabricksJobJobSettingsSettingsJobClusterNewClusterGcpAttributesOutputReference;
    putGcpAttributes(value: DataDatabricksJobJobSettingsSettingsJobClusterNewClusterGcpAttributes): void;
    resetGcpAttributes(): void;
    get gcpAttributesInput(): DataDatabricksJobJobSettingsSettingsJobClusterNewClusterGcpAttributes | undefined;
    private _initScripts;
    get initScripts(): DataDatabricksJobJobSettingsSettingsJobClusterNewClusterInitScriptsList;
    putInitScripts(value: DataDatabricksJobJobSettingsSettingsJobClusterNewClusterInitScripts[] | cdktf.IResolvable): void;
    resetInitScripts(): void;
    get initScriptsInput(): cdktf.IResolvable | DataDatabricksJobJobSettingsSettingsJobClusterNewClusterInitScripts[] | undefined;
    private _workloadType;
    get workloadType(): DataDatabricksJobJobSettingsSettingsJobClusterNewClusterWorkloadTypeOutputReference;
    putWorkloadType(value: DataDatabricksJobJobSettingsSettingsJobClusterNewClusterWorkloadType): void;
    resetWorkloadType(): void;
    get workloadTypeInput(): DataDatabricksJobJobSettingsSettingsJobClusterNewClusterWorkloadType | undefined;
}
export interface DataDatabricksJobJobSettingsSettingsJobCluster {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#job_cluster_key DataDatabricksJob#job_cluster_key}
    */
    readonly jobClusterKey?: string;
    /**
    * new_cluster block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#new_cluster DataDatabricksJob#new_cluster}
    */
    readonly newCluster?: DataDatabricksJobJobSettingsSettingsJobClusterNewCluster;
}
export declare function dataDatabricksJobJobSettingsSettingsJobClusterToTerraform(struct?: DataDatabricksJobJobSettingsSettingsJobCluster | cdktf.IResolvable): any;
export declare class DataDatabricksJobJobSettingsSettingsJobClusterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDatabricksJobJobSettingsSettingsJobCluster | cdktf.IResolvable | undefined;
    set internalValue(value: DataDatabricksJobJobSettingsSettingsJobCluster | cdktf.IResolvable | undefined);
    private _jobClusterKey?;
    get jobClusterKey(): string;
    set jobClusterKey(value: string);
    resetJobClusterKey(): void;
    get jobClusterKeyInput(): string | undefined;
    private _newCluster;
    get newCluster(): DataDatabricksJobJobSettingsSettingsJobClusterNewClusterOutputReference;
    putNewCluster(value: DataDatabricksJobJobSettingsSettingsJobClusterNewCluster): void;
    resetNewCluster(): void;
    get newClusterInput(): DataDatabricksJobJobSettingsSettingsJobClusterNewCluster | undefined;
}
export declare class DataDatabricksJobJobSettingsSettingsJobClusterList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DataDatabricksJobJobSettingsSettingsJobCluster[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDatabricksJobJobSettingsSettingsJobClusterOutputReference;
}
export interface DataDatabricksJobJobSettingsSettingsLibraryCran {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#package DataDatabricksJob#package}
    */
    readonly package: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#repo DataDatabricksJob#repo}
    */
    readonly repo?: string;
}
export declare function dataDatabricksJobJobSettingsSettingsLibraryCranToTerraform(struct?: DataDatabricksJobJobSettingsSettingsLibraryCranOutputReference | DataDatabricksJobJobSettingsSettingsLibraryCran): any;
export declare class DataDatabricksJobJobSettingsSettingsLibraryCranOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksJobJobSettingsSettingsLibraryCran | undefined;
    set internalValue(value: DataDatabricksJobJobSettingsSettingsLibraryCran | undefined);
    private _package?;
    get package(): string;
    set package(value: string);
    get packageInput(): string | undefined;
    private _repo?;
    get repo(): string;
    set repo(value: string);
    resetRepo(): void;
    get repoInput(): string | undefined;
}
export interface DataDatabricksJobJobSettingsSettingsLibraryMaven {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#coordinates DataDatabricksJob#coordinates}
    */
    readonly coordinates: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#exclusions DataDatabricksJob#exclusions}
    */
    readonly exclusions?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#repo DataDatabricksJob#repo}
    */
    readonly repo?: string;
}
export declare function dataDatabricksJobJobSettingsSettingsLibraryMavenToTerraform(struct?: DataDatabricksJobJobSettingsSettingsLibraryMavenOutputReference | DataDatabricksJobJobSettingsSettingsLibraryMaven): any;
export declare class DataDatabricksJobJobSettingsSettingsLibraryMavenOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksJobJobSettingsSettingsLibraryMaven | undefined;
    set internalValue(value: DataDatabricksJobJobSettingsSettingsLibraryMaven | undefined);
    private _coordinates?;
    get coordinates(): string;
    set coordinates(value: string);
    get coordinatesInput(): string | undefined;
    private _exclusions?;
    get exclusions(): string[];
    set exclusions(value: string[]);
    resetExclusions(): void;
    get exclusionsInput(): string[] | undefined;
    private _repo?;
    get repo(): string;
    set repo(value: string);
    resetRepo(): void;
    get repoInput(): string | undefined;
}
export interface DataDatabricksJobJobSettingsSettingsLibraryPypi {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#package DataDatabricksJob#package}
    */
    readonly package: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#repo DataDatabricksJob#repo}
    */
    readonly repo?: string;
}
export declare function dataDatabricksJobJobSettingsSettingsLibraryPypiToTerraform(struct?: DataDatabricksJobJobSettingsSettingsLibraryPypiOutputReference | DataDatabricksJobJobSettingsSettingsLibraryPypi): any;
export declare class DataDatabricksJobJobSettingsSettingsLibraryPypiOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksJobJobSettingsSettingsLibraryPypi | undefined;
    set internalValue(value: DataDatabricksJobJobSettingsSettingsLibraryPypi | undefined);
    private _package?;
    get package(): string;
    set package(value: string);
    get packageInput(): string | undefined;
    private _repo?;
    get repo(): string;
    set repo(value: string);
    resetRepo(): void;
    get repoInput(): string | undefined;
}
export interface DataDatabricksJobJobSettingsSettingsLibrary {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#egg DataDatabricksJob#egg}
    */
    readonly egg?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#jar DataDatabricksJob#jar}
    */
    readonly jar?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#whl DataDatabricksJob#whl}
    */
    readonly whl?: string;
    /**
    * cran block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#cran DataDatabricksJob#cran}
    */
    readonly cran?: DataDatabricksJobJobSettingsSettingsLibraryCran;
    /**
    * maven block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#maven DataDatabricksJob#maven}
    */
    readonly maven?: DataDatabricksJobJobSettingsSettingsLibraryMaven;
    /**
    * pypi block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#pypi DataDatabricksJob#pypi}
    */
    readonly pypi?: DataDatabricksJobJobSettingsSettingsLibraryPypi;
}
export declare function dataDatabricksJobJobSettingsSettingsLibraryToTerraform(struct?: DataDatabricksJobJobSettingsSettingsLibrary | cdktf.IResolvable): any;
export declare class DataDatabricksJobJobSettingsSettingsLibraryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDatabricksJobJobSettingsSettingsLibrary | cdktf.IResolvable | undefined;
    set internalValue(value: DataDatabricksJobJobSettingsSettingsLibrary | cdktf.IResolvable | undefined);
    private _egg?;
    get egg(): string;
    set egg(value: string);
    resetEgg(): void;
    get eggInput(): string | undefined;
    private _jar?;
    get jar(): string;
    set jar(value: string);
    resetJar(): void;
    get jarInput(): string | undefined;
    private _whl?;
    get whl(): string;
    set whl(value: string);
    resetWhl(): void;
    get whlInput(): string | undefined;
    private _cran;
    get cran(): DataDatabricksJobJobSettingsSettingsLibraryCranOutputReference;
    putCran(value: DataDatabricksJobJobSettingsSettingsLibraryCran): void;
    resetCran(): void;
    get cranInput(): DataDatabricksJobJobSettingsSettingsLibraryCran | undefined;
    private _maven;
    get maven(): DataDatabricksJobJobSettingsSettingsLibraryMavenOutputReference;
    putMaven(value: DataDatabricksJobJobSettingsSettingsLibraryMaven): void;
    resetMaven(): void;
    get mavenInput(): DataDatabricksJobJobSettingsSettingsLibraryMaven | undefined;
    private _pypi;
    get pypi(): DataDatabricksJobJobSettingsSettingsLibraryPypiOutputReference;
    putPypi(value: DataDatabricksJobJobSettingsSettingsLibraryPypi): void;
    resetPypi(): void;
    get pypiInput(): DataDatabricksJobJobSettingsSettingsLibraryPypi | undefined;
}
export declare class DataDatabricksJobJobSettingsSettingsLibraryList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DataDatabricksJobJobSettingsSettingsLibrary[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDatabricksJobJobSettingsSettingsLibraryOutputReference;
}
export interface DataDatabricksJobJobSettingsSettingsNewClusterAutoscale {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#max_workers DataDatabricksJob#max_workers}
    */
    readonly maxWorkers?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#min_workers DataDatabricksJob#min_workers}
    */
    readonly minWorkers?: number;
}
export declare function dataDatabricksJobJobSettingsSettingsNewClusterAutoscaleToTerraform(struct?: DataDatabricksJobJobSettingsSettingsNewClusterAutoscaleOutputReference | DataDatabricksJobJobSettingsSettingsNewClusterAutoscale): any;
export declare class DataDatabricksJobJobSettingsSettingsNewClusterAutoscaleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksJobJobSettingsSettingsNewClusterAutoscale | undefined;
    set internalValue(value: DataDatabricksJobJobSettingsSettingsNewClusterAutoscale | undefined);
    private _maxWorkers?;
    get maxWorkers(): number;
    set maxWorkers(value: number);
    resetMaxWorkers(): void;
    get maxWorkersInput(): number | undefined;
    private _minWorkers?;
    get minWorkers(): number;
    set minWorkers(value: number);
    resetMinWorkers(): void;
    get minWorkersInput(): number | undefined;
}
export interface DataDatabricksJobJobSettingsSettingsNewClusterAwsAttributes {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#availability DataDatabricksJob#availability}
    */
    readonly availability?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#ebs_volume_count DataDatabricksJob#ebs_volume_count}
    */
    readonly ebsVolumeCount?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#ebs_volume_size DataDatabricksJob#ebs_volume_size}
    */
    readonly ebsVolumeSize?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#ebs_volume_type DataDatabricksJob#ebs_volume_type}
    */
    readonly ebsVolumeType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#first_on_demand DataDatabricksJob#first_on_demand}
    */
    readonly firstOnDemand?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#instance_profile_arn DataDatabricksJob#instance_profile_arn}
    */
    readonly instanceProfileArn?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#spot_bid_price_percent DataDatabricksJob#spot_bid_price_percent}
    */
    readonly spotBidPricePercent?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#zone_id DataDatabricksJob#zone_id}
    */
    readonly zoneId?: string;
}
export declare function dataDatabricksJobJobSettingsSettingsNewClusterAwsAttributesToTerraform(struct?: DataDatabricksJobJobSettingsSettingsNewClusterAwsAttributesOutputReference | DataDatabricksJobJobSettingsSettingsNewClusterAwsAttributes): any;
export declare class DataDatabricksJobJobSettingsSettingsNewClusterAwsAttributesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksJobJobSettingsSettingsNewClusterAwsAttributes | undefined;
    set internalValue(value: DataDatabricksJobJobSettingsSettingsNewClusterAwsAttributes | undefined);
    private _availability?;
    get availability(): string;
    set availability(value: string);
    resetAvailability(): void;
    get availabilityInput(): string | undefined;
    private _ebsVolumeCount?;
    get ebsVolumeCount(): number;
    set ebsVolumeCount(value: number);
    resetEbsVolumeCount(): void;
    get ebsVolumeCountInput(): number | undefined;
    private _ebsVolumeSize?;
    get ebsVolumeSize(): number;
    set ebsVolumeSize(value: number);
    resetEbsVolumeSize(): void;
    get ebsVolumeSizeInput(): number | undefined;
    private _ebsVolumeType?;
    get ebsVolumeType(): string;
    set ebsVolumeType(value: string);
    resetEbsVolumeType(): void;
    get ebsVolumeTypeInput(): string | undefined;
    private _firstOnDemand?;
    get firstOnDemand(): number;
    set firstOnDemand(value: number);
    resetFirstOnDemand(): void;
    get firstOnDemandInput(): number | undefined;
    private _instanceProfileArn?;
    get instanceProfileArn(): string;
    set instanceProfileArn(value: string);
    resetInstanceProfileArn(): void;
    get instanceProfileArnInput(): string | undefined;
    private _spotBidPricePercent?;
    get spotBidPricePercent(): number;
    set spotBidPricePercent(value: number);
    resetSpotBidPricePercent(): void;
    get spotBidPricePercentInput(): number | undefined;
    private _zoneId?;
    get zoneId(): string;
    set zoneId(value: string);
    resetZoneId(): void;
    get zoneIdInput(): string | undefined;
}
export interface DataDatabricksJobJobSettingsSettingsNewClusterAzureAttributes {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#availability DataDatabricksJob#availability}
    */
    readonly availability?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#first_on_demand DataDatabricksJob#first_on_demand}
    */
    readonly firstOnDemand?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#spot_bid_max_price DataDatabricksJob#spot_bid_max_price}
    */
    readonly spotBidMaxPrice?: number;
}
export declare function dataDatabricksJobJobSettingsSettingsNewClusterAzureAttributesToTerraform(struct?: DataDatabricksJobJobSettingsSettingsNewClusterAzureAttributesOutputReference | DataDatabricksJobJobSettingsSettingsNewClusterAzureAttributes): any;
export declare class DataDatabricksJobJobSettingsSettingsNewClusterAzureAttributesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksJobJobSettingsSettingsNewClusterAzureAttributes | undefined;
    set internalValue(value: DataDatabricksJobJobSettingsSettingsNewClusterAzureAttributes | undefined);
    private _availability?;
    get availability(): string;
    set availability(value: string);
    resetAvailability(): void;
    get availabilityInput(): string | undefined;
    private _firstOnDemand?;
    get firstOnDemand(): number;
    set firstOnDemand(value: number);
    resetFirstOnDemand(): void;
    get firstOnDemandInput(): number | undefined;
    private _spotBidMaxPrice?;
    get spotBidMaxPrice(): number;
    set spotBidMaxPrice(value: number);
    resetSpotBidMaxPrice(): void;
    get spotBidMaxPriceInput(): number | undefined;
}
export interface DataDatabricksJobJobSettingsSettingsNewClusterClusterLogConfDbfs {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#destination DataDatabricksJob#destination}
    */
    readonly destination: string;
}
export declare function dataDatabricksJobJobSettingsSettingsNewClusterClusterLogConfDbfsToTerraform(struct?: DataDatabricksJobJobSettingsSettingsNewClusterClusterLogConfDbfsOutputReference | DataDatabricksJobJobSettingsSettingsNewClusterClusterLogConfDbfs): any;
export declare class DataDatabricksJobJobSettingsSettingsNewClusterClusterLogConfDbfsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksJobJobSettingsSettingsNewClusterClusterLogConfDbfs | undefined;
    set internalValue(value: DataDatabricksJobJobSettingsSettingsNewClusterClusterLogConfDbfs | undefined);
    private _destination?;
    get destination(): string;
    set destination(value: string);
    get destinationInput(): string | undefined;
}
export interface DataDatabricksJobJobSettingsSettingsNewClusterClusterLogConfS3 {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#canned_acl DataDatabricksJob#canned_acl}
    */
    readonly cannedAcl?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#destination DataDatabricksJob#destination}
    */
    readonly destination: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#enable_encryption DataDatabricksJob#enable_encryption}
    */
    readonly enableEncryption?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#encryption_type DataDatabricksJob#encryption_type}
    */
    readonly encryptionType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#endpoint DataDatabricksJob#endpoint}
    */
    readonly endpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#kms_key DataDatabricksJob#kms_key}
    */
    readonly kmsKey?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#region DataDatabricksJob#region}
    */
    readonly region?: string;
}
export declare function dataDatabricksJobJobSettingsSettingsNewClusterClusterLogConfS3ToTerraform(struct?: DataDatabricksJobJobSettingsSettingsNewClusterClusterLogConfS3OutputReference | DataDatabricksJobJobSettingsSettingsNewClusterClusterLogConfS3): any;
export declare class DataDatabricksJobJobSettingsSettingsNewClusterClusterLogConfS3OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksJobJobSettingsSettingsNewClusterClusterLogConfS3 | undefined;
    set internalValue(value: DataDatabricksJobJobSettingsSettingsNewClusterClusterLogConfS3 | undefined);
    private _cannedAcl?;
    get cannedAcl(): string;
    set cannedAcl(value: string);
    resetCannedAcl(): void;
    get cannedAclInput(): string | undefined;
    private _destination?;
    get destination(): string;
    set destination(value: string);
    get destinationInput(): string | undefined;
    private _enableEncryption?;
    get enableEncryption(): boolean | cdktf.IResolvable;
    set enableEncryption(value: boolean | cdktf.IResolvable);
    resetEnableEncryption(): void;
    get enableEncryptionInput(): boolean | cdktf.IResolvable | undefined;
    private _encryptionType?;
    get encryptionType(): string;
    set encryptionType(value: string);
    resetEncryptionType(): void;
    get encryptionTypeInput(): string | undefined;
    private _endpoint?;
    get endpoint(): string;
    set endpoint(value: string);
    resetEndpoint(): void;
    get endpointInput(): string | undefined;
    private _kmsKey?;
    get kmsKey(): string;
    set kmsKey(value: string);
    resetKmsKey(): void;
    get kmsKeyInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
}
export interface DataDatabricksJobJobSettingsSettingsNewClusterClusterLogConf {
    /**
    * dbfs block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#dbfs DataDatabricksJob#dbfs}
    */
    readonly dbfs?: DataDatabricksJobJobSettingsSettingsNewClusterClusterLogConfDbfs;
    /**
    * s3 block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#s3 DataDatabricksJob#s3}
    */
    readonly s3?: DataDatabricksJobJobSettingsSettingsNewClusterClusterLogConfS3;
}
export declare function dataDatabricksJobJobSettingsSettingsNewClusterClusterLogConfToTerraform(struct?: DataDatabricksJobJobSettingsSettingsNewClusterClusterLogConfOutputReference | DataDatabricksJobJobSettingsSettingsNewClusterClusterLogConf): any;
export declare class DataDatabricksJobJobSettingsSettingsNewClusterClusterLogConfOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksJobJobSettingsSettingsNewClusterClusterLogConf | undefined;
    set internalValue(value: DataDatabricksJobJobSettingsSettingsNewClusterClusterLogConf | undefined);
    private _dbfs;
    get dbfs(): DataDatabricksJobJobSettingsSettingsNewClusterClusterLogConfDbfsOutputReference;
    putDbfs(value: DataDatabricksJobJobSettingsSettingsNewClusterClusterLogConfDbfs): void;
    resetDbfs(): void;
    get dbfsInput(): DataDatabricksJobJobSettingsSettingsNewClusterClusterLogConfDbfs | undefined;
    private _s3;
    get s3(): DataDatabricksJobJobSettingsSettingsNewClusterClusterLogConfS3OutputReference;
    putS3(value: DataDatabricksJobJobSettingsSettingsNewClusterClusterLogConfS3): void;
    resetS3(): void;
    get s3Input(): DataDatabricksJobJobSettingsSettingsNewClusterClusterLogConfS3 | undefined;
}
export interface DataDatabricksJobJobSettingsSettingsNewClusterClusterMountInfoNetworkFilesystemInfo {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#mount_options DataDatabricksJob#mount_options}
    */
    readonly mountOptions?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#server_address DataDatabricksJob#server_address}
    */
    readonly serverAddress: string;
}
export declare function dataDatabricksJobJobSettingsSettingsNewClusterClusterMountInfoNetworkFilesystemInfoToTerraform(struct?: DataDatabricksJobJobSettingsSettingsNewClusterClusterMountInfoNetworkFilesystemInfoOutputReference | DataDatabricksJobJobSettingsSettingsNewClusterClusterMountInfoNetworkFilesystemInfo): any;
export declare class DataDatabricksJobJobSettingsSettingsNewClusterClusterMountInfoNetworkFilesystemInfoOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksJobJobSettingsSettingsNewClusterClusterMountInfoNetworkFilesystemInfo | undefined;
    set internalValue(value: DataDatabricksJobJobSettingsSettingsNewClusterClusterMountInfoNetworkFilesystemInfo | undefined);
    private _mountOptions?;
    get mountOptions(): string;
    set mountOptions(value: string);
    resetMountOptions(): void;
    get mountOptionsInput(): string | undefined;
    private _serverAddress?;
    get serverAddress(): string;
    set serverAddress(value: string);
    get serverAddressInput(): string | undefined;
}
export interface DataDatabricksJobJobSettingsSettingsNewClusterClusterMountInfo {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#local_mount_dir_path DataDatabricksJob#local_mount_dir_path}
    */
    readonly localMountDirPath: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#remote_mount_dir_path DataDatabricksJob#remote_mount_dir_path}
    */
    readonly remoteMountDirPath?: string;
    /**
    * network_filesystem_info block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#network_filesystem_info DataDatabricksJob#network_filesystem_info}
    */
    readonly networkFilesystemInfo: DataDatabricksJobJobSettingsSettingsNewClusterClusterMountInfoNetworkFilesystemInfo;
}
export declare function dataDatabricksJobJobSettingsSettingsNewClusterClusterMountInfoToTerraform(struct?: DataDatabricksJobJobSettingsSettingsNewClusterClusterMountInfo | cdktf.IResolvable): any;
export declare class DataDatabricksJobJobSettingsSettingsNewClusterClusterMountInfoOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDatabricksJobJobSettingsSettingsNewClusterClusterMountInfo | cdktf.IResolvable | undefined;
    set internalValue(value: DataDatabricksJobJobSettingsSettingsNewClusterClusterMountInfo | cdktf.IResolvable | undefined);
    private _localMountDirPath?;
    get localMountDirPath(): string;
    set localMountDirPath(value: string);
    get localMountDirPathInput(): string | undefined;
    private _remoteMountDirPath?;
    get remoteMountDirPath(): string;
    set remoteMountDirPath(value: string);
    resetRemoteMountDirPath(): void;
    get remoteMountDirPathInput(): string | undefined;
    private _networkFilesystemInfo;
    get networkFilesystemInfo(): DataDatabricksJobJobSettingsSettingsNewClusterClusterMountInfoNetworkFilesystemInfoOutputReference;
    putNetworkFilesystemInfo(value: DataDatabricksJobJobSettingsSettingsNewClusterClusterMountInfoNetworkFilesystemInfo): void;
    get networkFilesystemInfoInput(): DataDatabricksJobJobSettingsSettingsNewClusterClusterMountInfoNetworkFilesystemInfo | undefined;
}
export declare class DataDatabricksJobJobSettingsSettingsNewClusterClusterMountInfoList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DataDatabricksJobJobSettingsSettingsNewClusterClusterMountInfo[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDatabricksJobJobSettingsSettingsNewClusterClusterMountInfoOutputReference;
}
export interface DataDatabricksJobJobSettingsSettingsNewClusterDockerImageBasicAuth {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#password DataDatabricksJob#password}
    */
    readonly password: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#username DataDatabricksJob#username}
    */
    readonly username: string;
}
export declare function dataDatabricksJobJobSettingsSettingsNewClusterDockerImageBasicAuthToTerraform(struct?: DataDatabricksJobJobSettingsSettingsNewClusterDockerImageBasicAuthOutputReference | DataDatabricksJobJobSettingsSettingsNewClusterDockerImageBasicAuth): any;
export declare class DataDatabricksJobJobSettingsSettingsNewClusterDockerImageBasicAuthOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksJobJobSettingsSettingsNewClusterDockerImageBasicAuth | undefined;
    set internalValue(value: DataDatabricksJobJobSettingsSettingsNewClusterDockerImageBasicAuth | undefined);
    private _password?;
    get password(): string;
    set password(value: string);
    get passwordInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
}
export interface DataDatabricksJobJobSettingsSettingsNewClusterDockerImage {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#url DataDatabricksJob#url}
    */
    readonly url: string;
    /**
    * basic_auth block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#basic_auth DataDatabricksJob#basic_auth}
    */
    readonly basicAuth?: DataDatabricksJobJobSettingsSettingsNewClusterDockerImageBasicAuth;
}
export declare function dataDatabricksJobJobSettingsSettingsNewClusterDockerImageToTerraform(struct?: DataDatabricksJobJobSettingsSettingsNewClusterDockerImageOutputReference | DataDatabricksJobJobSettingsSettingsNewClusterDockerImage): any;
export declare class DataDatabricksJobJobSettingsSettingsNewClusterDockerImageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksJobJobSettingsSettingsNewClusterDockerImage | undefined;
    set internalValue(value: DataDatabricksJobJobSettingsSettingsNewClusterDockerImage | undefined);
    private _url?;
    get url(): string;
    set url(value: string);
    get urlInput(): string | undefined;
    private _basicAuth;
    get basicAuth(): DataDatabricksJobJobSettingsSettingsNewClusterDockerImageBasicAuthOutputReference;
    putBasicAuth(value: DataDatabricksJobJobSettingsSettingsNewClusterDockerImageBasicAuth): void;
    resetBasicAuth(): void;
    get basicAuthInput(): DataDatabricksJobJobSettingsSettingsNewClusterDockerImageBasicAuth | undefined;
}
export interface DataDatabricksJobJobSettingsSettingsNewClusterGcpAttributes {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#availability DataDatabricksJob#availability}
    */
    readonly availability?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#boot_disk_size DataDatabricksJob#boot_disk_size}
    */
    readonly bootDiskSize?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#google_service_account DataDatabricksJob#google_service_account}
    */
    readonly googleServiceAccount?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#use_preemptible_executors DataDatabricksJob#use_preemptible_executors}
    */
    readonly usePreemptibleExecutors?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#zone_id DataDatabricksJob#zone_id}
    */
    readonly zoneId?: string;
}
export declare function dataDatabricksJobJobSettingsSettingsNewClusterGcpAttributesToTerraform(struct?: DataDatabricksJobJobSettingsSettingsNewClusterGcpAttributesOutputReference | DataDatabricksJobJobSettingsSettingsNewClusterGcpAttributes): any;
export declare class DataDatabricksJobJobSettingsSettingsNewClusterGcpAttributesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksJobJobSettingsSettingsNewClusterGcpAttributes | undefined;
    set internalValue(value: DataDatabricksJobJobSettingsSettingsNewClusterGcpAttributes | undefined);
    private _availability?;
    get availability(): string;
    set availability(value: string);
    resetAvailability(): void;
    get availabilityInput(): string | undefined;
    private _bootDiskSize?;
    get bootDiskSize(): number;
    set bootDiskSize(value: number);
    resetBootDiskSize(): void;
    get bootDiskSizeInput(): number | undefined;
    private _googleServiceAccount?;
    get googleServiceAccount(): string;
    set googleServiceAccount(value: string);
    resetGoogleServiceAccount(): void;
    get googleServiceAccountInput(): string | undefined;
    private _usePreemptibleExecutors?;
    get usePreemptibleExecutors(): boolean | cdktf.IResolvable;
    set usePreemptibleExecutors(value: boolean | cdktf.IResolvable);
    resetUsePreemptibleExecutors(): void;
    get usePreemptibleExecutorsInput(): boolean | cdktf.IResolvable | undefined;
    private _zoneId?;
    get zoneId(): string;
    set zoneId(value: string);
    resetZoneId(): void;
    get zoneIdInput(): string | undefined;
}
export interface DataDatabricksJobJobSettingsSettingsNewClusterInitScriptsAbfss {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#destination DataDatabricksJob#destination}
    */
    readonly destination?: string;
}
export declare function dataDatabricksJobJobSettingsSettingsNewClusterInitScriptsAbfssToTerraform(struct?: DataDatabricksJobJobSettingsSettingsNewClusterInitScriptsAbfssOutputReference | DataDatabricksJobJobSettingsSettingsNewClusterInitScriptsAbfss): any;
export declare class DataDatabricksJobJobSettingsSettingsNewClusterInitScriptsAbfssOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksJobJobSettingsSettingsNewClusterInitScriptsAbfss | undefined;
    set internalValue(value: DataDatabricksJobJobSettingsSettingsNewClusterInitScriptsAbfss | undefined);
    private _destination?;
    get destination(): string;
    set destination(value: string);
    resetDestination(): void;
    get destinationInput(): string | undefined;
}
export interface DataDatabricksJobJobSettingsSettingsNewClusterInitScriptsDbfs {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#destination DataDatabricksJob#destination}
    */
    readonly destination: string;
}
export declare function dataDatabricksJobJobSettingsSettingsNewClusterInitScriptsDbfsToTerraform(struct?: DataDatabricksJobJobSettingsSettingsNewClusterInitScriptsDbfsOutputReference | DataDatabricksJobJobSettingsSettingsNewClusterInitScriptsDbfs): any;
export declare class DataDatabricksJobJobSettingsSettingsNewClusterInitScriptsDbfsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksJobJobSettingsSettingsNewClusterInitScriptsDbfs | undefined;
    set internalValue(value: DataDatabricksJobJobSettingsSettingsNewClusterInitScriptsDbfs | undefined);
    private _destination?;
    get destination(): string;
    set destination(value: string);
    get destinationInput(): string | undefined;
}
export interface DataDatabricksJobJobSettingsSettingsNewClusterInitScriptsFile {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#destination DataDatabricksJob#destination}
    */
    readonly destination?: string;
}
export declare function dataDatabricksJobJobSettingsSettingsNewClusterInitScriptsFileToTerraform(struct?: DataDatabricksJobJobSettingsSettingsNewClusterInitScriptsFileOutputReference | DataDatabricksJobJobSettingsSettingsNewClusterInitScriptsFile): any;
export declare class DataDatabricksJobJobSettingsSettingsNewClusterInitScriptsFileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksJobJobSettingsSettingsNewClusterInitScriptsFile | undefined;
    set internalValue(value: DataDatabricksJobJobSettingsSettingsNewClusterInitScriptsFile | undefined);
    private _destination?;
    get destination(): string;
    set destination(value: string);
    resetDestination(): void;
    get destinationInput(): string | undefined;
}
export interface DataDatabricksJobJobSettingsSettingsNewClusterInitScriptsGcs {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#destination DataDatabricksJob#destination}
    */
    readonly destination?: string;
}
export declare function dataDatabricksJobJobSettingsSettingsNewClusterInitScriptsGcsToTerraform(struct?: DataDatabricksJobJobSettingsSettingsNewClusterInitScriptsGcsOutputReference | DataDatabricksJobJobSettingsSettingsNewClusterInitScriptsGcs): any;
export declare class DataDatabricksJobJobSettingsSettingsNewClusterInitScriptsGcsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksJobJobSettingsSettingsNewClusterInitScriptsGcs | undefined;
    set internalValue(value: DataDatabricksJobJobSettingsSettingsNewClusterInitScriptsGcs | undefined);
    private _destination?;
    get destination(): string;
    set destination(value: string);
    resetDestination(): void;
    get destinationInput(): string | undefined;
}
export interface DataDatabricksJobJobSettingsSettingsNewClusterInitScriptsS3 {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#canned_acl DataDatabricksJob#canned_acl}
    */
    readonly cannedAcl?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#destination DataDatabricksJob#destination}
    */
    readonly destination: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#enable_encryption DataDatabricksJob#enable_encryption}
    */
    readonly enableEncryption?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#encryption_type DataDatabricksJob#encryption_type}
    */
    readonly encryptionType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#endpoint DataDatabricksJob#endpoint}
    */
    readonly endpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#kms_key DataDatabricksJob#kms_key}
    */
    readonly kmsKey?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#region DataDatabricksJob#region}
    */
    readonly region?: string;
}
export declare function dataDatabricksJobJobSettingsSettingsNewClusterInitScriptsS3ToTerraform(struct?: DataDatabricksJobJobSettingsSettingsNewClusterInitScriptsS3OutputReference | DataDatabricksJobJobSettingsSettingsNewClusterInitScriptsS3): any;
export declare class DataDatabricksJobJobSettingsSettingsNewClusterInitScriptsS3OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksJobJobSettingsSettingsNewClusterInitScriptsS3 | undefined;
    set internalValue(value: DataDatabricksJobJobSettingsSettingsNewClusterInitScriptsS3 | undefined);
    private _cannedAcl?;
    get cannedAcl(): string;
    set cannedAcl(value: string);
    resetCannedAcl(): void;
    get cannedAclInput(): string | undefined;
    private _destination?;
    get destination(): string;
    set destination(value: string);
    get destinationInput(): string | undefined;
    private _enableEncryption?;
    get enableEncryption(): boolean | cdktf.IResolvable;
    set enableEncryption(value: boolean | cdktf.IResolvable);
    resetEnableEncryption(): void;
    get enableEncryptionInput(): boolean | cdktf.IResolvable | undefined;
    private _encryptionType?;
    get encryptionType(): string;
    set encryptionType(value: string);
    resetEncryptionType(): void;
    get encryptionTypeInput(): string | undefined;
    private _endpoint?;
    get endpoint(): string;
    set endpoint(value: string);
    resetEndpoint(): void;
    get endpointInput(): string | undefined;
    private _kmsKey?;
    get kmsKey(): string;
    set kmsKey(value: string);
    resetKmsKey(): void;
    get kmsKeyInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
}
export interface DataDatabricksJobJobSettingsSettingsNewClusterInitScripts {
    /**
    * abfss block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#abfss DataDatabricksJob#abfss}
    */
    readonly abfss?: DataDatabricksJobJobSettingsSettingsNewClusterInitScriptsAbfss;
    /**
    * dbfs block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#dbfs DataDatabricksJob#dbfs}
    */
    readonly dbfs?: DataDatabricksJobJobSettingsSettingsNewClusterInitScriptsDbfs;
    /**
    * file block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#file DataDatabricksJob#file}
    */
    readonly file?: DataDatabricksJobJobSettingsSettingsNewClusterInitScriptsFile;
    /**
    * gcs block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#gcs DataDatabricksJob#gcs}
    */
    readonly gcs?: DataDatabricksJobJobSettingsSettingsNewClusterInitScriptsGcs;
    /**
    * s3 block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#s3 DataDatabricksJob#s3}
    */
    readonly s3?: DataDatabricksJobJobSettingsSettingsNewClusterInitScriptsS3;
}
export declare function dataDatabricksJobJobSettingsSettingsNewClusterInitScriptsToTerraform(struct?: DataDatabricksJobJobSettingsSettingsNewClusterInitScripts | cdktf.IResolvable): any;
export declare class DataDatabricksJobJobSettingsSettingsNewClusterInitScriptsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDatabricksJobJobSettingsSettingsNewClusterInitScripts | cdktf.IResolvable | undefined;
    set internalValue(value: DataDatabricksJobJobSettingsSettingsNewClusterInitScripts | cdktf.IResolvable | undefined);
    private _abfss;
    get abfss(): DataDatabricksJobJobSettingsSettingsNewClusterInitScriptsAbfssOutputReference;
    putAbfss(value: DataDatabricksJobJobSettingsSettingsNewClusterInitScriptsAbfss): void;
    resetAbfss(): void;
    get abfssInput(): DataDatabricksJobJobSettingsSettingsNewClusterInitScriptsAbfss | undefined;
    private _dbfs;
    get dbfs(): DataDatabricksJobJobSettingsSettingsNewClusterInitScriptsDbfsOutputReference;
    putDbfs(value: DataDatabricksJobJobSettingsSettingsNewClusterInitScriptsDbfs): void;
    resetDbfs(): void;
    get dbfsInput(): DataDatabricksJobJobSettingsSettingsNewClusterInitScriptsDbfs | undefined;
    private _file;
    get file(): DataDatabricksJobJobSettingsSettingsNewClusterInitScriptsFileOutputReference;
    putFile(value: DataDatabricksJobJobSettingsSettingsNewClusterInitScriptsFile): void;
    resetFile(): void;
    get fileInput(): DataDatabricksJobJobSettingsSettingsNewClusterInitScriptsFile | undefined;
    private _gcs;
    get gcs(): DataDatabricksJobJobSettingsSettingsNewClusterInitScriptsGcsOutputReference;
    putGcs(value: DataDatabricksJobJobSettingsSettingsNewClusterInitScriptsGcs): void;
    resetGcs(): void;
    get gcsInput(): DataDatabricksJobJobSettingsSettingsNewClusterInitScriptsGcs | undefined;
    private _s3;
    get s3(): DataDatabricksJobJobSettingsSettingsNewClusterInitScriptsS3OutputReference;
    putS3(value: DataDatabricksJobJobSettingsSettingsNewClusterInitScriptsS3): void;
    resetS3(): void;
    get s3Input(): DataDatabricksJobJobSettingsSettingsNewClusterInitScriptsS3 | undefined;
}
export declare class DataDatabricksJobJobSettingsSettingsNewClusterInitScriptsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DataDatabricksJobJobSettingsSettingsNewClusterInitScripts[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDatabricksJobJobSettingsSettingsNewClusterInitScriptsOutputReference;
}
export interface DataDatabricksJobJobSettingsSettingsNewClusterWorkloadTypeClients {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#jobs DataDatabricksJob#jobs}
    */
    readonly jobs?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#notebooks DataDatabricksJob#notebooks}
    */
    readonly notebooks?: boolean | cdktf.IResolvable;
}
export declare function dataDatabricksJobJobSettingsSettingsNewClusterWorkloadTypeClientsToTerraform(struct?: DataDatabricksJobJobSettingsSettingsNewClusterWorkloadTypeClientsOutputReference | DataDatabricksJobJobSettingsSettingsNewClusterWorkloadTypeClients): any;
export declare class DataDatabricksJobJobSettingsSettingsNewClusterWorkloadTypeClientsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksJobJobSettingsSettingsNewClusterWorkloadTypeClients | undefined;
    set internalValue(value: DataDatabricksJobJobSettingsSettingsNewClusterWorkloadTypeClients | undefined);
    private _jobs?;
    get jobs(): boolean | cdktf.IResolvable;
    set jobs(value: boolean | cdktf.IResolvable);
    resetJobs(): void;
    get jobsInput(): boolean | cdktf.IResolvable | undefined;
    private _notebooks?;
    get notebooks(): boolean | cdktf.IResolvable;
    set notebooks(value: boolean | cdktf.IResolvable);
    resetNotebooks(): void;
    get notebooksInput(): boolean | cdktf.IResolvable | undefined;
}
export interface DataDatabricksJobJobSettingsSettingsNewClusterWorkloadType {
    /**
    * clients block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#clients DataDatabricksJob#clients}
    */
    readonly clients: DataDatabricksJobJobSettingsSettingsNewClusterWorkloadTypeClients;
}
export declare function dataDatabricksJobJobSettingsSettingsNewClusterWorkloadTypeToTerraform(struct?: DataDatabricksJobJobSettingsSettingsNewClusterWorkloadTypeOutputReference | DataDatabricksJobJobSettingsSettingsNewClusterWorkloadType): any;
export declare class DataDatabricksJobJobSettingsSettingsNewClusterWorkloadTypeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksJobJobSettingsSettingsNewClusterWorkloadType | undefined;
    set internalValue(value: DataDatabricksJobJobSettingsSettingsNewClusterWorkloadType | undefined);
    private _clients;
    get clients(): DataDatabricksJobJobSettingsSettingsNewClusterWorkloadTypeClientsOutputReference;
    putClients(value: DataDatabricksJobJobSettingsSettingsNewClusterWorkloadTypeClients): void;
    get clientsInput(): DataDatabricksJobJobSettingsSettingsNewClusterWorkloadTypeClients | undefined;
}
export interface DataDatabricksJobJobSettingsSettingsNewCluster {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#apply_policy_default_values DataDatabricksJob#apply_policy_default_values}
    */
    readonly applyPolicyDefaultValues?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#autotermination_minutes DataDatabricksJob#autotermination_minutes}
    */
    readonly autoterminationMinutes?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#cluster_id DataDatabricksJob#cluster_id}
    */
    readonly clusterId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#cluster_name DataDatabricksJob#cluster_name}
    */
    readonly clusterName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#custom_tags DataDatabricksJob#custom_tags}
    */
    readonly customTags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#data_security_mode DataDatabricksJob#data_security_mode}
    */
    readonly dataSecurityMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#driver_instance_pool_id DataDatabricksJob#driver_instance_pool_id}
    */
    readonly driverInstancePoolId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#driver_node_type_id DataDatabricksJob#driver_node_type_id}
    */
    readonly driverNodeTypeId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#enable_elastic_disk DataDatabricksJob#enable_elastic_disk}
    */
    readonly enableElasticDisk?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#enable_local_disk_encryption DataDatabricksJob#enable_local_disk_encryption}
    */
    readonly enableLocalDiskEncryption?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#idempotency_token DataDatabricksJob#idempotency_token}
    */
    readonly idempotencyToken?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#instance_pool_id DataDatabricksJob#instance_pool_id}
    */
    readonly instancePoolId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#node_type_id DataDatabricksJob#node_type_id}
    */
    readonly nodeTypeId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#num_workers DataDatabricksJob#num_workers}
    */
    readonly numWorkers: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#policy_id DataDatabricksJob#policy_id}
    */
    readonly policyId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#runtime_engine DataDatabricksJob#runtime_engine}
    */
    readonly runtimeEngine?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#single_user_name DataDatabricksJob#single_user_name}
    */
    readonly singleUserName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#spark_conf DataDatabricksJob#spark_conf}
    */
    readonly sparkConf?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#spark_env_vars DataDatabricksJob#spark_env_vars}
    */
    readonly sparkEnvVars?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#spark_version DataDatabricksJob#spark_version}
    */
    readonly sparkVersion: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#ssh_public_keys DataDatabricksJob#ssh_public_keys}
    */
    readonly sshPublicKeys?: string[];
    /**
    * autoscale block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#autoscale DataDatabricksJob#autoscale}
    */
    readonly autoscale?: DataDatabricksJobJobSettingsSettingsNewClusterAutoscale;
    /**
    * aws_attributes block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#aws_attributes DataDatabricksJob#aws_attributes}
    */
    readonly awsAttributes?: DataDatabricksJobJobSettingsSettingsNewClusterAwsAttributes;
    /**
    * azure_attributes block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#azure_attributes DataDatabricksJob#azure_attributes}
    */
    readonly azureAttributes?: DataDatabricksJobJobSettingsSettingsNewClusterAzureAttributes;
    /**
    * cluster_log_conf block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#cluster_log_conf DataDatabricksJob#cluster_log_conf}
    */
    readonly clusterLogConf?: DataDatabricksJobJobSettingsSettingsNewClusterClusterLogConf;
    /**
    * cluster_mount_info block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#cluster_mount_info DataDatabricksJob#cluster_mount_info}
    */
    readonly clusterMountInfo?: DataDatabricksJobJobSettingsSettingsNewClusterClusterMountInfo[] | cdktf.IResolvable;
    /**
    * docker_image block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#docker_image DataDatabricksJob#docker_image}
    */
    readonly dockerImage?: DataDatabricksJobJobSettingsSettingsNewClusterDockerImage;
    /**
    * gcp_attributes block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#gcp_attributes DataDatabricksJob#gcp_attributes}
    */
    readonly gcpAttributes?: DataDatabricksJobJobSettingsSettingsNewClusterGcpAttributes;
    /**
    * init_scripts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#init_scripts DataDatabricksJob#init_scripts}
    */
    readonly initScripts?: DataDatabricksJobJobSettingsSettingsNewClusterInitScripts[] | cdktf.IResolvable;
    /**
    * workload_type block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#workload_type DataDatabricksJob#workload_type}
    */
    readonly workloadType?: DataDatabricksJobJobSettingsSettingsNewClusterWorkloadType;
}
export declare function dataDatabricksJobJobSettingsSettingsNewClusterToTerraform(struct?: DataDatabricksJobJobSettingsSettingsNewClusterOutputReference | DataDatabricksJobJobSettingsSettingsNewCluster): any;
export declare class DataDatabricksJobJobSettingsSettingsNewClusterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksJobJobSettingsSettingsNewCluster | undefined;
    set internalValue(value: DataDatabricksJobJobSettingsSettingsNewCluster | undefined);
    private _applyPolicyDefaultValues?;
    get applyPolicyDefaultValues(): boolean | cdktf.IResolvable;
    set applyPolicyDefaultValues(value: boolean | cdktf.IResolvable);
    resetApplyPolicyDefaultValues(): void;
    get applyPolicyDefaultValuesInput(): boolean | cdktf.IResolvable | undefined;
    private _autoterminationMinutes?;
    get autoterminationMinutes(): number;
    set autoterminationMinutes(value: number);
    resetAutoterminationMinutes(): void;
    get autoterminationMinutesInput(): number | undefined;
    private _clusterId?;
    get clusterId(): string;
    set clusterId(value: string);
    resetClusterId(): void;
    get clusterIdInput(): string | undefined;
    private _clusterName?;
    get clusterName(): string;
    set clusterName(value: string);
    resetClusterName(): void;
    get clusterNameInput(): string | undefined;
    private _customTags?;
    get customTags(): {
        [key: string]: string;
    };
    set customTags(value: {
        [key: string]: string;
    });
    resetCustomTags(): void;
    get customTagsInput(): {
        [key: string]: string;
    } | undefined;
    private _dataSecurityMode?;
    get dataSecurityMode(): string;
    set dataSecurityMode(value: string);
    resetDataSecurityMode(): void;
    get dataSecurityModeInput(): string | undefined;
    private _driverInstancePoolId?;
    get driverInstancePoolId(): string;
    set driverInstancePoolId(value: string);
    resetDriverInstancePoolId(): void;
    get driverInstancePoolIdInput(): string | undefined;
    private _driverNodeTypeId?;
    get driverNodeTypeId(): string;
    set driverNodeTypeId(value: string);
    resetDriverNodeTypeId(): void;
    get driverNodeTypeIdInput(): string | undefined;
    private _enableElasticDisk?;
    get enableElasticDisk(): boolean | cdktf.IResolvable;
    set enableElasticDisk(value: boolean | cdktf.IResolvable);
    resetEnableElasticDisk(): void;
    get enableElasticDiskInput(): boolean | cdktf.IResolvable | undefined;
    private _enableLocalDiskEncryption?;
    get enableLocalDiskEncryption(): boolean | cdktf.IResolvable;
    set enableLocalDiskEncryption(value: boolean | cdktf.IResolvable);
    resetEnableLocalDiskEncryption(): void;
    get enableLocalDiskEncryptionInput(): boolean | cdktf.IResolvable | undefined;
    private _idempotencyToken?;
    get idempotencyToken(): string;
    set idempotencyToken(value: string);
    resetIdempotencyToken(): void;
    get idempotencyTokenInput(): string | undefined;
    private _instancePoolId?;
    get instancePoolId(): string;
    set instancePoolId(value: string);
    resetInstancePoolId(): void;
    get instancePoolIdInput(): string | undefined;
    private _nodeTypeId?;
    get nodeTypeId(): string;
    set nodeTypeId(value: string);
    resetNodeTypeId(): void;
    get nodeTypeIdInput(): string | undefined;
    private _numWorkers?;
    get numWorkers(): number;
    set numWorkers(value: number);
    get numWorkersInput(): number | undefined;
    private _policyId?;
    get policyId(): string;
    set policyId(value: string);
    resetPolicyId(): void;
    get policyIdInput(): string | undefined;
    private _runtimeEngine?;
    get runtimeEngine(): string;
    set runtimeEngine(value: string);
    resetRuntimeEngine(): void;
    get runtimeEngineInput(): string | undefined;
    private _singleUserName?;
    get singleUserName(): string;
    set singleUserName(value: string);
    resetSingleUserName(): void;
    get singleUserNameInput(): string | undefined;
    private _sparkConf?;
    get sparkConf(): {
        [key: string]: string;
    };
    set sparkConf(value: {
        [key: string]: string;
    });
    resetSparkConf(): void;
    get sparkConfInput(): {
        [key: string]: string;
    } | undefined;
    private _sparkEnvVars?;
    get sparkEnvVars(): {
        [key: string]: string;
    };
    set sparkEnvVars(value: {
        [key: string]: string;
    });
    resetSparkEnvVars(): void;
    get sparkEnvVarsInput(): {
        [key: string]: string;
    } | undefined;
    private _sparkVersion?;
    get sparkVersion(): string;
    set sparkVersion(value: string);
    get sparkVersionInput(): string | undefined;
    private _sshPublicKeys?;
    get sshPublicKeys(): string[];
    set sshPublicKeys(value: string[]);
    resetSshPublicKeys(): void;
    get sshPublicKeysInput(): string[] | undefined;
    private _autoscale;
    get autoscale(): DataDatabricksJobJobSettingsSettingsNewClusterAutoscaleOutputReference;
    putAutoscale(value: DataDatabricksJobJobSettingsSettingsNewClusterAutoscale): void;
    resetAutoscale(): void;
    get autoscaleInput(): DataDatabricksJobJobSettingsSettingsNewClusterAutoscale | undefined;
    private _awsAttributes;
    get awsAttributes(): DataDatabricksJobJobSettingsSettingsNewClusterAwsAttributesOutputReference;
    putAwsAttributes(value: DataDatabricksJobJobSettingsSettingsNewClusterAwsAttributes): void;
    resetAwsAttributes(): void;
    get awsAttributesInput(): DataDatabricksJobJobSettingsSettingsNewClusterAwsAttributes | undefined;
    private _azureAttributes;
    get azureAttributes(): DataDatabricksJobJobSettingsSettingsNewClusterAzureAttributesOutputReference;
    putAzureAttributes(value: DataDatabricksJobJobSettingsSettingsNewClusterAzureAttributes): void;
    resetAzureAttributes(): void;
    get azureAttributesInput(): DataDatabricksJobJobSettingsSettingsNewClusterAzureAttributes | undefined;
    private _clusterLogConf;
    get clusterLogConf(): DataDatabricksJobJobSettingsSettingsNewClusterClusterLogConfOutputReference;
    putClusterLogConf(value: DataDatabricksJobJobSettingsSettingsNewClusterClusterLogConf): void;
    resetClusterLogConf(): void;
    get clusterLogConfInput(): DataDatabricksJobJobSettingsSettingsNewClusterClusterLogConf | undefined;
    private _clusterMountInfo;
    get clusterMountInfo(): DataDatabricksJobJobSettingsSettingsNewClusterClusterMountInfoList;
    putClusterMountInfo(value: DataDatabricksJobJobSettingsSettingsNewClusterClusterMountInfo[] | cdktf.IResolvable): void;
    resetClusterMountInfo(): void;
    get clusterMountInfoInput(): cdktf.IResolvable | DataDatabricksJobJobSettingsSettingsNewClusterClusterMountInfo[] | undefined;
    private _dockerImage;
    get dockerImage(): DataDatabricksJobJobSettingsSettingsNewClusterDockerImageOutputReference;
    putDockerImage(value: DataDatabricksJobJobSettingsSettingsNewClusterDockerImage): void;
    resetDockerImage(): void;
    get dockerImageInput(): DataDatabricksJobJobSettingsSettingsNewClusterDockerImage | undefined;
    private _gcpAttributes;
    get gcpAttributes(): DataDatabricksJobJobSettingsSettingsNewClusterGcpAttributesOutputReference;
    putGcpAttributes(value: DataDatabricksJobJobSettingsSettingsNewClusterGcpAttributes): void;
    resetGcpAttributes(): void;
    get gcpAttributesInput(): DataDatabricksJobJobSettingsSettingsNewClusterGcpAttributes | undefined;
    private _initScripts;
    get initScripts(): DataDatabricksJobJobSettingsSettingsNewClusterInitScriptsList;
    putInitScripts(value: DataDatabricksJobJobSettingsSettingsNewClusterInitScripts[] | cdktf.IResolvable): void;
    resetInitScripts(): void;
    get initScriptsInput(): cdktf.IResolvable | DataDatabricksJobJobSettingsSettingsNewClusterInitScripts[] | undefined;
    private _workloadType;
    get workloadType(): DataDatabricksJobJobSettingsSettingsNewClusterWorkloadTypeOutputReference;
    putWorkloadType(value: DataDatabricksJobJobSettingsSettingsNewClusterWorkloadType): void;
    resetWorkloadType(): void;
    get workloadTypeInput(): DataDatabricksJobJobSettingsSettingsNewClusterWorkloadType | undefined;
}
export interface DataDatabricksJobJobSettingsSettingsNotebookTask {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#base_parameters DataDatabricksJob#base_parameters}
    */
    readonly baseParameters?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#notebook_path DataDatabricksJob#notebook_path}
    */
    readonly notebookPath: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#source DataDatabricksJob#source}
    */
    readonly source?: string;
}
export declare function dataDatabricksJobJobSettingsSettingsNotebookTaskToTerraform(struct?: DataDatabricksJobJobSettingsSettingsNotebookTaskOutputReference | DataDatabricksJobJobSettingsSettingsNotebookTask): any;
export declare class DataDatabricksJobJobSettingsSettingsNotebookTaskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksJobJobSettingsSettingsNotebookTask | undefined;
    set internalValue(value: DataDatabricksJobJobSettingsSettingsNotebookTask | undefined);
    private _baseParameters?;
    get baseParameters(): {
        [key: string]: string;
    };
    set baseParameters(value: {
        [key: string]: string;
    });
    resetBaseParameters(): void;
    get baseParametersInput(): {
        [key: string]: string;
    } | undefined;
    private _notebookPath?;
    get notebookPath(): string;
    set notebookPath(value: string);
    get notebookPathInput(): string | undefined;
    private _source?;
    get source(): string;
    set source(value: string);
    resetSource(): void;
    get sourceInput(): string | undefined;
}
export interface DataDatabricksJobJobSettingsSettingsPipelineTask {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#pipeline_id DataDatabricksJob#pipeline_id}
    */
    readonly pipelineId: string;
}
export declare function dataDatabricksJobJobSettingsSettingsPipelineTaskToTerraform(struct?: DataDatabricksJobJobSettingsSettingsPipelineTaskOutputReference | DataDatabricksJobJobSettingsSettingsPipelineTask): any;
export declare class DataDatabricksJobJobSettingsSettingsPipelineTaskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksJobJobSettingsSettingsPipelineTask | undefined;
    set internalValue(value: DataDatabricksJobJobSettingsSettingsPipelineTask | undefined);
    private _pipelineId?;
    get pipelineId(): string;
    set pipelineId(value: string);
    get pipelineIdInput(): string | undefined;
}
export interface DataDatabricksJobJobSettingsSettingsPythonWheelTask {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#entry_point DataDatabricksJob#entry_point}
    */
    readonly entryPoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#named_parameters DataDatabricksJob#named_parameters}
    */
    readonly namedParameters?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#package_name DataDatabricksJob#package_name}
    */
    readonly packageName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#parameters DataDatabricksJob#parameters}
    */
    readonly parameters?: string[];
}
export declare function dataDatabricksJobJobSettingsSettingsPythonWheelTaskToTerraform(struct?: DataDatabricksJobJobSettingsSettingsPythonWheelTaskOutputReference | DataDatabricksJobJobSettingsSettingsPythonWheelTask): any;
export declare class DataDatabricksJobJobSettingsSettingsPythonWheelTaskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksJobJobSettingsSettingsPythonWheelTask | undefined;
    set internalValue(value: DataDatabricksJobJobSettingsSettingsPythonWheelTask | undefined);
    private _entryPoint?;
    get entryPoint(): string;
    set entryPoint(value: string);
    resetEntryPoint(): void;
    get entryPointInput(): string | undefined;
    private _namedParameters?;
    get namedParameters(): {
        [key: string]: string;
    };
    set namedParameters(value: {
        [key: string]: string;
    });
    resetNamedParameters(): void;
    get namedParametersInput(): {
        [key: string]: string;
    } | undefined;
    private _packageName?;
    get packageName(): string;
    set packageName(value: string);
    resetPackageName(): void;
    get packageNameInput(): string | undefined;
    private _parameters?;
    get parameters(): string[];
    set parameters(value: string[]);
    resetParameters(): void;
    get parametersInput(): string[] | undefined;
}
export interface DataDatabricksJobJobSettingsSettingsQueue {
}
export declare function dataDatabricksJobJobSettingsSettingsQueueToTerraform(struct?: DataDatabricksJobJobSettingsSettingsQueueOutputReference | DataDatabricksJobJobSettingsSettingsQueue): any;
export declare class DataDatabricksJobJobSettingsSettingsQueueOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksJobJobSettingsSettingsQueue | undefined;
    set internalValue(value: DataDatabricksJobJobSettingsSettingsQueue | undefined);
}
export interface DataDatabricksJobJobSettingsSettingsSchedule {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#pause_status DataDatabricksJob#pause_status}
    */
    readonly pauseStatus?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#quartz_cron_expression DataDatabricksJob#quartz_cron_expression}
    */
    readonly quartzCronExpression: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#timezone_id DataDatabricksJob#timezone_id}
    */
    readonly timezoneId: string;
}
export declare function dataDatabricksJobJobSettingsSettingsScheduleToTerraform(struct?: DataDatabricksJobJobSettingsSettingsScheduleOutputReference | DataDatabricksJobJobSettingsSettingsSchedule): any;
export declare class DataDatabricksJobJobSettingsSettingsScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksJobJobSettingsSettingsSchedule | undefined;
    set internalValue(value: DataDatabricksJobJobSettingsSettingsSchedule | undefined);
    private _pauseStatus?;
    get pauseStatus(): string;
    set pauseStatus(value: string);
    resetPauseStatus(): void;
    get pauseStatusInput(): string | undefined;
    private _quartzCronExpression?;
    get quartzCronExpression(): string;
    set quartzCronExpression(value: string);
    get quartzCronExpressionInput(): string | undefined;
    private _timezoneId?;
    get timezoneId(): string;
    set timezoneId(value: string);
    get timezoneIdInput(): string | undefined;
}
export interface DataDatabricksJobJobSettingsSettingsSparkJarTask {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#jar_uri DataDatabricksJob#jar_uri}
    */
    readonly jarUri?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#main_class_name DataDatabricksJob#main_class_name}
    */
    readonly mainClassName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#parameters DataDatabricksJob#parameters}
    */
    readonly parameters?: string[];
}
export declare function dataDatabricksJobJobSettingsSettingsSparkJarTaskToTerraform(struct?: DataDatabricksJobJobSettingsSettingsSparkJarTaskOutputReference | DataDatabricksJobJobSettingsSettingsSparkJarTask): any;
export declare class DataDatabricksJobJobSettingsSettingsSparkJarTaskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksJobJobSettingsSettingsSparkJarTask | undefined;
    set internalValue(value: DataDatabricksJobJobSettingsSettingsSparkJarTask | undefined);
    private _jarUri?;
    get jarUri(): string;
    set jarUri(value: string);
    resetJarUri(): void;
    get jarUriInput(): string | undefined;
    private _mainClassName?;
    get mainClassName(): string;
    set mainClassName(value: string);
    resetMainClassName(): void;
    get mainClassNameInput(): string | undefined;
    private _parameters?;
    get parameters(): string[];
    set parameters(value: string[]);
    resetParameters(): void;
    get parametersInput(): string[] | undefined;
}
export interface DataDatabricksJobJobSettingsSettingsSparkPythonTask {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#parameters DataDatabricksJob#parameters}
    */
    readonly parameters?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#python_file DataDatabricksJob#python_file}
    */
    readonly pythonFile: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#source DataDatabricksJob#source}
    */
    readonly source?: string;
}
export declare function dataDatabricksJobJobSettingsSettingsSparkPythonTaskToTerraform(struct?: DataDatabricksJobJobSettingsSettingsSparkPythonTaskOutputReference | DataDatabricksJobJobSettingsSettingsSparkPythonTask): any;
export declare class DataDatabricksJobJobSettingsSettingsSparkPythonTaskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksJobJobSettingsSettingsSparkPythonTask | undefined;
    set internalValue(value: DataDatabricksJobJobSettingsSettingsSparkPythonTask | undefined);
    private _parameters?;
    get parameters(): string[];
    set parameters(value: string[]);
    resetParameters(): void;
    get parametersInput(): string[] | undefined;
    private _pythonFile?;
    get pythonFile(): string;
    set pythonFile(value: string);
    get pythonFileInput(): string | undefined;
    private _source?;
    get source(): string;
    set source(value: string);
    resetSource(): void;
    get sourceInput(): string | undefined;
}
export interface DataDatabricksJobJobSettingsSettingsSparkSubmitTask {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#parameters DataDatabricksJob#parameters}
    */
    readonly parameters?: string[];
}
export declare function dataDatabricksJobJobSettingsSettingsSparkSubmitTaskToTerraform(struct?: DataDatabricksJobJobSettingsSettingsSparkSubmitTaskOutputReference | DataDatabricksJobJobSettingsSettingsSparkSubmitTask): any;
export declare class DataDatabricksJobJobSettingsSettingsSparkSubmitTaskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksJobJobSettingsSettingsSparkSubmitTask | undefined;
    set internalValue(value: DataDatabricksJobJobSettingsSettingsSparkSubmitTask | undefined);
    private _parameters?;
    get parameters(): string[];
    set parameters(value: string[]);
    resetParameters(): void;
    get parametersInput(): string[] | undefined;
}
export interface DataDatabricksJobJobSettingsSettingsTaskDbtTask {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#catalog DataDatabricksJob#catalog}
    */
    readonly catalog?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#commands DataDatabricksJob#commands}
    */
    readonly commands: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#profiles_directory DataDatabricksJob#profiles_directory}
    */
    readonly profilesDirectory?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#project_directory DataDatabricksJob#project_directory}
    */
    readonly projectDirectory?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#schema DataDatabricksJob#schema}
    */
    readonly schema?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#warehouse_id DataDatabricksJob#warehouse_id}
    */
    readonly warehouseId?: string;
}
export declare function dataDatabricksJobJobSettingsSettingsTaskDbtTaskToTerraform(struct?: DataDatabricksJobJobSettingsSettingsTaskDbtTaskOutputReference | DataDatabricksJobJobSettingsSettingsTaskDbtTask): any;
export declare class DataDatabricksJobJobSettingsSettingsTaskDbtTaskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksJobJobSettingsSettingsTaskDbtTask | undefined;
    set internalValue(value: DataDatabricksJobJobSettingsSettingsTaskDbtTask | undefined);
    private _catalog?;
    get catalog(): string;
    set catalog(value: string);
    resetCatalog(): void;
    get catalogInput(): string | undefined;
    private _commands?;
    get commands(): string[];
    set commands(value: string[]);
    get commandsInput(): string[] | undefined;
    private _profilesDirectory?;
    get profilesDirectory(): string;
    set profilesDirectory(value: string);
    resetProfilesDirectory(): void;
    get profilesDirectoryInput(): string | undefined;
    private _projectDirectory?;
    get projectDirectory(): string;
    set projectDirectory(value: string);
    resetProjectDirectory(): void;
    get projectDirectoryInput(): string | undefined;
    private _schema?;
    get schema(): string;
    set schema(value: string);
    resetSchema(): void;
    get schemaInput(): string | undefined;
    private _warehouseId?;
    get warehouseId(): string;
    set warehouseId(value: string);
    resetWarehouseId(): void;
    get warehouseIdInput(): string | undefined;
}
export interface DataDatabricksJobJobSettingsSettingsTaskDependsOn {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#task_key DataDatabricksJob#task_key}
    */
    readonly taskKey?: string;
}
export declare function dataDatabricksJobJobSettingsSettingsTaskDependsOnToTerraform(struct?: DataDatabricksJobJobSettingsSettingsTaskDependsOn | cdktf.IResolvable): any;
export declare class DataDatabricksJobJobSettingsSettingsTaskDependsOnOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDatabricksJobJobSettingsSettingsTaskDependsOn | cdktf.IResolvable | undefined;
    set internalValue(value: DataDatabricksJobJobSettingsSettingsTaskDependsOn | cdktf.IResolvable | undefined);
    private _taskKey?;
    get taskKey(): string;
    set taskKey(value: string);
    resetTaskKey(): void;
    get taskKeyInput(): string | undefined;
}
export declare class DataDatabricksJobJobSettingsSettingsTaskDependsOnList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DataDatabricksJobJobSettingsSettingsTaskDependsOn[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDatabricksJobJobSettingsSettingsTaskDependsOnOutputReference;
}
export interface DataDatabricksJobJobSettingsSettingsTaskEmailNotifications {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#alert_on_last_attempt DataDatabricksJob#alert_on_last_attempt}
    */
    readonly alertOnLastAttempt?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#no_alert_for_skipped_runs DataDatabricksJob#no_alert_for_skipped_runs}
    */
    readonly noAlertForSkippedRuns?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#on_failure DataDatabricksJob#on_failure}
    */
    readonly onFailure?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#on_start DataDatabricksJob#on_start}
    */
    readonly onStart?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#on_success DataDatabricksJob#on_success}
    */
    readonly onSuccess?: string[];
}
export declare function dataDatabricksJobJobSettingsSettingsTaskEmailNotificationsToTerraform(struct?: DataDatabricksJobJobSettingsSettingsTaskEmailNotificationsOutputReference | DataDatabricksJobJobSettingsSettingsTaskEmailNotifications): any;
export declare class DataDatabricksJobJobSettingsSettingsTaskEmailNotificationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksJobJobSettingsSettingsTaskEmailNotifications | undefined;
    set internalValue(value: DataDatabricksJobJobSettingsSettingsTaskEmailNotifications | undefined);
    private _alertOnLastAttempt?;
    get alertOnLastAttempt(): boolean | cdktf.IResolvable;
    set alertOnLastAttempt(value: boolean | cdktf.IResolvable);
    resetAlertOnLastAttempt(): void;
    get alertOnLastAttemptInput(): boolean | cdktf.IResolvable | undefined;
    private _noAlertForSkippedRuns?;
    get noAlertForSkippedRuns(): boolean | cdktf.IResolvable;
    set noAlertForSkippedRuns(value: boolean | cdktf.IResolvable);
    resetNoAlertForSkippedRuns(): void;
    get noAlertForSkippedRunsInput(): boolean | cdktf.IResolvable | undefined;
    private _onFailure?;
    get onFailure(): string[];
    set onFailure(value: string[]);
    resetOnFailure(): void;
    get onFailureInput(): string[] | undefined;
    private _onStart?;
    get onStart(): string[];
    set onStart(value: string[]);
    resetOnStart(): void;
    get onStartInput(): string[] | undefined;
    private _onSuccess?;
    get onSuccess(): string[];
    set onSuccess(value: string[]);
    resetOnSuccess(): void;
    get onSuccessInput(): string[] | undefined;
}
export interface DataDatabricksJobJobSettingsSettingsTaskLibraryCran {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#package DataDatabricksJob#package}
    */
    readonly package: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#repo DataDatabricksJob#repo}
    */
    readonly repo?: string;
}
export declare function dataDatabricksJobJobSettingsSettingsTaskLibraryCranToTerraform(struct?: DataDatabricksJobJobSettingsSettingsTaskLibraryCranOutputReference | DataDatabricksJobJobSettingsSettingsTaskLibraryCran): any;
export declare class DataDatabricksJobJobSettingsSettingsTaskLibraryCranOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksJobJobSettingsSettingsTaskLibraryCran | undefined;
    set internalValue(value: DataDatabricksJobJobSettingsSettingsTaskLibraryCran | undefined);
    private _package?;
    get package(): string;
    set package(value: string);
    get packageInput(): string | undefined;
    private _repo?;
    get repo(): string;
    set repo(value: string);
    resetRepo(): void;
    get repoInput(): string | undefined;
}
export interface DataDatabricksJobJobSettingsSettingsTaskLibraryMaven {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#coordinates DataDatabricksJob#coordinates}
    */
    readonly coordinates: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#exclusions DataDatabricksJob#exclusions}
    */
    readonly exclusions?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#repo DataDatabricksJob#repo}
    */
    readonly repo?: string;
}
export declare function dataDatabricksJobJobSettingsSettingsTaskLibraryMavenToTerraform(struct?: DataDatabricksJobJobSettingsSettingsTaskLibraryMavenOutputReference | DataDatabricksJobJobSettingsSettingsTaskLibraryMaven): any;
export declare class DataDatabricksJobJobSettingsSettingsTaskLibraryMavenOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksJobJobSettingsSettingsTaskLibraryMaven | undefined;
    set internalValue(value: DataDatabricksJobJobSettingsSettingsTaskLibraryMaven | undefined);
    private _coordinates?;
    get coordinates(): string;
    set coordinates(value: string);
    get coordinatesInput(): string | undefined;
    private _exclusions?;
    get exclusions(): string[];
    set exclusions(value: string[]);
    resetExclusions(): void;
    get exclusionsInput(): string[] | undefined;
    private _repo?;
    get repo(): string;
    set repo(value: string);
    resetRepo(): void;
    get repoInput(): string | undefined;
}
export interface DataDatabricksJobJobSettingsSettingsTaskLibraryPypi {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#package DataDatabricksJob#package}
    */
    readonly package: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#repo DataDatabricksJob#repo}
    */
    readonly repo?: string;
}
export declare function dataDatabricksJobJobSettingsSettingsTaskLibraryPypiToTerraform(struct?: DataDatabricksJobJobSettingsSettingsTaskLibraryPypiOutputReference | DataDatabricksJobJobSettingsSettingsTaskLibraryPypi): any;
export declare class DataDatabricksJobJobSettingsSettingsTaskLibraryPypiOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksJobJobSettingsSettingsTaskLibraryPypi | undefined;
    set internalValue(value: DataDatabricksJobJobSettingsSettingsTaskLibraryPypi | undefined);
    private _package?;
    get package(): string;
    set package(value: string);
    get packageInput(): string | undefined;
    private _repo?;
    get repo(): string;
    set repo(value: string);
    resetRepo(): void;
    get repoInput(): string | undefined;
}
export interface DataDatabricksJobJobSettingsSettingsTaskLibrary {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#egg DataDatabricksJob#egg}
    */
    readonly egg?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#jar DataDatabricksJob#jar}
    */
    readonly jar?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#whl DataDatabricksJob#whl}
    */
    readonly whl?: string;
    /**
    * cran block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#cran DataDatabricksJob#cran}
    */
    readonly cran?: DataDatabricksJobJobSettingsSettingsTaskLibraryCran;
    /**
    * maven block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#maven DataDatabricksJob#maven}
    */
    readonly maven?: DataDatabricksJobJobSettingsSettingsTaskLibraryMaven;
    /**
    * pypi block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#pypi DataDatabricksJob#pypi}
    */
    readonly pypi?: DataDatabricksJobJobSettingsSettingsTaskLibraryPypi;
}
export declare function dataDatabricksJobJobSettingsSettingsTaskLibraryToTerraform(struct?: DataDatabricksJobJobSettingsSettingsTaskLibrary | cdktf.IResolvable): any;
export declare class DataDatabricksJobJobSettingsSettingsTaskLibraryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDatabricksJobJobSettingsSettingsTaskLibrary | cdktf.IResolvable | undefined;
    set internalValue(value: DataDatabricksJobJobSettingsSettingsTaskLibrary | cdktf.IResolvable | undefined);
    private _egg?;
    get egg(): string;
    set egg(value: string);
    resetEgg(): void;
    get eggInput(): string | undefined;
    private _jar?;
    get jar(): string;
    set jar(value: string);
    resetJar(): void;
    get jarInput(): string | undefined;
    private _whl?;
    get whl(): string;
    set whl(value: string);
    resetWhl(): void;
    get whlInput(): string | undefined;
    private _cran;
    get cran(): DataDatabricksJobJobSettingsSettingsTaskLibraryCranOutputReference;
    putCran(value: DataDatabricksJobJobSettingsSettingsTaskLibraryCran): void;
    resetCran(): void;
    get cranInput(): DataDatabricksJobJobSettingsSettingsTaskLibraryCran | undefined;
    private _maven;
    get maven(): DataDatabricksJobJobSettingsSettingsTaskLibraryMavenOutputReference;
    putMaven(value: DataDatabricksJobJobSettingsSettingsTaskLibraryMaven): void;
    resetMaven(): void;
    get mavenInput(): DataDatabricksJobJobSettingsSettingsTaskLibraryMaven | undefined;
    private _pypi;
    get pypi(): DataDatabricksJobJobSettingsSettingsTaskLibraryPypiOutputReference;
    putPypi(value: DataDatabricksJobJobSettingsSettingsTaskLibraryPypi): void;
    resetPypi(): void;
    get pypiInput(): DataDatabricksJobJobSettingsSettingsTaskLibraryPypi | undefined;
}
export declare class DataDatabricksJobJobSettingsSettingsTaskLibraryList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DataDatabricksJobJobSettingsSettingsTaskLibrary[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDatabricksJobJobSettingsSettingsTaskLibraryOutputReference;
}
export interface DataDatabricksJobJobSettingsSettingsTaskNewClusterAutoscale {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#max_workers DataDatabricksJob#max_workers}
    */
    readonly maxWorkers?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#min_workers DataDatabricksJob#min_workers}
    */
    readonly minWorkers?: number;
}
export declare function dataDatabricksJobJobSettingsSettingsTaskNewClusterAutoscaleToTerraform(struct?: DataDatabricksJobJobSettingsSettingsTaskNewClusterAutoscaleOutputReference | DataDatabricksJobJobSettingsSettingsTaskNewClusterAutoscale): any;
export declare class DataDatabricksJobJobSettingsSettingsTaskNewClusterAutoscaleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksJobJobSettingsSettingsTaskNewClusterAutoscale | undefined;
    set internalValue(value: DataDatabricksJobJobSettingsSettingsTaskNewClusterAutoscale | undefined);
    private _maxWorkers?;
    get maxWorkers(): number;
    set maxWorkers(value: number);
    resetMaxWorkers(): void;
    get maxWorkersInput(): number | undefined;
    private _minWorkers?;
    get minWorkers(): number;
    set minWorkers(value: number);
    resetMinWorkers(): void;
    get minWorkersInput(): number | undefined;
}
export interface DataDatabricksJobJobSettingsSettingsTaskNewClusterAwsAttributes {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#availability DataDatabricksJob#availability}
    */
    readonly availability?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#ebs_volume_count DataDatabricksJob#ebs_volume_count}
    */
    readonly ebsVolumeCount?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#ebs_volume_size DataDatabricksJob#ebs_volume_size}
    */
    readonly ebsVolumeSize?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#ebs_volume_type DataDatabricksJob#ebs_volume_type}
    */
    readonly ebsVolumeType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#first_on_demand DataDatabricksJob#first_on_demand}
    */
    readonly firstOnDemand?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#instance_profile_arn DataDatabricksJob#instance_profile_arn}
    */
    readonly instanceProfileArn?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#spot_bid_price_percent DataDatabricksJob#spot_bid_price_percent}
    */
    readonly spotBidPricePercent?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#zone_id DataDatabricksJob#zone_id}
    */
    readonly zoneId?: string;
}
export declare function dataDatabricksJobJobSettingsSettingsTaskNewClusterAwsAttributesToTerraform(struct?: DataDatabricksJobJobSettingsSettingsTaskNewClusterAwsAttributesOutputReference | DataDatabricksJobJobSettingsSettingsTaskNewClusterAwsAttributes): any;
export declare class DataDatabricksJobJobSettingsSettingsTaskNewClusterAwsAttributesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksJobJobSettingsSettingsTaskNewClusterAwsAttributes | undefined;
    set internalValue(value: DataDatabricksJobJobSettingsSettingsTaskNewClusterAwsAttributes | undefined);
    private _availability?;
    get availability(): string;
    set availability(value: string);
    resetAvailability(): void;
    get availabilityInput(): string | undefined;
    private _ebsVolumeCount?;
    get ebsVolumeCount(): number;
    set ebsVolumeCount(value: number);
    resetEbsVolumeCount(): void;
    get ebsVolumeCountInput(): number | undefined;
    private _ebsVolumeSize?;
    get ebsVolumeSize(): number;
    set ebsVolumeSize(value: number);
    resetEbsVolumeSize(): void;
    get ebsVolumeSizeInput(): number | undefined;
    private _ebsVolumeType?;
    get ebsVolumeType(): string;
    set ebsVolumeType(value: string);
    resetEbsVolumeType(): void;
    get ebsVolumeTypeInput(): string | undefined;
    private _firstOnDemand?;
    get firstOnDemand(): number;
    set firstOnDemand(value: number);
    resetFirstOnDemand(): void;
    get firstOnDemandInput(): number | undefined;
    private _instanceProfileArn?;
    get instanceProfileArn(): string;
    set instanceProfileArn(value: string);
    resetInstanceProfileArn(): void;
    get instanceProfileArnInput(): string | undefined;
    private _spotBidPricePercent?;
    get spotBidPricePercent(): number;
    set spotBidPricePercent(value: number);
    resetSpotBidPricePercent(): void;
    get spotBidPricePercentInput(): number | undefined;
    private _zoneId?;
    get zoneId(): string;
    set zoneId(value: string);
    resetZoneId(): void;
    get zoneIdInput(): string | undefined;
}
export interface DataDatabricksJobJobSettingsSettingsTaskNewClusterAzureAttributes {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#availability DataDatabricksJob#availability}
    */
    readonly availability?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#first_on_demand DataDatabricksJob#first_on_demand}
    */
    readonly firstOnDemand?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#spot_bid_max_price DataDatabricksJob#spot_bid_max_price}
    */
    readonly spotBidMaxPrice?: number;
}
export declare function dataDatabricksJobJobSettingsSettingsTaskNewClusterAzureAttributesToTerraform(struct?: DataDatabricksJobJobSettingsSettingsTaskNewClusterAzureAttributesOutputReference | DataDatabricksJobJobSettingsSettingsTaskNewClusterAzureAttributes): any;
export declare class DataDatabricksJobJobSettingsSettingsTaskNewClusterAzureAttributesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksJobJobSettingsSettingsTaskNewClusterAzureAttributes | undefined;
    set internalValue(value: DataDatabricksJobJobSettingsSettingsTaskNewClusterAzureAttributes | undefined);
    private _availability?;
    get availability(): string;
    set availability(value: string);
    resetAvailability(): void;
    get availabilityInput(): string | undefined;
    private _firstOnDemand?;
    get firstOnDemand(): number;
    set firstOnDemand(value: number);
    resetFirstOnDemand(): void;
    get firstOnDemandInput(): number | undefined;
    private _spotBidMaxPrice?;
    get spotBidMaxPrice(): number;
    set spotBidMaxPrice(value: number);
    resetSpotBidMaxPrice(): void;
    get spotBidMaxPriceInput(): number | undefined;
}
export interface DataDatabricksJobJobSettingsSettingsTaskNewClusterClusterLogConfDbfs {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#destination DataDatabricksJob#destination}
    */
    readonly destination: string;
}
export declare function dataDatabricksJobJobSettingsSettingsTaskNewClusterClusterLogConfDbfsToTerraform(struct?: DataDatabricksJobJobSettingsSettingsTaskNewClusterClusterLogConfDbfsOutputReference | DataDatabricksJobJobSettingsSettingsTaskNewClusterClusterLogConfDbfs): any;
export declare class DataDatabricksJobJobSettingsSettingsTaskNewClusterClusterLogConfDbfsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksJobJobSettingsSettingsTaskNewClusterClusterLogConfDbfs | undefined;
    set internalValue(value: DataDatabricksJobJobSettingsSettingsTaskNewClusterClusterLogConfDbfs | undefined);
    private _destination?;
    get destination(): string;
    set destination(value: string);
    get destinationInput(): string | undefined;
}
export interface DataDatabricksJobJobSettingsSettingsTaskNewClusterClusterLogConfS3 {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#canned_acl DataDatabricksJob#canned_acl}
    */
    readonly cannedAcl?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#destination DataDatabricksJob#destination}
    */
    readonly destination: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#enable_encryption DataDatabricksJob#enable_encryption}
    */
    readonly enableEncryption?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#encryption_type DataDatabricksJob#encryption_type}
    */
    readonly encryptionType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#endpoint DataDatabricksJob#endpoint}
    */
    readonly endpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#kms_key DataDatabricksJob#kms_key}
    */
    readonly kmsKey?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#region DataDatabricksJob#region}
    */
    readonly region?: string;
}
export declare function dataDatabricksJobJobSettingsSettingsTaskNewClusterClusterLogConfS3ToTerraform(struct?: DataDatabricksJobJobSettingsSettingsTaskNewClusterClusterLogConfS3OutputReference | DataDatabricksJobJobSettingsSettingsTaskNewClusterClusterLogConfS3): any;
export declare class DataDatabricksJobJobSettingsSettingsTaskNewClusterClusterLogConfS3OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksJobJobSettingsSettingsTaskNewClusterClusterLogConfS3 | undefined;
    set internalValue(value: DataDatabricksJobJobSettingsSettingsTaskNewClusterClusterLogConfS3 | undefined);
    private _cannedAcl?;
    get cannedAcl(): string;
    set cannedAcl(value: string);
    resetCannedAcl(): void;
    get cannedAclInput(): string | undefined;
    private _destination?;
    get destination(): string;
    set destination(value: string);
    get destinationInput(): string | undefined;
    private _enableEncryption?;
    get enableEncryption(): boolean | cdktf.IResolvable;
    set enableEncryption(value: boolean | cdktf.IResolvable);
    resetEnableEncryption(): void;
    get enableEncryptionInput(): boolean | cdktf.IResolvable | undefined;
    private _encryptionType?;
    get encryptionType(): string;
    set encryptionType(value: string);
    resetEncryptionType(): void;
    get encryptionTypeInput(): string | undefined;
    private _endpoint?;
    get endpoint(): string;
    set endpoint(value: string);
    resetEndpoint(): void;
    get endpointInput(): string | undefined;
    private _kmsKey?;
    get kmsKey(): string;
    set kmsKey(value: string);
    resetKmsKey(): void;
    get kmsKeyInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
}
export interface DataDatabricksJobJobSettingsSettingsTaskNewClusterClusterLogConf {
    /**
    * dbfs block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#dbfs DataDatabricksJob#dbfs}
    */
    readonly dbfs?: DataDatabricksJobJobSettingsSettingsTaskNewClusterClusterLogConfDbfs;
    /**
    * s3 block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#s3 DataDatabricksJob#s3}
    */
    readonly s3?: DataDatabricksJobJobSettingsSettingsTaskNewClusterClusterLogConfS3;
}
export declare function dataDatabricksJobJobSettingsSettingsTaskNewClusterClusterLogConfToTerraform(struct?: DataDatabricksJobJobSettingsSettingsTaskNewClusterClusterLogConfOutputReference | DataDatabricksJobJobSettingsSettingsTaskNewClusterClusterLogConf): any;
export declare class DataDatabricksJobJobSettingsSettingsTaskNewClusterClusterLogConfOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksJobJobSettingsSettingsTaskNewClusterClusterLogConf | undefined;
    set internalValue(value: DataDatabricksJobJobSettingsSettingsTaskNewClusterClusterLogConf | undefined);
    private _dbfs;
    get dbfs(): DataDatabricksJobJobSettingsSettingsTaskNewClusterClusterLogConfDbfsOutputReference;
    putDbfs(value: DataDatabricksJobJobSettingsSettingsTaskNewClusterClusterLogConfDbfs): void;
    resetDbfs(): void;
    get dbfsInput(): DataDatabricksJobJobSettingsSettingsTaskNewClusterClusterLogConfDbfs | undefined;
    private _s3;
    get s3(): DataDatabricksJobJobSettingsSettingsTaskNewClusterClusterLogConfS3OutputReference;
    putS3(value: DataDatabricksJobJobSettingsSettingsTaskNewClusterClusterLogConfS3): void;
    resetS3(): void;
    get s3Input(): DataDatabricksJobJobSettingsSettingsTaskNewClusterClusterLogConfS3 | undefined;
}
export interface DataDatabricksJobJobSettingsSettingsTaskNewClusterClusterMountInfoNetworkFilesystemInfo {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#mount_options DataDatabricksJob#mount_options}
    */
    readonly mountOptions?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#server_address DataDatabricksJob#server_address}
    */
    readonly serverAddress: string;
}
export declare function dataDatabricksJobJobSettingsSettingsTaskNewClusterClusterMountInfoNetworkFilesystemInfoToTerraform(struct?: DataDatabricksJobJobSettingsSettingsTaskNewClusterClusterMountInfoNetworkFilesystemInfoOutputReference | DataDatabricksJobJobSettingsSettingsTaskNewClusterClusterMountInfoNetworkFilesystemInfo): any;
export declare class DataDatabricksJobJobSettingsSettingsTaskNewClusterClusterMountInfoNetworkFilesystemInfoOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksJobJobSettingsSettingsTaskNewClusterClusterMountInfoNetworkFilesystemInfo | undefined;
    set internalValue(value: DataDatabricksJobJobSettingsSettingsTaskNewClusterClusterMountInfoNetworkFilesystemInfo | undefined);
    private _mountOptions?;
    get mountOptions(): string;
    set mountOptions(value: string);
    resetMountOptions(): void;
    get mountOptionsInput(): string | undefined;
    private _serverAddress?;
    get serverAddress(): string;
    set serverAddress(value: string);
    get serverAddressInput(): string | undefined;
}
export interface DataDatabricksJobJobSettingsSettingsTaskNewClusterClusterMountInfo {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#local_mount_dir_path DataDatabricksJob#local_mount_dir_path}
    */
    readonly localMountDirPath: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#remote_mount_dir_path DataDatabricksJob#remote_mount_dir_path}
    */
    readonly remoteMountDirPath?: string;
    /**
    * network_filesystem_info block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#network_filesystem_info DataDatabricksJob#network_filesystem_info}
    */
    readonly networkFilesystemInfo: DataDatabricksJobJobSettingsSettingsTaskNewClusterClusterMountInfoNetworkFilesystemInfo;
}
export declare function dataDatabricksJobJobSettingsSettingsTaskNewClusterClusterMountInfoToTerraform(struct?: DataDatabricksJobJobSettingsSettingsTaskNewClusterClusterMountInfo | cdktf.IResolvable): any;
export declare class DataDatabricksJobJobSettingsSettingsTaskNewClusterClusterMountInfoOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDatabricksJobJobSettingsSettingsTaskNewClusterClusterMountInfo | cdktf.IResolvable | undefined;
    set internalValue(value: DataDatabricksJobJobSettingsSettingsTaskNewClusterClusterMountInfo | cdktf.IResolvable | undefined);
    private _localMountDirPath?;
    get localMountDirPath(): string;
    set localMountDirPath(value: string);
    get localMountDirPathInput(): string | undefined;
    private _remoteMountDirPath?;
    get remoteMountDirPath(): string;
    set remoteMountDirPath(value: string);
    resetRemoteMountDirPath(): void;
    get remoteMountDirPathInput(): string | undefined;
    private _networkFilesystemInfo;
    get networkFilesystemInfo(): DataDatabricksJobJobSettingsSettingsTaskNewClusterClusterMountInfoNetworkFilesystemInfoOutputReference;
    putNetworkFilesystemInfo(value: DataDatabricksJobJobSettingsSettingsTaskNewClusterClusterMountInfoNetworkFilesystemInfo): void;
    get networkFilesystemInfoInput(): DataDatabricksJobJobSettingsSettingsTaskNewClusterClusterMountInfoNetworkFilesystemInfo | undefined;
}
export declare class DataDatabricksJobJobSettingsSettingsTaskNewClusterClusterMountInfoList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DataDatabricksJobJobSettingsSettingsTaskNewClusterClusterMountInfo[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDatabricksJobJobSettingsSettingsTaskNewClusterClusterMountInfoOutputReference;
}
export interface DataDatabricksJobJobSettingsSettingsTaskNewClusterDockerImageBasicAuth {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#password DataDatabricksJob#password}
    */
    readonly password: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#username DataDatabricksJob#username}
    */
    readonly username: string;
}
export declare function dataDatabricksJobJobSettingsSettingsTaskNewClusterDockerImageBasicAuthToTerraform(struct?: DataDatabricksJobJobSettingsSettingsTaskNewClusterDockerImageBasicAuthOutputReference | DataDatabricksJobJobSettingsSettingsTaskNewClusterDockerImageBasicAuth): any;
export declare class DataDatabricksJobJobSettingsSettingsTaskNewClusterDockerImageBasicAuthOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksJobJobSettingsSettingsTaskNewClusterDockerImageBasicAuth | undefined;
    set internalValue(value: DataDatabricksJobJobSettingsSettingsTaskNewClusterDockerImageBasicAuth | undefined);
    private _password?;
    get password(): string;
    set password(value: string);
    get passwordInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
}
export interface DataDatabricksJobJobSettingsSettingsTaskNewClusterDockerImage {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#url DataDatabricksJob#url}
    */
    readonly url: string;
    /**
    * basic_auth block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#basic_auth DataDatabricksJob#basic_auth}
    */
    readonly basicAuth?: DataDatabricksJobJobSettingsSettingsTaskNewClusterDockerImageBasicAuth;
}
export declare function dataDatabricksJobJobSettingsSettingsTaskNewClusterDockerImageToTerraform(struct?: DataDatabricksJobJobSettingsSettingsTaskNewClusterDockerImageOutputReference | DataDatabricksJobJobSettingsSettingsTaskNewClusterDockerImage): any;
export declare class DataDatabricksJobJobSettingsSettingsTaskNewClusterDockerImageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksJobJobSettingsSettingsTaskNewClusterDockerImage | undefined;
    set internalValue(value: DataDatabricksJobJobSettingsSettingsTaskNewClusterDockerImage | undefined);
    private _url?;
    get url(): string;
    set url(value: string);
    get urlInput(): string | undefined;
    private _basicAuth;
    get basicAuth(): DataDatabricksJobJobSettingsSettingsTaskNewClusterDockerImageBasicAuthOutputReference;
    putBasicAuth(value: DataDatabricksJobJobSettingsSettingsTaskNewClusterDockerImageBasicAuth): void;
    resetBasicAuth(): void;
    get basicAuthInput(): DataDatabricksJobJobSettingsSettingsTaskNewClusterDockerImageBasicAuth | undefined;
}
export interface DataDatabricksJobJobSettingsSettingsTaskNewClusterGcpAttributes {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#availability DataDatabricksJob#availability}
    */
    readonly availability?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#boot_disk_size DataDatabricksJob#boot_disk_size}
    */
    readonly bootDiskSize?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#google_service_account DataDatabricksJob#google_service_account}
    */
    readonly googleServiceAccount?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#use_preemptible_executors DataDatabricksJob#use_preemptible_executors}
    */
    readonly usePreemptibleExecutors?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#zone_id DataDatabricksJob#zone_id}
    */
    readonly zoneId?: string;
}
export declare function dataDatabricksJobJobSettingsSettingsTaskNewClusterGcpAttributesToTerraform(struct?: DataDatabricksJobJobSettingsSettingsTaskNewClusterGcpAttributesOutputReference | DataDatabricksJobJobSettingsSettingsTaskNewClusterGcpAttributes): any;
export declare class DataDatabricksJobJobSettingsSettingsTaskNewClusterGcpAttributesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksJobJobSettingsSettingsTaskNewClusterGcpAttributes | undefined;
    set internalValue(value: DataDatabricksJobJobSettingsSettingsTaskNewClusterGcpAttributes | undefined);
    private _availability?;
    get availability(): string;
    set availability(value: string);
    resetAvailability(): void;
    get availabilityInput(): string | undefined;
    private _bootDiskSize?;
    get bootDiskSize(): number;
    set bootDiskSize(value: number);
    resetBootDiskSize(): void;
    get bootDiskSizeInput(): number | undefined;
    private _googleServiceAccount?;
    get googleServiceAccount(): string;
    set googleServiceAccount(value: string);
    resetGoogleServiceAccount(): void;
    get googleServiceAccountInput(): string | undefined;
    private _usePreemptibleExecutors?;
    get usePreemptibleExecutors(): boolean | cdktf.IResolvable;
    set usePreemptibleExecutors(value: boolean | cdktf.IResolvable);
    resetUsePreemptibleExecutors(): void;
    get usePreemptibleExecutorsInput(): boolean | cdktf.IResolvable | undefined;
    private _zoneId?;
    get zoneId(): string;
    set zoneId(value: string);
    resetZoneId(): void;
    get zoneIdInput(): string | undefined;
}
export interface DataDatabricksJobJobSettingsSettingsTaskNewClusterInitScriptsAbfss {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#destination DataDatabricksJob#destination}
    */
    readonly destination?: string;
}
export declare function dataDatabricksJobJobSettingsSettingsTaskNewClusterInitScriptsAbfssToTerraform(struct?: DataDatabricksJobJobSettingsSettingsTaskNewClusterInitScriptsAbfssOutputReference | DataDatabricksJobJobSettingsSettingsTaskNewClusterInitScriptsAbfss): any;
export declare class DataDatabricksJobJobSettingsSettingsTaskNewClusterInitScriptsAbfssOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksJobJobSettingsSettingsTaskNewClusterInitScriptsAbfss | undefined;
    set internalValue(value: DataDatabricksJobJobSettingsSettingsTaskNewClusterInitScriptsAbfss | undefined);
    private _destination?;
    get destination(): string;
    set destination(value: string);
    resetDestination(): void;
    get destinationInput(): string | undefined;
}
export interface DataDatabricksJobJobSettingsSettingsTaskNewClusterInitScriptsDbfs {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#destination DataDatabricksJob#destination}
    */
    readonly destination: string;
}
export declare function dataDatabricksJobJobSettingsSettingsTaskNewClusterInitScriptsDbfsToTerraform(struct?: DataDatabricksJobJobSettingsSettingsTaskNewClusterInitScriptsDbfsOutputReference | DataDatabricksJobJobSettingsSettingsTaskNewClusterInitScriptsDbfs): any;
export declare class DataDatabricksJobJobSettingsSettingsTaskNewClusterInitScriptsDbfsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksJobJobSettingsSettingsTaskNewClusterInitScriptsDbfs | undefined;
    set internalValue(value: DataDatabricksJobJobSettingsSettingsTaskNewClusterInitScriptsDbfs | undefined);
    private _destination?;
    get destination(): string;
    set destination(value: string);
    get destinationInput(): string | undefined;
}
export interface DataDatabricksJobJobSettingsSettingsTaskNewClusterInitScriptsFile {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#destination DataDatabricksJob#destination}
    */
    readonly destination?: string;
}
export declare function dataDatabricksJobJobSettingsSettingsTaskNewClusterInitScriptsFileToTerraform(struct?: DataDatabricksJobJobSettingsSettingsTaskNewClusterInitScriptsFileOutputReference | DataDatabricksJobJobSettingsSettingsTaskNewClusterInitScriptsFile): any;
export declare class DataDatabricksJobJobSettingsSettingsTaskNewClusterInitScriptsFileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksJobJobSettingsSettingsTaskNewClusterInitScriptsFile | undefined;
    set internalValue(value: DataDatabricksJobJobSettingsSettingsTaskNewClusterInitScriptsFile | undefined);
    private _destination?;
    get destination(): string;
    set destination(value: string);
    resetDestination(): void;
    get destinationInput(): string | undefined;
}
export interface DataDatabricksJobJobSettingsSettingsTaskNewClusterInitScriptsGcs {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#destination DataDatabricksJob#destination}
    */
    readonly destination?: string;
}
export declare function dataDatabricksJobJobSettingsSettingsTaskNewClusterInitScriptsGcsToTerraform(struct?: DataDatabricksJobJobSettingsSettingsTaskNewClusterInitScriptsGcsOutputReference | DataDatabricksJobJobSettingsSettingsTaskNewClusterInitScriptsGcs): any;
export declare class DataDatabricksJobJobSettingsSettingsTaskNewClusterInitScriptsGcsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksJobJobSettingsSettingsTaskNewClusterInitScriptsGcs | undefined;
    set internalValue(value: DataDatabricksJobJobSettingsSettingsTaskNewClusterInitScriptsGcs | undefined);
    private _destination?;
    get destination(): string;
    set destination(value: string);
    resetDestination(): void;
    get destinationInput(): string | undefined;
}
export interface DataDatabricksJobJobSettingsSettingsTaskNewClusterInitScriptsS3 {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#canned_acl DataDatabricksJob#canned_acl}
    */
    readonly cannedAcl?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#destination DataDatabricksJob#destination}
    */
    readonly destination: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#enable_encryption DataDatabricksJob#enable_encryption}
    */
    readonly enableEncryption?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#encryption_type DataDatabricksJob#encryption_type}
    */
    readonly encryptionType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#endpoint DataDatabricksJob#endpoint}
    */
    readonly endpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#kms_key DataDatabricksJob#kms_key}
    */
    readonly kmsKey?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#region DataDatabricksJob#region}
    */
    readonly region?: string;
}
export declare function dataDatabricksJobJobSettingsSettingsTaskNewClusterInitScriptsS3ToTerraform(struct?: DataDatabricksJobJobSettingsSettingsTaskNewClusterInitScriptsS3OutputReference | DataDatabricksJobJobSettingsSettingsTaskNewClusterInitScriptsS3): any;
export declare class DataDatabricksJobJobSettingsSettingsTaskNewClusterInitScriptsS3OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksJobJobSettingsSettingsTaskNewClusterInitScriptsS3 | undefined;
    set internalValue(value: DataDatabricksJobJobSettingsSettingsTaskNewClusterInitScriptsS3 | undefined);
    private _cannedAcl?;
    get cannedAcl(): string;
    set cannedAcl(value: string);
    resetCannedAcl(): void;
    get cannedAclInput(): string | undefined;
    private _destination?;
    get destination(): string;
    set destination(value: string);
    get destinationInput(): string | undefined;
    private _enableEncryption?;
    get enableEncryption(): boolean | cdktf.IResolvable;
    set enableEncryption(value: boolean | cdktf.IResolvable);
    resetEnableEncryption(): void;
    get enableEncryptionInput(): boolean | cdktf.IResolvable | undefined;
    private _encryptionType?;
    get encryptionType(): string;
    set encryptionType(value: string);
    resetEncryptionType(): void;
    get encryptionTypeInput(): string | undefined;
    private _endpoint?;
    get endpoint(): string;
    set endpoint(value: string);
    resetEndpoint(): void;
    get endpointInput(): string | undefined;
    private _kmsKey?;
    get kmsKey(): string;
    set kmsKey(value: string);
    resetKmsKey(): void;
    get kmsKeyInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
}
export interface DataDatabricksJobJobSettingsSettingsTaskNewClusterInitScripts {
    /**
    * abfss block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#abfss DataDatabricksJob#abfss}
    */
    readonly abfss?: DataDatabricksJobJobSettingsSettingsTaskNewClusterInitScriptsAbfss;
    /**
    * dbfs block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#dbfs DataDatabricksJob#dbfs}
    */
    readonly dbfs?: DataDatabricksJobJobSettingsSettingsTaskNewClusterInitScriptsDbfs;
    /**
    * file block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#file DataDatabricksJob#file}
    */
    readonly file?: DataDatabricksJobJobSettingsSettingsTaskNewClusterInitScriptsFile;
    /**
    * gcs block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#gcs DataDatabricksJob#gcs}
    */
    readonly gcs?: DataDatabricksJobJobSettingsSettingsTaskNewClusterInitScriptsGcs;
    /**
    * s3 block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#s3 DataDatabricksJob#s3}
    */
    readonly s3?: DataDatabricksJobJobSettingsSettingsTaskNewClusterInitScriptsS3;
}
export declare function dataDatabricksJobJobSettingsSettingsTaskNewClusterInitScriptsToTerraform(struct?: DataDatabricksJobJobSettingsSettingsTaskNewClusterInitScripts | cdktf.IResolvable): any;
export declare class DataDatabricksJobJobSettingsSettingsTaskNewClusterInitScriptsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDatabricksJobJobSettingsSettingsTaskNewClusterInitScripts | cdktf.IResolvable | undefined;
    set internalValue(value: DataDatabricksJobJobSettingsSettingsTaskNewClusterInitScripts | cdktf.IResolvable | undefined);
    private _abfss;
    get abfss(): DataDatabricksJobJobSettingsSettingsTaskNewClusterInitScriptsAbfssOutputReference;
    putAbfss(value: DataDatabricksJobJobSettingsSettingsTaskNewClusterInitScriptsAbfss): void;
    resetAbfss(): void;
    get abfssInput(): DataDatabricksJobJobSettingsSettingsTaskNewClusterInitScriptsAbfss | undefined;
    private _dbfs;
    get dbfs(): DataDatabricksJobJobSettingsSettingsTaskNewClusterInitScriptsDbfsOutputReference;
    putDbfs(value: DataDatabricksJobJobSettingsSettingsTaskNewClusterInitScriptsDbfs): void;
    resetDbfs(): void;
    get dbfsInput(): DataDatabricksJobJobSettingsSettingsTaskNewClusterInitScriptsDbfs | undefined;
    private _file;
    get file(): DataDatabricksJobJobSettingsSettingsTaskNewClusterInitScriptsFileOutputReference;
    putFile(value: DataDatabricksJobJobSettingsSettingsTaskNewClusterInitScriptsFile): void;
    resetFile(): void;
    get fileInput(): DataDatabricksJobJobSettingsSettingsTaskNewClusterInitScriptsFile | undefined;
    private _gcs;
    get gcs(): DataDatabricksJobJobSettingsSettingsTaskNewClusterInitScriptsGcsOutputReference;
    putGcs(value: DataDatabricksJobJobSettingsSettingsTaskNewClusterInitScriptsGcs): void;
    resetGcs(): void;
    get gcsInput(): DataDatabricksJobJobSettingsSettingsTaskNewClusterInitScriptsGcs | undefined;
    private _s3;
    get s3(): DataDatabricksJobJobSettingsSettingsTaskNewClusterInitScriptsS3OutputReference;
    putS3(value: DataDatabricksJobJobSettingsSettingsTaskNewClusterInitScriptsS3): void;
    resetS3(): void;
    get s3Input(): DataDatabricksJobJobSettingsSettingsTaskNewClusterInitScriptsS3 | undefined;
}
export declare class DataDatabricksJobJobSettingsSettingsTaskNewClusterInitScriptsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DataDatabricksJobJobSettingsSettingsTaskNewClusterInitScripts[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDatabricksJobJobSettingsSettingsTaskNewClusterInitScriptsOutputReference;
}
export interface DataDatabricksJobJobSettingsSettingsTaskNewClusterWorkloadTypeClients {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#jobs DataDatabricksJob#jobs}
    */
    readonly jobs?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#notebooks DataDatabricksJob#notebooks}
    */
    readonly notebooks?: boolean | cdktf.IResolvable;
}
export declare function dataDatabricksJobJobSettingsSettingsTaskNewClusterWorkloadTypeClientsToTerraform(struct?: DataDatabricksJobJobSettingsSettingsTaskNewClusterWorkloadTypeClientsOutputReference | DataDatabricksJobJobSettingsSettingsTaskNewClusterWorkloadTypeClients): any;
export declare class DataDatabricksJobJobSettingsSettingsTaskNewClusterWorkloadTypeClientsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksJobJobSettingsSettingsTaskNewClusterWorkloadTypeClients | undefined;
    set internalValue(value: DataDatabricksJobJobSettingsSettingsTaskNewClusterWorkloadTypeClients | undefined);
    private _jobs?;
    get jobs(): boolean | cdktf.IResolvable;
    set jobs(value: boolean | cdktf.IResolvable);
    resetJobs(): void;
    get jobsInput(): boolean | cdktf.IResolvable | undefined;
    private _notebooks?;
    get notebooks(): boolean | cdktf.IResolvable;
    set notebooks(value: boolean | cdktf.IResolvable);
    resetNotebooks(): void;
    get notebooksInput(): boolean | cdktf.IResolvable | undefined;
}
export interface DataDatabricksJobJobSettingsSettingsTaskNewClusterWorkloadType {
    /**
    * clients block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#clients DataDatabricksJob#clients}
    */
    readonly clients: DataDatabricksJobJobSettingsSettingsTaskNewClusterWorkloadTypeClients;
}
export declare function dataDatabricksJobJobSettingsSettingsTaskNewClusterWorkloadTypeToTerraform(struct?: DataDatabricksJobJobSettingsSettingsTaskNewClusterWorkloadTypeOutputReference | DataDatabricksJobJobSettingsSettingsTaskNewClusterWorkloadType): any;
export declare class DataDatabricksJobJobSettingsSettingsTaskNewClusterWorkloadTypeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksJobJobSettingsSettingsTaskNewClusterWorkloadType | undefined;
    set internalValue(value: DataDatabricksJobJobSettingsSettingsTaskNewClusterWorkloadType | undefined);
    private _clients;
    get clients(): DataDatabricksJobJobSettingsSettingsTaskNewClusterWorkloadTypeClientsOutputReference;
    putClients(value: DataDatabricksJobJobSettingsSettingsTaskNewClusterWorkloadTypeClients): void;
    get clientsInput(): DataDatabricksJobJobSettingsSettingsTaskNewClusterWorkloadTypeClients | undefined;
}
export interface DataDatabricksJobJobSettingsSettingsTaskNewCluster {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#apply_policy_default_values DataDatabricksJob#apply_policy_default_values}
    */
    readonly applyPolicyDefaultValues?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#autotermination_minutes DataDatabricksJob#autotermination_minutes}
    */
    readonly autoterminationMinutes?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#cluster_id DataDatabricksJob#cluster_id}
    */
    readonly clusterId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#cluster_name DataDatabricksJob#cluster_name}
    */
    readonly clusterName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#custom_tags DataDatabricksJob#custom_tags}
    */
    readonly customTags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#data_security_mode DataDatabricksJob#data_security_mode}
    */
    readonly dataSecurityMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#driver_instance_pool_id DataDatabricksJob#driver_instance_pool_id}
    */
    readonly driverInstancePoolId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#driver_node_type_id DataDatabricksJob#driver_node_type_id}
    */
    readonly driverNodeTypeId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#enable_elastic_disk DataDatabricksJob#enable_elastic_disk}
    */
    readonly enableElasticDisk?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#enable_local_disk_encryption DataDatabricksJob#enable_local_disk_encryption}
    */
    readonly enableLocalDiskEncryption?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#idempotency_token DataDatabricksJob#idempotency_token}
    */
    readonly idempotencyToken?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#instance_pool_id DataDatabricksJob#instance_pool_id}
    */
    readonly instancePoolId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#node_type_id DataDatabricksJob#node_type_id}
    */
    readonly nodeTypeId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#num_workers DataDatabricksJob#num_workers}
    */
    readonly numWorkers: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#policy_id DataDatabricksJob#policy_id}
    */
    readonly policyId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#runtime_engine DataDatabricksJob#runtime_engine}
    */
    readonly runtimeEngine?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#single_user_name DataDatabricksJob#single_user_name}
    */
    readonly singleUserName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#spark_conf DataDatabricksJob#spark_conf}
    */
    readonly sparkConf?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#spark_env_vars DataDatabricksJob#spark_env_vars}
    */
    readonly sparkEnvVars?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#spark_version DataDatabricksJob#spark_version}
    */
    readonly sparkVersion: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#ssh_public_keys DataDatabricksJob#ssh_public_keys}
    */
    readonly sshPublicKeys?: string[];
    /**
    * autoscale block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#autoscale DataDatabricksJob#autoscale}
    */
    readonly autoscale?: DataDatabricksJobJobSettingsSettingsTaskNewClusterAutoscale;
    /**
    * aws_attributes block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#aws_attributes DataDatabricksJob#aws_attributes}
    */
    readonly awsAttributes?: DataDatabricksJobJobSettingsSettingsTaskNewClusterAwsAttributes;
    /**
    * azure_attributes block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#azure_attributes DataDatabricksJob#azure_attributes}
    */
    readonly azureAttributes?: DataDatabricksJobJobSettingsSettingsTaskNewClusterAzureAttributes;
    /**
    * cluster_log_conf block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#cluster_log_conf DataDatabricksJob#cluster_log_conf}
    */
    readonly clusterLogConf?: DataDatabricksJobJobSettingsSettingsTaskNewClusterClusterLogConf;
    /**
    * cluster_mount_info block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#cluster_mount_info DataDatabricksJob#cluster_mount_info}
    */
    readonly clusterMountInfo?: DataDatabricksJobJobSettingsSettingsTaskNewClusterClusterMountInfo[] | cdktf.IResolvable;
    /**
    * docker_image block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#docker_image DataDatabricksJob#docker_image}
    */
    readonly dockerImage?: DataDatabricksJobJobSettingsSettingsTaskNewClusterDockerImage;
    /**
    * gcp_attributes block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#gcp_attributes DataDatabricksJob#gcp_attributes}
    */
    readonly gcpAttributes?: DataDatabricksJobJobSettingsSettingsTaskNewClusterGcpAttributes;
    /**
    * init_scripts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#init_scripts DataDatabricksJob#init_scripts}
    */
    readonly initScripts?: DataDatabricksJobJobSettingsSettingsTaskNewClusterInitScripts[] | cdktf.IResolvable;
    /**
    * workload_type block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#workload_type DataDatabricksJob#workload_type}
    */
    readonly workloadType?: DataDatabricksJobJobSettingsSettingsTaskNewClusterWorkloadType;
}
export declare function dataDatabricksJobJobSettingsSettingsTaskNewClusterToTerraform(struct?: DataDatabricksJobJobSettingsSettingsTaskNewClusterOutputReference | DataDatabricksJobJobSettingsSettingsTaskNewCluster): any;
export declare class DataDatabricksJobJobSettingsSettingsTaskNewClusterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksJobJobSettingsSettingsTaskNewCluster | undefined;
    set internalValue(value: DataDatabricksJobJobSettingsSettingsTaskNewCluster | undefined);
    private _applyPolicyDefaultValues?;
    get applyPolicyDefaultValues(): boolean | cdktf.IResolvable;
    set applyPolicyDefaultValues(value: boolean | cdktf.IResolvable);
    resetApplyPolicyDefaultValues(): void;
    get applyPolicyDefaultValuesInput(): boolean | cdktf.IResolvable | undefined;
    private _autoterminationMinutes?;
    get autoterminationMinutes(): number;
    set autoterminationMinutes(value: number);
    resetAutoterminationMinutes(): void;
    get autoterminationMinutesInput(): number | undefined;
    private _clusterId?;
    get clusterId(): string;
    set clusterId(value: string);
    resetClusterId(): void;
    get clusterIdInput(): string | undefined;
    private _clusterName?;
    get clusterName(): string;
    set clusterName(value: string);
    resetClusterName(): void;
    get clusterNameInput(): string | undefined;
    private _customTags?;
    get customTags(): {
        [key: string]: string;
    };
    set customTags(value: {
        [key: string]: string;
    });
    resetCustomTags(): void;
    get customTagsInput(): {
        [key: string]: string;
    } | undefined;
    private _dataSecurityMode?;
    get dataSecurityMode(): string;
    set dataSecurityMode(value: string);
    resetDataSecurityMode(): void;
    get dataSecurityModeInput(): string | undefined;
    private _driverInstancePoolId?;
    get driverInstancePoolId(): string;
    set driverInstancePoolId(value: string);
    resetDriverInstancePoolId(): void;
    get driverInstancePoolIdInput(): string | undefined;
    private _driverNodeTypeId?;
    get driverNodeTypeId(): string;
    set driverNodeTypeId(value: string);
    resetDriverNodeTypeId(): void;
    get driverNodeTypeIdInput(): string | undefined;
    private _enableElasticDisk?;
    get enableElasticDisk(): boolean | cdktf.IResolvable;
    set enableElasticDisk(value: boolean | cdktf.IResolvable);
    resetEnableElasticDisk(): void;
    get enableElasticDiskInput(): boolean | cdktf.IResolvable | undefined;
    private _enableLocalDiskEncryption?;
    get enableLocalDiskEncryption(): boolean | cdktf.IResolvable;
    set enableLocalDiskEncryption(value: boolean | cdktf.IResolvable);
    resetEnableLocalDiskEncryption(): void;
    get enableLocalDiskEncryptionInput(): boolean | cdktf.IResolvable | undefined;
    private _idempotencyToken?;
    get idempotencyToken(): string;
    set idempotencyToken(value: string);
    resetIdempotencyToken(): void;
    get idempotencyTokenInput(): string | undefined;
    private _instancePoolId?;
    get instancePoolId(): string;
    set instancePoolId(value: string);
    resetInstancePoolId(): void;
    get instancePoolIdInput(): string | undefined;
    private _nodeTypeId?;
    get nodeTypeId(): string;
    set nodeTypeId(value: string);
    resetNodeTypeId(): void;
    get nodeTypeIdInput(): string | undefined;
    private _numWorkers?;
    get numWorkers(): number;
    set numWorkers(value: number);
    get numWorkersInput(): number | undefined;
    private _policyId?;
    get policyId(): string;
    set policyId(value: string);
    resetPolicyId(): void;
    get policyIdInput(): string | undefined;
    private _runtimeEngine?;
    get runtimeEngine(): string;
    set runtimeEngine(value: string);
    resetRuntimeEngine(): void;
    get runtimeEngineInput(): string | undefined;
    private _singleUserName?;
    get singleUserName(): string;
    set singleUserName(value: string);
    resetSingleUserName(): void;
    get singleUserNameInput(): string | undefined;
    private _sparkConf?;
    get sparkConf(): {
        [key: string]: string;
    };
    set sparkConf(value: {
        [key: string]: string;
    });
    resetSparkConf(): void;
    get sparkConfInput(): {
        [key: string]: string;
    } | undefined;
    private _sparkEnvVars?;
    get sparkEnvVars(): {
        [key: string]: string;
    };
    set sparkEnvVars(value: {
        [key: string]: string;
    });
    resetSparkEnvVars(): void;
    get sparkEnvVarsInput(): {
        [key: string]: string;
    } | undefined;
    private _sparkVersion?;
    get sparkVersion(): string;
    set sparkVersion(value: string);
    get sparkVersionInput(): string | undefined;
    private _sshPublicKeys?;
    get sshPublicKeys(): string[];
    set sshPublicKeys(value: string[]);
    resetSshPublicKeys(): void;
    get sshPublicKeysInput(): string[] | undefined;
    private _autoscale;
    get autoscale(): DataDatabricksJobJobSettingsSettingsTaskNewClusterAutoscaleOutputReference;
    putAutoscale(value: DataDatabricksJobJobSettingsSettingsTaskNewClusterAutoscale): void;
    resetAutoscale(): void;
    get autoscaleInput(): DataDatabricksJobJobSettingsSettingsTaskNewClusterAutoscale | undefined;
    private _awsAttributes;
    get awsAttributes(): DataDatabricksJobJobSettingsSettingsTaskNewClusterAwsAttributesOutputReference;
    putAwsAttributes(value: DataDatabricksJobJobSettingsSettingsTaskNewClusterAwsAttributes): void;
    resetAwsAttributes(): void;
    get awsAttributesInput(): DataDatabricksJobJobSettingsSettingsTaskNewClusterAwsAttributes | undefined;
    private _azureAttributes;
    get azureAttributes(): DataDatabricksJobJobSettingsSettingsTaskNewClusterAzureAttributesOutputReference;
    putAzureAttributes(value: DataDatabricksJobJobSettingsSettingsTaskNewClusterAzureAttributes): void;
    resetAzureAttributes(): void;
    get azureAttributesInput(): DataDatabricksJobJobSettingsSettingsTaskNewClusterAzureAttributes | undefined;
    private _clusterLogConf;
    get clusterLogConf(): DataDatabricksJobJobSettingsSettingsTaskNewClusterClusterLogConfOutputReference;
    putClusterLogConf(value: DataDatabricksJobJobSettingsSettingsTaskNewClusterClusterLogConf): void;
    resetClusterLogConf(): void;
    get clusterLogConfInput(): DataDatabricksJobJobSettingsSettingsTaskNewClusterClusterLogConf | undefined;
    private _clusterMountInfo;
    get clusterMountInfo(): DataDatabricksJobJobSettingsSettingsTaskNewClusterClusterMountInfoList;
    putClusterMountInfo(value: DataDatabricksJobJobSettingsSettingsTaskNewClusterClusterMountInfo[] | cdktf.IResolvable): void;
    resetClusterMountInfo(): void;
    get clusterMountInfoInput(): cdktf.IResolvable | DataDatabricksJobJobSettingsSettingsTaskNewClusterClusterMountInfo[] | undefined;
    private _dockerImage;
    get dockerImage(): DataDatabricksJobJobSettingsSettingsTaskNewClusterDockerImageOutputReference;
    putDockerImage(value: DataDatabricksJobJobSettingsSettingsTaskNewClusterDockerImage): void;
    resetDockerImage(): void;
    get dockerImageInput(): DataDatabricksJobJobSettingsSettingsTaskNewClusterDockerImage | undefined;
    private _gcpAttributes;
    get gcpAttributes(): DataDatabricksJobJobSettingsSettingsTaskNewClusterGcpAttributesOutputReference;
    putGcpAttributes(value: DataDatabricksJobJobSettingsSettingsTaskNewClusterGcpAttributes): void;
    resetGcpAttributes(): void;
    get gcpAttributesInput(): DataDatabricksJobJobSettingsSettingsTaskNewClusterGcpAttributes | undefined;
    private _initScripts;
    get initScripts(): DataDatabricksJobJobSettingsSettingsTaskNewClusterInitScriptsList;
    putInitScripts(value: DataDatabricksJobJobSettingsSettingsTaskNewClusterInitScripts[] | cdktf.IResolvable): void;
    resetInitScripts(): void;
    get initScriptsInput(): cdktf.IResolvable | DataDatabricksJobJobSettingsSettingsTaskNewClusterInitScripts[] | undefined;
    private _workloadType;
    get workloadType(): DataDatabricksJobJobSettingsSettingsTaskNewClusterWorkloadTypeOutputReference;
    putWorkloadType(value: DataDatabricksJobJobSettingsSettingsTaskNewClusterWorkloadType): void;
    resetWorkloadType(): void;
    get workloadTypeInput(): DataDatabricksJobJobSettingsSettingsTaskNewClusterWorkloadType | undefined;
}
export interface DataDatabricksJobJobSettingsSettingsTaskNotebookTask {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#base_parameters DataDatabricksJob#base_parameters}
    */
    readonly baseParameters?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#notebook_path DataDatabricksJob#notebook_path}
    */
    readonly notebookPath: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#source DataDatabricksJob#source}
    */
    readonly source?: string;
}
export declare function dataDatabricksJobJobSettingsSettingsTaskNotebookTaskToTerraform(struct?: DataDatabricksJobJobSettingsSettingsTaskNotebookTaskOutputReference | DataDatabricksJobJobSettingsSettingsTaskNotebookTask): any;
export declare class DataDatabricksJobJobSettingsSettingsTaskNotebookTaskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksJobJobSettingsSettingsTaskNotebookTask | undefined;
    set internalValue(value: DataDatabricksJobJobSettingsSettingsTaskNotebookTask | undefined);
    private _baseParameters?;
    get baseParameters(): {
        [key: string]: string;
    };
    set baseParameters(value: {
        [key: string]: string;
    });
    resetBaseParameters(): void;
    get baseParametersInput(): {
        [key: string]: string;
    } | undefined;
    private _notebookPath?;
    get notebookPath(): string;
    set notebookPath(value: string);
    get notebookPathInput(): string | undefined;
    private _source?;
    get source(): string;
    set source(value: string);
    resetSource(): void;
    get sourceInput(): string | undefined;
}
export interface DataDatabricksJobJobSettingsSettingsTaskPipelineTask {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#pipeline_id DataDatabricksJob#pipeline_id}
    */
    readonly pipelineId: string;
}
export declare function dataDatabricksJobJobSettingsSettingsTaskPipelineTaskToTerraform(struct?: DataDatabricksJobJobSettingsSettingsTaskPipelineTaskOutputReference | DataDatabricksJobJobSettingsSettingsTaskPipelineTask): any;
export declare class DataDatabricksJobJobSettingsSettingsTaskPipelineTaskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksJobJobSettingsSettingsTaskPipelineTask | undefined;
    set internalValue(value: DataDatabricksJobJobSettingsSettingsTaskPipelineTask | undefined);
    private _pipelineId?;
    get pipelineId(): string;
    set pipelineId(value: string);
    get pipelineIdInput(): string | undefined;
}
export interface DataDatabricksJobJobSettingsSettingsTaskPythonWheelTask {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#entry_point DataDatabricksJob#entry_point}
    */
    readonly entryPoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#named_parameters DataDatabricksJob#named_parameters}
    */
    readonly namedParameters?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#package_name DataDatabricksJob#package_name}
    */
    readonly packageName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#parameters DataDatabricksJob#parameters}
    */
    readonly parameters?: string[];
}
export declare function dataDatabricksJobJobSettingsSettingsTaskPythonWheelTaskToTerraform(struct?: DataDatabricksJobJobSettingsSettingsTaskPythonWheelTaskOutputReference | DataDatabricksJobJobSettingsSettingsTaskPythonWheelTask): any;
export declare class DataDatabricksJobJobSettingsSettingsTaskPythonWheelTaskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksJobJobSettingsSettingsTaskPythonWheelTask | undefined;
    set internalValue(value: DataDatabricksJobJobSettingsSettingsTaskPythonWheelTask | undefined);
    private _entryPoint?;
    get entryPoint(): string;
    set entryPoint(value: string);
    resetEntryPoint(): void;
    get entryPointInput(): string | undefined;
    private _namedParameters?;
    get namedParameters(): {
        [key: string]: string;
    };
    set namedParameters(value: {
        [key: string]: string;
    });
    resetNamedParameters(): void;
    get namedParametersInput(): {
        [key: string]: string;
    } | undefined;
    private _packageName?;
    get packageName(): string;
    set packageName(value: string);
    resetPackageName(): void;
    get packageNameInput(): string | undefined;
    private _parameters?;
    get parameters(): string[];
    set parameters(value: string[]);
    resetParameters(): void;
    get parametersInput(): string[] | undefined;
}
export interface DataDatabricksJobJobSettingsSettingsTaskSparkJarTask {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#jar_uri DataDatabricksJob#jar_uri}
    */
    readonly jarUri?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#main_class_name DataDatabricksJob#main_class_name}
    */
    readonly mainClassName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#parameters DataDatabricksJob#parameters}
    */
    readonly parameters?: string[];
}
export declare function dataDatabricksJobJobSettingsSettingsTaskSparkJarTaskToTerraform(struct?: DataDatabricksJobJobSettingsSettingsTaskSparkJarTaskOutputReference | DataDatabricksJobJobSettingsSettingsTaskSparkJarTask): any;
export declare class DataDatabricksJobJobSettingsSettingsTaskSparkJarTaskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksJobJobSettingsSettingsTaskSparkJarTask | undefined;
    set internalValue(value: DataDatabricksJobJobSettingsSettingsTaskSparkJarTask | undefined);
    private _jarUri?;
    get jarUri(): string;
    set jarUri(value: string);
    resetJarUri(): void;
    get jarUriInput(): string | undefined;
    private _mainClassName?;
    get mainClassName(): string;
    set mainClassName(value: string);
    resetMainClassName(): void;
    get mainClassNameInput(): string | undefined;
    private _parameters?;
    get parameters(): string[];
    set parameters(value: string[]);
    resetParameters(): void;
    get parametersInput(): string[] | undefined;
}
export interface DataDatabricksJobJobSettingsSettingsTaskSparkPythonTask {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#parameters DataDatabricksJob#parameters}
    */
    readonly parameters?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#python_file DataDatabricksJob#python_file}
    */
    readonly pythonFile: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#source DataDatabricksJob#source}
    */
    readonly source?: string;
}
export declare function dataDatabricksJobJobSettingsSettingsTaskSparkPythonTaskToTerraform(struct?: DataDatabricksJobJobSettingsSettingsTaskSparkPythonTaskOutputReference | DataDatabricksJobJobSettingsSettingsTaskSparkPythonTask): any;
export declare class DataDatabricksJobJobSettingsSettingsTaskSparkPythonTaskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksJobJobSettingsSettingsTaskSparkPythonTask | undefined;
    set internalValue(value: DataDatabricksJobJobSettingsSettingsTaskSparkPythonTask | undefined);
    private _parameters?;
    get parameters(): string[];
    set parameters(value: string[]);
    resetParameters(): void;
    get parametersInput(): string[] | undefined;
    private _pythonFile?;
    get pythonFile(): string;
    set pythonFile(value: string);
    get pythonFileInput(): string | undefined;
    private _source?;
    get source(): string;
    set source(value: string);
    resetSource(): void;
    get sourceInput(): string | undefined;
}
export interface DataDatabricksJobJobSettingsSettingsTaskSparkSubmitTask {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#parameters DataDatabricksJob#parameters}
    */
    readonly parameters?: string[];
}
export declare function dataDatabricksJobJobSettingsSettingsTaskSparkSubmitTaskToTerraform(struct?: DataDatabricksJobJobSettingsSettingsTaskSparkSubmitTaskOutputReference | DataDatabricksJobJobSettingsSettingsTaskSparkSubmitTask): any;
export declare class DataDatabricksJobJobSettingsSettingsTaskSparkSubmitTaskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksJobJobSettingsSettingsTaskSparkSubmitTask | undefined;
    set internalValue(value: DataDatabricksJobJobSettingsSettingsTaskSparkSubmitTask | undefined);
    private _parameters?;
    get parameters(): string[];
    set parameters(value: string[]);
    resetParameters(): void;
    get parametersInput(): string[] | undefined;
}
export interface DataDatabricksJobJobSettingsSettingsTaskSqlTaskAlert {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#alert_id DataDatabricksJob#alert_id}
    */
    readonly alertId: string;
}
export declare function dataDatabricksJobJobSettingsSettingsTaskSqlTaskAlertToTerraform(struct?: DataDatabricksJobJobSettingsSettingsTaskSqlTaskAlertOutputReference | DataDatabricksJobJobSettingsSettingsTaskSqlTaskAlert): any;
export declare class DataDatabricksJobJobSettingsSettingsTaskSqlTaskAlertOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksJobJobSettingsSettingsTaskSqlTaskAlert | undefined;
    set internalValue(value: DataDatabricksJobJobSettingsSettingsTaskSqlTaskAlert | undefined);
    private _alertId?;
    get alertId(): string;
    set alertId(value: string);
    get alertIdInput(): string | undefined;
}
export interface DataDatabricksJobJobSettingsSettingsTaskSqlTaskDashboard {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#dashboard_id DataDatabricksJob#dashboard_id}
    */
    readonly dashboardId: string;
}
export declare function dataDatabricksJobJobSettingsSettingsTaskSqlTaskDashboardToTerraform(struct?: DataDatabricksJobJobSettingsSettingsTaskSqlTaskDashboardOutputReference | DataDatabricksJobJobSettingsSettingsTaskSqlTaskDashboard): any;
export declare class DataDatabricksJobJobSettingsSettingsTaskSqlTaskDashboardOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksJobJobSettingsSettingsTaskSqlTaskDashboard | undefined;
    set internalValue(value: DataDatabricksJobJobSettingsSettingsTaskSqlTaskDashboard | undefined);
    private _dashboardId?;
    get dashboardId(): string;
    set dashboardId(value: string);
    get dashboardIdInput(): string | undefined;
}
export interface DataDatabricksJobJobSettingsSettingsTaskSqlTaskFile {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#path DataDatabricksJob#path}
    */
    readonly path: string;
}
export declare function dataDatabricksJobJobSettingsSettingsTaskSqlTaskFileToTerraform(struct?: DataDatabricksJobJobSettingsSettingsTaskSqlTaskFileOutputReference | DataDatabricksJobJobSettingsSettingsTaskSqlTaskFile): any;
export declare class DataDatabricksJobJobSettingsSettingsTaskSqlTaskFileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksJobJobSettingsSettingsTaskSqlTaskFile | undefined;
    set internalValue(value: DataDatabricksJobJobSettingsSettingsTaskSqlTaskFile | undefined);
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
}
export interface DataDatabricksJobJobSettingsSettingsTaskSqlTaskQuery {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#query_id DataDatabricksJob#query_id}
    */
    readonly queryId: string;
}
export declare function dataDatabricksJobJobSettingsSettingsTaskSqlTaskQueryToTerraform(struct?: DataDatabricksJobJobSettingsSettingsTaskSqlTaskQueryOutputReference | DataDatabricksJobJobSettingsSettingsTaskSqlTaskQuery): any;
export declare class DataDatabricksJobJobSettingsSettingsTaskSqlTaskQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksJobJobSettingsSettingsTaskSqlTaskQuery | undefined;
    set internalValue(value: DataDatabricksJobJobSettingsSettingsTaskSqlTaskQuery | undefined);
    private _queryId?;
    get queryId(): string;
    set queryId(value: string);
    get queryIdInput(): string | undefined;
}
export interface DataDatabricksJobJobSettingsSettingsTaskSqlTask {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#parameters DataDatabricksJob#parameters}
    */
    readonly parameters?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#warehouse_id DataDatabricksJob#warehouse_id}
    */
    readonly warehouseId?: string;
    /**
    * alert block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#alert DataDatabricksJob#alert}
    */
    readonly alert?: DataDatabricksJobJobSettingsSettingsTaskSqlTaskAlert;
    /**
    * dashboard block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#dashboard DataDatabricksJob#dashboard}
    */
    readonly dashboard?: DataDatabricksJobJobSettingsSettingsTaskSqlTaskDashboard;
    /**
    * file block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#file DataDatabricksJob#file}
    */
    readonly file?: DataDatabricksJobJobSettingsSettingsTaskSqlTaskFile;
    /**
    * query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#query DataDatabricksJob#query}
    */
    readonly query?: DataDatabricksJobJobSettingsSettingsTaskSqlTaskQuery;
}
export declare function dataDatabricksJobJobSettingsSettingsTaskSqlTaskToTerraform(struct?: DataDatabricksJobJobSettingsSettingsTaskSqlTaskOutputReference | DataDatabricksJobJobSettingsSettingsTaskSqlTask): any;
export declare class DataDatabricksJobJobSettingsSettingsTaskSqlTaskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksJobJobSettingsSettingsTaskSqlTask | undefined;
    set internalValue(value: DataDatabricksJobJobSettingsSettingsTaskSqlTask | undefined);
    private _parameters?;
    get parameters(): {
        [key: string]: string;
    };
    set parameters(value: {
        [key: string]: string;
    });
    resetParameters(): void;
    get parametersInput(): {
        [key: string]: string;
    } | undefined;
    private _warehouseId?;
    get warehouseId(): string;
    set warehouseId(value: string);
    resetWarehouseId(): void;
    get warehouseIdInput(): string | undefined;
    private _alert;
    get alert(): DataDatabricksJobJobSettingsSettingsTaskSqlTaskAlertOutputReference;
    putAlert(value: DataDatabricksJobJobSettingsSettingsTaskSqlTaskAlert): void;
    resetAlert(): void;
    get alertInput(): DataDatabricksJobJobSettingsSettingsTaskSqlTaskAlert | undefined;
    private _dashboard;
    get dashboard(): DataDatabricksJobJobSettingsSettingsTaskSqlTaskDashboardOutputReference;
    putDashboard(value: DataDatabricksJobJobSettingsSettingsTaskSqlTaskDashboard): void;
    resetDashboard(): void;
    get dashboardInput(): DataDatabricksJobJobSettingsSettingsTaskSqlTaskDashboard | undefined;
    private _file;
    get file(): DataDatabricksJobJobSettingsSettingsTaskSqlTaskFileOutputReference;
    putFile(value: DataDatabricksJobJobSettingsSettingsTaskSqlTaskFile): void;
    resetFile(): void;
    get fileInput(): DataDatabricksJobJobSettingsSettingsTaskSqlTaskFile | undefined;
    private _query;
    get query(): DataDatabricksJobJobSettingsSettingsTaskSqlTaskQueryOutputReference;
    putQuery(value: DataDatabricksJobJobSettingsSettingsTaskSqlTaskQuery): void;
    resetQuery(): void;
    get queryInput(): DataDatabricksJobJobSettingsSettingsTaskSqlTaskQuery | undefined;
}
export interface DataDatabricksJobJobSettingsSettingsTask {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#description DataDatabricksJob#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#existing_cluster_id DataDatabricksJob#existing_cluster_id}
    */
    readonly existingClusterId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#job_cluster_key DataDatabricksJob#job_cluster_key}
    */
    readonly jobClusterKey?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#max_retries DataDatabricksJob#max_retries}
    */
    readonly maxRetries?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#min_retry_interval_millis DataDatabricksJob#min_retry_interval_millis}
    */
    readonly minRetryIntervalMillis?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#retry_on_timeout DataDatabricksJob#retry_on_timeout}
    */
    readonly retryOnTimeout?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#run_if DataDatabricksJob#run_if}
    */
    readonly runIf?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#task_key DataDatabricksJob#task_key}
    */
    readonly taskKey?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#timeout_seconds DataDatabricksJob#timeout_seconds}
    */
    readonly timeoutSeconds?: number;
    /**
    * dbt_task block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#dbt_task DataDatabricksJob#dbt_task}
    */
    readonly dbtTask?: DataDatabricksJobJobSettingsSettingsTaskDbtTask;
    /**
    * depends_on block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#depends_on DataDatabricksJob#depends_on}
    */
    readonly dependsOn?: DataDatabricksJobJobSettingsSettingsTaskDependsOn[] | cdktf.IResolvable;
    /**
    * email_notifications block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#email_notifications DataDatabricksJob#email_notifications}
    */
    readonly emailNotifications?: DataDatabricksJobJobSettingsSettingsTaskEmailNotifications;
    /**
    * library block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#library DataDatabricksJob#library}
    */
    readonly library?: DataDatabricksJobJobSettingsSettingsTaskLibrary[] | cdktf.IResolvable;
    /**
    * new_cluster block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#new_cluster DataDatabricksJob#new_cluster}
    */
    readonly newCluster?: DataDatabricksJobJobSettingsSettingsTaskNewCluster;
    /**
    * notebook_task block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#notebook_task DataDatabricksJob#notebook_task}
    */
    readonly notebookTask?: DataDatabricksJobJobSettingsSettingsTaskNotebookTask;
    /**
    * pipeline_task block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#pipeline_task DataDatabricksJob#pipeline_task}
    */
    readonly pipelineTask?: DataDatabricksJobJobSettingsSettingsTaskPipelineTask;
    /**
    * python_wheel_task block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#python_wheel_task DataDatabricksJob#python_wheel_task}
    */
    readonly pythonWheelTask?: DataDatabricksJobJobSettingsSettingsTaskPythonWheelTask;
    /**
    * spark_jar_task block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#spark_jar_task DataDatabricksJob#spark_jar_task}
    */
    readonly sparkJarTask?: DataDatabricksJobJobSettingsSettingsTaskSparkJarTask;
    /**
    * spark_python_task block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#spark_python_task DataDatabricksJob#spark_python_task}
    */
    readonly sparkPythonTask?: DataDatabricksJobJobSettingsSettingsTaskSparkPythonTask;
    /**
    * spark_submit_task block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#spark_submit_task DataDatabricksJob#spark_submit_task}
    */
    readonly sparkSubmitTask?: DataDatabricksJobJobSettingsSettingsTaskSparkSubmitTask;
    /**
    * sql_task block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#sql_task DataDatabricksJob#sql_task}
    */
    readonly sqlTask?: DataDatabricksJobJobSettingsSettingsTaskSqlTask;
}
export declare function dataDatabricksJobJobSettingsSettingsTaskToTerraform(struct?: DataDatabricksJobJobSettingsSettingsTask | cdktf.IResolvable): any;
export declare class DataDatabricksJobJobSettingsSettingsTaskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDatabricksJobJobSettingsSettingsTask | cdktf.IResolvable | undefined;
    set internalValue(value: DataDatabricksJobJobSettingsSettingsTask | cdktf.IResolvable | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _existingClusterId?;
    get existingClusterId(): string;
    set existingClusterId(value: string);
    resetExistingClusterId(): void;
    get existingClusterIdInput(): string | undefined;
    private _jobClusterKey?;
    get jobClusterKey(): string;
    set jobClusterKey(value: string);
    resetJobClusterKey(): void;
    get jobClusterKeyInput(): string | undefined;
    private _maxRetries?;
    get maxRetries(): number;
    set maxRetries(value: number);
    resetMaxRetries(): void;
    get maxRetriesInput(): number | undefined;
    private _minRetryIntervalMillis?;
    get minRetryIntervalMillis(): number;
    set minRetryIntervalMillis(value: number);
    resetMinRetryIntervalMillis(): void;
    get minRetryIntervalMillisInput(): number | undefined;
    private _retryOnTimeout?;
    get retryOnTimeout(): boolean | cdktf.IResolvable;
    set retryOnTimeout(value: boolean | cdktf.IResolvable);
    resetRetryOnTimeout(): void;
    get retryOnTimeoutInput(): boolean | cdktf.IResolvable | undefined;
    private _runIf?;
    get runIf(): string;
    set runIf(value: string);
    resetRunIf(): void;
    get runIfInput(): string | undefined;
    private _taskKey?;
    get taskKey(): string;
    set taskKey(value: string);
    resetTaskKey(): void;
    get taskKeyInput(): string | undefined;
    private _timeoutSeconds?;
    get timeoutSeconds(): number;
    set timeoutSeconds(value: number);
    resetTimeoutSeconds(): void;
    get timeoutSecondsInput(): number | undefined;
    private _dbtTask;
    get dbtTask(): DataDatabricksJobJobSettingsSettingsTaskDbtTaskOutputReference;
    putDbtTask(value: DataDatabricksJobJobSettingsSettingsTaskDbtTask): void;
    resetDbtTask(): void;
    get dbtTaskInput(): DataDatabricksJobJobSettingsSettingsTaskDbtTask | undefined;
    private _dependsOn;
    get dependsOn(): DataDatabricksJobJobSettingsSettingsTaskDependsOnList;
    putDependsOn(value: DataDatabricksJobJobSettingsSettingsTaskDependsOn[] | cdktf.IResolvable): void;
    resetDependsOn(): void;
    get dependsOnInput(): cdktf.IResolvable | DataDatabricksJobJobSettingsSettingsTaskDependsOn[] | undefined;
    private _emailNotifications;
    get emailNotifications(): DataDatabricksJobJobSettingsSettingsTaskEmailNotificationsOutputReference;
    putEmailNotifications(value: DataDatabricksJobJobSettingsSettingsTaskEmailNotifications): void;
    resetEmailNotifications(): void;
    get emailNotificationsInput(): DataDatabricksJobJobSettingsSettingsTaskEmailNotifications | undefined;
    private _library;
    get library(): DataDatabricksJobJobSettingsSettingsTaskLibraryList;
    putLibrary(value: DataDatabricksJobJobSettingsSettingsTaskLibrary[] | cdktf.IResolvable): void;
    resetLibrary(): void;
    get libraryInput(): cdktf.IResolvable | DataDatabricksJobJobSettingsSettingsTaskLibrary[] | undefined;
    private _newCluster;
    get newCluster(): DataDatabricksJobJobSettingsSettingsTaskNewClusterOutputReference;
    putNewCluster(value: DataDatabricksJobJobSettingsSettingsTaskNewCluster): void;
    resetNewCluster(): void;
    get newClusterInput(): DataDatabricksJobJobSettingsSettingsTaskNewCluster | undefined;
    private _notebookTask;
    get notebookTask(): DataDatabricksJobJobSettingsSettingsTaskNotebookTaskOutputReference;
    putNotebookTask(value: DataDatabricksJobJobSettingsSettingsTaskNotebookTask): void;
    resetNotebookTask(): void;
    get notebookTaskInput(): DataDatabricksJobJobSettingsSettingsTaskNotebookTask | undefined;
    private _pipelineTask;
    get pipelineTask(): DataDatabricksJobJobSettingsSettingsTaskPipelineTaskOutputReference;
    putPipelineTask(value: DataDatabricksJobJobSettingsSettingsTaskPipelineTask): void;
    resetPipelineTask(): void;
    get pipelineTaskInput(): DataDatabricksJobJobSettingsSettingsTaskPipelineTask | undefined;
    private _pythonWheelTask;
    get pythonWheelTask(): DataDatabricksJobJobSettingsSettingsTaskPythonWheelTaskOutputReference;
    putPythonWheelTask(value: DataDatabricksJobJobSettingsSettingsTaskPythonWheelTask): void;
    resetPythonWheelTask(): void;
    get pythonWheelTaskInput(): DataDatabricksJobJobSettingsSettingsTaskPythonWheelTask | undefined;
    private _sparkJarTask;
    get sparkJarTask(): DataDatabricksJobJobSettingsSettingsTaskSparkJarTaskOutputReference;
    putSparkJarTask(value: DataDatabricksJobJobSettingsSettingsTaskSparkJarTask): void;
    resetSparkJarTask(): void;
    get sparkJarTaskInput(): DataDatabricksJobJobSettingsSettingsTaskSparkJarTask | undefined;
    private _sparkPythonTask;
    get sparkPythonTask(): DataDatabricksJobJobSettingsSettingsTaskSparkPythonTaskOutputReference;
    putSparkPythonTask(value: DataDatabricksJobJobSettingsSettingsTaskSparkPythonTask): void;
    resetSparkPythonTask(): void;
    get sparkPythonTaskInput(): DataDatabricksJobJobSettingsSettingsTaskSparkPythonTask | undefined;
    private _sparkSubmitTask;
    get sparkSubmitTask(): DataDatabricksJobJobSettingsSettingsTaskSparkSubmitTaskOutputReference;
    putSparkSubmitTask(value: DataDatabricksJobJobSettingsSettingsTaskSparkSubmitTask): void;
    resetSparkSubmitTask(): void;
    get sparkSubmitTaskInput(): DataDatabricksJobJobSettingsSettingsTaskSparkSubmitTask | undefined;
    private _sqlTask;
    get sqlTask(): DataDatabricksJobJobSettingsSettingsTaskSqlTaskOutputReference;
    putSqlTask(value: DataDatabricksJobJobSettingsSettingsTaskSqlTask): void;
    resetSqlTask(): void;
    get sqlTaskInput(): DataDatabricksJobJobSettingsSettingsTaskSqlTask | undefined;
}
export declare class DataDatabricksJobJobSettingsSettingsTaskList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DataDatabricksJobJobSettingsSettingsTask[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDatabricksJobJobSettingsSettingsTaskOutputReference;
}
export interface DataDatabricksJobJobSettingsSettingsTriggerFileArrival {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#min_time_between_trigger_seconds DataDatabricksJob#min_time_between_trigger_seconds}
    */
    readonly minTimeBetweenTriggerSeconds?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#url DataDatabricksJob#url}
    */
    readonly url: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#wait_after_last_change_seconds DataDatabricksJob#wait_after_last_change_seconds}
    */
    readonly waitAfterLastChangeSeconds?: number;
}
export declare function dataDatabricksJobJobSettingsSettingsTriggerFileArrivalToTerraform(struct?: DataDatabricksJobJobSettingsSettingsTriggerFileArrivalOutputReference | DataDatabricksJobJobSettingsSettingsTriggerFileArrival): any;
export declare class DataDatabricksJobJobSettingsSettingsTriggerFileArrivalOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksJobJobSettingsSettingsTriggerFileArrival | undefined;
    set internalValue(value: DataDatabricksJobJobSettingsSettingsTriggerFileArrival | undefined);
    private _minTimeBetweenTriggerSeconds?;
    get minTimeBetweenTriggerSeconds(): number;
    set minTimeBetweenTriggerSeconds(value: number);
    resetMinTimeBetweenTriggerSeconds(): void;
    get minTimeBetweenTriggerSecondsInput(): number | undefined;
    private _url?;
    get url(): string;
    set url(value: string);
    get urlInput(): string | undefined;
    private _waitAfterLastChangeSeconds?;
    get waitAfterLastChangeSeconds(): number;
    set waitAfterLastChangeSeconds(value: number);
    resetWaitAfterLastChangeSeconds(): void;
    get waitAfterLastChangeSecondsInput(): number | undefined;
}
export interface DataDatabricksJobJobSettingsSettingsTrigger {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#pause_status DataDatabricksJob#pause_status}
    */
    readonly pauseStatus?: string;
    /**
    * file_arrival block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#file_arrival DataDatabricksJob#file_arrival}
    */
    readonly fileArrival: DataDatabricksJobJobSettingsSettingsTriggerFileArrival;
}
export declare function dataDatabricksJobJobSettingsSettingsTriggerToTerraform(struct?: DataDatabricksJobJobSettingsSettingsTriggerOutputReference | DataDatabricksJobJobSettingsSettingsTrigger): any;
export declare class DataDatabricksJobJobSettingsSettingsTriggerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksJobJobSettingsSettingsTrigger | undefined;
    set internalValue(value: DataDatabricksJobJobSettingsSettingsTrigger | undefined);
    private _pauseStatus?;
    get pauseStatus(): string;
    set pauseStatus(value: string);
    resetPauseStatus(): void;
    get pauseStatusInput(): string | undefined;
    private _fileArrival;
    get fileArrival(): DataDatabricksJobJobSettingsSettingsTriggerFileArrivalOutputReference;
    putFileArrival(value: DataDatabricksJobJobSettingsSettingsTriggerFileArrival): void;
    get fileArrivalInput(): DataDatabricksJobJobSettingsSettingsTriggerFileArrival | undefined;
}
export interface DataDatabricksJobJobSettingsSettingsWebhookNotificationsOnFailure {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#id DataDatabricksJob#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id: string;
}
export declare function dataDatabricksJobJobSettingsSettingsWebhookNotificationsOnFailureToTerraform(struct?: DataDatabricksJobJobSettingsSettingsWebhookNotificationsOnFailure | cdktf.IResolvable): any;
export declare class DataDatabricksJobJobSettingsSettingsWebhookNotificationsOnFailureOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDatabricksJobJobSettingsSettingsWebhookNotificationsOnFailure | cdktf.IResolvable | undefined;
    set internalValue(value: DataDatabricksJobJobSettingsSettingsWebhookNotificationsOnFailure | cdktf.IResolvable | undefined);
    private _id?;
    get id(): string;
    set id(value: string);
    get idInput(): string | undefined;
}
export declare class DataDatabricksJobJobSettingsSettingsWebhookNotificationsOnFailureList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DataDatabricksJobJobSettingsSettingsWebhookNotificationsOnFailure[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDatabricksJobJobSettingsSettingsWebhookNotificationsOnFailureOutputReference;
}
export interface DataDatabricksJobJobSettingsSettingsWebhookNotificationsOnStart {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#id DataDatabricksJob#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id: string;
}
export declare function dataDatabricksJobJobSettingsSettingsWebhookNotificationsOnStartToTerraform(struct?: DataDatabricksJobJobSettingsSettingsWebhookNotificationsOnStart | cdktf.IResolvable): any;
export declare class DataDatabricksJobJobSettingsSettingsWebhookNotificationsOnStartOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDatabricksJobJobSettingsSettingsWebhookNotificationsOnStart | cdktf.IResolvable | undefined;
    set internalValue(value: DataDatabricksJobJobSettingsSettingsWebhookNotificationsOnStart | cdktf.IResolvable | undefined);
    private _id?;
    get id(): string;
    set id(value: string);
    get idInput(): string | undefined;
}
export declare class DataDatabricksJobJobSettingsSettingsWebhookNotificationsOnStartList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DataDatabricksJobJobSettingsSettingsWebhookNotificationsOnStart[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDatabricksJobJobSettingsSettingsWebhookNotificationsOnStartOutputReference;
}
export interface DataDatabricksJobJobSettingsSettingsWebhookNotificationsOnSuccess {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#id DataDatabricksJob#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id: string;
}
export declare function dataDatabricksJobJobSettingsSettingsWebhookNotificationsOnSuccessToTerraform(struct?: DataDatabricksJobJobSettingsSettingsWebhookNotificationsOnSuccess | cdktf.IResolvable): any;
export declare class DataDatabricksJobJobSettingsSettingsWebhookNotificationsOnSuccessOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDatabricksJobJobSettingsSettingsWebhookNotificationsOnSuccess | cdktf.IResolvable | undefined;
    set internalValue(value: DataDatabricksJobJobSettingsSettingsWebhookNotificationsOnSuccess | cdktf.IResolvable | undefined);
    private _id?;
    get id(): string;
    set id(value: string);
    get idInput(): string | undefined;
}
export declare class DataDatabricksJobJobSettingsSettingsWebhookNotificationsOnSuccessList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DataDatabricksJobJobSettingsSettingsWebhookNotificationsOnSuccess[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDatabricksJobJobSettingsSettingsWebhookNotificationsOnSuccessOutputReference;
}
export interface DataDatabricksJobJobSettingsSettingsWebhookNotifications {
    /**
    * on_failure block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#on_failure DataDatabricksJob#on_failure}
    */
    readonly onFailure?: DataDatabricksJobJobSettingsSettingsWebhookNotificationsOnFailure[] | cdktf.IResolvable;
    /**
    * on_start block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#on_start DataDatabricksJob#on_start}
    */
    readonly onStart?: DataDatabricksJobJobSettingsSettingsWebhookNotificationsOnStart[] | cdktf.IResolvable;
    /**
    * on_success block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#on_success DataDatabricksJob#on_success}
    */
    readonly onSuccess?: DataDatabricksJobJobSettingsSettingsWebhookNotificationsOnSuccess[] | cdktf.IResolvable;
}
export declare function dataDatabricksJobJobSettingsSettingsWebhookNotificationsToTerraform(struct?: DataDatabricksJobJobSettingsSettingsWebhookNotificationsOutputReference | DataDatabricksJobJobSettingsSettingsWebhookNotifications): any;
export declare class DataDatabricksJobJobSettingsSettingsWebhookNotificationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksJobJobSettingsSettingsWebhookNotifications | undefined;
    set internalValue(value: DataDatabricksJobJobSettingsSettingsWebhookNotifications | undefined);
    private _onFailure;
    get onFailure(): DataDatabricksJobJobSettingsSettingsWebhookNotificationsOnFailureList;
    putOnFailure(value: DataDatabricksJobJobSettingsSettingsWebhookNotificationsOnFailure[] | cdktf.IResolvable): void;
    resetOnFailure(): void;
    get onFailureInput(): cdktf.IResolvable | DataDatabricksJobJobSettingsSettingsWebhookNotificationsOnFailure[] | undefined;
    private _onStart;
    get onStart(): DataDatabricksJobJobSettingsSettingsWebhookNotificationsOnStartList;
    putOnStart(value: DataDatabricksJobJobSettingsSettingsWebhookNotificationsOnStart[] | cdktf.IResolvable): void;
    resetOnStart(): void;
    get onStartInput(): cdktf.IResolvable | DataDatabricksJobJobSettingsSettingsWebhookNotificationsOnStart[] | undefined;
    private _onSuccess;
    get onSuccess(): DataDatabricksJobJobSettingsSettingsWebhookNotificationsOnSuccessList;
    putOnSuccess(value: DataDatabricksJobJobSettingsSettingsWebhookNotificationsOnSuccess[] | cdktf.IResolvable): void;
    resetOnSuccess(): void;
    get onSuccessInput(): cdktf.IResolvable | DataDatabricksJobJobSettingsSettingsWebhookNotificationsOnSuccess[] | undefined;
}
export interface DataDatabricksJobJobSettingsSettings {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#existing_cluster_id DataDatabricksJob#existing_cluster_id}
    */
    readonly existingClusterId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#format DataDatabricksJob#format}
    */
    readonly format?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#max_concurrent_runs DataDatabricksJob#max_concurrent_runs}
    */
    readonly maxConcurrentRuns?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#max_retries DataDatabricksJob#max_retries}
    */
    readonly maxRetries?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#min_retry_interval_millis DataDatabricksJob#min_retry_interval_millis}
    */
    readonly minRetryIntervalMillis?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#name DataDatabricksJob#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#retry_on_timeout DataDatabricksJob#retry_on_timeout}
    */
    readonly retryOnTimeout?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#tags DataDatabricksJob#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#timeout_seconds DataDatabricksJob#timeout_seconds}
    */
    readonly timeoutSeconds?: number;
    /**
    * continuous block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#continuous DataDatabricksJob#continuous}
    */
    readonly continuous?: DataDatabricksJobJobSettingsSettingsContinuous;
    /**
    * dbt_task block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#dbt_task DataDatabricksJob#dbt_task}
    */
    readonly dbtTask?: DataDatabricksJobJobSettingsSettingsDbtTask;
    /**
    * email_notifications block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#email_notifications DataDatabricksJob#email_notifications}
    */
    readonly emailNotifications?: DataDatabricksJobJobSettingsSettingsEmailNotifications;
    /**
    * git_source block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#git_source DataDatabricksJob#git_source}
    */
    readonly gitSource?: DataDatabricksJobJobSettingsSettingsGitSource;
    /**
    * job_cluster block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#job_cluster DataDatabricksJob#job_cluster}
    */
    readonly jobCluster?: DataDatabricksJobJobSettingsSettingsJobCluster[] | cdktf.IResolvable;
    /**
    * library block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#library DataDatabricksJob#library}
    */
    readonly library?: DataDatabricksJobJobSettingsSettingsLibrary[] | cdktf.IResolvable;
    /**
    * new_cluster block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#new_cluster DataDatabricksJob#new_cluster}
    */
    readonly newCluster?: DataDatabricksJobJobSettingsSettingsNewCluster;
    /**
    * notebook_task block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#notebook_task DataDatabricksJob#notebook_task}
    */
    readonly notebookTask?: DataDatabricksJobJobSettingsSettingsNotebookTask;
    /**
    * pipeline_task block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#pipeline_task DataDatabricksJob#pipeline_task}
    */
    readonly pipelineTask?: DataDatabricksJobJobSettingsSettingsPipelineTask;
    /**
    * python_wheel_task block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#python_wheel_task DataDatabricksJob#python_wheel_task}
    */
    readonly pythonWheelTask?: DataDatabricksJobJobSettingsSettingsPythonWheelTask;
    /**
    * queue block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#queue DataDatabricksJob#queue}
    */
    readonly queue?: DataDatabricksJobJobSettingsSettingsQueue;
    /**
    * schedule block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#schedule DataDatabricksJob#schedule}
    */
    readonly schedule?: DataDatabricksJobJobSettingsSettingsSchedule;
    /**
    * spark_jar_task block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#spark_jar_task DataDatabricksJob#spark_jar_task}
    */
    readonly sparkJarTask?: DataDatabricksJobJobSettingsSettingsSparkJarTask;
    /**
    * spark_python_task block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#spark_python_task DataDatabricksJob#spark_python_task}
    */
    readonly sparkPythonTask?: DataDatabricksJobJobSettingsSettingsSparkPythonTask;
    /**
    * spark_submit_task block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#spark_submit_task DataDatabricksJob#spark_submit_task}
    */
    readonly sparkSubmitTask?: DataDatabricksJobJobSettingsSettingsSparkSubmitTask;
    /**
    * task block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#task DataDatabricksJob#task}
    */
    readonly task?: DataDatabricksJobJobSettingsSettingsTask[] | cdktf.IResolvable;
    /**
    * trigger block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#trigger DataDatabricksJob#trigger}
    */
    readonly trigger?: DataDatabricksJobJobSettingsSettingsTrigger;
    /**
    * webhook_notifications block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#webhook_notifications DataDatabricksJob#webhook_notifications}
    */
    readonly webhookNotifications?: DataDatabricksJobJobSettingsSettingsWebhookNotifications;
}
export declare function dataDatabricksJobJobSettingsSettingsToTerraform(struct?: DataDatabricksJobJobSettingsSettingsOutputReference | DataDatabricksJobJobSettingsSettings): any;
export declare class DataDatabricksJobJobSettingsSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksJobJobSettingsSettings | undefined;
    set internalValue(value: DataDatabricksJobJobSettingsSettings | undefined);
    private _existingClusterId?;
    get existingClusterId(): string;
    set existingClusterId(value: string);
    resetExistingClusterId(): void;
    get existingClusterIdInput(): string | undefined;
    private _format?;
    get format(): string;
    set format(value: string);
    resetFormat(): void;
    get formatInput(): string | undefined;
    private _maxConcurrentRuns?;
    get maxConcurrentRuns(): number;
    set maxConcurrentRuns(value: number);
    resetMaxConcurrentRuns(): void;
    get maxConcurrentRunsInput(): number | undefined;
    private _maxRetries?;
    get maxRetries(): number;
    set maxRetries(value: number);
    resetMaxRetries(): void;
    get maxRetriesInput(): number | undefined;
    private _minRetryIntervalMillis?;
    get minRetryIntervalMillis(): number;
    set minRetryIntervalMillis(value: number);
    resetMinRetryIntervalMillis(): void;
    get minRetryIntervalMillisInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _retryOnTimeout?;
    get retryOnTimeout(): boolean | cdktf.IResolvable;
    set retryOnTimeout(value: boolean | cdktf.IResolvable);
    resetRetryOnTimeout(): void;
    get retryOnTimeoutInput(): boolean | cdktf.IResolvable | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _timeoutSeconds?;
    get timeoutSeconds(): number;
    set timeoutSeconds(value: number);
    resetTimeoutSeconds(): void;
    get timeoutSecondsInput(): number | undefined;
    private _continuous;
    get continuous(): DataDatabricksJobJobSettingsSettingsContinuousOutputReference;
    putContinuous(value: DataDatabricksJobJobSettingsSettingsContinuous): void;
    resetContinuous(): void;
    get continuousInput(): DataDatabricksJobJobSettingsSettingsContinuous | undefined;
    private _dbtTask;
    get dbtTask(): DataDatabricksJobJobSettingsSettingsDbtTaskOutputReference;
    putDbtTask(value: DataDatabricksJobJobSettingsSettingsDbtTask): void;
    resetDbtTask(): void;
    get dbtTaskInput(): DataDatabricksJobJobSettingsSettingsDbtTask | undefined;
    private _emailNotifications;
    get emailNotifications(): DataDatabricksJobJobSettingsSettingsEmailNotificationsOutputReference;
    putEmailNotifications(value: DataDatabricksJobJobSettingsSettingsEmailNotifications): void;
    resetEmailNotifications(): void;
    get emailNotificationsInput(): DataDatabricksJobJobSettingsSettingsEmailNotifications | undefined;
    private _gitSource;
    get gitSource(): DataDatabricksJobJobSettingsSettingsGitSourceOutputReference;
    putGitSource(value: DataDatabricksJobJobSettingsSettingsGitSource): void;
    resetGitSource(): void;
    get gitSourceInput(): DataDatabricksJobJobSettingsSettingsGitSource | undefined;
    private _jobCluster;
    get jobCluster(): DataDatabricksJobJobSettingsSettingsJobClusterList;
    putJobCluster(value: DataDatabricksJobJobSettingsSettingsJobCluster[] | cdktf.IResolvable): void;
    resetJobCluster(): void;
    get jobClusterInput(): cdktf.IResolvable | DataDatabricksJobJobSettingsSettingsJobCluster[] | undefined;
    private _library;
    get library(): DataDatabricksJobJobSettingsSettingsLibraryList;
    putLibrary(value: DataDatabricksJobJobSettingsSettingsLibrary[] | cdktf.IResolvable): void;
    resetLibrary(): void;
    get libraryInput(): cdktf.IResolvable | DataDatabricksJobJobSettingsSettingsLibrary[] | undefined;
    private _newCluster;
    get newCluster(): DataDatabricksJobJobSettingsSettingsNewClusterOutputReference;
    putNewCluster(value: DataDatabricksJobJobSettingsSettingsNewCluster): void;
    resetNewCluster(): void;
    get newClusterInput(): DataDatabricksJobJobSettingsSettingsNewCluster | undefined;
    private _notebookTask;
    get notebookTask(): DataDatabricksJobJobSettingsSettingsNotebookTaskOutputReference;
    putNotebookTask(value: DataDatabricksJobJobSettingsSettingsNotebookTask): void;
    resetNotebookTask(): void;
    get notebookTaskInput(): DataDatabricksJobJobSettingsSettingsNotebookTask | undefined;
    private _pipelineTask;
    get pipelineTask(): DataDatabricksJobJobSettingsSettingsPipelineTaskOutputReference;
    putPipelineTask(value: DataDatabricksJobJobSettingsSettingsPipelineTask): void;
    resetPipelineTask(): void;
    get pipelineTaskInput(): DataDatabricksJobJobSettingsSettingsPipelineTask | undefined;
    private _pythonWheelTask;
    get pythonWheelTask(): DataDatabricksJobJobSettingsSettingsPythonWheelTaskOutputReference;
    putPythonWheelTask(value: DataDatabricksJobJobSettingsSettingsPythonWheelTask): void;
    resetPythonWheelTask(): void;
    get pythonWheelTaskInput(): DataDatabricksJobJobSettingsSettingsPythonWheelTask | undefined;
    private _queue;
    get queue(): DataDatabricksJobJobSettingsSettingsQueueOutputReference;
    putQueue(value: DataDatabricksJobJobSettingsSettingsQueue): void;
    resetQueue(): void;
    get queueInput(): DataDatabricksJobJobSettingsSettingsQueue | undefined;
    private _schedule;
    get schedule(): DataDatabricksJobJobSettingsSettingsScheduleOutputReference;
    putSchedule(value: DataDatabricksJobJobSettingsSettingsSchedule): void;
    resetSchedule(): void;
    get scheduleInput(): DataDatabricksJobJobSettingsSettingsSchedule | undefined;
    private _sparkJarTask;
    get sparkJarTask(): DataDatabricksJobJobSettingsSettingsSparkJarTaskOutputReference;
    putSparkJarTask(value: DataDatabricksJobJobSettingsSettingsSparkJarTask): void;
    resetSparkJarTask(): void;
    get sparkJarTaskInput(): DataDatabricksJobJobSettingsSettingsSparkJarTask | undefined;
    private _sparkPythonTask;
    get sparkPythonTask(): DataDatabricksJobJobSettingsSettingsSparkPythonTaskOutputReference;
    putSparkPythonTask(value: DataDatabricksJobJobSettingsSettingsSparkPythonTask): void;
    resetSparkPythonTask(): void;
    get sparkPythonTaskInput(): DataDatabricksJobJobSettingsSettingsSparkPythonTask | undefined;
    private _sparkSubmitTask;
    get sparkSubmitTask(): DataDatabricksJobJobSettingsSettingsSparkSubmitTaskOutputReference;
    putSparkSubmitTask(value: DataDatabricksJobJobSettingsSettingsSparkSubmitTask): void;
    resetSparkSubmitTask(): void;
    get sparkSubmitTaskInput(): DataDatabricksJobJobSettingsSettingsSparkSubmitTask | undefined;
    private _task;
    get task(): DataDatabricksJobJobSettingsSettingsTaskList;
    putTask(value: DataDatabricksJobJobSettingsSettingsTask[] | cdktf.IResolvable): void;
    resetTask(): void;
    get taskInput(): cdktf.IResolvable | DataDatabricksJobJobSettingsSettingsTask[] | undefined;
    private _trigger;
    get trigger(): DataDatabricksJobJobSettingsSettingsTriggerOutputReference;
    putTrigger(value: DataDatabricksJobJobSettingsSettingsTrigger): void;
    resetTrigger(): void;
    get triggerInput(): DataDatabricksJobJobSettingsSettingsTrigger | undefined;
    private _webhookNotifications;
    get webhookNotifications(): DataDatabricksJobJobSettingsSettingsWebhookNotificationsOutputReference;
    putWebhookNotifications(value: DataDatabricksJobJobSettingsSettingsWebhookNotifications): void;
    resetWebhookNotifications(): void;
    get webhookNotificationsInput(): DataDatabricksJobJobSettingsSettingsWebhookNotifications | undefined;
}
export interface DataDatabricksJobJobSettings {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#created_time DataDatabricksJob#created_time}
    */
    readonly createdTime?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#creator_user_name DataDatabricksJob#creator_user_name}
    */
    readonly creatorUserName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#job_id DataDatabricksJob#job_id}
    */
    readonly jobId?: number;
    /**
    * settings block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/job#settings DataDatabricksJob#settings}
    */
    readonly settings?: DataDatabricksJobJobSettingsSettings;
}
export declare function dataDatabricksJobJobSettingsToTerraform(struct?: DataDatabricksJobJobSettingsOutputReference | DataDatabricksJobJobSettings): any;
export declare class DataDatabricksJobJobSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksJobJobSettings | undefined;
    set internalValue(value: DataDatabricksJobJobSettings | undefined);
    private _createdTime?;
    get createdTime(): number;
    set createdTime(value: number);
    resetCreatedTime(): void;
    get createdTimeInput(): number | undefined;
    private _creatorUserName?;
    get creatorUserName(): string;
    set creatorUserName(value: string);
    resetCreatorUserName(): void;
    get creatorUserNameInput(): string | undefined;
    private _jobId?;
    get jobId(): number;
    set jobId(value: number);
    resetJobId(): void;
    get jobIdInput(): number | undefined;
    private _settings;
    get settings(): DataDatabricksJobJobSettingsSettingsOutputReference;
    putSettings(value: DataDatabricksJobJobSettingsSettings): void;
    resetSettings(): void;
    get settingsInput(): DataDatabricksJobJobSettingsSettings | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/databricks/d/job databricks_job}
*/
export declare class DataDatabricksJob extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "databricks_job";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/databricks/d/job databricks_job} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataDatabricksJobConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataDatabricksJobConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _jobId?;
    get jobId(): string;
    set jobId(value: string);
    resetJobId(): void;
    get jobIdInput(): string | undefined;
    private _jobName?;
    get jobName(): string;
    set jobName(value: string);
    resetJobName(): void;
    get jobNameInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _jobSettings;
    get jobSettings(): DataDatabricksJobJobSettingsOutputReference;
    putJobSettings(value: DataDatabricksJobJobSettings): void;
    resetJobSettings(): void;
    get jobSettingsInput(): DataDatabricksJobJobSettings | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
