import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataDatabricksMwsCredentialsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/mws_credentials#id DataDatabricksMwsCredentials#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/mws_credentials#ids DataDatabricksMwsCredentials#ids}
    */
    readonly ids?: {
        [key: string]: string;
    };
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/databricks/d/mws_credentials databricks_mws_credentials}
*/
export declare class DataDatabricksMwsCredentials extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "databricks_mws_credentials";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/databricks/d/mws_credentials databricks_mws_credentials} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataDatabricksMwsCredentialsConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataDatabricksMwsCredentialsConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _ids?;
    get ids(): {
        [key: string]: string;
    };
    set ids(value: {
        [key: string]: string;
    });
    resetIds(): void;
    get idsInput(): {
        [key: string]: string;
    } | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
