import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataDatabricksMwsWorkspacesConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/mws_workspaces#id DataDatabricksMwsWorkspaces#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/mws_workspaces#ids DataDatabricksMwsWorkspaces#ids}
    */
    readonly ids?: {
        [key: string]: number;
    };
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/databricks/d/mws_workspaces databricks_mws_workspaces}
*/
export declare class DataDatabricksMwsWorkspaces extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "databricks_mws_workspaces";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/databricks/d/mws_workspaces databricks_mws_workspaces} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataDatabricksMwsWorkspacesConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataDatabricksMwsWorkspacesConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _ids?;
    get ids(): {
        [key: string]: number;
    };
    set ids(value: {
        [key: string]: number;
    });
    resetIds(): void;
    get idsInput(): {
        [key: string]: number;
    } | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
