import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataDatabricksNotebookPathsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/notebook_paths#id DataDatabricksNotebookPaths#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/notebook_paths#path DataDatabricksNotebookPaths#path}
    */
    readonly path: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/notebook_paths#recursive DataDatabricksNotebookPaths#recursive}
    */
    readonly recursive: boolean | cdktf.IResolvable;
}
export interface DataDatabricksNotebookPathsNotebookPathList {
}
export declare function dataDatabricksNotebookPathsNotebookPathListToTerraform(struct?: DataDatabricksNotebookPathsNotebookPathList): any;
export declare class DataDatabricksNotebookPathsNotebookPathListOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDatabricksNotebookPathsNotebookPathList | undefined;
    set internalValue(value: DataDatabricksNotebookPathsNotebookPathList | undefined);
    get language(): string;
    get path(): string;
}
export declare class DataDatabricksNotebookPathsNotebookPathListList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDatabricksNotebookPathsNotebookPathListOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/databricks/d/notebook_paths databricks_notebook_paths}
*/
export declare class DataDatabricksNotebookPaths extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "databricks_notebook_paths";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/databricks/d/notebook_paths databricks_notebook_paths} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataDatabricksNotebookPathsConfig
    */
    constructor(scope: Construct, id: string, config: DataDatabricksNotebookPathsConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _notebookPathList;
    get notebookPathList(): DataDatabricksNotebookPathsNotebookPathListList;
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
    private _recursive?;
    get recursive(): boolean | cdktf.IResolvable;
    set recursive(value: boolean | cdktf.IResolvable);
    get recursiveInput(): boolean | cdktf.IResolvable | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
