import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataDatabricksShareConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/share#created_at DataDatabricksShare#created_at}
    */
    readonly createdAt?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/share#created_by DataDatabricksShare#created_by}
    */
    readonly createdBy?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/share#id DataDatabricksShare#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/share#name DataDatabricksShare#name}
    */
    readonly name?: string;
    /**
    * object block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/share#object DataDatabricksShare#object}
    */
    readonly object?: DataDatabricksShareObject[] | cdktf.IResolvable;
}
export interface DataDatabricksShareObjectPartitionValue {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/share#name DataDatabricksShare#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/share#op DataDatabricksShare#op}
    */
    readonly op: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/share#recipient_property_key DataDatabricksShare#recipient_property_key}
    */
    readonly recipientPropertyKey?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/share#value DataDatabricksShare#value}
    */
    readonly value?: string;
}
export declare function dataDatabricksShareObjectPartitionValueToTerraform(struct?: DataDatabricksShareObjectPartitionValue | cdktf.IResolvable): any;
export declare class DataDatabricksShareObjectPartitionValueOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDatabricksShareObjectPartitionValue | cdktf.IResolvable | undefined;
    set internalValue(value: DataDatabricksShareObjectPartitionValue | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _op?;
    get op(): string;
    set op(value: string);
    get opInput(): string | undefined;
    private _recipientPropertyKey?;
    get recipientPropertyKey(): string;
    set recipientPropertyKey(value: string);
    resetRecipientPropertyKey(): void;
    get recipientPropertyKeyInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class DataDatabricksShareObjectPartitionValueList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DataDatabricksShareObjectPartitionValue[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDatabricksShareObjectPartitionValueOutputReference;
}
export interface DataDatabricksShareObjectPartition {
    /**
    * value block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/share#value DataDatabricksShare#value}
    */
    readonly value: DataDatabricksShareObjectPartitionValue[] | cdktf.IResolvable;
}
export declare function dataDatabricksShareObjectPartitionToTerraform(struct?: DataDatabricksShareObjectPartition | cdktf.IResolvable): any;
export declare class DataDatabricksShareObjectPartitionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDatabricksShareObjectPartition | cdktf.IResolvable | undefined;
    set internalValue(value: DataDatabricksShareObjectPartition | cdktf.IResolvable | undefined);
    private _value;
    get value(): DataDatabricksShareObjectPartitionValueList;
    putValue(value: DataDatabricksShareObjectPartitionValue[] | cdktf.IResolvable): void;
    get valueInput(): cdktf.IResolvable | DataDatabricksShareObjectPartitionValue[] | undefined;
}
export declare class DataDatabricksShareObjectPartitionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DataDatabricksShareObjectPartition[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDatabricksShareObjectPartitionOutputReference;
}
export interface DataDatabricksShareObject {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/share#added_at DataDatabricksShare#added_at}
    */
    readonly addedAt?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/share#added_by DataDatabricksShare#added_by}
    */
    readonly addedBy?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/share#cdf_enabled DataDatabricksShare#cdf_enabled}
    */
    readonly cdfEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/share#comment DataDatabricksShare#comment}
    */
    readonly comment?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/share#data_object_type DataDatabricksShare#data_object_type}
    */
    readonly dataObjectType: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/share#history_data_sharing_status DataDatabricksShare#history_data_sharing_status}
    */
    readonly historyDataSharingStatus?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/share#name DataDatabricksShare#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/share#shared_as DataDatabricksShare#shared_as}
    */
    readonly sharedAs?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/share#start_version DataDatabricksShare#start_version}
    */
    readonly startVersion?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/share#status DataDatabricksShare#status}
    */
    readonly status?: string;
    /**
    * partition block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/share#partition DataDatabricksShare#partition}
    */
    readonly partition?: DataDatabricksShareObjectPartition[] | cdktf.IResolvable;
}
export declare function dataDatabricksShareObjectToTerraform(struct?: DataDatabricksShareObject | cdktf.IResolvable): any;
export declare class DataDatabricksShareObjectOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDatabricksShareObject | cdktf.IResolvable | undefined;
    set internalValue(value: DataDatabricksShareObject | cdktf.IResolvable | undefined);
    private _addedAt?;
    get addedAt(): number;
    set addedAt(value: number);
    resetAddedAt(): void;
    get addedAtInput(): number | undefined;
    private _addedBy?;
    get addedBy(): string;
    set addedBy(value: string);
    resetAddedBy(): void;
    get addedByInput(): string | undefined;
    private _cdfEnabled?;
    get cdfEnabled(): boolean | cdktf.IResolvable;
    set cdfEnabled(value: boolean | cdktf.IResolvable);
    resetCdfEnabled(): void;
    get cdfEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _comment?;
    get comment(): string;
    set comment(value: string);
    resetComment(): void;
    get commentInput(): string | undefined;
    private _dataObjectType?;
    get dataObjectType(): string;
    set dataObjectType(value: string);
    get dataObjectTypeInput(): string | undefined;
    private _historyDataSharingStatus?;
    get historyDataSharingStatus(): string;
    set historyDataSharingStatus(value: string);
    resetHistoryDataSharingStatus(): void;
    get historyDataSharingStatusInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _sharedAs?;
    get sharedAs(): string;
    set sharedAs(value: string);
    resetSharedAs(): void;
    get sharedAsInput(): string | undefined;
    private _startVersion?;
    get startVersion(): number;
    set startVersion(value: number);
    resetStartVersion(): void;
    get startVersionInput(): number | undefined;
    private _status?;
    get status(): string;
    set status(value: string);
    resetStatus(): void;
    get statusInput(): string | undefined;
    private _partition;
    get partition(): DataDatabricksShareObjectPartitionList;
    putPartition(value: DataDatabricksShareObjectPartition[] | cdktf.IResolvable): void;
    resetPartition(): void;
    get partitionInput(): cdktf.IResolvable | DataDatabricksShareObjectPartition[] | undefined;
}
export declare class DataDatabricksShareObjectList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DataDatabricksShareObject[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDatabricksShareObjectOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/databricks/d/share databricks_share}
*/
export declare class DataDatabricksShare extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "databricks_share";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/databricks/d/share databricks_share} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataDatabricksShareConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataDatabricksShareConfig);
    private _createdAt?;
    get createdAt(): number;
    set createdAt(value: number);
    resetCreatedAt(): void;
    get createdAtInput(): number | undefined;
    private _createdBy?;
    get createdBy(): string;
    set createdBy(value: string);
    resetCreatedBy(): void;
    get createdByInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _object;
    get object(): DataDatabricksShareObjectList;
    putObject(value: DataDatabricksShareObject[] | cdktf.IResolvable): void;
    resetObject(): void;
    get objectInput(): cdktf.IResolvable | DataDatabricksShareObject[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
