import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataDatabricksSharesConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/shares#id DataDatabricksShares#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/shares#shares DataDatabricksShares#shares}
    */
    readonly shares?: string[];
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/databricks/d/shares databricks_shares}
*/
export declare class DataDatabricksShares extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "databricks_shares";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/databricks/d/shares databricks_shares} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataDatabricksSharesConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataDatabricksSharesConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _shares?;
    get shares(): string[];
    set shares(value: string[]);
    resetShares(): void;
    get sharesInput(): string[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
