import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataDatabricksSparkVersionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/spark_version#beta DataDatabricksSparkVersion#beta}
    */
    readonly beta?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/spark_version#genomics DataDatabricksSparkVersion#genomics}
    */
    readonly genomics?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/spark_version#gpu DataDatabricksSparkVersion#gpu}
    */
    readonly gpu?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/spark_version#graviton DataDatabricksSparkVersion#graviton}
    */
    readonly graviton?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/spark_version#id DataDatabricksSparkVersion#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/spark_version#latest DataDatabricksSparkVersion#latest}
    */
    readonly latest?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/spark_version#long_term_support DataDatabricksSparkVersion#long_term_support}
    */
    readonly longTermSupport?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/spark_version#ml DataDatabricksSparkVersion#ml}
    */
    readonly ml?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/spark_version#photon DataDatabricksSparkVersion#photon}
    */
    readonly photon?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/spark_version#scala DataDatabricksSparkVersion#scala}
    */
    readonly scala?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/spark_version#spark_version DataDatabricksSparkVersion#spark_version}
    */
    readonly sparkVersion?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/databricks/d/spark_version databricks_spark_version}
*/
export declare class DataDatabricksSparkVersion extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "databricks_spark_version";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/databricks/d/spark_version databricks_spark_version} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataDatabricksSparkVersionConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataDatabricksSparkVersionConfig);
    private _beta?;
    get beta(): boolean | cdktf.IResolvable;
    set beta(value: boolean | cdktf.IResolvable);
    resetBeta(): void;
    get betaInput(): boolean | cdktf.IResolvable | undefined;
    private _genomics?;
    get genomics(): boolean | cdktf.IResolvable;
    set genomics(value: boolean | cdktf.IResolvable);
    resetGenomics(): void;
    get genomicsInput(): boolean | cdktf.IResolvable | undefined;
    private _gpu?;
    get gpu(): boolean | cdktf.IResolvable;
    set gpu(value: boolean | cdktf.IResolvable);
    resetGpu(): void;
    get gpuInput(): boolean | cdktf.IResolvable | undefined;
    private _graviton?;
    get graviton(): boolean | cdktf.IResolvable;
    set graviton(value: boolean | cdktf.IResolvable);
    resetGraviton(): void;
    get gravitonInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _latest?;
    get latest(): boolean | cdktf.IResolvable;
    set latest(value: boolean | cdktf.IResolvable);
    resetLatest(): void;
    get latestInput(): boolean | cdktf.IResolvable | undefined;
    private _longTermSupport?;
    get longTermSupport(): boolean | cdktf.IResolvable;
    set longTermSupport(value: boolean | cdktf.IResolvable);
    resetLongTermSupport(): void;
    get longTermSupportInput(): boolean | cdktf.IResolvable | undefined;
    private _ml?;
    get ml(): boolean | cdktf.IResolvable;
    set ml(value: boolean | cdktf.IResolvable);
    resetMl(): void;
    get mlInput(): boolean | cdktf.IResolvable | undefined;
    private _photon?;
    get photon(): boolean | cdktf.IResolvable;
    set photon(value: boolean | cdktf.IResolvable);
    resetPhoton(): void;
    get photonInput(): boolean | cdktf.IResolvable | undefined;
    private _scala?;
    get scala(): string;
    set scala(value: string);
    resetScala(): void;
    get scalaInput(): string | undefined;
    private _sparkVersion?;
    get sparkVersion(): string;
    set sparkVersion(value: string);
    resetSparkVersion(): void;
    get sparkVersionInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
