import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataDatabricksSqlWarehouseConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/sql_warehouse#auto_stop_mins DataDatabricksSqlWarehouse#auto_stop_mins}
    */
    readonly autoStopMins?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/sql_warehouse#cluster_size DataDatabricksSqlWarehouse#cluster_size}
    */
    readonly clusterSize?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/sql_warehouse#data_source_id DataDatabricksSqlWarehouse#data_source_id}
    */
    readonly dataSourceId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/sql_warehouse#enable_photon DataDatabricksSqlWarehouse#enable_photon}
    */
    readonly enablePhoton?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/sql_warehouse#enable_serverless_compute DataDatabricksSqlWarehouse#enable_serverless_compute}
    */
    readonly enableServerlessCompute?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/sql_warehouse#id DataDatabricksSqlWarehouse#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/sql_warehouse#instance_profile_arn DataDatabricksSqlWarehouse#instance_profile_arn}
    */
    readonly instanceProfileArn?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/sql_warehouse#jdbc_url DataDatabricksSqlWarehouse#jdbc_url}
    */
    readonly jdbcUrl?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/sql_warehouse#max_num_clusters DataDatabricksSqlWarehouse#max_num_clusters}
    */
    readonly maxNumClusters?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/sql_warehouse#min_num_clusters DataDatabricksSqlWarehouse#min_num_clusters}
    */
    readonly minNumClusters?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/sql_warehouse#name DataDatabricksSqlWarehouse#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/sql_warehouse#num_clusters DataDatabricksSqlWarehouse#num_clusters}
    */
    readonly numClusters?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/sql_warehouse#spot_instance_policy DataDatabricksSqlWarehouse#spot_instance_policy}
    */
    readonly spotInstancePolicy?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/sql_warehouse#state DataDatabricksSqlWarehouse#state}
    */
    readonly state?: string;
    /**
    * channel block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/sql_warehouse#channel DataDatabricksSqlWarehouse#channel}
    */
    readonly channel?: DataDatabricksSqlWarehouseChannel;
    /**
    * odbc_params block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/sql_warehouse#odbc_params DataDatabricksSqlWarehouse#odbc_params}
    */
    readonly odbcParams?: DataDatabricksSqlWarehouseOdbcParams;
    /**
    * tags block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/sql_warehouse#tags DataDatabricksSqlWarehouse#tags}
    */
    readonly tags?: DataDatabricksSqlWarehouseTags;
}
export interface DataDatabricksSqlWarehouseChannel {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/sql_warehouse#name DataDatabricksSqlWarehouse#name}
    */
    readonly name?: string;
}
export declare function dataDatabricksSqlWarehouseChannelToTerraform(struct?: DataDatabricksSqlWarehouseChannelOutputReference | DataDatabricksSqlWarehouseChannel): any;
export declare class DataDatabricksSqlWarehouseChannelOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksSqlWarehouseChannel | undefined;
    set internalValue(value: DataDatabricksSqlWarehouseChannel | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export interface DataDatabricksSqlWarehouseOdbcParams {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/sql_warehouse#host DataDatabricksSqlWarehouse#host}
    */
    readonly host?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/sql_warehouse#hostname DataDatabricksSqlWarehouse#hostname}
    */
    readonly hostname?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/sql_warehouse#path DataDatabricksSqlWarehouse#path}
    */
    readonly path: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/sql_warehouse#port DataDatabricksSqlWarehouse#port}
    */
    readonly port: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/sql_warehouse#protocol DataDatabricksSqlWarehouse#protocol}
    */
    readonly protocol: string;
}
export declare function dataDatabricksSqlWarehouseOdbcParamsToTerraform(struct?: DataDatabricksSqlWarehouseOdbcParamsOutputReference | DataDatabricksSqlWarehouseOdbcParams): any;
export declare class DataDatabricksSqlWarehouseOdbcParamsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksSqlWarehouseOdbcParams | undefined;
    set internalValue(value: DataDatabricksSqlWarehouseOdbcParams | undefined);
    private _host?;
    get host(): string;
    set host(value: string);
    resetHost(): void;
    get hostInput(): string | undefined;
    private _hostname?;
    get hostname(): string;
    set hostname(value: string);
    resetHostname(): void;
    get hostnameInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
    private _port?;
    get port(): number;
    set port(value: number);
    get portInput(): number | undefined;
    private _protocol?;
    get protocol(): string;
    set protocol(value: string);
    get protocolInput(): string | undefined;
}
export interface DataDatabricksSqlWarehouseTagsCustomTags {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/sql_warehouse#key DataDatabricksSqlWarehouse#key}
    */
    readonly key: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/sql_warehouse#value DataDatabricksSqlWarehouse#value}
    */
    readonly value: string;
}
export declare function dataDatabricksSqlWarehouseTagsCustomTagsToTerraform(struct?: DataDatabricksSqlWarehouseTagsCustomTags | cdktf.IResolvable): any;
export declare class DataDatabricksSqlWarehouseTagsCustomTagsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDatabricksSqlWarehouseTagsCustomTags | cdktf.IResolvable | undefined;
    set internalValue(value: DataDatabricksSqlWarehouseTagsCustomTags | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class DataDatabricksSqlWarehouseTagsCustomTagsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DataDatabricksSqlWarehouseTagsCustomTags[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDatabricksSqlWarehouseTagsCustomTagsOutputReference;
}
export interface DataDatabricksSqlWarehouseTags {
    /**
    * custom_tags block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/sql_warehouse#custom_tags DataDatabricksSqlWarehouse#custom_tags}
    */
    readonly customTags: DataDatabricksSqlWarehouseTagsCustomTags[] | cdktf.IResolvable;
}
export declare function dataDatabricksSqlWarehouseTagsToTerraform(struct?: DataDatabricksSqlWarehouseTagsOutputReference | DataDatabricksSqlWarehouseTags): any;
export declare class DataDatabricksSqlWarehouseTagsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataDatabricksSqlWarehouseTags | undefined;
    set internalValue(value: DataDatabricksSqlWarehouseTags | undefined);
    private _customTags;
    get customTags(): DataDatabricksSqlWarehouseTagsCustomTagsList;
    putCustomTags(value: DataDatabricksSqlWarehouseTagsCustomTags[] | cdktf.IResolvable): void;
    get customTagsInput(): cdktf.IResolvable | DataDatabricksSqlWarehouseTagsCustomTags[] | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/databricks/d/sql_warehouse databricks_sql_warehouse}
*/
export declare class DataDatabricksSqlWarehouse extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "databricks_sql_warehouse";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/databricks/d/sql_warehouse databricks_sql_warehouse} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataDatabricksSqlWarehouseConfig
    */
    constructor(scope: Construct, id: string, config: DataDatabricksSqlWarehouseConfig);
    private _autoStopMins?;
    get autoStopMins(): number;
    set autoStopMins(value: number);
    resetAutoStopMins(): void;
    get autoStopMinsInput(): number | undefined;
    private _clusterSize?;
    get clusterSize(): string;
    set clusterSize(value: string);
    resetClusterSize(): void;
    get clusterSizeInput(): string | undefined;
    private _dataSourceId?;
    get dataSourceId(): string;
    set dataSourceId(value: string);
    resetDataSourceId(): void;
    get dataSourceIdInput(): string | undefined;
    private _enablePhoton?;
    get enablePhoton(): boolean | cdktf.IResolvable;
    set enablePhoton(value: boolean | cdktf.IResolvable);
    resetEnablePhoton(): void;
    get enablePhotonInput(): boolean | cdktf.IResolvable | undefined;
    private _enableServerlessCompute?;
    get enableServerlessCompute(): boolean | cdktf.IResolvable;
    set enableServerlessCompute(value: boolean | cdktf.IResolvable);
    resetEnableServerlessCompute(): void;
    get enableServerlessComputeInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    get idInput(): string | undefined;
    private _instanceProfileArn?;
    get instanceProfileArn(): string;
    set instanceProfileArn(value: string);
    resetInstanceProfileArn(): void;
    get instanceProfileArnInput(): string | undefined;
    private _jdbcUrl?;
    get jdbcUrl(): string;
    set jdbcUrl(value: string);
    resetJdbcUrl(): void;
    get jdbcUrlInput(): string | undefined;
    private _maxNumClusters?;
    get maxNumClusters(): number;
    set maxNumClusters(value: number);
    resetMaxNumClusters(): void;
    get maxNumClustersInput(): number | undefined;
    private _minNumClusters?;
    get minNumClusters(): number;
    set minNumClusters(value: number);
    resetMinNumClusters(): void;
    get minNumClustersInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _numClusters?;
    get numClusters(): number;
    set numClusters(value: number);
    resetNumClusters(): void;
    get numClustersInput(): number | undefined;
    private _spotInstancePolicy?;
    get spotInstancePolicy(): string;
    set spotInstancePolicy(value: string);
    resetSpotInstancePolicy(): void;
    get spotInstancePolicyInput(): string | undefined;
    private _state?;
    get state(): string;
    set state(value: string);
    resetState(): void;
    get stateInput(): string | undefined;
    private _channel;
    get channel(): DataDatabricksSqlWarehouseChannelOutputReference;
    putChannel(value: DataDatabricksSqlWarehouseChannel): void;
    resetChannel(): void;
    get channelInput(): DataDatabricksSqlWarehouseChannel | undefined;
    private _odbcParams;
    get odbcParams(): DataDatabricksSqlWarehouseOdbcParamsOutputReference;
    putOdbcParams(value: DataDatabricksSqlWarehouseOdbcParams): void;
    resetOdbcParams(): void;
    get odbcParamsInput(): DataDatabricksSqlWarehouseOdbcParams | undefined;
    private _tags;
    get tags(): DataDatabricksSqlWarehouseTagsOutputReference;
    putTags(value: DataDatabricksSqlWarehouseTags): void;
    resetTags(): void;
    get tagsInput(): DataDatabricksSqlWarehouseTags | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
