import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DbfsFileConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/dbfs_file#content_base64 DbfsFile#content_base64}
    */
    readonly contentBase64?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/dbfs_file#id DbfsFile#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/dbfs_file#md5 DbfsFile#md5}
    */
    readonly md5?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/dbfs_file#path DbfsFile#path}
    */
    readonly path: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/dbfs_file#source DbfsFile#source}
    */
    readonly source?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/databricks/r/dbfs_file databricks_dbfs_file}
*/
export declare class DbfsFile extends cdktf.TerraformResource {
    static readonly tfResourceType = "databricks_dbfs_file";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/databricks/r/dbfs_file databricks_dbfs_file} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DbfsFileConfig
    */
    constructor(scope: Construct, id: string, config: DbfsFileConfig);
    private _contentBase64?;
    get contentBase64(): string;
    set contentBase64(value: string);
    resetContentBase64(): void;
    get contentBase64Input(): string | undefined;
    get dbfsPath(): string;
    get fileSize(): number;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _md5?;
    get md5(): string;
    set md5(value: string);
    resetMd5(): void;
    get md5Input(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
    private _source?;
    get source(): string;
    set source(value: string);
    resetSource(): void;
    get sourceInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
