import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DirectoryConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/directory#delete_recursive Directory#delete_recursive}
    */
    readonly deleteRecursive?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/directory#id Directory#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/directory#object_id Directory#object_id}
    */
    readonly objectId?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/directory#path Directory#path}
    */
    readonly path: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/databricks/r/directory databricks_directory}
*/
export declare class Directory extends cdktf.TerraformResource {
    static readonly tfResourceType = "databricks_directory";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/databricks/r/directory databricks_directory} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DirectoryConfig
    */
    constructor(scope: Construct, id: string, config: DirectoryConfig);
    private _deleteRecursive?;
    get deleteRecursive(): boolean | cdktf.IResolvable;
    set deleteRecursive(value: boolean | cdktf.IResolvable);
    resetDeleteRecursive(): void;
    get deleteRecursiveInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _objectId?;
    get objectId(): number;
    set objectId(value: number);
    resetObjectId(): void;
    get objectIdInput(): number | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
