import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ExternalLocationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/external_location#comment ExternalLocation#comment}
    */
    readonly comment?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/external_location#credential_name ExternalLocation#credential_name}
    */
    readonly credentialName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/external_location#id ExternalLocation#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/external_location#metastore_id ExternalLocation#metastore_id}
    */
    readonly metastoreId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/external_location#name ExternalLocation#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/external_location#owner ExternalLocation#owner}
    */
    readonly owner?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/external_location#skip_validation ExternalLocation#skip_validation}
    */
    readonly skipValidation?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/external_location#url ExternalLocation#url}
    */
    readonly url: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/databricks/r/external_location databricks_external_location}
*/
export declare class ExternalLocation extends cdktf.TerraformResource {
    static readonly tfResourceType = "databricks_external_location";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/databricks/r/external_location databricks_external_location} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ExternalLocationConfig
    */
    constructor(scope: Construct, id: string, config: ExternalLocationConfig);
    private _comment?;
    get comment(): string;
    set comment(value: string);
    resetComment(): void;
    get commentInput(): string | undefined;
    private _credentialName?;
    get credentialName(): string;
    set credentialName(value: string);
    get credentialNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _metastoreId?;
    get metastoreId(): string;
    set metastoreId(value: string);
    resetMetastoreId(): void;
    get metastoreIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _owner?;
    get owner(): string;
    set owner(value: string);
    resetOwner(): void;
    get ownerInput(): string | undefined;
    private _skipValidation?;
    get skipValidation(): boolean | cdktf.IResolvable;
    set skipValidation(value: boolean | cdktf.IResolvable);
    resetSkipValidation(): void;
    get skipValidationInput(): boolean | cdktf.IResolvable | undefined;
    private _url?;
    get url(): string;
    set url(value: string);
    get urlInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
