import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GlobalInitScriptConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/global_init_script#content_base64 GlobalInitScript#content_base64}
    */
    readonly contentBase64?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/global_init_script#enabled GlobalInitScript#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/global_init_script#id GlobalInitScript#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/global_init_script#md5 GlobalInitScript#md5}
    */
    readonly md5?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/global_init_script#name GlobalInitScript#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/global_init_script#position GlobalInitScript#position}
    */
    readonly position?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/global_init_script#source GlobalInitScript#source}
    */
    readonly source?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/global_init_script#timeouts GlobalInitScript#timeouts}
    */
    readonly timeouts?: GlobalInitScriptTimeouts;
}
export interface GlobalInitScriptTimeouts {
}
export declare function globalInitScriptTimeoutsToTerraform(struct?: GlobalInitScriptTimeoutsOutputReference | GlobalInitScriptTimeouts | cdktf.IResolvable): any;
export declare class GlobalInitScriptTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GlobalInitScriptTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GlobalInitScriptTimeouts | cdktf.IResolvable | undefined);
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/databricks/r/global_init_script databricks_global_init_script}
*/
export declare class GlobalInitScript extends cdktf.TerraformResource {
    static readonly tfResourceType = "databricks_global_init_script";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/databricks/r/global_init_script databricks_global_init_script} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GlobalInitScriptConfig
    */
    constructor(scope: Construct, id: string, config: GlobalInitScriptConfig);
    private _contentBase64?;
    get contentBase64(): string;
    set contentBase64(value: string);
    resetContentBase64(): void;
    get contentBase64Input(): string | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _md5?;
    get md5(): string;
    set md5(value: string);
    resetMd5(): void;
    get md5Input(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _position?;
    get position(): number;
    set position(value: number);
    resetPosition(): void;
    get positionInput(): number | undefined;
    private _source?;
    get source(): string;
    set source(value: string);
    resetSource(): void;
    get sourceInput(): string | undefined;
    private _timeouts;
    get timeouts(): GlobalInitScriptTimeoutsOutputReference;
    putTimeouts(value: GlobalInitScriptTimeouts): void;
    get timeoutsInput(): cdktf.IResolvable | GlobalInitScriptTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
