import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface InstancePoolConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/instance_pool#custom_tags InstancePool#custom_tags}
    */
    readonly customTags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/instance_pool#enable_elastic_disk InstancePool#enable_elastic_disk}
    */
    readonly enableElasticDisk?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/instance_pool#id InstancePool#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/instance_pool#idle_instance_autotermination_minutes InstancePool#idle_instance_autotermination_minutes}
    */
    readonly idleInstanceAutoterminationMinutes: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/instance_pool#instance_pool_id InstancePool#instance_pool_id}
    */
    readonly instancePoolId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/instance_pool#instance_pool_name InstancePool#instance_pool_name}
    */
    readonly instancePoolName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/instance_pool#max_capacity InstancePool#max_capacity}
    */
    readonly maxCapacity?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/instance_pool#min_idle_instances InstancePool#min_idle_instances}
    */
    readonly minIdleInstances?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/instance_pool#node_type_id InstancePool#node_type_id}
    */
    readonly nodeTypeId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/instance_pool#preloaded_spark_versions InstancePool#preloaded_spark_versions}
    */
    readonly preloadedSparkVersions?: string[];
    /**
    * aws_attributes block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/instance_pool#aws_attributes InstancePool#aws_attributes}
    */
    readonly awsAttributes?: InstancePoolAwsAttributes;
    /**
    * azure_attributes block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/instance_pool#azure_attributes InstancePool#azure_attributes}
    */
    readonly azureAttributes?: InstancePoolAzureAttributes;
    /**
    * disk_spec block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/instance_pool#disk_spec InstancePool#disk_spec}
    */
    readonly diskSpec?: InstancePoolDiskSpec;
    /**
    * gcp_attributes block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/instance_pool#gcp_attributes InstancePool#gcp_attributes}
    */
    readonly gcpAttributes?: InstancePoolGcpAttributes;
    /**
    * instance_pool_fleet_attributes block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/instance_pool#instance_pool_fleet_attributes InstancePool#instance_pool_fleet_attributes}
    */
    readonly instancePoolFleetAttributes?: InstancePoolInstancePoolFleetAttributes;
    /**
    * preloaded_docker_image block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/instance_pool#preloaded_docker_image InstancePool#preloaded_docker_image}
    */
    readonly preloadedDockerImage?: InstancePoolPreloadedDockerImage[] | cdktf.IResolvable;
}
export interface InstancePoolAwsAttributes {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/instance_pool#availability InstancePool#availability}
    */
    readonly availability?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/instance_pool#spot_bid_price_percent InstancePool#spot_bid_price_percent}
    */
    readonly spotBidPricePercent?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/instance_pool#zone_id InstancePool#zone_id}
    */
    readonly zoneId?: string;
}
export declare function instancePoolAwsAttributesToTerraform(struct?: InstancePoolAwsAttributesOutputReference | InstancePoolAwsAttributes): any;
export declare class InstancePoolAwsAttributesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): InstancePoolAwsAttributes | undefined;
    set internalValue(value: InstancePoolAwsAttributes | undefined);
    private _availability?;
    get availability(): string;
    set availability(value: string);
    resetAvailability(): void;
    get availabilityInput(): string | undefined;
    private _spotBidPricePercent?;
    get spotBidPricePercent(): number;
    set spotBidPricePercent(value: number);
    resetSpotBidPricePercent(): void;
    get spotBidPricePercentInput(): number | undefined;
    private _zoneId?;
    get zoneId(): string;
    set zoneId(value: string);
    resetZoneId(): void;
    get zoneIdInput(): string | undefined;
}
export interface InstancePoolAzureAttributes {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/instance_pool#availability InstancePool#availability}
    */
    readonly availability?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/instance_pool#spot_bid_max_price InstancePool#spot_bid_max_price}
    */
    readonly spotBidMaxPrice?: number;
}
export declare function instancePoolAzureAttributesToTerraform(struct?: InstancePoolAzureAttributesOutputReference | InstancePoolAzureAttributes): any;
export declare class InstancePoolAzureAttributesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): InstancePoolAzureAttributes | undefined;
    set internalValue(value: InstancePoolAzureAttributes | undefined);
    private _availability?;
    get availability(): string;
    set availability(value: string);
    resetAvailability(): void;
    get availabilityInput(): string | undefined;
    private _spotBidMaxPrice?;
    get spotBidMaxPrice(): number;
    set spotBidMaxPrice(value: number);
    resetSpotBidMaxPrice(): void;
    get spotBidMaxPriceInput(): number | undefined;
}
export interface InstancePoolDiskSpecDiskType {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/instance_pool#azure_disk_volume_type InstancePool#azure_disk_volume_type}
    */
    readonly azureDiskVolumeType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/instance_pool#ebs_volume_type InstancePool#ebs_volume_type}
    */
    readonly ebsVolumeType?: string;
}
export declare function instancePoolDiskSpecDiskTypeToTerraform(struct?: InstancePoolDiskSpecDiskTypeOutputReference | InstancePoolDiskSpecDiskType): any;
export declare class InstancePoolDiskSpecDiskTypeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): InstancePoolDiskSpecDiskType | undefined;
    set internalValue(value: InstancePoolDiskSpecDiskType | undefined);
    private _azureDiskVolumeType?;
    get azureDiskVolumeType(): string;
    set azureDiskVolumeType(value: string);
    resetAzureDiskVolumeType(): void;
    get azureDiskVolumeTypeInput(): string | undefined;
    private _ebsVolumeType?;
    get ebsVolumeType(): string;
    set ebsVolumeType(value: string);
    resetEbsVolumeType(): void;
    get ebsVolumeTypeInput(): string | undefined;
}
export interface InstancePoolDiskSpec {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/instance_pool#disk_count InstancePool#disk_count}
    */
    readonly diskCount?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/instance_pool#disk_size InstancePool#disk_size}
    */
    readonly diskSize?: number;
    /**
    * disk_type block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/instance_pool#disk_type InstancePool#disk_type}
    */
    readonly diskType?: InstancePoolDiskSpecDiskType;
}
export declare function instancePoolDiskSpecToTerraform(struct?: InstancePoolDiskSpecOutputReference | InstancePoolDiskSpec): any;
export declare class InstancePoolDiskSpecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): InstancePoolDiskSpec | undefined;
    set internalValue(value: InstancePoolDiskSpec | undefined);
    private _diskCount?;
    get diskCount(): number;
    set diskCount(value: number);
    resetDiskCount(): void;
    get diskCountInput(): number | undefined;
    private _diskSize?;
    get diskSize(): number;
    set diskSize(value: number);
    resetDiskSize(): void;
    get diskSizeInput(): number | undefined;
    private _diskType;
    get diskType(): InstancePoolDiskSpecDiskTypeOutputReference;
    putDiskType(value: InstancePoolDiskSpecDiskType): void;
    resetDiskType(): void;
    get diskTypeInput(): InstancePoolDiskSpecDiskType | undefined;
}
export interface InstancePoolGcpAttributes {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/instance_pool#gcp_availability InstancePool#gcp_availability}
    */
    readonly gcpAvailability?: string;
}
export declare function instancePoolGcpAttributesToTerraform(struct?: InstancePoolGcpAttributesOutputReference | InstancePoolGcpAttributes): any;
export declare class InstancePoolGcpAttributesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): InstancePoolGcpAttributes | undefined;
    set internalValue(value: InstancePoolGcpAttributes | undefined);
    private _gcpAvailability?;
    get gcpAvailability(): string;
    set gcpAvailability(value: string);
    resetGcpAvailability(): void;
    get gcpAvailabilityInput(): string | undefined;
}
export interface InstancePoolInstancePoolFleetAttributesFleetOnDemandOption {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/instance_pool#allocation_strategy InstancePool#allocation_strategy}
    */
    readonly allocationStrategy: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/instance_pool#instance_pools_to_use_count InstancePool#instance_pools_to_use_count}
    */
    readonly instancePoolsToUseCount?: number;
}
export declare function instancePoolInstancePoolFleetAttributesFleetOnDemandOptionToTerraform(struct?: InstancePoolInstancePoolFleetAttributesFleetOnDemandOptionOutputReference | InstancePoolInstancePoolFleetAttributesFleetOnDemandOption): any;
export declare class InstancePoolInstancePoolFleetAttributesFleetOnDemandOptionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): InstancePoolInstancePoolFleetAttributesFleetOnDemandOption | undefined;
    set internalValue(value: InstancePoolInstancePoolFleetAttributesFleetOnDemandOption | undefined);
    private _allocationStrategy?;
    get allocationStrategy(): string;
    set allocationStrategy(value: string);
    get allocationStrategyInput(): string | undefined;
    private _instancePoolsToUseCount?;
    get instancePoolsToUseCount(): number;
    set instancePoolsToUseCount(value: number);
    resetInstancePoolsToUseCount(): void;
    get instancePoolsToUseCountInput(): number | undefined;
}
export interface InstancePoolInstancePoolFleetAttributesFleetSpotOption {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/instance_pool#allocation_strategy InstancePool#allocation_strategy}
    */
    readonly allocationStrategy: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/instance_pool#instance_pools_to_use_count InstancePool#instance_pools_to_use_count}
    */
    readonly instancePoolsToUseCount?: number;
}
export declare function instancePoolInstancePoolFleetAttributesFleetSpotOptionToTerraform(struct?: InstancePoolInstancePoolFleetAttributesFleetSpotOptionOutputReference | InstancePoolInstancePoolFleetAttributesFleetSpotOption): any;
export declare class InstancePoolInstancePoolFleetAttributesFleetSpotOptionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): InstancePoolInstancePoolFleetAttributesFleetSpotOption | undefined;
    set internalValue(value: InstancePoolInstancePoolFleetAttributesFleetSpotOption | undefined);
    private _allocationStrategy?;
    get allocationStrategy(): string;
    set allocationStrategy(value: string);
    get allocationStrategyInput(): string | undefined;
    private _instancePoolsToUseCount?;
    get instancePoolsToUseCount(): number;
    set instancePoolsToUseCount(value: number);
    resetInstancePoolsToUseCount(): void;
    get instancePoolsToUseCountInput(): number | undefined;
}
export interface InstancePoolInstancePoolFleetAttributesLaunchTemplateOverride {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/instance_pool#availability_zone InstancePool#availability_zone}
    */
    readonly availabilityZone: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/instance_pool#instance_type InstancePool#instance_type}
    */
    readonly instanceType: string;
}
export declare function instancePoolInstancePoolFleetAttributesLaunchTemplateOverrideToTerraform(struct?: InstancePoolInstancePoolFleetAttributesLaunchTemplateOverride | cdktf.IResolvable): any;
export declare class InstancePoolInstancePoolFleetAttributesLaunchTemplateOverrideOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): InstancePoolInstancePoolFleetAttributesLaunchTemplateOverride | cdktf.IResolvable | undefined;
    set internalValue(value: InstancePoolInstancePoolFleetAttributesLaunchTemplateOverride | cdktf.IResolvable | undefined);
    private _availabilityZone?;
    get availabilityZone(): string;
    set availabilityZone(value: string);
    get availabilityZoneInput(): string | undefined;
    private _instanceType?;
    get instanceType(): string;
    set instanceType(value: string);
    get instanceTypeInput(): string | undefined;
}
export declare class InstancePoolInstancePoolFleetAttributesLaunchTemplateOverrideList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: InstancePoolInstancePoolFleetAttributesLaunchTemplateOverride[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): InstancePoolInstancePoolFleetAttributesLaunchTemplateOverrideOutputReference;
}
export interface InstancePoolInstancePoolFleetAttributes {
    /**
    * fleet_on_demand_option block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/instance_pool#fleet_on_demand_option InstancePool#fleet_on_demand_option}
    */
    readonly fleetOnDemandOption?: InstancePoolInstancePoolFleetAttributesFleetOnDemandOption;
    /**
    * fleet_spot_option block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/instance_pool#fleet_spot_option InstancePool#fleet_spot_option}
    */
    readonly fleetSpotOption?: InstancePoolInstancePoolFleetAttributesFleetSpotOption;
    /**
    * launch_template_override block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/instance_pool#launch_template_override InstancePool#launch_template_override}
    */
    readonly launchTemplateOverride: InstancePoolInstancePoolFleetAttributesLaunchTemplateOverride[] | cdktf.IResolvable;
}
export declare function instancePoolInstancePoolFleetAttributesToTerraform(struct?: InstancePoolInstancePoolFleetAttributesOutputReference | InstancePoolInstancePoolFleetAttributes): any;
export declare class InstancePoolInstancePoolFleetAttributesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): InstancePoolInstancePoolFleetAttributes | undefined;
    set internalValue(value: InstancePoolInstancePoolFleetAttributes | undefined);
    private _fleetOnDemandOption;
    get fleetOnDemandOption(): InstancePoolInstancePoolFleetAttributesFleetOnDemandOptionOutputReference;
    putFleetOnDemandOption(value: InstancePoolInstancePoolFleetAttributesFleetOnDemandOption): void;
    resetFleetOnDemandOption(): void;
    get fleetOnDemandOptionInput(): InstancePoolInstancePoolFleetAttributesFleetOnDemandOption | undefined;
    private _fleetSpotOption;
    get fleetSpotOption(): InstancePoolInstancePoolFleetAttributesFleetSpotOptionOutputReference;
    putFleetSpotOption(value: InstancePoolInstancePoolFleetAttributesFleetSpotOption): void;
    resetFleetSpotOption(): void;
    get fleetSpotOptionInput(): InstancePoolInstancePoolFleetAttributesFleetSpotOption | undefined;
    private _launchTemplateOverride;
    get launchTemplateOverride(): InstancePoolInstancePoolFleetAttributesLaunchTemplateOverrideList;
    putLaunchTemplateOverride(value: InstancePoolInstancePoolFleetAttributesLaunchTemplateOverride[] | cdktf.IResolvable): void;
    get launchTemplateOverrideInput(): cdktf.IResolvable | InstancePoolInstancePoolFleetAttributesLaunchTemplateOverride[] | undefined;
}
export interface InstancePoolPreloadedDockerImageBasicAuth {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/instance_pool#password InstancePool#password}
    */
    readonly password: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/instance_pool#username InstancePool#username}
    */
    readonly username: string;
}
export declare function instancePoolPreloadedDockerImageBasicAuthToTerraform(struct?: InstancePoolPreloadedDockerImageBasicAuthOutputReference | InstancePoolPreloadedDockerImageBasicAuth): any;
export declare class InstancePoolPreloadedDockerImageBasicAuthOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): InstancePoolPreloadedDockerImageBasicAuth | undefined;
    set internalValue(value: InstancePoolPreloadedDockerImageBasicAuth | undefined);
    private _password?;
    get password(): string;
    set password(value: string);
    get passwordInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
}
export interface InstancePoolPreloadedDockerImage {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/instance_pool#url InstancePool#url}
    */
    readonly url: string;
    /**
    * basic_auth block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/instance_pool#basic_auth InstancePool#basic_auth}
    */
    readonly basicAuth?: InstancePoolPreloadedDockerImageBasicAuth;
}
export declare function instancePoolPreloadedDockerImageToTerraform(struct?: InstancePoolPreloadedDockerImage | cdktf.IResolvable): any;
export declare class InstancePoolPreloadedDockerImageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): InstancePoolPreloadedDockerImage | cdktf.IResolvable | undefined;
    set internalValue(value: InstancePoolPreloadedDockerImage | cdktf.IResolvable | undefined);
    private _url?;
    get url(): string;
    set url(value: string);
    get urlInput(): string | undefined;
    private _basicAuth;
    get basicAuth(): InstancePoolPreloadedDockerImageBasicAuthOutputReference;
    putBasicAuth(value: InstancePoolPreloadedDockerImageBasicAuth): void;
    resetBasicAuth(): void;
    get basicAuthInput(): InstancePoolPreloadedDockerImageBasicAuth | undefined;
}
export declare class InstancePoolPreloadedDockerImageList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: InstancePoolPreloadedDockerImage[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): InstancePoolPreloadedDockerImageOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/databricks/r/instance_pool databricks_instance_pool}
*/
export declare class InstancePool extends cdktf.TerraformResource {
    static readonly tfResourceType = "databricks_instance_pool";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/databricks/r/instance_pool databricks_instance_pool} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options InstancePoolConfig
    */
    constructor(scope: Construct, id: string, config: InstancePoolConfig);
    private _customTags?;
    get customTags(): {
        [key: string]: string;
    };
    set customTags(value: {
        [key: string]: string;
    });
    resetCustomTags(): void;
    get customTagsInput(): {
        [key: string]: string;
    } | undefined;
    private _enableElasticDisk?;
    get enableElasticDisk(): boolean | cdktf.IResolvable;
    set enableElasticDisk(value: boolean | cdktf.IResolvable);
    resetEnableElasticDisk(): void;
    get enableElasticDiskInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _idleInstanceAutoterminationMinutes?;
    get idleInstanceAutoterminationMinutes(): number;
    set idleInstanceAutoterminationMinutes(value: number);
    get idleInstanceAutoterminationMinutesInput(): number | undefined;
    private _instancePoolId?;
    get instancePoolId(): string;
    set instancePoolId(value: string);
    resetInstancePoolId(): void;
    get instancePoolIdInput(): string | undefined;
    private _instancePoolName?;
    get instancePoolName(): string;
    set instancePoolName(value: string);
    get instancePoolNameInput(): string | undefined;
    private _maxCapacity?;
    get maxCapacity(): number;
    set maxCapacity(value: number);
    resetMaxCapacity(): void;
    get maxCapacityInput(): number | undefined;
    private _minIdleInstances?;
    get minIdleInstances(): number;
    set minIdleInstances(value: number);
    resetMinIdleInstances(): void;
    get minIdleInstancesInput(): number | undefined;
    private _nodeTypeId?;
    get nodeTypeId(): string;
    set nodeTypeId(value: string);
    resetNodeTypeId(): void;
    get nodeTypeIdInput(): string | undefined;
    private _preloadedSparkVersions?;
    get preloadedSparkVersions(): string[];
    set preloadedSparkVersions(value: string[]);
    resetPreloadedSparkVersions(): void;
    get preloadedSparkVersionsInput(): string[] | undefined;
    private _awsAttributes;
    get awsAttributes(): InstancePoolAwsAttributesOutputReference;
    putAwsAttributes(value: InstancePoolAwsAttributes): void;
    resetAwsAttributes(): void;
    get awsAttributesInput(): InstancePoolAwsAttributes | undefined;
    private _azureAttributes;
    get azureAttributes(): InstancePoolAzureAttributesOutputReference;
    putAzureAttributes(value: InstancePoolAzureAttributes): void;
    resetAzureAttributes(): void;
    get azureAttributesInput(): InstancePoolAzureAttributes | undefined;
    private _diskSpec;
    get diskSpec(): InstancePoolDiskSpecOutputReference;
    putDiskSpec(value: InstancePoolDiskSpec): void;
    resetDiskSpec(): void;
    get diskSpecInput(): InstancePoolDiskSpec | undefined;
    private _gcpAttributes;
    get gcpAttributes(): InstancePoolGcpAttributesOutputReference;
    putGcpAttributes(value: InstancePoolGcpAttributes): void;
    resetGcpAttributes(): void;
    get gcpAttributesInput(): InstancePoolGcpAttributes | undefined;
    private _instancePoolFleetAttributes;
    get instancePoolFleetAttributes(): InstancePoolInstancePoolFleetAttributesOutputReference;
    putInstancePoolFleetAttributes(value: InstancePoolInstancePoolFleetAttributes): void;
    resetInstancePoolFleetAttributes(): void;
    get instancePoolFleetAttributesInput(): InstancePoolInstancePoolFleetAttributes | undefined;
    private _preloadedDockerImage;
    get preloadedDockerImage(): InstancePoolPreloadedDockerImageList;
    putPreloadedDockerImage(value: InstancePoolPreloadedDockerImage[] | cdktf.IResolvable): void;
    resetPreloadedDockerImage(): void;
    get preloadedDockerImageInput(): cdktf.IResolvable | InstancePoolPreloadedDockerImage[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
