import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface JobConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#always_running Job#always_running}
    */
    readonly alwaysRunning?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#existing_cluster_id Job#existing_cluster_id}
    */
    readonly existingClusterId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#format Job#format}
    */
    readonly format?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#id Job#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#max_concurrent_runs Job#max_concurrent_runs}
    */
    readonly maxConcurrentRuns?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#max_retries Job#max_retries}
    */
    readonly maxRetries?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#min_retry_interval_millis Job#min_retry_interval_millis}
    */
    readonly minRetryIntervalMillis?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#name Job#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#retry_on_timeout Job#retry_on_timeout}
    */
    readonly retryOnTimeout?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#tags Job#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#timeout_seconds Job#timeout_seconds}
    */
    readonly timeoutSeconds?: number;
    /**
    * continuous block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#continuous Job#continuous}
    */
    readonly continuous?: JobContinuous;
    /**
    * dbt_task block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#dbt_task Job#dbt_task}
    */
    readonly dbtTask?: JobDbtTask;
    /**
    * email_notifications block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#email_notifications Job#email_notifications}
    */
    readonly emailNotifications?: JobEmailNotifications;
    /**
    * git_source block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#git_source Job#git_source}
    */
    readonly gitSource?: JobGitSource;
    /**
    * job_cluster block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#job_cluster Job#job_cluster}
    */
    readonly jobCluster?: JobJobCluster[] | cdktf.IResolvable;
    /**
    * library block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#library Job#library}
    */
    readonly library?: JobLibrary[] | cdktf.IResolvable;
    /**
    * new_cluster block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#new_cluster Job#new_cluster}
    */
    readonly newCluster?: JobNewCluster;
    /**
    * notebook_task block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#notebook_task Job#notebook_task}
    */
    readonly notebookTask?: JobNotebookTask;
    /**
    * pipeline_task block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#pipeline_task Job#pipeline_task}
    */
    readonly pipelineTask?: JobPipelineTask;
    /**
    * python_wheel_task block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#python_wheel_task Job#python_wheel_task}
    */
    readonly pythonWheelTask?: JobPythonWheelTask;
    /**
    * queue block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#queue Job#queue}
    */
    readonly queue?: JobQueue;
    /**
    * schedule block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#schedule Job#schedule}
    */
    readonly schedule?: JobSchedule;
    /**
    * spark_jar_task block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#spark_jar_task Job#spark_jar_task}
    */
    readonly sparkJarTask?: JobSparkJarTask;
    /**
    * spark_python_task block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#spark_python_task Job#spark_python_task}
    */
    readonly sparkPythonTask?: JobSparkPythonTask;
    /**
    * spark_submit_task block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#spark_submit_task Job#spark_submit_task}
    */
    readonly sparkSubmitTask?: JobSparkSubmitTask;
    /**
    * task block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#task Job#task}
    */
    readonly task?: JobTask[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#timeouts Job#timeouts}
    */
    readonly timeouts?: JobTimeouts;
    /**
    * trigger block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#trigger Job#trigger}
    */
    readonly trigger?: JobTrigger;
    /**
    * webhook_notifications block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#webhook_notifications Job#webhook_notifications}
    */
    readonly webhookNotifications?: JobWebhookNotifications;
}
export interface JobContinuous {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#pause_status Job#pause_status}
    */
    readonly pauseStatus?: string;
}
export declare function jobContinuousToTerraform(struct?: JobContinuousOutputReference | JobContinuous): any;
export declare class JobContinuousOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobContinuous | undefined;
    set internalValue(value: JobContinuous | undefined);
    private _pauseStatus?;
    get pauseStatus(): string;
    set pauseStatus(value: string);
    resetPauseStatus(): void;
    get pauseStatusInput(): string | undefined;
}
export interface JobDbtTask {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#catalog Job#catalog}
    */
    readonly catalog?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#commands Job#commands}
    */
    readonly commands: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#profiles_directory Job#profiles_directory}
    */
    readonly profilesDirectory?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#project_directory Job#project_directory}
    */
    readonly projectDirectory?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#schema Job#schema}
    */
    readonly schema?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#warehouse_id Job#warehouse_id}
    */
    readonly warehouseId?: string;
}
export declare function jobDbtTaskToTerraform(struct?: JobDbtTaskOutputReference | JobDbtTask): any;
export declare class JobDbtTaskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobDbtTask | undefined;
    set internalValue(value: JobDbtTask | undefined);
    private _catalog?;
    get catalog(): string;
    set catalog(value: string);
    resetCatalog(): void;
    get catalogInput(): string | undefined;
    private _commands?;
    get commands(): string[];
    set commands(value: string[]);
    get commandsInput(): string[] | undefined;
    private _profilesDirectory?;
    get profilesDirectory(): string;
    set profilesDirectory(value: string);
    resetProfilesDirectory(): void;
    get profilesDirectoryInput(): string | undefined;
    private _projectDirectory?;
    get projectDirectory(): string;
    set projectDirectory(value: string);
    resetProjectDirectory(): void;
    get projectDirectoryInput(): string | undefined;
    private _schema?;
    get schema(): string;
    set schema(value: string);
    resetSchema(): void;
    get schemaInput(): string | undefined;
    private _warehouseId?;
    get warehouseId(): string;
    set warehouseId(value: string);
    resetWarehouseId(): void;
    get warehouseIdInput(): string | undefined;
}
export interface JobEmailNotifications {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#alert_on_last_attempt Job#alert_on_last_attempt}
    */
    readonly alertOnLastAttempt?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#no_alert_for_skipped_runs Job#no_alert_for_skipped_runs}
    */
    readonly noAlertForSkippedRuns?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#on_failure Job#on_failure}
    */
    readonly onFailure?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#on_start Job#on_start}
    */
    readonly onStart?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#on_success Job#on_success}
    */
    readonly onSuccess?: string[];
}
export declare function jobEmailNotificationsToTerraform(struct?: JobEmailNotificationsOutputReference | JobEmailNotifications): any;
export declare class JobEmailNotificationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobEmailNotifications | undefined;
    set internalValue(value: JobEmailNotifications | undefined);
    private _alertOnLastAttempt?;
    get alertOnLastAttempt(): boolean | cdktf.IResolvable;
    set alertOnLastAttempt(value: boolean | cdktf.IResolvable);
    resetAlertOnLastAttempt(): void;
    get alertOnLastAttemptInput(): boolean | cdktf.IResolvable | undefined;
    private _noAlertForSkippedRuns?;
    get noAlertForSkippedRuns(): boolean | cdktf.IResolvable;
    set noAlertForSkippedRuns(value: boolean | cdktf.IResolvable);
    resetNoAlertForSkippedRuns(): void;
    get noAlertForSkippedRunsInput(): boolean | cdktf.IResolvable | undefined;
    private _onFailure?;
    get onFailure(): string[];
    set onFailure(value: string[]);
    resetOnFailure(): void;
    get onFailureInput(): string[] | undefined;
    private _onStart?;
    get onStart(): string[];
    set onStart(value: string[]);
    resetOnStart(): void;
    get onStartInput(): string[] | undefined;
    private _onSuccess?;
    get onSuccess(): string[];
    set onSuccess(value: string[]);
    resetOnSuccess(): void;
    get onSuccessInput(): string[] | undefined;
}
export interface JobGitSource {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#branch Job#branch}
    */
    readonly branch?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#commit Job#commit}
    */
    readonly commit?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#provider Job#provider}
    */
    readonly provider?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#tag Job#tag}
    */
    readonly tag?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#url Job#url}
    */
    readonly url: string;
}
export declare function jobGitSourceToTerraform(struct?: JobGitSourceOutputReference | JobGitSource): any;
export declare class JobGitSourceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobGitSource | undefined;
    set internalValue(value: JobGitSource | undefined);
    private _branch?;
    get branch(): string;
    set branch(value: string);
    resetBranch(): void;
    get branchInput(): string | undefined;
    private _commit?;
    get commit(): string;
    set commit(value: string);
    resetCommit(): void;
    get commitInput(): string | undefined;
    private _provider?;
    get provider(): string;
    set provider(value: string);
    resetProvider(): void;
    get providerInput(): string | undefined;
    private _tag?;
    get tag(): string;
    set tag(value: string);
    resetTag(): void;
    get tagInput(): string | undefined;
    private _url?;
    get url(): string;
    set url(value: string);
    get urlInput(): string | undefined;
}
export interface JobJobClusterNewClusterAutoscale {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#max_workers Job#max_workers}
    */
    readonly maxWorkers?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#min_workers Job#min_workers}
    */
    readonly minWorkers?: number;
}
export declare function jobJobClusterNewClusterAutoscaleToTerraform(struct?: JobJobClusterNewClusterAutoscaleOutputReference | JobJobClusterNewClusterAutoscale): any;
export declare class JobJobClusterNewClusterAutoscaleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobJobClusterNewClusterAutoscale | undefined;
    set internalValue(value: JobJobClusterNewClusterAutoscale | undefined);
    private _maxWorkers?;
    get maxWorkers(): number;
    set maxWorkers(value: number);
    resetMaxWorkers(): void;
    get maxWorkersInput(): number | undefined;
    private _minWorkers?;
    get minWorkers(): number;
    set minWorkers(value: number);
    resetMinWorkers(): void;
    get minWorkersInput(): number | undefined;
}
export interface JobJobClusterNewClusterAwsAttributes {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#availability Job#availability}
    */
    readonly availability?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#ebs_volume_count Job#ebs_volume_count}
    */
    readonly ebsVolumeCount?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#ebs_volume_size Job#ebs_volume_size}
    */
    readonly ebsVolumeSize?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#ebs_volume_type Job#ebs_volume_type}
    */
    readonly ebsVolumeType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#first_on_demand Job#first_on_demand}
    */
    readonly firstOnDemand?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#instance_profile_arn Job#instance_profile_arn}
    */
    readonly instanceProfileArn?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#spot_bid_price_percent Job#spot_bid_price_percent}
    */
    readonly spotBidPricePercent?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#zone_id Job#zone_id}
    */
    readonly zoneId?: string;
}
export declare function jobJobClusterNewClusterAwsAttributesToTerraform(struct?: JobJobClusterNewClusterAwsAttributesOutputReference | JobJobClusterNewClusterAwsAttributes): any;
export declare class JobJobClusterNewClusterAwsAttributesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobJobClusterNewClusterAwsAttributes | undefined;
    set internalValue(value: JobJobClusterNewClusterAwsAttributes | undefined);
    private _availability?;
    get availability(): string;
    set availability(value: string);
    resetAvailability(): void;
    get availabilityInput(): string | undefined;
    private _ebsVolumeCount?;
    get ebsVolumeCount(): number;
    set ebsVolumeCount(value: number);
    resetEbsVolumeCount(): void;
    get ebsVolumeCountInput(): number | undefined;
    private _ebsVolumeSize?;
    get ebsVolumeSize(): number;
    set ebsVolumeSize(value: number);
    resetEbsVolumeSize(): void;
    get ebsVolumeSizeInput(): number | undefined;
    private _ebsVolumeType?;
    get ebsVolumeType(): string;
    set ebsVolumeType(value: string);
    resetEbsVolumeType(): void;
    get ebsVolumeTypeInput(): string | undefined;
    private _firstOnDemand?;
    get firstOnDemand(): number;
    set firstOnDemand(value: number);
    resetFirstOnDemand(): void;
    get firstOnDemandInput(): number | undefined;
    private _instanceProfileArn?;
    get instanceProfileArn(): string;
    set instanceProfileArn(value: string);
    resetInstanceProfileArn(): void;
    get instanceProfileArnInput(): string | undefined;
    private _spotBidPricePercent?;
    get spotBidPricePercent(): number;
    set spotBidPricePercent(value: number);
    resetSpotBidPricePercent(): void;
    get spotBidPricePercentInput(): number | undefined;
    private _zoneId?;
    get zoneId(): string;
    set zoneId(value: string);
    resetZoneId(): void;
    get zoneIdInput(): string | undefined;
}
export interface JobJobClusterNewClusterAzureAttributes {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#availability Job#availability}
    */
    readonly availability?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#first_on_demand Job#first_on_demand}
    */
    readonly firstOnDemand?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#spot_bid_max_price Job#spot_bid_max_price}
    */
    readonly spotBidMaxPrice?: number;
}
export declare function jobJobClusterNewClusterAzureAttributesToTerraform(struct?: JobJobClusterNewClusterAzureAttributesOutputReference | JobJobClusterNewClusterAzureAttributes): any;
export declare class JobJobClusterNewClusterAzureAttributesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobJobClusterNewClusterAzureAttributes | undefined;
    set internalValue(value: JobJobClusterNewClusterAzureAttributes | undefined);
    private _availability?;
    get availability(): string;
    set availability(value: string);
    resetAvailability(): void;
    get availabilityInput(): string | undefined;
    private _firstOnDemand?;
    get firstOnDemand(): number;
    set firstOnDemand(value: number);
    resetFirstOnDemand(): void;
    get firstOnDemandInput(): number | undefined;
    private _spotBidMaxPrice?;
    get spotBidMaxPrice(): number;
    set spotBidMaxPrice(value: number);
    resetSpotBidMaxPrice(): void;
    get spotBidMaxPriceInput(): number | undefined;
}
export interface JobJobClusterNewClusterClusterLogConfDbfs {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#destination Job#destination}
    */
    readonly destination: string;
}
export declare function jobJobClusterNewClusterClusterLogConfDbfsToTerraform(struct?: JobJobClusterNewClusterClusterLogConfDbfsOutputReference | JobJobClusterNewClusterClusterLogConfDbfs): any;
export declare class JobJobClusterNewClusterClusterLogConfDbfsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobJobClusterNewClusterClusterLogConfDbfs | undefined;
    set internalValue(value: JobJobClusterNewClusterClusterLogConfDbfs | undefined);
    private _destination?;
    get destination(): string;
    set destination(value: string);
    get destinationInput(): string | undefined;
}
export interface JobJobClusterNewClusterClusterLogConfS3 {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#canned_acl Job#canned_acl}
    */
    readonly cannedAcl?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#destination Job#destination}
    */
    readonly destination: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#enable_encryption Job#enable_encryption}
    */
    readonly enableEncryption?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#encryption_type Job#encryption_type}
    */
    readonly encryptionType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#endpoint Job#endpoint}
    */
    readonly endpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#kms_key Job#kms_key}
    */
    readonly kmsKey?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#region Job#region}
    */
    readonly region?: string;
}
export declare function jobJobClusterNewClusterClusterLogConfS3ToTerraform(struct?: JobJobClusterNewClusterClusterLogConfS3OutputReference | JobJobClusterNewClusterClusterLogConfS3): any;
export declare class JobJobClusterNewClusterClusterLogConfS3OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobJobClusterNewClusterClusterLogConfS3 | undefined;
    set internalValue(value: JobJobClusterNewClusterClusterLogConfS3 | undefined);
    private _cannedAcl?;
    get cannedAcl(): string;
    set cannedAcl(value: string);
    resetCannedAcl(): void;
    get cannedAclInput(): string | undefined;
    private _destination?;
    get destination(): string;
    set destination(value: string);
    get destinationInput(): string | undefined;
    private _enableEncryption?;
    get enableEncryption(): boolean | cdktf.IResolvable;
    set enableEncryption(value: boolean | cdktf.IResolvable);
    resetEnableEncryption(): void;
    get enableEncryptionInput(): boolean | cdktf.IResolvable | undefined;
    private _encryptionType?;
    get encryptionType(): string;
    set encryptionType(value: string);
    resetEncryptionType(): void;
    get encryptionTypeInput(): string | undefined;
    private _endpoint?;
    get endpoint(): string;
    set endpoint(value: string);
    resetEndpoint(): void;
    get endpointInput(): string | undefined;
    private _kmsKey?;
    get kmsKey(): string;
    set kmsKey(value: string);
    resetKmsKey(): void;
    get kmsKeyInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
}
export interface JobJobClusterNewClusterClusterLogConf {
    /**
    * dbfs block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#dbfs Job#dbfs}
    */
    readonly dbfs?: JobJobClusterNewClusterClusterLogConfDbfs;
    /**
    * s3 block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#s3 Job#s3}
    */
    readonly s3?: JobJobClusterNewClusterClusterLogConfS3;
}
export declare function jobJobClusterNewClusterClusterLogConfToTerraform(struct?: JobJobClusterNewClusterClusterLogConfOutputReference | JobJobClusterNewClusterClusterLogConf): any;
export declare class JobJobClusterNewClusterClusterLogConfOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobJobClusterNewClusterClusterLogConf | undefined;
    set internalValue(value: JobJobClusterNewClusterClusterLogConf | undefined);
    private _dbfs;
    get dbfs(): JobJobClusterNewClusterClusterLogConfDbfsOutputReference;
    putDbfs(value: JobJobClusterNewClusterClusterLogConfDbfs): void;
    resetDbfs(): void;
    get dbfsInput(): JobJobClusterNewClusterClusterLogConfDbfs | undefined;
    private _s3;
    get s3(): JobJobClusterNewClusterClusterLogConfS3OutputReference;
    putS3(value: JobJobClusterNewClusterClusterLogConfS3): void;
    resetS3(): void;
    get s3Input(): JobJobClusterNewClusterClusterLogConfS3 | undefined;
}
export interface JobJobClusterNewClusterClusterMountInfoNetworkFilesystemInfo {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#mount_options Job#mount_options}
    */
    readonly mountOptions?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#server_address Job#server_address}
    */
    readonly serverAddress: string;
}
export declare function jobJobClusterNewClusterClusterMountInfoNetworkFilesystemInfoToTerraform(struct?: JobJobClusterNewClusterClusterMountInfoNetworkFilesystemInfoOutputReference | JobJobClusterNewClusterClusterMountInfoNetworkFilesystemInfo): any;
export declare class JobJobClusterNewClusterClusterMountInfoNetworkFilesystemInfoOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobJobClusterNewClusterClusterMountInfoNetworkFilesystemInfo | undefined;
    set internalValue(value: JobJobClusterNewClusterClusterMountInfoNetworkFilesystemInfo | undefined);
    private _mountOptions?;
    get mountOptions(): string;
    set mountOptions(value: string);
    resetMountOptions(): void;
    get mountOptionsInput(): string | undefined;
    private _serverAddress?;
    get serverAddress(): string;
    set serverAddress(value: string);
    get serverAddressInput(): string | undefined;
}
export interface JobJobClusterNewClusterClusterMountInfo {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#local_mount_dir_path Job#local_mount_dir_path}
    */
    readonly localMountDirPath: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#remote_mount_dir_path Job#remote_mount_dir_path}
    */
    readonly remoteMountDirPath?: string;
    /**
    * network_filesystem_info block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#network_filesystem_info Job#network_filesystem_info}
    */
    readonly networkFilesystemInfo: JobJobClusterNewClusterClusterMountInfoNetworkFilesystemInfo;
}
export declare function jobJobClusterNewClusterClusterMountInfoToTerraform(struct?: JobJobClusterNewClusterClusterMountInfo | cdktf.IResolvable): any;
export declare class JobJobClusterNewClusterClusterMountInfoOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): JobJobClusterNewClusterClusterMountInfo | cdktf.IResolvable | undefined;
    set internalValue(value: JobJobClusterNewClusterClusterMountInfo | cdktf.IResolvable | undefined);
    private _localMountDirPath?;
    get localMountDirPath(): string;
    set localMountDirPath(value: string);
    get localMountDirPathInput(): string | undefined;
    private _remoteMountDirPath?;
    get remoteMountDirPath(): string;
    set remoteMountDirPath(value: string);
    resetRemoteMountDirPath(): void;
    get remoteMountDirPathInput(): string | undefined;
    private _networkFilesystemInfo;
    get networkFilesystemInfo(): JobJobClusterNewClusterClusterMountInfoNetworkFilesystemInfoOutputReference;
    putNetworkFilesystemInfo(value: JobJobClusterNewClusterClusterMountInfoNetworkFilesystemInfo): void;
    get networkFilesystemInfoInput(): JobJobClusterNewClusterClusterMountInfoNetworkFilesystemInfo | undefined;
}
export declare class JobJobClusterNewClusterClusterMountInfoList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: JobJobClusterNewClusterClusterMountInfo[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): JobJobClusterNewClusterClusterMountInfoOutputReference;
}
export interface JobJobClusterNewClusterDockerImageBasicAuth {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#password Job#password}
    */
    readonly password: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#username Job#username}
    */
    readonly username: string;
}
export declare function jobJobClusterNewClusterDockerImageBasicAuthToTerraform(struct?: JobJobClusterNewClusterDockerImageBasicAuthOutputReference | JobJobClusterNewClusterDockerImageBasicAuth): any;
export declare class JobJobClusterNewClusterDockerImageBasicAuthOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobJobClusterNewClusterDockerImageBasicAuth | undefined;
    set internalValue(value: JobJobClusterNewClusterDockerImageBasicAuth | undefined);
    private _password?;
    get password(): string;
    set password(value: string);
    get passwordInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
}
export interface JobJobClusterNewClusterDockerImage {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#url Job#url}
    */
    readonly url: string;
    /**
    * basic_auth block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#basic_auth Job#basic_auth}
    */
    readonly basicAuth?: JobJobClusterNewClusterDockerImageBasicAuth;
}
export declare function jobJobClusterNewClusterDockerImageToTerraform(struct?: JobJobClusterNewClusterDockerImageOutputReference | JobJobClusterNewClusterDockerImage): any;
export declare class JobJobClusterNewClusterDockerImageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobJobClusterNewClusterDockerImage | undefined;
    set internalValue(value: JobJobClusterNewClusterDockerImage | undefined);
    private _url?;
    get url(): string;
    set url(value: string);
    get urlInput(): string | undefined;
    private _basicAuth;
    get basicAuth(): JobJobClusterNewClusterDockerImageBasicAuthOutputReference;
    putBasicAuth(value: JobJobClusterNewClusterDockerImageBasicAuth): void;
    resetBasicAuth(): void;
    get basicAuthInput(): JobJobClusterNewClusterDockerImageBasicAuth | undefined;
}
export interface JobJobClusterNewClusterGcpAttributes {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#availability Job#availability}
    */
    readonly availability?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#boot_disk_size Job#boot_disk_size}
    */
    readonly bootDiskSize?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#google_service_account Job#google_service_account}
    */
    readonly googleServiceAccount?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#use_preemptible_executors Job#use_preemptible_executors}
    */
    readonly usePreemptibleExecutors?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#zone_id Job#zone_id}
    */
    readonly zoneId?: string;
}
export declare function jobJobClusterNewClusterGcpAttributesToTerraform(struct?: JobJobClusterNewClusterGcpAttributesOutputReference | JobJobClusterNewClusterGcpAttributes): any;
export declare class JobJobClusterNewClusterGcpAttributesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobJobClusterNewClusterGcpAttributes | undefined;
    set internalValue(value: JobJobClusterNewClusterGcpAttributes | undefined);
    private _availability?;
    get availability(): string;
    set availability(value: string);
    resetAvailability(): void;
    get availabilityInput(): string | undefined;
    private _bootDiskSize?;
    get bootDiskSize(): number;
    set bootDiskSize(value: number);
    resetBootDiskSize(): void;
    get bootDiskSizeInput(): number | undefined;
    private _googleServiceAccount?;
    get googleServiceAccount(): string;
    set googleServiceAccount(value: string);
    resetGoogleServiceAccount(): void;
    get googleServiceAccountInput(): string | undefined;
    private _usePreemptibleExecutors?;
    get usePreemptibleExecutors(): boolean | cdktf.IResolvable;
    set usePreemptibleExecutors(value: boolean | cdktf.IResolvable);
    resetUsePreemptibleExecutors(): void;
    get usePreemptibleExecutorsInput(): boolean | cdktf.IResolvable | undefined;
    private _zoneId?;
    get zoneId(): string;
    set zoneId(value: string);
    resetZoneId(): void;
    get zoneIdInput(): string | undefined;
}
export interface JobJobClusterNewClusterInitScriptsAbfss {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#destination Job#destination}
    */
    readonly destination?: string;
}
export declare function jobJobClusterNewClusterInitScriptsAbfssToTerraform(struct?: JobJobClusterNewClusterInitScriptsAbfssOutputReference | JobJobClusterNewClusterInitScriptsAbfss): any;
export declare class JobJobClusterNewClusterInitScriptsAbfssOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobJobClusterNewClusterInitScriptsAbfss | undefined;
    set internalValue(value: JobJobClusterNewClusterInitScriptsAbfss | undefined);
    private _destination?;
    get destination(): string;
    set destination(value: string);
    resetDestination(): void;
    get destinationInput(): string | undefined;
}
export interface JobJobClusterNewClusterInitScriptsDbfs {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#destination Job#destination}
    */
    readonly destination: string;
}
export declare function jobJobClusterNewClusterInitScriptsDbfsToTerraform(struct?: JobJobClusterNewClusterInitScriptsDbfsOutputReference | JobJobClusterNewClusterInitScriptsDbfs): any;
export declare class JobJobClusterNewClusterInitScriptsDbfsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobJobClusterNewClusterInitScriptsDbfs | undefined;
    set internalValue(value: JobJobClusterNewClusterInitScriptsDbfs | undefined);
    private _destination?;
    get destination(): string;
    set destination(value: string);
    get destinationInput(): string | undefined;
}
export interface JobJobClusterNewClusterInitScriptsFile {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#destination Job#destination}
    */
    readonly destination?: string;
}
export declare function jobJobClusterNewClusterInitScriptsFileToTerraform(struct?: JobJobClusterNewClusterInitScriptsFileOutputReference | JobJobClusterNewClusterInitScriptsFile): any;
export declare class JobJobClusterNewClusterInitScriptsFileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobJobClusterNewClusterInitScriptsFile | undefined;
    set internalValue(value: JobJobClusterNewClusterInitScriptsFile | undefined);
    private _destination?;
    get destination(): string;
    set destination(value: string);
    resetDestination(): void;
    get destinationInput(): string | undefined;
}
export interface JobJobClusterNewClusterInitScriptsGcs {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#destination Job#destination}
    */
    readonly destination?: string;
}
export declare function jobJobClusterNewClusterInitScriptsGcsToTerraform(struct?: JobJobClusterNewClusterInitScriptsGcsOutputReference | JobJobClusterNewClusterInitScriptsGcs): any;
export declare class JobJobClusterNewClusterInitScriptsGcsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobJobClusterNewClusterInitScriptsGcs | undefined;
    set internalValue(value: JobJobClusterNewClusterInitScriptsGcs | undefined);
    private _destination?;
    get destination(): string;
    set destination(value: string);
    resetDestination(): void;
    get destinationInput(): string | undefined;
}
export interface JobJobClusterNewClusterInitScriptsS3 {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#canned_acl Job#canned_acl}
    */
    readonly cannedAcl?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#destination Job#destination}
    */
    readonly destination: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#enable_encryption Job#enable_encryption}
    */
    readonly enableEncryption?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#encryption_type Job#encryption_type}
    */
    readonly encryptionType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#endpoint Job#endpoint}
    */
    readonly endpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#kms_key Job#kms_key}
    */
    readonly kmsKey?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#region Job#region}
    */
    readonly region?: string;
}
export declare function jobJobClusterNewClusterInitScriptsS3ToTerraform(struct?: JobJobClusterNewClusterInitScriptsS3OutputReference | JobJobClusterNewClusterInitScriptsS3): any;
export declare class JobJobClusterNewClusterInitScriptsS3OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobJobClusterNewClusterInitScriptsS3 | undefined;
    set internalValue(value: JobJobClusterNewClusterInitScriptsS3 | undefined);
    private _cannedAcl?;
    get cannedAcl(): string;
    set cannedAcl(value: string);
    resetCannedAcl(): void;
    get cannedAclInput(): string | undefined;
    private _destination?;
    get destination(): string;
    set destination(value: string);
    get destinationInput(): string | undefined;
    private _enableEncryption?;
    get enableEncryption(): boolean | cdktf.IResolvable;
    set enableEncryption(value: boolean | cdktf.IResolvable);
    resetEnableEncryption(): void;
    get enableEncryptionInput(): boolean | cdktf.IResolvable | undefined;
    private _encryptionType?;
    get encryptionType(): string;
    set encryptionType(value: string);
    resetEncryptionType(): void;
    get encryptionTypeInput(): string | undefined;
    private _endpoint?;
    get endpoint(): string;
    set endpoint(value: string);
    resetEndpoint(): void;
    get endpointInput(): string | undefined;
    private _kmsKey?;
    get kmsKey(): string;
    set kmsKey(value: string);
    resetKmsKey(): void;
    get kmsKeyInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
}
export interface JobJobClusterNewClusterInitScripts {
    /**
    * abfss block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#abfss Job#abfss}
    */
    readonly abfss?: JobJobClusterNewClusterInitScriptsAbfss;
    /**
    * dbfs block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#dbfs Job#dbfs}
    */
    readonly dbfs?: JobJobClusterNewClusterInitScriptsDbfs;
    /**
    * file block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#file Job#file}
    */
    readonly file?: JobJobClusterNewClusterInitScriptsFile;
    /**
    * gcs block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#gcs Job#gcs}
    */
    readonly gcs?: JobJobClusterNewClusterInitScriptsGcs;
    /**
    * s3 block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#s3 Job#s3}
    */
    readonly s3?: JobJobClusterNewClusterInitScriptsS3;
}
export declare function jobJobClusterNewClusterInitScriptsToTerraform(struct?: JobJobClusterNewClusterInitScripts | cdktf.IResolvable): any;
export declare class JobJobClusterNewClusterInitScriptsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): JobJobClusterNewClusterInitScripts | cdktf.IResolvable | undefined;
    set internalValue(value: JobJobClusterNewClusterInitScripts | cdktf.IResolvable | undefined);
    private _abfss;
    get abfss(): JobJobClusterNewClusterInitScriptsAbfssOutputReference;
    putAbfss(value: JobJobClusterNewClusterInitScriptsAbfss): void;
    resetAbfss(): void;
    get abfssInput(): JobJobClusterNewClusterInitScriptsAbfss | undefined;
    private _dbfs;
    get dbfs(): JobJobClusterNewClusterInitScriptsDbfsOutputReference;
    putDbfs(value: JobJobClusterNewClusterInitScriptsDbfs): void;
    resetDbfs(): void;
    get dbfsInput(): JobJobClusterNewClusterInitScriptsDbfs | undefined;
    private _file;
    get file(): JobJobClusterNewClusterInitScriptsFileOutputReference;
    putFile(value: JobJobClusterNewClusterInitScriptsFile): void;
    resetFile(): void;
    get fileInput(): JobJobClusterNewClusterInitScriptsFile | undefined;
    private _gcs;
    get gcs(): JobJobClusterNewClusterInitScriptsGcsOutputReference;
    putGcs(value: JobJobClusterNewClusterInitScriptsGcs): void;
    resetGcs(): void;
    get gcsInput(): JobJobClusterNewClusterInitScriptsGcs | undefined;
    private _s3;
    get s3(): JobJobClusterNewClusterInitScriptsS3OutputReference;
    putS3(value: JobJobClusterNewClusterInitScriptsS3): void;
    resetS3(): void;
    get s3Input(): JobJobClusterNewClusterInitScriptsS3 | undefined;
}
export declare class JobJobClusterNewClusterInitScriptsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: JobJobClusterNewClusterInitScripts[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): JobJobClusterNewClusterInitScriptsOutputReference;
}
export interface JobJobClusterNewClusterWorkloadTypeClients {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#jobs Job#jobs}
    */
    readonly jobs?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#notebooks Job#notebooks}
    */
    readonly notebooks?: boolean | cdktf.IResolvable;
}
export declare function jobJobClusterNewClusterWorkloadTypeClientsToTerraform(struct?: JobJobClusterNewClusterWorkloadTypeClientsOutputReference | JobJobClusterNewClusterWorkloadTypeClients): any;
export declare class JobJobClusterNewClusterWorkloadTypeClientsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobJobClusterNewClusterWorkloadTypeClients | undefined;
    set internalValue(value: JobJobClusterNewClusterWorkloadTypeClients | undefined);
    private _jobs?;
    get jobs(): boolean | cdktf.IResolvable;
    set jobs(value: boolean | cdktf.IResolvable);
    resetJobs(): void;
    get jobsInput(): boolean | cdktf.IResolvable | undefined;
    private _notebooks?;
    get notebooks(): boolean | cdktf.IResolvable;
    set notebooks(value: boolean | cdktf.IResolvable);
    resetNotebooks(): void;
    get notebooksInput(): boolean | cdktf.IResolvable | undefined;
}
export interface JobJobClusterNewClusterWorkloadType {
    /**
    * clients block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#clients Job#clients}
    */
    readonly clients: JobJobClusterNewClusterWorkloadTypeClients;
}
export declare function jobJobClusterNewClusterWorkloadTypeToTerraform(struct?: JobJobClusterNewClusterWorkloadTypeOutputReference | JobJobClusterNewClusterWorkloadType): any;
export declare class JobJobClusterNewClusterWorkloadTypeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobJobClusterNewClusterWorkloadType | undefined;
    set internalValue(value: JobJobClusterNewClusterWorkloadType | undefined);
    private _clients;
    get clients(): JobJobClusterNewClusterWorkloadTypeClientsOutputReference;
    putClients(value: JobJobClusterNewClusterWorkloadTypeClients): void;
    get clientsInput(): JobJobClusterNewClusterWorkloadTypeClients | undefined;
}
export interface JobJobClusterNewCluster {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#apply_policy_default_values Job#apply_policy_default_values}
    */
    readonly applyPolicyDefaultValues?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#autotermination_minutes Job#autotermination_minutes}
    */
    readonly autoterminationMinutes?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#cluster_id Job#cluster_id}
    */
    readonly clusterId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#cluster_name Job#cluster_name}
    */
    readonly clusterName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#custom_tags Job#custom_tags}
    */
    readonly customTags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#data_security_mode Job#data_security_mode}
    */
    readonly dataSecurityMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#driver_instance_pool_id Job#driver_instance_pool_id}
    */
    readonly driverInstancePoolId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#driver_node_type_id Job#driver_node_type_id}
    */
    readonly driverNodeTypeId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#enable_elastic_disk Job#enable_elastic_disk}
    */
    readonly enableElasticDisk?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#enable_local_disk_encryption Job#enable_local_disk_encryption}
    */
    readonly enableLocalDiskEncryption?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#idempotency_token Job#idempotency_token}
    */
    readonly idempotencyToken?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#instance_pool_id Job#instance_pool_id}
    */
    readonly instancePoolId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#node_type_id Job#node_type_id}
    */
    readonly nodeTypeId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#num_workers Job#num_workers}
    */
    readonly numWorkers?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#policy_id Job#policy_id}
    */
    readonly policyId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#runtime_engine Job#runtime_engine}
    */
    readonly runtimeEngine?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#single_user_name Job#single_user_name}
    */
    readonly singleUserName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#spark_conf Job#spark_conf}
    */
    readonly sparkConf?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#spark_env_vars Job#spark_env_vars}
    */
    readonly sparkEnvVars?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#spark_version Job#spark_version}
    */
    readonly sparkVersion: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#ssh_public_keys Job#ssh_public_keys}
    */
    readonly sshPublicKeys?: string[];
    /**
    * autoscale block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#autoscale Job#autoscale}
    */
    readonly autoscale?: JobJobClusterNewClusterAutoscale;
    /**
    * aws_attributes block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#aws_attributes Job#aws_attributes}
    */
    readonly awsAttributes?: JobJobClusterNewClusterAwsAttributes;
    /**
    * azure_attributes block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#azure_attributes Job#azure_attributes}
    */
    readonly azureAttributes?: JobJobClusterNewClusterAzureAttributes;
    /**
    * cluster_log_conf block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#cluster_log_conf Job#cluster_log_conf}
    */
    readonly clusterLogConf?: JobJobClusterNewClusterClusterLogConf;
    /**
    * cluster_mount_info block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#cluster_mount_info Job#cluster_mount_info}
    */
    readonly clusterMountInfo?: JobJobClusterNewClusterClusterMountInfo[] | cdktf.IResolvable;
    /**
    * docker_image block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#docker_image Job#docker_image}
    */
    readonly dockerImage?: JobJobClusterNewClusterDockerImage;
    /**
    * gcp_attributes block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#gcp_attributes Job#gcp_attributes}
    */
    readonly gcpAttributes?: JobJobClusterNewClusterGcpAttributes;
    /**
    * init_scripts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#init_scripts Job#init_scripts}
    */
    readonly initScripts?: JobJobClusterNewClusterInitScripts[] | cdktf.IResolvable;
    /**
    * workload_type block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#workload_type Job#workload_type}
    */
    readonly workloadType?: JobJobClusterNewClusterWorkloadType;
}
export declare function jobJobClusterNewClusterToTerraform(struct?: JobJobClusterNewClusterOutputReference | JobJobClusterNewCluster): any;
export declare class JobJobClusterNewClusterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobJobClusterNewCluster | undefined;
    set internalValue(value: JobJobClusterNewCluster | undefined);
    private _applyPolicyDefaultValues?;
    get applyPolicyDefaultValues(): boolean | cdktf.IResolvable;
    set applyPolicyDefaultValues(value: boolean | cdktf.IResolvable);
    resetApplyPolicyDefaultValues(): void;
    get applyPolicyDefaultValuesInput(): boolean | cdktf.IResolvable | undefined;
    private _autoterminationMinutes?;
    get autoterminationMinutes(): number;
    set autoterminationMinutes(value: number);
    resetAutoterminationMinutes(): void;
    get autoterminationMinutesInput(): number | undefined;
    private _clusterId?;
    get clusterId(): string;
    set clusterId(value: string);
    resetClusterId(): void;
    get clusterIdInput(): string | undefined;
    private _clusterName?;
    get clusterName(): string;
    set clusterName(value: string);
    resetClusterName(): void;
    get clusterNameInput(): string | undefined;
    private _customTags?;
    get customTags(): {
        [key: string]: string;
    };
    set customTags(value: {
        [key: string]: string;
    });
    resetCustomTags(): void;
    get customTagsInput(): {
        [key: string]: string;
    } | undefined;
    private _dataSecurityMode?;
    get dataSecurityMode(): string;
    set dataSecurityMode(value: string);
    resetDataSecurityMode(): void;
    get dataSecurityModeInput(): string | undefined;
    private _driverInstancePoolId?;
    get driverInstancePoolId(): string;
    set driverInstancePoolId(value: string);
    resetDriverInstancePoolId(): void;
    get driverInstancePoolIdInput(): string | undefined;
    private _driverNodeTypeId?;
    get driverNodeTypeId(): string;
    set driverNodeTypeId(value: string);
    resetDriverNodeTypeId(): void;
    get driverNodeTypeIdInput(): string | undefined;
    private _enableElasticDisk?;
    get enableElasticDisk(): boolean | cdktf.IResolvable;
    set enableElasticDisk(value: boolean | cdktf.IResolvable);
    resetEnableElasticDisk(): void;
    get enableElasticDiskInput(): boolean | cdktf.IResolvable | undefined;
    private _enableLocalDiskEncryption?;
    get enableLocalDiskEncryption(): boolean | cdktf.IResolvable;
    set enableLocalDiskEncryption(value: boolean | cdktf.IResolvable);
    resetEnableLocalDiskEncryption(): void;
    get enableLocalDiskEncryptionInput(): boolean | cdktf.IResolvable | undefined;
    private _idempotencyToken?;
    get idempotencyToken(): string;
    set idempotencyToken(value: string);
    resetIdempotencyToken(): void;
    get idempotencyTokenInput(): string | undefined;
    private _instancePoolId?;
    get instancePoolId(): string;
    set instancePoolId(value: string);
    resetInstancePoolId(): void;
    get instancePoolIdInput(): string | undefined;
    private _nodeTypeId?;
    get nodeTypeId(): string;
    set nodeTypeId(value: string);
    resetNodeTypeId(): void;
    get nodeTypeIdInput(): string | undefined;
    private _numWorkers?;
    get numWorkers(): number;
    set numWorkers(value: number);
    resetNumWorkers(): void;
    get numWorkersInput(): number | undefined;
    private _policyId?;
    get policyId(): string;
    set policyId(value: string);
    resetPolicyId(): void;
    get policyIdInput(): string | undefined;
    private _runtimeEngine?;
    get runtimeEngine(): string;
    set runtimeEngine(value: string);
    resetRuntimeEngine(): void;
    get runtimeEngineInput(): string | undefined;
    private _singleUserName?;
    get singleUserName(): string;
    set singleUserName(value: string);
    resetSingleUserName(): void;
    get singleUserNameInput(): string | undefined;
    private _sparkConf?;
    get sparkConf(): {
        [key: string]: string;
    };
    set sparkConf(value: {
        [key: string]: string;
    });
    resetSparkConf(): void;
    get sparkConfInput(): {
        [key: string]: string;
    } | undefined;
    private _sparkEnvVars?;
    get sparkEnvVars(): {
        [key: string]: string;
    };
    set sparkEnvVars(value: {
        [key: string]: string;
    });
    resetSparkEnvVars(): void;
    get sparkEnvVarsInput(): {
        [key: string]: string;
    } | undefined;
    private _sparkVersion?;
    get sparkVersion(): string;
    set sparkVersion(value: string);
    get sparkVersionInput(): string | undefined;
    private _sshPublicKeys?;
    get sshPublicKeys(): string[];
    set sshPublicKeys(value: string[]);
    resetSshPublicKeys(): void;
    get sshPublicKeysInput(): string[] | undefined;
    private _autoscale;
    get autoscale(): JobJobClusterNewClusterAutoscaleOutputReference;
    putAutoscale(value: JobJobClusterNewClusterAutoscale): void;
    resetAutoscale(): void;
    get autoscaleInput(): JobJobClusterNewClusterAutoscale | undefined;
    private _awsAttributes;
    get awsAttributes(): JobJobClusterNewClusterAwsAttributesOutputReference;
    putAwsAttributes(value: JobJobClusterNewClusterAwsAttributes): void;
    resetAwsAttributes(): void;
    get awsAttributesInput(): JobJobClusterNewClusterAwsAttributes | undefined;
    private _azureAttributes;
    get azureAttributes(): JobJobClusterNewClusterAzureAttributesOutputReference;
    putAzureAttributes(value: JobJobClusterNewClusterAzureAttributes): void;
    resetAzureAttributes(): void;
    get azureAttributesInput(): JobJobClusterNewClusterAzureAttributes | undefined;
    private _clusterLogConf;
    get clusterLogConf(): JobJobClusterNewClusterClusterLogConfOutputReference;
    putClusterLogConf(value: JobJobClusterNewClusterClusterLogConf): void;
    resetClusterLogConf(): void;
    get clusterLogConfInput(): JobJobClusterNewClusterClusterLogConf | undefined;
    private _clusterMountInfo;
    get clusterMountInfo(): JobJobClusterNewClusterClusterMountInfoList;
    putClusterMountInfo(value: JobJobClusterNewClusterClusterMountInfo[] | cdktf.IResolvable): void;
    resetClusterMountInfo(): void;
    get clusterMountInfoInput(): cdktf.IResolvable | JobJobClusterNewClusterClusterMountInfo[] | undefined;
    private _dockerImage;
    get dockerImage(): JobJobClusterNewClusterDockerImageOutputReference;
    putDockerImage(value: JobJobClusterNewClusterDockerImage): void;
    resetDockerImage(): void;
    get dockerImageInput(): JobJobClusterNewClusterDockerImage | undefined;
    private _gcpAttributes;
    get gcpAttributes(): JobJobClusterNewClusterGcpAttributesOutputReference;
    putGcpAttributes(value: JobJobClusterNewClusterGcpAttributes): void;
    resetGcpAttributes(): void;
    get gcpAttributesInput(): JobJobClusterNewClusterGcpAttributes | undefined;
    private _initScripts;
    get initScripts(): JobJobClusterNewClusterInitScriptsList;
    putInitScripts(value: JobJobClusterNewClusterInitScripts[] | cdktf.IResolvable): void;
    resetInitScripts(): void;
    get initScriptsInput(): cdktf.IResolvable | JobJobClusterNewClusterInitScripts[] | undefined;
    private _workloadType;
    get workloadType(): JobJobClusterNewClusterWorkloadTypeOutputReference;
    putWorkloadType(value: JobJobClusterNewClusterWorkloadType): void;
    resetWorkloadType(): void;
    get workloadTypeInput(): JobJobClusterNewClusterWorkloadType | undefined;
}
export interface JobJobCluster {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#job_cluster_key Job#job_cluster_key}
    */
    readonly jobClusterKey?: string;
    /**
    * new_cluster block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#new_cluster Job#new_cluster}
    */
    readonly newCluster?: JobJobClusterNewCluster;
}
export declare function jobJobClusterToTerraform(struct?: JobJobCluster | cdktf.IResolvable): any;
export declare class JobJobClusterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): JobJobCluster | cdktf.IResolvable | undefined;
    set internalValue(value: JobJobCluster | cdktf.IResolvable | undefined);
    private _jobClusterKey?;
    get jobClusterKey(): string;
    set jobClusterKey(value: string);
    resetJobClusterKey(): void;
    get jobClusterKeyInput(): string | undefined;
    private _newCluster;
    get newCluster(): JobJobClusterNewClusterOutputReference;
    putNewCluster(value: JobJobClusterNewCluster): void;
    resetNewCluster(): void;
    get newClusterInput(): JobJobClusterNewCluster | undefined;
}
export declare class JobJobClusterList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: JobJobCluster[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): JobJobClusterOutputReference;
}
export interface JobLibraryCran {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#package Job#package}
    */
    readonly package: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#repo Job#repo}
    */
    readonly repo?: string;
}
export declare function jobLibraryCranToTerraform(struct?: JobLibraryCranOutputReference | JobLibraryCran): any;
export declare class JobLibraryCranOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobLibraryCran | undefined;
    set internalValue(value: JobLibraryCran | undefined);
    private _package?;
    get package(): string;
    set package(value: string);
    get packageInput(): string | undefined;
    private _repo?;
    get repo(): string;
    set repo(value: string);
    resetRepo(): void;
    get repoInput(): string | undefined;
}
export interface JobLibraryMaven {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#coordinates Job#coordinates}
    */
    readonly coordinates: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#exclusions Job#exclusions}
    */
    readonly exclusions?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#repo Job#repo}
    */
    readonly repo?: string;
}
export declare function jobLibraryMavenToTerraform(struct?: JobLibraryMavenOutputReference | JobLibraryMaven): any;
export declare class JobLibraryMavenOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobLibraryMaven | undefined;
    set internalValue(value: JobLibraryMaven | undefined);
    private _coordinates?;
    get coordinates(): string;
    set coordinates(value: string);
    get coordinatesInput(): string | undefined;
    private _exclusions?;
    get exclusions(): string[];
    set exclusions(value: string[]);
    resetExclusions(): void;
    get exclusionsInput(): string[] | undefined;
    private _repo?;
    get repo(): string;
    set repo(value: string);
    resetRepo(): void;
    get repoInput(): string | undefined;
}
export interface JobLibraryPypi {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#package Job#package}
    */
    readonly package: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#repo Job#repo}
    */
    readonly repo?: string;
}
export declare function jobLibraryPypiToTerraform(struct?: JobLibraryPypiOutputReference | JobLibraryPypi): any;
export declare class JobLibraryPypiOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobLibraryPypi | undefined;
    set internalValue(value: JobLibraryPypi | undefined);
    private _package?;
    get package(): string;
    set package(value: string);
    get packageInput(): string | undefined;
    private _repo?;
    get repo(): string;
    set repo(value: string);
    resetRepo(): void;
    get repoInput(): string | undefined;
}
export interface JobLibrary {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#egg Job#egg}
    */
    readonly egg?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#jar Job#jar}
    */
    readonly jar?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#whl Job#whl}
    */
    readonly whl?: string;
    /**
    * cran block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#cran Job#cran}
    */
    readonly cran?: JobLibraryCran;
    /**
    * maven block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#maven Job#maven}
    */
    readonly maven?: JobLibraryMaven;
    /**
    * pypi block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#pypi Job#pypi}
    */
    readonly pypi?: JobLibraryPypi;
}
export declare function jobLibraryToTerraform(struct?: JobLibrary | cdktf.IResolvable): any;
export declare class JobLibraryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): JobLibrary | cdktf.IResolvable | undefined;
    set internalValue(value: JobLibrary | cdktf.IResolvable | undefined);
    private _egg?;
    get egg(): string;
    set egg(value: string);
    resetEgg(): void;
    get eggInput(): string | undefined;
    private _jar?;
    get jar(): string;
    set jar(value: string);
    resetJar(): void;
    get jarInput(): string | undefined;
    private _whl?;
    get whl(): string;
    set whl(value: string);
    resetWhl(): void;
    get whlInput(): string | undefined;
    private _cran;
    get cran(): JobLibraryCranOutputReference;
    putCran(value: JobLibraryCran): void;
    resetCran(): void;
    get cranInput(): JobLibraryCran | undefined;
    private _maven;
    get maven(): JobLibraryMavenOutputReference;
    putMaven(value: JobLibraryMaven): void;
    resetMaven(): void;
    get mavenInput(): JobLibraryMaven | undefined;
    private _pypi;
    get pypi(): JobLibraryPypiOutputReference;
    putPypi(value: JobLibraryPypi): void;
    resetPypi(): void;
    get pypiInput(): JobLibraryPypi | undefined;
}
export declare class JobLibraryList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: JobLibrary[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): JobLibraryOutputReference;
}
export interface JobNewClusterAutoscale {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#max_workers Job#max_workers}
    */
    readonly maxWorkers?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#min_workers Job#min_workers}
    */
    readonly minWorkers?: number;
}
export declare function jobNewClusterAutoscaleToTerraform(struct?: JobNewClusterAutoscaleOutputReference | JobNewClusterAutoscale): any;
export declare class JobNewClusterAutoscaleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobNewClusterAutoscale | undefined;
    set internalValue(value: JobNewClusterAutoscale | undefined);
    private _maxWorkers?;
    get maxWorkers(): number;
    set maxWorkers(value: number);
    resetMaxWorkers(): void;
    get maxWorkersInput(): number | undefined;
    private _minWorkers?;
    get minWorkers(): number;
    set minWorkers(value: number);
    resetMinWorkers(): void;
    get minWorkersInput(): number | undefined;
}
export interface JobNewClusterAwsAttributes {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#availability Job#availability}
    */
    readonly availability?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#ebs_volume_count Job#ebs_volume_count}
    */
    readonly ebsVolumeCount?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#ebs_volume_size Job#ebs_volume_size}
    */
    readonly ebsVolumeSize?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#ebs_volume_type Job#ebs_volume_type}
    */
    readonly ebsVolumeType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#first_on_demand Job#first_on_demand}
    */
    readonly firstOnDemand?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#instance_profile_arn Job#instance_profile_arn}
    */
    readonly instanceProfileArn?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#spot_bid_price_percent Job#spot_bid_price_percent}
    */
    readonly spotBidPricePercent?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#zone_id Job#zone_id}
    */
    readonly zoneId?: string;
}
export declare function jobNewClusterAwsAttributesToTerraform(struct?: JobNewClusterAwsAttributesOutputReference | JobNewClusterAwsAttributes): any;
export declare class JobNewClusterAwsAttributesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobNewClusterAwsAttributes | undefined;
    set internalValue(value: JobNewClusterAwsAttributes | undefined);
    private _availability?;
    get availability(): string;
    set availability(value: string);
    resetAvailability(): void;
    get availabilityInput(): string | undefined;
    private _ebsVolumeCount?;
    get ebsVolumeCount(): number;
    set ebsVolumeCount(value: number);
    resetEbsVolumeCount(): void;
    get ebsVolumeCountInput(): number | undefined;
    private _ebsVolumeSize?;
    get ebsVolumeSize(): number;
    set ebsVolumeSize(value: number);
    resetEbsVolumeSize(): void;
    get ebsVolumeSizeInput(): number | undefined;
    private _ebsVolumeType?;
    get ebsVolumeType(): string;
    set ebsVolumeType(value: string);
    resetEbsVolumeType(): void;
    get ebsVolumeTypeInput(): string | undefined;
    private _firstOnDemand?;
    get firstOnDemand(): number;
    set firstOnDemand(value: number);
    resetFirstOnDemand(): void;
    get firstOnDemandInput(): number | undefined;
    private _instanceProfileArn?;
    get instanceProfileArn(): string;
    set instanceProfileArn(value: string);
    resetInstanceProfileArn(): void;
    get instanceProfileArnInput(): string | undefined;
    private _spotBidPricePercent?;
    get spotBidPricePercent(): number;
    set spotBidPricePercent(value: number);
    resetSpotBidPricePercent(): void;
    get spotBidPricePercentInput(): number | undefined;
    private _zoneId?;
    get zoneId(): string;
    set zoneId(value: string);
    resetZoneId(): void;
    get zoneIdInput(): string | undefined;
}
export interface JobNewClusterAzureAttributes {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#availability Job#availability}
    */
    readonly availability?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#first_on_demand Job#first_on_demand}
    */
    readonly firstOnDemand?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#spot_bid_max_price Job#spot_bid_max_price}
    */
    readonly spotBidMaxPrice?: number;
}
export declare function jobNewClusterAzureAttributesToTerraform(struct?: JobNewClusterAzureAttributesOutputReference | JobNewClusterAzureAttributes): any;
export declare class JobNewClusterAzureAttributesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobNewClusterAzureAttributes | undefined;
    set internalValue(value: JobNewClusterAzureAttributes | undefined);
    private _availability?;
    get availability(): string;
    set availability(value: string);
    resetAvailability(): void;
    get availabilityInput(): string | undefined;
    private _firstOnDemand?;
    get firstOnDemand(): number;
    set firstOnDemand(value: number);
    resetFirstOnDemand(): void;
    get firstOnDemandInput(): number | undefined;
    private _spotBidMaxPrice?;
    get spotBidMaxPrice(): number;
    set spotBidMaxPrice(value: number);
    resetSpotBidMaxPrice(): void;
    get spotBidMaxPriceInput(): number | undefined;
}
export interface JobNewClusterClusterLogConfDbfs {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#destination Job#destination}
    */
    readonly destination: string;
}
export declare function jobNewClusterClusterLogConfDbfsToTerraform(struct?: JobNewClusterClusterLogConfDbfsOutputReference | JobNewClusterClusterLogConfDbfs): any;
export declare class JobNewClusterClusterLogConfDbfsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobNewClusterClusterLogConfDbfs | undefined;
    set internalValue(value: JobNewClusterClusterLogConfDbfs | undefined);
    private _destination?;
    get destination(): string;
    set destination(value: string);
    get destinationInput(): string | undefined;
}
export interface JobNewClusterClusterLogConfS3 {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#canned_acl Job#canned_acl}
    */
    readonly cannedAcl?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#destination Job#destination}
    */
    readonly destination: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#enable_encryption Job#enable_encryption}
    */
    readonly enableEncryption?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#encryption_type Job#encryption_type}
    */
    readonly encryptionType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#endpoint Job#endpoint}
    */
    readonly endpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#kms_key Job#kms_key}
    */
    readonly kmsKey?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#region Job#region}
    */
    readonly region?: string;
}
export declare function jobNewClusterClusterLogConfS3ToTerraform(struct?: JobNewClusterClusterLogConfS3OutputReference | JobNewClusterClusterLogConfS3): any;
export declare class JobNewClusterClusterLogConfS3OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobNewClusterClusterLogConfS3 | undefined;
    set internalValue(value: JobNewClusterClusterLogConfS3 | undefined);
    private _cannedAcl?;
    get cannedAcl(): string;
    set cannedAcl(value: string);
    resetCannedAcl(): void;
    get cannedAclInput(): string | undefined;
    private _destination?;
    get destination(): string;
    set destination(value: string);
    get destinationInput(): string | undefined;
    private _enableEncryption?;
    get enableEncryption(): boolean | cdktf.IResolvable;
    set enableEncryption(value: boolean | cdktf.IResolvable);
    resetEnableEncryption(): void;
    get enableEncryptionInput(): boolean | cdktf.IResolvable | undefined;
    private _encryptionType?;
    get encryptionType(): string;
    set encryptionType(value: string);
    resetEncryptionType(): void;
    get encryptionTypeInput(): string | undefined;
    private _endpoint?;
    get endpoint(): string;
    set endpoint(value: string);
    resetEndpoint(): void;
    get endpointInput(): string | undefined;
    private _kmsKey?;
    get kmsKey(): string;
    set kmsKey(value: string);
    resetKmsKey(): void;
    get kmsKeyInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
}
export interface JobNewClusterClusterLogConf {
    /**
    * dbfs block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#dbfs Job#dbfs}
    */
    readonly dbfs?: JobNewClusterClusterLogConfDbfs;
    /**
    * s3 block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#s3 Job#s3}
    */
    readonly s3?: JobNewClusterClusterLogConfS3;
}
export declare function jobNewClusterClusterLogConfToTerraform(struct?: JobNewClusterClusterLogConfOutputReference | JobNewClusterClusterLogConf): any;
export declare class JobNewClusterClusterLogConfOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobNewClusterClusterLogConf | undefined;
    set internalValue(value: JobNewClusterClusterLogConf | undefined);
    private _dbfs;
    get dbfs(): JobNewClusterClusterLogConfDbfsOutputReference;
    putDbfs(value: JobNewClusterClusterLogConfDbfs): void;
    resetDbfs(): void;
    get dbfsInput(): JobNewClusterClusterLogConfDbfs | undefined;
    private _s3;
    get s3(): JobNewClusterClusterLogConfS3OutputReference;
    putS3(value: JobNewClusterClusterLogConfS3): void;
    resetS3(): void;
    get s3Input(): JobNewClusterClusterLogConfS3 | undefined;
}
export interface JobNewClusterClusterMountInfoNetworkFilesystemInfo {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#mount_options Job#mount_options}
    */
    readonly mountOptions?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#server_address Job#server_address}
    */
    readonly serverAddress: string;
}
export declare function jobNewClusterClusterMountInfoNetworkFilesystemInfoToTerraform(struct?: JobNewClusterClusterMountInfoNetworkFilesystemInfoOutputReference | JobNewClusterClusterMountInfoNetworkFilesystemInfo): any;
export declare class JobNewClusterClusterMountInfoNetworkFilesystemInfoOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobNewClusterClusterMountInfoNetworkFilesystemInfo | undefined;
    set internalValue(value: JobNewClusterClusterMountInfoNetworkFilesystemInfo | undefined);
    private _mountOptions?;
    get mountOptions(): string;
    set mountOptions(value: string);
    resetMountOptions(): void;
    get mountOptionsInput(): string | undefined;
    private _serverAddress?;
    get serverAddress(): string;
    set serverAddress(value: string);
    get serverAddressInput(): string | undefined;
}
export interface JobNewClusterClusterMountInfo {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#local_mount_dir_path Job#local_mount_dir_path}
    */
    readonly localMountDirPath: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#remote_mount_dir_path Job#remote_mount_dir_path}
    */
    readonly remoteMountDirPath?: string;
    /**
    * network_filesystem_info block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#network_filesystem_info Job#network_filesystem_info}
    */
    readonly networkFilesystemInfo: JobNewClusterClusterMountInfoNetworkFilesystemInfo;
}
export declare function jobNewClusterClusterMountInfoToTerraform(struct?: JobNewClusterClusterMountInfo | cdktf.IResolvable): any;
export declare class JobNewClusterClusterMountInfoOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): JobNewClusterClusterMountInfo | cdktf.IResolvable | undefined;
    set internalValue(value: JobNewClusterClusterMountInfo | cdktf.IResolvable | undefined);
    private _localMountDirPath?;
    get localMountDirPath(): string;
    set localMountDirPath(value: string);
    get localMountDirPathInput(): string | undefined;
    private _remoteMountDirPath?;
    get remoteMountDirPath(): string;
    set remoteMountDirPath(value: string);
    resetRemoteMountDirPath(): void;
    get remoteMountDirPathInput(): string | undefined;
    private _networkFilesystemInfo;
    get networkFilesystemInfo(): JobNewClusterClusterMountInfoNetworkFilesystemInfoOutputReference;
    putNetworkFilesystemInfo(value: JobNewClusterClusterMountInfoNetworkFilesystemInfo): void;
    get networkFilesystemInfoInput(): JobNewClusterClusterMountInfoNetworkFilesystemInfo | undefined;
}
export declare class JobNewClusterClusterMountInfoList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: JobNewClusterClusterMountInfo[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): JobNewClusterClusterMountInfoOutputReference;
}
export interface JobNewClusterDockerImageBasicAuth {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#password Job#password}
    */
    readonly password: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#username Job#username}
    */
    readonly username: string;
}
export declare function jobNewClusterDockerImageBasicAuthToTerraform(struct?: JobNewClusterDockerImageBasicAuthOutputReference | JobNewClusterDockerImageBasicAuth): any;
export declare class JobNewClusterDockerImageBasicAuthOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobNewClusterDockerImageBasicAuth | undefined;
    set internalValue(value: JobNewClusterDockerImageBasicAuth | undefined);
    private _password?;
    get password(): string;
    set password(value: string);
    get passwordInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
}
export interface JobNewClusterDockerImage {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#url Job#url}
    */
    readonly url: string;
    /**
    * basic_auth block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#basic_auth Job#basic_auth}
    */
    readonly basicAuth?: JobNewClusterDockerImageBasicAuth;
}
export declare function jobNewClusterDockerImageToTerraform(struct?: JobNewClusterDockerImageOutputReference | JobNewClusterDockerImage): any;
export declare class JobNewClusterDockerImageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobNewClusterDockerImage | undefined;
    set internalValue(value: JobNewClusterDockerImage | undefined);
    private _url?;
    get url(): string;
    set url(value: string);
    get urlInput(): string | undefined;
    private _basicAuth;
    get basicAuth(): JobNewClusterDockerImageBasicAuthOutputReference;
    putBasicAuth(value: JobNewClusterDockerImageBasicAuth): void;
    resetBasicAuth(): void;
    get basicAuthInput(): JobNewClusterDockerImageBasicAuth | undefined;
}
export interface JobNewClusterGcpAttributes {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#availability Job#availability}
    */
    readonly availability?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#boot_disk_size Job#boot_disk_size}
    */
    readonly bootDiskSize?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#google_service_account Job#google_service_account}
    */
    readonly googleServiceAccount?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#use_preemptible_executors Job#use_preemptible_executors}
    */
    readonly usePreemptibleExecutors?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#zone_id Job#zone_id}
    */
    readonly zoneId?: string;
}
export declare function jobNewClusterGcpAttributesToTerraform(struct?: JobNewClusterGcpAttributesOutputReference | JobNewClusterGcpAttributes): any;
export declare class JobNewClusterGcpAttributesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobNewClusterGcpAttributes | undefined;
    set internalValue(value: JobNewClusterGcpAttributes | undefined);
    private _availability?;
    get availability(): string;
    set availability(value: string);
    resetAvailability(): void;
    get availabilityInput(): string | undefined;
    private _bootDiskSize?;
    get bootDiskSize(): number;
    set bootDiskSize(value: number);
    resetBootDiskSize(): void;
    get bootDiskSizeInput(): number | undefined;
    private _googleServiceAccount?;
    get googleServiceAccount(): string;
    set googleServiceAccount(value: string);
    resetGoogleServiceAccount(): void;
    get googleServiceAccountInput(): string | undefined;
    private _usePreemptibleExecutors?;
    get usePreemptibleExecutors(): boolean | cdktf.IResolvable;
    set usePreemptibleExecutors(value: boolean | cdktf.IResolvable);
    resetUsePreemptibleExecutors(): void;
    get usePreemptibleExecutorsInput(): boolean | cdktf.IResolvable | undefined;
    private _zoneId?;
    get zoneId(): string;
    set zoneId(value: string);
    resetZoneId(): void;
    get zoneIdInput(): string | undefined;
}
export interface JobNewClusterInitScriptsAbfss {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#destination Job#destination}
    */
    readonly destination?: string;
}
export declare function jobNewClusterInitScriptsAbfssToTerraform(struct?: JobNewClusterInitScriptsAbfssOutputReference | JobNewClusterInitScriptsAbfss): any;
export declare class JobNewClusterInitScriptsAbfssOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobNewClusterInitScriptsAbfss | undefined;
    set internalValue(value: JobNewClusterInitScriptsAbfss | undefined);
    private _destination?;
    get destination(): string;
    set destination(value: string);
    resetDestination(): void;
    get destinationInput(): string | undefined;
}
export interface JobNewClusterInitScriptsDbfs {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#destination Job#destination}
    */
    readonly destination: string;
}
export declare function jobNewClusterInitScriptsDbfsToTerraform(struct?: JobNewClusterInitScriptsDbfsOutputReference | JobNewClusterInitScriptsDbfs): any;
export declare class JobNewClusterInitScriptsDbfsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobNewClusterInitScriptsDbfs | undefined;
    set internalValue(value: JobNewClusterInitScriptsDbfs | undefined);
    private _destination?;
    get destination(): string;
    set destination(value: string);
    get destinationInput(): string | undefined;
}
export interface JobNewClusterInitScriptsFile {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#destination Job#destination}
    */
    readonly destination?: string;
}
export declare function jobNewClusterInitScriptsFileToTerraform(struct?: JobNewClusterInitScriptsFileOutputReference | JobNewClusterInitScriptsFile): any;
export declare class JobNewClusterInitScriptsFileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobNewClusterInitScriptsFile | undefined;
    set internalValue(value: JobNewClusterInitScriptsFile | undefined);
    private _destination?;
    get destination(): string;
    set destination(value: string);
    resetDestination(): void;
    get destinationInput(): string | undefined;
}
export interface JobNewClusterInitScriptsGcs {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#destination Job#destination}
    */
    readonly destination?: string;
}
export declare function jobNewClusterInitScriptsGcsToTerraform(struct?: JobNewClusterInitScriptsGcsOutputReference | JobNewClusterInitScriptsGcs): any;
export declare class JobNewClusterInitScriptsGcsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobNewClusterInitScriptsGcs | undefined;
    set internalValue(value: JobNewClusterInitScriptsGcs | undefined);
    private _destination?;
    get destination(): string;
    set destination(value: string);
    resetDestination(): void;
    get destinationInput(): string | undefined;
}
export interface JobNewClusterInitScriptsS3 {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#canned_acl Job#canned_acl}
    */
    readonly cannedAcl?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#destination Job#destination}
    */
    readonly destination: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#enable_encryption Job#enable_encryption}
    */
    readonly enableEncryption?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#encryption_type Job#encryption_type}
    */
    readonly encryptionType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#endpoint Job#endpoint}
    */
    readonly endpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#kms_key Job#kms_key}
    */
    readonly kmsKey?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#region Job#region}
    */
    readonly region?: string;
}
export declare function jobNewClusterInitScriptsS3ToTerraform(struct?: JobNewClusterInitScriptsS3OutputReference | JobNewClusterInitScriptsS3): any;
export declare class JobNewClusterInitScriptsS3OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobNewClusterInitScriptsS3 | undefined;
    set internalValue(value: JobNewClusterInitScriptsS3 | undefined);
    private _cannedAcl?;
    get cannedAcl(): string;
    set cannedAcl(value: string);
    resetCannedAcl(): void;
    get cannedAclInput(): string | undefined;
    private _destination?;
    get destination(): string;
    set destination(value: string);
    get destinationInput(): string | undefined;
    private _enableEncryption?;
    get enableEncryption(): boolean | cdktf.IResolvable;
    set enableEncryption(value: boolean | cdktf.IResolvable);
    resetEnableEncryption(): void;
    get enableEncryptionInput(): boolean | cdktf.IResolvable | undefined;
    private _encryptionType?;
    get encryptionType(): string;
    set encryptionType(value: string);
    resetEncryptionType(): void;
    get encryptionTypeInput(): string | undefined;
    private _endpoint?;
    get endpoint(): string;
    set endpoint(value: string);
    resetEndpoint(): void;
    get endpointInput(): string | undefined;
    private _kmsKey?;
    get kmsKey(): string;
    set kmsKey(value: string);
    resetKmsKey(): void;
    get kmsKeyInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
}
export interface JobNewClusterInitScripts {
    /**
    * abfss block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#abfss Job#abfss}
    */
    readonly abfss?: JobNewClusterInitScriptsAbfss;
    /**
    * dbfs block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#dbfs Job#dbfs}
    */
    readonly dbfs?: JobNewClusterInitScriptsDbfs;
    /**
    * file block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#file Job#file}
    */
    readonly file?: JobNewClusterInitScriptsFile;
    /**
    * gcs block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#gcs Job#gcs}
    */
    readonly gcs?: JobNewClusterInitScriptsGcs;
    /**
    * s3 block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#s3 Job#s3}
    */
    readonly s3?: JobNewClusterInitScriptsS3;
}
export declare function jobNewClusterInitScriptsToTerraform(struct?: JobNewClusterInitScripts | cdktf.IResolvable): any;
export declare class JobNewClusterInitScriptsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): JobNewClusterInitScripts | cdktf.IResolvable | undefined;
    set internalValue(value: JobNewClusterInitScripts | cdktf.IResolvable | undefined);
    private _abfss;
    get abfss(): JobNewClusterInitScriptsAbfssOutputReference;
    putAbfss(value: JobNewClusterInitScriptsAbfss): void;
    resetAbfss(): void;
    get abfssInput(): JobNewClusterInitScriptsAbfss | undefined;
    private _dbfs;
    get dbfs(): JobNewClusterInitScriptsDbfsOutputReference;
    putDbfs(value: JobNewClusterInitScriptsDbfs): void;
    resetDbfs(): void;
    get dbfsInput(): JobNewClusterInitScriptsDbfs | undefined;
    private _file;
    get file(): JobNewClusterInitScriptsFileOutputReference;
    putFile(value: JobNewClusterInitScriptsFile): void;
    resetFile(): void;
    get fileInput(): JobNewClusterInitScriptsFile | undefined;
    private _gcs;
    get gcs(): JobNewClusterInitScriptsGcsOutputReference;
    putGcs(value: JobNewClusterInitScriptsGcs): void;
    resetGcs(): void;
    get gcsInput(): JobNewClusterInitScriptsGcs | undefined;
    private _s3;
    get s3(): JobNewClusterInitScriptsS3OutputReference;
    putS3(value: JobNewClusterInitScriptsS3): void;
    resetS3(): void;
    get s3Input(): JobNewClusterInitScriptsS3 | undefined;
}
export declare class JobNewClusterInitScriptsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: JobNewClusterInitScripts[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): JobNewClusterInitScriptsOutputReference;
}
export interface JobNewClusterWorkloadTypeClients {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#jobs Job#jobs}
    */
    readonly jobs?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#notebooks Job#notebooks}
    */
    readonly notebooks?: boolean | cdktf.IResolvable;
}
export declare function jobNewClusterWorkloadTypeClientsToTerraform(struct?: JobNewClusterWorkloadTypeClientsOutputReference | JobNewClusterWorkloadTypeClients): any;
export declare class JobNewClusterWorkloadTypeClientsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobNewClusterWorkloadTypeClients | undefined;
    set internalValue(value: JobNewClusterWorkloadTypeClients | undefined);
    private _jobs?;
    get jobs(): boolean | cdktf.IResolvable;
    set jobs(value: boolean | cdktf.IResolvable);
    resetJobs(): void;
    get jobsInput(): boolean | cdktf.IResolvable | undefined;
    private _notebooks?;
    get notebooks(): boolean | cdktf.IResolvable;
    set notebooks(value: boolean | cdktf.IResolvable);
    resetNotebooks(): void;
    get notebooksInput(): boolean | cdktf.IResolvable | undefined;
}
export interface JobNewClusterWorkloadType {
    /**
    * clients block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#clients Job#clients}
    */
    readonly clients: JobNewClusterWorkloadTypeClients;
}
export declare function jobNewClusterWorkloadTypeToTerraform(struct?: JobNewClusterWorkloadTypeOutputReference | JobNewClusterWorkloadType): any;
export declare class JobNewClusterWorkloadTypeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobNewClusterWorkloadType | undefined;
    set internalValue(value: JobNewClusterWorkloadType | undefined);
    private _clients;
    get clients(): JobNewClusterWorkloadTypeClientsOutputReference;
    putClients(value: JobNewClusterWorkloadTypeClients): void;
    get clientsInput(): JobNewClusterWorkloadTypeClients | undefined;
}
export interface JobNewCluster {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#apply_policy_default_values Job#apply_policy_default_values}
    */
    readonly applyPolicyDefaultValues?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#autotermination_minutes Job#autotermination_minutes}
    */
    readonly autoterminationMinutes?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#cluster_id Job#cluster_id}
    */
    readonly clusterId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#cluster_name Job#cluster_name}
    */
    readonly clusterName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#custom_tags Job#custom_tags}
    */
    readonly customTags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#data_security_mode Job#data_security_mode}
    */
    readonly dataSecurityMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#driver_instance_pool_id Job#driver_instance_pool_id}
    */
    readonly driverInstancePoolId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#driver_node_type_id Job#driver_node_type_id}
    */
    readonly driverNodeTypeId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#enable_elastic_disk Job#enable_elastic_disk}
    */
    readonly enableElasticDisk?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#enable_local_disk_encryption Job#enable_local_disk_encryption}
    */
    readonly enableLocalDiskEncryption?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#idempotency_token Job#idempotency_token}
    */
    readonly idempotencyToken?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#instance_pool_id Job#instance_pool_id}
    */
    readonly instancePoolId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#node_type_id Job#node_type_id}
    */
    readonly nodeTypeId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#num_workers Job#num_workers}
    */
    readonly numWorkers?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#policy_id Job#policy_id}
    */
    readonly policyId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#runtime_engine Job#runtime_engine}
    */
    readonly runtimeEngine?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#single_user_name Job#single_user_name}
    */
    readonly singleUserName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#spark_conf Job#spark_conf}
    */
    readonly sparkConf?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#spark_env_vars Job#spark_env_vars}
    */
    readonly sparkEnvVars?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#spark_version Job#spark_version}
    */
    readonly sparkVersion: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#ssh_public_keys Job#ssh_public_keys}
    */
    readonly sshPublicKeys?: string[];
    /**
    * autoscale block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#autoscale Job#autoscale}
    */
    readonly autoscale?: JobNewClusterAutoscale;
    /**
    * aws_attributes block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#aws_attributes Job#aws_attributes}
    */
    readonly awsAttributes?: JobNewClusterAwsAttributes;
    /**
    * azure_attributes block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#azure_attributes Job#azure_attributes}
    */
    readonly azureAttributes?: JobNewClusterAzureAttributes;
    /**
    * cluster_log_conf block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#cluster_log_conf Job#cluster_log_conf}
    */
    readonly clusterLogConf?: JobNewClusterClusterLogConf;
    /**
    * cluster_mount_info block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#cluster_mount_info Job#cluster_mount_info}
    */
    readonly clusterMountInfo?: JobNewClusterClusterMountInfo[] | cdktf.IResolvable;
    /**
    * docker_image block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#docker_image Job#docker_image}
    */
    readonly dockerImage?: JobNewClusterDockerImage;
    /**
    * gcp_attributes block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#gcp_attributes Job#gcp_attributes}
    */
    readonly gcpAttributes?: JobNewClusterGcpAttributes;
    /**
    * init_scripts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#init_scripts Job#init_scripts}
    */
    readonly initScripts?: JobNewClusterInitScripts[] | cdktf.IResolvable;
    /**
    * workload_type block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#workload_type Job#workload_type}
    */
    readonly workloadType?: JobNewClusterWorkloadType;
}
export declare function jobNewClusterToTerraform(struct?: JobNewClusterOutputReference | JobNewCluster): any;
export declare class JobNewClusterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobNewCluster | undefined;
    set internalValue(value: JobNewCluster | undefined);
    private _applyPolicyDefaultValues?;
    get applyPolicyDefaultValues(): boolean | cdktf.IResolvable;
    set applyPolicyDefaultValues(value: boolean | cdktf.IResolvable);
    resetApplyPolicyDefaultValues(): void;
    get applyPolicyDefaultValuesInput(): boolean | cdktf.IResolvable | undefined;
    private _autoterminationMinutes?;
    get autoterminationMinutes(): number;
    set autoterminationMinutes(value: number);
    resetAutoterminationMinutes(): void;
    get autoterminationMinutesInput(): number | undefined;
    private _clusterId?;
    get clusterId(): string;
    set clusterId(value: string);
    resetClusterId(): void;
    get clusterIdInput(): string | undefined;
    private _clusterName?;
    get clusterName(): string;
    set clusterName(value: string);
    resetClusterName(): void;
    get clusterNameInput(): string | undefined;
    private _customTags?;
    get customTags(): {
        [key: string]: string;
    };
    set customTags(value: {
        [key: string]: string;
    });
    resetCustomTags(): void;
    get customTagsInput(): {
        [key: string]: string;
    } | undefined;
    private _dataSecurityMode?;
    get dataSecurityMode(): string;
    set dataSecurityMode(value: string);
    resetDataSecurityMode(): void;
    get dataSecurityModeInput(): string | undefined;
    private _driverInstancePoolId?;
    get driverInstancePoolId(): string;
    set driverInstancePoolId(value: string);
    resetDriverInstancePoolId(): void;
    get driverInstancePoolIdInput(): string | undefined;
    private _driverNodeTypeId?;
    get driverNodeTypeId(): string;
    set driverNodeTypeId(value: string);
    resetDriverNodeTypeId(): void;
    get driverNodeTypeIdInput(): string | undefined;
    private _enableElasticDisk?;
    get enableElasticDisk(): boolean | cdktf.IResolvable;
    set enableElasticDisk(value: boolean | cdktf.IResolvable);
    resetEnableElasticDisk(): void;
    get enableElasticDiskInput(): boolean | cdktf.IResolvable | undefined;
    private _enableLocalDiskEncryption?;
    get enableLocalDiskEncryption(): boolean | cdktf.IResolvable;
    set enableLocalDiskEncryption(value: boolean | cdktf.IResolvable);
    resetEnableLocalDiskEncryption(): void;
    get enableLocalDiskEncryptionInput(): boolean | cdktf.IResolvable | undefined;
    private _idempotencyToken?;
    get idempotencyToken(): string;
    set idempotencyToken(value: string);
    resetIdempotencyToken(): void;
    get idempotencyTokenInput(): string | undefined;
    private _instancePoolId?;
    get instancePoolId(): string;
    set instancePoolId(value: string);
    resetInstancePoolId(): void;
    get instancePoolIdInput(): string | undefined;
    private _nodeTypeId?;
    get nodeTypeId(): string;
    set nodeTypeId(value: string);
    resetNodeTypeId(): void;
    get nodeTypeIdInput(): string | undefined;
    private _numWorkers?;
    get numWorkers(): number;
    set numWorkers(value: number);
    resetNumWorkers(): void;
    get numWorkersInput(): number | undefined;
    private _policyId?;
    get policyId(): string;
    set policyId(value: string);
    resetPolicyId(): void;
    get policyIdInput(): string | undefined;
    private _runtimeEngine?;
    get runtimeEngine(): string;
    set runtimeEngine(value: string);
    resetRuntimeEngine(): void;
    get runtimeEngineInput(): string | undefined;
    private _singleUserName?;
    get singleUserName(): string;
    set singleUserName(value: string);
    resetSingleUserName(): void;
    get singleUserNameInput(): string | undefined;
    private _sparkConf?;
    get sparkConf(): {
        [key: string]: string;
    };
    set sparkConf(value: {
        [key: string]: string;
    });
    resetSparkConf(): void;
    get sparkConfInput(): {
        [key: string]: string;
    } | undefined;
    private _sparkEnvVars?;
    get sparkEnvVars(): {
        [key: string]: string;
    };
    set sparkEnvVars(value: {
        [key: string]: string;
    });
    resetSparkEnvVars(): void;
    get sparkEnvVarsInput(): {
        [key: string]: string;
    } | undefined;
    private _sparkVersion?;
    get sparkVersion(): string;
    set sparkVersion(value: string);
    get sparkVersionInput(): string | undefined;
    private _sshPublicKeys?;
    get sshPublicKeys(): string[];
    set sshPublicKeys(value: string[]);
    resetSshPublicKeys(): void;
    get sshPublicKeysInput(): string[] | undefined;
    private _autoscale;
    get autoscale(): JobNewClusterAutoscaleOutputReference;
    putAutoscale(value: JobNewClusterAutoscale): void;
    resetAutoscale(): void;
    get autoscaleInput(): JobNewClusterAutoscale | undefined;
    private _awsAttributes;
    get awsAttributes(): JobNewClusterAwsAttributesOutputReference;
    putAwsAttributes(value: JobNewClusterAwsAttributes): void;
    resetAwsAttributes(): void;
    get awsAttributesInput(): JobNewClusterAwsAttributes | undefined;
    private _azureAttributes;
    get azureAttributes(): JobNewClusterAzureAttributesOutputReference;
    putAzureAttributes(value: JobNewClusterAzureAttributes): void;
    resetAzureAttributes(): void;
    get azureAttributesInput(): JobNewClusterAzureAttributes | undefined;
    private _clusterLogConf;
    get clusterLogConf(): JobNewClusterClusterLogConfOutputReference;
    putClusterLogConf(value: JobNewClusterClusterLogConf): void;
    resetClusterLogConf(): void;
    get clusterLogConfInput(): JobNewClusterClusterLogConf | undefined;
    private _clusterMountInfo;
    get clusterMountInfo(): JobNewClusterClusterMountInfoList;
    putClusterMountInfo(value: JobNewClusterClusterMountInfo[] | cdktf.IResolvable): void;
    resetClusterMountInfo(): void;
    get clusterMountInfoInput(): cdktf.IResolvable | JobNewClusterClusterMountInfo[] | undefined;
    private _dockerImage;
    get dockerImage(): JobNewClusterDockerImageOutputReference;
    putDockerImage(value: JobNewClusterDockerImage): void;
    resetDockerImage(): void;
    get dockerImageInput(): JobNewClusterDockerImage | undefined;
    private _gcpAttributes;
    get gcpAttributes(): JobNewClusterGcpAttributesOutputReference;
    putGcpAttributes(value: JobNewClusterGcpAttributes): void;
    resetGcpAttributes(): void;
    get gcpAttributesInput(): JobNewClusterGcpAttributes | undefined;
    private _initScripts;
    get initScripts(): JobNewClusterInitScriptsList;
    putInitScripts(value: JobNewClusterInitScripts[] | cdktf.IResolvable): void;
    resetInitScripts(): void;
    get initScriptsInput(): cdktf.IResolvable | JobNewClusterInitScripts[] | undefined;
    private _workloadType;
    get workloadType(): JobNewClusterWorkloadTypeOutputReference;
    putWorkloadType(value: JobNewClusterWorkloadType): void;
    resetWorkloadType(): void;
    get workloadTypeInput(): JobNewClusterWorkloadType | undefined;
}
export interface JobNotebookTask {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#base_parameters Job#base_parameters}
    */
    readonly baseParameters?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#notebook_path Job#notebook_path}
    */
    readonly notebookPath: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#source Job#source}
    */
    readonly source?: string;
}
export declare function jobNotebookTaskToTerraform(struct?: JobNotebookTaskOutputReference | JobNotebookTask): any;
export declare class JobNotebookTaskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobNotebookTask | undefined;
    set internalValue(value: JobNotebookTask | undefined);
    private _baseParameters?;
    get baseParameters(): {
        [key: string]: string;
    };
    set baseParameters(value: {
        [key: string]: string;
    });
    resetBaseParameters(): void;
    get baseParametersInput(): {
        [key: string]: string;
    } | undefined;
    private _notebookPath?;
    get notebookPath(): string;
    set notebookPath(value: string);
    get notebookPathInput(): string | undefined;
    private _source?;
    get source(): string;
    set source(value: string);
    resetSource(): void;
    get sourceInput(): string | undefined;
}
export interface JobPipelineTask {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#pipeline_id Job#pipeline_id}
    */
    readonly pipelineId: string;
}
export declare function jobPipelineTaskToTerraform(struct?: JobPipelineTaskOutputReference | JobPipelineTask): any;
export declare class JobPipelineTaskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobPipelineTask | undefined;
    set internalValue(value: JobPipelineTask | undefined);
    private _pipelineId?;
    get pipelineId(): string;
    set pipelineId(value: string);
    get pipelineIdInput(): string | undefined;
}
export interface JobPythonWheelTask {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#entry_point Job#entry_point}
    */
    readonly entryPoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#named_parameters Job#named_parameters}
    */
    readonly namedParameters?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#package_name Job#package_name}
    */
    readonly packageName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#parameters Job#parameters}
    */
    readonly parameters?: string[];
}
export declare function jobPythonWheelTaskToTerraform(struct?: JobPythonWheelTaskOutputReference | JobPythonWheelTask): any;
export declare class JobPythonWheelTaskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobPythonWheelTask | undefined;
    set internalValue(value: JobPythonWheelTask | undefined);
    private _entryPoint?;
    get entryPoint(): string;
    set entryPoint(value: string);
    resetEntryPoint(): void;
    get entryPointInput(): string | undefined;
    private _namedParameters?;
    get namedParameters(): {
        [key: string]: string;
    };
    set namedParameters(value: {
        [key: string]: string;
    });
    resetNamedParameters(): void;
    get namedParametersInput(): {
        [key: string]: string;
    } | undefined;
    private _packageName?;
    get packageName(): string;
    set packageName(value: string);
    resetPackageName(): void;
    get packageNameInput(): string | undefined;
    private _parameters?;
    get parameters(): string[];
    set parameters(value: string[]);
    resetParameters(): void;
    get parametersInput(): string[] | undefined;
}
export interface JobQueue {
}
export declare function jobQueueToTerraform(struct?: JobQueueOutputReference | JobQueue): any;
export declare class JobQueueOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobQueue | undefined;
    set internalValue(value: JobQueue | undefined);
}
export interface JobSchedule {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#pause_status Job#pause_status}
    */
    readonly pauseStatus?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#quartz_cron_expression Job#quartz_cron_expression}
    */
    readonly quartzCronExpression: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#timezone_id Job#timezone_id}
    */
    readonly timezoneId: string;
}
export declare function jobScheduleToTerraform(struct?: JobScheduleOutputReference | JobSchedule): any;
export declare class JobScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobSchedule | undefined;
    set internalValue(value: JobSchedule | undefined);
    private _pauseStatus?;
    get pauseStatus(): string;
    set pauseStatus(value: string);
    resetPauseStatus(): void;
    get pauseStatusInput(): string | undefined;
    private _quartzCronExpression?;
    get quartzCronExpression(): string;
    set quartzCronExpression(value: string);
    get quartzCronExpressionInput(): string | undefined;
    private _timezoneId?;
    get timezoneId(): string;
    set timezoneId(value: string);
    get timezoneIdInput(): string | undefined;
}
export interface JobSparkJarTask {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#jar_uri Job#jar_uri}
    */
    readonly jarUri?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#main_class_name Job#main_class_name}
    */
    readonly mainClassName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#parameters Job#parameters}
    */
    readonly parameters?: string[];
}
export declare function jobSparkJarTaskToTerraform(struct?: JobSparkJarTaskOutputReference | JobSparkJarTask): any;
export declare class JobSparkJarTaskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobSparkJarTask | undefined;
    set internalValue(value: JobSparkJarTask | undefined);
    private _jarUri?;
    get jarUri(): string;
    set jarUri(value: string);
    resetJarUri(): void;
    get jarUriInput(): string | undefined;
    private _mainClassName?;
    get mainClassName(): string;
    set mainClassName(value: string);
    resetMainClassName(): void;
    get mainClassNameInput(): string | undefined;
    private _parameters?;
    get parameters(): string[];
    set parameters(value: string[]);
    resetParameters(): void;
    get parametersInput(): string[] | undefined;
}
export interface JobSparkPythonTask {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#parameters Job#parameters}
    */
    readonly parameters?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#python_file Job#python_file}
    */
    readonly pythonFile: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#source Job#source}
    */
    readonly source?: string;
}
export declare function jobSparkPythonTaskToTerraform(struct?: JobSparkPythonTaskOutputReference | JobSparkPythonTask): any;
export declare class JobSparkPythonTaskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobSparkPythonTask | undefined;
    set internalValue(value: JobSparkPythonTask | undefined);
    private _parameters?;
    get parameters(): string[];
    set parameters(value: string[]);
    resetParameters(): void;
    get parametersInput(): string[] | undefined;
    private _pythonFile?;
    get pythonFile(): string;
    set pythonFile(value: string);
    get pythonFileInput(): string | undefined;
    private _source?;
    get source(): string;
    set source(value: string);
    resetSource(): void;
    get sourceInput(): string | undefined;
}
export interface JobSparkSubmitTask {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#parameters Job#parameters}
    */
    readonly parameters?: string[];
}
export declare function jobSparkSubmitTaskToTerraform(struct?: JobSparkSubmitTaskOutputReference | JobSparkSubmitTask): any;
export declare class JobSparkSubmitTaskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobSparkSubmitTask | undefined;
    set internalValue(value: JobSparkSubmitTask | undefined);
    private _parameters?;
    get parameters(): string[];
    set parameters(value: string[]);
    resetParameters(): void;
    get parametersInput(): string[] | undefined;
}
export interface JobTaskDbtTask {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#catalog Job#catalog}
    */
    readonly catalog?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#commands Job#commands}
    */
    readonly commands: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#profiles_directory Job#profiles_directory}
    */
    readonly profilesDirectory?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#project_directory Job#project_directory}
    */
    readonly projectDirectory?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#schema Job#schema}
    */
    readonly schema?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#warehouse_id Job#warehouse_id}
    */
    readonly warehouseId?: string;
}
export declare function jobTaskDbtTaskToTerraform(struct?: JobTaskDbtTaskOutputReference | JobTaskDbtTask): any;
export declare class JobTaskDbtTaskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobTaskDbtTask | undefined;
    set internalValue(value: JobTaskDbtTask | undefined);
    private _catalog?;
    get catalog(): string;
    set catalog(value: string);
    resetCatalog(): void;
    get catalogInput(): string | undefined;
    private _commands?;
    get commands(): string[];
    set commands(value: string[]);
    get commandsInput(): string[] | undefined;
    private _profilesDirectory?;
    get profilesDirectory(): string;
    set profilesDirectory(value: string);
    resetProfilesDirectory(): void;
    get profilesDirectoryInput(): string | undefined;
    private _projectDirectory?;
    get projectDirectory(): string;
    set projectDirectory(value: string);
    resetProjectDirectory(): void;
    get projectDirectoryInput(): string | undefined;
    private _schema?;
    get schema(): string;
    set schema(value: string);
    resetSchema(): void;
    get schemaInput(): string | undefined;
    private _warehouseId?;
    get warehouseId(): string;
    set warehouseId(value: string);
    resetWarehouseId(): void;
    get warehouseIdInput(): string | undefined;
}
export interface JobTaskDependsOn {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#task_key Job#task_key}
    */
    readonly taskKey?: string;
}
export declare function jobTaskDependsOnToTerraform(struct?: JobTaskDependsOn | cdktf.IResolvable): any;
export declare class JobTaskDependsOnOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): JobTaskDependsOn | cdktf.IResolvable | undefined;
    set internalValue(value: JobTaskDependsOn | cdktf.IResolvable | undefined);
    private _taskKey?;
    get taskKey(): string;
    set taskKey(value: string);
    resetTaskKey(): void;
    get taskKeyInput(): string | undefined;
}
export declare class JobTaskDependsOnList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: JobTaskDependsOn[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): JobTaskDependsOnOutputReference;
}
export interface JobTaskEmailNotifications {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#alert_on_last_attempt Job#alert_on_last_attempt}
    */
    readonly alertOnLastAttempt?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#no_alert_for_skipped_runs Job#no_alert_for_skipped_runs}
    */
    readonly noAlertForSkippedRuns?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#on_failure Job#on_failure}
    */
    readonly onFailure?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#on_start Job#on_start}
    */
    readonly onStart?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#on_success Job#on_success}
    */
    readonly onSuccess?: string[];
}
export declare function jobTaskEmailNotificationsToTerraform(struct?: JobTaskEmailNotificationsOutputReference | JobTaskEmailNotifications): any;
export declare class JobTaskEmailNotificationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobTaskEmailNotifications | undefined;
    set internalValue(value: JobTaskEmailNotifications | undefined);
    private _alertOnLastAttempt?;
    get alertOnLastAttempt(): boolean | cdktf.IResolvable;
    set alertOnLastAttempt(value: boolean | cdktf.IResolvable);
    resetAlertOnLastAttempt(): void;
    get alertOnLastAttemptInput(): boolean | cdktf.IResolvable | undefined;
    private _noAlertForSkippedRuns?;
    get noAlertForSkippedRuns(): boolean | cdktf.IResolvable;
    set noAlertForSkippedRuns(value: boolean | cdktf.IResolvable);
    resetNoAlertForSkippedRuns(): void;
    get noAlertForSkippedRunsInput(): boolean | cdktf.IResolvable | undefined;
    private _onFailure?;
    get onFailure(): string[];
    set onFailure(value: string[]);
    resetOnFailure(): void;
    get onFailureInput(): string[] | undefined;
    private _onStart?;
    get onStart(): string[];
    set onStart(value: string[]);
    resetOnStart(): void;
    get onStartInput(): string[] | undefined;
    private _onSuccess?;
    get onSuccess(): string[];
    set onSuccess(value: string[]);
    resetOnSuccess(): void;
    get onSuccessInput(): string[] | undefined;
}
export interface JobTaskLibraryCran {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#package Job#package}
    */
    readonly package: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#repo Job#repo}
    */
    readonly repo?: string;
}
export declare function jobTaskLibraryCranToTerraform(struct?: JobTaskLibraryCranOutputReference | JobTaskLibraryCran): any;
export declare class JobTaskLibraryCranOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobTaskLibraryCran | undefined;
    set internalValue(value: JobTaskLibraryCran | undefined);
    private _package?;
    get package(): string;
    set package(value: string);
    get packageInput(): string | undefined;
    private _repo?;
    get repo(): string;
    set repo(value: string);
    resetRepo(): void;
    get repoInput(): string | undefined;
}
export interface JobTaskLibraryMaven {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#coordinates Job#coordinates}
    */
    readonly coordinates: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#exclusions Job#exclusions}
    */
    readonly exclusions?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#repo Job#repo}
    */
    readonly repo?: string;
}
export declare function jobTaskLibraryMavenToTerraform(struct?: JobTaskLibraryMavenOutputReference | JobTaskLibraryMaven): any;
export declare class JobTaskLibraryMavenOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobTaskLibraryMaven | undefined;
    set internalValue(value: JobTaskLibraryMaven | undefined);
    private _coordinates?;
    get coordinates(): string;
    set coordinates(value: string);
    get coordinatesInput(): string | undefined;
    private _exclusions?;
    get exclusions(): string[];
    set exclusions(value: string[]);
    resetExclusions(): void;
    get exclusionsInput(): string[] | undefined;
    private _repo?;
    get repo(): string;
    set repo(value: string);
    resetRepo(): void;
    get repoInput(): string | undefined;
}
export interface JobTaskLibraryPypi {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#package Job#package}
    */
    readonly package: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#repo Job#repo}
    */
    readonly repo?: string;
}
export declare function jobTaskLibraryPypiToTerraform(struct?: JobTaskLibraryPypiOutputReference | JobTaskLibraryPypi): any;
export declare class JobTaskLibraryPypiOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobTaskLibraryPypi | undefined;
    set internalValue(value: JobTaskLibraryPypi | undefined);
    private _package?;
    get package(): string;
    set package(value: string);
    get packageInput(): string | undefined;
    private _repo?;
    get repo(): string;
    set repo(value: string);
    resetRepo(): void;
    get repoInput(): string | undefined;
}
export interface JobTaskLibrary {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#egg Job#egg}
    */
    readonly egg?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#jar Job#jar}
    */
    readonly jar?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#whl Job#whl}
    */
    readonly whl?: string;
    /**
    * cran block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#cran Job#cran}
    */
    readonly cran?: JobTaskLibraryCran;
    /**
    * maven block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#maven Job#maven}
    */
    readonly maven?: JobTaskLibraryMaven;
    /**
    * pypi block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#pypi Job#pypi}
    */
    readonly pypi?: JobTaskLibraryPypi;
}
export declare function jobTaskLibraryToTerraform(struct?: JobTaskLibrary | cdktf.IResolvable): any;
export declare class JobTaskLibraryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): JobTaskLibrary | cdktf.IResolvable | undefined;
    set internalValue(value: JobTaskLibrary | cdktf.IResolvable | undefined);
    private _egg?;
    get egg(): string;
    set egg(value: string);
    resetEgg(): void;
    get eggInput(): string | undefined;
    private _jar?;
    get jar(): string;
    set jar(value: string);
    resetJar(): void;
    get jarInput(): string | undefined;
    private _whl?;
    get whl(): string;
    set whl(value: string);
    resetWhl(): void;
    get whlInput(): string | undefined;
    private _cran;
    get cran(): JobTaskLibraryCranOutputReference;
    putCran(value: JobTaskLibraryCran): void;
    resetCran(): void;
    get cranInput(): JobTaskLibraryCran | undefined;
    private _maven;
    get maven(): JobTaskLibraryMavenOutputReference;
    putMaven(value: JobTaskLibraryMaven): void;
    resetMaven(): void;
    get mavenInput(): JobTaskLibraryMaven | undefined;
    private _pypi;
    get pypi(): JobTaskLibraryPypiOutputReference;
    putPypi(value: JobTaskLibraryPypi): void;
    resetPypi(): void;
    get pypiInput(): JobTaskLibraryPypi | undefined;
}
export declare class JobTaskLibraryList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: JobTaskLibrary[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): JobTaskLibraryOutputReference;
}
export interface JobTaskNewClusterAutoscale {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#max_workers Job#max_workers}
    */
    readonly maxWorkers?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#min_workers Job#min_workers}
    */
    readonly minWorkers?: number;
}
export declare function jobTaskNewClusterAutoscaleToTerraform(struct?: JobTaskNewClusterAutoscaleOutputReference | JobTaskNewClusterAutoscale): any;
export declare class JobTaskNewClusterAutoscaleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobTaskNewClusterAutoscale | undefined;
    set internalValue(value: JobTaskNewClusterAutoscale | undefined);
    private _maxWorkers?;
    get maxWorkers(): number;
    set maxWorkers(value: number);
    resetMaxWorkers(): void;
    get maxWorkersInput(): number | undefined;
    private _minWorkers?;
    get minWorkers(): number;
    set minWorkers(value: number);
    resetMinWorkers(): void;
    get minWorkersInput(): number | undefined;
}
export interface JobTaskNewClusterAwsAttributes {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#availability Job#availability}
    */
    readonly availability?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#ebs_volume_count Job#ebs_volume_count}
    */
    readonly ebsVolumeCount?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#ebs_volume_size Job#ebs_volume_size}
    */
    readonly ebsVolumeSize?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#ebs_volume_type Job#ebs_volume_type}
    */
    readonly ebsVolumeType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#first_on_demand Job#first_on_demand}
    */
    readonly firstOnDemand?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#instance_profile_arn Job#instance_profile_arn}
    */
    readonly instanceProfileArn?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#spot_bid_price_percent Job#spot_bid_price_percent}
    */
    readonly spotBidPricePercent?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#zone_id Job#zone_id}
    */
    readonly zoneId?: string;
}
export declare function jobTaskNewClusterAwsAttributesToTerraform(struct?: JobTaskNewClusterAwsAttributesOutputReference | JobTaskNewClusterAwsAttributes): any;
export declare class JobTaskNewClusterAwsAttributesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobTaskNewClusterAwsAttributes | undefined;
    set internalValue(value: JobTaskNewClusterAwsAttributes | undefined);
    private _availability?;
    get availability(): string;
    set availability(value: string);
    resetAvailability(): void;
    get availabilityInput(): string | undefined;
    private _ebsVolumeCount?;
    get ebsVolumeCount(): number;
    set ebsVolumeCount(value: number);
    resetEbsVolumeCount(): void;
    get ebsVolumeCountInput(): number | undefined;
    private _ebsVolumeSize?;
    get ebsVolumeSize(): number;
    set ebsVolumeSize(value: number);
    resetEbsVolumeSize(): void;
    get ebsVolumeSizeInput(): number | undefined;
    private _ebsVolumeType?;
    get ebsVolumeType(): string;
    set ebsVolumeType(value: string);
    resetEbsVolumeType(): void;
    get ebsVolumeTypeInput(): string | undefined;
    private _firstOnDemand?;
    get firstOnDemand(): number;
    set firstOnDemand(value: number);
    resetFirstOnDemand(): void;
    get firstOnDemandInput(): number | undefined;
    private _instanceProfileArn?;
    get instanceProfileArn(): string;
    set instanceProfileArn(value: string);
    resetInstanceProfileArn(): void;
    get instanceProfileArnInput(): string | undefined;
    private _spotBidPricePercent?;
    get spotBidPricePercent(): number;
    set spotBidPricePercent(value: number);
    resetSpotBidPricePercent(): void;
    get spotBidPricePercentInput(): number | undefined;
    private _zoneId?;
    get zoneId(): string;
    set zoneId(value: string);
    resetZoneId(): void;
    get zoneIdInput(): string | undefined;
}
export interface JobTaskNewClusterAzureAttributes {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#availability Job#availability}
    */
    readonly availability?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#first_on_demand Job#first_on_demand}
    */
    readonly firstOnDemand?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#spot_bid_max_price Job#spot_bid_max_price}
    */
    readonly spotBidMaxPrice?: number;
}
export declare function jobTaskNewClusterAzureAttributesToTerraform(struct?: JobTaskNewClusterAzureAttributesOutputReference | JobTaskNewClusterAzureAttributes): any;
export declare class JobTaskNewClusterAzureAttributesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobTaskNewClusterAzureAttributes | undefined;
    set internalValue(value: JobTaskNewClusterAzureAttributes | undefined);
    private _availability?;
    get availability(): string;
    set availability(value: string);
    resetAvailability(): void;
    get availabilityInput(): string | undefined;
    private _firstOnDemand?;
    get firstOnDemand(): number;
    set firstOnDemand(value: number);
    resetFirstOnDemand(): void;
    get firstOnDemandInput(): number | undefined;
    private _spotBidMaxPrice?;
    get spotBidMaxPrice(): number;
    set spotBidMaxPrice(value: number);
    resetSpotBidMaxPrice(): void;
    get spotBidMaxPriceInput(): number | undefined;
}
export interface JobTaskNewClusterClusterLogConfDbfs {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#destination Job#destination}
    */
    readonly destination: string;
}
export declare function jobTaskNewClusterClusterLogConfDbfsToTerraform(struct?: JobTaskNewClusterClusterLogConfDbfsOutputReference | JobTaskNewClusterClusterLogConfDbfs): any;
export declare class JobTaskNewClusterClusterLogConfDbfsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobTaskNewClusterClusterLogConfDbfs | undefined;
    set internalValue(value: JobTaskNewClusterClusterLogConfDbfs | undefined);
    private _destination?;
    get destination(): string;
    set destination(value: string);
    get destinationInput(): string | undefined;
}
export interface JobTaskNewClusterClusterLogConfS3 {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#canned_acl Job#canned_acl}
    */
    readonly cannedAcl?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#destination Job#destination}
    */
    readonly destination: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#enable_encryption Job#enable_encryption}
    */
    readonly enableEncryption?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#encryption_type Job#encryption_type}
    */
    readonly encryptionType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#endpoint Job#endpoint}
    */
    readonly endpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#kms_key Job#kms_key}
    */
    readonly kmsKey?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#region Job#region}
    */
    readonly region?: string;
}
export declare function jobTaskNewClusterClusterLogConfS3ToTerraform(struct?: JobTaskNewClusterClusterLogConfS3OutputReference | JobTaskNewClusterClusterLogConfS3): any;
export declare class JobTaskNewClusterClusterLogConfS3OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobTaskNewClusterClusterLogConfS3 | undefined;
    set internalValue(value: JobTaskNewClusterClusterLogConfS3 | undefined);
    private _cannedAcl?;
    get cannedAcl(): string;
    set cannedAcl(value: string);
    resetCannedAcl(): void;
    get cannedAclInput(): string | undefined;
    private _destination?;
    get destination(): string;
    set destination(value: string);
    get destinationInput(): string | undefined;
    private _enableEncryption?;
    get enableEncryption(): boolean | cdktf.IResolvable;
    set enableEncryption(value: boolean | cdktf.IResolvable);
    resetEnableEncryption(): void;
    get enableEncryptionInput(): boolean | cdktf.IResolvable | undefined;
    private _encryptionType?;
    get encryptionType(): string;
    set encryptionType(value: string);
    resetEncryptionType(): void;
    get encryptionTypeInput(): string | undefined;
    private _endpoint?;
    get endpoint(): string;
    set endpoint(value: string);
    resetEndpoint(): void;
    get endpointInput(): string | undefined;
    private _kmsKey?;
    get kmsKey(): string;
    set kmsKey(value: string);
    resetKmsKey(): void;
    get kmsKeyInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
}
export interface JobTaskNewClusterClusterLogConf {
    /**
    * dbfs block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#dbfs Job#dbfs}
    */
    readonly dbfs?: JobTaskNewClusterClusterLogConfDbfs;
    /**
    * s3 block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#s3 Job#s3}
    */
    readonly s3?: JobTaskNewClusterClusterLogConfS3;
}
export declare function jobTaskNewClusterClusterLogConfToTerraform(struct?: JobTaskNewClusterClusterLogConfOutputReference | JobTaskNewClusterClusterLogConf): any;
export declare class JobTaskNewClusterClusterLogConfOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobTaskNewClusterClusterLogConf | undefined;
    set internalValue(value: JobTaskNewClusterClusterLogConf | undefined);
    private _dbfs;
    get dbfs(): JobTaskNewClusterClusterLogConfDbfsOutputReference;
    putDbfs(value: JobTaskNewClusterClusterLogConfDbfs): void;
    resetDbfs(): void;
    get dbfsInput(): JobTaskNewClusterClusterLogConfDbfs | undefined;
    private _s3;
    get s3(): JobTaskNewClusterClusterLogConfS3OutputReference;
    putS3(value: JobTaskNewClusterClusterLogConfS3): void;
    resetS3(): void;
    get s3Input(): JobTaskNewClusterClusterLogConfS3 | undefined;
}
export interface JobTaskNewClusterClusterMountInfoNetworkFilesystemInfo {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#mount_options Job#mount_options}
    */
    readonly mountOptions?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#server_address Job#server_address}
    */
    readonly serverAddress: string;
}
export declare function jobTaskNewClusterClusterMountInfoNetworkFilesystemInfoToTerraform(struct?: JobTaskNewClusterClusterMountInfoNetworkFilesystemInfoOutputReference | JobTaskNewClusterClusterMountInfoNetworkFilesystemInfo): any;
export declare class JobTaskNewClusterClusterMountInfoNetworkFilesystemInfoOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobTaskNewClusterClusterMountInfoNetworkFilesystemInfo | undefined;
    set internalValue(value: JobTaskNewClusterClusterMountInfoNetworkFilesystemInfo | undefined);
    private _mountOptions?;
    get mountOptions(): string;
    set mountOptions(value: string);
    resetMountOptions(): void;
    get mountOptionsInput(): string | undefined;
    private _serverAddress?;
    get serverAddress(): string;
    set serverAddress(value: string);
    get serverAddressInput(): string | undefined;
}
export interface JobTaskNewClusterClusterMountInfo {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#local_mount_dir_path Job#local_mount_dir_path}
    */
    readonly localMountDirPath: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#remote_mount_dir_path Job#remote_mount_dir_path}
    */
    readonly remoteMountDirPath?: string;
    /**
    * network_filesystem_info block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#network_filesystem_info Job#network_filesystem_info}
    */
    readonly networkFilesystemInfo: JobTaskNewClusterClusterMountInfoNetworkFilesystemInfo;
}
export declare function jobTaskNewClusterClusterMountInfoToTerraform(struct?: JobTaskNewClusterClusterMountInfo | cdktf.IResolvable): any;
export declare class JobTaskNewClusterClusterMountInfoOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): JobTaskNewClusterClusterMountInfo | cdktf.IResolvable | undefined;
    set internalValue(value: JobTaskNewClusterClusterMountInfo | cdktf.IResolvable | undefined);
    private _localMountDirPath?;
    get localMountDirPath(): string;
    set localMountDirPath(value: string);
    get localMountDirPathInput(): string | undefined;
    private _remoteMountDirPath?;
    get remoteMountDirPath(): string;
    set remoteMountDirPath(value: string);
    resetRemoteMountDirPath(): void;
    get remoteMountDirPathInput(): string | undefined;
    private _networkFilesystemInfo;
    get networkFilesystemInfo(): JobTaskNewClusterClusterMountInfoNetworkFilesystemInfoOutputReference;
    putNetworkFilesystemInfo(value: JobTaskNewClusterClusterMountInfoNetworkFilesystemInfo): void;
    get networkFilesystemInfoInput(): JobTaskNewClusterClusterMountInfoNetworkFilesystemInfo | undefined;
}
export declare class JobTaskNewClusterClusterMountInfoList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: JobTaskNewClusterClusterMountInfo[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): JobTaskNewClusterClusterMountInfoOutputReference;
}
export interface JobTaskNewClusterDockerImageBasicAuth {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#password Job#password}
    */
    readonly password: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#username Job#username}
    */
    readonly username: string;
}
export declare function jobTaskNewClusterDockerImageBasicAuthToTerraform(struct?: JobTaskNewClusterDockerImageBasicAuthOutputReference | JobTaskNewClusterDockerImageBasicAuth): any;
export declare class JobTaskNewClusterDockerImageBasicAuthOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobTaskNewClusterDockerImageBasicAuth | undefined;
    set internalValue(value: JobTaskNewClusterDockerImageBasicAuth | undefined);
    private _password?;
    get password(): string;
    set password(value: string);
    get passwordInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
}
export interface JobTaskNewClusterDockerImage {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#url Job#url}
    */
    readonly url: string;
    /**
    * basic_auth block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#basic_auth Job#basic_auth}
    */
    readonly basicAuth?: JobTaskNewClusterDockerImageBasicAuth;
}
export declare function jobTaskNewClusterDockerImageToTerraform(struct?: JobTaskNewClusterDockerImageOutputReference | JobTaskNewClusterDockerImage): any;
export declare class JobTaskNewClusterDockerImageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobTaskNewClusterDockerImage | undefined;
    set internalValue(value: JobTaskNewClusterDockerImage | undefined);
    private _url?;
    get url(): string;
    set url(value: string);
    get urlInput(): string | undefined;
    private _basicAuth;
    get basicAuth(): JobTaskNewClusterDockerImageBasicAuthOutputReference;
    putBasicAuth(value: JobTaskNewClusterDockerImageBasicAuth): void;
    resetBasicAuth(): void;
    get basicAuthInput(): JobTaskNewClusterDockerImageBasicAuth | undefined;
}
export interface JobTaskNewClusterGcpAttributes {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#availability Job#availability}
    */
    readonly availability?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#boot_disk_size Job#boot_disk_size}
    */
    readonly bootDiskSize?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#google_service_account Job#google_service_account}
    */
    readonly googleServiceAccount?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#use_preemptible_executors Job#use_preemptible_executors}
    */
    readonly usePreemptibleExecutors?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#zone_id Job#zone_id}
    */
    readonly zoneId?: string;
}
export declare function jobTaskNewClusterGcpAttributesToTerraform(struct?: JobTaskNewClusterGcpAttributesOutputReference | JobTaskNewClusterGcpAttributes): any;
export declare class JobTaskNewClusterGcpAttributesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobTaskNewClusterGcpAttributes | undefined;
    set internalValue(value: JobTaskNewClusterGcpAttributes | undefined);
    private _availability?;
    get availability(): string;
    set availability(value: string);
    resetAvailability(): void;
    get availabilityInput(): string | undefined;
    private _bootDiskSize?;
    get bootDiskSize(): number;
    set bootDiskSize(value: number);
    resetBootDiskSize(): void;
    get bootDiskSizeInput(): number | undefined;
    private _googleServiceAccount?;
    get googleServiceAccount(): string;
    set googleServiceAccount(value: string);
    resetGoogleServiceAccount(): void;
    get googleServiceAccountInput(): string | undefined;
    private _usePreemptibleExecutors?;
    get usePreemptibleExecutors(): boolean | cdktf.IResolvable;
    set usePreemptibleExecutors(value: boolean | cdktf.IResolvable);
    resetUsePreemptibleExecutors(): void;
    get usePreemptibleExecutorsInput(): boolean | cdktf.IResolvable | undefined;
    private _zoneId?;
    get zoneId(): string;
    set zoneId(value: string);
    resetZoneId(): void;
    get zoneIdInput(): string | undefined;
}
export interface JobTaskNewClusterInitScriptsAbfss {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#destination Job#destination}
    */
    readonly destination?: string;
}
export declare function jobTaskNewClusterInitScriptsAbfssToTerraform(struct?: JobTaskNewClusterInitScriptsAbfssOutputReference | JobTaskNewClusterInitScriptsAbfss): any;
export declare class JobTaskNewClusterInitScriptsAbfssOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobTaskNewClusterInitScriptsAbfss | undefined;
    set internalValue(value: JobTaskNewClusterInitScriptsAbfss | undefined);
    private _destination?;
    get destination(): string;
    set destination(value: string);
    resetDestination(): void;
    get destinationInput(): string | undefined;
}
export interface JobTaskNewClusterInitScriptsDbfs {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#destination Job#destination}
    */
    readonly destination: string;
}
export declare function jobTaskNewClusterInitScriptsDbfsToTerraform(struct?: JobTaskNewClusterInitScriptsDbfsOutputReference | JobTaskNewClusterInitScriptsDbfs): any;
export declare class JobTaskNewClusterInitScriptsDbfsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobTaskNewClusterInitScriptsDbfs | undefined;
    set internalValue(value: JobTaskNewClusterInitScriptsDbfs | undefined);
    private _destination?;
    get destination(): string;
    set destination(value: string);
    get destinationInput(): string | undefined;
}
export interface JobTaskNewClusterInitScriptsFile {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#destination Job#destination}
    */
    readonly destination?: string;
}
export declare function jobTaskNewClusterInitScriptsFileToTerraform(struct?: JobTaskNewClusterInitScriptsFileOutputReference | JobTaskNewClusterInitScriptsFile): any;
export declare class JobTaskNewClusterInitScriptsFileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobTaskNewClusterInitScriptsFile | undefined;
    set internalValue(value: JobTaskNewClusterInitScriptsFile | undefined);
    private _destination?;
    get destination(): string;
    set destination(value: string);
    resetDestination(): void;
    get destinationInput(): string | undefined;
}
export interface JobTaskNewClusterInitScriptsGcs {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#destination Job#destination}
    */
    readonly destination?: string;
}
export declare function jobTaskNewClusterInitScriptsGcsToTerraform(struct?: JobTaskNewClusterInitScriptsGcsOutputReference | JobTaskNewClusterInitScriptsGcs): any;
export declare class JobTaskNewClusterInitScriptsGcsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobTaskNewClusterInitScriptsGcs | undefined;
    set internalValue(value: JobTaskNewClusterInitScriptsGcs | undefined);
    private _destination?;
    get destination(): string;
    set destination(value: string);
    resetDestination(): void;
    get destinationInput(): string | undefined;
}
export interface JobTaskNewClusterInitScriptsS3 {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#canned_acl Job#canned_acl}
    */
    readonly cannedAcl?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#destination Job#destination}
    */
    readonly destination: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#enable_encryption Job#enable_encryption}
    */
    readonly enableEncryption?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#encryption_type Job#encryption_type}
    */
    readonly encryptionType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#endpoint Job#endpoint}
    */
    readonly endpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#kms_key Job#kms_key}
    */
    readonly kmsKey?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#region Job#region}
    */
    readonly region?: string;
}
export declare function jobTaskNewClusterInitScriptsS3ToTerraform(struct?: JobTaskNewClusterInitScriptsS3OutputReference | JobTaskNewClusterInitScriptsS3): any;
export declare class JobTaskNewClusterInitScriptsS3OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobTaskNewClusterInitScriptsS3 | undefined;
    set internalValue(value: JobTaskNewClusterInitScriptsS3 | undefined);
    private _cannedAcl?;
    get cannedAcl(): string;
    set cannedAcl(value: string);
    resetCannedAcl(): void;
    get cannedAclInput(): string | undefined;
    private _destination?;
    get destination(): string;
    set destination(value: string);
    get destinationInput(): string | undefined;
    private _enableEncryption?;
    get enableEncryption(): boolean | cdktf.IResolvable;
    set enableEncryption(value: boolean | cdktf.IResolvable);
    resetEnableEncryption(): void;
    get enableEncryptionInput(): boolean | cdktf.IResolvable | undefined;
    private _encryptionType?;
    get encryptionType(): string;
    set encryptionType(value: string);
    resetEncryptionType(): void;
    get encryptionTypeInput(): string | undefined;
    private _endpoint?;
    get endpoint(): string;
    set endpoint(value: string);
    resetEndpoint(): void;
    get endpointInput(): string | undefined;
    private _kmsKey?;
    get kmsKey(): string;
    set kmsKey(value: string);
    resetKmsKey(): void;
    get kmsKeyInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
}
export interface JobTaskNewClusterInitScripts {
    /**
    * abfss block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#abfss Job#abfss}
    */
    readonly abfss?: JobTaskNewClusterInitScriptsAbfss;
    /**
    * dbfs block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#dbfs Job#dbfs}
    */
    readonly dbfs?: JobTaskNewClusterInitScriptsDbfs;
    /**
    * file block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#file Job#file}
    */
    readonly file?: JobTaskNewClusterInitScriptsFile;
    /**
    * gcs block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#gcs Job#gcs}
    */
    readonly gcs?: JobTaskNewClusterInitScriptsGcs;
    /**
    * s3 block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#s3 Job#s3}
    */
    readonly s3?: JobTaskNewClusterInitScriptsS3;
}
export declare function jobTaskNewClusterInitScriptsToTerraform(struct?: JobTaskNewClusterInitScripts | cdktf.IResolvable): any;
export declare class JobTaskNewClusterInitScriptsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): JobTaskNewClusterInitScripts | cdktf.IResolvable | undefined;
    set internalValue(value: JobTaskNewClusterInitScripts | cdktf.IResolvable | undefined);
    private _abfss;
    get abfss(): JobTaskNewClusterInitScriptsAbfssOutputReference;
    putAbfss(value: JobTaskNewClusterInitScriptsAbfss): void;
    resetAbfss(): void;
    get abfssInput(): JobTaskNewClusterInitScriptsAbfss | undefined;
    private _dbfs;
    get dbfs(): JobTaskNewClusterInitScriptsDbfsOutputReference;
    putDbfs(value: JobTaskNewClusterInitScriptsDbfs): void;
    resetDbfs(): void;
    get dbfsInput(): JobTaskNewClusterInitScriptsDbfs | undefined;
    private _file;
    get file(): JobTaskNewClusterInitScriptsFileOutputReference;
    putFile(value: JobTaskNewClusterInitScriptsFile): void;
    resetFile(): void;
    get fileInput(): JobTaskNewClusterInitScriptsFile | undefined;
    private _gcs;
    get gcs(): JobTaskNewClusterInitScriptsGcsOutputReference;
    putGcs(value: JobTaskNewClusterInitScriptsGcs): void;
    resetGcs(): void;
    get gcsInput(): JobTaskNewClusterInitScriptsGcs | undefined;
    private _s3;
    get s3(): JobTaskNewClusterInitScriptsS3OutputReference;
    putS3(value: JobTaskNewClusterInitScriptsS3): void;
    resetS3(): void;
    get s3Input(): JobTaskNewClusterInitScriptsS3 | undefined;
}
export declare class JobTaskNewClusterInitScriptsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: JobTaskNewClusterInitScripts[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): JobTaskNewClusterInitScriptsOutputReference;
}
export interface JobTaskNewClusterWorkloadTypeClients {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#jobs Job#jobs}
    */
    readonly jobs?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#notebooks Job#notebooks}
    */
    readonly notebooks?: boolean | cdktf.IResolvable;
}
export declare function jobTaskNewClusterWorkloadTypeClientsToTerraform(struct?: JobTaskNewClusterWorkloadTypeClientsOutputReference | JobTaskNewClusterWorkloadTypeClients): any;
export declare class JobTaskNewClusterWorkloadTypeClientsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobTaskNewClusterWorkloadTypeClients | undefined;
    set internalValue(value: JobTaskNewClusterWorkloadTypeClients | undefined);
    private _jobs?;
    get jobs(): boolean | cdktf.IResolvable;
    set jobs(value: boolean | cdktf.IResolvable);
    resetJobs(): void;
    get jobsInput(): boolean | cdktf.IResolvable | undefined;
    private _notebooks?;
    get notebooks(): boolean | cdktf.IResolvable;
    set notebooks(value: boolean | cdktf.IResolvable);
    resetNotebooks(): void;
    get notebooksInput(): boolean | cdktf.IResolvable | undefined;
}
export interface JobTaskNewClusterWorkloadType {
    /**
    * clients block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#clients Job#clients}
    */
    readonly clients: JobTaskNewClusterWorkloadTypeClients;
}
export declare function jobTaskNewClusterWorkloadTypeToTerraform(struct?: JobTaskNewClusterWorkloadTypeOutputReference | JobTaskNewClusterWorkloadType): any;
export declare class JobTaskNewClusterWorkloadTypeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobTaskNewClusterWorkloadType | undefined;
    set internalValue(value: JobTaskNewClusterWorkloadType | undefined);
    private _clients;
    get clients(): JobTaskNewClusterWorkloadTypeClientsOutputReference;
    putClients(value: JobTaskNewClusterWorkloadTypeClients): void;
    get clientsInput(): JobTaskNewClusterWorkloadTypeClients | undefined;
}
export interface JobTaskNewCluster {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#apply_policy_default_values Job#apply_policy_default_values}
    */
    readonly applyPolicyDefaultValues?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#autotermination_minutes Job#autotermination_minutes}
    */
    readonly autoterminationMinutes?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#cluster_id Job#cluster_id}
    */
    readonly clusterId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#cluster_name Job#cluster_name}
    */
    readonly clusterName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#custom_tags Job#custom_tags}
    */
    readonly customTags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#data_security_mode Job#data_security_mode}
    */
    readonly dataSecurityMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#driver_instance_pool_id Job#driver_instance_pool_id}
    */
    readonly driverInstancePoolId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#driver_node_type_id Job#driver_node_type_id}
    */
    readonly driverNodeTypeId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#enable_elastic_disk Job#enable_elastic_disk}
    */
    readonly enableElasticDisk?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#enable_local_disk_encryption Job#enable_local_disk_encryption}
    */
    readonly enableLocalDiskEncryption?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#idempotency_token Job#idempotency_token}
    */
    readonly idempotencyToken?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#instance_pool_id Job#instance_pool_id}
    */
    readonly instancePoolId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#node_type_id Job#node_type_id}
    */
    readonly nodeTypeId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#num_workers Job#num_workers}
    */
    readonly numWorkers?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#policy_id Job#policy_id}
    */
    readonly policyId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#runtime_engine Job#runtime_engine}
    */
    readonly runtimeEngine?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#single_user_name Job#single_user_name}
    */
    readonly singleUserName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#spark_conf Job#spark_conf}
    */
    readonly sparkConf?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#spark_env_vars Job#spark_env_vars}
    */
    readonly sparkEnvVars?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#spark_version Job#spark_version}
    */
    readonly sparkVersion: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#ssh_public_keys Job#ssh_public_keys}
    */
    readonly sshPublicKeys?: string[];
    /**
    * autoscale block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#autoscale Job#autoscale}
    */
    readonly autoscale?: JobTaskNewClusterAutoscale;
    /**
    * aws_attributes block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#aws_attributes Job#aws_attributes}
    */
    readonly awsAttributes?: JobTaskNewClusterAwsAttributes;
    /**
    * azure_attributes block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#azure_attributes Job#azure_attributes}
    */
    readonly azureAttributes?: JobTaskNewClusterAzureAttributes;
    /**
    * cluster_log_conf block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#cluster_log_conf Job#cluster_log_conf}
    */
    readonly clusterLogConf?: JobTaskNewClusterClusterLogConf;
    /**
    * cluster_mount_info block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#cluster_mount_info Job#cluster_mount_info}
    */
    readonly clusterMountInfo?: JobTaskNewClusterClusterMountInfo[] | cdktf.IResolvable;
    /**
    * docker_image block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#docker_image Job#docker_image}
    */
    readonly dockerImage?: JobTaskNewClusterDockerImage;
    /**
    * gcp_attributes block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#gcp_attributes Job#gcp_attributes}
    */
    readonly gcpAttributes?: JobTaskNewClusterGcpAttributes;
    /**
    * init_scripts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#init_scripts Job#init_scripts}
    */
    readonly initScripts?: JobTaskNewClusterInitScripts[] | cdktf.IResolvable;
    /**
    * workload_type block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#workload_type Job#workload_type}
    */
    readonly workloadType?: JobTaskNewClusterWorkloadType;
}
export declare function jobTaskNewClusterToTerraform(struct?: JobTaskNewClusterOutputReference | JobTaskNewCluster): any;
export declare class JobTaskNewClusterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobTaskNewCluster | undefined;
    set internalValue(value: JobTaskNewCluster | undefined);
    private _applyPolicyDefaultValues?;
    get applyPolicyDefaultValues(): boolean | cdktf.IResolvable;
    set applyPolicyDefaultValues(value: boolean | cdktf.IResolvable);
    resetApplyPolicyDefaultValues(): void;
    get applyPolicyDefaultValuesInput(): boolean | cdktf.IResolvable | undefined;
    private _autoterminationMinutes?;
    get autoterminationMinutes(): number;
    set autoterminationMinutes(value: number);
    resetAutoterminationMinutes(): void;
    get autoterminationMinutesInput(): number | undefined;
    private _clusterId?;
    get clusterId(): string;
    set clusterId(value: string);
    resetClusterId(): void;
    get clusterIdInput(): string | undefined;
    private _clusterName?;
    get clusterName(): string;
    set clusterName(value: string);
    resetClusterName(): void;
    get clusterNameInput(): string | undefined;
    private _customTags?;
    get customTags(): {
        [key: string]: string;
    };
    set customTags(value: {
        [key: string]: string;
    });
    resetCustomTags(): void;
    get customTagsInput(): {
        [key: string]: string;
    } | undefined;
    private _dataSecurityMode?;
    get dataSecurityMode(): string;
    set dataSecurityMode(value: string);
    resetDataSecurityMode(): void;
    get dataSecurityModeInput(): string | undefined;
    private _driverInstancePoolId?;
    get driverInstancePoolId(): string;
    set driverInstancePoolId(value: string);
    resetDriverInstancePoolId(): void;
    get driverInstancePoolIdInput(): string | undefined;
    private _driverNodeTypeId?;
    get driverNodeTypeId(): string;
    set driverNodeTypeId(value: string);
    resetDriverNodeTypeId(): void;
    get driverNodeTypeIdInput(): string | undefined;
    private _enableElasticDisk?;
    get enableElasticDisk(): boolean | cdktf.IResolvable;
    set enableElasticDisk(value: boolean | cdktf.IResolvable);
    resetEnableElasticDisk(): void;
    get enableElasticDiskInput(): boolean | cdktf.IResolvable | undefined;
    private _enableLocalDiskEncryption?;
    get enableLocalDiskEncryption(): boolean | cdktf.IResolvable;
    set enableLocalDiskEncryption(value: boolean | cdktf.IResolvable);
    resetEnableLocalDiskEncryption(): void;
    get enableLocalDiskEncryptionInput(): boolean | cdktf.IResolvable | undefined;
    private _idempotencyToken?;
    get idempotencyToken(): string;
    set idempotencyToken(value: string);
    resetIdempotencyToken(): void;
    get idempotencyTokenInput(): string | undefined;
    private _instancePoolId?;
    get instancePoolId(): string;
    set instancePoolId(value: string);
    resetInstancePoolId(): void;
    get instancePoolIdInput(): string | undefined;
    private _nodeTypeId?;
    get nodeTypeId(): string;
    set nodeTypeId(value: string);
    resetNodeTypeId(): void;
    get nodeTypeIdInput(): string | undefined;
    private _numWorkers?;
    get numWorkers(): number;
    set numWorkers(value: number);
    resetNumWorkers(): void;
    get numWorkersInput(): number | undefined;
    private _policyId?;
    get policyId(): string;
    set policyId(value: string);
    resetPolicyId(): void;
    get policyIdInput(): string | undefined;
    private _runtimeEngine?;
    get runtimeEngine(): string;
    set runtimeEngine(value: string);
    resetRuntimeEngine(): void;
    get runtimeEngineInput(): string | undefined;
    private _singleUserName?;
    get singleUserName(): string;
    set singleUserName(value: string);
    resetSingleUserName(): void;
    get singleUserNameInput(): string | undefined;
    private _sparkConf?;
    get sparkConf(): {
        [key: string]: string;
    };
    set sparkConf(value: {
        [key: string]: string;
    });
    resetSparkConf(): void;
    get sparkConfInput(): {
        [key: string]: string;
    } | undefined;
    private _sparkEnvVars?;
    get sparkEnvVars(): {
        [key: string]: string;
    };
    set sparkEnvVars(value: {
        [key: string]: string;
    });
    resetSparkEnvVars(): void;
    get sparkEnvVarsInput(): {
        [key: string]: string;
    } | undefined;
    private _sparkVersion?;
    get sparkVersion(): string;
    set sparkVersion(value: string);
    get sparkVersionInput(): string | undefined;
    private _sshPublicKeys?;
    get sshPublicKeys(): string[];
    set sshPublicKeys(value: string[]);
    resetSshPublicKeys(): void;
    get sshPublicKeysInput(): string[] | undefined;
    private _autoscale;
    get autoscale(): JobTaskNewClusterAutoscaleOutputReference;
    putAutoscale(value: JobTaskNewClusterAutoscale): void;
    resetAutoscale(): void;
    get autoscaleInput(): JobTaskNewClusterAutoscale | undefined;
    private _awsAttributes;
    get awsAttributes(): JobTaskNewClusterAwsAttributesOutputReference;
    putAwsAttributes(value: JobTaskNewClusterAwsAttributes): void;
    resetAwsAttributes(): void;
    get awsAttributesInput(): JobTaskNewClusterAwsAttributes | undefined;
    private _azureAttributes;
    get azureAttributes(): JobTaskNewClusterAzureAttributesOutputReference;
    putAzureAttributes(value: JobTaskNewClusterAzureAttributes): void;
    resetAzureAttributes(): void;
    get azureAttributesInput(): JobTaskNewClusterAzureAttributes | undefined;
    private _clusterLogConf;
    get clusterLogConf(): JobTaskNewClusterClusterLogConfOutputReference;
    putClusterLogConf(value: JobTaskNewClusterClusterLogConf): void;
    resetClusterLogConf(): void;
    get clusterLogConfInput(): JobTaskNewClusterClusterLogConf | undefined;
    private _clusterMountInfo;
    get clusterMountInfo(): JobTaskNewClusterClusterMountInfoList;
    putClusterMountInfo(value: JobTaskNewClusterClusterMountInfo[] | cdktf.IResolvable): void;
    resetClusterMountInfo(): void;
    get clusterMountInfoInput(): cdktf.IResolvable | JobTaskNewClusterClusterMountInfo[] | undefined;
    private _dockerImage;
    get dockerImage(): JobTaskNewClusterDockerImageOutputReference;
    putDockerImage(value: JobTaskNewClusterDockerImage): void;
    resetDockerImage(): void;
    get dockerImageInput(): JobTaskNewClusterDockerImage | undefined;
    private _gcpAttributes;
    get gcpAttributes(): JobTaskNewClusterGcpAttributesOutputReference;
    putGcpAttributes(value: JobTaskNewClusterGcpAttributes): void;
    resetGcpAttributes(): void;
    get gcpAttributesInput(): JobTaskNewClusterGcpAttributes | undefined;
    private _initScripts;
    get initScripts(): JobTaskNewClusterInitScriptsList;
    putInitScripts(value: JobTaskNewClusterInitScripts[] | cdktf.IResolvable): void;
    resetInitScripts(): void;
    get initScriptsInput(): cdktf.IResolvable | JobTaskNewClusterInitScripts[] | undefined;
    private _workloadType;
    get workloadType(): JobTaskNewClusterWorkloadTypeOutputReference;
    putWorkloadType(value: JobTaskNewClusterWorkloadType): void;
    resetWorkloadType(): void;
    get workloadTypeInput(): JobTaskNewClusterWorkloadType | undefined;
}
export interface JobTaskNotebookTask {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#base_parameters Job#base_parameters}
    */
    readonly baseParameters?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#notebook_path Job#notebook_path}
    */
    readonly notebookPath: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#source Job#source}
    */
    readonly source?: string;
}
export declare function jobTaskNotebookTaskToTerraform(struct?: JobTaskNotebookTaskOutputReference | JobTaskNotebookTask): any;
export declare class JobTaskNotebookTaskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobTaskNotebookTask | undefined;
    set internalValue(value: JobTaskNotebookTask | undefined);
    private _baseParameters?;
    get baseParameters(): {
        [key: string]: string;
    };
    set baseParameters(value: {
        [key: string]: string;
    });
    resetBaseParameters(): void;
    get baseParametersInput(): {
        [key: string]: string;
    } | undefined;
    private _notebookPath?;
    get notebookPath(): string;
    set notebookPath(value: string);
    get notebookPathInput(): string | undefined;
    private _source?;
    get source(): string;
    set source(value: string);
    resetSource(): void;
    get sourceInput(): string | undefined;
}
export interface JobTaskPipelineTask {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#pipeline_id Job#pipeline_id}
    */
    readonly pipelineId: string;
}
export declare function jobTaskPipelineTaskToTerraform(struct?: JobTaskPipelineTaskOutputReference | JobTaskPipelineTask): any;
export declare class JobTaskPipelineTaskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobTaskPipelineTask | undefined;
    set internalValue(value: JobTaskPipelineTask | undefined);
    private _pipelineId?;
    get pipelineId(): string;
    set pipelineId(value: string);
    get pipelineIdInput(): string | undefined;
}
export interface JobTaskPythonWheelTask {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#entry_point Job#entry_point}
    */
    readonly entryPoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#named_parameters Job#named_parameters}
    */
    readonly namedParameters?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#package_name Job#package_name}
    */
    readonly packageName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#parameters Job#parameters}
    */
    readonly parameters?: string[];
}
export declare function jobTaskPythonWheelTaskToTerraform(struct?: JobTaskPythonWheelTaskOutputReference | JobTaskPythonWheelTask): any;
export declare class JobTaskPythonWheelTaskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobTaskPythonWheelTask | undefined;
    set internalValue(value: JobTaskPythonWheelTask | undefined);
    private _entryPoint?;
    get entryPoint(): string;
    set entryPoint(value: string);
    resetEntryPoint(): void;
    get entryPointInput(): string | undefined;
    private _namedParameters?;
    get namedParameters(): {
        [key: string]: string;
    };
    set namedParameters(value: {
        [key: string]: string;
    });
    resetNamedParameters(): void;
    get namedParametersInput(): {
        [key: string]: string;
    } | undefined;
    private _packageName?;
    get packageName(): string;
    set packageName(value: string);
    resetPackageName(): void;
    get packageNameInput(): string | undefined;
    private _parameters?;
    get parameters(): string[];
    set parameters(value: string[]);
    resetParameters(): void;
    get parametersInput(): string[] | undefined;
}
export interface JobTaskSparkJarTask {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#jar_uri Job#jar_uri}
    */
    readonly jarUri?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#main_class_name Job#main_class_name}
    */
    readonly mainClassName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#parameters Job#parameters}
    */
    readonly parameters?: string[];
}
export declare function jobTaskSparkJarTaskToTerraform(struct?: JobTaskSparkJarTaskOutputReference | JobTaskSparkJarTask): any;
export declare class JobTaskSparkJarTaskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobTaskSparkJarTask | undefined;
    set internalValue(value: JobTaskSparkJarTask | undefined);
    private _jarUri?;
    get jarUri(): string;
    set jarUri(value: string);
    resetJarUri(): void;
    get jarUriInput(): string | undefined;
    private _mainClassName?;
    get mainClassName(): string;
    set mainClassName(value: string);
    resetMainClassName(): void;
    get mainClassNameInput(): string | undefined;
    private _parameters?;
    get parameters(): string[];
    set parameters(value: string[]);
    resetParameters(): void;
    get parametersInput(): string[] | undefined;
}
export interface JobTaskSparkPythonTask {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#parameters Job#parameters}
    */
    readonly parameters?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#python_file Job#python_file}
    */
    readonly pythonFile: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#source Job#source}
    */
    readonly source?: string;
}
export declare function jobTaskSparkPythonTaskToTerraform(struct?: JobTaskSparkPythonTaskOutputReference | JobTaskSparkPythonTask): any;
export declare class JobTaskSparkPythonTaskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobTaskSparkPythonTask | undefined;
    set internalValue(value: JobTaskSparkPythonTask | undefined);
    private _parameters?;
    get parameters(): string[];
    set parameters(value: string[]);
    resetParameters(): void;
    get parametersInput(): string[] | undefined;
    private _pythonFile?;
    get pythonFile(): string;
    set pythonFile(value: string);
    get pythonFileInput(): string | undefined;
    private _source?;
    get source(): string;
    set source(value: string);
    resetSource(): void;
    get sourceInput(): string | undefined;
}
export interface JobTaskSparkSubmitTask {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#parameters Job#parameters}
    */
    readonly parameters?: string[];
}
export declare function jobTaskSparkSubmitTaskToTerraform(struct?: JobTaskSparkSubmitTaskOutputReference | JobTaskSparkSubmitTask): any;
export declare class JobTaskSparkSubmitTaskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobTaskSparkSubmitTask | undefined;
    set internalValue(value: JobTaskSparkSubmitTask | undefined);
    private _parameters?;
    get parameters(): string[];
    set parameters(value: string[]);
    resetParameters(): void;
    get parametersInput(): string[] | undefined;
}
export interface JobTaskSqlTaskAlert {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#alert_id Job#alert_id}
    */
    readonly alertId: string;
}
export declare function jobTaskSqlTaskAlertToTerraform(struct?: JobTaskSqlTaskAlertOutputReference | JobTaskSqlTaskAlert): any;
export declare class JobTaskSqlTaskAlertOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobTaskSqlTaskAlert | undefined;
    set internalValue(value: JobTaskSqlTaskAlert | undefined);
    private _alertId?;
    get alertId(): string;
    set alertId(value: string);
    get alertIdInput(): string | undefined;
}
export interface JobTaskSqlTaskDashboard {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#dashboard_id Job#dashboard_id}
    */
    readonly dashboardId: string;
}
export declare function jobTaskSqlTaskDashboardToTerraform(struct?: JobTaskSqlTaskDashboardOutputReference | JobTaskSqlTaskDashboard): any;
export declare class JobTaskSqlTaskDashboardOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobTaskSqlTaskDashboard | undefined;
    set internalValue(value: JobTaskSqlTaskDashboard | undefined);
    private _dashboardId?;
    get dashboardId(): string;
    set dashboardId(value: string);
    get dashboardIdInput(): string | undefined;
}
export interface JobTaskSqlTaskFile {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#path Job#path}
    */
    readonly path: string;
}
export declare function jobTaskSqlTaskFileToTerraform(struct?: JobTaskSqlTaskFileOutputReference | JobTaskSqlTaskFile): any;
export declare class JobTaskSqlTaskFileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobTaskSqlTaskFile | undefined;
    set internalValue(value: JobTaskSqlTaskFile | undefined);
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
}
export interface JobTaskSqlTaskQuery {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#query_id Job#query_id}
    */
    readonly queryId: string;
}
export declare function jobTaskSqlTaskQueryToTerraform(struct?: JobTaskSqlTaskQueryOutputReference | JobTaskSqlTaskQuery): any;
export declare class JobTaskSqlTaskQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobTaskSqlTaskQuery | undefined;
    set internalValue(value: JobTaskSqlTaskQuery | undefined);
    private _queryId?;
    get queryId(): string;
    set queryId(value: string);
    get queryIdInput(): string | undefined;
}
export interface JobTaskSqlTask {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#parameters Job#parameters}
    */
    readonly parameters?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#warehouse_id Job#warehouse_id}
    */
    readonly warehouseId?: string;
    /**
    * alert block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#alert Job#alert}
    */
    readonly alert?: JobTaskSqlTaskAlert;
    /**
    * dashboard block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#dashboard Job#dashboard}
    */
    readonly dashboard?: JobTaskSqlTaskDashboard;
    /**
    * file block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#file Job#file}
    */
    readonly file?: JobTaskSqlTaskFile;
    /**
    * query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#query Job#query}
    */
    readonly query?: JobTaskSqlTaskQuery;
}
export declare function jobTaskSqlTaskToTerraform(struct?: JobTaskSqlTaskOutputReference | JobTaskSqlTask): any;
export declare class JobTaskSqlTaskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobTaskSqlTask | undefined;
    set internalValue(value: JobTaskSqlTask | undefined);
    private _parameters?;
    get parameters(): {
        [key: string]: string;
    };
    set parameters(value: {
        [key: string]: string;
    });
    resetParameters(): void;
    get parametersInput(): {
        [key: string]: string;
    } | undefined;
    private _warehouseId?;
    get warehouseId(): string;
    set warehouseId(value: string);
    resetWarehouseId(): void;
    get warehouseIdInput(): string | undefined;
    private _alert;
    get alert(): JobTaskSqlTaskAlertOutputReference;
    putAlert(value: JobTaskSqlTaskAlert): void;
    resetAlert(): void;
    get alertInput(): JobTaskSqlTaskAlert | undefined;
    private _dashboard;
    get dashboard(): JobTaskSqlTaskDashboardOutputReference;
    putDashboard(value: JobTaskSqlTaskDashboard): void;
    resetDashboard(): void;
    get dashboardInput(): JobTaskSqlTaskDashboard | undefined;
    private _file;
    get file(): JobTaskSqlTaskFileOutputReference;
    putFile(value: JobTaskSqlTaskFile): void;
    resetFile(): void;
    get fileInput(): JobTaskSqlTaskFile | undefined;
    private _query;
    get query(): JobTaskSqlTaskQueryOutputReference;
    putQuery(value: JobTaskSqlTaskQuery): void;
    resetQuery(): void;
    get queryInput(): JobTaskSqlTaskQuery | undefined;
}
export interface JobTask {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#description Job#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#existing_cluster_id Job#existing_cluster_id}
    */
    readonly existingClusterId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#job_cluster_key Job#job_cluster_key}
    */
    readonly jobClusterKey?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#max_retries Job#max_retries}
    */
    readonly maxRetries?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#min_retry_interval_millis Job#min_retry_interval_millis}
    */
    readonly minRetryIntervalMillis?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#retry_on_timeout Job#retry_on_timeout}
    */
    readonly retryOnTimeout?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#run_if Job#run_if}
    */
    readonly runIf?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#task_key Job#task_key}
    */
    readonly taskKey?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#timeout_seconds Job#timeout_seconds}
    */
    readonly timeoutSeconds?: number;
    /**
    * dbt_task block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#dbt_task Job#dbt_task}
    */
    readonly dbtTask?: JobTaskDbtTask;
    /**
    * depends_on block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#depends_on Job#depends_on}
    */
    readonly dependsOn?: JobTaskDependsOn[] | cdktf.IResolvable;
    /**
    * email_notifications block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#email_notifications Job#email_notifications}
    */
    readonly emailNotifications?: JobTaskEmailNotifications;
    /**
    * library block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#library Job#library}
    */
    readonly library?: JobTaskLibrary[] | cdktf.IResolvable;
    /**
    * new_cluster block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#new_cluster Job#new_cluster}
    */
    readonly newCluster?: JobTaskNewCluster;
    /**
    * notebook_task block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#notebook_task Job#notebook_task}
    */
    readonly notebookTask?: JobTaskNotebookTask;
    /**
    * pipeline_task block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#pipeline_task Job#pipeline_task}
    */
    readonly pipelineTask?: JobTaskPipelineTask;
    /**
    * python_wheel_task block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#python_wheel_task Job#python_wheel_task}
    */
    readonly pythonWheelTask?: JobTaskPythonWheelTask;
    /**
    * spark_jar_task block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#spark_jar_task Job#spark_jar_task}
    */
    readonly sparkJarTask?: JobTaskSparkJarTask;
    /**
    * spark_python_task block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#spark_python_task Job#spark_python_task}
    */
    readonly sparkPythonTask?: JobTaskSparkPythonTask;
    /**
    * spark_submit_task block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#spark_submit_task Job#spark_submit_task}
    */
    readonly sparkSubmitTask?: JobTaskSparkSubmitTask;
    /**
    * sql_task block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#sql_task Job#sql_task}
    */
    readonly sqlTask?: JobTaskSqlTask;
}
export declare function jobTaskToTerraform(struct?: JobTask | cdktf.IResolvable): any;
export declare class JobTaskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): JobTask | cdktf.IResolvable | undefined;
    set internalValue(value: JobTask | cdktf.IResolvable | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _existingClusterId?;
    get existingClusterId(): string;
    set existingClusterId(value: string);
    resetExistingClusterId(): void;
    get existingClusterIdInput(): string | undefined;
    private _jobClusterKey?;
    get jobClusterKey(): string;
    set jobClusterKey(value: string);
    resetJobClusterKey(): void;
    get jobClusterKeyInput(): string | undefined;
    private _maxRetries?;
    get maxRetries(): number;
    set maxRetries(value: number);
    resetMaxRetries(): void;
    get maxRetriesInput(): number | undefined;
    private _minRetryIntervalMillis?;
    get minRetryIntervalMillis(): number;
    set minRetryIntervalMillis(value: number);
    resetMinRetryIntervalMillis(): void;
    get minRetryIntervalMillisInput(): number | undefined;
    private _retryOnTimeout?;
    get retryOnTimeout(): boolean | cdktf.IResolvable;
    set retryOnTimeout(value: boolean | cdktf.IResolvable);
    resetRetryOnTimeout(): void;
    get retryOnTimeoutInput(): boolean | cdktf.IResolvable | undefined;
    private _runIf?;
    get runIf(): string;
    set runIf(value: string);
    resetRunIf(): void;
    get runIfInput(): string | undefined;
    private _taskKey?;
    get taskKey(): string;
    set taskKey(value: string);
    resetTaskKey(): void;
    get taskKeyInput(): string | undefined;
    private _timeoutSeconds?;
    get timeoutSeconds(): number;
    set timeoutSeconds(value: number);
    resetTimeoutSeconds(): void;
    get timeoutSecondsInput(): number | undefined;
    private _dbtTask;
    get dbtTask(): JobTaskDbtTaskOutputReference;
    putDbtTask(value: JobTaskDbtTask): void;
    resetDbtTask(): void;
    get dbtTaskInput(): JobTaskDbtTask | undefined;
    private _dependsOn;
    get dependsOn(): JobTaskDependsOnList;
    putDependsOn(value: JobTaskDependsOn[] | cdktf.IResolvable): void;
    resetDependsOn(): void;
    get dependsOnInput(): cdktf.IResolvable | JobTaskDependsOn[] | undefined;
    private _emailNotifications;
    get emailNotifications(): JobTaskEmailNotificationsOutputReference;
    putEmailNotifications(value: JobTaskEmailNotifications): void;
    resetEmailNotifications(): void;
    get emailNotificationsInput(): JobTaskEmailNotifications | undefined;
    private _library;
    get library(): JobTaskLibraryList;
    putLibrary(value: JobTaskLibrary[] | cdktf.IResolvable): void;
    resetLibrary(): void;
    get libraryInput(): cdktf.IResolvable | JobTaskLibrary[] | undefined;
    private _newCluster;
    get newCluster(): JobTaskNewClusterOutputReference;
    putNewCluster(value: JobTaskNewCluster): void;
    resetNewCluster(): void;
    get newClusterInput(): JobTaskNewCluster | undefined;
    private _notebookTask;
    get notebookTask(): JobTaskNotebookTaskOutputReference;
    putNotebookTask(value: JobTaskNotebookTask): void;
    resetNotebookTask(): void;
    get notebookTaskInput(): JobTaskNotebookTask | undefined;
    private _pipelineTask;
    get pipelineTask(): JobTaskPipelineTaskOutputReference;
    putPipelineTask(value: JobTaskPipelineTask): void;
    resetPipelineTask(): void;
    get pipelineTaskInput(): JobTaskPipelineTask | undefined;
    private _pythonWheelTask;
    get pythonWheelTask(): JobTaskPythonWheelTaskOutputReference;
    putPythonWheelTask(value: JobTaskPythonWheelTask): void;
    resetPythonWheelTask(): void;
    get pythonWheelTaskInput(): JobTaskPythonWheelTask | undefined;
    private _sparkJarTask;
    get sparkJarTask(): JobTaskSparkJarTaskOutputReference;
    putSparkJarTask(value: JobTaskSparkJarTask): void;
    resetSparkJarTask(): void;
    get sparkJarTaskInput(): JobTaskSparkJarTask | undefined;
    private _sparkPythonTask;
    get sparkPythonTask(): JobTaskSparkPythonTaskOutputReference;
    putSparkPythonTask(value: JobTaskSparkPythonTask): void;
    resetSparkPythonTask(): void;
    get sparkPythonTaskInput(): JobTaskSparkPythonTask | undefined;
    private _sparkSubmitTask;
    get sparkSubmitTask(): JobTaskSparkSubmitTaskOutputReference;
    putSparkSubmitTask(value: JobTaskSparkSubmitTask): void;
    resetSparkSubmitTask(): void;
    get sparkSubmitTaskInput(): JobTaskSparkSubmitTask | undefined;
    private _sqlTask;
    get sqlTask(): JobTaskSqlTaskOutputReference;
    putSqlTask(value: JobTaskSqlTask): void;
    resetSqlTask(): void;
    get sqlTaskInput(): JobTaskSqlTask | undefined;
}
export declare class JobTaskList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: JobTask[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): JobTaskOutputReference;
}
export interface JobTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#create Job#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#update Job#update}
    */
    readonly update?: string;
}
export declare function jobTimeoutsToTerraform(struct?: JobTimeoutsOutputReference | JobTimeouts | cdktf.IResolvable): any;
export declare class JobTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: JobTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface JobTriggerFileArrival {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#min_time_between_trigger_seconds Job#min_time_between_trigger_seconds}
    */
    readonly minTimeBetweenTriggerSeconds?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#url Job#url}
    */
    readonly url: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#wait_after_last_change_seconds Job#wait_after_last_change_seconds}
    */
    readonly waitAfterLastChangeSeconds?: number;
}
export declare function jobTriggerFileArrivalToTerraform(struct?: JobTriggerFileArrivalOutputReference | JobTriggerFileArrival): any;
export declare class JobTriggerFileArrivalOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobTriggerFileArrival | undefined;
    set internalValue(value: JobTriggerFileArrival | undefined);
    private _minTimeBetweenTriggerSeconds?;
    get minTimeBetweenTriggerSeconds(): number;
    set minTimeBetweenTriggerSeconds(value: number);
    resetMinTimeBetweenTriggerSeconds(): void;
    get minTimeBetweenTriggerSecondsInput(): number | undefined;
    private _url?;
    get url(): string;
    set url(value: string);
    get urlInput(): string | undefined;
    private _waitAfterLastChangeSeconds?;
    get waitAfterLastChangeSeconds(): number;
    set waitAfterLastChangeSeconds(value: number);
    resetWaitAfterLastChangeSeconds(): void;
    get waitAfterLastChangeSecondsInput(): number | undefined;
}
export interface JobTrigger {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#pause_status Job#pause_status}
    */
    readonly pauseStatus?: string;
    /**
    * file_arrival block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#file_arrival Job#file_arrival}
    */
    readonly fileArrival: JobTriggerFileArrival;
}
export declare function jobTriggerToTerraform(struct?: JobTriggerOutputReference | JobTrigger): any;
export declare class JobTriggerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobTrigger | undefined;
    set internalValue(value: JobTrigger | undefined);
    private _pauseStatus?;
    get pauseStatus(): string;
    set pauseStatus(value: string);
    resetPauseStatus(): void;
    get pauseStatusInput(): string | undefined;
    private _fileArrival;
    get fileArrival(): JobTriggerFileArrivalOutputReference;
    putFileArrival(value: JobTriggerFileArrival): void;
    get fileArrivalInput(): JobTriggerFileArrival | undefined;
}
export interface JobWebhookNotificationsOnFailure {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#id Job#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id: string;
}
export declare function jobWebhookNotificationsOnFailureToTerraform(struct?: JobWebhookNotificationsOnFailure | cdktf.IResolvable): any;
export declare class JobWebhookNotificationsOnFailureOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): JobWebhookNotificationsOnFailure | cdktf.IResolvable | undefined;
    set internalValue(value: JobWebhookNotificationsOnFailure | cdktf.IResolvable | undefined);
    private _id?;
    get id(): string;
    set id(value: string);
    get idInput(): string | undefined;
}
export declare class JobWebhookNotificationsOnFailureList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: JobWebhookNotificationsOnFailure[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): JobWebhookNotificationsOnFailureOutputReference;
}
export interface JobWebhookNotificationsOnStart {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#id Job#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id: string;
}
export declare function jobWebhookNotificationsOnStartToTerraform(struct?: JobWebhookNotificationsOnStart | cdktf.IResolvable): any;
export declare class JobWebhookNotificationsOnStartOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): JobWebhookNotificationsOnStart | cdktf.IResolvable | undefined;
    set internalValue(value: JobWebhookNotificationsOnStart | cdktf.IResolvable | undefined);
    private _id?;
    get id(): string;
    set id(value: string);
    get idInput(): string | undefined;
}
export declare class JobWebhookNotificationsOnStartList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: JobWebhookNotificationsOnStart[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): JobWebhookNotificationsOnStartOutputReference;
}
export interface JobWebhookNotificationsOnSuccess {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#id Job#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id: string;
}
export declare function jobWebhookNotificationsOnSuccessToTerraform(struct?: JobWebhookNotificationsOnSuccess | cdktf.IResolvable): any;
export declare class JobWebhookNotificationsOnSuccessOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): JobWebhookNotificationsOnSuccess | cdktf.IResolvable | undefined;
    set internalValue(value: JobWebhookNotificationsOnSuccess | cdktf.IResolvable | undefined);
    private _id?;
    get id(): string;
    set id(value: string);
    get idInput(): string | undefined;
}
export declare class JobWebhookNotificationsOnSuccessList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: JobWebhookNotificationsOnSuccess[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): JobWebhookNotificationsOnSuccessOutputReference;
}
export interface JobWebhookNotifications {
    /**
    * on_failure block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#on_failure Job#on_failure}
    */
    readonly onFailure?: JobWebhookNotificationsOnFailure[] | cdktf.IResolvable;
    /**
    * on_start block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#on_start Job#on_start}
    */
    readonly onStart?: JobWebhookNotificationsOnStart[] | cdktf.IResolvable;
    /**
    * on_success block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/job#on_success Job#on_success}
    */
    readonly onSuccess?: JobWebhookNotificationsOnSuccess[] | cdktf.IResolvable;
}
export declare function jobWebhookNotificationsToTerraform(struct?: JobWebhookNotificationsOutputReference | JobWebhookNotifications): any;
export declare class JobWebhookNotificationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobWebhookNotifications | undefined;
    set internalValue(value: JobWebhookNotifications | undefined);
    private _onFailure;
    get onFailure(): JobWebhookNotificationsOnFailureList;
    putOnFailure(value: JobWebhookNotificationsOnFailure[] | cdktf.IResolvable): void;
    resetOnFailure(): void;
    get onFailureInput(): cdktf.IResolvable | JobWebhookNotificationsOnFailure[] | undefined;
    private _onStart;
    get onStart(): JobWebhookNotificationsOnStartList;
    putOnStart(value: JobWebhookNotificationsOnStart[] | cdktf.IResolvable): void;
    resetOnStart(): void;
    get onStartInput(): cdktf.IResolvable | JobWebhookNotificationsOnStart[] | undefined;
    private _onSuccess;
    get onSuccess(): JobWebhookNotificationsOnSuccessList;
    putOnSuccess(value: JobWebhookNotificationsOnSuccess[] | cdktf.IResolvable): void;
    resetOnSuccess(): void;
    get onSuccessInput(): cdktf.IResolvable | JobWebhookNotificationsOnSuccess[] | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/databricks/r/job databricks_job}
*/
export declare class Job extends cdktf.TerraformResource {
    static readonly tfResourceType = "databricks_job";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/databricks/r/job databricks_job} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options JobConfig = {}
    */
    constructor(scope: Construct, id: string, config?: JobConfig);
    private _alwaysRunning?;
    get alwaysRunning(): boolean | cdktf.IResolvable;
    set alwaysRunning(value: boolean | cdktf.IResolvable);
    resetAlwaysRunning(): void;
    get alwaysRunningInput(): boolean | cdktf.IResolvable | undefined;
    private _existingClusterId?;
    get existingClusterId(): string;
    set existingClusterId(value: string);
    resetExistingClusterId(): void;
    get existingClusterIdInput(): string | undefined;
    private _format?;
    get format(): string;
    set format(value: string);
    resetFormat(): void;
    get formatInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _maxConcurrentRuns?;
    get maxConcurrentRuns(): number;
    set maxConcurrentRuns(value: number);
    resetMaxConcurrentRuns(): void;
    get maxConcurrentRunsInput(): number | undefined;
    private _maxRetries?;
    get maxRetries(): number;
    set maxRetries(value: number);
    resetMaxRetries(): void;
    get maxRetriesInput(): number | undefined;
    private _minRetryIntervalMillis?;
    get minRetryIntervalMillis(): number;
    set minRetryIntervalMillis(value: number);
    resetMinRetryIntervalMillis(): void;
    get minRetryIntervalMillisInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _retryOnTimeout?;
    get retryOnTimeout(): boolean | cdktf.IResolvable;
    set retryOnTimeout(value: boolean | cdktf.IResolvable);
    resetRetryOnTimeout(): void;
    get retryOnTimeoutInput(): boolean | cdktf.IResolvable | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _timeoutSeconds?;
    get timeoutSeconds(): number;
    set timeoutSeconds(value: number);
    resetTimeoutSeconds(): void;
    get timeoutSecondsInput(): number | undefined;
    get url(): string;
    private _continuous;
    get continuous(): JobContinuousOutputReference;
    putContinuous(value: JobContinuous): void;
    resetContinuous(): void;
    get continuousInput(): JobContinuous | undefined;
    private _dbtTask;
    get dbtTask(): JobDbtTaskOutputReference;
    putDbtTask(value: JobDbtTask): void;
    resetDbtTask(): void;
    get dbtTaskInput(): JobDbtTask | undefined;
    private _emailNotifications;
    get emailNotifications(): JobEmailNotificationsOutputReference;
    putEmailNotifications(value: JobEmailNotifications): void;
    resetEmailNotifications(): void;
    get emailNotificationsInput(): JobEmailNotifications | undefined;
    private _gitSource;
    get gitSource(): JobGitSourceOutputReference;
    putGitSource(value: JobGitSource): void;
    resetGitSource(): void;
    get gitSourceInput(): JobGitSource | undefined;
    private _jobCluster;
    get jobCluster(): JobJobClusterList;
    putJobCluster(value: JobJobCluster[] | cdktf.IResolvable): void;
    resetJobCluster(): void;
    get jobClusterInput(): cdktf.IResolvable | JobJobCluster[] | undefined;
    private _library;
    get library(): JobLibraryList;
    putLibrary(value: JobLibrary[] | cdktf.IResolvable): void;
    resetLibrary(): void;
    get libraryInput(): cdktf.IResolvable | JobLibrary[] | undefined;
    private _newCluster;
    get newCluster(): JobNewClusterOutputReference;
    putNewCluster(value: JobNewCluster): void;
    resetNewCluster(): void;
    get newClusterInput(): JobNewCluster | undefined;
    private _notebookTask;
    get notebookTask(): JobNotebookTaskOutputReference;
    putNotebookTask(value: JobNotebookTask): void;
    resetNotebookTask(): void;
    get notebookTaskInput(): JobNotebookTask | undefined;
    private _pipelineTask;
    get pipelineTask(): JobPipelineTaskOutputReference;
    putPipelineTask(value: JobPipelineTask): void;
    resetPipelineTask(): void;
    get pipelineTaskInput(): JobPipelineTask | undefined;
    private _pythonWheelTask;
    get pythonWheelTask(): JobPythonWheelTaskOutputReference;
    putPythonWheelTask(value: JobPythonWheelTask): void;
    resetPythonWheelTask(): void;
    get pythonWheelTaskInput(): JobPythonWheelTask | undefined;
    private _queue;
    get queue(): JobQueueOutputReference;
    putQueue(value: JobQueue): void;
    resetQueue(): void;
    get queueInput(): JobQueue | undefined;
    private _schedule;
    get schedule(): JobScheduleOutputReference;
    putSchedule(value: JobSchedule): void;
    resetSchedule(): void;
    get scheduleInput(): JobSchedule | undefined;
    private _sparkJarTask;
    get sparkJarTask(): JobSparkJarTaskOutputReference;
    putSparkJarTask(value: JobSparkJarTask): void;
    resetSparkJarTask(): void;
    get sparkJarTaskInput(): JobSparkJarTask | undefined;
    private _sparkPythonTask;
    get sparkPythonTask(): JobSparkPythonTaskOutputReference;
    putSparkPythonTask(value: JobSparkPythonTask): void;
    resetSparkPythonTask(): void;
    get sparkPythonTaskInput(): JobSparkPythonTask | undefined;
    private _sparkSubmitTask;
    get sparkSubmitTask(): JobSparkSubmitTaskOutputReference;
    putSparkSubmitTask(value: JobSparkSubmitTask): void;
    resetSparkSubmitTask(): void;
    get sparkSubmitTaskInput(): JobSparkSubmitTask | undefined;
    private _task;
    get task(): JobTaskList;
    putTask(value: JobTask[] | cdktf.IResolvable): void;
    resetTask(): void;
    get taskInput(): cdktf.IResolvable | JobTask[] | undefined;
    private _timeouts;
    get timeouts(): JobTimeoutsOutputReference;
    putTimeouts(value: JobTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | JobTimeouts | undefined;
    private _trigger;
    get trigger(): JobTriggerOutputReference;
    putTrigger(value: JobTrigger): void;
    resetTrigger(): void;
    get triggerInput(): JobTrigger | undefined;
    private _webhookNotifications;
    get webhookNotifications(): JobWebhookNotificationsOutputReference;
    putWebhookNotifications(value: JobWebhookNotifications): void;
    resetWebhookNotifications(): void;
    get webhookNotificationsInput(): JobWebhookNotifications | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
