import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MetastoreDataAccessConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/metastore_data_access#configuration_type MetastoreDataAccess#configuration_type}
    */
    readonly configurationType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/metastore_data_access#id MetastoreDataAccess#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/metastore_data_access#is_default MetastoreDataAccess#is_default}
    */
    readonly isDefault?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/metastore_data_access#metastore_id MetastoreDataAccess#metastore_id}
    */
    readonly metastoreId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/metastore_data_access#name MetastoreDataAccess#name}
    */
    readonly name: string;
    /**
    * aws_iam_role block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/metastore_data_access#aws_iam_role MetastoreDataAccess#aws_iam_role}
    */
    readonly awsIamRole?: MetastoreDataAccessAwsIamRole;
    /**
    * azure_managed_identity block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/metastore_data_access#azure_managed_identity MetastoreDataAccess#azure_managed_identity}
    */
    readonly azureManagedIdentity?: MetastoreDataAccessAzureManagedIdentity;
    /**
    * azure_service_principal block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/metastore_data_access#azure_service_principal MetastoreDataAccess#azure_service_principal}
    */
    readonly azureServicePrincipal?: MetastoreDataAccessAzureServicePrincipal;
    /**
    * databricks_gcp_service_account block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/metastore_data_access#databricks_gcp_service_account MetastoreDataAccess#databricks_gcp_service_account}
    */
    readonly databricksGcpServiceAccount?: MetastoreDataAccessDatabricksGcpServiceAccount;
    /**
    * gcp_service_account_key block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/metastore_data_access#gcp_service_account_key MetastoreDataAccess#gcp_service_account_key}
    */
    readonly gcpServiceAccountKey?: MetastoreDataAccessGcpServiceAccountKey;
}
export interface MetastoreDataAccessAwsIamRole {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/metastore_data_access#role_arn MetastoreDataAccess#role_arn}
    */
    readonly roleArn: string;
}
export declare function metastoreDataAccessAwsIamRoleToTerraform(struct?: MetastoreDataAccessAwsIamRoleOutputReference | MetastoreDataAccessAwsIamRole): any;
export declare class MetastoreDataAccessAwsIamRoleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MetastoreDataAccessAwsIamRole | undefined;
    set internalValue(value: MetastoreDataAccessAwsIamRole | undefined);
    private _roleArn?;
    get roleArn(): string;
    set roleArn(value: string);
    get roleArnInput(): string | undefined;
}
export interface MetastoreDataAccessAzureManagedIdentity {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/metastore_data_access#access_connector_id MetastoreDataAccess#access_connector_id}
    */
    readonly accessConnectorId: string;
}
export declare function metastoreDataAccessAzureManagedIdentityToTerraform(struct?: MetastoreDataAccessAzureManagedIdentityOutputReference | MetastoreDataAccessAzureManagedIdentity): any;
export declare class MetastoreDataAccessAzureManagedIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MetastoreDataAccessAzureManagedIdentity | undefined;
    set internalValue(value: MetastoreDataAccessAzureManagedIdentity | undefined);
    private _accessConnectorId?;
    get accessConnectorId(): string;
    set accessConnectorId(value: string);
    get accessConnectorIdInput(): string | undefined;
}
export interface MetastoreDataAccessAzureServicePrincipal {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/metastore_data_access#application_id MetastoreDataAccess#application_id}
    */
    readonly applicationId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/metastore_data_access#client_secret MetastoreDataAccess#client_secret}
    */
    readonly clientSecret: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/metastore_data_access#directory_id MetastoreDataAccess#directory_id}
    */
    readonly directoryId: string;
}
export declare function metastoreDataAccessAzureServicePrincipalToTerraform(struct?: MetastoreDataAccessAzureServicePrincipalOutputReference | MetastoreDataAccessAzureServicePrincipal): any;
export declare class MetastoreDataAccessAzureServicePrincipalOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MetastoreDataAccessAzureServicePrincipal | undefined;
    set internalValue(value: MetastoreDataAccessAzureServicePrincipal | undefined);
    private _applicationId?;
    get applicationId(): string;
    set applicationId(value: string);
    get applicationIdInput(): string | undefined;
    private _clientSecret?;
    get clientSecret(): string;
    set clientSecret(value: string);
    get clientSecretInput(): string | undefined;
    private _directoryId?;
    get directoryId(): string;
    set directoryId(value: string);
    get directoryIdInput(): string | undefined;
}
export interface MetastoreDataAccessDatabricksGcpServiceAccount {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/metastore_data_access#email MetastoreDataAccess#email}
    */
    readonly email?: string;
}
export declare function metastoreDataAccessDatabricksGcpServiceAccountToTerraform(struct?: MetastoreDataAccessDatabricksGcpServiceAccountOutputReference | MetastoreDataAccessDatabricksGcpServiceAccount): any;
export declare class MetastoreDataAccessDatabricksGcpServiceAccountOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MetastoreDataAccessDatabricksGcpServiceAccount | undefined;
    set internalValue(value: MetastoreDataAccessDatabricksGcpServiceAccount | undefined);
    private _email?;
    get email(): string;
    set email(value: string);
    resetEmail(): void;
    get emailInput(): string | undefined;
}
export interface MetastoreDataAccessGcpServiceAccountKey {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/metastore_data_access#email MetastoreDataAccess#email}
    */
    readonly email: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/metastore_data_access#private_key MetastoreDataAccess#private_key}
    */
    readonly privateKey: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/metastore_data_access#private_key_id MetastoreDataAccess#private_key_id}
    */
    readonly privateKeyId: string;
}
export declare function metastoreDataAccessGcpServiceAccountKeyToTerraform(struct?: MetastoreDataAccessGcpServiceAccountKeyOutputReference | MetastoreDataAccessGcpServiceAccountKey): any;
export declare class MetastoreDataAccessGcpServiceAccountKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MetastoreDataAccessGcpServiceAccountKey | undefined;
    set internalValue(value: MetastoreDataAccessGcpServiceAccountKey | undefined);
    private _email?;
    get email(): string;
    set email(value: string);
    get emailInput(): string | undefined;
    private _privateKey?;
    get privateKey(): string;
    set privateKey(value: string);
    get privateKeyInput(): string | undefined;
    private _privateKeyId?;
    get privateKeyId(): string;
    set privateKeyId(value: string);
    get privateKeyIdInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/databricks/r/metastore_data_access databricks_metastore_data_access}
*/
export declare class MetastoreDataAccess extends cdktf.TerraformResource {
    static readonly tfResourceType = "databricks_metastore_data_access";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/databricks/r/metastore_data_access databricks_metastore_data_access} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MetastoreDataAccessConfig
    */
    constructor(scope: Construct, id: string, config: MetastoreDataAccessConfig);
    private _configurationType?;
    get configurationType(): string;
    set configurationType(value: string);
    resetConfigurationType(): void;
    get configurationTypeInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _isDefault?;
    get isDefault(): boolean | cdktf.IResolvable;
    set isDefault(value: boolean | cdktf.IResolvable);
    resetIsDefault(): void;
    get isDefaultInput(): boolean | cdktf.IResolvable | undefined;
    private _metastoreId?;
    get metastoreId(): string;
    set metastoreId(value: string);
    get metastoreIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _awsIamRole;
    get awsIamRole(): MetastoreDataAccessAwsIamRoleOutputReference;
    putAwsIamRole(value: MetastoreDataAccessAwsIamRole): void;
    resetAwsIamRole(): void;
    get awsIamRoleInput(): MetastoreDataAccessAwsIamRole | undefined;
    private _azureManagedIdentity;
    get azureManagedIdentity(): MetastoreDataAccessAzureManagedIdentityOutputReference;
    putAzureManagedIdentity(value: MetastoreDataAccessAzureManagedIdentity): void;
    resetAzureManagedIdentity(): void;
    get azureManagedIdentityInput(): MetastoreDataAccessAzureManagedIdentity | undefined;
    private _azureServicePrincipal;
    get azureServicePrincipal(): MetastoreDataAccessAzureServicePrincipalOutputReference;
    putAzureServicePrincipal(value: MetastoreDataAccessAzureServicePrincipal): void;
    resetAzureServicePrincipal(): void;
    get azureServicePrincipalInput(): MetastoreDataAccessAzureServicePrincipal | undefined;
    private _databricksGcpServiceAccount;
    get databricksGcpServiceAccount(): MetastoreDataAccessDatabricksGcpServiceAccountOutputReference;
    putDatabricksGcpServiceAccount(value: MetastoreDataAccessDatabricksGcpServiceAccount): void;
    resetDatabricksGcpServiceAccount(): void;
    get databricksGcpServiceAccountInput(): MetastoreDataAccessDatabricksGcpServiceAccount | undefined;
    private _gcpServiceAccountKey;
    get gcpServiceAccountKey(): MetastoreDataAccessGcpServiceAccountKeyOutputReference;
    putGcpServiceAccountKey(value: MetastoreDataAccessGcpServiceAccountKey): void;
    resetGcpServiceAccountKey(): void;
    get gcpServiceAccountKeyInput(): MetastoreDataAccessGcpServiceAccountKey | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
