import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MlflowExperimentConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mlflow_experiment#artifact_location MlflowExperiment#artifact_location}
    */
    readonly artifactLocation?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mlflow_experiment#creation_time MlflowExperiment#creation_time}
    */
    readonly creationTime?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mlflow_experiment#description MlflowExperiment#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mlflow_experiment#experiment_id MlflowExperiment#experiment_id}
    */
    readonly experimentId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mlflow_experiment#id MlflowExperiment#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mlflow_experiment#last_update_time MlflowExperiment#last_update_time}
    */
    readonly lastUpdateTime?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mlflow_experiment#lifecycle_stage MlflowExperiment#lifecycle_stage}
    */
    readonly lifecycleStage?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mlflow_experiment#name MlflowExperiment#name}
    */
    readonly name: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mlflow_experiment#timeouts MlflowExperiment#timeouts}
    */
    readonly timeouts?: MlflowExperimentTimeouts;
}
export interface MlflowExperimentTimeouts {
}
export declare function mlflowExperimentTimeoutsToTerraform(struct?: MlflowExperimentTimeoutsOutputReference | MlflowExperimentTimeouts | cdktf.IResolvable): any;
export declare class MlflowExperimentTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MlflowExperimentTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: MlflowExperimentTimeouts | cdktf.IResolvable | undefined);
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/databricks/r/mlflow_experiment databricks_mlflow_experiment}
*/
export declare class MlflowExperiment extends cdktf.TerraformResource {
    static readonly tfResourceType = "databricks_mlflow_experiment";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/databricks/r/mlflow_experiment databricks_mlflow_experiment} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MlflowExperimentConfig
    */
    constructor(scope: Construct, id: string, config: MlflowExperimentConfig);
    private _artifactLocation?;
    get artifactLocation(): string;
    set artifactLocation(value: string);
    resetArtifactLocation(): void;
    get artifactLocationInput(): string | undefined;
    private _creationTime?;
    get creationTime(): number;
    set creationTime(value: number);
    resetCreationTime(): void;
    get creationTimeInput(): number | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _experimentId?;
    get experimentId(): string;
    set experimentId(value: string);
    resetExperimentId(): void;
    get experimentIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _lastUpdateTime?;
    get lastUpdateTime(): number;
    set lastUpdateTime(value: number);
    resetLastUpdateTime(): void;
    get lastUpdateTimeInput(): number | undefined;
    private _lifecycleStage?;
    get lifecycleStage(): string;
    set lifecycleStage(value: string);
    resetLifecycleStage(): void;
    get lifecycleStageInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _timeouts;
    get timeouts(): MlflowExperimentTimeoutsOutputReference;
    putTimeouts(value: MlflowExperimentTimeouts): void;
    get timeoutsInput(): cdktf.IResolvable | MlflowExperimentTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
