import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MlflowModelConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mlflow_model#creation_timestamp MlflowModel#creation_timestamp}
    */
    readonly creationTimestamp?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mlflow_model#description MlflowModel#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mlflow_model#id MlflowModel#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mlflow_model#last_updated_timestamp MlflowModel#last_updated_timestamp}
    */
    readonly lastUpdatedTimestamp?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mlflow_model#name MlflowModel#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mlflow_model#registered_model_id MlflowModel#registered_model_id}
    */
    readonly registeredModelId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mlflow_model#user_id MlflowModel#user_id}
    */
    readonly userId?: string;
    /**
    * tags block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mlflow_model#tags MlflowModel#tags}
    */
    readonly tags?: MlflowModelTags[] | cdktf.IResolvable;
}
export interface MlflowModelTags {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mlflow_model#key MlflowModel#key}
    */
    readonly key: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mlflow_model#value MlflowModel#value}
    */
    readonly value: string;
}
export declare function mlflowModelTagsToTerraform(struct?: MlflowModelTags | cdktf.IResolvable): any;
export declare class MlflowModelTagsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MlflowModelTags | cdktf.IResolvable | undefined;
    set internalValue(value: MlflowModelTags | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class MlflowModelTagsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MlflowModelTags[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MlflowModelTagsOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/databricks/r/mlflow_model databricks_mlflow_model}
*/
export declare class MlflowModel extends cdktf.TerraformResource {
    static readonly tfResourceType = "databricks_mlflow_model";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/databricks/r/mlflow_model databricks_mlflow_model} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MlflowModelConfig
    */
    constructor(scope: Construct, id: string, config: MlflowModelConfig);
    private _creationTimestamp?;
    get creationTimestamp(): number;
    set creationTimestamp(value: number);
    resetCreationTimestamp(): void;
    get creationTimestampInput(): number | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _lastUpdatedTimestamp?;
    get lastUpdatedTimestamp(): number;
    set lastUpdatedTimestamp(value: number);
    resetLastUpdatedTimestamp(): void;
    get lastUpdatedTimestampInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _registeredModelId?;
    get registeredModelId(): string;
    set registeredModelId(value: string);
    resetRegisteredModelId(): void;
    get registeredModelIdInput(): string | undefined;
    private _userId?;
    get userId(): string;
    set userId(value: string);
    resetUserId(): void;
    get userIdInput(): string | undefined;
    private _tags;
    get tags(): MlflowModelTagsList;
    putTags(value: MlflowModelTags[] | cdktf.IResolvable): void;
    resetTags(): void;
    get tagsInput(): cdktf.IResolvable | MlflowModelTags[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
