import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ModelServingConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/model_serving#id ModelServing#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/model_serving#name ModelServing#name}
    */
    readonly name: string;
    /**
    * config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/model_serving#config ModelServing#config}
    */
    readonly config: ModelServingConfigA;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/model_serving#timeouts ModelServing#timeouts}
    */
    readonly timeouts?: ModelServingTimeouts;
}
export interface ModelServingConfigServedModels {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/model_serving#model_name ModelServing#model_name}
    */
    readonly modelName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/model_serving#model_version ModelServing#model_version}
    */
    readonly modelVersion: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/model_serving#name ModelServing#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/model_serving#scale_to_zero_enabled ModelServing#scale_to_zero_enabled}
    */
    readonly scaleToZeroEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/model_serving#workload_size ModelServing#workload_size}
    */
    readonly workloadSize: string;
}
export declare function modelServingConfigServedModelsToTerraform(struct?: ModelServingConfigServedModels | cdktf.IResolvable): any;
export declare class ModelServingConfigServedModelsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ModelServingConfigServedModels | cdktf.IResolvable | undefined;
    set internalValue(value: ModelServingConfigServedModels | cdktf.IResolvable | undefined);
    private _modelName?;
    get modelName(): string;
    set modelName(value: string);
    get modelNameInput(): string | undefined;
    private _modelVersion?;
    get modelVersion(): string;
    set modelVersion(value: string);
    get modelVersionInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _scaleToZeroEnabled?;
    get scaleToZeroEnabled(): boolean | cdktf.IResolvable;
    set scaleToZeroEnabled(value: boolean | cdktf.IResolvable);
    resetScaleToZeroEnabled(): void;
    get scaleToZeroEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _workloadSize?;
    get workloadSize(): string;
    set workloadSize(value: string);
    get workloadSizeInput(): string | undefined;
}
export declare class ModelServingConfigServedModelsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ModelServingConfigServedModels[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ModelServingConfigServedModelsOutputReference;
}
export interface ModelServingConfigTrafficConfigRoutes {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/model_serving#served_model_name ModelServing#served_model_name}
    */
    readonly servedModelName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/model_serving#traffic_percentage ModelServing#traffic_percentage}
    */
    readonly trafficPercentage: number;
}
export declare function modelServingConfigTrafficConfigRoutesToTerraform(struct?: ModelServingConfigTrafficConfigRoutes | cdktf.IResolvable): any;
export declare class ModelServingConfigTrafficConfigRoutesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ModelServingConfigTrafficConfigRoutes | cdktf.IResolvable | undefined;
    set internalValue(value: ModelServingConfigTrafficConfigRoutes | cdktf.IResolvable | undefined);
    private _servedModelName?;
    get servedModelName(): string;
    set servedModelName(value: string);
    get servedModelNameInput(): string | undefined;
    private _trafficPercentage?;
    get trafficPercentage(): number;
    set trafficPercentage(value: number);
    get trafficPercentageInput(): number | undefined;
}
export declare class ModelServingConfigTrafficConfigRoutesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ModelServingConfigTrafficConfigRoutes[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ModelServingConfigTrafficConfigRoutesOutputReference;
}
export interface ModelServingConfigTrafficConfig {
    /**
    * routes block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/model_serving#routes ModelServing#routes}
    */
    readonly routes?: ModelServingConfigTrafficConfigRoutes[] | cdktf.IResolvable;
}
export declare function modelServingConfigTrafficConfigToTerraform(struct?: ModelServingConfigTrafficConfigOutputReference | ModelServingConfigTrafficConfig): any;
export declare class ModelServingConfigTrafficConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ModelServingConfigTrafficConfig | undefined;
    set internalValue(value: ModelServingConfigTrafficConfig | undefined);
    private _routes;
    get routes(): ModelServingConfigTrafficConfigRoutesList;
    putRoutes(value: ModelServingConfigTrafficConfigRoutes[] | cdktf.IResolvable): void;
    resetRoutes(): void;
    get routesInput(): cdktf.IResolvable | ModelServingConfigTrafficConfigRoutes[] | undefined;
}
export interface ModelServingConfigA {
    /**
    * served_models block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/model_serving#served_models ModelServing#served_models}
    */
    readonly servedModels: ModelServingConfigServedModels[] | cdktf.IResolvable;
    /**
    * traffic_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/model_serving#traffic_config ModelServing#traffic_config}
    */
    readonly trafficConfig?: ModelServingConfigTrafficConfig;
}
export declare function modelServingConfigAToTerraform(struct?: ModelServingConfigAOutputReference | ModelServingConfigA): any;
export declare class ModelServingConfigAOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ModelServingConfigA | undefined;
    set internalValue(value: ModelServingConfigA | undefined);
    private _servedModels;
    get servedModels(): ModelServingConfigServedModelsList;
    putServedModels(value: ModelServingConfigServedModels[] | cdktf.IResolvable): void;
    get servedModelsInput(): cdktf.IResolvable | ModelServingConfigServedModels[] | undefined;
    private _trafficConfig;
    get trafficConfig(): ModelServingConfigTrafficConfigOutputReference;
    putTrafficConfig(value: ModelServingConfigTrafficConfig): void;
    resetTrafficConfig(): void;
    get trafficConfigInput(): ModelServingConfigTrafficConfig | undefined;
}
export interface ModelServingTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/model_serving#create ModelServing#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/model_serving#update ModelServing#update}
    */
    readonly update?: string;
}
export declare function modelServingTimeoutsToTerraform(struct?: ModelServingTimeoutsOutputReference | ModelServingTimeouts | cdktf.IResolvable): any;
export declare class ModelServingTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ModelServingTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ModelServingTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/databricks/r/model_serving databricks_model_serving}
*/
export declare class ModelServing extends cdktf.TerraformResource {
    static readonly tfResourceType = "databricks_model_serving";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/databricks/r/model_serving databricks_model_serving} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ModelServingConfig
    */
    constructor(scope: Construct, id: string, config: ModelServingConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _config;
    get config(): ModelServingConfigAOutputReference;
    putConfig(value: ModelServingConfigA): void;
    get configInput(): ModelServingConfigA | undefined;
    private _timeouts;
    get timeouts(): ModelServingTimeoutsOutputReference;
    putTimeouts(value: ModelServingTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ModelServingTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
