import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MwsCustomerManagedKeysConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_customer_managed_keys#account_id MwsCustomerManagedKeys#account_id}
    */
    readonly accountId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_customer_managed_keys#creation_time MwsCustomerManagedKeys#creation_time}
    */
    readonly creationTime?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_customer_managed_keys#customer_managed_key_id MwsCustomerManagedKeys#customer_managed_key_id}
    */
    readonly customerManagedKeyId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_customer_managed_keys#id MwsCustomerManagedKeys#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_customer_managed_keys#use_cases MwsCustomerManagedKeys#use_cases}
    */
    readonly useCases: string[];
    /**
    * aws_key_info block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_customer_managed_keys#aws_key_info MwsCustomerManagedKeys#aws_key_info}
    */
    readonly awsKeyInfo?: MwsCustomerManagedKeysAwsKeyInfo;
    /**
    * gcp_key_info block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_customer_managed_keys#gcp_key_info MwsCustomerManagedKeys#gcp_key_info}
    */
    readonly gcpKeyInfo?: MwsCustomerManagedKeysGcpKeyInfo;
}
export interface MwsCustomerManagedKeysAwsKeyInfo {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_customer_managed_keys#key_alias MwsCustomerManagedKeys#key_alias}
    */
    readonly keyAlias: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_customer_managed_keys#key_arn MwsCustomerManagedKeys#key_arn}
    */
    readonly keyArn: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_customer_managed_keys#key_region MwsCustomerManagedKeys#key_region}
    */
    readonly keyRegion?: string;
}
export declare function mwsCustomerManagedKeysAwsKeyInfoToTerraform(struct?: MwsCustomerManagedKeysAwsKeyInfoOutputReference | MwsCustomerManagedKeysAwsKeyInfo): any;
export declare class MwsCustomerManagedKeysAwsKeyInfoOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MwsCustomerManagedKeysAwsKeyInfo | undefined;
    set internalValue(value: MwsCustomerManagedKeysAwsKeyInfo | undefined);
    private _keyAlias?;
    get keyAlias(): string;
    set keyAlias(value: string);
    get keyAliasInput(): string | undefined;
    private _keyArn?;
    get keyArn(): string;
    set keyArn(value: string);
    get keyArnInput(): string | undefined;
    private _keyRegion?;
    get keyRegion(): string;
    set keyRegion(value: string);
    resetKeyRegion(): void;
    get keyRegionInput(): string | undefined;
}
export interface MwsCustomerManagedKeysGcpKeyInfo {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_customer_managed_keys#kms_key_id MwsCustomerManagedKeys#kms_key_id}
    */
    readonly kmsKeyId: string;
}
export declare function mwsCustomerManagedKeysGcpKeyInfoToTerraform(struct?: MwsCustomerManagedKeysGcpKeyInfoOutputReference | MwsCustomerManagedKeysGcpKeyInfo): any;
export declare class MwsCustomerManagedKeysGcpKeyInfoOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MwsCustomerManagedKeysGcpKeyInfo | undefined;
    set internalValue(value: MwsCustomerManagedKeysGcpKeyInfo | undefined);
    private _kmsKeyId?;
    get kmsKeyId(): string;
    set kmsKeyId(value: string);
    get kmsKeyIdInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/databricks/r/mws_customer_managed_keys databricks_mws_customer_managed_keys}
*/
export declare class MwsCustomerManagedKeys extends cdktf.TerraformResource {
    static readonly tfResourceType = "databricks_mws_customer_managed_keys";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/databricks/r/mws_customer_managed_keys databricks_mws_customer_managed_keys} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MwsCustomerManagedKeysConfig
    */
    constructor(scope: Construct, id: string, config: MwsCustomerManagedKeysConfig);
    private _accountId?;
    get accountId(): string;
    set accountId(value: string);
    get accountIdInput(): string | undefined;
    private _creationTime?;
    get creationTime(): number;
    set creationTime(value: number);
    resetCreationTime(): void;
    get creationTimeInput(): number | undefined;
    private _customerManagedKeyId?;
    get customerManagedKeyId(): string;
    set customerManagedKeyId(value: string);
    resetCustomerManagedKeyId(): void;
    get customerManagedKeyIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _useCases?;
    get useCases(): string[];
    set useCases(value: string[]);
    get useCasesInput(): string[] | undefined;
    private _awsKeyInfo;
    get awsKeyInfo(): MwsCustomerManagedKeysAwsKeyInfoOutputReference;
    putAwsKeyInfo(value: MwsCustomerManagedKeysAwsKeyInfo): void;
    resetAwsKeyInfo(): void;
    get awsKeyInfoInput(): MwsCustomerManagedKeysAwsKeyInfo | undefined;
    private _gcpKeyInfo;
    get gcpKeyInfo(): MwsCustomerManagedKeysGcpKeyInfoOutputReference;
    putGcpKeyInfo(value: MwsCustomerManagedKeysGcpKeyInfo): void;
    resetGcpKeyInfo(): void;
    get gcpKeyInfoInput(): MwsCustomerManagedKeysGcpKeyInfo | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
