import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MwsNetworksConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_networks#account_id MwsNetworks#account_id}
    */
    readonly accountId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_networks#creation_time MwsNetworks#creation_time}
    */
    readonly creationTime?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_networks#id MwsNetworks#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_networks#network_id MwsNetworks#network_id}
    */
    readonly networkId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_networks#network_name MwsNetworks#network_name}
    */
    readonly networkName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_networks#security_group_ids MwsNetworks#security_group_ids}
    */
    readonly securityGroupIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_networks#subnet_ids MwsNetworks#subnet_ids}
    */
    readonly subnetIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_networks#vpc_id MwsNetworks#vpc_id}
    */
    readonly vpcId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_networks#vpc_status MwsNetworks#vpc_status}
    */
    readonly vpcStatus?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_networks#workspace_id MwsNetworks#workspace_id}
    */
    readonly workspaceId?: number;
    /**
    * error_messages block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_networks#error_messages MwsNetworks#error_messages}
    */
    readonly errorMessages?: MwsNetworksErrorMessages[] | cdktf.IResolvable;
    /**
    * gcp_network_info block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_networks#gcp_network_info MwsNetworks#gcp_network_info}
    */
    readonly gcpNetworkInfo?: MwsNetworksGcpNetworkInfo;
    /**
    * vpc_endpoints block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_networks#vpc_endpoints MwsNetworks#vpc_endpoints}
    */
    readonly vpcEndpoints?: MwsNetworksVpcEndpoints;
}
export interface MwsNetworksErrorMessages {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_networks#error_message MwsNetworks#error_message}
    */
    readonly errorMessage?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_networks#error_type MwsNetworks#error_type}
    */
    readonly errorType?: string;
}
export declare function mwsNetworksErrorMessagesToTerraform(struct?: MwsNetworksErrorMessages | cdktf.IResolvable): any;
export declare class MwsNetworksErrorMessagesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MwsNetworksErrorMessages | cdktf.IResolvable | undefined;
    set internalValue(value: MwsNetworksErrorMessages | cdktf.IResolvable | undefined);
    private _errorMessage?;
    get errorMessage(): string;
    set errorMessage(value: string);
    resetErrorMessage(): void;
    get errorMessageInput(): string | undefined;
    private _errorType?;
    get errorType(): string;
    set errorType(value: string);
    resetErrorType(): void;
    get errorTypeInput(): string | undefined;
}
export declare class MwsNetworksErrorMessagesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MwsNetworksErrorMessages[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MwsNetworksErrorMessagesOutputReference;
}
export interface MwsNetworksGcpNetworkInfo {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_networks#network_project_id MwsNetworks#network_project_id}
    */
    readonly networkProjectId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_networks#pod_ip_range_name MwsNetworks#pod_ip_range_name}
    */
    readonly podIpRangeName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_networks#service_ip_range_name MwsNetworks#service_ip_range_name}
    */
    readonly serviceIpRangeName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_networks#subnet_id MwsNetworks#subnet_id}
    */
    readonly subnetId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_networks#subnet_region MwsNetworks#subnet_region}
    */
    readonly subnetRegion: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_networks#vpc_id MwsNetworks#vpc_id}
    */
    readonly vpcId: string;
}
export declare function mwsNetworksGcpNetworkInfoToTerraform(struct?: MwsNetworksGcpNetworkInfoOutputReference | MwsNetworksGcpNetworkInfo): any;
export declare class MwsNetworksGcpNetworkInfoOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MwsNetworksGcpNetworkInfo | undefined;
    set internalValue(value: MwsNetworksGcpNetworkInfo | undefined);
    private _networkProjectId?;
    get networkProjectId(): string;
    set networkProjectId(value: string);
    get networkProjectIdInput(): string | undefined;
    private _podIpRangeName?;
    get podIpRangeName(): string;
    set podIpRangeName(value: string);
    get podIpRangeNameInput(): string | undefined;
    private _serviceIpRangeName?;
    get serviceIpRangeName(): string;
    set serviceIpRangeName(value: string);
    get serviceIpRangeNameInput(): string | undefined;
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    get subnetIdInput(): string | undefined;
    private _subnetRegion?;
    get subnetRegion(): string;
    set subnetRegion(value: string);
    get subnetRegionInput(): string | undefined;
    private _vpcId?;
    get vpcId(): string;
    set vpcId(value: string);
    get vpcIdInput(): string | undefined;
}
export interface MwsNetworksVpcEndpoints {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_networks#dataplane_relay MwsNetworks#dataplane_relay}
    */
    readonly dataplaneRelay: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_networks#rest_api MwsNetworks#rest_api}
    */
    readonly restApi: string[];
}
export declare function mwsNetworksVpcEndpointsToTerraform(struct?: MwsNetworksVpcEndpointsOutputReference | MwsNetworksVpcEndpoints): any;
export declare class MwsNetworksVpcEndpointsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MwsNetworksVpcEndpoints | undefined;
    set internalValue(value: MwsNetworksVpcEndpoints | undefined);
    private _dataplaneRelay?;
    get dataplaneRelay(): string[];
    set dataplaneRelay(value: string[]);
    get dataplaneRelayInput(): string[] | undefined;
    private _restApi?;
    get restApi(): string[];
    set restApi(value: string[]);
    get restApiInput(): string[] | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/databricks/r/mws_networks databricks_mws_networks}
*/
export declare class MwsNetworks extends cdktf.TerraformResource {
    static readonly tfResourceType = "databricks_mws_networks";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/databricks/r/mws_networks databricks_mws_networks} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MwsNetworksConfig
    */
    constructor(scope: Construct, id: string, config: MwsNetworksConfig);
    private _accountId?;
    get accountId(): string;
    set accountId(value: string);
    get accountIdInput(): string | undefined;
    private _creationTime?;
    get creationTime(): number;
    set creationTime(value: number);
    resetCreationTime(): void;
    get creationTimeInput(): number | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _networkId?;
    get networkId(): string;
    set networkId(value: string);
    resetNetworkId(): void;
    get networkIdInput(): string | undefined;
    private _networkName?;
    get networkName(): string;
    set networkName(value: string);
    get networkNameInput(): string | undefined;
    private _securityGroupIds?;
    get securityGroupIds(): string[];
    set securityGroupIds(value: string[]);
    resetSecurityGroupIds(): void;
    get securityGroupIdsInput(): string[] | undefined;
    private _subnetIds?;
    get subnetIds(): string[];
    set subnetIds(value: string[]);
    resetSubnetIds(): void;
    get subnetIdsInput(): string[] | undefined;
    private _vpcId?;
    get vpcId(): string;
    set vpcId(value: string);
    resetVpcId(): void;
    get vpcIdInput(): string | undefined;
    private _vpcStatus?;
    get vpcStatus(): string;
    set vpcStatus(value: string);
    resetVpcStatus(): void;
    get vpcStatusInput(): string | undefined;
    private _workspaceId?;
    get workspaceId(): number;
    set workspaceId(value: number);
    resetWorkspaceId(): void;
    get workspaceIdInput(): number | undefined;
    private _errorMessages;
    get errorMessages(): MwsNetworksErrorMessagesList;
    putErrorMessages(value: MwsNetworksErrorMessages[] | cdktf.IResolvable): void;
    resetErrorMessages(): void;
    get errorMessagesInput(): cdktf.IResolvable | MwsNetworksErrorMessages[] | undefined;
    private _gcpNetworkInfo;
    get gcpNetworkInfo(): MwsNetworksGcpNetworkInfoOutputReference;
    putGcpNetworkInfo(value: MwsNetworksGcpNetworkInfo): void;
    resetGcpNetworkInfo(): void;
    get gcpNetworkInfoInput(): MwsNetworksGcpNetworkInfo | undefined;
    private _vpcEndpoints;
    get vpcEndpoints(): MwsNetworksVpcEndpointsOutputReference;
    putVpcEndpoints(value: MwsNetworksVpcEndpoints): void;
    resetVpcEndpoints(): void;
    get vpcEndpointsInput(): MwsNetworksVpcEndpoints | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
