import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MwsPermissionAssignmentConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_permission_assignment#id MwsPermissionAssignment#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_permission_assignment#permissions MwsPermissionAssignment#permissions}
    */
    readonly permissions: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_permission_assignment#principal_id MwsPermissionAssignment#principal_id}
    */
    readonly principalId: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_permission_assignment#workspace_id MwsPermissionAssignment#workspace_id}
    */
    readonly workspaceId: number;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/databricks/r/mws_permission_assignment databricks_mws_permission_assignment}
*/
export declare class MwsPermissionAssignment extends cdktf.TerraformResource {
    static readonly tfResourceType = "databricks_mws_permission_assignment";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/databricks/r/mws_permission_assignment databricks_mws_permission_assignment} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MwsPermissionAssignmentConfig
    */
    constructor(scope: Construct, id: string, config: MwsPermissionAssignmentConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _permissions?;
    get permissions(): string[];
    set permissions(value: string[]);
    get permissionsInput(): string[] | undefined;
    private _principalId?;
    get principalId(): number;
    set principalId(value: number);
    get principalIdInput(): number | undefined;
    private _workspaceId?;
    get workspaceId(): number;
    set workspaceId(value: number);
    get workspaceIdInput(): number | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
