import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MwsPrivateAccessSettingsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_private_access_settings#account_id MwsPrivateAccessSettings#account_id}
    */
    readonly accountId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_private_access_settings#allowed_vpc_endpoint_ids MwsPrivateAccessSettings#allowed_vpc_endpoint_ids}
    */
    readonly allowedVpcEndpointIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_private_access_settings#id MwsPrivateAccessSettings#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_private_access_settings#private_access_level MwsPrivateAccessSettings#private_access_level}
    */
    readonly privateAccessLevel?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_private_access_settings#private_access_settings_id MwsPrivateAccessSettings#private_access_settings_id}
    */
    readonly privateAccessSettingsId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_private_access_settings#private_access_settings_name MwsPrivateAccessSettings#private_access_settings_name}
    */
    readonly privateAccessSettingsName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_private_access_settings#public_access_enabled MwsPrivateAccessSettings#public_access_enabled}
    */
    readonly publicAccessEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_private_access_settings#region MwsPrivateAccessSettings#region}
    */
    readonly region: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_private_access_settings#status MwsPrivateAccessSettings#status}
    */
    readonly status?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/databricks/r/mws_private_access_settings databricks_mws_private_access_settings}
*/
export declare class MwsPrivateAccessSettings extends cdktf.TerraformResource {
    static readonly tfResourceType = "databricks_mws_private_access_settings";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/databricks/r/mws_private_access_settings databricks_mws_private_access_settings} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MwsPrivateAccessSettingsConfig
    */
    constructor(scope: Construct, id: string, config: MwsPrivateAccessSettingsConfig);
    private _accountId?;
    get accountId(): string;
    set accountId(value: string);
    resetAccountId(): void;
    get accountIdInput(): string | undefined;
    private _allowedVpcEndpointIds?;
    get allowedVpcEndpointIds(): string[];
    set allowedVpcEndpointIds(value: string[]);
    resetAllowedVpcEndpointIds(): void;
    get allowedVpcEndpointIdsInput(): string[] | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _privateAccessLevel?;
    get privateAccessLevel(): string;
    set privateAccessLevel(value: string);
    resetPrivateAccessLevel(): void;
    get privateAccessLevelInput(): string | undefined;
    private _privateAccessSettingsId?;
    get privateAccessSettingsId(): string;
    set privateAccessSettingsId(value: string);
    resetPrivateAccessSettingsId(): void;
    get privateAccessSettingsIdInput(): string | undefined;
    private _privateAccessSettingsName?;
    get privateAccessSettingsName(): string;
    set privateAccessSettingsName(value: string);
    get privateAccessSettingsNameInput(): string | undefined;
    private _publicAccessEnabled?;
    get publicAccessEnabled(): boolean | cdktf.IResolvable;
    set publicAccessEnabled(value: boolean | cdktf.IResolvable);
    resetPublicAccessEnabled(): void;
    get publicAccessEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    get regionInput(): string | undefined;
    private _status?;
    get status(): string;
    set status(value: string);
    resetStatus(): void;
    get statusInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
