import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MwsStorageConfigurationsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_storage_configurations#account_id MwsStorageConfigurations#account_id}
    */
    readonly accountId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_storage_configurations#bucket_name MwsStorageConfigurations#bucket_name}
    */
    readonly bucketName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_storage_configurations#id MwsStorageConfigurations#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_storage_configurations#storage_configuration_name MwsStorageConfigurations#storage_configuration_name}
    */
    readonly storageConfigurationName: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/databricks/r/mws_storage_configurations databricks_mws_storage_configurations}
*/
export declare class MwsStorageConfigurations extends cdktf.TerraformResource {
    static readonly tfResourceType = "databricks_mws_storage_configurations";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/databricks/r/mws_storage_configurations databricks_mws_storage_configurations} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MwsStorageConfigurationsConfig
    */
    constructor(scope: Construct, id: string, config: MwsStorageConfigurationsConfig);
    private _accountId?;
    get accountId(): string;
    set accountId(value: string);
    get accountIdInput(): string | undefined;
    private _bucketName?;
    get bucketName(): string;
    set bucketName(value: string);
    get bucketNameInput(): string | undefined;
    get creationTime(): number;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get storageConfigurationId(): string;
    private _storageConfigurationName?;
    get storageConfigurationName(): string;
    set storageConfigurationName(value: string);
    get storageConfigurationNameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
