import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MwsVpcEndpointConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_vpc_endpoint#account_id MwsVpcEndpoint#account_id}
    */
    readonly accountId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_vpc_endpoint#aws_account_id MwsVpcEndpoint#aws_account_id}
    */
    readonly awsAccountId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_vpc_endpoint#aws_endpoint_service_id MwsVpcEndpoint#aws_endpoint_service_id}
    */
    readonly awsEndpointServiceId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_vpc_endpoint#aws_vpc_endpoint_id MwsVpcEndpoint#aws_vpc_endpoint_id}
    */
    readonly awsVpcEndpointId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_vpc_endpoint#id MwsVpcEndpoint#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_vpc_endpoint#region MwsVpcEndpoint#region}
    */
    readonly region?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_vpc_endpoint#state MwsVpcEndpoint#state}
    */
    readonly state?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_vpc_endpoint#use_case MwsVpcEndpoint#use_case}
    */
    readonly useCase?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_vpc_endpoint#vpc_endpoint_id MwsVpcEndpoint#vpc_endpoint_id}
    */
    readonly vpcEndpointId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_vpc_endpoint#vpc_endpoint_name MwsVpcEndpoint#vpc_endpoint_name}
    */
    readonly vpcEndpointName: string;
    /**
    * gcp_vpc_endpoint_info block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_vpc_endpoint#gcp_vpc_endpoint_info MwsVpcEndpoint#gcp_vpc_endpoint_info}
    */
    readonly gcpVpcEndpointInfo?: MwsVpcEndpointGcpVpcEndpointInfo;
}
export interface MwsVpcEndpointGcpVpcEndpointInfo {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_vpc_endpoint#endpoint_region MwsVpcEndpoint#endpoint_region}
    */
    readonly endpointRegion: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_vpc_endpoint#project_id MwsVpcEndpoint#project_id}
    */
    readonly projectId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_vpc_endpoint#psc_connection_id MwsVpcEndpoint#psc_connection_id}
    */
    readonly pscConnectionId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_vpc_endpoint#psc_endpoint_name MwsVpcEndpoint#psc_endpoint_name}
    */
    readonly pscEndpointName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_vpc_endpoint#service_attachment_id MwsVpcEndpoint#service_attachment_id}
    */
    readonly serviceAttachmentId?: string;
}
export declare function mwsVpcEndpointGcpVpcEndpointInfoToTerraform(struct?: MwsVpcEndpointGcpVpcEndpointInfoOutputReference | MwsVpcEndpointGcpVpcEndpointInfo): any;
export declare class MwsVpcEndpointGcpVpcEndpointInfoOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MwsVpcEndpointGcpVpcEndpointInfo | undefined;
    set internalValue(value: MwsVpcEndpointGcpVpcEndpointInfo | undefined);
    private _endpointRegion?;
    get endpointRegion(): string;
    set endpointRegion(value: string);
    get endpointRegionInput(): string | undefined;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
    private _pscConnectionId?;
    get pscConnectionId(): string;
    set pscConnectionId(value: string);
    resetPscConnectionId(): void;
    get pscConnectionIdInput(): string | undefined;
    private _pscEndpointName?;
    get pscEndpointName(): string;
    set pscEndpointName(value: string);
    get pscEndpointNameInput(): string | undefined;
    private _serviceAttachmentId?;
    get serviceAttachmentId(): string;
    set serviceAttachmentId(value: string);
    resetServiceAttachmentId(): void;
    get serviceAttachmentIdInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/databricks/r/mws_vpc_endpoint databricks_mws_vpc_endpoint}
*/
export declare class MwsVpcEndpoint extends cdktf.TerraformResource {
    static readonly tfResourceType = "databricks_mws_vpc_endpoint";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/databricks/r/mws_vpc_endpoint databricks_mws_vpc_endpoint} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MwsVpcEndpointConfig
    */
    constructor(scope: Construct, id: string, config: MwsVpcEndpointConfig);
    private _accountId?;
    get accountId(): string;
    set accountId(value: string);
    resetAccountId(): void;
    get accountIdInput(): string | undefined;
    private _awsAccountId?;
    get awsAccountId(): string;
    set awsAccountId(value: string);
    resetAwsAccountId(): void;
    get awsAccountIdInput(): string | undefined;
    private _awsEndpointServiceId?;
    get awsEndpointServiceId(): string;
    set awsEndpointServiceId(value: string);
    resetAwsEndpointServiceId(): void;
    get awsEndpointServiceIdInput(): string | undefined;
    private _awsVpcEndpointId?;
    get awsVpcEndpointId(): string;
    set awsVpcEndpointId(value: string);
    resetAwsVpcEndpointId(): void;
    get awsVpcEndpointIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _state?;
    get state(): string;
    set state(value: string);
    resetState(): void;
    get stateInput(): string | undefined;
    private _useCase?;
    get useCase(): string;
    set useCase(value: string);
    resetUseCase(): void;
    get useCaseInput(): string | undefined;
    private _vpcEndpointId?;
    get vpcEndpointId(): string;
    set vpcEndpointId(value: string);
    resetVpcEndpointId(): void;
    get vpcEndpointIdInput(): string | undefined;
    private _vpcEndpointName?;
    get vpcEndpointName(): string;
    set vpcEndpointName(value: string);
    get vpcEndpointNameInput(): string | undefined;
    private _gcpVpcEndpointInfo;
    get gcpVpcEndpointInfo(): MwsVpcEndpointGcpVpcEndpointInfoOutputReference;
    putGcpVpcEndpointInfo(value: MwsVpcEndpointGcpVpcEndpointInfo): void;
    resetGcpVpcEndpointInfo(): void;
    get gcpVpcEndpointInfoInput(): MwsVpcEndpointGcpVpcEndpointInfo | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
