"use strict";
var _a, _b, _c, _d, _e, _f, _g, _h;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MwsWorkspaces = exports.MwsWorkspacesTokenOutputReference = exports.mwsWorkspacesTokenToTerraform = exports.MwsWorkspacesTimeoutsOutputReference = exports.mwsWorkspacesTimeoutsToTerraform = exports.MwsWorkspacesGkeConfigOutputReference = exports.mwsWorkspacesGkeConfigToTerraform = exports.MwsWorkspacesGcpManagedNetworkConfigOutputReference = exports.mwsWorkspacesGcpManagedNetworkConfigToTerraform = exports.MwsWorkspacesExternalCustomerInfoOutputReference = exports.mwsWorkspacesExternalCustomerInfoToTerraform = exports.MwsWorkspacesCloudResourceContainerOutputReference = exports.mwsWorkspacesCloudResourceContainerToTerraform = exports.MwsWorkspacesCloudResourceContainerGcpOutputReference = exports.mwsWorkspacesCloudResourceContainerGcpToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function mwsWorkspacesCloudResourceContainerGcpToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        project_id: cdktf.stringToTerraform(struct.projectId),
    };
}
exports.mwsWorkspacesCloudResourceContainerGcpToTerraform = mwsWorkspacesCloudResourceContainerGcpToTerraform;
class MwsWorkspacesCloudResourceContainerGcpOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._projectId !== undefined) {
            hasAnyValues = true;
            internalValueResult.projectId = this._projectId;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._projectId = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._projectId = value.projectId;
        }
    }
    get projectId() {
        return this.getStringAttribute('project_id');
    }
    set projectId(value) {
        this._projectId = value;
    }
    // Temporarily expose input value. Use with caution.
    get projectIdInput() {
        return this._projectId;
    }
}
exports.MwsWorkspacesCloudResourceContainerGcpOutputReference = MwsWorkspacesCloudResourceContainerGcpOutputReference;
_a = JSII_RTTI_SYMBOL_1;
MwsWorkspacesCloudResourceContainerGcpOutputReference[_a] = { fqn: "@cdktf/provider-databricks.mwsWorkspaces.MwsWorkspacesCloudResourceContainerGcpOutputReference", version: "6.0.0" };
function mwsWorkspacesCloudResourceContainerToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        gcp: mwsWorkspacesCloudResourceContainerGcpToTerraform(struct.gcp),
    };
}
exports.mwsWorkspacesCloudResourceContainerToTerraform = mwsWorkspacesCloudResourceContainerToTerraform;
class MwsWorkspacesCloudResourceContainerOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
        // gcp - computed: false, optional: false, required: true
        this._gcp = new MwsWorkspacesCloudResourceContainerGcpOutputReference(this, "gcp");
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._gcp?.internalValue !== undefined) {
            hasAnyValues = true;
            internalValueResult.gcp = this._gcp?.internalValue;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._gcp.internalValue = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._gcp.internalValue = value.gcp;
        }
    }
    get gcp() {
        return this._gcp;
    }
    putGcp(value) {
        this._gcp.internalValue = value;
    }
    // Temporarily expose input value. Use with caution.
    get gcpInput() {
        return this._gcp.internalValue;
    }
}
exports.MwsWorkspacesCloudResourceContainerOutputReference = MwsWorkspacesCloudResourceContainerOutputReference;
_b = JSII_RTTI_SYMBOL_1;
MwsWorkspacesCloudResourceContainerOutputReference[_b] = { fqn: "@cdktf/provider-databricks.mwsWorkspaces.MwsWorkspacesCloudResourceContainerOutputReference", version: "6.0.0" };
function mwsWorkspacesExternalCustomerInfoToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        authoritative_user_email: cdktf.stringToTerraform(struct.authoritativeUserEmail),
        authoritative_user_full_name: cdktf.stringToTerraform(struct.authoritativeUserFullName),
        customer_name: cdktf.stringToTerraform(struct.customerName),
    };
}
exports.mwsWorkspacesExternalCustomerInfoToTerraform = mwsWorkspacesExternalCustomerInfoToTerraform;
class MwsWorkspacesExternalCustomerInfoOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._authoritativeUserEmail !== undefined) {
            hasAnyValues = true;
            internalValueResult.authoritativeUserEmail = this._authoritativeUserEmail;
        }
        if (this._authoritativeUserFullName !== undefined) {
            hasAnyValues = true;
            internalValueResult.authoritativeUserFullName = this._authoritativeUserFullName;
        }
        if (this._customerName !== undefined) {
            hasAnyValues = true;
            internalValueResult.customerName = this._customerName;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._authoritativeUserEmail = undefined;
            this._authoritativeUserFullName = undefined;
            this._customerName = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._authoritativeUserEmail = value.authoritativeUserEmail;
            this._authoritativeUserFullName = value.authoritativeUserFullName;
            this._customerName = value.customerName;
        }
    }
    get authoritativeUserEmail() {
        return this.getStringAttribute('authoritative_user_email');
    }
    set authoritativeUserEmail(value) {
        this._authoritativeUserEmail = value;
    }
    // Temporarily expose input value. Use with caution.
    get authoritativeUserEmailInput() {
        return this._authoritativeUserEmail;
    }
    get authoritativeUserFullName() {
        return this.getStringAttribute('authoritative_user_full_name');
    }
    set authoritativeUserFullName(value) {
        this._authoritativeUserFullName = value;
    }
    // Temporarily expose input value. Use with caution.
    get authoritativeUserFullNameInput() {
        return this._authoritativeUserFullName;
    }
    get customerName() {
        return this.getStringAttribute('customer_name');
    }
    set customerName(value) {
        this._customerName = value;
    }
    // Temporarily expose input value. Use with caution.
    get customerNameInput() {
        return this._customerName;
    }
}
exports.MwsWorkspacesExternalCustomerInfoOutputReference = MwsWorkspacesExternalCustomerInfoOutputReference;
_c = JSII_RTTI_SYMBOL_1;
MwsWorkspacesExternalCustomerInfoOutputReference[_c] = { fqn: "@cdktf/provider-databricks.mwsWorkspaces.MwsWorkspacesExternalCustomerInfoOutputReference", version: "6.0.0" };
function mwsWorkspacesGcpManagedNetworkConfigToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        gke_cluster_pod_ip_range: cdktf.stringToTerraform(struct.gkeClusterPodIpRange),
        gke_cluster_service_ip_range: cdktf.stringToTerraform(struct.gkeClusterServiceIpRange),
        subnet_cidr: cdktf.stringToTerraform(struct.subnetCidr),
    };
}
exports.mwsWorkspacesGcpManagedNetworkConfigToTerraform = mwsWorkspacesGcpManagedNetworkConfigToTerraform;
class MwsWorkspacesGcpManagedNetworkConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._gkeClusterPodIpRange !== undefined) {
            hasAnyValues = true;
            internalValueResult.gkeClusterPodIpRange = this._gkeClusterPodIpRange;
        }
        if (this._gkeClusterServiceIpRange !== undefined) {
            hasAnyValues = true;
            internalValueResult.gkeClusterServiceIpRange = this._gkeClusterServiceIpRange;
        }
        if (this._subnetCidr !== undefined) {
            hasAnyValues = true;
            internalValueResult.subnetCidr = this._subnetCidr;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._gkeClusterPodIpRange = undefined;
            this._gkeClusterServiceIpRange = undefined;
            this._subnetCidr = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._gkeClusterPodIpRange = value.gkeClusterPodIpRange;
            this._gkeClusterServiceIpRange = value.gkeClusterServiceIpRange;
            this._subnetCidr = value.subnetCidr;
        }
    }
    get gkeClusterPodIpRange() {
        return this.getStringAttribute('gke_cluster_pod_ip_range');
    }
    set gkeClusterPodIpRange(value) {
        this._gkeClusterPodIpRange = value;
    }
    // Temporarily expose input value. Use with caution.
    get gkeClusterPodIpRangeInput() {
        return this._gkeClusterPodIpRange;
    }
    get gkeClusterServiceIpRange() {
        return this.getStringAttribute('gke_cluster_service_ip_range');
    }
    set gkeClusterServiceIpRange(value) {
        this._gkeClusterServiceIpRange = value;
    }
    // Temporarily expose input value. Use with caution.
    get gkeClusterServiceIpRangeInput() {
        return this._gkeClusterServiceIpRange;
    }
    get subnetCidr() {
        return this.getStringAttribute('subnet_cidr');
    }
    set subnetCidr(value) {
        this._subnetCidr = value;
    }
    // Temporarily expose input value. Use with caution.
    get subnetCidrInput() {
        return this._subnetCidr;
    }
}
exports.MwsWorkspacesGcpManagedNetworkConfigOutputReference = MwsWorkspacesGcpManagedNetworkConfigOutputReference;
_d = JSII_RTTI_SYMBOL_1;
MwsWorkspacesGcpManagedNetworkConfigOutputReference[_d] = { fqn: "@cdktf/provider-databricks.mwsWorkspaces.MwsWorkspacesGcpManagedNetworkConfigOutputReference", version: "6.0.0" };
function mwsWorkspacesGkeConfigToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        connectivity_type: cdktf.stringToTerraform(struct.connectivityType),
        master_ip_range: cdktf.stringToTerraform(struct.masterIpRange),
    };
}
exports.mwsWorkspacesGkeConfigToTerraform = mwsWorkspacesGkeConfigToTerraform;
class MwsWorkspacesGkeConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._connectivityType !== undefined) {
            hasAnyValues = true;
            internalValueResult.connectivityType = this._connectivityType;
        }
        if (this._masterIpRange !== undefined) {
            hasAnyValues = true;
            internalValueResult.masterIpRange = this._masterIpRange;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._connectivityType = undefined;
            this._masterIpRange = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._connectivityType = value.connectivityType;
            this._masterIpRange = value.masterIpRange;
        }
    }
    get connectivityType() {
        return this.getStringAttribute('connectivity_type');
    }
    set connectivityType(value) {
        this._connectivityType = value;
    }
    // Temporarily expose input value. Use with caution.
    get connectivityTypeInput() {
        return this._connectivityType;
    }
    get masterIpRange() {
        return this.getStringAttribute('master_ip_range');
    }
    set masterIpRange(value) {
        this._masterIpRange = value;
    }
    // Temporarily expose input value. Use with caution.
    get masterIpRangeInput() {
        return this._masterIpRange;
    }
}
exports.MwsWorkspacesGkeConfigOutputReference = MwsWorkspacesGkeConfigOutputReference;
_e = JSII_RTTI_SYMBOL_1;
MwsWorkspacesGkeConfigOutputReference[_e] = { fqn: "@cdktf/provider-databricks.mwsWorkspaces.MwsWorkspacesGkeConfigOutputReference", version: "6.0.0" };
function mwsWorkspacesTimeoutsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        create: cdktf.stringToTerraform(struct.create),
        read: cdktf.stringToTerraform(struct.read),
        update: cdktf.stringToTerraform(struct.update),
    };
}
exports.mwsWorkspacesTimeoutsToTerraform = mwsWorkspacesTimeoutsToTerraform;
class MwsWorkspacesTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        if (this.resolvableValue) {
            return this.resolvableValue;
        }
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._create !== undefined) {
            hasAnyValues = true;
            internalValueResult.create = this._create;
        }
        if (this._read !== undefined) {
            hasAnyValues = true;
            internalValueResult.read = this._read;
        }
        if (this._update !== undefined) {
            hasAnyValues = true;
            internalValueResult.update = this._update;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this.resolvableValue = undefined;
            this._create = undefined;
            this._read = undefined;
            this._update = undefined;
        }
        else if (cdktf.Tokenization.isResolvable(value)) {
            this.isEmptyObject = false;
            this.resolvableValue = value;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this.resolvableValue = undefined;
            this._create = value.create;
            this._read = value.read;
            this._update = value.update;
        }
    }
    get create() {
        return this.getStringAttribute('create');
    }
    set create(value) {
        this._create = value;
    }
    resetCreate() {
        this._create = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get createInput() {
        return this._create;
    }
    get read() {
        return this.getStringAttribute('read');
    }
    set read(value) {
        this._read = value;
    }
    resetRead() {
        this._read = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get readInput() {
        return this._read;
    }
    get update() {
        return this.getStringAttribute('update');
    }
    set update(value) {
        this._update = value;
    }
    resetUpdate() {
        this._update = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get updateInput() {
        return this._update;
    }
}
exports.MwsWorkspacesTimeoutsOutputReference = MwsWorkspacesTimeoutsOutputReference;
_f = JSII_RTTI_SYMBOL_1;
MwsWorkspacesTimeoutsOutputReference[_f] = { fqn: "@cdktf/provider-databricks.mwsWorkspaces.MwsWorkspacesTimeoutsOutputReference", version: "6.0.0" };
function mwsWorkspacesTokenToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        comment: cdktf.stringToTerraform(struct.comment),
        lifetime_seconds: cdktf.numberToTerraform(struct.lifetimeSeconds),
        token_id: cdktf.stringToTerraform(struct.tokenId),
        token_value: cdktf.stringToTerraform(struct.tokenValue),
    };
}
exports.mwsWorkspacesTokenToTerraform = mwsWorkspacesTokenToTerraform;
class MwsWorkspacesTokenOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._comment !== undefined) {
            hasAnyValues = true;
            internalValueResult.comment = this._comment;
        }
        if (this._lifetimeSeconds !== undefined) {
            hasAnyValues = true;
            internalValueResult.lifetimeSeconds = this._lifetimeSeconds;
        }
        if (this._tokenId !== undefined) {
            hasAnyValues = true;
            internalValueResult.tokenId = this._tokenId;
        }
        if (this._tokenValue !== undefined) {
            hasAnyValues = true;
            internalValueResult.tokenValue = this._tokenValue;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._comment = undefined;
            this._lifetimeSeconds = undefined;
            this._tokenId = undefined;
            this._tokenValue = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._comment = value.comment;
            this._lifetimeSeconds = value.lifetimeSeconds;
            this._tokenId = value.tokenId;
            this._tokenValue = value.tokenValue;
        }
    }
    get comment() {
        return this.getStringAttribute('comment');
    }
    set comment(value) {
        this._comment = value;
    }
    resetComment() {
        this._comment = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get commentInput() {
        return this._comment;
    }
    get lifetimeSeconds() {
        return this.getNumberAttribute('lifetime_seconds');
    }
    set lifetimeSeconds(value) {
        this._lifetimeSeconds = value;
    }
    resetLifetimeSeconds() {
        this._lifetimeSeconds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get lifetimeSecondsInput() {
        return this._lifetimeSeconds;
    }
    get tokenId() {
        return this.getStringAttribute('token_id');
    }
    set tokenId(value) {
        this._tokenId = value;
    }
    resetTokenId() {
        this._tokenId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenIdInput() {
        return this._tokenId;
    }
    get tokenValue() {
        return this.getStringAttribute('token_value');
    }
    set tokenValue(value) {
        this._tokenValue = value;
    }
    resetTokenValue() {
        this._tokenValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenValueInput() {
        return this._tokenValue;
    }
}
exports.MwsWorkspacesTokenOutputReference = MwsWorkspacesTokenOutputReference;
_g = JSII_RTTI_SYMBOL_1;
MwsWorkspacesTokenOutputReference[_g] = { fqn: "@cdktf/provider-databricks.mwsWorkspaces.MwsWorkspacesTokenOutputReference", version: "6.0.0" };
/**
* Represents a {@link https://www.terraform.io/docs/providers/databricks/r/mws_workspaces databricks_mws_workspaces}
*/
class MwsWorkspaces extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/databricks/r/mws_workspaces databricks_mws_workspaces} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MwsWorkspacesConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'databricks_mws_workspaces',
            terraformGeneratorMetadata: {
                providerName: 'databricks',
                providerVersion: '1.14.3',
                providerVersionConstraint: '~> 1.0'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        // cloud_resource_container - computed: false, optional: true, required: false
        this._cloudResourceContainer = new MwsWorkspacesCloudResourceContainerOutputReference(this, "cloud_resource_container");
        // external_customer_info - computed: false, optional: true, required: false
        this._externalCustomerInfo = new MwsWorkspacesExternalCustomerInfoOutputReference(this, "external_customer_info");
        // gcp_managed_network_config - computed: false, optional: true, required: false
        this._gcpManagedNetworkConfig = new MwsWorkspacesGcpManagedNetworkConfigOutputReference(this, "gcp_managed_network_config");
        // gke_config - computed: false, optional: true, required: false
        this._gkeConfig = new MwsWorkspacesGkeConfigOutputReference(this, "gke_config");
        // timeouts - computed: false, optional: true, required: false
        this._timeouts = new MwsWorkspacesTimeoutsOutputReference(this, "timeouts");
        // token - computed: false, optional: true, required: false
        this._token = new MwsWorkspacesTokenOutputReference(this, "token");
        this._accountId = config.accountId;
        this._awsRegion = config.awsRegion;
        this._cloud = config.cloud;
        this._creationTime = config.creationTime;
        this._credentialsId = config.credentialsId;
        this._customerManagedKeyId = config.customerManagedKeyId;
        this._deploymentName = config.deploymentName;
        this._id = config.id;
        this._isNoPublicIpEnabled = config.isNoPublicIpEnabled;
        this._location = config.location;
        this._managedServicesCustomerManagedKeyId = config.managedServicesCustomerManagedKeyId;
        this._networkId = config.networkId;
        this._pricingTier = config.pricingTier;
        this._privateAccessSettingsId = config.privateAccessSettingsId;
        this._storageConfigurationId = config.storageConfigurationId;
        this._storageCustomerManagedKeyId = config.storageCustomerManagedKeyId;
        this._workspaceId = config.workspaceId;
        this._workspaceName = config.workspaceName;
        this._workspaceStatus = config.workspaceStatus;
        this._workspaceStatusMessage = config.workspaceStatusMessage;
        this._workspaceUrl = config.workspaceUrl;
        this._cloudResourceContainer.internalValue = config.cloudResourceContainer;
        this._externalCustomerInfo.internalValue = config.externalCustomerInfo;
        this._gcpManagedNetworkConfig.internalValue = config.gcpManagedNetworkConfig;
        this._gkeConfig.internalValue = config.gkeConfig;
        this._timeouts.internalValue = config.timeouts;
        this._token.internalValue = config.token;
    }
    get accountId() {
        return this.getStringAttribute('account_id');
    }
    set accountId(value) {
        this._accountId = value;
    }
    // Temporarily expose input value. Use with caution.
    get accountIdInput() {
        return this._accountId;
    }
    get awsRegion() {
        return this.getStringAttribute('aws_region');
    }
    set awsRegion(value) {
        this._awsRegion = value;
    }
    resetAwsRegion() {
        this._awsRegion = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get awsRegionInput() {
        return this._awsRegion;
    }
    get cloud() {
        return this.getStringAttribute('cloud');
    }
    set cloud(value) {
        this._cloud = value;
    }
    resetCloud() {
        this._cloud = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cloudInput() {
        return this._cloud;
    }
    get creationTime() {
        return this.getNumberAttribute('creation_time');
    }
    set creationTime(value) {
        this._creationTime = value;
    }
    resetCreationTime() {
        this._creationTime = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get creationTimeInput() {
        return this._creationTime;
    }
    get credentialsId() {
        return this.getStringAttribute('credentials_id');
    }
    set credentialsId(value) {
        this._credentialsId = value;
    }
    resetCredentialsId() {
        this._credentialsId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get credentialsIdInput() {
        return this._credentialsId;
    }
    get customerManagedKeyId() {
        return this.getStringAttribute('customer_managed_key_id');
    }
    set customerManagedKeyId(value) {
        this._customerManagedKeyId = value;
    }
    resetCustomerManagedKeyId() {
        this._customerManagedKeyId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get customerManagedKeyIdInput() {
        return this._customerManagedKeyId;
    }
    get deploymentName() {
        return this.getStringAttribute('deployment_name');
    }
    set deploymentName(value) {
        this._deploymentName = value;
    }
    resetDeploymentName() {
        this._deploymentName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get deploymentNameInput() {
        return this._deploymentName;
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get isNoPublicIpEnabled() {
        return this.getBooleanAttribute('is_no_public_ip_enabled');
    }
    set isNoPublicIpEnabled(value) {
        this._isNoPublicIpEnabled = value;
    }
    resetIsNoPublicIpEnabled() {
        this._isNoPublicIpEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get isNoPublicIpEnabledInput() {
        return this._isNoPublicIpEnabled;
    }
    get location() {
        return this.getStringAttribute('location');
    }
    set location(value) {
        this._location = value;
    }
    resetLocation() {
        this._location = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get locationInput() {
        return this._location;
    }
    get managedServicesCustomerManagedKeyId() {
        return this.getStringAttribute('managed_services_customer_managed_key_id');
    }
    set managedServicesCustomerManagedKeyId(value) {
        this._managedServicesCustomerManagedKeyId = value;
    }
    resetManagedServicesCustomerManagedKeyId() {
        this._managedServicesCustomerManagedKeyId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get managedServicesCustomerManagedKeyIdInput() {
        return this._managedServicesCustomerManagedKeyId;
    }
    get networkId() {
        return this.getStringAttribute('network_id');
    }
    set networkId(value) {
        this._networkId = value;
    }
    resetNetworkId() {
        this._networkId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get networkIdInput() {
        return this._networkId;
    }
    get pricingTier() {
        return this.getStringAttribute('pricing_tier');
    }
    set pricingTier(value) {
        this._pricingTier = value;
    }
    resetPricingTier() {
        this._pricingTier = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get pricingTierInput() {
        return this._pricingTier;
    }
    get privateAccessSettingsId() {
        return this.getStringAttribute('private_access_settings_id');
    }
    set privateAccessSettingsId(value) {
        this._privateAccessSettingsId = value;
    }
    resetPrivateAccessSettingsId() {
        this._privateAccessSettingsId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get privateAccessSettingsIdInput() {
        return this._privateAccessSettingsId;
    }
    get storageConfigurationId() {
        return this.getStringAttribute('storage_configuration_id');
    }
    set storageConfigurationId(value) {
        this._storageConfigurationId = value;
    }
    resetStorageConfigurationId() {
        this._storageConfigurationId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get storageConfigurationIdInput() {
        return this._storageConfigurationId;
    }
    get storageCustomerManagedKeyId() {
        return this.getStringAttribute('storage_customer_managed_key_id');
    }
    set storageCustomerManagedKeyId(value) {
        this._storageCustomerManagedKeyId = value;
    }
    resetStorageCustomerManagedKeyId() {
        this._storageCustomerManagedKeyId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get storageCustomerManagedKeyIdInput() {
        return this._storageCustomerManagedKeyId;
    }
    get workspaceId() {
        return this.getNumberAttribute('workspace_id');
    }
    set workspaceId(value) {
        this._workspaceId = value;
    }
    resetWorkspaceId() {
        this._workspaceId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get workspaceIdInput() {
        return this._workspaceId;
    }
    get workspaceName() {
        return this.getStringAttribute('workspace_name');
    }
    set workspaceName(value) {
        this._workspaceName = value;
    }
    // Temporarily expose input value. Use with caution.
    get workspaceNameInput() {
        return this._workspaceName;
    }
    get workspaceStatus() {
        return this.getStringAttribute('workspace_status');
    }
    set workspaceStatus(value) {
        this._workspaceStatus = value;
    }
    resetWorkspaceStatus() {
        this._workspaceStatus = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get workspaceStatusInput() {
        return this._workspaceStatus;
    }
    get workspaceStatusMessage() {
        return this.getStringAttribute('workspace_status_message');
    }
    set workspaceStatusMessage(value) {
        this._workspaceStatusMessage = value;
    }
    resetWorkspaceStatusMessage() {
        this._workspaceStatusMessage = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get workspaceStatusMessageInput() {
        return this._workspaceStatusMessage;
    }
    get workspaceUrl() {
        return this.getStringAttribute('workspace_url');
    }
    set workspaceUrl(value) {
        this._workspaceUrl = value;
    }
    resetWorkspaceUrl() {
        this._workspaceUrl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get workspaceUrlInput() {
        return this._workspaceUrl;
    }
    get cloudResourceContainer() {
        return this._cloudResourceContainer;
    }
    putCloudResourceContainer(value) {
        this._cloudResourceContainer.internalValue = value;
    }
    resetCloudResourceContainer() {
        this._cloudResourceContainer.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cloudResourceContainerInput() {
        return this._cloudResourceContainer.internalValue;
    }
    get externalCustomerInfo() {
        return this._externalCustomerInfo;
    }
    putExternalCustomerInfo(value) {
        this._externalCustomerInfo.internalValue = value;
    }
    resetExternalCustomerInfo() {
        this._externalCustomerInfo.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get externalCustomerInfoInput() {
        return this._externalCustomerInfo.internalValue;
    }
    get gcpManagedNetworkConfig() {
        return this._gcpManagedNetworkConfig;
    }
    putGcpManagedNetworkConfig(value) {
        this._gcpManagedNetworkConfig.internalValue = value;
    }
    resetGcpManagedNetworkConfig() {
        this._gcpManagedNetworkConfig.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get gcpManagedNetworkConfigInput() {
        return this._gcpManagedNetworkConfig.internalValue;
    }
    get gkeConfig() {
        return this._gkeConfig;
    }
    putGkeConfig(value) {
        this._gkeConfig.internalValue = value;
    }
    resetGkeConfig() {
        this._gkeConfig.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get gkeConfigInput() {
        return this._gkeConfig.internalValue;
    }
    get timeouts() {
        return this._timeouts;
    }
    putTimeouts(value) {
        this._timeouts.internalValue = value;
    }
    resetTimeouts() {
        this._timeouts.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get timeoutsInput() {
        return this._timeouts.internalValue;
    }
    get token() {
        return this._token;
    }
    putToken(value) {
        this._token.internalValue = value;
    }
    resetToken() {
        this._token.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenInput() {
        return this._token.internalValue;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            account_id: cdktf.stringToTerraform(this._accountId),
            aws_region: cdktf.stringToTerraform(this._awsRegion),
            cloud: cdktf.stringToTerraform(this._cloud),
            creation_time: cdktf.numberToTerraform(this._creationTime),
            credentials_id: cdktf.stringToTerraform(this._credentialsId),
            customer_managed_key_id: cdktf.stringToTerraform(this._customerManagedKeyId),
            deployment_name: cdktf.stringToTerraform(this._deploymentName),
            id: cdktf.stringToTerraform(this._id),
            is_no_public_ip_enabled: cdktf.booleanToTerraform(this._isNoPublicIpEnabled),
            location: cdktf.stringToTerraform(this._location),
            managed_services_customer_managed_key_id: cdktf.stringToTerraform(this._managedServicesCustomerManagedKeyId),
            network_id: cdktf.stringToTerraform(this._networkId),
            pricing_tier: cdktf.stringToTerraform(this._pricingTier),
            private_access_settings_id: cdktf.stringToTerraform(this._privateAccessSettingsId),
            storage_configuration_id: cdktf.stringToTerraform(this._storageConfigurationId),
            storage_customer_managed_key_id: cdktf.stringToTerraform(this._storageCustomerManagedKeyId),
            workspace_id: cdktf.numberToTerraform(this._workspaceId),
            workspace_name: cdktf.stringToTerraform(this._workspaceName),
            workspace_status: cdktf.stringToTerraform(this._workspaceStatus),
            workspace_status_message: cdktf.stringToTerraform(this._workspaceStatusMessage),
            workspace_url: cdktf.stringToTerraform(this._workspaceUrl),
            cloud_resource_container: mwsWorkspacesCloudResourceContainerToTerraform(this._cloudResourceContainer.internalValue),
            external_customer_info: mwsWorkspacesExternalCustomerInfoToTerraform(this._externalCustomerInfo.internalValue),
            gcp_managed_network_config: mwsWorkspacesGcpManagedNetworkConfigToTerraform(this._gcpManagedNetworkConfig.internalValue),
            gke_config: mwsWorkspacesGkeConfigToTerraform(this._gkeConfig.internalValue),
            timeouts: mwsWorkspacesTimeoutsToTerraform(this._timeouts.internalValue),
            token: mwsWorkspacesTokenToTerraform(this._token.internalValue),
        };
    }
}
exports.MwsWorkspaces = MwsWorkspaces;
_h = JSII_RTTI_SYMBOL_1;
MwsWorkspaces[_h] = { fqn: "@cdktf/provider-databricks.mwsWorkspaces.MwsWorkspaces", version: "6.0.0" };
// =================
// STATIC PROPERTIES
// =================
MwsWorkspaces.tfResourceType = "databricks_mws_workspaces";
//# sourceMappingURL=data:application/json;base64,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