import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface OboTokenConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/obo_token#application_id OboToken#application_id}
    */
    readonly applicationId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/obo_token#comment OboToken#comment}
    */
    readonly comment?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/obo_token#id OboToken#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/obo_token#lifetime_seconds OboToken#lifetime_seconds}
    */
    readonly lifetimeSeconds?: number;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/databricks/r/obo_token databricks_obo_token}
*/
export declare class OboToken extends cdktf.TerraformResource {
    static readonly tfResourceType = "databricks_obo_token";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/databricks/r/obo_token databricks_obo_token} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options OboTokenConfig
    */
    constructor(scope: Construct, id: string, config: OboTokenConfig);
    private _applicationId?;
    get applicationId(): string;
    set applicationId(value: string);
    get applicationIdInput(): string | undefined;
    private _comment?;
    get comment(): string;
    set comment(value: string);
    resetComment(): void;
    get commentInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _lifetimeSeconds?;
    get lifetimeSeconds(): number;
    set lifetimeSeconds(value: number);
    resetLifetimeSeconds(): void;
    get lifetimeSecondsInput(): number | undefined;
    get tokenValue(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
