import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface PermissionsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/permissions#authorization Permissions#authorization}
    */
    readonly authorization?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/permissions#cluster_id Permissions#cluster_id}
    */
    readonly clusterId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/permissions#cluster_policy_id Permissions#cluster_policy_id}
    */
    readonly clusterPolicyId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/permissions#directory_id Permissions#directory_id}
    */
    readonly directoryId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/permissions#directory_path Permissions#directory_path}
    */
    readonly directoryPath?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/permissions#experiment_id Permissions#experiment_id}
    */
    readonly experimentId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/permissions#id Permissions#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/permissions#instance_pool_id Permissions#instance_pool_id}
    */
    readonly instancePoolId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/permissions#job_id Permissions#job_id}
    */
    readonly jobId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/permissions#notebook_id Permissions#notebook_id}
    */
    readonly notebookId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/permissions#notebook_path Permissions#notebook_path}
    */
    readonly notebookPath?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/permissions#object_type Permissions#object_type}
    */
    readonly objectType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/permissions#pipeline_id Permissions#pipeline_id}
    */
    readonly pipelineId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/permissions#registered_model_id Permissions#registered_model_id}
    */
    readonly registeredModelId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/permissions#repo_id Permissions#repo_id}
    */
    readonly repoId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/permissions#repo_path Permissions#repo_path}
    */
    readonly repoPath?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/permissions#sql_alert_id Permissions#sql_alert_id}
    */
    readonly sqlAlertId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/permissions#sql_dashboard_id Permissions#sql_dashboard_id}
    */
    readonly sqlDashboardId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/permissions#sql_endpoint_id Permissions#sql_endpoint_id}
    */
    readonly sqlEndpointId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/permissions#sql_query_id Permissions#sql_query_id}
    */
    readonly sqlQueryId?: string;
    /**
    * access_control block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/permissions#access_control Permissions#access_control}
    */
    readonly accessControl: PermissionsAccessControl[] | cdktf.IResolvable;
}
export interface PermissionsAccessControl {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/permissions#group_name Permissions#group_name}
    */
    readonly groupName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/permissions#permission_level Permissions#permission_level}
    */
    readonly permissionLevel: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/permissions#service_principal_name Permissions#service_principal_name}
    */
    readonly servicePrincipalName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/permissions#user_name Permissions#user_name}
    */
    readonly userName?: string;
}
export declare function permissionsAccessControlToTerraform(struct?: PermissionsAccessControl | cdktf.IResolvable): any;
export declare class PermissionsAccessControlOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PermissionsAccessControl | cdktf.IResolvable | undefined;
    set internalValue(value: PermissionsAccessControl | cdktf.IResolvable | undefined);
    private _groupName?;
    get groupName(): string;
    set groupName(value: string);
    resetGroupName(): void;
    get groupNameInput(): string | undefined;
    private _permissionLevel?;
    get permissionLevel(): string;
    set permissionLevel(value: string);
    get permissionLevelInput(): string | undefined;
    private _servicePrincipalName?;
    get servicePrincipalName(): string;
    set servicePrincipalName(value: string);
    resetServicePrincipalName(): void;
    get servicePrincipalNameInput(): string | undefined;
    private _userName?;
    get userName(): string;
    set userName(value: string);
    resetUserName(): void;
    get userNameInput(): string | undefined;
}
export declare class PermissionsAccessControlList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PermissionsAccessControl[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PermissionsAccessControlOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/databricks/r/permissions databricks_permissions}
*/
export declare class Permissions extends cdktf.TerraformResource {
    static readonly tfResourceType = "databricks_permissions";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/databricks/r/permissions databricks_permissions} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options PermissionsConfig
    */
    constructor(scope: Construct, id: string, config: PermissionsConfig);
    private _authorization?;
    get authorization(): string;
    set authorization(value: string);
    resetAuthorization(): void;
    get authorizationInput(): string | undefined;
    private _clusterId?;
    get clusterId(): string;
    set clusterId(value: string);
    resetClusterId(): void;
    get clusterIdInput(): string | undefined;
    private _clusterPolicyId?;
    get clusterPolicyId(): string;
    set clusterPolicyId(value: string);
    resetClusterPolicyId(): void;
    get clusterPolicyIdInput(): string | undefined;
    private _directoryId?;
    get directoryId(): string;
    set directoryId(value: string);
    resetDirectoryId(): void;
    get directoryIdInput(): string | undefined;
    private _directoryPath?;
    get directoryPath(): string;
    set directoryPath(value: string);
    resetDirectoryPath(): void;
    get directoryPathInput(): string | undefined;
    private _experimentId?;
    get experimentId(): string;
    set experimentId(value: string);
    resetExperimentId(): void;
    get experimentIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _instancePoolId?;
    get instancePoolId(): string;
    set instancePoolId(value: string);
    resetInstancePoolId(): void;
    get instancePoolIdInput(): string | undefined;
    private _jobId?;
    get jobId(): string;
    set jobId(value: string);
    resetJobId(): void;
    get jobIdInput(): string | undefined;
    private _notebookId?;
    get notebookId(): string;
    set notebookId(value: string);
    resetNotebookId(): void;
    get notebookIdInput(): string | undefined;
    private _notebookPath?;
    get notebookPath(): string;
    set notebookPath(value: string);
    resetNotebookPath(): void;
    get notebookPathInput(): string | undefined;
    private _objectType?;
    get objectType(): string;
    set objectType(value: string);
    resetObjectType(): void;
    get objectTypeInput(): string | undefined;
    private _pipelineId?;
    get pipelineId(): string;
    set pipelineId(value: string);
    resetPipelineId(): void;
    get pipelineIdInput(): string | undefined;
    private _registeredModelId?;
    get registeredModelId(): string;
    set registeredModelId(value: string);
    resetRegisteredModelId(): void;
    get registeredModelIdInput(): string | undefined;
    private _repoId?;
    get repoId(): string;
    set repoId(value: string);
    resetRepoId(): void;
    get repoIdInput(): string | undefined;
    private _repoPath?;
    get repoPath(): string;
    set repoPath(value: string);
    resetRepoPath(): void;
    get repoPathInput(): string | undefined;
    private _sqlAlertId?;
    get sqlAlertId(): string;
    set sqlAlertId(value: string);
    resetSqlAlertId(): void;
    get sqlAlertIdInput(): string | undefined;
    private _sqlDashboardId?;
    get sqlDashboardId(): string;
    set sqlDashboardId(value: string);
    resetSqlDashboardId(): void;
    get sqlDashboardIdInput(): string | undefined;
    private _sqlEndpointId?;
    get sqlEndpointId(): string;
    set sqlEndpointId(value: string);
    resetSqlEndpointId(): void;
    get sqlEndpointIdInput(): string | undefined;
    private _sqlQueryId?;
    get sqlQueryId(): string;
    set sqlQueryId(value: string);
    resetSqlQueryId(): void;
    get sqlQueryIdInput(): string | undefined;
    private _accessControl;
    get accessControl(): PermissionsAccessControlList;
    putAccessControl(value: PermissionsAccessControl[] | cdktf.IResolvable): void;
    get accessControlInput(): cdktf.IResolvable | PermissionsAccessControl[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
