import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface PipelineConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/pipeline#allow_duplicate_names Pipeline#allow_duplicate_names}
    */
    readonly allowDuplicateNames?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/pipeline#catalog Pipeline#catalog}
    */
    readonly catalog?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/pipeline#channel Pipeline#channel}
    */
    readonly channel?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/pipeline#configuration Pipeline#configuration}
    */
    readonly configuration?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/pipeline#continuous Pipeline#continuous}
    */
    readonly continuous?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/pipeline#development Pipeline#development}
    */
    readonly development?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/pipeline#edition Pipeline#edition}
    */
    readonly edition?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/pipeline#id Pipeline#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/pipeline#name Pipeline#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/pipeline#photon Pipeline#photon}
    */
    readonly photon?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/pipeline#storage Pipeline#storage}
    */
    readonly storage?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/pipeline#target Pipeline#target}
    */
    readonly target?: string;
    /**
    * cluster block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/pipeline#cluster Pipeline#cluster}
    */
    readonly cluster?: PipelineCluster[] | cdktf.IResolvable;
    /**
    * filters block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/pipeline#filters Pipeline#filters}
    */
    readonly filters?: PipelineFilters;
    /**
    * library block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/pipeline#library Pipeline#library}
    */
    readonly library?: PipelineLibrary[] | cdktf.IResolvable;
    /**
    * notification block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/pipeline#notification Pipeline#notification}
    */
    readonly notification?: PipelineNotification[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/pipeline#timeouts Pipeline#timeouts}
    */
    readonly timeouts?: PipelineTimeouts;
}
export interface PipelineClusterAutoscale {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/pipeline#max_workers Pipeline#max_workers}
    */
    readonly maxWorkers?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/pipeline#min_workers Pipeline#min_workers}
    */
    readonly minWorkers?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/pipeline#mode Pipeline#mode}
    */
    readonly mode?: string;
}
export declare function pipelineClusterAutoscaleToTerraform(struct?: PipelineClusterAutoscaleOutputReference | PipelineClusterAutoscale): any;
export declare class PipelineClusterAutoscaleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PipelineClusterAutoscale | undefined;
    set internalValue(value: PipelineClusterAutoscale | undefined);
    private _maxWorkers?;
    get maxWorkers(): number;
    set maxWorkers(value: number);
    resetMaxWorkers(): void;
    get maxWorkersInput(): number | undefined;
    private _minWorkers?;
    get minWorkers(): number;
    set minWorkers(value: number);
    resetMinWorkers(): void;
    get minWorkersInput(): number | undefined;
    private _mode?;
    get mode(): string;
    set mode(value: string);
    resetMode(): void;
    get modeInput(): string | undefined;
}
export interface PipelineClusterAwsAttributes {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/pipeline#availability Pipeline#availability}
    */
    readonly availability?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/pipeline#ebs_volume_count Pipeline#ebs_volume_count}
    */
    readonly ebsVolumeCount?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/pipeline#ebs_volume_size Pipeline#ebs_volume_size}
    */
    readonly ebsVolumeSize?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/pipeline#ebs_volume_type Pipeline#ebs_volume_type}
    */
    readonly ebsVolumeType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/pipeline#first_on_demand Pipeline#first_on_demand}
    */
    readonly firstOnDemand?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/pipeline#instance_profile_arn Pipeline#instance_profile_arn}
    */
    readonly instanceProfileArn?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/pipeline#spot_bid_price_percent Pipeline#spot_bid_price_percent}
    */
    readonly spotBidPricePercent?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/pipeline#zone_id Pipeline#zone_id}
    */
    readonly zoneId?: string;
}
export declare function pipelineClusterAwsAttributesToTerraform(struct?: PipelineClusterAwsAttributesOutputReference | PipelineClusterAwsAttributes): any;
export declare class PipelineClusterAwsAttributesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PipelineClusterAwsAttributes | undefined;
    set internalValue(value: PipelineClusterAwsAttributes | undefined);
    private _availability?;
    get availability(): string;
    set availability(value: string);
    resetAvailability(): void;
    get availabilityInput(): string | undefined;
    private _ebsVolumeCount?;
    get ebsVolumeCount(): number;
    set ebsVolumeCount(value: number);
    resetEbsVolumeCount(): void;
    get ebsVolumeCountInput(): number | undefined;
    private _ebsVolumeSize?;
    get ebsVolumeSize(): number;
    set ebsVolumeSize(value: number);
    resetEbsVolumeSize(): void;
    get ebsVolumeSizeInput(): number | undefined;
    private _ebsVolumeType?;
    get ebsVolumeType(): string;
    set ebsVolumeType(value: string);
    resetEbsVolumeType(): void;
    get ebsVolumeTypeInput(): string | undefined;
    private _firstOnDemand?;
    get firstOnDemand(): number;
    set firstOnDemand(value: number);
    resetFirstOnDemand(): void;
    get firstOnDemandInput(): number | undefined;
    private _instanceProfileArn?;
    get instanceProfileArn(): string;
    set instanceProfileArn(value: string);
    resetInstanceProfileArn(): void;
    get instanceProfileArnInput(): string | undefined;
    private _spotBidPricePercent?;
    get spotBidPricePercent(): number;
    set spotBidPricePercent(value: number);
    resetSpotBidPricePercent(): void;
    get spotBidPricePercentInput(): number | undefined;
    private _zoneId?;
    get zoneId(): string;
    set zoneId(value: string);
    resetZoneId(): void;
    get zoneIdInput(): string | undefined;
}
export interface PipelineClusterAzureAttributes {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/pipeline#availability Pipeline#availability}
    */
    readonly availability?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/pipeline#first_on_demand Pipeline#first_on_demand}
    */
    readonly firstOnDemand?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/pipeline#spot_bid_max_price Pipeline#spot_bid_max_price}
    */
    readonly spotBidMaxPrice?: number;
}
export declare function pipelineClusterAzureAttributesToTerraform(struct?: PipelineClusterAzureAttributesOutputReference | PipelineClusterAzureAttributes): any;
export declare class PipelineClusterAzureAttributesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PipelineClusterAzureAttributes | undefined;
    set internalValue(value: PipelineClusterAzureAttributes | undefined);
    private _availability?;
    get availability(): string;
    set availability(value: string);
    resetAvailability(): void;
    get availabilityInput(): string | undefined;
    private _firstOnDemand?;
    get firstOnDemand(): number;
    set firstOnDemand(value: number);
    resetFirstOnDemand(): void;
    get firstOnDemandInput(): number | undefined;
    private _spotBidMaxPrice?;
    get spotBidMaxPrice(): number;
    set spotBidMaxPrice(value: number);
    resetSpotBidMaxPrice(): void;
    get spotBidMaxPriceInput(): number | undefined;
}
export interface PipelineClusterClusterLogConfDbfs {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/pipeline#destination Pipeline#destination}
    */
    readonly destination: string;
}
export declare function pipelineClusterClusterLogConfDbfsToTerraform(struct?: PipelineClusterClusterLogConfDbfsOutputReference | PipelineClusterClusterLogConfDbfs): any;
export declare class PipelineClusterClusterLogConfDbfsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PipelineClusterClusterLogConfDbfs | undefined;
    set internalValue(value: PipelineClusterClusterLogConfDbfs | undefined);
    private _destination?;
    get destination(): string;
    set destination(value: string);
    get destinationInput(): string | undefined;
}
export interface PipelineClusterClusterLogConfS3 {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/pipeline#canned_acl Pipeline#canned_acl}
    */
    readonly cannedAcl?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/pipeline#destination Pipeline#destination}
    */
    readonly destination: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/pipeline#enable_encryption Pipeline#enable_encryption}
    */
    readonly enableEncryption?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/pipeline#encryption_type Pipeline#encryption_type}
    */
    readonly encryptionType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/pipeline#endpoint Pipeline#endpoint}
    */
    readonly endpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/pipeline#kms_key Pipeline#kms_key}
    */
    readonly kmsKey?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/pipeline#region Pipeline#region}
    */
    readonly region?: string;
}
export declare function pipelineClusterClusterLogConfS3ToTerraform(struct?: PipelineClusterClusterLogConfS3OutputReference | PipelineClusterClusterLogConfS3): any;
export declare class PipelineClusterClusterLogConfS3OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PipelineClusterClusterLogConfS3 | undefined;
    set internalValue(value: PipelineClusterClusterLogConfS3 | undefined);
    private _cannedAcl?;
    get cannedAcl(): string;
    set cannedAcl(value: string);
    resetCannedAcl(): void;
    get cannedAclInput(): string | undefined;
    private _destination?;
    get destination(): string;
    set destination(value: string);
    get destinationInput(): string | undefined;
    private _enableEncryption?;
    get enableEncryption(): boolean | cdktf.IResolvable;
    set enableEncryption(value: boolean | cdktf.IResolvable);
    resetEnableEncryption(): void;
    get enableEncryptionInput(): boolean | cdktf.IResolvable | undefined;
    private _encryptionType?;
    get encryptionType(): string;
    set encryptionType(value: string);
    resetEncryptionType(): void;
    get encryptionTypeInput(): string | undefined;
    private _endpoint?;
    get endpoint(): string;
    set endpoint(value: string);
    resetEndpoint(): void;
    get endpointInput(): string | undefined;
    private _kmsKey?;
    get kmsKey(): string;
    set kmsKey(value: string);
    resetKmsKey(): void;
    get kmsKeyInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
}
export interface PipelineClusterClusterLogConf {
    /**
    * dbfs block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/pipeline#dbfs Pipeline#dbfs}
    */
    readonly dbfs?: PipelineClusterClusterLogConfDbfs;
    /**
    * s3 block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/pipeline#s3 Pipeline#s3}
    */
    readonly s3?: PipelineClusterClusterLogConfS3;
}
export declare function pipelineClusterClusterLogConfToTerraform(struct?: PipelineClusterClusterLogConfOutputReference | PipelineClusterClusterLogConf): any;
export declare class PipelineClusterClusterLogConfOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PipelineClusterClusterLogConf | undefined;
    set internalValue(value: PipelineClusterClusterLogConf | undefined);
    private _dbfs;
    get dbfs(): PipelineClusterClusterLogConfDbfsOutputReference;
    putDbfs(value: PipelineClusterClusterLogConfDbfs): void;
    resetDbfs(): void;
    get dbfsInput(): PipelineClusterClusterLogConfDbfs | undefined;
    private _s3;
    get s3(): PipelineClusterClusterLogConfS3OutputReference;
    putS3(value: PipelineClusterClusterLogConfS3): void;
    resetS3(): void;
    get s3Input(): PipelineClusterClusterLogConfS3 | undefined;
}
export interface PipelineClusterGcpAttributes {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/pipeline#availability Pipeline#availability}
    */
    readonly availability?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/pipeline#google_service_account Pipeline#google_service_account}
    */
    readonly googleServiceAccount?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/pipeline#zone_id Pipeline#zone_id}
    */
    readonly zoneId?: string;
}
export declare function pipelineClusterGcpAttributesToTerraform(struct?: PipelineClusterGcpAttributesOutputReference | PipelineClusterGcpAttributes): any;
export declare class PipelineClusterGcpAttributesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PipelineClusterGcpAttributes | undefined;
    set internalValue(value: PipelineClusterGcpAttributes | undefined);
    private _availability?;
    get availability(): string;
    set availability(value: string);
    resetAvailability(): void;
    get availabilityInput(): string | undefined;
    private _googleServiceAccount?;
    get googleServiceAccount(): string;
    set googleServiceAccount(value: string);
    resetGoogleServiceAccount(): void;
    get googleServiceAccountInput(): string | undefined;
    private _zoneId?;
    get zoneId(): string;
    set zoneId(value: string);
    resetZoneId(): void;
    get zoneIdInput(): string | undefined;
}
export interface PipelineClusterInitScriptsAbfss {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/pipeline#destination Pipeline#destination}
    */
    readonly destination?: string;
}
export declare function pipelineClusterInitScriptsAbfssToTerraform(struct?: PipelineClusterInitScriptsAbfssOutputReference | PipelineClusterInitScriptsAbfss): any;
export declare class PipelineClusterInitScriptsAbfssOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PipelineClusterInitScriptsAbfss | undefined;
    set internalValue(value: PipelineClusterInitScriptsAbfss | undefined);
    private _destination?;
    get destination(): string;
    set destination(value: string);
    resetDestination(): void;
    get destinationInput(): string | undefined;
}
export interface PipelineClusterInitScriptsDbfs {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/pipeline#destination Pipeline#destination}
    */
    readonly destination: string;
}
export declare function pipelineClusterInitScriptsDbfsToTerraform(struct?: PipelineClusterInitScriptsDbfsOutputReference | PipelineClusterInitScriptsDbfs): any;
export declare class PipelineClusterInitScriptsDbfsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PipelineClusterInitScriptsDbfs | undefined;
    set internalValue(value: PipelineClusterInitScriptsDbfs | undefined);
    private _destination?;
    get destination(): string;
    set destination(value: string);
    get destinationInput(): string | undefined;
}
export interface PipelineClusterInitScriptsFile {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/pipeline#destination Pipeline#destination}
    */
    readonly destination?: string;
}
export declare function pipelineClusterInitScriptsFileToTerraform(struct?: PipelineClusterInitScriptsFileOutputReference | PipelineClusterInitScriptsFile): any;
export declare class PipelineClusterInitScriptsFileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PipelineClusterInitScriptsFile | undefined;
    set internalValue(value: PipelineClusterInitScriptsFile | undefined);
    private _destination?;
    get destination(): string;
    set destination(value: string);
    resetDestination(): void;
    get destinationInput(): string | undefined;
}
export interface PipelineClusterInitScriptsGcs {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/pipeline#destination Pipeline#destination}
    */
    readonly destination?: string;
}
export declare function pipelineClusterInitScriptsGcsToTerraform(struct?: PipelineClusterInitScriptsGcsOutputReference | PipelineClusterInitScriptsGcs): any;
export declare class PipelineClusterInitScriptsGcsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PipelineClusterInitScriptsGcs | undefined;
    set internalValue(value: PipelineClusterInitScriptsGcs | undefined);
    private _destination?;
    get destination(): string;
    set destination(value: string);
    resetDestination(): void;
    get destinationInput(): string | undefined;
}
export interface PipelineClusterInitScriptsS3 {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/pipeline#canned_acl Pipeline#canned_acl}
    */
    readonly cannedAcl?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/pipeline#destination Pipeline#destination}
    */
    readonly destination: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/pipeline#enable_encryption Pipeline#enable_encryption}
    */
    readonly enableEncryption?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/pipeline#encryption_type Pipeline#encryption_type}
    */
    readonly encryptionType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/pipeline#endpoint Pipeline#endpoint}
    */
    readonly endpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/pipeline#kms_key Pipeline#kms_key}
    */
    readonly kmsKey?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/pipeline#region Pipeline#region}
    */
    readonly region?: string;
}
export declare function pipelineClusterInitScriptsS3ToTerraform(struct?: PipelineClusterInitScriptsS3OutputReference | PipelineClusterInitScriptsS3): any;
export declare class PipelineClusterInitScriptsS3OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PipelineClusterInitScriptsS3 | undefined;
    set internalValue(value: PipelineClusterInitScriptsS3 | undefined);
    private _cannedAcl?;
    get cannedAcl(): string;
    set cannedAcl(value: string);
    resetCannedAcl(): void;
    get cannedAclInput(): string | undefined;
    private _destination?;
    get destination(): string;
    set destination(value: string);
    get destinationInput(): string | undefined;
    private _enableEncryption?;
    get enableEncryption(): boolean | cdktf.IResolvable;
    set enableEncryption(value: boolean | cdktf.IResolvable);
    resetEnableEncryption(): void;
    get enableEncryptionInput(): boolean | cdktf.IResolvable | undefined;
    private _encryptionType?;
    get encryptionType(): string;
    set encryptionType(value: string);
    resetEncryptionType(): void;
    get encryptionTypeInput(): string | undefined;
    private _endpoint?;
    get endpoint(): string;
    set endpoint(value: string);
    resetEndpoint(): void;
    get endpointInput(): string | undefined;
    private _kmsKey?;
    get kmsKey(): string;
    set kmsKey(value: string);
    resetKmsKey(): void;
    get kmsKeyInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
}
export interface PipelineClusterInitScripts {
    /**
    * abfss block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/pipeline#abfss Pipeline#abfss}
    */
    readonly abfss?: PipelineClusterInitScriptsAbfss;
    /**
    * dbfs block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/pipeline#dbfs Pipeline#dbfs}
    */
    readonly dbfs?: PipelineClusterInitScriptsDbfs;
    /**
    * file block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/pipeline#file Pipeline#file}
    */
    readonly file?: PipelineClusterInitScriptsFile;
    /**
    * gcs block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/pipeline#gcs Pipeline#gcs}
    */
    readonly gcs?: PipelineClusterInitScriptsGcs;
    /**
    * s3 block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/pipeline#s3 Pipeline#s3}
    */
    readonly s3?: PipelineClusterInitScriptsS3;
}
export declare function pipelineClusterInitScriptsToTerraform(struct?: PipelineClusterInitScripts | cdktf.IResolvable): any;
export declare class PipelineClusterInitScriptsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PipelineClusterInitScripts | cdktf.IResolvable | undefined;
    set internalValue(value: PipelineClusterInitScripts | cdktf.IResolvable | undefined);
    private _abfss;
    get abfss(): PipelineClusterInitScriptsAbfssOutputReference;
    putAbfss(value: PipelineClusterInitScriptsAbfss): void;
    resetAbfss(): void;
    get abfssInput(): PipelineClusterInitScriptsAbfss | undefined;
    private _dbfs;
    get dbfs(): PipelineClusterInitScriptsDbfsOutputReference;
    putDbfs(value: PipelineClusterInitScriptsDbfs): void;
    resetDbfs(): void;
    get dbfsInput(): PipelineClusterInitScriptsDbfs | undefined;
    private _file;
    get file(): PipelineClusterInitScriptsFileOutputReference;
    putFile(value: PipelineClusterInitScriptsFile): void;
    resetFile(): void;
    get fileInput(): PipelineClusterInitScriptsFile | undefined;
    private _gcs;
    get gcs(): PipelineClusterInitScriptsGcsOutputReference;
    putGcs(value: PipelineClusterInitScriptsGcs): void;
    resetGcs(): void;
    get gcsInput(): PipelineClusterInitScriptsGcs | undefined;
    private _s3;
    get s3(): PipelineClusterInitScriptsS3OutputReference;
    putS3(value: PipelineClusterInitScriptsS3): void;
    resetS3(): void;
    get s3Input(): PipelineClusterInitScriptsS3 | undefined;
}
export declare class PipelineClusterInitScriptsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PipelineClusterInitScripts[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PipelineClusterInitScriptsOutputReference;
}
export interface PipelineCluster {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/pipeline#apply_policy_default_values Pipeline#apply_policy_default_values}
    */
    readonly applyPolicyDefaultValues?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/pipeline#custom_tags Pipeline#custom_tags}
    */
    readonly customTags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/pipeline#driver_instance_pool_id Pipeline#driver_instance_pool_id}
    */
    readonly driverInstancePoolId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/pipeline#driver_node_type_id Pipeline#driver_node_type_id}
    */
    readonly driverNodeTypeId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/pipeline#enable_local_disk_encryption Pipeline#enable_local_disk_encryption}
    */
    readonly enableLocalDiskEncryption?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/pipeline#instance_pool_id Pipeline#instance_pool_id}
    */
    readonly instancePoolId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/pipeline#label Pipeline#label}
    */
    readonly label?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/pipeline#node_type_id Pipeline#node_type_id}
    */
    readonly nodeTypeId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/pipeline#num_workers Pipeline#num_workers}
    */
    readonly numWorkers?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/pipeline#policy_id Pipeline#policy_id}
    */
    readonly policyId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/pipeline#spark_conf Pipeline#spark_conf}
    */
    readonly sparkConf?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/pipeline#spark_env_vars Pipeline#spark_env_vars}
    */
    readonly sparkEnvVars?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/pipeline#ssh_public_keys Pipeline#ssh_public_keys}
    */
    readonly sshPublicKeys?: string[];
    /**
    * autoscale block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/pipeline#autoscale Pipeline#autoscale}
    */
    readonly autoscale?: PipelineClusterAutoscale;
    /**
    * aws_attributes block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/pipeline#aws_attributes Pipeline#aws_attributes}
    */
    readonly awsAttributes?: PipelineClusterAwsAttributes;
    /**
    * azure_attributes block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/pipeline#azure_attributes Pipeline#azure_attributes}
    */
    readonly azureAttributes?: PipelineClusterAzureAttributes;
    /**
    * cluster_log_conf block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/pipeline#cluster_log_conf Pipeline#cluster_log_conf}
    */
    readonly clusterLogConf?: PipelineClusterClusterLogConf;
    /**
    * gcp_attributes block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/pipeline#gcp_attributes Pipeline#gcp_attributes}
    */
    readonly gcpAttributes?: PipelineClusterGcpAttributes;
    /**
    * init_scripts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/pipeline#init_scripts Pipeline#init_scripts}
    */
    readonly initScripts?: PipelineClusterInitScripts[] | cdktf.IResolvable;
}
export declare function pipelineClusterToTerraform(struct?: PipelineCluster | cdktf.IResolvable): any;
export declare class PipelineClusterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PipelineCluster | cdktf.IResolvable | undefined;
    set internalValue(value: PipelineCluster | cdktf.IResolvable | undefined);
    private _applyPolicyDefaultValues?;
    get applyPolicyDefaultValues(): boolean | cdktf.IResolvable;
    set applyPolicyDefaultValues(value: boolean | cdktf.IResolvable);
    resetApplyPolicyDefaultValues(): void;
    get applyPolicyDefaultValuesInput(): boolean | cdktf.IResolvable | undefined;
    private _customTags?;
    get customTags(): {
        [key: string]: string;
    };
    set customTags(value: {
        [key: string]: string;
    });
    resetCustomTags(): void;
    get customTagsInput(): {
        [key: string]: string;
    } | undefined;
    private _driverInstancePoolId?;
    get driverInstancePoolId(): string;
    set driverInstancePoolId(value: string);
    resetDriverInstancePoolId(): void;
    get driverInstancePoolIdInput(): string | undefined;
    private _driverNodeTypeId?;
    get driverNodeTypeId(): string;
    set driverNodeTypeId(value: string);
    resetDriverNodeTypeId(): void;
    get driverNodeTypeIdInput(): string | undefined;
    private _enableLocalDiskEncryption?;
    get enableLocalDiskEncryption(): boolean | cdktf.IResolvable;
    set enableLocalDiskEncryption(value: boolean | cdktf.IResolvable);
    resetEnableLocalDiskEncryption(): void;
    get enableLocalDiskEncryptionInput(): boolean | cdktf.IResolvable | undefined;
    private _instancePoolId?;
    get instancePoolId(): string;
    set instancePoolId(value: string);
    resetInstancePoolId(): void;
    get instancePoolIdInput(): string | undefined;
    private _label?;
    get label(): string;
    set label(value: string);
    resetLabel(): void;
    get labelInput(): string | undefined;
    private _nodeTypeId?;
    get nodeTypeId(): string;
    set nodeTypeId(value: string);
    resetNodeTypeId(): void;
    get nodeTypeIdInput(): string | undefined;
    private _numWorkers?;
    get numWorkers(): number;
    set numWorkers(value: number);
    resetNumWorkers(): void;
    get numWorkersInput(): number | undefined;
    private _policyId?;
    get policyId(): string;
    set policyId(value: string);
    resetPolicyId(): void;
    get policyIdInput(): string | undefined;
    private _sparkConf?;
    get sparkConf(): {
        [key: string]: string;
    };
    set sparkConf(value: {
        [key: string]: string;
    });
    resetSparkConf(): void;
    get sparkConfInput(): {
        [key: string]: string;
    } | undefined;
    private _sparkEnvVars?;
    get sparkEnvVars(): {
        [key: string]: string;
    };
    set sparkEnvVars(value: {
        [key: string]: string;
    });
    resetSparkEnvVars(): void;
    get sparkEnvVarsInput(): {
        [key: string]: string;
    } | undefined;
    private _sshPublicKeys?;
    get sshPublicKeys(): string[];
    set sshPublicKeys(value: string[]);
    resetSshPublicKeys(): void;
    get sshPublicKeysInput(): string[] | undefined;
    private _autoscale;
    get autoscale(): PipelineClusterAutoscaleOutputReference;
    putAutoscale(value: PipelineClusterAutoscale): void;
    resetAutoscale(): void;
    get autoscaleInput(): PipelineClusterAutoscale | undefined;
    private _awsAttributes;
    get awsAttributes(): PipelineClusterAwsAttributesOutputReference;
    putAwsAttributes(value: PipelineClusterAwsAttributes): void;
    resetAwsAttributes(): void;
    get awsAttributesInput(): PipelineClusterAwsAttributes | undefined;
    private _azureAttributes;
    get azureAttributes(): PipelineClusterAzureAttributesOutputReference;
    putAzureAttributes(value: PipelineClusterAzureAttributes): void;
    resetAzureAttributes(): void;
    get azureAttributesInput(): PipelineClusterAzureAttributes | undefined;
    private _clusterLogConf;
    get clusterLogConf(): PipelineClusterClusterLogConfOutputReference;
    putClusterLogConf(value: PipelineClusterClusterLogConf): void;
    resetClusterLogConf(): void;
    get clusterLogConfInput(): PipelineClusterClusterLogConf | undefined;
    private _gcpAttributes;
    get gcpAttributes(): PipelineClusterGcpAttributesOutputReference;
    putGcpAttributes(value: PipelineClusterGcpAttributes): void;
    resetGcpAttributes(): void;
    get gcpAttributesInput(): PipelineClusterGcpAttributes | undefined;
    private _initScripts;
    get initScripts(): PipelineClusterInitScriptsList;
    putInitScripts(value: PipelineClusterInitScripts[] | cdktf.IResolvable): void;
    resetInitScripts(): void;
    get initScriptsInput(): cdktf.IResolvable | PipelineClusterInitScripts[] | undefined;
}
export declare class PipelineClusterList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PipelineCluster[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PipelineClusterOutputReference;
}
export interface PipelineFilters {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/pipeline#exclude Pipeline#exclude}
    */
    readonly exclude?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/pipeline#include Pipeline#include}
    */
    readonly include?: string[];
}
export declare function pipelineFiltersToTerraform(struct?: PipelineFiltersOutputReference | PipelineFilters): any;
export declare class PipelineFiltersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PipelineFilters | undefined;
    set internalValue(value: PipelineFilters | undefined);
    private _exclude?;
    get exclude(): string[];
    set exclude(value: string[]);
    resetExclude(): void;
    get excludeInput(): string[] | undefined;
    private _include?;
    get include(): string[];
    set include(value: string[]);
    resetInclude(): void;
    get includeInput(): string[] | undefined;
}
export interface PipelineLibraryFile {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/pipeline#path Pipeline#path}
    */
    readonly path: string;
}
export declare function pipelineLibraryFileToTerraform(struct?: PipelineLibraryFileOutputReference | PipelineLibraryFile): any;
export declare class PipelineLibraryFileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PipelineLibraryFile | undefined;
    set internalValue(value: PipelineLibraryFile | undefined);
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
}
export interface PipelineLibraryMaven {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/pipeline#coordinates Pipeline#coordinates}
    */
    readonly coordinates: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/pipeline#exclusions Pipeline#exclusions}
    */
    readonly exclusions?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/pipeline#repo Pipeline#repo}
    */
    readonly repo?: string;
}
export declare function pipelineLibraryMavenToTerraform(struct?: PipelineLibraryMavenOutputReference | PipelineLibraryMaven): any;
export declare class PipelineLibraryMavenOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PipelineLibraryMaven | undefined;
    set internalValue(value: PipelineLibraryMaven | undefined);
    private _coordinates?;
    get coordinates(): string;
    set coordinates(value: string);
    get coordinatesInput(): string | undefined;
    private _exclusions?;
    get exclusions(): string[];
    set exclusions(value: string[]);
    resetExclusions(): void;
    get exclusionsInput(): string[] | undefined;
    private _repo?;
    get repo(): string;
    set repo(value: string);
    resetRepo(): void;
    get repoInput(): string | undefined;
}
export interface PipelineLibraryNotebook {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/pipeline#path Pipeline#path}
    */
    readonly path: string;
}
export declare function pipelineLibraryNotebookToTerraform(struct?: PipelineLibraryNotebookOutputReference | PipelineLibraryNotebook): any;
export declare class PipelineLibraryNotebookOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PipelineLibraryNotebook | undefined;
    set internalValue(value: PipelineLibraryNotebook | undefined);
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
}
export interface PipelineLibrary {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/pipeline#jar Pipeline#jar}
    */
    readonly jar?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/pipeline#whl Pipeline#whl}
    */
    readonly whl?: string;
    /**
    * file block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/pipeline#file Pipeline#file}
    */
    readonly file?: PipelineLibraryFile;
    /**
    * maven block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/pipeline#maven Pipeline#maven}
    */
    readonly maven?: PipelineLibraryMaven;
    /**
    * notebook block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/pipeline#notebook Pipeline#notebook}
    */
    readonly notebook?: PipelineLibraryNotebook;
}
export declare function pipelineLibraryToTerraform(struct?: PipelineLibrary | cdktf.IResolvable): any;
export declare class PipelineLibraryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PipelineLibrary | cdktf.IResolvable | undefined;
    set internalValue(value: PipelineLibrary | cdktf.IResolvable | undefined);
    private _jar?;
    get jar(): string;
    set jar(value: string);
    resetJar(): void;
    get jarInput(): string | undefined;
    private _whl?;
    get whl(): string;
    set whl(value: string);
    resetWhl(): void;
    get whlInput(): string | undefined;
    private _file;
    get file(): PipelineLibraryFileOutputReference;
    putFile(value: PipelineLibraryFile): void;
    resetFile(): void;
    get fileInput(): PipelineLibraryFile | undefined;
    private _maven;
    get maven(): PipelineLibraryMavenOutputReference;
    putMaven(value: PipelineLibraryMaven): void;
    resetMaven(): void;
    get mavenInput(): PipelineLibraryMaven | undefined;
    private _notebook;
    get notebook(): PipelineLibraryNotebookOutputReference;
    putNotebook(value: PipelineLibraryNotebook): void;
    resetNotebook(): void;
    get notebookInput(): PipelineLibraryNotebook | undefined;
}
export declare class PipelineLibraryList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PipelineLibrary[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PipelineLibraryOutputReference;
}
export interface PipelineNotification {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/pipeline#alerts Pipeline#alerts}
    */
    readonly alerts: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/pipeline#email_recipients Pipeline#email_recipients}
    */
    readonly emailRecipients: string[];
}
export declare function pipelineNotificationToTerraform(struct?: PipelineNotification | cdktf.IResolvable): any;
export declare class PipelineNotificationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PipelineNotification | cdktf.IResolvable | undefined;
    set internalValue(value: PipelineNotification | cdktf.IResolvable | undefined);
    private _alerts?;
    get alerts(): string[];
    set alerts(value: string[]);
    get alertsInput(): string[] | undefined;
    private _emailRecipients?;
    get emailRecipients(): string[];
    set emailRecipients(value: string[]);
    get emailRecipientsInput(): string[] | undefined;
}
export declare class PipelineNotificationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PipelineNotification[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PipelineNotificationOutputReference;
}
export interface PipelineTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/pipeline#default Pipeline#default}
    */
    readonly default?: string;
}
export declare function pipelineTimeoutsToTerraform(struct?: PipelineTimeoutsOutputReference | PipelineTimeouts | cdktf.IResolvable): any;
export declare class PipelineTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PipelineTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: PipelineTimeouts | cdktf.IResolvable | undefined);
    private _default?;
    get default(): string;
    set default(value: string);
    resetDefault(): void;
    get defaultInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/databricks/r/pipeline databricks_pipeline}
*/
export declare class Pipeline extends cdktf.TerraformResource {
    static readonly tfResourceType = "databricks_pipeline";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/databricks/r/pipeline databricks_pipeline} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options PipelineConfig = {}
    */
    constructor(scope: Construct, id: string, config?: PipelineConfig);
    private _allowDuplicateNames?;
    get allowDuplicateNames(): boolean | cdktf.IResolvable;
    set allowDuplicateNames(value: boolean | cdktf.IResolvable);
    resetAllowDuplicateNames(): void;
    get allowDuplicateNamesInput(): boolean | cdktf.IResolvable | undefined;
    private _catalog?;
    get catalog(): string;
    set catalog(value: string);
    resetCatalog(): void;
    get catalogInput(): string | undefined;
    private _channel?;
    get channel(): string;
    set channel(value: string);
    resetChannel(): void;
    get channelInput(): string | undefined;
    private _configuration?;
    get configuration(): {
        [key: string]: string;
    };
    set configuration(value: {
        [key: string]: string;
    });
    resetConfiguration(): void;
    get configurationInput(): {
        [key: string]: string;
    } | undefined;
    private _continuous?;
    get continuous(): boolean | cdktf.IResolvable;
    set continuous(value: boolean | cdktf.IResolvable);
    resetContinuous(): void;
    get continuousInput(): boolean | cdktf.IResolvable | undefined;
    private _development?;
    get development(): boolean | cdktf.IResolvable;
    set development(value: boolean | cdktf.IResolvable);
    resetDevelopment(): void;
    get developmentInput(): boolean | cdktf.IResolvable | undefined;
    private _edition?;
    get edition(): string;
    set edition(value: string);
    resetEdition(): void;
    get editionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _photon?;
    get photon(): boolean | cdktf.IResolvable;
    set photon(value: boolean | cdktf.IResolvable);
    resetPhoton(): void;
    get photonInput(): boolean | cdktf.IResolvable | undefined;
    private _storage?;
    get storage(): string;
    set storage(value: string);
    resetStorage(): void;
    get storageInput(): string | undefined;
    private _target?;
    get target(): string;
    set target(value: string);
    resetTarget(): void;
    get targetInput(): string | undefined;
    get url(): string;
    private _cluster;
    get cluster(): PipelineClusterList;
    putCluster(value: PipelineCluster[] | cdktf.IResolvable): void;
    resetCluster(): void;
    get clusterInput(): cdktf.IResolvable | PipelineCluster[] | undefined;
    private _filters;
    get filters(): PipelineFiltersOutputReference;
    putFilters(value: PipelineFilters): void;
    resetFilters(): void;
    get filtersInput(): PipelineFilters | undefined;
    private _library;
    get library(): PipelineLibraryList;
    putLibrary(value: PipelineLibrary[] | cdktf.IResolvable): void;
    resetLibrary(): void;
    get libraryInput(): cdktf.IResolvable | PipelineLibrary[] | undefined;
    private _notification;
    get notification(): PipelineNotificationList;
    putNotification(value: PipelineNotification[] | cdktf.IResolvable): void;
    resetNotification(): void;
    get notificationInput(): cdktf.IResolvable | PipelineNotification[] | undefined;
    private _timeouts;
    get timeouts(): PipelineTimeoutsOutputReference;
    putTimeouts(value: PipelineTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | PipelineTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
