import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ProviderResourceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/provider#authentication_type ProviderResource#authentication_type}
    */
    readonly authenticationType: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/provider#comment ProviderResource#comment}
    */
    readonly comment?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/provider#id ProviderResource#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/provider#name ProviderResource#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/provider#recipient_profile_str ProviderResource#recipient_profile_str}
    */
    readonly recipientProfileStr: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/databricks/r/provider databricks_provider}
*/
export declare class ProviderResource extends cdktf.TerraformResource {
    static readonly tfResourceType = "databricks_provider";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/databricks/r/provider databricks_provider} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ProviderResourceConfig
    */
    constructor(scope: Construct, id: string, config: ProviderResourceConfig);
    private _authenticationType?;
    get authenticationType(): string;
    set authenticationType(value: string);
    get authenticationTypeInput(): string | undefined;
    private _comment?;
    get comment(): string;
    set comment(value: string);
    resetComment(): void;
    get commentInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _recipientProfileStr?;
    get recipientProfileStr(): string;
    set recipientProfileStr(value: string);
    get recipientProfileStrInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
