import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DatabricksProviderConfig {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks#account_id DatabricksProvider#account_id}
    */
    readonly accountId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks#auth_type DatabricksProvider#auth_type}
    */
    readonly authType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks#azure_client_id DatabricksProvider#azure_client_id}
    */
    readonly azureClientId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks#azure_client_secret DatabricksProvider#azure_client_secret}
    */
    readonly azureClientSecret?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks#azure_environment DatabricksProvider#azure_environment}
    */
    readonly azureEnvironment?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks#azure_login_app_id DatabricksProvider#azure_login_app_id}
    */
    readonly azureLoginAppId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks#azure_tenant_id DatabricksProvider#azure_tenant_id}
    */
    readonly azureTenantId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks#azure_use_msi DatabricksProvider#azure_use_msi}
    */
    readonly azureUseMsi?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks#azure_workspace_resource_id DatabricksProvider#azure_workspace_resource_id}
    */
    readonly azureWorkspaceResourceId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks#bricks_cli_path DatabricksProvider#bricks_cli_path}
    */
    readonly bricksCliPath?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks#client_id DatabricksProvider#client_id}
    */
    readonly clientId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks#client_secret DatabricksProvider#client_secret}
    */
    readonly clientSecret?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks#config_file DatabricksProvider#config_file}
    */
    readonly configFile?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks#debug_headers DatabricksProvider#debug_headers}
    */
    readonly debugHeaders?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks#debug_truncate_bytes DatabricksProvider#debug_truncate_bytes}
    */
    readonly debugTruncateBytes?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks#google_credentials DatabricksProvider#google_credentials}
    */
    readonly googleCredentials?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks#google_service_account DatabricksProvider#google_service_account}
    */
    readonly googleServiceAccount?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks#host DatabricksProvider#host}
    */
    readonly host?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks#http_timeout_seconds DatabricksProvider#http_timeout_seconds}
    */
    readonly httpTimeoutSeconds?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks#metadata_service_url DatabricksProvider#metadata_service_url}
    */
    readonly metadataServiceUrl?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks#password DatabricksProvider#password}
    */
    readonly password?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks#profile DatabricksProvider#profile}
    */
    readonly profile?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks#rate_limit DatabricksProvider#rate_limit}
    */
    readonly rateLimit?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks#retry_timeout_seconds DatabricksProvider#retry_timeout_seconds}
    */
    readonly retryTimeoutSeconds?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks#skip_verify DatabricksProvider#skip_verify}
    */
    readonly skipVerify?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks#token DatabricksProvider#token}
    */
    readonly token?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks#username DatabricksProvider#username}
    */
    readonly username?: string;
    /**
    * Alias name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks#alias DatabricksProvider#alias}
    */
    readonly alias?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/databricks databricks}
*/
export declare class DatabricksProvider extends cdktf.TerraformProvider {
    static readonly tfResourceType = "databricks";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/databricks databricks} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DatabricksProviderConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DatabricksProviderConfig);
    private _accountId?;
    get accountId(): string | undefined;
    set accountId(value: string | undefined);
    resetAccountId(): void;
    get accountIdInput(): string | undefined;
    private _authType?;
    get authType(): string | undefined;
    set authType(value: string | undefined);
    resetAuthType(): void;
    get authTypeInput(): string | undefined;
    private _azureClientId?;
    get azureClientId(): string | undefined;
    set azureClientId(value: string | undefined);
    resetAzureClientId(): void;
    get azureClientIdInput(): string | undefined;
    private _azureClientSecret?;
    get azureClientSecret(): string | undefined;
    set azureClientSecret(value: string | undefined);
    resetAzureClientSecret(): void;
    get azureClientSecretInput(): string | undefined;
    private _azureEnvironment?;
    get azureEnvironment(): string | undefined;
    set azureEnvironment(value: string | undefined);
    resetAzureEnvironment(): void;
    get azureEnvironmentInput(): string | undefined;
    private _azureLoginAppId?;
    get azureLoginAppId(): string | undefined;
    set azureLoginAppId(value: string | undefined);
    resetAzureLoginAppId(): void;
    get azureLoginAppIdInput(): string | undefined;
    private _azureTenantId?;
    get azureTenantId(): string | undefined;
    set azureTenantId(value: string | undefined);
    resetAzureTenantId(): void;
    get azureTenantIdInput(): string | undefined;
    private _azureUseMsi?;
    get azureUseMsi(): boolean | cdktf.IResolvable | undefined;
    set azureUseMsi(value: boolean | cdktf.IResolvable | undefined);
    resetAzureUseMsi(): void;
    get azureUseMsiInput(): boolean | cdktf.IResolvable | undefined;
    private _azureWorkspaceResourceId?;
    get azureWorkspaceResourceId(): string | undefined;
    set azureWorkspaceResourceId(value: string | undefined);
    resetAzureWorkspaceResourceId(): void;
    get azureWorkspaceResourceIdInput(): string | undefined;
    private _bricksCliPath?;
    get bricksCliPath(): string | undefined;
    set bricksCliPath(value: string | undefined);
    resetBricksCliPath(): void;
    get bricksCliPathInput(): string | undefined;
    private _clientId?;
    get clientId(): string | undefined;
    set clientId(value: string | undefined);
    resetClientId(): void;
    get clientIdInput(): string | undefined;
    private _clientSecret?;
    get clientSecret(): string | undefined;
    set clientSecret(value: string | undefined);
    resetClientSecret(): void;
    get clientSecretInput(): string | undefined;
    private _configFile?;
    get configFile(): string | undefined;
    set configFile(value: string | undefined);
    resetConfigFile(): void;
    get configFileInput(): string | undefined;
    private _debugHeaders?;
    get debugHeaders(): boolean | cdktf.IResolvable | undefined;
    set debugHeaders(value: boolean | cdktf.IResolvable | undefined);
    resetDebugHeaders(): void;
    get debugHeadersInput(): boolean | cdktf.IResolvable | undefined;
    private _debugTruncateBytes?;
    get debugTruncateBytes(): number | undefined;
    set debugTruncateBytes(value: number | undefined);
    resetDebugTruncateBytes(): void;
    get debugTruncateBytesInput(): number | undefined;
    private _googleCredentials?;
    get googleCredentials(): string | undefined;
    set googleCredentials(value: string | undefined);
    resetGoogleCredentials(): void;
    get googleCredentialsInput(): string | undefined;
    private _googleServiceAccount?;
    get googleServiceAccount(): string | undefined;
    set googleServiceAccount(value: string | undefined);
    resetGoogleServiceAccount(): void;
    get googleServiceAccountInput(): string | undefined;
    private _host?;
    get host(): string | undefined;
    set host(value: string | undefined);
    resetHost(): void;
    get hostInput(): string | undefined;
    private _httpTimeoutSeconds?;
    get httpTimeoutSeconds(): number | undefined;
    set httpTimeoutSeconds(value: number | undefined);
    resetHttpTimeoutSeconds(): void;
    get httpTimeoutSecondsInput(): number | undefined;
    private _metadataServiceUrl?;
    get metadataServiceUrl(): string | undefined;
    set metadataServiceUrl(value: string | undefined);
    resetMetadataServiceUrl(): void;
    get metadataServiceUrlInput(): string | undefined;
    private _password?;
    get password(): string | undefined;
    set password(value: string | undefined);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _profile?;
    get profile(): string | undefined;
    set profile(value: string | undefined);
    resetProfile(): void;
    get profileInput(): string | undefined;
    private _rateLimit?;
    get rateLimit(): number | undefined;
    set rateLimit(value: number | undefined);
    resetRateLimit(): void;
    get rateLimitInput(): number | undefined;
    private _retryTimeoutSeconds?;
    get retryTimeoutSeconds(): number | undefined;
    set retryTimeoutSeconds(value: number | undefined);
    resetRetryTimeoutSeconds(): void;
    get retryTimeoutSecondsInput(): number | undefined;
    private _skipVerify?;
    get skipVerify(): boolean | cdktf.IResolvable | undefined;
    set skipVerify(value: boolean | cdktf.IResolvable | undefined);
    resetSkipVerify(): void;
    get skipVerifyInput(): boolean | cdktf.IResolvable | undefined;
    private _token?;
    get token(): string | undefined;
    set token(value: string | undefined);
    resetToken(): void;
    get tokenInput(): string | undefined;
    private _username?;
    get username(): string | undefined;
    set username(value: string | undefined);
    resetUsername(): void;
    get usernameInput(): string | undefined;
    private _alias?;
    get alias(): string | undefined;
    set alias(value: string | undefined);
    resetAlias(): void;
    get aliasInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
